CREATE TABLE IF NOT EXISTS `news` (
  `id` int(11) NOT NULL COMMENT 'Уникальный id',
  `date_create` int(10) DEFAULT '0' COMMENT 'Дата добавления',
  `date_public` int(10) DEFAULT '0' COMMENT 'Дата побликации',
  `id_user` int(11) DEFAULT '0' COMMENT 'Кто опубликовал',
  `link` varchar(128) NOT NULL COMMENT 'Персональная ссылка',
  `token` varchar(64) NOT NULL COMMENT 'TokenCSRF',
  `key` varchar(64) NOT NULL COMMENT 'Key',
  `act` int(1) DEFAULT '0' COMMENT 'Статус публикации',
  `title` varchar(128) NOT NULL COMMENT 'Заголовок',
  `text` text NOT NULL COMMENT 'Заголовок',
  `img` varchar(128) NOT NULL COMMENT 'Обложка',
  `razd` varchar(64) NOT NULL COMMENT 'Раздел',
  `keywords` varchar(512) DEFAULT '',
  `description` varchar(512) DEFAULT '',
  `sort` int(11) DEFAULT '0',
  `view` int(11) DEFAULT '0'
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `news_razd` (
  `id` int(11) NOT NULL COMMENT 'Уникальный id',
  `date_create` int(10) DEFAULT '0' COMMENT 'Дата добавления',
  `link` varchar(64) NOT NULL COMMENT 'Персональная ссылка',
  `token` varchar(64) NOT NULL COMMENT 'TokenCSRF',
  `name` varchar(128) NOT NULL COMMENT 'Заголовок',
  `text` text NOT NULL COMMENT 'Описание',
  `img` varchar(128) NOT NULL COMMENT 'Обложка',
  `sort` int(11) DEFAULT '0',
  `description` varchar(512) DEFAULT '',
  `keywords` varchar(512) DEFAULT ''
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

INSERT INTO `news_razd` (`id`, `date_create`, `link`, `token`, `name`, `text`, `img`, `sort`, `description`, `keywords`) VALUES
(1, 0, 'russia', 'russiarussia', 'Россия', '', '', 2, 'asdasd32423', 'xcv34534df'),
(3, 0, 'ukraine', 'ukraineukraine', 'Украина', '', '', 3, '', ''),
(2, 0, 'dnr-lnr', 'dnr-lnrdnr-lnrs', 'ДНР и ЛНР', '', '', 4, '', ''),
(4, 0, 'world', 'world2world', 'Мир', 'Но́вости — оперативная информация, которая представляет политический, \r\nсоциальный или экономический интерес для аудитории в своей свежести, \r\nто есть сообщения о событиях, произошедших недавно или происходящих в данный момент.', '', 1, '', ''),
(5, 0, 'balkany', 'balkany3balkany', 'Балканы', '', '', 5, '', ''),
(6, 0, 'moldaviya', 'moldaviya5moldaviya', 'Молдавия', '', '', 6, '', ''),
(7, 0, 'belorussiya', 'belorussiya77belorussiya', 'Белоруссия', '', '', 7, '', ''),
(8, 0, 'central-asia', 'central-asiass', 'Центральная Азия', '', '', 8, '', '');

CREATE TABLE IF NOT EXISTS `users` (
  `id` int(11) NOT NULL COMMENT 'Уникальный id',
  `date_create` int(10) DEFAULT '0' COMMENT 'Дата регистрации',
  `date_last` int(10) DEFAULT '0' COMMENT 'Дата последнего посещения',
  `link` varchar(64) NOT NULL COMMENT 'Персональная ссылка',
  `login` varchar(64) NOT NULL COMMENT 'Логин',
  `password` varchar(1024) NOT NULL COMMENT 'Пароль',
  `id_level` int(3) DEFAULT '0' COMMENT 'Уровень прав доступа',
  `sex` int(1) DEFAULT '0' COMMENT 'Пол',
  `token` varchar(128) NOT NULL COMMENT 'Текущий token',
  `rating` varchar(32) DEFAULT '0.00' COMMENT 'Рейтинг',
  `news_read` int(1) DEFAULT '0' COMMENT 'Статус прочтения последней новости',
  `url` varchar(128) NOT NULL COMMENT 'Текущая страница',
  `ua` varchar(2048) NOT NULL COMMENT 'Юзер агент',
  `ip` varchar(20) DEFAULT '0' COMMENT 'Последний ip',
  `email` varchar(64) NOT NULL COMMENT 'Почтовый ящик',
  `money` bigint(20) DEFAULT '0' COMMENT 'Валюта сайта',
  `timezone` int(2) DEFAULT '0' COMMENT 'Часовой пояс',
  `theme_mobile` varchar(32) NOT NULL COMMENT 'Мобильная тема',
  `theme_web` varchar(32) NOT NULL COMMENT 'Веб тема',
  `theme_tablet` varchar(32) NOT NULL COMMENT 'Планшетная тема',
  `avatar` varchar(64) NOT NULL COMMENT 'Аватар пользователя',
  `browser` varchar(32) NOT NULL COMMENT 'Текущий Браузер',
  `surname` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `times` int(10) DEFAULT '0',
  `status` text
) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `users_password` (
  `id_user` int(11) NOT NULL DEFAULT '0',
  `date_create` int(10) DEFAULT '0',
  `pass` varchar(512) COLLATE utf8_unicode_ci DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `users_recovery` (
  `id` int(11) NOT NULL,
  `date_create` int(10) DEFAULT '0',
  `id_user` int(11) DEFAULT '0',
  `key` varchar(64) DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `news` ADD PRIMARY KEY (`id`);
ALTER TABLE `news_razd` ADD PRIMARY KEY (`id`);
ALTER TABLE `users` ADD PRIMARY KEY (`id`);
ALTER TABLE `users_password`  ADD PRIMARY KEY (`id_user`),  ADD KEY `date_create` (`date_create`);
ALTER TABLE `users_recovery`  ADD PRIMARY KEY (`id`);
ALTER TABLE `news`  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Уникальный id',AUTO_INCREMENT=0;
ALTER TABLE `news_razd`  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Уникальный id',AUTO_INCREMENT=13;
ALTER TABLE `users`  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Уникальный id',AUTO_INCREMENT=0;
ALTER TABLE `users_recovery`  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

