<?

class db {
	//public static $db;
    public function __construct() {
		$this->SqlCount = 0;
        try
		{
			$this->FileConfig = $_SERVER['DOCUMENT_ROOT'] . '/core/config/db.ini';
			if (is_file($this->FileConfig)) {
				$this->ini = parse_ini_file($this->FileConfig);
			} else {
				die('No configuration file - '. $this->FileConfig);
			}
			//self::$db = $db
			$this->db = new PDO(
				"mysql:host=".
				$this->ini['mysql_host'].";dbname=".
				$this->ini['mysql_db_name'], 
				$this->ini['mysql_user'], 
				$this->ini['mysql_pass']
			);
			//$this->_query = $this->db->query();
			if (isset($this->ini['charset_names']) AND $this->ini['charset_names'] != null) {
				self::query("SET NAMES '{$this->ini['charset_names']}'");
			}
		} catch (PDOException $e) {
			print "Error!: " . $e->getMessage() . "<br/>";
			die();
		}
    }
	//Счётчик числа запросов
	public function SqlCount(){
		return $this->SqlCount;
	}
	//Последний insert id ключа
	public function id(){
		return $this->db->lastInsertId();
	}
	public function quote($sql = false){
		return $this->db->quote($sql);
	}

    public function exec($query = false, $params = array()) {
		//Если есть массив params , значит это подготовленыне запросы
		if (is_array($params)) {
			$sql = $this->db->prepare($query);
			$query = $sql->execute($params);
		} else {
			$query = $this->db->exec($query);
		}
		//Если запрос был выполнен с ошибкой
		if (!$query) {
			echo $this->err($query);
		} else {
			//Считаем только выполненые запросы
			$this->SqlCount++;
			return $query;
		}
    }	
	
    public function query($query = false, $params = array()) {
		//Если есть массив params , значит это подготовленыне запросы
		if (is_array($params)) {
			$sql = $this->db->prepare($query);
			$query = $sql->execute($params);
		} else {
			$query = $this->db->query($query);
		}
		//Если запрос был выполнен с ошибкой
		if (!$query) {
			echo $this->err($query);
		} else {
			//Считаем только выполненые запросы
			$this->SqlCount++;
			return $query;
		}
    }
	
	public function err($err = false){
		$err .= "<b style='color:#ce5959;'>db::errorInfo():</b>";
		$err .=  "<pre style='color:#61b37f;'>";
		$err .= print_r($this->db->errorInfo());
		$err .=  "</pre>";
		return $err;
	}
    public function fetch($query = false, $params = false) {
		if (is_array($params)) {
			$st = $this->db->prepare($query);
			$st->execute($params); 
		} else {
			$st = $this->db->query($query);
		}
		$st = $st->fetch(PDO::FETCH_ASSOC); 
		$this->SqlCount++;
		return $st;
	}
    public function fetchObject($query = false, $params = false) {
		if (is_array($params)) {
			$st = $this->db->prepare($query);
			$st->execute($params); 
		} else {
			$st = $this->db->query($query);
		}
		$st = $st->fetchObject(); 
		$this->SqlCount++;
		return $st;
	}
	public function fetchAll($query = false ,$params = false) { 
		if (is_array($params)) {
			$st = $this->db->prepare($query);
			$st->execute($params); 
		} else {
			$st = $this->db->query($query);
		}
		$st = $st->fetchAll(PDO::FETCH_ASSOC); 
		$this->SqlCount++;
		return $st;
    }
	public function rowCount($query = false ,$params = false) { 
		if (is_array($params)) {
			$st = $this->db->prepare($query);
			$st->execute($params); 
		} else {
			$st = $this->db->query($query);
		}
		$st = $st->rowCount();
		$this->SqlCount++;
		return $st;
    }
	//Вызывать после каждого фича
	public function closeCursor(){
		return $this->db->closeCursor();
	}	
}