<?php

class CacheHade{

    const DirCache = H . 'files/cache/';

	static function get($data = array()) {
	if (!isset($data['type'])) {
		$data['type'] = 'data';
	}
	//Если указан 0 .храним файл бесконечно
	if (!isset($data['LifeTime']) || $data['LifeTime'] <= 0)
	$data['LifeTime'] = 99999999;

	$data['type'] = self::DirCache . $data['type'].'/';
	//Сам файл
	
	$CacheFile = $data['type'] .  md5($data['NameKey']) .'.json';
	//Если время жизни файла истекло
	if (is_file($CacheFile) AND (time() - $data['LifeTime']) > filemtime($CacheFile) AND isset($data['NameKey']))
	{
		unlink($CacheFile);
		//self::delete($data['NameKey'],$data['Type']);
	}
    // Если время файла не вышло AND Если файл с кэшем существует
    if (is_file($CacheFile) AND isset($data['NameKey'])) 
	{
		//Формируем нашу строку из файла в json 
		$json = json_decode(file_get_contents($CacheFile), true);
		//Выводим
		return $json;
	}
	//Всё плохо
	return false;
  }

  //перезапись файла
 static function save($data = array()) 
  {
	  	if (!isset($data['type'])) {
			$data['type'] = 'data';
		}
		$otype = $data['type'];
		$data['type'] = self::DirCache . $data['type'].'/';
		
	  	//Если есть права на запись 
		if (empty($data['data'])) {
			return false;
		}
		//Если есть права на запись 
		if (!is_writable($data['type'])) {
			return false;
		}
		//Сам файл
		$CacheFile = $data['type'] .  md5($data['NameKey']) .'.json';
		//Если файл существует , удаляем его 
		if (is_file($CacheFile) AND isset($data['NameKey']) AND $data['NameKey'] != null) {
			self::delete($data['NameKey'],$otype);
		}
		//Формируем строку json
		$json = json_encode($data['data'], true);
		file_put_contents($CacheFile, $json, FILE_APPEND);
		//Для отладки
		if (is_file($CacheFile)) {
			return $data['data'];
		}
		//Если всё плохо
		return false;
  }

  //Удалить кэш файла
	static  function delete($name = false, $type = 'data') 
	{
		  $type = self::DirCache . $type .'/';
		  $CacheFile =  $type .  md5($name) .'.json';
		  //Если файл сущестует
		  if (is_file($CacheFile) AND $name)
		  {
			unlink($CacheFile);
			return true;
		  }
		  //Всё плохо
		  return false;
	}

  //Замена данных
 static function replace($data = array()) 
  {
	  $CacheFile = self::DirCache .  $data['type']  .'/'. md5($data['NameKey']) .'.json';
	  //Если файл сущестует
	  if (is_file($CacheFile) AND isset($data['replace'],$data['NameKey']))
	  {
		$json = array();
		$json = json_decode(file_get_contents($CacheFile), true);	
		$json = array_replace($json, $data['replace']);
		$json = json_encode($json, true);
		file_put_contents($CacheFile, $json);
		return true;
	  }
	  //Всё плохо
	  return false;
  }
}

class CacheDelete {
	public static function type($data = array())
	{
		if (isset($data['type'],$data['NameKey']))
		{
			$file = H . 'files/cache/'. $data['type'] .'/'. md5($data['NameKey']) .'.json';
			if (is_file($file)) {
				unlink($file);
			}
		}
	}
	public static function user($id = 0)
	{
		$r = true;
		$u = user::data($id);
		if (!$u){
			$r = false;
		} else {
			CacheHade::delete($u['id'],'users');
			CacheHade::delete($u['link'],'users');
		}
		return $r;
	}
	public static function news($id = 0)
	{
		CacheHade::delete('news-'. $id,'news');
		return $id;
	}	
}