<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

defined('_IN_JOHNCMS') or die('Error: restricted access');

$headmod = 'office';
$textl = 'Оповещения';
require('../system/head.php');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var PDO $db */
$db = $container->get(PDO::class);

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

// Проверяем права доступа
if ($user['id'] != $systemUser->id) {
    echo $tools->displayError(_t('Access forbidden'));
    require('../system/end.php');
    exit;
}

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);
$mod = isset($_GET['mod']) ? trim($_GET['mod']) : '';

?>
<div class="phdr">Оповещения</div>
<?php
$notifi = $db->query("SELECT * FROM `cms_notification` WHERE `user_id`='".$systemUser->id."' ORDER BY `date` DESC LIMIT $start, $kmess");

$total = $db->query("SELECT COUNT(*) FROM `cms_notification` WHERE `user_id`='".$systemUser->id."'")->fetchColumn();
if($total > 0){
    while($n = $notifi->fetch()){
        $db->query("UPDATE `cms_notification` SET `read`=1 WHERE `id`='".$n['id']."'");
        echo '<div class="menu" '.($n['read'] == 0 ? 'style="color:red;font-weight:bold"' : '').'>'.$n['text'].' '.$tools->displayDate($n['date']).'</div>';
    if($mod == 'clear'){
    if($systemUser->id === $n['user_id']){
        $db->query("DELETE FROM `cms_notification` WHERE `user_id`='".$systemUser->id."'");
        header('location: /profile/?act=notification');
    }
    }
    }
}else{
    echo '<div class="menu">Оповещений пока нет!</div>';
}
    
    if ($total > $kmess) {
            echo '<div class="center">' . $tools->displayPagination('?act=notification&', $start, $total, $kmess) . '</div>';
    }
    if($total > 0){
        echo '<div class="phdr"><center><a href="?act=notification&mod=clear">Очистить оповещения</a></center></div>';
    }

?>