<?php
define('_IN_JOHNCMS', 1);

require('../system/bootstrap.php');
/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var PDO $db */
$db = $container->get(PDO::class);

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Johncms\Api\ToolsInterface $tools */
$tools = $container->get(Johncms\Api\ToolsInterface::class);

/** @var Johncms\Api\ConfigInterface $config */
$config = $container->get(Johncms\Api\ConfigInterface::class);

/** @var Johncms\Counters $counters */
$counters = App::getContainer()->get('counters');

/** @var Zend\I18n\Translator\Translator $translator */
$translator = $container->get(Zend\I18n\Translator\Translator::class);
$translator->addTranslationFilePattern('gettext', __DIR__ . '/locale', '/%s/default.mo');
$text1 = 'Создать статью';

if(!$systemUser->id){header('location:/');}
if(isset($_POST['go'])){
    $title = isset($_POST['title']) ? mb_substr(trim($_POST['title']), 0, 100) : '';
    $text = isset($_POST['text']) ? mb_substr(trim($_POST['text']), 0, 10000) : '';
    if(!empty($title) && !empty($text)){
        $error = [];
        $flood = false;
        if ($systemUser->isValid()) {
            // Антифлуд для зарегистрированных пользователей
            $flood = $tools->antiflood();
        }
        if ($flood) {
            $error = sprintf(_t('You cannot add the message so often. Please, wait %d seconds.'), $flood);
        }
        if(!$error){
        $db->prepare("INSERT INTO `blogs` SET
                `title` = ?,
                `text` = ?,
                `date` = ?,
                `user_id` = ?,
                `ip` = ?,
                `browser` = ?
            ")->execute([
                $title,
                $text,
                time(),
                $systemUser->id,
                $env->getIp(),
                $env->getUserAgent()
            ]);
        // Обновляем статистику юзера
            $db->exec("UPDATE `users` SET
                `blogs`='" . ($systemUser->blogs + 1) . "',
                `lastpost` = '" . time() . "'
                WHERE `id` = '" . $systemUser->id . "'
            ");
        header('location:blog.php');
        }
    }
}
require($_SERVER['DOCUMENT_ROOT'].'/system/head.php');
?>
<div class="phdr">Создать запись</div>
<?php
if($error){
            echo '<div class="rmenu">'.$error.'</div>';
        }
?>
<div class="list1">
    <form action="" method="POST" name="form">
        <?php
        $token = mt_rand(1000, 100000);
        $_SESSION['token'] = $token;
        ?>
        <p>Название записи (макс 100)</p>
        <input type="text" name="title" class="form-control" placeholder="Введите название записи..."><br>
        <p>Текст записи (макс 10000)</p>
        <?php echo $container->get('bbcode')->buttons('form', 'text'); ?>
        <textarea name="text" class="form-control" placeholder="Введите текст записи..."></textarea><br>
        <input type="submit" name="go" value="Написать" class="btn btn-default">
    </form>
</div>
<?
require($_SERVER['DOCUMENT_ROOT'].'/system/end.php');