<?php
/*
 * JohnCMS NEXT Mobile Content Management System (http://johncms.com)
 *
 * For copyright and license information, please see the LICENSE.md
 * Installing the system or redistributions of files must retain the above copyright notice.
 *
 * @link        http://johncms.com JohnCMS Project
 * @copyright   Copyright (C) JohnCMS Community
 * @license     GPL-3
 */

@ini_set("max_execution_time", "600");
define('_IN_JOHNCMS', 1);
define('_IN_JOHNADM', 1);

$id = isset($_REQUEST['id']) ? abs(intval($_REQUEST['id'])) : 0;
$act = isset($_GET['act']) ? trim($_GET['act']) : '';
$mod = isset($_GET['mod']) ? trim($_GET['mod']) : '';
$do = isset($_REQUEST['do']) ? trim($_REQUEST['do']) : false;

require('../system/bootstrap.php');

/** @var Psr\Container\ContainerInterface $container */
$container = App::getContainer();

/** @var PDO $db */
$db = $container->get(PDO::class);

/** @var Johncms\Api\UserInterface $systemUser */
$systemUser = $container->get(Johncms\Api\UserInterface::class);

/** @var Zend\I18n\Translator\Translator $translator */
$translator = $container->get(Zend\I18n\Translator\Translator::class);
$translator->addTranslationFilePattern('gettext', __DIR__ . '/locale', '/%s/default.mo');

// Проверяем права доступа
if ($systemUser->rights < 1) {
    header('Location: http://johncms.com/?err');
    exit;
}

$headmod = 'admin';
$textl = _t('Admin Panel');
require('head.php');

$array = [
    'forum',
    'news',
    'ads',
    'counters',
    'ip_whois',
    'languages',
    'settings',
    'smilies',
    'access',
    'antispy',
    'httpaf',
    'ipban',
    'antiflood',
    'ban_panel',
    'karma',
    'reg',
    'mail',
    'search_ip',
    'usr',
    'usr_adm',
    'usr_clean',
    'usr_del',
];

if ($act && ($key = array_search($act, $array)) !== false && file_exists('includes/' . $array[$key] . '.php')) {
    require('includes/' . $array[$key] . '.php');
} else {
    $regtotal = $db->query("SELECT COUNT(*) FROM `users` WHERE `preg`='0'")->fetchColumn();
    $bantotal = $db->query("SELECT COUNT(*) FROM `cms_ban_users` WHERE `ban_time` > '" . time() . "'")->fetchColumn();
    echo '<div class="phdr"><b>' . _t('Admin Panel') . '</b></div><div class="menu">';
    echo '<div class="col-lg-3 col-md-3">
<div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
  <div class="panel panel-default">
    <div class="panel-heading" role="tab" id="headingUsers">
      <h4 class="panel-title">
        <a role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseUsers" aria-expanded="true" aria-controls="collapseUsers" class="acc_h">
          ' . _t('Users') . '
        </a>
      </h4>
    </div>
    <div id="collapseUsers" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingUsers">
      <div class="panel-body" style="padding:0">';
        // Блок пользователей

    if ($regtotal && $systemUser->rights >= 6) {
        echo '<a href="index.php?act=reg" class="accordion-link">' . _t('On registration') . ' &#160;(' . $regtotal . ')</a>';
    }

    echo '<a href="index.php?act=usr" class="accordion-link">' . _t('Users') . ' &#160;(' . $container->get('counters')->users() . ')</a>
    <a href="index.php?act=usr_adm" class="accordion-link">' . _t('Administration') . ' &#160;(' . $db->query("SELECT COUNT(*) FROM `users` WHERE `rights` >= '1'")->fetchColumn() . ')</a>'.
        ($systemUser->rights >= 7 ? '<a href="index.php?act=usr_clean" class="accordion-link">' . _t('Database cleanup') . '</a>' : '') .
        '<a href="index.php?act=ban_panel" class="accordion-link">' . _t('Ban Panel') . ' &#160;(' . $bantotal . ')</a>' .
        ($systemUser->rights >= 7 ? '<a href="index.php?act=antiflood" class="accordion-link">' . _t('Antiflood') . '</a></li>' : '') .
        ($systemUser->rights >= 7 ? '<a href="index.php?act=karma" class="accordion-link">' . _t('Karma') . '</a>' : '') .
        '<a href="../users/search.php" class="accordion-link">' . _t('Search by Nickname') . '</a>' .
        '<a href="index.php?act=search_ip" class="accordion-link">' . _t('Search IP') . '</a>';
echo '</div>
    </div>
  </div>

  <div class="panel panel-default">
    <div class="panel-heading" role="tab" id="headingModules">
      <h4 class="panel-title">
        <a role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseModules" aria-expanded="true" aria-controls="collapseModules" class="acc_h">
          ' . _t('Modules') . '
        </a>
      </h4>
    </div>
    <div id="collapseModules" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingModules">
      <div class="panel-body" style="padding:0">';
        if ($systemUser->rights >= 7) {
        // Блок модулей
        $spam = $db->query("SELECT COUNT(*) FROM `cms_mail` WHERE `spam`='1';")->fetchColumn();

        echo '<a href="index.php?act=forum" class="accordion-link">' . _t('Forum') . '</a>' .
            '<a href="index.php?act=news" class="accordion-link">' . _t('News') . '</a>' .
            '<a href="index.php?act=ads" class="accordion-link">' . _t('Advertisement') . '</a>';

        if ($systemUser->rights == 9) {
            echo '<a href="index.php?act=counters" class="accordion-link">' . _t('Counters') . '</a>';
        }
echo '</div>
    </div>
  </div>


  <div class="panel panel-default">
    <div class="panel-heading" role="tab" id="headingSystem">
      <h4 class="panel-title">
        <a role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseSystem" aria-expanded="true" aria-controls="collapseSystem" class="acc_h">
          ' . _t('System') . '
        </a>
      </h4>
    </div>
    <div id="collapseSystem" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingSystem">
      <div class="panel-body" style="padding:0">';
// Блок системных настроек
        echo '' .
            ($systemUser->rights == 9 ? '<a href="index.php?act=settings" class="accordion-link">' . _t('System Settings') . '</a>' : '') .
            '<a href="index.php?act=smilies" class="accordion-link">' . _t('Update Smilies') . '</a>' .
            ($systemUser->rights == 9 ? '<a href="index.php?act=languages" class="accordion-link">' . _t('Language Settings') . '</a>' : '') .
            '<a href="index.php?act=access" class="accordion-link">' . _t('Permissions') . '</a>';
echo '</div>
    </div>
  </div>


    <div class="panel panel-default">
    <div class="panel-heading" role="tab" id="headingSheild">
      <h4 class="panel-title">
        <a role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseSheild" aria-expanded="true" aria-controls="collapseSheild" class="acc_h">
          ' . _t('Security') . '
        </a>
      </h4>
    </div>
    <div id="collapseSheild" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingSheild">
      <div class="panel-body" style="padding:0">';
        // Блок безопасности
        echo '<a href="index.php?act=antispy" class="accordion-link">' . _t('Anti-Spyware') . '</a>' .
            ($systemUser->rights == 9 ? '<a href="index.php?act=ipban" class="accordion-link">' . _t('Ban by IP') . '</a>' : '');
echo '</div>
    </div>
  </div>




</div>
    </div>
<div class="col-lg-9 col-md-9">
    <div class="phdr"><b>Новые пользователи</b></div>';
    $users = $db->query("SELECT * FROM `users` ORDER BY `datereg` DESC LIMIT 5");
    while ($u = $users->fetch()) {
        echo '<div class="menu">'.$tools->displayUser($u).'</div>';
    }
}
    echo '</div><div class="clearfix"></div></div>';
}

require('end.php');
