/***************************************************************************\
		===============================================
		 * || Zombie Plague Advance Includes File || *
		===============================================

	
	---------------
	 *||How to ||*
	---------------
	
	To make use of the Zombie Plague Advance API features in your plugin,
	just add the following line at the beginning of your script:
	
	#include <zombie_plague_advance>
	
	---------------
	 *||Natives||*
	---------------
	
	These work just like any other functions: you may have to pass
	parameters and they usually return values.
	
	Example:
	
	if ( is_user_alive( id ) && zp_get_user_zombie( id ) )
	{
		server_print( "Player %d is alive and a zombie", id )
	}
	
	----------------
	 *||Forwards||*
	----------------
	
	Forwards get called whenever an event happens during the game.
	You need to make a public callback somewhere on your script,
	and it will automatically be triggered when the event occurs.
	
	Example:
	
	public zp_user_infected_post( id, infector, nemesis )
	{
		if ( !infector || nemesis )
			return;
		
		server_print( "Player %d just got infected by %d!", id, infector )
	}
	
	Also, take note of cases when there's a suffix:
	[These suffixes are only available in some forwards]
	
	* _pre  : means the forward will be called BEFORE the event happens
	* _post : means it will be called AFTER the event takes place
	
\***************************************************************************/

#if defined _zombie_plague_advance_included
  #endinput
#endif
#define _zombie_plague_advance_included

/* Disable it to prevent it from using FM/Engine compile errors if your plugin doesn't use either one */
/* Add '//' infront to disable it */
#define ENABLE_KNOCKBACK_STOCK

/* Add '//' infront to use engine instead */
#define USE_FAKEMETA_FOR_KNOCKBACK

/* Teams for zp_register_extra_item() */
#define ZP_TEAM_ZOMBIE (1<<0)
#define ZP_TEAM_HUMAN (1<<1)
#define ZP_TEAM_NEMESIS (1<<2)
#define ZP_TEAM_SURVIVOR (1<<3)
#define ZP_TEAM_SNIPER (1<<4)
#define ZP_TEAM_ASSASSIN (1<<5)

/* Death Match modes for zp_register_game_mode */
enum
{
	ZP_DM_NONE = 0,	// Disable death match during the custom mode round
	ZP_DM_HUMAN, 	// Respawn as human only
	ZP_DM_ZOMBIE, 	// Respawn as zombie only
	ZP_DM_RANDOM,	// Respawn randomly as humans or zombies
	ZP_DM_BALANCE	// Respawn as humans or zombies to keep both team balanced
}

/* Game modes for zp_round_started() */
enum
{
	MODE_NONE = 0,
	MODE_INFECTION,
	MODE_NEMESIS,
	MODE_ASSASSIN,
	MODE_SURVIVOR,
	MODE_SNIPER,
	MODE_SWARM,
	MODE_MULTI,
	MODE_PLAGUE,
	MODE_LNJ
}

/* Winner teams for zp_round_ended() */
enum
{
	WIN_NO_ONE = 0,
	WIN_ZOMBIES,
	WIN_HUMANS
}

/* Custom forward return values */
#define ZP_PLUGIN_HANDLED 97

/**
 * Returns whether a player is a zombie.
 *
 * @param id		Player index.
 * @return		True if it is, false otherwise.
 */
native zp_get_user_zombie(id)

/**
 * Returns whether a player is a nemesis.
 *
 * @param id		Player index.
 * @return		True if it is, false otherwise.
 */
native zp_get_user_nemesis(id)

/**
 * Returns whether a player is a survivor.
 *
 * @param id		Player index.
 * @return		True if it is, false otherwise.
 */
native zp_get_user_survivor(id)

/**
 * Returns whether a player is the first zombie.
 *
 * @param id		Player index.
 * @return		True if it is, false otherwise.
 */
native zp_get_user_first_zombie(id)

/**
 * Returns whether a player is the last zombie.
 *
 * @param id		Player index.
 * @return		True if it is, false otherwise.
 */
native zp_get_user_last_zombie(id)

/**
 * Returns whether a player is the last human.
 *
 * @param id		Player index.
 * @return		True if it is, false otherwise.
 */
native zp_get_user_last_human(id)

/**
 * Returns a player's current zombie class ID.
 *
 * @param id		Player index.
 * @return		Internal zombie class ID, or -1 if not yet chosen.
 */
native zp_get_user_zombie_class(id)

/**
 * Returns a player's next zombie class ID (for the next infection).
 *
 * @param id		Player index.
 * @return		Internal zombie class ID, or -1 if not yet chosen.
 */
native zp_get_user_next_class(id)

/**
 * Sets a player's next zombie class ID (for the next infection).
 *
 * @param id		Player index.
 * @param classid	A valid zombie class ID.
 * @return		True on success, false otherwise.
 */
native zp_set_user_zombie_class(id, classid)

/**
 * Returns a player's ammo pack count.
 *
 * @param id		Player index.
 * @return		Number of ammo packs owned.
 */
native zp_get_user_ammo_packs(id)

/**
 * Sets a player's ammo pack count.
 *
 * @param id		Player index.
 * @param amount	New quantity of ammo packs owned.
 */
native zp_set_user_ammo_packs(id, amount)

/**
 * Returns the default maximum health of a zombie.
 *
 * Note: Takes into account first zombie's HP multiplier.
 *
 * @param id		Player index.
 * @return		Maximum amount of health points, or -1 if not a normal zombie.
 */
native zp_get_zombie_maxhealth(id)

/**
 * Returns a player's custom flashlight batteries charge.
 *
 * @param id		Player index.
 * @return		Charge percent (0 to 100).
 */
native zp_get_user_batteries(id)

/**
 * Sets a player's custom flashlight batteries charge.
 *
 * @param id		Player index.
 * @param value		New charge percent (0 to 100).
 */
native zp_set_user_batteries(id, charge)

/**
 * Returns whether a player has night vision.
 *
 * @param id		Player index.
 * @return		True if it has, false otherwise.
 */
native zp_get_user_nightvision(id)

/**
 * Sets whether a player has night vision.
 *
 * @param id		Player index.
 * @param set		True to give, false for removing it.
 */
native zp_set_user_nightvision(id, set)

/**
 * If the user is frozen
 *
 * @param id		Player index.
 */
native zp_get_user_frozen(id)

/**
 * Set if user should be frozen
 *
 * @param id		Player index.
 * @param set		True to set, false for removing it.
 */
native zp_set_user_frozen(id, set)

/**
 * If the user is no damage(Zombie Madness)
 *
 * @param id		Player index.
 */
native zp_get_user_nodamage(id)

/**
 * Set if user should be no damage(Zombie Madness)
 *
 * @param id		Player index.
 * @param set		True to set, false for removing it.
 */
native zp_set_user_nodamage(id, set)

/**
 * If the user is stucked
 *
 * @param id		Player index.
 */
native zp_get_user_stucked(id)

/**
 * Set user unstucked if he is stucked
 *
 * @param id		Player index.
 */
native zp_set_user_unstucked(id)

/**
 * If user has infection nade
 *
 * @param id		Player index.
 */
native zp_user_has_infect_nade(id)

/**
 * If the user is burning
 *
 * @param id		Player index.
 */
native zp_get_user_burning(id)

/**
 * Set user burning
 *
 * @param id		Player index.
 * @param bool:isburning	True: Set burning | False: Remove burn
 */
native zp_set_user_burning(id, bool:isburning)

/**
 * If the user has unlimited clip
 *
 * @param id		Player index.
 */
native zp_get_user_unlimited_clip(id)

/**
 * Set user unlimited clip
 *
 * @param id		Player index.
 * @param set		1: Unlimited clip | False: Remove unlimited clip
 */
native zp_set_user_unlimited_clip(id, set)

/**
 * If the user has Pain Shock Free
 *
 * @param id		Player index.
 */
native zp_user_has_painshockfree(id)

/**
 * Set user Pain Shock Free
 *
 * @param id		Player index.
 * @param set		1: PSF | False: Remove PSF
 */
native zp_set_user_painshockfree(id, set)

/**
 * Start a specified game mode
 *
 * @param gamemode	Start a mode(MODE_SWARM | MODE_MULTI | MODE_PLAGUE)
 */
native zp_set_gamemode(gamemode)

/**
 * Get user's gender(IN-GAME, NOT REAL LIFE)
 *
 * @param id		Player's Index
 */
native zp_get_user_gender(id)

/**
 * Set user's gender(IN-GAME, NOT REAL LIFE)
 *
 * @param id		Player's Index
 * @param gender	Put 1 for Male & 2 for female
 */
native zp_set_user_gender(id, gender)

/**
 * Get user's model
 *
 * @param id		Player's Index
 * @string[]		Model's name
 * @len			Lens
 */
native zp_get_user_model(id, const string[], len)

/**
 * Set user's model
 *
 * @param id		Player's Index
 * @param model[]	Change to the specified model
 */
native zp_set_user_model(id, const model[])

/**
 * Randomly places a user via index if he is alive.
 *
 * @param id		Player's Index
 */
native zp_user_random_spawn(id)

/**
 * Forces a player to become a zombie.
 *
 * Note: Unavailable for last human/survivor/sniper.
 *
 * @param id		Player index to be infected.
 * @param infector	Player index who infected him (optional).
 * @param silent	If set, there will be no HUD messages or infection sounds.
 * @param rewards	Whether to show DeathMsg and reward frags, hp, and ammo packs to infector.
 * @return		True on success, false otherwise.
 */
native zp_infect_user(id, infector = 0, silent = 0, rewards = 0)

/**
 * Forces a player to become a human.
 *
 * Note: Unavailable for last zombie/nemesis.
 *
 * @param id		Player index to be cured.
 * @param silent	If set, there will be no HUD messages or antidote sounds.
 * @return		True on success, false otherwise.
 */
native zp_disinfect_user(id, silent = 0)

/**
 * Forces a player to become a nemesis.
 *
 * Note: Unavailable for last human/survivor/sniper.
 *
 * @param id		Player index to turn into nemesis.
 * @return		True on success, false otherwise.
 */
native zp_make_user_nemesis(id)

/**
 * Forces a player to become a survivor.
 *
 * Note: Unavailable for last zombie/nemesis.
 *
 * @param id		Player index to turn into survivor.
 * @return		True on success, false otherwise.
 */
native zp_make_user_survivor(id)

/**
 * Respawns a player into a specific team.
 *
 * @param id		Player index to be respawned.
 * @param team		Team to respawn the player into (ZP_TEAM_ZOMBIE or ZP_TEAM_HUMAN).
 * @return		True on success, false otherwise.
 */
native zp_respawn_user(id, team)

/**
 * Forces a player to buy an extra item.
 *
 * @param id		Player index.
 * @param itemid	A valid extra item ID.
 * @param ignorecost	If set, item's cost won't be deduced from player.
 * @return		True on success, false otherwise.
 */
native zp_force_buy_extra_item(id, itemid, ignorecost = 0)

/**
 * Returns whether a player is a sniper.
 *
 * @param id		Player index.
 * @return		True if it is, false otherwise.
 */
native zp_get_user_sniper(id)

/**
 * Forces a player to become a sniper.
 *
 * Note: Unavailable for last zombie/nemesis/assassin.
 *
 * @param id		Player index to turn into sniper.
 * @return		True on success, false otherwise.
 */
native zp_make_user_sniper(id)

/**
 * Returns whether a player is an assassin.
 *
 * @param id		Player index.
 * @return		True if it is, false otherwise.
 */
native zp_get_user_assassin(id)

/**
 * Forces a player to become a assassin.
 *
 * Note: Unavailable for last human/survivor/sniper.
 *
 * @param id		Player index to turn into assassin.
 * @return		True on success, false otherwise.
 */
native zp_make_user_assassin(id)

/**
 * Returns whether the ZP round has started, i.e. first zombie
 * has been chosen or a game mode has begun.
 *
 * @return		0 - Round not started
 *			1 - Round started
 *			2 - Round starting
 */
native zp_has_round_started()

/**
 * Returns whether the current round is a nemesis round.
 *
 * @return		True if it is, false otherwise.
 */
native zp_is_nemesis_round()

/**
 * Returns whether the current round is a survivor round.
 *
 * @return		True if it is, false otherwise.
 */
native zp_is_survivor_round()

/**
 * Returns whether the current round is a swarm round.
 *
 * @return		True if it is, false otherwise.
 */
native zp_is_swarm_round()

/**
 * Returns whether the current round is a plague round.
 *
 * @return		True if it is, false otherwise.
 */
native zp_is_plague_round()

/**
 * Returns whether the current round is a Armageddon round.
 *
 * @return		True if it is, false otherwise.
 */
native zp_is_lnj_round()

/**
 * Returns number of alive zombies.
 *
 * @return		Zombie count.
 */
native zp_get_zombie_count()

/**
 * Returns number of alive humans.
 *
 * @return		Human count.
 */
native zp_get_human_count()

/**
 * Returns number of alive nemesis.
 *
 * @return		Nemesis count.
 */
native zp_get_nemesis_count()

/**
 * Returns number of alive survivors.
 *
 * @return		Survivor count.
 */
native zp_get_survivor_count()

/**
 * Returns whether the current round is a sniper round.
 *
 * @return		True if it is, false otherwise.
 */
native zp_is_sniper_round()

/**
 * Returns whether the current round is a assassin round.
 *
 * @return		True if it is, false otherwise.
 */
native zp_is_assassin_round()

/**
 * Returns number of alive snipers.
 *
 * @return		Sniper count.
 */
native zp_get_sniper_count()

/**
 * Returns number of alive assassins.
 *
 * @return		Assassin count.
 */
native zp_get_assassin_count()

/**
 * Returns the current game mode ID
 * 
 * Note: For default game modes you can use, for eg. MODE_SWARM,
 * to check if the current round is swarm mode.
 * 
 * Note: For custom game modes you must have the custom game
 * mode ID to detect it
 * 
 * @return		Current game mode ID
 */
native zp_get_current_mode()

/**
 * Allows you to properly retrieve a player's model
 * 
 * Note: You should use this native for retrieving a player's 
 * current model instead of other methods
 * 
 * Note: The model name which is retrieved is the model's folder
 * name for eg: zombie_source and is not the model's actual name.
 * 
 * @param id 		Player index who's model is to be retrieved.
 * @param model		String in which the model name will be copied.
 * @param maxlen	Number of characters (of the string) to copy.
 */
native zp_get_user_model(id, const model[], maxlen)

/**
 * Properly sets the given model for the player.
 * 
 * Note: You should use this native for setting a player's model
 * instead of other methods.
 * 
 * Note: The model name which is passed should be the model's folder
 * name for eg: zombie_source and the folder should contain the
 * actual model file in it eg: zombie_source.mdl
 * 
 * Note: The model you are setting should be precached in the 
 * sub-plugin using the plugin_precache forward to prevent problems.
 * 
 * Note: It is highly advised to set the models with an additional
 * delay during round start to prevent SVC_BAD errors/kicks.
 * 
 * @param id 		Player index who's model needs to be set.
 * @param model		String containing the model folder name.
 */
native zp_set_user_model(id, const model[])

/**
 * Returns an extra item's ID.
 *
 * @param name		Item name to look for.
 * @return		Internal extra item ID, or -1 if not found.
 */
native zp_get_extra_item_id(const name[])

/**
 * Returns a zombie class' ID.
 *
 * @param name		Class name to look for.
 * @return		Internal zombie class ID, or -1 if not found.
 */
native zp_get_zombie_class_id(const name[])

/**
 * Registers a custom game mode which will be added to the admin menu of ZP
 * 
 * Note: The returned game mode ID can later be used to detect the game mode
 * which is called in zp_round_started_pre. There you can start the game mode
 * externally by using this game mode ID.
 * 
 * @param name 		The game mode's name which will help in identifing it.
 * @param flags		Access flags required by the admins to start this game mode.
 * @param chance	Chance level of this game mode. (1 in X).
 * @param allow		Whether to permit infection after zombie to player attacks.
 * @param dm_mode	Death match mode which will be used during this game.
 * @return		An internal game mode ID or -1 on failure.
 */
native zp_register_game_mode( const name[], flags, chance, allow, dm_mode)

/**
 * Registers a custom item which will be added to the extra items menu of ZP.
 *
 * Note: The returned extra item ID can be later used to catch item
 * purchase events for the zp_extra_item_selected() forward.
 *
 * Note: ZP_TEAM_NEMESIS, ZP_TEAM_SURVIVOR, ZP_TEAM_ASSASSIN and ZP_TEAM_SNIPER
 * can be used to make an item available to Nemesis,
 * Survivors, Assassins and Snipers.
 *
 * @param name		Caption to display on the menu.
 * @param cost		Ammo packs to be deducted on purchase.
 * @param teams		Bitsum of teams it should be available for.
 * @return		An internal extra item ID, or -1 on failure.
 */
native zp_register_extra_item(const name[], cost, teams)

/**
 * Registers a custom class which will be added to the zombie classes menu of ZP.
 *
 * Note: The returned zombie class ID can be later used to identify
 * the class when calling the zp_get_user_zombie_class() natives.
 *
 * @param name		Caption to display on the menu.
 * @param info		Brief description of the class.
 * @param model		Player model to be used.
 * @param clawmodel	Claws model to be used.
 * @param hp		Initial health points.
 * @param speed		Maximum speed.
 * @param gravity	Gravity multiplier.
 * @param knockback	Knockback multiplier.
 * @return		An internal zombie class ID, or -1 on failure.
 */
native zp_register_zombie_class(const name[], const info[], const model[], const clawmodel[], hp, speed, Float:gravity, Float:knockback)

/**
 * Called when the ZP round starts, i.e. first zombie
 * is chosen or a game mode begins.
 *
 * @param gamemode	Mode which has started.
 * @param id		Affected player's index (if applicable).
 */
forward zp_round_started(gamemode, id)

/**
 * Called before the ZP round starts. This is only 
 * called for custom game modes.
 * 
 * Note: The custom game mode id can be used to start
 * the game mode externally
 * 
 * Note: returning ZP_PLUGIN_HANDLED will cause the
 * game mode to be blocked and other game modes will
 * be given a chance.
 * 
 * @param gameid	Custom mode id which is called
 */
forward zp_round_started_pre(gameid)

/**
 * Called when the round ends.
 *
 * @param winteam	Team which has won the round.
 */
forward zp_round_ended(winteam)

/**
 * Called when a player gets infected.
 *
 * @param id		Player index who was infected.
 * @param infector	Player index who infected him (if applicable).
 * @param nemesis	Whether the player was turned into a nemesis.
 */
forward zp_user_infected_pre(id, infector, nemesis)
forward zp_user_infected_post(id, infector, nemesis)

/**
 * Called when a player turns back to human.
 *
 * @param id		Player index who was cured.
 * @param survivor	Whether the player was turned into a survivor.
 */
forward zp_user_humanized_pre(id, survivor)
forward zp_user_humanized_post(id, survivor)
forward zp_user_humanized_pre(id, sniper)
forward zp_user_humanized_post(id, sniper)

/**
 * Called on a player infect/cure attempt. You can use this to block
 * an infection/humanization by returning ZP_PLUGIN_HANDLED in your plugin.
 *
 * Note: Right now this is only available after the ZP round starts, since some
 * situations (like blocking a first zombie's infection) are not yet handled.
 */
forward zp_user_infect_attempt(id, infector, nemesis)
forward zp_user_humanize_attempt(id, survivor)
forward zp_user_humanize_attempt(id, sniper)

/**
 * Called when an admin selects a custom game mode from the ZP admin menu.
 *
 * Note: You should trigger the custom game mode here with out any checks
 *
 * @param gameid	Internal custom game mode ID
 * @param id		Player index who selected the game mode
 */
forward zp_game_mode_selected(gameid, id)

/**
 * Called when a player buys an extra item from the ZP menu.
 *
 * Note: You can now return ZP_PLUGIN_HANDLED in your plugin to block
 * the purchase and the player will be automatically refunded.
 *
 * @param id		Player index of purchaser.
 * @param itemid	Internal extra item ID.
 */
forward zp_extra_item_selected(id, itemid)

/**
 * Called when a player gets unfrozen (frostnades).
 *
 * @param id		Player index.
 */
forward zp_user_unfrozen(id)

/**
 * Called when a player becomes the last zombie.
 *
 * Note: This is called for the first zombie too.
 *
 * @param id		Player index.
 */
forward zp_user_last_zombie(id)

/**
 * Called when a player becomes the last human.
 *
 * @param id		Player index.
 */
forward zp_user_last_human(id)

/**
 * Called when a player spawns. This is also called for CZ bots 
 * which are spawning.
 *
 * Note: You should use this, instead of other spawn forwards,
 * for changing a player's class after the player's spawn.
 *
 * @param id		Player index who has spawned
 */
forward zp_player_spawn_post(id, resp_zombie)

/**
 * @deprecated - Do not use!
 * For backwards compatibility only.
 */
#define ZP_TEAM_ANY 0

/**
 * Set victim knockback.
 *
 * Note: This is called for the first zombie too.
 *
 * @param victim		Victim index.
 * @param attacker		Attacker index.
 * @param velocity		Velocity.
 * @param velocity_amt		Amount of velocity.
 */

#if defined ENABLE_KNOCKBACK_STOCK
	stock zp_set_victim_knockback(victim, attacker, Float:velocity[3], Float:velocity_amt)
	{
		if(!is_user_alive(victim) || !is_user_alive(attacker))
			return 0;
		
		new Float:oldvelocity[3]
		new Float:vicorigin[3];
		new Float:attorigin[3];
		
		#if defined USE_FAKEMETA_FOR_KNOCKBACK
			pev(victim, pev_velocity, oldvelocity)
			pev(victim, pev_origin, vicorigin)
			pev(attacker, pev_origin, attorigin)
		#else
			entity_get_vector(victim, EV_VEC_velocity, oldvelocity);
			entity_get_vector(victim, EV_VEC_origin, vicorigin);
			entity_get_vector(attacker, EV_VEC_origin, attorigin);
		#endif
	
		new Float:origin2[3]
		origin2[0] = vicorigin[0] - attorigin[0];
		origin2[1] = vicorigin[1] - attorigin[1];
	
		new Float:largestnum = 0.0;
	
		if(floatabs(origin2[0])>largestnum) largestnum = floatabs(origin2[0]);
		if(floatabs(origin2[1])>largestnum) largestnum = floatabs(origin2[1]);

		origin2[0] /= largestnum;
		origin2[1] /= largestnum;
	
		velocity[0] = (origin2[0] * (velocity_amt));
		velocity[1] = (origin2[1] * (velocity_amt));
		if(velocity[0] <= 20.0 || velocity[1] <= 20.0)
			velocity[2] = random_float(200.0 , 275.0);
		
		velocity[0] += oldvelocity[0];
		velocity[1] += oldvelocity[1];
		
		#if defined USE_FAKEMETA_FOR_KNOCKBACK
			set_pev(victim, pev_velocity, velocity);
		#else
			set_user_velocity(victim, velocity);
		#endif
		
		return 1;
	}
#endif