<?php
ob_start();

require_once('wu_config.php');

//Определение домена и весии движка
define('SITE', $_SERVER['HTTP_HOST']);
define('WUVERSION', '3.0');

//Вывод ошибок
function wu_error_msg($msg) {
return '<link href="/wu-static/css/wu_main.css" rel="stylesheet" type="text/css"><div class="alert alert-danger fade in"><center>'.$msg.'</center></div>';
}

//Подклчение к базе
$connect_db = mysqli_connect(DB_HOST,DB_USER,DB_PASS,DB_BASE) or die(wu_error_msg('Ошибка подключения к базе данных: '.mysqli_connect_error()));                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
mysqli_set_charset ($connect_db, DB_CHARSET) or die(wu_error_msg('Кодировка базы данных не установлена'));

//Старт сессии
ini_set('session.use_cookies', 'On');
ini_set('session.use_trans_sid', 'Off');
session_set_cookie_params(604800000, "/", SITE, false, false);
session_start();

//Определяем реальный IP
if(getenv('HTTP_CLIENT_IP') && strcasecmp(getenv('HTTP_CLIENT_IP'),'unknown')) { $ip=getenv('HTTP_CLIENT_IP'); }
elseif(getenv('HTTP_X_FORWARDED_FOR') && strcasecmp(getenv('HTTP_X_FORWARDED_FOR'), 'unknown')) { $ip=getenv('HTTP_X_FORWARDED_FOR'); }
elseif(getenv('REMOTE_ADDR') && strcasecmp(getenv("REMOTE_ADDR"), 'unknown')) { $ip=getenv('REMOTE_ADDR'); }
elseif(!empty($_SERVER['REMOTE_ADDR']) && strcasecmp($_SERVER['REMOTE_ADDR'], 'unknown')) { $ip=getenv('REMOTE_ADDR'); }
else{$ip='unknown';}
if($ip!='unknown'){ $ip=preg_replace("#[^0-9\.]+#i",'',$ip); }
$sip = substr($ip, 0, 3); //Начало IP
$cip=preg_replace("#[^0-9]+#i",'',$ip); //IP без точек

//Настройки системы
$wu_conf = mysqli_fetch_assoc(mysqli_query($connect_db, "SELECT id,sitename,theme,log_auth,log_act,log_fin FROM `".DB_PREFIX."_config` LIMIT 1"));

//Проверка авторизации
if (!isset($_SESSION['HTTP_USER_AGENT'])) { $_SESSION['HTTP_USER_AGENT'] = ''; }
if(!empty($_SESSION['uid']) && !empty($_SESSION['login']) && !empty($_SESSION['pas']) && $_SESSION['HTTP_USER_AGENT'] == md5($_SERVER['HTTP_USER_AGENT'])) {
$preuid = intval($_SESSION['uid']);
$nowuser = mysqli_fetch_assoc(mysqli_query($connect_db, "SELECT uid,log,pas,bal,av,ban FROM `".DB_PREFIX."_users` WHERE uid='$preuid' LIMIT 1"));
if ($_SESSION['pas'] == md5($nowuser['pas'])) {
define('USER_LOGGED',true);
$u_id = $nowuser['uid'];
$u_login = $nowuser['log'];
} else {
unset($_SESSION['uid']); unset($_SESSION['login']); unset($_SESSION['pas']); unset($_SESSION['ip']);
$u_id = 0;
define('USER_LOGGED',false); }
} else {
unset($_SESSION['uid']); unset($_SESSION['login']); unset($_SESSION['pas']); unset($_SESSION['ip']);
$u_id = 0;
define('USER_LOGGED',false); }

//Разное
$dt = time();
define('WEBUPPER', true);

//Функции

//Фильтрование
function wu_filter($text) {
return nl2br(htmlspecialchars($text));
}

//Окончания
function wu_end($number, $titles) {
$cases = array( 2, 0, 1, 1, 1, 2 );
return $titles[ ( $number % 100 > 4 && $number % 100 < 20 ) ? 2 : $cases[ min( $number % 10, 5 ) ] ];
}

//Шифрование
function wu_encode($unencoded,$key=LICENSE){
$string=base64_encode($unencoded);
$newstr = '';
$arr=array();
$x=0;
while ($x++ < strlen($string)) {
$arr[$x-1] = md5(md5($key.$string[$x-1]).$key);
$newstr = $newstr.$arr[$x-1][3].$arr[$x-1][6].$arr[$x-1][1].$arr[$x-1][2];
}
return $newstr;
}

//Расшифровка
function wu_decode($encoded, $key=LICENSE){
$strofsym='qwertyuiopasdfghjklzxcvbnm1234567890QWERTYUIOPASDFGHJKLZXCVBNM=+/';
$x=0;
while ($x++ < strlen($strofsym)) {
$tmp = md5(md5($key.$strofsym[$x-1]).$key);
$encoded = str_replace($tmp[3].$tmp[6].$tmp[1].$tmp[2], $strofsym[$x-1], $encoded);
}
return base64_decode($encoded);
}

//Лог авторизаций
function wu_log_auth($st, $msg) {
global $wu_conf;
global $dt;
global $connect_db;
$st = intval($st);
$msg = mysqli_real_escape_string($connect_db,$msg);
if ($wu_conf['log_auth'] == 1) { mysqli_query($connect_db, "INSERT INTO `".DB_PREFIX."_adm_auth` (st,msg,dt) VALUES ('$st','$msg','$dt')"); }
return true;
}

//Лог активности
function wu_log_act($ty, $msg) {
global $wu_conf;
global $dt;
global $connect_db;
global $u_id;
$ty = intval($ty);
$msg = mysqli_real_escape_string($connect_db,$msg);
if ($wu_conf['log_act'] == 1 || $wu_conf['log_act'] == 2 && $ty == 2) { mysqli_query($connect_db, "INSERT INTO `".DB_PREFIX."_adm_act` (usr,ty,msg,new,dt) VALUES ('$u_id','$ty','$msg','1','$dt');"); }
return true;
}

//Лог финансовых операций
function wu_log_fin($usr, $ty, $msg) {
global $wu_conf;
global $dt;
global $connect_db;
$usr = intval($usr);
$ty = intval($ty);
$msg = mysqli_real_escape_string($connect_db,$msg);
if ($wu_conf['log_fin'] == 1) { mysqli_query($connect_db, "INSERT INTO `".DB_PREFIX."_adm_operations` (usr,ty,new,msg,dt) VALUES ('$usr','$ty','1','$msg','$dt')"); }
return true;
}

//История финансовых операций
function wu_operation($usr, $ty, $sum, $msg) {
global $dt;
global $connect_db;
$usr = intval($usr);
$ty = intval($ty);
$sum = preg_replace("#[^0-9\.]+#i",'',$sum);
$msg = mysqli_real_escape_string($connect_db,$msg);
mysqli_query($connect_db, "INSERT INTO `".DB_PREFIX."_operations` (usr,ty,s,msg,dt) VALUES ('$usr','$ty','$sum','$msg','$dt')");
return true;
}

//Генерация токена
function wu_token_gen() {
global $u_id;
$salt = rand(0, 9999);
return $salt.':'.md5($salt.':'.$u_id.':'.LICENSE);
}

//Проверка токена
function wu_token() {
global $u_id;
if (empty($_REQUEST['token'])) { wu_log_act(2, 'Пытался выполнить действие с пустым токеном'); return false; } else {
$gtkn = explode(':', $_REQUEST['token']);
$vtkn = $gtkn['0'].':'.md5($gtkn['0'].':'.$u_id.':'.LICENSE);
if($_REQUEST['token'] != $vtkn) { wu_log_act(2, 'Пытался выполнить действие с недействительным токеном'); return false; }
}
return true;
}

//Для забаненного пользователя
if (!empty($nowuser['ban'])) {
$ban = explode('||', $nowuser['ban']);
if ($ban['0'] > 0 && $ban['0'] < $dt) { mysqli_query($connect_db, "UPDATE `".DB_PREFIX."_users` SET ban = '' WHERE uid='$u_id' LIMIT 1"); } else {
if ($ban['0'] == 0) { $block_date = 'навсегда'; } else { $block_date = 'до '.date('d.m.Y H:i',$ban['0']); }
exit(wu_error_msg('Аккаунт '.$u_login.' заблокирован '.$block_date.' по следующей причине: '.$ban['1']));
}
}
