<?php
if(!defined('WEBUPPER')){ exit; }

//Класс Паера
class CPayeer
{
	private $url = 'https://payeer.com/ajax/api/api.php';
	private $agent = 'Mozilla/5.0 (Windows NT 6.1; rv:12.0) Gecko/20100101 Firefox/12.0';

	private $auth = array();

	private $output;
	private $errors;
	private $language = 'ru';

	public function __construct($account, $apiId, $apiPass)
	{
		$arr = array(
			'account' => $account,
			'apiId' => $apiId,
			'apiPass' => $apiPass,
		);

		$response = $this->getResponse($arr);

		if ($response['auth_error'] == '0')
		{
			$this->auth = $arr;
		}
	}

	public function isAuth()
	{
		if (!empty($this->auth)) return true;
		return false;
	}

	private function getResponse($arPost)
	{
		if (!function_exists('curl_init'))
		{
		   die('curl library not installed');
		   return false;
		}

		if ($this->isAuth())
		{
			$arPost = array_merge($arPost, $this->auth);
		}

		$data = array();
		foreach ($arPost as $k => $v)
		{
			$data[] = urlencode($k) . '=' . urlencode($v);
		}
		$data[] = 'language=' . $this->language;
		$data = implode('&', $data);

		$handler  = curl_init();
		curl_setopt($handler, CURLOPT_URL, $this->url);
		curl_setopt($handler, CURLOPT_HEADER, 0);
		curl_setopt($handler, CURLOPT_POST, true);
		curl_setopt($handler, CURLOPT_POSTFIELDS, $data);
		curl_setopt($handler, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($handler, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($handler, CURLOPT_USERAGENT, $this->agent);
		curl_setopt($handler, CURLOPT_RETURNTRANSFER, 1);

		$content = curl_exec($handler);
		//print_r($content);

		$arRequest = curl_getinfo($handler);
		//print_r($arRequest);

		curl_close($handler);
		//print_r($content);

		$content = json_decode($content, true);

		if (isset($content['errors']) && !empty($content['errors']))
		{
			$this->errors = $content['errors'];
		}

		return $content;
	}

	public function getPaySystems()
	{
		$arPost = array(
			'action' => 'getPaySystems',
		);

		$response = $this->getResponse($arPost);

		return $response;
	}

	public function initOutput($arr)
	{
		$arPost = $arr;
		$arPost['action'] = 'initOutput';

		$response = $this->getResponse($arPost);

		if (empty($response['errors']))
		{
			$this->output = $arr;
			return true;
		}

		return false;
	}

	public function output()
	{
		$arPost = $this->output;
		$arPost['action'] = 'output';

		$response = $this->getResponse($arPost);

		if (empty($response['errors']))
		{
			return $response['historyId'];
		}

		return false;
	}

	public function getHistoryInfo($historyId)
	{
		$arPost = array(
			'action' => 'historyInfo',
			'historyId' => $historyId
		);

		$response = $this->getResponse($arPost);

		return $response;
	}

	public function getBalance()
	{
		$arPost = array(
			'action' => 'balance',
		);

		$response = $this->getResponse($arPost);

		return $response;
	}

	public function getErrors()
	{
		return $this->errors;
	}

	public function transfer($arPost)
	{
		$arPost['action'] = 'transfer';

		$response = $this->getResponse($arPost);

		return $response;
	}

	public function SetLang($language)
	{
		$this->language = $language;
		return $this;
	}

	public function getShopOrderInfo($arPost)
	{
		$arPost['action'] = 'shopOrderInfo';

		$response = $this->getResponse($arPost);

		return $response;
	}

	public function checkUser($arPost)
	{
		$arPost['action'] = 'checkUser';

		$response = $this->getResponse($arPost);

		if (empty($response['errors']))
		{
			return true;
		}

		return false;
	}

	public function getExchangeRate($arPost)
	{
		$arPost['action'] = 'getExchangeRate';

		$response = $this->getResponse($arPost);

		return $response;
	}

	public function merchant($arPost)
	{
		$arPost['action'] = 'merchant';

		$arPost['shop'] = json_encode($arPost['shop']);
		$arPost['form'] = json_encode($arPost['form']);
		$arPost['ps'] = json_encode($arPost['ps']);

		if (empty($arPost['ip'])) $arPost['ip'] = $_SERVER['REMOTE_ADDR'];

		$response = $this->getResponse($arPost);

		if (empty($response['errors']))
		{
			return $response;
		}

		return false;
	}
}
$keys_out = explode('||', $paysys['keys_out']);
$accountNumber = $keys_out[0];
$apiId = $keys_out[1];
$apiKey = $keys_out[2];
$payeer = new CPayeer($accountNumber, $apiId, $apiKey);
if ($payeer->isAuth())
{
    $arBalance = $payeer->getBalance();
//  $acc_balance = $arBalance['balance']['RUB']['DOSTUPNO']; //Баланс аккаунта, можете использовать в уведомлениях администации
	$arTransfer = $payeer->transfer(array(
		'curIn' => 'RUB',
		'sum' => $sum,
		'curOut' => 'RUB',
		'to' => $purse,
		'comment' => 'Вывод средств с сайта '.SITE,
		'anonim' => 'Y'
	));
	if (empty($arTransfer['errors']))
	{
mysqli_query($connect_db, "UPDATE `".DB_PREFIX."_users` SET `bal` = `bal`-'$sum' WHERE uid = '$u_id' LIMIT 1");
wu_operation($u_id, 3, $sum, "Вывод средств на кошелёк $purse через платёжную систему Payeer");
wu_log_fin($u_id, 2, "Вывел $sum руб. на кошелёк $purse через платёжную систему Payeer");
exit('1');
	}
	else
	{
$err = $payeer->getErrors();
wu_log_act(2, 'Ошибка при выводе средств через платёжную систему Payeer. Текст ошибки: '.$err[0]); exit('wu-error');
	}
}
else
{
$err = $payeer->getErrors();
wu_log_act(2, 'Ошибка при выводе средств через платёжную систему Payeer. Текст ошибки: '.$err[0]); exit('wu-error');
}
exit('1');
?>