<?php

namespace JBBCode;

require_once 'CodeDefinition.php';
require_once 'CodeDefinitionBuilder.php';
require_once 'CodeDefinitionSet.php';
require_once 'validators/CssColorValidator.php';
require_once 'validators/UrlValidator.php';
require_once 'validators/VideoValidator.php';
require_once 'validators/WUnormalize.php';

class DefaultCodeDefinitionSet implements CodeDefinitionSet
{

    /** @var CodeDefinition[] The default code definitions in this set. */
    protected $definitions = array();

    /**
     * Constructs the default code definitions.
     */
    public function __construct()
    {
        /* [b] bold tag */
        $builder = new CodeDefinitionBuilder('b', '<b>{param}</b>');
        $this->definitions[] = $builder->build();

        /* [i] italics tag */
        $builder = new CodeDefinitionBuilder('i', '<em>{param}</em>');
        $this->definitions[] = $builder->build();

        /* [u] underline tag */
        $builder = new CodeDefinitionBuilder('u', '<u>{param}</u>');
        $this->definitions[] = $builder->build();
		
		$builder = new CodeDefinitionBuilder('s', '<strike>{param}</strike>');
        $this->definitions[] = $builder->build();
		
		$builder = new CodeDefinitionBuilder('sup', '<sup>{param}</sup>');
        $this->definitions[] = $builder->build();
				
		$builder = new CodeDefinitionBuilder('sub', '<sub>{param}</sub>');
        $this->definitions[] = $builder->build();
		
		$builder = new CodeDefinitionBuilder('table', '<table class="table table-bordered">{param}</table>');
        $this->definitions[] = $builder->build();
		
		$builder = new CodeDefinitionBuilder('tr', '<tr>{param}</tr>');
        $this->definitions[] = $builder->build();
		
		$builder = new CodeDefinitionBuilder('td', '<td>{param}</td>');
        $this->definitions[] = $builder->build();
		
		$builder = new CodeDefinitionBuilder('list', '<ul>{param}</ul>');
        $this->definitions[] = $builder->build();
		
		$builder = new CodeDefinitionBuilder('numlist', '<ol>{param}</ol>');
        $this->definitions[] = $builder->build();
		
		$builder = new CodeDefinitionBuilder('*', '<li>{param}</li>');
        $this->definitions[] = $builder->build();
		
        $urlValidator = new \JBBCode\validators\UrlValidator();
		$VideoValidator = new \JBBCode\validators\VideoValidator();
		$CssColorValidator = new \JBBCode\validators\CssColorValidator();
		$WUnormalize = new \JBBCode\validators\WUnormalize();
		
        /* [url] link tag */
        $builder = new CodeDefinitionBuilder('url', '<a href="/wu-engine/away?url={param}" target="_blank" rel="nofollow">{param}</a>');
        $builder->setParseContent(false)->setBodyValidator($urlValidator);
        $this->definitions[] = $builder->build();

        /* [url=http://example.com] link tag */
        $builder = new CodeDefinitionBuilder('url', '<a href="/wu-engine/away?url={option}" target="_blank" rel="nofollow">{param}</a>');
        $builder->setUseOption(true)->setParseContent(true)->setOptionValidator($urlValidator);
        $this->definitions[] = $builder->build();

        /* [img] image tag */
        $builder = new CodeDefinitionBuilder('img', '<div class="lightgallerys"><a href="{param}"><img src="{param}" class="postimg" /></a></div>');
        $builder->setUseOption(false)->setParseContent(false)->setBodyValidator($urlValidator);
        $this->definitions[] = $builder->build();

        /* [img=alt text] image tag */
        $builder = new CodeDefinitionBuilder('img', '<div class="lightgallerys"><a href="{param}" data-sub-html="{option}"><img src="{param}" alt="{option}" class="postimg" /></a></div>');
        $builder->setUseOption(true)->setParseContent(false)->setBodyValidator($urlValidator)->setOptionValidator($WUnormalize);
        $this->definitions[] = $builder->build();
		
		/* [video] video tag */
        $builder = new CodeDefinitionBuilder('video', '<iframe class="video_embed" src="https://www.youtube.com/embed/{param}" frameborder="0" allowfullscreen></iframe>');
        $builder->setUseOption(false)->setParseContent(false)->setBodyValidator($VideoValidator);
        $this->definitions[] = $builder->build();
		
		
		/* [spoiler] spoiler tag */
        $builder = new CodeDefinitionBuilder('spoiler', '<div class="panel panel-default marnone"><div class="panel-heading spoiler-btn"><h4 class="panel-title">Спойлер</h4></div><div class="panel-collapse collapse spoiler-body"><div class="panel-body">{param}</div></div></div>');
        $this->definitions[] = $builder->build();

        /* [spoiler=title] spoiler tag */
        $builder = new CodeDefinitionBuilder('spoiler', '<div class="panel panel-default marnone"><div class="panel-heading spoiler-btn"><h4 class="panel-title">{option}</h4></div><div class="panel-collapse collapse spoiler-body"><div class="panel-body">{param}</div></div></div>');
        $builder->setUseOption(true);
        $this->definitions[] = $builder->build();

        /* [color] color tag */
        $builder = new CodeDefinitionBuilder('color', '<span style="color: {option}">{param}</span>');
        $builder->setUseOption(true)->setOptionValidator($CssColorValidator);
        $this->definitions[] = $builder->build();
		
		/* [size] size tag */
        $builder = new CodeDefinitionBuilder('size', '<font size="{option}">{param}</font>');
        $builder->setUseOption(true)->setOptionValidator($CssColorValidator);
        $this->definitions[] = $builder->build();
		
		/* [font] font tag */
        $builder = new CodeDefinitionBuilder('font', '<font face="{option}">{param}</font>');
        $builder->setUseOption(true)->setOptionValidator($CssColorValidator);
        $this->definitions[] = $builder->build();
		
		/* [left] left tag */
        $builder = new CodeDefinitionBuilder('left', '<p style="text-align:left">{param}</p>');
        $this->definitions[] = $builder->build();
		
		/* [center] center tag */
        $builder = new CodeDefinitionBuilder('center', '<p style="text-align:center">{param}</p>');
        $this->definitions[] = $builder->build();
		
		/* [right] right tag */
        $builder = new CodeDefinitionBuilder('right', '<p style="text-align:right">{param}</p>');
        $this->definitions[] = $builder->build();
		
		/* [quote] quote tag */
        $builder = new CodeDefinitionBuilder('quote', '<blockquote>{param}</blockquote>');
        $this->definitions[] = $builder->build();
		
		/* [code] code tag */
        $builder = new CodeDefinitionBuilder('code', '<pre class="prettyprint linenums">{param}</pre>');
        $this->definitions[] = $builder->build();

    }
    
    public function getCodeDefinitions()
    {
        return $this->definitions;
    }

}
