<?php
function bbConfig()
{
return array(
'max_len' => 150,
'links' => true,
'images' => true,
'setup_bb' => array(
'[b]' => '[/b]',
'[i]' => '[/i]',
'[u]' => '[/u]',
'[left]' => '[/left]',
'[right]' => '[/right]',
'[center]' => '[/center]',
'[quote]' => '[/quote]',
'[h=5]' => '[/h=5]',
'[h=4]' => '[/h=4]',
'[h=3]' => '[/h=3]',
'[h=2]' => '[/h=2]',
'[h=1]' => '[/h=1]',
),
'setup_html' => array(
'<b>' => '</b>',
'<i>' => '</i>',
'<u>' => '</u>',
'<p align="left">' => '</p>',
'<p align="right">' => '</p>',
'<center>' => '</center>',
'<blockquote>' => '</blockquote>',
'<h5>' => '</h5>',
'<h4>' => '</h4>',
'<h3>' => '</h3>',
'<h2>' => '</h2>',
'<h1>' => '</h1>',
)
);
}
class IRB_BBdecoder
{
private $bb_open;
private $bb_close;
private $html_open;
private $html_close;
private $html_single;
private $tmp_open;
private $tmp_close;
private $tmp_single;
private $max_len;
private $links;
private $images;
public function __construct()
{
$config   = bbConfig();
extract($config);
$confrepl = configReplace();
extract($confrepl);
$this->bb_open = array_keys($setup_bb);
$this->bb_close = array_values($setup_bb);
$this->html_open = array_keys($setup_html);
$this->html_close = array_values($setup_html);
$this->tmp_open = $tmp_open;
$this->tmp_close = $tmp_close;
$this->tmp_single = $tmp_single;
$this->max_len = $max_len;
$this->links = $links;
$this->images = $images;
}
public function createBBtags($text)
{
$text = str_replace($this->tmp_open, '', $text);
$text = str_replace($this->tmp_close, '', $text);
$text = str_replace($this->tmp_single, '', $text);
$text = str_replace("\r", "", $text);
$text = str_replace("\t", "    ", $text);
$text = str_ireplace($this->bb_open, $this->tmp_open, $text);
$text = str_ireplace($this->bb_close, $this->tmp_close, $text);
$open_cnt = array();
foreach($this->tmp_open as $k => $v)
{
$text = preg_replace("#". $v ."\s*?". $this->tmp_close[$k] ."#us", "", $text);
$cnt = substr_count($text, $v);
if($cnt > 0)
{
$open_cnt[$v] = $cnt;
$close_cnt[$v] = substr_count($text, $this->tmp_close[$k]);
}
}
foreach($open_cnt as $k => $v)
{
if($v > $close_cnt[$k])
{
for($i = 0; $i < $v - $close_cnt[$k]; ++$i)
$text = preg_replace('#'. $k .'(?!.*'. $k .')#us', '', $text);
}
}
$text = $this->mBwordwrap($text, $this->max_len);
$text = htmlspecialchars($text);
if($this->links)
{
$text = preg_replace_callback('#\[url=http(s*)://([^\] ]+?)\](.+?)\[/url\]#si',
array($this, 'createLink1'),
$text
);
$text = preg_replace_callback('#\[url\]http(s*)://(.+?)\[/url\]#si',
array($this, 'createLink2'),
$text
);
}
if($this->images)
{
$text = preg_replace_callback('#\[img=([^\]]+?)\]https?://([^\] \?]+?)\[/img\]#si',
array($this, 'createImg1'),
$text);
$text = preg_replace_callback('#\[img\]https?://([^\] \?]+?)\[/img\]#si',
array($this, 'createImg2'),
$text
);
}
$text = str_replace($this->tmp_open, $this->html_open, $text);
$text = str_replace($this->tmp_close, $this->html_close, $text);
$text = str_replace($this->tmp_single, $this->html_single, $text);
$text = str_replace('  ', '&nbsp;&nbsp;', $text);
$text = nl2br($text);
return $text;
}
public function stripBBtags($text)
{
$text = str_replace($this->bb_open, '', $text);
$text = str_replace($this->bb_close, '', $text);
$text = str_replace($this->bb_single, '', $text);
$text = preg_replace('#\\[(code|url|img|html)[^\s]*?\].*?\[/\\1\]#usi', '', $text);
return $text;
}
public function mBwordwrap($text, $width = 74, $break = "\n")
{
return preg_replace('#([^\s]{'. $width .'})#u', '$1'. $break , $text);
}
private function createLink1($match)
{
$match[2] = str_replace("\n", "", $match[2]);
return '<a href="http://'.SITE.'/away?baseurl='.base64_encode('http'. $match[1] .'://'. htmlspecialchars($match[2])) . '" target="_blank" rel="noreferrer nofollow">'. htmlspecialchars($match[3]) .'</a>';
}
private function createLink2($match)
{
$match[2] = str_replace("\n", "", $match[2]);
return '<a href="http://'.SITE.'/away?baseurl='.base64_encode('http'. $match[1] .'://'. htmlspecialchars($match[2])) . '" target="_blank" rel="noreferrer nofollow">'. htmlspecialchars($match[2]) .'</a>';
}
private function createImg1($match)
{
$match[2] = str_replace("\n", "", $match[2]);
return '<div class="lightgallerys"><a href="http://'. htmlspecialchars($match[2]) .'" data-sub-html="'. htmlspecialchars($match[1]) .'"><img class="postimg" src="http://'. htmlspecialchars($match[2]) .'" border="0" alt="'. htmlspecialchars($match[1]) .'" title="'. htmlspecialchars($match[1]) .'" /></a></div>';
}
private function createImg2($match)
{
$match[1] = str_replace("\n", "", $match[1]);
return '<div class="lightgallerys"><a href="http://'. htmlspecialchars($match[1]) .'"><img class="postimg" src="http://'. htmlspecialchars($match[1]) .'" border="0" /></a></div>';
}
}
function configReplace()
{
return array(
'tmp_open'   => array(
'ᐁ', 'ᐂ', 'ᐃ', 'ᐄ', 'ᐅ', 'ᐆ', 'ᐇ', 'ᐉ', 'ᐊ', 'ᐋ',
'ᐌ', 'ᐍ', 'ᐎ', 'ᐏ', 'ᐐ', 'ᐑ', 'ᐒ', 'ᐓ', 'ᐔ', 'ᐕ',
'ᐫ', 'ᐬ', 'ᐭ', 'ᐮ', 'ᐯ', 'ᐰ', 'ᐱ', 'ᐲ', 'ᐳ', 'ᐴ',
'ᐵ', 'ᐷ', 'ᐸ', 'ᐹ', 'ᐺ', 'ᐻ', 'ᐼ', 'ᐽ', 'ᐾ', 'ᐿ',
'ᑌ', 'ᑍ', 'ᑎ', 'ᑏ', 'ᑐ', 'ᑑ', 'ᑒ', 'ᑔ', 'ᑕ', 'ᑖ',
),
'tmp_close'  => array(
'ᑗ', 'ᑘ', 'ᑙ', 'ᑚ', 'ᑛ', 'ᑜ', 'ᑝ', 'ᑞ', 'ᑟ', 'ᑠ',
'ᑡ', 'ᑢ', 'ᑣ', 'ᑤ', 'ᑥ', 'ᑧ', 'ᑨ', 'ᑩ', 'ᑪ', 'ᑫ',
'ᑬ', 'ᑭ', 'ᑮ', 'ᑯ', 'ᑰ', 'ᑱ', 'ᑲ', 'ᑳ', 'ᑴ', 'ᑵ',
'ᑶ', 'ᑷ', 'ᑸ', 'ᑹ', 'ᑺ', 'ᑻ', 'ᑼ', 'ᑽ', 'ᑾ', 'ᑿ',
'ᒀ', 'ᒁ', 'ᒂ', 'ᒌ', 'ᒍ', 'ᒎ', 'ᒏ', 'ᒐ', 'ᒑ', 'ᒒ',
),
'tmp_single' => array(
'ᒓ', 'ᒔ', 'ᒕ', 'ᒖ', 'ᒗ', 'ᒘ', 'ᒙ', 'ᒚ', 'ᒛ', 'ᒜ',
'ᒝ', 'ᒞ', 'ᒟ', 'ᒠ', 'ᒣ', 'ᒤ', 'ᒥ', 'ᒦ', 'ᒧ', 'ᒨ',
'ᒩ', 'ᒪ', 'ᒫ', 'ᒬ', 'ᒭ', 'ᒮ', 'ᒯ', 'ᒰ', 'ᒱ', 'ᒲ',
'ᒳ', 'ᒴ', 'ᒵ', 'ᒶ', 'ᒷ', 'ᒸ', 'ᒹ', 'ᒺ', 'ᓀ', 'ᓁ',
'ᓂ', 'ᓃ', 'ᓄ', 'ᓅ', 'ᓆ', 'ᓇ', 'ᓈ', 'ᓉ', 'ᓊ', 'ᓋ',
),
);
}