<?

function validate_phone_number($string) {
    if ( preg_match( '/^[+]?([\d]{0,3})?[\(\.\-\s]?([\d]{3})[\)\.\-\s]*([\d]{3})[\.\-\s]?([\d]{4})$/', $string ) ) {
        return true;
    } else {
        return false;
    }
}

function is_valid_credit_card($s) {
    // оставить только цифры
    $s = strrev(preg_replace('/[^\d]/','',$s));
 
    // вычисление контрольной суммы
    $sum = 0;
    for ($i = 0, $j = strlen($s); $i < $j; $i++) {
        // использовать четные цифры как есть
        if (($i % 2) == 0) {
            $val = $s[$i];
        } else {
            // удвоить нечетные цифры и вычесть 9, если они больше 9
            $val = $s[$i] * 2;
            if ($val > 9)  $val -= 9;
        }
        $sum += $val;
    }
 
    // число корректно, если сумма равна 10
    return (($sum % 10) == 0);
}

function FreeKassaCashout($data) {
	$wallet_id = 'Номер кошелька';
	$apikey = 'API ключ';
	$DataOUT = array(
		'wallet_id'=> 	$wallet_id,
		'purse'=> 		$data['purse'],
		'amount'=>	    $data['amount'],
		'desc'=> 		$data['desc'],
		'currency'=> 	$data['currency'],
		'sign'=> md5($wallet_id . $data['currency'] . $data['amount'] . $data['purse'] . $apikey),
		'action'=>'cashout',
	);
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, 'https://www.fkwallet.ru/api_v1.php');
	curl_setopt($ch, CURLOPT_HEADER, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_TIMEOUT, 10);
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $DataOUT);
	$result = trim(curl_exec($ch));
	$c_errors = curl_error($ch);
	curl_close($ch);
	return $result;
}


class FreeKassaHade
{
	const VERSION  = '1.1';
	const API_URL  = 'https://www.fkwallet.ru/api_v1.php';
	const INI_FILE = '/_system/_inifiles/freekassa.ini';
	
    public function __construct() {
		$this->FileConfig = $_SERVER['DOCUMENT_ROOT'] . self::INI_FILE;
		if (is_file($this->FileConfig)) {
			$this->config = parse_ini_file($this->FileConfig);
		} else {
			die('Freekassa: error - not ini file');
		}
	}
	public function data($data)
	{
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, self::API_URL);
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_TIMEOUT, 10);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		$result = trim(curl_exec($ch));
		$c_errors = curl_error($ch);
		$cc = curl_close($ch);
		$result = json_decode($result, TRUE);
		return $result;
	}
	public function status($id)
	{
		$data = array(
			'wallet_id'  => $this->config['wallet'],
			'payment_id' => $id,
			'sign' 		 => md5($this->config['wallet'] . $id . $this->config['apikey']),
			'action' 	 => 'get_payment_status',
		);
		return $this->data($data);
	}
	public function balans()
	{
		$data = array(
			'wallet_id'  => $this->config['wallet'],
			'sign' 		 => md5($this->config['wallet'] . $this->config['apikey']),
			'action' 	 => 'get_balance',
		);
		return $this->data($data);
	}
	public function cashout($data)
	{
		if (empty($data)) {
			return 'error options';
		}
		$DataOUT = array(
			'wallet_id' => $this->config['wallet'],
			'purse'		=> $data['purse'],
			'amount'	=> $data['amount'],
			'desc'		=> $data['desc'],
			'currency'	=> $data['currency'],
			'sign'		=> md5($this->config['wallet'] . $data['currency'] . $data['amount'] . $data['purse'] . $this->config['apikey']),
			'action'	=> 'cashout',
		);
		return $this->data($DataOUT);
	}
	public function tariff()
	{
		/*
		id : минимальная сумма :: коммиссия :: доп. сумма(фиксированная):: максимальная сумма :: название
		*/
		$ConfigPayment = array(
			
			'QIWI' 			=> '63::100::4::1::15000::QIWI кошелёк (RUB)',
			'QIWIUAH' 		=> '63::100::5::1::15000::QIWI кошелёк (UAH)',	
			//'QIWIKZT' 		=> '162::100::6::5::15000::QIWI кошелёк (KZT)',	
			
			//'WebMoneyWMR' 	=> '1::10::4::0::15000::WebMoney WMR',
			
			'YandexMoney' 	=> '45::10::0::0::15000::Яндекс.Деньги',
			'CardRU' 		=> '94::300::5::71::40000::Банковские карты VISA/MASTERCARD (RUB)',
			'Tele2' 		=> '132::10::1::5::15000::Баланс телефона Tele2',
			'Mts' 			=> '84::10::1::5::15000::Баланс телефона Mts',
			'Beeline' 		=> '83::10::1::5::15000::Баланс телефона Beeline',
			'Megafon' 		=> '82::10::1::5::15000::Баланс телефона Megafon',
			//'PayeerRUB' 	=> '114::10::5::0::15000::Payeer RUB',
			//'PayPal' 	=> '70::10::5::5::15000::PayPal',
			
		);
		return $ConfigPayment;
	}

	/*
	return
	array(3) {
	  ["answer"]=>
	  string(4) "info"
	  ["desc"]=>
	  string(33) "Заявка отправлена"
	  ["PaymentId"]=>
	  string(7) "4464508"
	}
	*/
	function getTransfer($amount = 100) 
	{
		$merchant_id = $this->config['merchant_id'];
		$s = md5($merchant_id . $this->config['secret_word']);
		$API_URL = "http://www.free-kassa.ru/api.php?currency=fkw&merchant_id={$merchant_id}&s={$s}&action=payment&amount=". $amount;
		
		$html_code = file_get_contents($API_URL);
		$xml = simplexml_load_string($html_code);
		$json = json_encode($xml);
		$array = json_decode($json,TRUE);
		return $array;
		/*
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $API_URL);
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_TIMEOUT, 10);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		$result = trim(curl_exec($ch));
		$c_errors = curl_error($ch);
		$cc = curl_close($ch);
		//xml to json
		$xml = simplexml_load_string($result);
		$json = json_encode($xml);
		$array = json_decode($json,TRUE);
		return $array;	*/
		
		
	}
}