<?php
html::title('Журнал модерации');
acms_header();
access('adlist');

if (config('PRIVATE_ADLIST') == 0){
  
  error('Модуль отключен администратором');
  redirect('/');
  
}

if (get('id')){
  
  get_check_valid();
  
  $adm = db::get_string("SELECT * FROM `ADLIST_MODERATION` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);
  
  if (isset($adm['ID'])){
    
    /*
    --------------------
    Одобрение объявления
    --------------------
    */
    
    if (get('get') == 'yes'){
      
      db::get_set("UPDATE `ADLIST` SET `MODERATION` = ? WHERE `ID` = ? LIMIT 1", [1, $adm['AD_ID']]);
      db::get_set("UPDATE `ADLIST_MODERATION` SET `ACT` = ? WHERE `ID` = ? LIMIT 1", [1, $adm['ID']]);
      
      $message = 'Поздравляем, ваше [url=/m/adlist/show/?id='.$adm['AD_ID'].']объявление[/url] одобрено и уже виден в списке объявлений.';
      messages::get(config('SYSTEM'), $adm['USER_ID'], $message, 0);
      
      success('Объявление одобрено');
      redirect('/m/adlist/moderation/');
      
    }
    
    if (get('get') == 'yes2'){
      
      db::get_set("UPDATE `ADLIST` SET `MODERATION` = ? WHERE `ID` = ? LIMIT 1", [1, $adm['AD_ID']]);
      db::get_set("UPDATE `ADLIST_MODERATION` SET `ACT` = ? WHERE `ID` = ? LIMIT 1", [1, $adm['ID']]);
      
      success('Объявление одобрено');
      redirect('/m/adlist/moderation/');
      
    }
    
    /*
    ---------------------
    Отклонение объявления
    ---------------------
    */
    
    if (get('get') == 'no'){
      
      db::get_set("UPDATE `ADLIST` SET `MODERATION` = ? WHERE `ID` = ? LIMIT 1", [2, $adm['AD_ID']]);
      db::get_set("UPDATE `ADLIST_MODERATION` SET `ACT` = ? WHERE `ID` = ? LIMIT 1", [3, $adm['ID']]);
      
      $message = 'Сожалеем, но в ходе проверки ваше [url=/m/adlist/show/?id='.$adm['AD_ID'].']объявление[/url] не было одобрено.';
      messages::get(config('SYSTEM'), $adm['USER_ID'], $message, 0);
      
      success('Объявление отклонено');
      redirect('/m/adlist/moderation/');
      
    }
    
    /*
    ---------------------------
    Отмена одобрения/отклонения
    ---------------------------
    */
    
    if (get('get') == 'cancel'){
      
      db::get_set("UPDATE `ADLIST` SET `MODERATION` = ? WHERE `ID` = ? LIMIT 1", [0, $adm['AD_ID']]);
      db::get_set("UPDATE `ADLIST_MODERATION` SET `ACT` = ? WHERE `ID` = ? LIMIT 1", [0, $adm['ID']]);

      redirect('/m/adlist/moderation/');
      
    }
    
  }
  
}

$column = db::get_column("SELECT COUNT(*) FROM `ADLIST_MODERATION`");
$spage = spage($column, PAGE_SETTINGS);
$page = page($spage);
$limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;

if ($column == 0){ 
  
  html::empty();
  
}else{
  
  ?><div class='list-body'><?
  
}

$data = db::get_string_all("SELECT * FROM `ADLIST_MODERATION` ORDER BY `TIME` DESC LIMIT ".$limit.", ".PAGE_SETTINGS);
while ($list = $data->fetch()) {
  
  $ad = db::get_string("SELECT `ID`,`NAME` FROM `ADLIST` WHERE `ID` = ? LIMIT 1", [$list['AD_ID']]);
  
  ?><div class='list-menu'><?
    
  if ($list['ACT'] == 2) {
    
    ?>
    <?=lg('Пользователь %s отредактировал объявление %s', '<b>'.user::login_mini($list['USER_ID']).'</b>', '<a href="/m/adlist/show/?id='.$ad['ID'].'">'.tabs($ad['NAME']).'</a>')?>
    <br /><br />
    <a href='/m/adlist/moderation/?id=<?=$list['ID']?>&get=yes2&<?=TOKEN_URL?>' class='btn'><?=icons('check', 15, 'fa-fw')?> <?=lg('Одобряю изменения')?></a>
    <a href='/m/adlist/show/?id=<?=$list['ID']?>&get=ban&<?=TOKEN_URL?>' class='btn'><?=icons('times', 15, 'fa-fw')?> <?=lg('Заблокировать')?></a>
    <?
      
  }elseif ($list['ACT'] == 0) {
    
    ?>
    <?=lg('Пользователь %s добавил объявление %s и ждет одобрения', '<b>'.user::login_mini($list['USER_ID']).'</b>', '<a href="/m/adlist/show/?id='.$ad['ID'].'">'.tabs($ad['NAME']).'</a>')?><br />
    <span class='info gray'><?=lg('На модерации')?></span>
    <br /><br />
    <a href='/m/adlist/moderation/?id=<?=$list['ID']?>&get=yes&<?=TOKEN_URL?>' class='btn'><?=icons('check', 15, 'fa-fw')?> <?=lg('Одобрить')?></a>
    <a href='/m/adlist/moderation/?id=<?=$list['ID']?>&get=no&<?=TOKEN_URL?>' class='btn'><?=icons('times', 15, 'fa-fw')?> <?=lg('Отклонить')?></a>
    <?
    
  }elseif ($list['ACT'] == 1) {
    
    ?>
    <?=lg('Пользователь %s добавил объявление %s и ждет одобрения', '<b>'.user::login_mini($list['USER_ID']).'</b>', '<a href="/m/adlist/show/?id='.$ad['ID'].'">'.tabs($ad['NAME']).'</a>')?><br />
    <span class='info green'><?=lg('Активно')?></span>
    <br /><br />  
    <a href='/m/adlist/moderation/?id=<?=$list['ID']?>&get=cancel&<?=TOKEN_URL?>' class='btn'><?=icons('times', 15, 'fa-fw')?> <?=lg('Отменить одобрение')?></a>
    <?
    
  }elseif ($list['ACT'] == 3) {
    
    ?>
    <?=lg('Пользователь %s добавил объявление %s и ждет одобрения', '<b>'.user::login_mini($list['USER_ID']).'</b>', '<a href="/m/adlist/show/?id='.$ad['ID'].'">'.tabs($ad['NAME']).'</a>')?><br />
    <span class='info red'><?=lg('Отклонено')?></span>
    <br /><br />  
    <a href='/m/adlist/moderation/?id=<?=$list['ID']?>&get=cancel&<?=TOKEN_URL?>' class='btn'><?=icons('times', 15, 'fa-fw')?> <?=lg('Отменить отклонение')?></a>
    <?
    
  }
    
  ?></div><?

}

if ($column > 0){
  
  ?></div><?
  
}

get_page('/m/adlist/moderation/?', $spage, $page);

back('/m/adlist/catalog/', 'К объявлениям');
acms_footer();