<?php 
$adlist = db::get_string("SELECT * FROM `ADLIST` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);
html::title('Редактировать объявление');
acms_header();
access('users');

if (!isset($adlist['ID'])) {
  
  error('Неверная директива');
  redirect('/m/adlist/');

}

if ($adlist['TIME_SEC'] < TM) {
  
  error('Срок жизни объявления истек');
  redirect('/m/adlist/show/?id='.$adlist['ID']);

}

if (config('PRIVATE_ADLIST') == 0){
  
  error('Модуль отключен администратором');
  redirect('/');
  
}

if (access('adlist', null) == false && $adlist['USER_ID'] != user('ID')){
  
  error('Нет прав');
  redirect('/m/adlist/');
  
}

if (post('ok_adlist')){
  
  valid::create(array(
    
    'ADLIST_NAME' => ['name', 'text', [2, 200], 'Название', 0],
    'ADLIST_MESSAGE' => ['message', 'text', [10, 10000], 'Описание', 0],
    'ADLIST_ID_CATEGORY' => ['id_cat', 'number', [0, 99999], 'Категория'],
    'ADLIST_SUM' => ['sum', 'number_abs', [0, 200000000], 'Цена'],
    'ADLIST_PHONE' => ['phone', 'text', [1, 18], 'Телефон', 0],
    'ADLIST_SITE' => ['site', 'text', [0, 100], 'Сайт', 0],
    'ADLIST_SOC' => ['soc', 'text', [0, 500], 'Соц.сети', 0],
    'ADLIST_C_S' => ['country_or_city', 'text', [0, 120], 'Страна или город', 0]
  
  ));
  
  if (db::get_column("SELECT COUNT(*) FROM `ADLIST_CATEGORIES` WHERE `ID` = ? LIMIT 1", [ADLIST_ID_CATEGORY]) == 0){
    
    error('Раздел не выбран');
    redirect('/m/adlist/edit/?id='.$adlist['ID']);
    
  }
  
  if (ADLIST_MESSAGE != $adlist['MESSAGE'] && db::get_column("SELECT COUNT(*) FROM `ADLIST` WHERE `MESSAGE` = ? LIMIT 1", [ADLIST_MESSAGE]) > 0){
    
    error('Объявление с таким содержимым уже существует');
    redirect('/m/adlist/edit/?id='.$adlist['ID']);
    
  }
  
  if (ERROR_LOG == 1){
    
    redirect('/m/adlist/edit/?id='.$adlist['ID']);
  
  }
  
  db::get_set("UPDATE `ADLIST` SET `NAME` = ?, `MESSAGE` = ?, `ID_CATEGORY` = ?, `COUNTRY_OR_CITY` = ?, `SOC` = ?, `PHONE` = ?, `SITE` = ?, `SUM` = ?, `TIME_EDIT` = ? WHERE `ID` = ? LIMIT 1", [ADLIST_NAME, ADLIST_MESSAGE, ADLIST_ID_CATEGORY, ADLIST_C_S, ADLIST_SOC, ADLIST_PHONE, ADLIST_SITE, ADLIST_SUM, TM, $adlist['ID']]);
  
  if (access('addlist', null) == false){
    
    db::get_add("INSERT INTO `ADLIST_MODERATION` (`USER_ID`, `ACT`, `TIME`, `AD_ID`) VALUES (?, ?, ?, ?)", [user('ID'), 2, TM, $adlist['ID']]);
    
  }
  
  if (access('addlist', null) == true){
    
    logs('Объявления - редактирование объявления [url=/m/adlist/show/?id='.$adlist['ID'].']'.$adlist['NAME'].'[/url]', user('ID'));
    
  }
  
  success('Изменения успешно приняты');
  redirect('/m/adlist/show/?id='.$adlist['ID']);
  
}

?>    
<div class='list'>
<form method='post' class='ajax-form' action='/m/adlist/edit/?id=<?=$adlist['ID']?>'>
<?
html::input('name', 'Название объявления', null, null, tabs($adlist['NAME']), 'form-control-100', 'text', null, 'bullhorn');
define('ACTION', '/m/adlist/edit/?id='.$adlist['ID']);
define('TYPE', 'adlist');
define('ID', $adlist['ID']);
html::textarea(tabs($adlist['MESSAGE']), 'message', 'Введите описание объявления', null, 'form-control-textarea', 9);  
?><br /><br /><?
$array = array();
$data = db::get_string_all("SELECT * FROM `ADLIST_CATEGORIES` ORDER BY `ID` DESC");  
while ($list = $data->fetch()){
  
  $array[$list['ID']] = [$list['NAME'], ($adlist['ID_CATEGORY'] == $list['ID'] ? "selected" : null)];

}
html::select('id_cat', $array, 'Раздел', 'form-control-100-modify-select', 'folder-open');
html::input('sum', 'Укажите цену', null, null, tabs($adlist['SUM']), 'form-control-30', 'text', null, 'money');
html::input('phone', 'Телефон', null, null, tabs($adlist['PHONE']), 'form-control-100', 'tel', null, 'phone');
html::input('site', 'Сайт', null, null, tabs($adlist['SITE']), 'form-control-100', 'text', null, 'link');
html::input('soc', 'Соц.сети (через запятую)', null, null, tabs($adlist['SOC']), 'form-control-100', 'text', null, 'link');
html::input('country_or_city', 'Страна или город', null, null, tabs($adlist['COUNTRY_OR_CITY']), 'form-control-100', 'text', null, 'globe');
html::button('button ajax-button', 'ok_adlist', 'plus', 'Добавить');  
?>
<a class='button-o' href='/m/adlist/users/?id=<?=user('ID')?>'><?=lg('Отмена')?></a>
<form>
</div>
<?
  
back('/m/adlist/');
acms_footer();