<?php   
html::title('Добавить объявление');
acms_header();

if (user('ID') == 0){
  
  html::empty('Для добавления объявления необходимо авторизоваться или зарегистрироваться', 'bullhorn');
  
  back('/m/adlist/');
  acms_footer();
  
}

if (config('PRIVATE_ADLIST') == 0){
  
  error('Модуль отключен администратором');
  redirect('/');
  
}

if (post('ok_adlist')){
  
  valid::create(array(
    
    'ADLIST_NAME' => ['name', 'text', [2, 200], 'Название', 0],
    'ADLIST_MESSAGE' => ['message', 'text', [10, 10000], 'Описание', 0],
    'ADLIST_ID_CATEGORY' => ['id_cat', 'number', [1, 99999], 'Раздел'],
    'ADLIST_SUM' => ['sum', 'number_abs', [0, 200000000], 'Цена'],
    'ADLIST_PHONE' => ['phone', 'text', [1, 18], 'Телефон', 0],
    'ADLIST_SITE' => ['site', 'text', [0, 100], 'Сайт', 0],
    'ADLIST_SOC' => ['soc', 'text', [0, 500], 'Соц.сети', 0],
    'ADLIST_C_S' => ['country_or_city', 'text', [0, 120], 'Страна или город', 0]
  
  ));
  
  if (db::get_column("SELECT COUNT(*) FROM `ADLIST_CATEGORIES` WHERE `ID` = ? LIMIT 1", [ADLIST_ID_CATEGORY]) == 0){
    
    error('Раздел не выбран');
    redirect('/m/adlist/add/');
    
  }
  
  if (db::get_column("SELECT COUNT(*) FROM `ADLIST` WHERE `MESSAGE` = ? LIMIT 1", [ADLIST_MESSAGE]) > 0){
    
    error('Объявление с таким содержимым уже существует');
    redirect('/m/adlist/add/');
    
  }
  
  if (ERROR_LOG == 1){
    
    redirect('/m/adlist/add/');
  
  }
  
  $tm = TM + 2592000;
  
  $ID = db::get_add("INSERT INTO `ADLIST` (`NAME`, `USER_ID`, `ID_CATEGORY`, `COUNTRY_OR_CITY`, `SOC`, `MESSAGE`, `TIME`, `TIME_SEC`, `PHONE`, `SITE`, `SUM`, `TIME_UPD`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", [ADLIST_NAME, user('ID'), ADLIST_ID_CATEGORY, ADLIST_C_S, ADLIST_SOC, ADLIST_MESSAGE, TM, $tm, ADLIST_PHONE, ADLIST_SITE, ADLIST_SUM, TM]);  
  db::get_add("INSERT INTO `ADLIST_MODERATION` (`USER_ID`, `ACT`, `TIME`, `AD_ID`) VALUES (?, ?, ?, ?)", [user('ID'), 0, TM, $ID]);
  
  if (db::get_column("SELECT COUNT(*) FROM `ATTACHMENTS` WHERE `TYPE_POST` = ? AND `ID_POST` = ? LIMIT 1", ['adlist', 0]) > 0){
    
    db::get_set("UPDATE `ATTACHMENTS` SET `ID_POST` = ?, `ACT` = '1' WHERE `USER_ID` = ? AND `ACT` = '0' AND `TYPE_POST` = ?", [$ID, user('ID'), 'adlist']);
  
  }
  
  success('Объявление отправлено на проверку. Вы получите уведомление в почту когда администрация примет решение');
  redirect('/m/adlist/users/?id='.user('ID'));
  
}

?>    
<div class='list'>
<form method='post' class='ajax-form' action='/m/adlist/add/'>
<?
html::input('name', 'Название объявления', null, null, null, 'form-control-100', 'text', null, 'bullhorn');
define('ACTION', '/m/adlist/add/');
define('TYPE', 'adlist');
define('ID', 0);
html::textarea(null, 'message', 'Введите описание объявления', null, 'form-control-textarea', 9);  
?><br /><br /><?
$array = array();
$data = db::get_string_all("SELECT * FROM `ADLIST_CATEGORIES` ORDER BY `ID` DESC");  
while ($list = $data->fetch()){
  
  $array[$list['ID']] = [$list['NAME'], (0 == $list['ID'] ? "selected" : null)];

}
html::select('id_cat', $array, 'Раздел', 'form-control-100-modify-select', 'folder-open');
html::input('sum', 'Укажите цену', null, null, null, 'form-control-30', 'text', null, 'money');
html::input('phone', 'Телефон', null, null, null, 'form-control-100', 'tel', null, 'phone');
html::input('site', 'Сайт', null, null, null, 'form-control-100', 'text', null, 'link');
html::input('soc', 'Соц.сети (через запятую)', null, null, null, 'form-control-100', 'text', null, 'link');
html::input('country_or_city', 'Страна или город', null, null, null, 'form-control-100', 'text', null, 'globe');
html::button('button ajax-button', 'ok_adlist', 'plus', 'Добавить');  
?>
<a class='button-o' href='/m/adlist/users/?id=<?=user('ID')?>'><?=lg('Отмена')?></a>
<form>
</div>
<?
  
back('/m/adlist/');
acms_footer();