<?

/**
 * проверяем, что функция mb_ucfirst не объявлена
 * и включено расширение mbstring (Multibyte String Functions)
 */
if (!function_exists('mb_ucfirst') && extension_loaded('mbstring'))
{
    /**
     * mb_ucfirst - преобразует первый символ в верхний регистр
     * @param string $str - строка
     * @param string $encoding - кодировка, по-умолчанию UTF-8
     * @return string
     */
    function mb_ucfirst($str, $encoding='UTF-8')
    {
        $str = mb_ereg_replace('^[\ ]+', '', $str);
        $str = mb_strtoupper(mb_substr($str, 0, 1, $encoding), $encoding).
               mb_substr($str, 1, mb_strlen($str), $encoding);
        return $str;
    }
}

/**
* @param $source - WM кошелек или WMID
* @param $type - wmid => wmid, purse => WM кошелек
* $wmid_to_wmid = wmid_info('911708189410', 'wmid');
* $wmr_to_wmid = wmid_info('R289951892735', 'purse');
* return array();
*/

function wmid_info($source, $type) 
{
  $request = '<request><' . $type . '>' . $source . '</' . $type . '></request>';
  $url = 'https://passport.webmoney.ru/xml/XMLGetWMIDInfo.aspx';
  $ch = curl_init($url);
  curl_setopt($ch, CURLOPT_HEADER, 0);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
  curl_setopt($ch, CURLOPT_POST,1);
  curl_setopt($ch, CURLOPT_POSTFIELDS, $request);
  $result = curl_exec($ch);
  $xmlres = simplexml_load_string($result);

  $array = array();
  $array['poscount'] = $xmlres->certinfo->claims->row['posclaimscount']; // Положительные отзывы
  $array['negcount'] = $xmlres->certinfo->claims->row['negclaimscount']; // Отрицательные отзывы
  $array['wmid'] = $xmlres->certinfo->wmids->row['wmid']; // WMID
  $array['level'] = $xmlres->certinfo->wmids->row['level']; // BL уровень
  $array['datereg'] = $xmlres->certinfo->wmids->row['datereg']; // Дата регистрации в системе
  $array['type'] = mb_ucfirst($xmlres->certinfo->attestat->row['typename']); // Тип аттестата
  $array['image'] = $xmlres->certinfo->urls->row['attestaticonurl']; // Иконка аттестата
  return $array;
}

function save_wmid_img($array) {
  global $system;
  
  $text = $array['type'] . "\nWMID: " . $array['wmid'] . "\nBL: " . $array['level'];
  $text2 = "Отзывы: " . $array['poscount'] . "\nПретензии: " . $array['negcount'] . "\nРегистрация: " . $array['datereg'];

  if (preg_match('/севд/i', $array['type'])) {
    $att = 1;
  } elseif (preg_match('/ормал/i', $array['type'])) {
    $att = 2;
  } elseif (preg_match('/ачал/i', $array['type'])) {
    $att = 3;
  } elseif (preg_match('/ерс/i', $array['type'])) {
    $att = 4;
  } elseif (preg_match('/рода/i', $array['type'])) {
    $att = 5;
  } else {
    $att = 0;
  }
  
  $text = $array['type'] . "\nWMID: " . $array['wmid'] . "\nBL: " . $array['level'] . " Отзывы/Претензии [" . $array['poscount'] . "/" . $array['negcount'] . "]";

  // Create objects
  $image = new Imagick(ROOT.'_images/wmid/template/' . $att . '.png');
  
  // Create a new drawing palette
  $draw = new ImagickDraw();
   
  // Set wmid_font_text properties
  $draw->setFont(ROOT.'_system/_tools/fonts/' . $system['wmid_font_text']);
  $draw->setFontSize($system['wmid_font_size']);
  $draw->setFillColor('black');
  
  // Position text at the bottom-right of the image
  //$draw->setGravity(Imagick::GRAVITY_SOUTH);
   
  // Draw text on the image
  $image->annotateImage($draw, 65, 17, 0, $text);
   
  // Set output image format
  $image->setImageFormat('png');

  if (@file_put_contents(ROOT.'_images/wmid/' . $array['wmid'] . '.png', $image)) {
    return true;
  } else {
    return false;
  }
}
?>