<?php
abstract class simpleDB
{
    /**
     * MySQLi object
     * @var MySQLi
     */
    protected $db_resource;
    /**
     * Method name to prepare data for select-like query
     * @var string
     */
    protected $returnMethod;
    /**
     * Assoc array with query info(affected_rows,num_rows,etc)
     * @var array
     */
    public $queryInfo;
    /**
     * @var MySQLi_STMT $stmp
     */
    protected $stmp;
    
    
  	public function esc($str){
      $str = str_replace('%', '%%', $str);
  		return mysqli_real_escape_string($this->db_resource, $str);
  	}
    
  	public function insert_id(){
  		return mysqli_insert_id($this->db_resource);
  	}

    /**
     * @param  $query
     * @return array|false
     */
    public function select($query)
    {
        $this->returnMethod = 'mysqliFetchAssoc';
        $arguments = func_get_args();
        $array = call_user_func_array(array($this, 's_query'), $arguments);
        
        if (is_array($array) && $array) {
          return $array;
        } else {
          return false;
        }
    }
	
    /**
     * @param  $query
     * @return array|false
     */
    public function fetch($query)
    {
      $this->returnMethod = 'mysqliFetchAssoc';
      $arguments = func_get_args();
      $array = call_user_func_array(array($this, 's_query'), $arguments);
	
  		if (isset($array[0])) {
  			return $array[0];
  		} else {
  			return false;
  		}
    }
	
	/**
	* Вернет колличество строк
	*/
	
    public function selectCount($query)
	{
        $this->returnMethod = 'mysqliFetchCol';
        $arguments = func_get_args();
        $array = call_user_func_array(array($this, 's_query'), $arguments);
		return $array[0];
	}

    /**
     * @param  $query
     * @return array|false
     */
    public function selectCol($query)
    {
        $this->returnMethod = 'mysqliFetchCol';
        $arguments = func_get_args();
        return call_user_func_array(array($this, 's_query'), $arguments);
    }

    /**
     * @param  $query
     * @return string
     */
    public function selectCell($query)
    {
        $this->returnMethod = 'mysqliFetchCell';
        $arguments = func_get_args();
        return call_user_func_array(array($this, 's_query'), $arguments);
    }

    /**
     * @param  $query
     * @return array|false
     */
    public function selectRow($query)
    {
        $this->returnMethod = 'mysqliFetchRow';
        $arguments = func_get_args();
        return call_user_func_array(array($this, 's_query'), $arguments);
    }

    /**
     * @param  $query
     * @return boolean
     */
    public function update($query)
    {
        $arguments = func_get_args();
        return call_user_func_array(array($this, 'i_query'), $arguments);
    }

     /**
     * @param  $query
     * @return boolean
     */
    public function insert($query)
    {
        $arguments = func_get_args();
        return call_user_func_array(array($this, 'i_query'), $arguments);
    }

     /**
     * @param  $query
     */
    public function replace($query)
    {
        $arguments = func_get_args();
        return call_user_func_array(array($this, 'i_query'), $arguments);
    }
    
     /**
     * @param  $query
     * @return boolean
     */
    public function delete($query)
    {
        $arguments = func_get_args();
        return call_user_func_array(array($this, 'i_query'), $arguments);
    }

}