<?

/*
* Функция обработки текста для вывода
*/

function text($str) {
$str = html_entity_decode($str, ENT_QUOTES, 'UTF-8');
//if ($html)$str=htmlentities($str, ENT_QUOTES, 'UTF-8');
//$str=esc($str);
	return stripcslashes(stripcslashes(htmlspecialchars($str)));
}

/**
* Вырезает все нечитаемые символы
*/

function esc($text, $br = NULL) {  
  if ($br != NULL) {
    for ($i = 0; $i <= 31; $i++) { 
      $text = str_replace(chr($i), NULL, $text);
    }
  } else {
    for ($i = 0; $i < 10; $i++){
      $text = str_replace(chr($i), NULL, $text);
    }
    for ($i = 11; $i < 20; $i++) {
      $text = str_replace(chr($i), NULL, $text);
    }
    for ($i = 21; $i <= 31; $i++){
      $text = str_replace(chr($i), NULL, $text);
    }
  }
  return $text;
}

/**
* Обработка ссылок
*/
function links_preg1($arr)
{
	if (preg_match('#^http://' . preg_quote($_SERVER['HTTP_HOST']) . '#',$arr[1]) || !preg_match('#://#',$arr[1]))
	return '<a href="' . $arr[1] . '">' . $arr[2] . '</a>';
	else
	return '<a target="_blank" href="http://' . $_SERVER['HTTP_HOST'] . '/?func=redirect.url&amp;ByShop4i4iRu=' . base64_encode(html_entity_decode($arr[1])) . '">' . $arr[2] . '</a>';
}

function links_preg2($arr)
{
	if (preg_match('#^https://' . preg_quote($_SERVER['HTTP_HOST']) . '#',$arr[2]) || preg_match('#^http://' . preg_quote($_SERVER['HTTP_HOST']) . '#',$arr[2]))
	return $arr[1] . '<a href="' . $arr[2] . '">' . $arr[2] . '</a>' . $arr[4];
	else
	return $arr[1] . '<a target="_blank" href="http://' . $_SERVER['HTTP_HOST'] . '/?func=redirect.url&amp;ByShop4i4iRu=' . base64_encode(html_entity_decode($arr[2])) . '">Ссылка</a>' . $arr[4];
}

function links($msg)
{
	$msg = preg_replace_callback('/\[url=((?!javascript:|data:|document.cookie).+)\](.+)\[\/url\]/isU', 'links_preg1', $msg);
	$msg = preg_replace_callback('~(^|\s)([a-z]+://([^ \r\n\t`\'"]+))(\s|$)~iu', 'links_preg2', $msg);
	return $msg;
}

/**
*  Вывод обработанного текста
*/
function text_out($str) {
  
  $str = links(text($str));
  
  // Список смайлов
  $smiles = array(
  '=P' => '1', 
  '=)|:)|:-)' => '2', 
  '.plak.|.плак.' => '3', 
  '=D|:D|:-D' => '4',
  '.lol.|.лол.' => '5',
  '.mig.|.миг.' => '6',
  '.zlo.|.зло.' => '7',
  '.gruz.|.груз.' => '8',
  '.gg.|.гг.' => '9',
  '.bye.|.пока.' => '10',
  '.ванг.' => '11',
  '.данет.' => '12',
  '.дану.' => '13',
  '.жиес.' => '14',
  '.зашто.' => '15',
  '.зол.' => '16',
  '.лах.' => '17',
  '.лис.' => '18',
  '.ммм.' => '19',
  '.нига.' => '20',
  '.норм.' => '21',
  '.ого.' => '22',
  '.спуди.' => '23',
  '.шта.' => '24'
  );
  
  foreach ($smiles AS $key => $value) {
    $array = explode("|", $key);
    
    for ($i = 0; $i < count($array); $i++)
		{
      $str = str_replace($array[$i], '<img src="/_images/smiles/' . $value . '.gif" alt="*" />', $str);
    }
  }
  
	$bbcode = array();
	$bbcode['/\[i\](.+)\[\/i\]/isU'] = '<em>$1</em>';
	$bbcode['/\[b\](.+)\[\/b\]/isU'] = '<strong>$1</strong>';
	$bbcode['/\[u\](.+)\[\/u\]/isU'] = '<span style="text-decoration:underline;">$1</span>';
	$bbcode['/\[s\](.+)\[\/s\]/isU'] = '<span style="text-decoration: line-through;">$1</span>';
	$bbcode['/\[big\](.+)\[\/big\]/isU'] = '<span style="font-size:large;">$1</span>';
	$bbcode['/\[small\](.+)\[\/small\]/isU'] = '<span style="font-size:small;">$1</span>';
	$bbcode['/\[red\](.+)\[\/red\]/isU'] = '<span style="color:#ff0000;">$1</span>';
	$bbcode['/\[yellow\](.+)\[\/yellow\]/isU'] = '<span style="color:#ffff22;">$1</span>';
	$bbcode['/\[green\](.+)\[\/green\]/isU'] = '<span style="color:#00bb00;">$1</span>';
	$bbcode['/\[blue\](.+)\[\/blue\]/isU'] = '<span style="color:#0000bb;">$1</span>';
	$bbcode['/\[white\](.+)\[\/white\]/isU'] = '<span style="color:#ffffff;">$1</span>';
	$bbcode['/\[fix\]/isU']='<img src="/_images/bb/bb.fix.png" alt="fix" />';
	$bbcode['/\[add\]/isU'] = '<img src="/_images/bb/bb.add.png" alt="add" />';
	$bbcode['/\[change\]/isU'] = '<img src="/_images/bb/bb.change.png" alt="change" />';
	$bbcode['/\[del\]/isU'] = '<img src="/_images/bb/bb.del.png" alt="del" />';
	$bbcode['/\[notice\]/isU'] = '<img src="/_images/bb/bb.notice.png" alt="notice" />';
	$bbcode['/\[secure\]/isU'] = '<img src="/_images/bb/bb.secure.png" alt="secure" />';
	$bbcode['/\[youtube\](.+)\[\/youtube\]/isU']='<iframe width="240" height="150" src="//www.youtube.com/embed/$1?modestbranding=1;rel=0;autohide=1;controls=1;" frameborder="0" allowfullscreen></iframe>';

	$str = preg_replace(array_keys($bbcode), array_values($bbcode), $str);



	// Перенос только на одну строку
	// $str = preg_replace("#((<br( ?/?)>)|\n|\r)+#i", '<br />', $str);
	//$str = str_replace(" ", "&nbsp;&nbsp;", $str);
	
	//\t
	//$str = str_replace("\t", "  ", $str);
	
	//$str = str_replace(array("\r\n", "\r", "\n"), ' ', $str);
	$str = preg_replace('%((?:\r\n|\r|\n){3})[\r\n]+%', '$1', $str);
	//$str = str_replace("	", "&nbsp;&nbsp;&nbsp;&nbsp;", $str);
	//$str = str_replace("	", "&nbsp;&nbsp;", $str);
	
	$str = nl2br($str);
	
	return $str;
}

/*
* Не стал придумывать велосипед
* Подсчет колличества символов с учетом кириллицы 
*/


function strlen2($str) {
  $str = str_replace(' ', '', $str);
  
	$rus = array('й','ц','у','к','е','н','г','ш','щ','з','х','ъ','ф','ы','в','а','п','р','о','л','д','ж','э','я','ч','с','м','и','т','ь','б','ю','Й','Ц','У','К','Е','Н','Г','Ш','Щ','З','Х','Ъ','Ф','Ы','В','А','П','Р','О','Л','Д','Ж','Э','Я','Ч','С','М','И','Т','Ь','Б','Ю');
	return strlen(str_replace($rus, '0', $str));
}

// Ретранслируем русских букв на латиницу
function OnlineShop($str) {
    $tr_te = array(
        "А"=>"a","Б"=>"b","В"=>"v","Г"=>"g",
        "Д"=>"d","Е"=>"e","Ж"=>"j","З"=>"z","И"=>"i",
        "Й"=>"y","К"=>"k","Л"=>"l","М"=>"m","Н"=>"n",
        "О"=>"o","П"=>"p","Р"=>"r","С"=>"s","Т"=>"t",
        "У"=>"u","Ф"=>"f","Х"=>"h","Ц"=>"ts","Ч"=>"ch",
        "Ш"=>"sh","Щ"=>"sch","Ъ"=>"","Ы"=>"yi","Ь"=>"",
        "Э"=>"e","Ю"=>"yu","Я"=>"ya","а"=>"a","б"=>"b",
        "в"=>"v","г"=>"g","д"=>"d","е"=>"e","ж"=>"j",
        "з"=>"z","и"=>"i","й"=>"y","к"=>"k","л"=>"l",
        "м"=>"m","н"=>"n","о"=>"o","п"=>"p","р"=>"r",
        "с"=>"s","т"=>"t","у"=>"u","ф"=>"f","х"=>"h",
        "ц"=>"ts","ч"=>"ch","ш"=>"sh","щ"=>"sch","ъ"=>"y",
        "ы"=>"y","ь"=>"","э"=>"e","ю"=>"yu","я"=>"ya"
    );
	
    if (preg_match('/[^A-Za-z0-9\_\-]/', $str)) 
	{
        $str = strtr($str,$tr_te);
        $str = preg_replace('/[^A-Za-z0-9\_\-\.]/', '', $str);
    }
    return $str;
}


function latin($in) {
	$trans1 = array("'",'"','`',',',' ',"Ё","Ж","Ч","Ш","Щ","Э","Ю","Я","ё","ж","ч","ш","щ","э","ю","я","А","Б","В","Г","Д","Е","З","И","Й","К","Л","М","Н","О","П","Р","С","Т","У","Ф","Х","Ц","Ь","Ы","а","б","в","г","д","е","з","и","й","к","л","м","н","о","п","р","с","т","у","ф","х","ц","ь","ы");
	$trans2 = array('_','_','_','_','_',"JO","ZH","CH","SH","SCH","Je","Jy","Ja","jo","zh","ch","sh","sch","je","jy","ja","A","B","V","G","D","E","Z","I","J","K","L","M","N","O","P","R","S","T","U","F","H","C","","Y","a","b","v","g","d","e","z","i","j","k","l","m","n","o","p","r","s","t","u","f","h","c","","y");
	
	return str_replace($trans1, $trans2, $in);
}

/**
* Обрезаем текст
*/

function text_str($text, $maxwords = 15, $maxchar = 100) {
  $sep = ' ';
  $sep2 = '...';
  $words = explode($sep, $text);
  $char = iconv_strlen($text, 'utf-8');
  
  if (count($words) > $maxwords) {
    $text = join($sep, array_slice($words, 0, $maxwords));
  }
  
  if ($char > $maxchar) {
    $text = iconv_substr( $text, 0, $maxchar, 'utf-8' );
  }

  return text_out($text) . $sep2;
}

/*
*
* Преобразовывает строку $text в строку-градиент
* начиная с цвета $from и заканчивая цветом $to
* Поддерживает работу как и с rgb режимом так и с hex
*
* @param    string  $text - сама строка
* @param    string  $from - начальный цвет
* @param    string  $to   - Конечный цвет
* @param    string  $mode - Режим, по умолчанию hex
*/
function gradient($text, $from = '', $to = '', $mode = "hex")
{
  if($mode == "hex") {
    $to  =  hexdec($to[0].$to[1]).",".hexdec($to[2].$to[3]).",".hexdec($to[4].$to[5]);
    $from = hexdec($from[0].$from[1]).",".hexdec($from[2].$from[3]).",".hexdec($from[4].$from[5]);
  }

  if (empty($text)) {
    return '';
  } else {
    $levels = strlen($text);
  }
  
  if (empty($from)) {
    $from = array(0,0,255);
  } else {
    $from = explode(",", $from);
  }
  

  if (empty($to)){
    $to = array(255, 0, 0);
  } else {
    $to = explode(",", $to);
  }
  
  $output = "";

  for ($i = 1; $i <= $levels; $i++) {
    for ($ii = 0; $ii < 3; $ii++) {
      $tmp[$ii] = $from[$ii] - $to[$ii];
      $tmp[$ii] = floor($tmp[$ii] / $levels);
      $rgb[$ii] = $from[$ii] - ($tmp[$ii] * $i);

      if ($rgb[$ii] > 255) $rgb[$ii] = 255;

      $rgb[$ii] = dechex($rgb[$ii]);
      $rgb[$ii] = strtoupper($rgb[$ii]);

      if (strlen($rgb[$ii]) < 2) {
         $rgb[$ii] = "0$rgb[$ii]";
      }
    }
    $output .= "<font color=\"#" . $rgb[0].$rgb[1].$rgb[2] . "\">" . mb_substr($text, ($i - 1), 1, 'utf-8') . "</font>";
  }
  return $output . "\n";
}

function __($str) { 

return $str; 
} 

function bbClearTWO($str) {
	$bbcode = array();
	$bbcode['/\[blue\](.+)\[\/blue\]/isU'] = '$1';
	$bbcode['/\[green\](.+)\[\/green\]/isU'] = '$1';
	$bbcode['/\[red\](.+)\[\/red\]/isU'] = '$1';
	$bbcode['/\[white\](.+)\[\/white\]/isU'] = '$1';
	$bbcode['/\[yellow\](.+)\[\/yellow\]/isU'] = '$1';
	
	$bbcode['/\[small\](.+)\[\/small\]/isU'] = '$1';
	$bbcode['/\[big\](.+)\[\/big\]/isU'] = '$1';

	$bbcode['/\::stikers(.+)\::/isU'] = 'Стикер';
	$bbcode['/\&#(.+)\;/isU'] = 'Смайл';
	$bbcode['/\[marquee=right\](.+)\[\/marquee\]/isU'] = '$1';
	$bbcode['/\[b\](.+)\[\/b\]/isU'] = '$1';
	$bbcode['/\[url=(.+)\](.+)\[\/url\]/isU'] = '$2';
	$bbcode['/\[q\](.+)\[\/q\]/isU'] = '$1';
	$bbcode['/\[br\]/isU'] = '$1';
	$bbcode['/\[hr\]/isU'] = '$1';
	$bbcode['/\[i\](.+)\[\/i\]/isU'] = '$1';
	$bbcode['/\[u\](.+)\[\/u\]/isU'] = '$1';
	$bbcode['/\[size=([0-9]+)\](.+)\[\/size\]/isU'] = '$2';
	$bbcode['/\[fon=([a-z0-9-#]+)\](.+)\[\/fon\]/isU'] = '$2';
	//$bbcode['/\[url=([a-z0-9-#_/]+)\](.+)\[\/url\]/isU'] = '$2';
	
	$bbcode['/\[position=(center|left|right+)\](.+)\[\/position\]/isU'] = '$2';
	$bbcode['/\[color=([a-z0-9-#]+)\](.+)\[\/color\]/isU'] = '$2';
	$str = preg_replace(array_keys($bbcode), array_values($bbcode), $str);
	return $str;
}

?>