/***********************************************************/
/*                    tinyTips Plugin                      */
/*                      Version: 1.1                       */
/*                      Mike Merritt                       */
/*                 Updated: Mar 2nd, 2010                  */
/***********************************************************/

(function($){  
	$.fn.tinyTips = function (tipColor, supCont) {
		
		if (tipColor === 'null') {
			tipColor = 'light';
		} 
		
		var tipName = tipColor + 'Tip';
		
		/*  
		**********************************/
		
		//      .  div    tinyTip  
		//     div   "content".
		var tipFrame = '<div class="' + tipName + '"><div class="content"></div><div class="bottom">&nbsp;</div></div>';
		
		//     : 1000  = 1 .
		var animSpeed = 300;
		
		/***************************************************************************************************/
		/*     -     ,      . */
		/***************************************************************************************************/
		
		//  ;
		var tinyTip;
		var tText;
		
		//      ,     
		$(this).hover(function() {
		
			//       .
			//      .
			$('body').append(tipFrame);
			var divTip = 'div.'+tipName;
			tinyTip = $(divTip);
			tinyTip.hide();
			
			//      title (  ) 
			//       . :  title 
			//      .
			if (supCont === 'title') {
				var tipCont = $(this).attr('title');
			} else if (supCont !== 'title') {
				var tipCont = supCont;
			}
			$(divTip + ' .content').html(tipCont);
			tText = $(this).attr('title');
			$(this).attr('title', '');
			
			//     ,      ,  
			//  ,    .
			var yOffset = tinyTip.height() + 2;
			var xOffset = (tinyTip.width() / 2) - ($(this).width() / 2);
			
			//         ,
			//      .
			var pos = $(this).offset();
			var nPos = pos;
			
			//     
			nPos.top = pos.top - yOffset;
			nPos.left = pos.left - xOffset;
			
			//         z-index, 
			//         .
			tinyTip.css('position', 'absolute').css('z-index', '1000');
			tinyTip.css(nPos).fadeIn(animSpeed);
			
		}, function() {
			
			$(this).attr('title', tText);
		
			//   ,      ,
			//      DOM.
			tinyTip.fadeOut(animSpeed, function() {
				$(this).remove();
			});
			
		});
		
	}

})(jQuery);