﻿jQuery(function($){
	// bind event handlers to modal triggers
	$('body').on('click', '.dcms-trigger', function(e){
		e.preventDefault();
		$('#dcms-modal').modal().open();
	});

	// attach modal close handler
	$('.dcms-modal-style .close_dcms_modal').on('click', function(e){
		e.preventDefault();
		$.modal().close();
	});

	// below isn't important (demo-specific things)
	$('.dcms-modal-style .more-toggle').on('click', function(e){
		e.stopPropagation();
		$('.dcms-modal-style .more').toggle();
	});
});

// Функция подгрузки видео
function getVideoDcms(name, id_video)   
{  
	// Помещаем заголовок в контейнер
	document.getElementById('dcms-modal-title').innerHTML = name;
	
	// Запускаем анимацию погрузки
	document.getElementById('dcms-modal-content').innerHTML = '<img class="dcms-load-photo" src="/ajax/newModal/img/progress_gray.gif" alt="Loading..."/>';
	
	$('#dcms-modal-style').css({'min-width' : '800px'});
	$('#dcms-modal-title').css({'color' : '#868686'});
	$('#dcms-modal').css({'margin-top':'30px', 'height': 'auto', 'color' : '#fff'});
	$('#dcms-modal-content').css({'backgropund-color' : '#000'});
	
	$('#dcms-load-photo').css({'margin-top':'10px'});
	
	// Загружаем контент
	$.ajax({  
		url: '/ajax/newModal/video/youtube.php?id=' + id_video,  
		cache: false,  
		success: function(html)
		{  
			$("#dcms-modal-content").html(html);  
		}  
	});  
}  


// Функция подгрузки фотографии
function getPhotoDcms(name, id_photo)   
{  
	// Помещаем заголовок в контейнер
	document.getElementById('dcms-modal-title').innerHTML = '<img src="/ajax/newModal/img/upload.gif" alt="load.."/>';
	
	// Запускаем анимацию погрузки
	document.getElementById('dcms-modal-content').innerHTML = '<img class="dcms-load-photo" src="/ajax/newModal/img/progress_gray.gif" alt="Loading..."/>';
	
	$('#dcms-modal').css({'margin-top':'30px', 'height': 'auto'});
	$('#dcms-load-photo').css({'margin-top':'10px'});
	
	// Загружаем контент
	$.ajax({  
		url: '/ajax/newModal/foto/photos.php?id=' + id_photo,  
		cache: false,  
		success: function(html)
		{  
			$("#dcms-modal-content").html(html);  
		}  
	});  
}  


// Функция загрузки новой фотографии
function getPhotoUploadDcms(id_gallery)   
{  
	// Помещаем заголовок в контейнер
	document.getElementById('dcms-modal-title').innerHTML = 'Загрузка новой фотографии';
	
	// Запускаем анимацию погрузки
	document.getElementById('dcms-modal-content').innerHTML = '<img class="dcms-load-photo" id="dcms-load-photo" src="/ajax/newModal/img/progress_gray.gif" alt="Loading..."/>';
	
	$('#dcms-modal').css({'margin-top':'200px', 'height': '200px'});
	$('#dcms-load-photo').css({'margin-top':'80px'});
	
	// Загружаем контент
	$.ajax({  
		url: '/ajax/newModal/foto/upload.php?id=' + id_gallery,  
		cache: false,  
		success: function(html)
		{  
			$("#dcms-modal-content").html(html);  
		}  
	});  
}  


$(function() 
{
	$('form.ajax').submit(function()
	{
		if(this.id=='')
		{
			$(this).attr('id', 'ajaxForm' + Math.floor(Math.random()*1001));
		}

		var action = $(this).attr('action');
		var post = "ajax=1"; 
		
		$('#'+this.id+' input[name],textarea[name]').each(function()
		{
			post = post + "&" + encodeURIComponent(this.name) + "=" + encodeURIComponent($(this).val());
		});    
		$.ajax({
			type: "POST",
			url: action,
			data: post,
			dataType: "script",
			success: function(msg){
			// alert(msg);
			}
		});

		$(this)[0].reset();     
		return false;
	});
 });