<?php 

/**
* Класс для работы с обновлением системы
*/

class Update
{
    private $config;
    private $current = array();
    
    public function __construct($set) 
    {
        $this->config = $set; 
        $this->version(); 
    }
    
    /**
    * Получение информации о последней версии
    * @return array
    */
    public function current() 
    { 
        $cache = new Cache(60*60*3); 
        
        if ($cache->read('dcms.update', true)) {
            return $cache->read('dcms.update', true);
        }
        
        $data = $this->_get(); 
        
        if ($data) {
            $data['time'] = TIME;
            $save = $cache->write('dcms.update', $data, true);
            return $data;
        }
        
        return false; 
    }
    
    private function _get() 
    {
        $build = array(
            'HOST' => $_SERVER['HTTP_HOST'],
            'PROTOCOL' => $_SERVER['SERVER_PROTOCOL'],
            'PORT' => $_SERVER['REMOTE_PORT'],
            'VERSION' => $this->config['dcms_version'],
        ); 
        
        $data = false;
        
        if (function_exists('curl_init')) {
            $ch = curl_init(); 
            
            curl_setopt($ch, CURLOPT_URL, 'https://alex-borisi.ru/dev/social/index.php?get=current'); 
            curl_setopt($ch, CURLOPT_HEADER, false); 
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 1); 
            curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_HOST']); 
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($build, false, '&'));
            $data = curl_exec($ch); 
            curl_close($ch);
        }
        
        if ($data) {
            return json_decode($data, 1); 
        }
        
        return false;
    }
    
    public function version() {
        if (isset($_GET['social_version'])) {
            die($this->config['dcms_version']);
        }
    }
}