DROP TABLE IF EXISTS `activday`;

CREATE TABLE `activday` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `y` int(11) NOT NULL,
  `d` int(11) NOT NULL,
  `m` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO activday VALUES("1","2017","21","2");
INSERT INTO activday VALUES("2","2017","22","2");



DROP TABLE IF EXISTS `adm_chat`;

CREATE TABLE `adm_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `msg` varchar(1024) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `admin_log`;

CREATE TABLE `admin_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(10) unsigned NOT NULL,
  `time` int(10) unsigned NOT NULL,
  `mod` int(11) NOT NULL,
  `act` int(11) NOT NULL,
  `opis` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mod` (`mod`),
  KEY `act` (`act`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

INSERT INTO admin_log VALUES("1","1","1487492024","1","1","Изменение системных настроек");
INSERT INTO admin_log VALUES("2","1","1487492602","2","2","Выполнено 6 запрос(ов)");
INSERT INTO admin_log VALUES("3","1","1487492904","2","2","Выполнено 2 запрос(ов)");
INSERT INTO admin_log VALUES("4","1","1487494084","2","2","Выполнено 1 запрос(ов)");
INSERT INTO admin_log VALUES("5","1","1487494440","2","2","Выполнено 5 запрос(ов)");
INSERT INTO admin_log VALUES("6","1","1487518288","2","2","Выполнено 1 запрос(ов)");
INSERT INTO admin_log VALUES("7","1","1487522697","2","2","Выполнено 1 запрос(ов)");
INSERT INTO admin_log VALUES("8","1","1487595122","3","3","Удаление сообщения от Дзейтов Мага");
INSERT INTO admin_log VALUES("9","1","1487595123","3","3","Удаление сообщения от Дзейтов Мага");
INSERT INTO admin_log VALUES("10","1","1487595931","3","3","Удаление сообщения от Зуля");
INSERT INTO admin_log VALUES("11","1","1487693853","1","4","Изменение пользовательских настроек");
INSERT INTO admin_log VALUES("12","1","1487693862","2","2","Выполнено 3 запрос(ов)");
INSERT INTO admin_log VALUES("13","1","1487704612","2","2","Выполнено 2 запрос(ов)");
INSERT INTO admin_log VALUES("14","1","1487736331","4","5","Пользователь \'Зуля\': Статус \'Пользователь\' изменен на \'Главный администратор\'");
INSERT INTO admin_log VALUES("15","1","1487736331","4","6","Редактирование профиля пользователя \'Зуля\' (id#7)");



DROP TABLE IF EXISTS `admin_log_act`;

CREATE TABLE `admin_log_act` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_mod` int(11) NOT NULL,
  `name` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `act` (`name`),
  KEY `id_mod` (`id_mod`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO admin_log_act VALUES("1","1","Система");
INSERT INTO admin_log_act VALUES("2","2","MySQL");
INSERT INTO admin_log_act VALUES("3","3","Удаление сообщения");
INSERT INTO admin_log_act VALUES("4","1","Пользователи");
INSERT INTO admin_log_act VALUES("5","4","Изменение статуса");
INSERT INTO admin_log_act VALUES("6","4","Профиль");



DROP TABLE IF EXISTS `admin_log_mod`;

CREATE TABLE `admin_log_mod` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO admin_log_mod VALUES("1","Настройки");
INSERT INTO admin_log_mod VALUES("2","Админка");
INSERT INTO admin_log_mod VALUES("3","Гостевая");
INSERT INTO admin_log_mod VALUES("4","Пользователи");



DROP TABLE IF EXISTS `all_accesses`;

CREATE TABLE `all_accesses` (
  `type` varchar(32) NOT NULL,
  `name` varchar(64) NOT NULL,
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO all_accesses VALUES("adm_panel_show","Админка - доступ к разделам админки");
INSERT INTO all_accesses VALUES("loads_file_upload","Загрузки - выгрузка файлов");
INSERT INTO all_accesses VALUES("loads_dir_mesto","Загрузки - перемещение папок");
INSERT INTO all_accesses VALUES("loads_dir_delete","Загрузки - удаление папок");
INSERT INTO all_accesses VALUES("loads_dir_rename","Загрузки - переименование папок");
INSERT INTO all_accesses VALUES("loads_dir_create","Загрузки - создание папок");
INSERT INTO all_accesses VALUES("loads_file_edit","Загрузки - параметры файлов");
INSERT INTO all_accesses VALUES("loads_file_delete","Загрузки - удаление файлов");
INSERT INTO all_accesses VALUES("loads_unzip","Загрузки - Распаковка ZIP");
INSERT INTO all_accesses VALUES("lib_stat_zip","Библиотека - выгрузка статей в ZIP");
INSERT INTO all_accesses VALUES("lib_stat_txt","Библиотека - выгрузка статей в txt");
INSERT INTO all_accesses VALUES("lib_stat_create","Библиотека - создание статей");
INSERT INTO all_accesses VALUES("lib_dir_delete","Библиотека - удаление папок");
INSERT INTO all_accesses VALUES("lib_dir_mesto","Библиотека - перемещение папок");
INSERT INTO all_accesses VALUES("lib_dir_edit","Библиотека - редактирование папок");
INSERT INTO all_accesses VALUES("lib_dir_create","Библиотека - создание папок");
INSERT INTO all_accesses VALUES("lib_stat_delete","Библиотека - удаление статей");
INSERT INTO all_accesses VALUES("votes_settings","Голосования - закрытие/удаление");
INSERT INTO all_accesses VALUES("votes_create","Голосования - создание");
INSERT INTO all_accesses VALUES("guest_clear","Гостевая - очистка");
INSERT INTO all_accesses VALUES("guest_delete","Гостевая - удаление постов");
INSERT INTO all_accesses VALUES("obmen_dir_delete","Обменник - удаление папок");
INSERT INTO all_accesses VALUES("obmen_dir_edit","Обменник - управление папками");
INSERT INTO all_accesses VALUES("obmen_dir_create","Обменник - создание папок");
INSERT INTO all_accesses VALUES("obmen_file_delete","Обменник - удаление файлов");
INSERT INTO all_accesses VALUES("obmen_file_edit","Обменник - редактирование файлов");
INSERT INTO all_accesses VALUES("obmen_komm_del","Обменник - удаление комментариев");
INSERT INTO all_accesses VALUES("foto_foto_edit","Фотогалерея - редактирование/удаление фото");
INSERT INTO all_accesses VALUES("foto_alb_del","Фотогалерея - удаление альбомов");
INSERT INTO all_accesses VALUES("foto_komm_del","Фотогалерея - удаление комментариев");
INSERT INTO all_accesses VALUES("forum_razd_create","Форум - создание разделов");
INSERT INTO all_accesses VALUES("forum_for_delete","Форум - удаление подфорумов");
INSERT INTO all_accesses VALUES("forum_for_edit","Форум - редактирование подфорумов");
INSERT INTO all_accesses VALUES("forum_for_create","Форум - создание подфорумов");
INSERT INTO all_accesses VALUES("forum_razd_edit","Форум - управление разделами");
INSERT INTO all_accesses VALUES("adm_info","Админка - общая информация");
INSERT INTO all_accesses VALUES("forum_them_edit","Форум - редактирование тем");
INSERT INTO all_accesses VALUES("forum_them_del","Форум - удаление тем");
INSERT INTO all_accesses VALUES("forum_post_ed","Форум - редактирование сообщений");
INSERT INTO all_accesses VALUES("chat_clear","Чат - очистка");
INSERT INTO all_accesses VALUES("chat_room","Чат - управление комнатами");
INSERT INTO all_accesses VALUES("adm_statistic","Админка - статистика");
INSERT INTO all_accesses VALUES("adm_banlist","Админка - список забаненых");
INSERT INTO all_accesses VALUES("adm_menu","Админка - главное меню");
INSERT INTO all_accesses VALUES("adm_news","Админка - новости");
INSERT INTO all_accesses VALUES("adm_rekl","Админка - реклама");
INSERT INTO all_accesses VALUES("adm_set_sys","Админка - настройки системы");
INSERT INTO all_accesses VALUES("adm_set_loads","Админка - настройки загруз-центра");
INSERT INTO all_accesses VALUES("adm_set_user","Админка - пользовательские настройки");
INSERT INTO all_accesses VALUES("adm_set_chat","Админка - настройки чата");
INSERT INTO all_accesses VALUES("adm_set_forum","Админка - настройки форума");
INSERT INTO all_accesses VALUES("adm_set_foto","Админка - настройки фотогалереи");
INSERT INTO all_accesses VALUES("adm_forum_sinc","Админка - синхронизация таблиц форума");
INSERT INTO all_accesses VALUES("adm_themes","Админка - темы оформления");
INSERT INTO all_accesses VALUES("adm_log_read","Админка - лог действий администрации");
INSERT INTO all_accesses VALUES("adm_log_delete","Админка - удаление лога");
INSERT INTO all_accesses VALUES("adm_mysql","Админка - MySQL запросы !!!");
INSERT INTO all_accesses VALUES("adm_ref","Админка - рефералы");
INSERT INTO all_accesses VALUES("adm_show_adm","Админка - список администрации");
INSERT INTO all_accesses VALUES("adm_ip_edit","Админка - редактирование IP операторов");
INSERT INTO all_accesses VALUES("adm_ban_ip","Админка - бан по IP");
INSERT INTO all_accesses VALUES("adm_accesses","Привилегии групп пользователей !!!");
INSERT INTO all_accesses VALUES("user_delete","Пользователи - удаление");
INSERT INTO all_accesses VALUES("user_mass_delete","Пользователи - массовое удаление");
INSERT INTO all_accesses VALUES("user_ban_set","Пользователи - бан");
INSERT INTO all_accesses VALUES("user_ban_unset","Пользователи - снятие бана");
INSERT INTO all_accesses VALUES("user_prof_edit","Пользователи - редактирование профиля");
INSERT INTO all_accesses VALUES("user_collisions","Пользователи - совпадения ников");
INSERT INTO all_accesses VALUES("user_show_ip","Пользователи - показывать IP");
INSERT INTO all_accesses VALUES("user_show_ua","Пользователи - показ USER-AGENT");
INSERT INTO all_accesses VALUES("user_show_add_info","Пользователи - показ доп. информации");
INSERT INTO all_accesses VALUES("guest_show_ip","Гости - показ IP");
INSERT INTO all_accesses VALUES("user_change_group","Пользователи - смена группы привилегий");
INSERT INTO all_accesses VALUES("user_ban_set_h","Пользователи - бан (max 1 сутки)");
INSERT INTO all_accesses VALUES("forum_post_close","Форум - возможность писать в закрытой теме");
INSERT INTO all_accesses VALUES("user_change_nick","Пользователи - смена ника");
INSERT INTO all_accesses VALUES("loads_file_import","Загрузки - импорт файлов");
INSERT INTO all_accesses VALUES("adm_lib_repair","Восстановление библиотеки");
INSERT INTO all_accesses VALUES("notes_edit","Дневники - редактирование");
INSERT INTO all_accesses VALUES("notes_delete","Дневники - удаление");



DROP TABLE IF EXISTS `apps`;

CREATE TABLE `apps` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `opis` varchar(512) DEFAULT NULL,
  `url` varchar(128) DEFAULT NULL,
  `icon_small` varchar(128) DEFAULT NULL,
  `icon_big` varchar(128) DEFAULT NULL,
  `time` int(11) NOT NULL,
  `count` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO apps VALUES("1","Мой ребенок","Онлайн иг8ра мой ребенок","/moi/index.php","http://royalgram.ru/moi/img/m_1.png","","1487591767","0");
INSERT INTO apps VALUES("2","Война полов","Онлайн игра война полов","/plugins/sexwar/index.php","http://royalgram.ru/plugins/sexwar/images/users.png","","1487591939","0");
INSERT INTO apps VALUES("3","Золотые птицы","Онлайн игра золотые птицы","/birds/index.php","http://royalgram.ru/birds/birds/img/my_birds.png","","1487592143","1");



DROP TABLE IF EXISTS `ask`;

CREATE TABLE `ask` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_ank` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `anonim` int(1) NOT NULL,
  `msg` text NOT NULL,
  `reply` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO ask VALUES("1","2","1","1487534220","0","У тебя есть любимая девушка?","Есть.");
INSERT INTO ask VALUES("2","2","1","1487534228","0","Какая у тебя машина?","Ваз 2106");
INSERT INTO ask VALUES("3","2","1","1487534247","0","Сложно было создавать этот сайт?","нормально было");
INSERT INTO ask VALUES("4","1","7","1487596950","0","Откуда у тебя эти красивые глазки?","Всевышнил дал");
INSERT INTO ask VALUES("5","1","12","1487690671","0","Тебе понравился наш сайт?","Да,диз отличный.");



DROP TABLE IF EXISTS `ask_like`;

CREATE TABLE `ask_like` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_post` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO ask_like VALUES("1","1","3");
INSERT INTO ask_like VALUES("2","1","2");
INSERT INTO ask_like VALUES("3","1","1");
INSERT INTO ask_like VALUES("4","5","3");
INSERT INTO ask_like VALUES("5","5","2");
INSERT INTO ask_like VALUES("6","5","1");
INSERT INTO ask_like VALUES("7","0","1");
INSERT INTO ask_like VALUES("8","0","2");



DROP TABLE IF EXISTS `baby`;

CREATE TABLE `baby` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `pol` int(11) NOT NULL DEFAULT '0',
  `papa` int(11) NOT NULL DEFAULT '0',
  `mama` int(11) NOT NULL DEFAULT '0',
  `health` int(11) NOT NULL DEFAULT '0',
  `happy` int(11) NOT NULL DEFAULT '0',
  `eda` int(11) NOT NULL DEFAULT '0',
  `iq` int(11) NOT NULL DEFAULT '0',
  `progulka` int(11) NOT NULL DEFAULT '0',
  `play` int(11) NOT NULL DEFAULT '0',
  `skazka` int(11) NOT NULL DEFAULT '0',
  `health_time` int(11) NOT NULL DEFAULT '0',
  `happy_time` int(11) NOT NULL DEFAULT '0',
  `eda_time` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `baby_chat`;

CREATE TABLE `baby_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `msg` varchar(1024) DEFAULT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `baby_shop_eda`;

CREATE TABLE `baby_shop_eda` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(1024) DEFAULT NULL,
  `cena` int(11) NOT NULL DEFAULT '0',
  `health` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO baby_shop_eda VALUES("1","Яишница","20","5");
INSERT INTO baby_shop_eda VALUES("2","Гамбургер","20","5");
INSERT INTO baby_shop_eda VALUES("3","Тортик","20","5");
INSERT INTO baby_shop_eda VALUES("4","Тосты","20","5");



DROP TABLE IF EXISTS `baby_shop_igrushki`;

CREATE TABLE `baby_shop_igrushki` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(1024) DEFAULT NULL,
  `cena` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO baby_shop_igrushki VALUES("1","Футбольный мяч","50");
INSERT INTO baby_shop_igrushki VALUES("2","Маска","50");
INSERT INTO baby_shop_igrushki VALUES("3","Компьютер","50");
INSERT INTO baby_shop_igrushki VALUES("4","PSP","50");



DROP TABLE IF EXISTS `baby_shop_skazki`;

CREATE TABLE `baby_shop_skazki` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(1024) DEFAULT NULL,
  `cena` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO baby_shop_skazki VALUES("1","Волшебные сказки","20");
INSERT INTO baby_shop_skazki VALUES("2","Учимся считать","50");
INSERT INTO baby_shop_skazki VALUES("3","Букварь","80");
INSERT INTO baby_shop_skazki VALUES("4","Сборник советских сказок","100");
INSERT INTO baby_shop_skazki VALUES("5","Энциклопедия","200");



DROP TABLE IF EXISTS `baby_sp`;

CREATE TABLE `baby_sp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_baby` int(11) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `ban`;

CREATE TABLE `ban` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `id_ban` int(11) NOT NULL,
  `prich` varchar(1024) NOT NULL,
  `view` set('1','0') NOT NULL DEFAULT '0',
  `razdel` varchar(10) DEFAULT 'all',
  `post` int(1) DEFAULT '0',
  `pochemu` int(11) DEFAULT '0',
  `navsegda` int(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`,`id_ban`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `ban_ip`;

CREATE TABLE `ban_ip` (
  `min` bigint(20) NOT NULL,
  `max` bigint(20) NOT NULL,
  KEY `min` (`min`,`max`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `best`;

CREATE TABLE `best` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO best VALUES("1","1","1488127511");
INSERT INTO best VALUES("2","6","1488182471");
INSERT INTO best VALUES("3","5","1488182563");
INSERT INTO best VALUES("4","7","1488199301");



DROP TABLE IF EXISTS `board_cat`;

CREATE TABLE `board_cat` (
  `id_cat` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id_cat`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

INSERT INTO board_cat VALUES("1","Ayдиo- Bидeo тexникa");
INSERT INTO board_cat VALUES("2","Бизнec, финaнcы");
INSERT INTO board_cat VALUES("3","Живoтныe");
INSERT INTO board_cat VALUES("4","Paзвлeчeния");
INSERT INTO board_cat VALUES("5","Oбopyдoвaниe");
INSERT INTO board_cat VALUES("6","Пpoдyкты");
INSERT INTO board_cat VALUES("7","Peмoнт, cтpoитeльcтвo");
INSERT INTO board_cat VALUES("8","Cpeдcтвa cвязи");
INSERT INTO board_cat VALUES("9","Pынoк тpyдa");
INSERT INTO board_cat VALUES("10","Уcлyги");
INSERT INTO board_cat VALUES("11","Paзнoe");



DROP TABLE IF EXISTS `board_mess`;

CREATE TABLE `board_mess` (
  `id_mess` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `date` varchar(10) NOT NULL,
  `id_cat` int(11) NOT NULL,
  `desc` text NOT NULL,
  `contact` varchar(255) NOT NULL,
  PRIMARY KEY (`id_mess`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `chat_post`;

CREATE TABLE `chat_post` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `room` int(11) NOT NULL,
  `id_user` int(11) DEFAULT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(1024) DEFAULT NULL,
  `vopros` int(11) DEFAULT NULL,
  `umnik_st` set('0','1','2','3','4') DEFAULT '0',
  `shutnik` set('0','1') NOT NULL DEFAULT '0',
  `privat` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `room` (`room`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `chat_rooms`;

CREATE TABLE `chat_rooms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pos` int(11) NOT NULL,
  `name` varchar(32) NOT NULL,
  `umnik` set('0','1') DEFAULT '0',
  `shutnik` set('0','1') DEFAULT '0',
  `opis` varchar(256) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pos` (`pos`,`umnik`,`shutnik`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `chat_shutnik`;

CREATE TABLE `chat_shutnik` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `anek` varchar(1024) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=501 DEFAULT CHARSET=utf8;

INSERT INTO chat_shutnik VALUES("1","По просьбе своих соплеменников поехал Чукча в Москву узнать, когда будет коммунизм. Приходит Чукча на прием к Горбачеву и спрашивает: - Когда будет коммунизм ? - Вот смотри: видишь, стоит моя \"Волга\", \"Волга\" Лукьянова, \"Волга\" Лигачева. Вот когда будет рядом стоять твоя \"Волга\", тогда, считай, и будет коммунизм. Вернулся Чукча в стойбище.\n- Узнал ? - Узнал. Вот видишь, стоят мои унты, твои унты и еще унты. Вот когда рядом будут стоять унты Горбачева, тогда, считай, и будет коммунизм.");
INSERT INTO chat_shutnik VALUES("2","Судья: - Вы должны попробовать стать другим человеком.\n- Я уже пытался, меня сразу посадили за подделку документов.");
INSERT INTO chat_shutnik VALUES("3","На недавней компютерной выставке (COMDEX) Билл Гейтс сравнил компьютерную промышленность с автомобильной и, в частности, сказал: - Если бы Дженерал Моторс осваивала достижения технологии с таким же эффектом, как это происходит в компьютерной промышленности, то мы все уже бы ездили на 25-ти долларовых машинах с расходом бензина 10 литров на 1000 километров. На что Дженерал Моторс отреагировала: - Да, но хотели бы вы чинить ваш автомобиль дважды в день?...");
INSERT INTO chat_shutnik VALUES("4","- Скажи, вот если мужчина говорит, что у меня волосы хорошо пахнут, это домогательство или нет? - Да нет, это комплимент, по-моему.\n- А если он карлик ....????");
INSERT INTO chat_shutnik VALUES("5","- Когда я иду с женой в гости, то пью очень мало.\n- Тебе не разрешает жена? - Вовсе нет. Просто однажды я здорово перебрал, и мне показалось, что у меня две жены. Такого ужаса я никогда не испытывал!");
INSERT INTO chat_shutnik VALUES("6","Два наркомана, обкурившись, лежат на кровати. Звонок в дверь... Через полчаса один другому: \"Кажется, в дверь звонят...\" Через полчаса другой первому: \"Может, пойти, открыть дверь?..\" Через полчаса первый: \"Ну, сходи, открой...\" Через полчаса второй встает, медленно идет к двери, открывает... На пороге, облокотившись о дверной косяк, стоит третий наркоман: \"Ох-х! Не успел позвонить, уже дверь открывают!\"");
INSERT INTO chat_shutnik VALUES("7","Наташа Ростова вышла вечером подышать на веранду. Внизу в лопухах что-то темнело. НР: Поручик, это Вы? Ржевский: Я! НР: А что это Вы такой маленький? Ржевский: Я не маленький. Я сру.");
INSERT INTO chat_shutnik VALUES("8","- А я не встану под музыку нового гимна! - Ну и будешь смотреть в задницу поющему... Коклюшкин");
INSERT INTO chat_shutnik VALUES("9","Семь раз отмерь - один раз отрежь! (еврейская народная пословица)");
INSERT INTO chat_shutnik VALUES("10","К мужику на вокзале подбегает цыганка: - Драгоценный мой, дай руку, погадаю, все скажу, что будет, что было. Мужик пожимает плечами, протягивает руку: - Hу, погадай. Цыганка некоторое время смотрит на ладонь, потом в ужасе кричит: - Страшной смертью помрешь! Зарежут тебя, сдерут шкуру, четвертуют, зажарят и съедят! - Ах да, я ж перчатку не снял...");
INSERT INTO chat_shutnik VALUES("11","Мадам готовит завтрак, муж перелистывает газету. Вдруг раздается странный гортанный звук.\n- Что там с тобой? - кричит она мужу.\n- Я случайно проглотил пуговицу от воротничка! Мадам удовлетворенно: - Хоть теперь мы будем знать, где она находится!");
INSERT INTO chat_shutnik VALUES("12","Военный говорит жене: - Поздравь меня - мне дали майора.\n- Поздравляю. И что ты с ним сделал?..");
INSERT INTO chat_shutnik VALUES("13","- Что делать, профессор, все готово к операции, а пациента еще нет.\n- Это ничего, начнем без него.");
INSERT INTO chat_shutnik VALUES("14","- Доктор, что означают буквы \"ЧЗ\" в моем диагнозе? - \"Черт его знает\".");
INSERT INTO chat_shutnik VALUES("15","Купил искусственную электронную вагину. Вы даже не представляете, что сбой процессора может быть так приятен...");
INSERT INTO chat_shutnik VALUES("16","Люди, которые думают, что они знают все на свете, раздражают нас, людей, которые действительно все на свете знают.");
INSERT INTO chat_shutnik VALUES("17","- Вчера я видел, как ты выходил из пивной.\n- Что поделаешь, не могу же я там жить.");
INSERT INTO chat_shutnik VALUES("18","Мать с дочкой идут через густой лес. Вокруг никого. страшно. Дочь: - Мама, а вдруг нас изнасилуют?!! - Не с нашим счастьем, доченька....");
INSERT INTO chat_shutnik VALUES("19","ЗВОНОК ОТ ХИЛЛАРИ Хиллари пошла к гинекологу, чтобы провериться. Когда она закончила, она спросила его, все ли в порядке. Он ответил, что он очень рад ее состоянием, но...........она беременна! - Как это возможно? Этого не может быть! - Но это так! Вы беременны уже месяц! Она выбежала из оффиса и побежала к секретарю. Взяла телефон и позвонила в Белый Дом. Когда ответил оператор, она сказала, что это Хиллари и хочет говорить с Биллом срочно! Оператор соединил ее с Овальным оффисом и Билл ответил. Хиллари начала кричать: - Ты знаешь, что ты сделал, ты кретин! Ты сделал меня беременной!!! Никакого ответа не последовало. Хиллари опять повторила, крича: - Ты знаешь, что ты сделал, ты никому не нужный кретин! Ты сделал меня беременной!!!!!!!!!! Наконец, послышался ответ: - Кто это???................");
INSERT INTO chat_shutnik VALUES("20","Управляющий беседует с молодым человеком, который хочет устроиться на работу: - В нашей фирме, - говорит управляющий, - очень заботятся о чистоте. Вы вытерли ноги о коврик перед тем как войти? - О да, разумеется.\n- Во-вторых, - продолжает управляющий, - мы требуем от наших сотрудников правдивости. Никакого коврика там нет.");
INSERT INTO chat_shutnik VALUES("21","Если к поэту приходит муза, к поэтессе приходит музык.");
INSERT INTO chat_shutnik VALUES("22","- Не понимаю, почему ты развелась с мужем? - Мне вообще не повезло с замужеством. Сначала оно напоминало мираж в пустыне: дворцы, фонтаны, пальмы, яхты, путешествия на верблюдах по Африке...\n- А потом? - Потом дворцы, фонтаны исчезли, яхта пришла в негодность, осталась одна верблюжья работа.");
INSERT INTO chat_shutnik VALUES("23","Директор мебельной фабрики поехал в командировку в Париж. Возвращается - масса впечатлений. Рассказывает своим приятелям: - О, такой город! Такие улицы! Такие магазины! - Ну а женщины? - О-о! Это что-то невероятное! Мечта! Главное - любого мужика понимают с полуслова. Вот например: захожу я в маленький ресторанчик, сажусь за столик. Ко мне подсаживается умопомрачительная красотка. Ну сразу сообразила, что я по ихнему - ни слова. Рисует мне на салфетке рюмку. Я - наливаю ей шампанского. Рисует сигарету. Я - даю закурить. Рисует две танцующие фигурки. Я - приглашаю ее на танец.\n- Ну а потом? - Рисует кровать...\n- А ты? - Хмм... До сих пор не пойму - как она узнала, что я - директор мебельной фабрики...");
INSERT INTO chat_shutnik VALUES("24","Молодой офицер попадает служить на боевой корабль, который немедленно направляется в длительный поход. \"Товарищ капитан первого ранга, я и с девушкой-то не успел побыть, а тут такой длительный поход - жалуется он командиру. \"Ничего, лейтенант, у нас для этих целей кок есть.\" \"Как можно - возмущается лейтенант - ведь он мужчина.\" \"Ну не хотите, как хотите, но если что, посодействую.\" Проходит три месяца. Лейтенант подходит к командиру: \"Товарищ капитан первого ранга, Вы что-то насчет кока говорили...\" \"Мичман! - зовет тот - приведи кока в каюту лейтенанта и не забудь взять еще троих.\" \"Зачем троих? - смущается лейтенант - а нельзя ли нам с коком один на один?\" \"Ты один с ним не справишься, сынок. Его же сначала надо с ног сбить и к кровати прижать.\"");
INSERT INTO chat_shutnik VALUES("25","На балу к поручику подскочил корнет и решив блеснуть остроумием и поетическим даром сказал: \"Поручик-ключик-чайничек\" Ржевский ответил: \"Корнет-кларнет-тромбон-гандон- и вообще ты пидарас\"");
INSERT INTO chat_shutnik VALUES("26","Самое сложное для артиста пародирующего Баскова - также не попасть в ноты.");
INSERT INTO chat_shutnik VALUES("27","Анекдот из сериала \"Скорая помощь\". Врач дает указания практикантке: - В третьей смотровой пациент повредил прямую кишку большой морковью. Составьте анамнез и заполните его карточку. Практикантка изумленно: - Как он проглотил целую морковь?!!");
INSERT INTO chat_shutnik VALUES("28","Ночь была темной. Часовому хотелось курить.\n- Эй, Мак! - окликнул он, как ему показалось, своего товарища, проходившего недалеко от поста.\n- У тебя нет сигаретки? И тут он рассмотрел, что окликнул генерала.\n- Виноват, сэр! - гаркнул он и принял стойку \"смирно\".\n- Вольно, рядовой, - отдал команду генерал.\n- И считай, тебе повезло, что я не лейтенант!");
INSERT INTO chat_shutnik VALUES("29","В фотоателье мастер долго и пристально смотрит на клиента. Тот заерзал в кресле: - Что-то не так ? - Да Вы не волнуйтесь, все в порядке - просто если б не усы, Вы были бы вылитая моя теща.\n- Но у меня нет усов ! - А вот у нее есть.");
INSERT INTO chat_shutnik VALUES("30","- Как получить миллиард долларов? - Очень просто. Надо поймать Березовского и продать его Гусинскому.");
INSERT INTO chat_shutnik VALUES("31","Вернулся мужик из командировки. Приехал домой, открывает дверь и видит на вешалке чужое мужское пальто. Заходит в спальню. В постели жена лежит, всюду мужская одежда разбросана, а тут еще из ванной выходит голый мужчина. Муж только открывает рот, но его тут же перебивает жена: - Ну, конечно, всегда так ! Ты сейчас будешь верить своим бесстыжим глазам, а не любимой жене !");
INSERT INTO chat_shutnik VALUES("32","Молодой, талантливый пианист пришел записываться на радиостудию. Но вот непруха! Чем больше играет, тем хуже получается. И дальше - хуже... Время 12 часов ночи. За стеклышком сидит оператор грустный... Кофе кончился, сигарет нет, жена три раза звонила, обещала из дому выгнать. Надоело ему это все. Включает он микрофон в студии и говорит: - \"Слушай, мужик! Ладно, все, хорош! Ну не получается. Но ты хоть гамму-то сыграть можешь?\" Тот ему: - Гамму! Нет проблем! - Сыграй, а я потом нарежу!");
INSERT INTO chat_shutnik VALUES("33","- Какая разница между женщиной без груди и брюками без карманов? - Никакой. Некуда руки девать.");
INSERT INTO chat_shutnik VALUES("34","Около ранчо остановилось стадо баранов и уставилось на ворота.\n- Чего они смотрят? - спросили у пастуха.\n- Ведь ворота старые? - Бараны новые, - ответил пастух.");
INSERT INTO chat_shutnik VALUES("35","Встречаются на том свете три старых седых мужика, узнают друг у друга, как и отчего приключилась смерть. Первый говорит: - Я всю жизнь работал и смерть меня настигла в процессе труда. А работа была нелегкой, и поседел я лет в шестьдесят. Второй говорит: - А я всю жизнь воровал потихоньку, в конце концов меня и убили из-за денег. И при этом лет в сорок поседел, понимая, чем кончится мой промысел. Третий говорит: - Ну, вы, мужики, круты, хоть чего-то в жизни добились, а вот я вообще не делал ни хрена, и, как услышал, что моя собственная жена хочет меня на пересадку органов пустить, сначала поседел, а потом - при операции - сердце не выдержало... Голем");
INSERT INTO chat_shutnik VALUES("36","Жили в одной избушке Медведь, Волк и Заяц. У Медведя была заначка водки. Как-то раз ушел он в лес, а Волк с Зайцем остались дома. Заяц подходит к Волку и говорит: - Давай выпьем! - Да ты что, Медведь нам потом головы оторвет.\n- Ничего, когда он станет про водку спрашивать, ты, главное, глаза побольше сделай, мол, и не видели ее даже, а там как-нибудь выкрутимся. Выпили они медвежью заначку. Вечером Медведь обнаружил пропажу и спрашивает - А где моя водка? У Волка глаза по пятаку, а Заяц ему и говорит: - Ну что глазенки-то выпятил, рассказывай все дяде Мише!");
INSERT INTO chat_shutnik VALUES("37","Мужики взбунтовались, взяли вилы, топоры, дубье и поперли к усадьбе. Шумят, матерятся, гул стоит. Подходят к усадьбе. Выходит староста, пытается уговорить мужиков разойтись, потом управляющий - не слушают, матерятся, требуют, чтоб Сам вышел. Выходит помещик, после завтрака, халат расстегнут, левой рукой чешет брюхо, правой зубочистку держит, во рту ковыряется. Мужики притихли. Барин зевает, поворачивается к толпе и негромким голосом спрашивает: - Ну, чего вам, мужики? Мужики стоят молча. Барин смотрит на них, ждет ответа минуты три, потом лениво уходит. Мужики стоят, молчат, потом, спустя полчаса понемногу расходятся. Дня через три один из зачинщиков обедает дома, ест шти. Вдруг посреди обеда останавливается, задумывается, потом бах ложкой об стол и орет: - ЧАВО, ЧАВО, А НИЧАВО!");
INSERT INTO chat_shutnik VALUES("38","- Что можно снять с голой женщины? - Только голого мужчину.");
INSERT INTO chat_shutnik VALUES("39","Учительница прибегает к директору в слезах: - Ах это просто невыносим ! Не ученики - животные, скоты ! А один даже грозился меня изнасиловать ! Представляете ?! Директор встает и идет в класс. Входит. Молча осматривает ряды учеников и тыкает пальцем в Вовочку: - Этот сказал ? Понимаю: этот раз сказал - сделает.");
INSERT INTO chat_shutnik VALUES("40","\"Хуюшки вам, а не Кунашир!\" - сказал японцам Владимир Путин. И остров Хуюшки из Курильской гряды пришлось отдать.");
INSERT INTO chat_shutnik VALUES("41","- Любите ли вы Шекспира? - Трудно сказать. Скорее, мы просто приятели.");
INSERT INTO chat_shutnik VALUES("42","Начало чемнионата России по футболу. Матч \"Динамо\" - \"Спартак\". Опоздавший болельщик - соседу: - Ну и кто из наших лучше всех играет, точнее всех бьет? - Ковтун.\n- Но на табло 2:2, и два гола забил Терехин....\n- Много ты понимаешь! Терехин десять раз ударил и два раза забил, а Ковтун три раза ударил, и для всех троих сезон уже закончился!");
INSERT INTO chat_shutnik VALUES("43","- Кто, в конце концов, в доме хозяин?! - набравшись духу, закричал муж.\n- Я,- спокойно ответила жена,- А что? - Да нет, ничего... Все в порядке. Я просто так спросил.");
INSERT INTO chat_shutnik VALUES("44","- Где у женщин расположен аппендикс? - Как войдешь - налево.");
INSERT INTO chat_shutnik VALUES("45","Где-то загорелся дом. Все тушат. Прибегает хозяин и кричит: - Hа меня ведро воды! Выплеснули на него ведро, вбежал в горящий дом, через какое-то время выскоч ил. Проходит минут 15, мужик опять: - Hа меня ведро воды! Снова забежал в дом, через некоторое время выскочил. Прошло еще минут 15, у дома крыша уже обваливается, мужик опять: - Hа меня 10 ведер! Ему говорят, мол, куда ты полезешь, и вещей не спасешь, и сам погибнешь.\n- Какие вещи! Там моя теща, а я ее переворачиваю.");
INSERT INTO chat_shutnik VALUES("46","Однажды пришли к габровцам гости, да слишком засиделись. Не вытерпела хозяйка и громко сказала мужу, чтобы все услышали: - Давай, муженек, ляжем спать, а то, наверное, гости уже хотят идти домой!..");
INSERT INTO chat_shutnik VALUES("47","Революция кончилась. Петька с Василием Ивановичем думают о новой жизни: - Петька, что бы нам теперь построить? - Построим консерваторию! - Точно! А на крышу пулемет поставим! - А это зачем? - Чтобы все консервы не растащили!");
INSERT INTO chat_shutnik VALUES("48","Мужик жалуется приятелю: - А ведь когда-то у меня было все: деньги, роскошный дом, мерс, красивая женщина, которая меня по-настоящему любила. И всего этого я лишился в одночасье.\n- А что случилось? - Да какой-то козел рассказал об этом моей жене!");
INSERT INTO chat_shutnik VALUES("49","Из письма А. Б. Чубайсу. Уважаемый Анатолий Борисович, пишет вам электрик Эрнест Петрович Сидоров. Сделайте что-нибудь. Ввиду огромного внешнего сходства с вами, мне очень часто бьют морду. С уважением Э. П. Сидоров");
INSERT INTO chat_shutnik VALUES("50","Глубокой ночью Сталин поднимает трубку.\n- Слушай, товарищ Молотов, а ты так же все заикаешься? - Заикаюсь, товарищ Сталин, но если нужно будет для дела строительства социализма, тоЄ - Нет, ничего не надо. Спи спокойно. И кладет трубку. Звонит Микояну.\n- Слушай, товарищ Микоян, сколько там было бакинских комиссаров? - 27, товарищ СталинЄ - А сколько погибло? - 26, товарищ Сталин.\n- Ну, спи спокойно, наш двадцать седьмой бакинский комиссар! И кладет трубку. Звонит Берии.\n- Слушай, товарищ Берия, ты Бухарина надежно расстрелял? - Надежно, товарищ Сталин. А что? - Да ничего. Спи спокойно. Кладет трубку и говорит: - Ну вот, их успокоил, теперь можно м самому уснуть.");
INSERT INTO chat_shutnik VALUES("51","Англичанин среднего достатка заходит в респектабельный магазин. Немного оглядевшись спрашивает продавца.\n- Скажите, сколько стоит вон та шляпа? -Тысячу долларов, Сэр.\n-Черт.., А вон та? -Два черта, Сэр. FiL");
INSERT INTO chat_shutnik VALUES("52","Гpузин в pестоpане любуется новыими \"коpочками\" кандидата наук. Официант ехидно спpашивает: - Что, только что купил ? - Вах ! Зачэм стpашиваэш ! Зачэм сpазу: Купиль ! Дpуззя подаpиль !!");
INSERT INTO chat_shutnik VALUES("53","Встречаются два директора советского и японского предприятий. Предприятия изготавливают совершенно одинаковую продукцию и в одинаковых количествах. Директор нашего завода спрашивает: - Сколько людей у тебя работает? - Девять. А у тебя? У нашего вообще-то пятьсот, но он говорит: - Десять! На следующий день японец говорит: - Слушай, я всю ночь думал и никак не могу понять: что у тебя этот десятый делает?");
INSERT INTO chat_shutnik VALUES("54","\"Фанта. Вкус апельсина.\" До сих пор не могу понять, что именно дает этот вкус. То ли вода с сахаром и диоксидом углерода, то ли регулятор кислотности и стабилизатор гуммиарабик. А может, изо-бутират ацетат сахарозы с антиоксидантом аскорбиновая кислота? Хотя, вероятнее всего, краситель \"желтый солнечный загар\" с идентичными натуральным ароматизаторами... Нет, наверное, все-таки бензоат натрия!..");
INSERT INTO chat_shutnik VALUES("55","Жена: - Не могли бы мы как-нибудь сходить в кино ? Муж: - Мы же были в кино.\n- Да, но теперь там идут звуковые фильмы...");
INSERT INTO chat_shutnik VALUES("56","Садятся старик со старухой ужинать. Старуха поставила перед стариком сковородку картошки. Он поковырялся вилкой, взял сковородку да как треснет старухе по лбу.\n- Старик, ты одурел, что ли? - Как вспомню что не целкой взял, так аппетит пропадает!!!");
INSERT INTO chat_shutnik VALUES("57","У минетчицы спрашивают: - как дела? - Да вот вот хреново! Всякая пошлятина в голову лезет!");
INSERT INTO chat_shutnik VALUES("58","Выполз уж из ресторана: \"Гав. Неа.. Ку-ка-реку Неа.. Мяу Неа... Шшшш, бля буду, шшшшш!\"");
INSERT INTO chat_shutnik VALUES("59","Леди не захочет, джентльмен не вскочит.");
INSERT INTO chat_shutnik VALUES("60","- Ва-ань, а Ва-ань, ты за ско-олько доходишь от кровати до двери? - Я - за час, а ты за сколько? - За полчаса! - Ну, ты вообще, как метеор!");
INSERT INTO chat_shutnik VALUES("61","Фиpма, пpодающая пилюли для похудения, получила письмо: \"Ваши пилюли бесподобны. За пеpвые две недели моя жена похудела на шесть кг, а вскоpе исчезла вообще.\"");
INSERT INTO chat_shutnik VALUES("62","Врач - пациенту, глядя в историю болезни: - Э-э ,батенька, с сегодняшнего дня бросайте курить - положение серьезное! - Доктор, но я не курю! Не люблю.\n- Да? Тогда ни капли спиртного!! - Но, доктор, я не пью! Не люблю! - Да??... Но что-нибудь вы любите!!?? - Картошку...\n- Так вот! С сегодняшнего дня я вам решительно запрещаю есть картошку!!!");
INSERT INTO chat_shutnik VALUES("63","- Рабинович, говорят, вы большой интриган? - Да, а кто это ценит...");
INSERT INTO chat_shutnik VALUES("64","Социальная реклама Мы yже не pаз обманывали вас. Вы защищали нас осенью 91-го, мы стpеляли в вас осенью 93-го. Мы pазвалили вашy стpанy в 90-м, обокpали в 92-м, надyли с двyмя Волгами в 93-м, с помощью МММ-ов pаскpyтили на бабки в 94-м, посылали ваших детей на бойню в 95-м, неплохо \"повтоpничали\" в 96-м, и полностью огpабили в 98-м. Hо y нас опять кончились деньги. Пожалyйста, заплатите налоги...");
INSERT INTO chat_shutnik VALUES("65","- Дорогой! Наш сосед подарил тебе на день рождения двухрожковую люстру! - Это он на что намекает?!");
INSERT INTO chat_shutnik VALUES("66","Недавно на ж/д переезде № 37 пожарный инспектор Василий М. обнаружил цистерну со спиртом, близкую к самовозгоранию. Лишь к вечеру силами жителей семи окрестных сел риск самовозгорания уменьшился ровно наполовину.");
INSERT INTO chat_shutnik VALUES("67","Молодой фермер, призванный на военную службу, в письме домой написал: \"Эта армейская жизнь - сплошное удовольствие. Можно валяться в постели до пяти часов утра\".");
INSERT INTO chat_shutnik VALUES("68","- Что вы будете делать, сержант Тейер, если запасы воды в вашем взводе окажутся зараженными? - Лучшим выходом было бы перейти на пиво.");
INSERT INTO chat_shutnik VALUES("69","Встречаются две подруги. Одна две недели назад вышла замуж. Вторая любопытствует: - Ну и как тебе семейная жизнь? - Да так себе, ничего. Только вот, представляешь, а Жан-то, оказывается, пьет...\n- Как пьет! Вы же два года были знакомы! И ты не знала? - Так ведь два года все было нормально, но вот вчера он пришел трезвым!");
INSERT INTO chat_shutnik VALUES("70","Почему евреи так популярны у женщин? Потому, что у них есть длинный, большой и толстый... Нет, не то, о чем Вы подумали: длинный - рубль, большой - счет в банке, а толстый - бумажник! Голем");
INSERT INTO chat_shutnik VALUES("71","\"micro soft works for micro soft windows\" означает \"Микро программное обеспечение работает для микро окон программного обеспечения\" (Перевод выполнен ПО Stylus for Windows 95, в. 3.0)");
INSERT INTO chat_shutnik VALUES("72","Больной вызывает врача в три часа ночи. После осмотра врач задумывается, потом говорит: - Вы составили завещание? - Нет, доктор.\n- Так вызовите, пожалуйста, нотариуса и двух свидетелей.\n- Боже мой, это так серьезно? - Нет, но я не хотел бы быть единственным дураком, которого вы подняли в три часа ночи.");
INSERT INTO chat_shutnik VALUES("73","Ж) - Смотри какие тени длинные, и облака тяжелые... Х) - Длинные - потому что уже поздно, а тяжелые потому что мы уже 5-й день пьем.");
INSERT INTO chat_shutnik VALUES("74","- Хаим, я слышал - вы женитесь! - Таки-да! - И как вам ваша будущая жена? - Ой, сколько людей, столько и мнений. Маме нравится, мне - нет.");
INSERT INTO chat_shutnik VALUES("75","Племянник разговаривает с Лениным: - Дядя Вова, у тебя такая большая умная голова!? - Да, Витенька, ей я думаю, как людям лучше жить.\n- У тебя такие руки!? - Да, Витенька, ими я указываю людям верную дорогу.\n- А усы тебе зачем? - А чтобы тетю Надю щекотать!");
INSERT INTO chat_shutnik VALUES("76","Один еврей рассказывает: - Представляешь, прихожу домой, а там жена с любовником. А глаза у них хитрые-хитрые... Думаю, что за черт! Бегу прямо к холодильнику, открываю его, так и есть! Всю фаршированную рыбу съели, сволочи!");
INSERT INTO chat_shutnik VALUES("77","Дочка спрашивает у мамы: - Мама, а что такое фаллоимитатор? Мама, немного смутившись, отвечает - Ну, доченька, это прибор, который заменяет мужа. Дочка (с восхищением): - Классно! И он сам по ночам жрет котлеты из холодильника и храпит?");
INSERT INTO chat_shutnik VALUES("78","Встречаются два приятеля: - Говорят, ты женился на девушке, о которой даже не мог и мечтать.\n- Правильно говорят... Неужели ты думаешь, что я мог мечтать о такой стерве?");
INSERT INTO chat_shutnik VALUES("79","Начальник лагеря объявляет: - Сегодня день смены белья. Первый барак меняется со вторым.");
INSERT INTO chat_shutnik VALUES("80","Вышел как-то Брежнев на балкон - на звезды посмотреть. Глянул - а луна-то не красная! Он позвонил кому надо, ему ответили, мол, все ОК, будет сделано! Выходит на следующий день - луна красная, как мак! Ильич лег спать довольным. На следующий день вышел - у луны снизу треугольник белый и надпись черным - Marlboro. Он звонит, ему - будет сделано! Он ложится спать. На следующий день - красная луна, белый треугольник, Мальборо и подпись внизу - \"московская фабрика Дукат\". Ильич ложится довольным. Следующий день. Глянул Брежнев - красная луна, Мальборо, фабрика Дукат, а внизу подпись - по лицензии компании Phillip Morris Ltd. Звонит, ему - будет сделано. Следующий день. Брежнев на балконе. Красная луна, белый треугольник, надпись Marlboro, подпись \"московская фабрика Дукат\", еще подпись \"по лицензии компании Phillip Morris Ltd.\", а внизу крупными буквами - МИНИСТЕРСТВО ОБОРОНЫ СССР ПРЕДУПРЕЖДАЕТ...");
INSERT INTO chat_shutnik VALUES("81","Вовочка пpедлагает Машеньке: - Машка, а давай мы с тобой в семью поигpаем? - А как? - Сначала потp#хаемся - а потом хаpактеpами не сойдёмся!");
INSERT INTO chat_shutnik VALUES("82","После того, как хирург сделал даме пластическую операцию, удалив двойной подбородок и придав носу классическую форму, она попросила, чтобы он расширил ей глаза.\n- Это уже лишнее, - заявил хирург, - у вас глаза станут и без того широкими, когда вы увидите счет за две первые операции.");
INSERT INTO chat_shutnik VALUES("83","Новый русский приходит к дантисту. Садится в кресло, открывает рот и дантист обалдевает: верхняя челюсть платиновая, а нижняя - золотая! Обалдевши дантист спрашивает: - А чем я могу помочь !??? - Как чем? Ты сигнализатцию поставь.");
INSERT INTO chat_shutnik VALUES("84","И настали в России смутные времена - лица кавказской национальности стали проверять прописку у работников милиции, а гаишники давать взятки водителям...");
INSERT INTO chat_shutnik VALUES("85","- Что-нибудь поймали? - интересуется прохожий.\n- Да, - мрачно отвечает рыбак.\n- Поймал одного и бросил в реку.\n- Наверное, маленький был? - Да, ростом примерно с вас и такой же назойливый.");
INSERT INTO chat_shutnik VALUES("86","- Мадам, почему вы уменьшили свой возраст на шесть лет? - Дело в том, что первые шесть лет я не умела считать.");
INSERT INTO chat_shutnik VALUES("87","Ленин с Крупской сидят и пьют чай. Вдруг на лестнице раздался страшный грохот и лязг.\n- Наденька, кажется, в прихожей упал несгораемый шкаф...\n- Нет, Володя, это железный Феликс на перилах катается.");
INSERT INTO chat_shutnik VALUES("88","Вопрос: Почему большинство женщин не может уснуть после оргазма? Ответ: Потому что им нужно еще до дома добираться!");
INSERT INTO chat_shutnik VALUES("89","- Доктор, я после ампутации не чувствую правую ногу.\n- Как же вы, голубчик, хотите ее чувствовать, если она у вас ампутирована?.\n- Так мне же ампутировали левую!");
INSERT INTO chat_shutnik VALUES("90","С завистью про одну знакомую: - Она только что вернулась с черноморского побережья с чудесно загоревшим языком!");
INSERT INTO chat_shutnik VALUES("91","Винни-Пух полез за медом и застрял.\n- Пятачок! Пятачок! Отдери меня! Ну Пятачок и отодрал. Через два дня пошел дождь, Винни-Пух отлип и упал.");
INSERT INTO chat_shutnik VALUES("92","Как пытают Саддама Хусейна? - показывают портрет Мадлен Олбрайт");
INSERT INTO chat_shutnik VALUES("93","У нового рyсского спрашивают: \"За сколько минимyм Вы пробежите 100 метровкy?\" (HР): \"Минимyм за $800.\"");
INSERT INTO chat_shutnik VALUES("94","\"Как я учился трахаться\" - руководство по установке \"Windows\"");
INSERT INTO chat_shutnik VALUES("95","Парочка едет на спортивном автомобиле. Она: - Дорогой, не надо ехать так быстро, я боюсь. Он: - А ты закрой глаза, как я.");
INSERT INTO chat_shutnik VALUES("96","Вопpос к аpмянскому pадио: - Женятся ли онанисты? Ответ: - Да. Hа дояpках!");
INSERT INTO chat_shutnik VALUES("97","Солдат стройбата берет пачку \"Беломора\" и по слогам читает: - Минздрав предупреждает...\n- прикурил, затянулся, поглядел мечтательно вдаль и произнес: - Вот же гады, на лопатах-то такое не пишут.");
INSERT INTO chat_shutnik VALUES("98","- Pядовой Петpов - выйти из cтpоя - 15 шагов впеpед! - Pаз, два, тpи... Cемь! Дальше не могy, товаpищ майоp, - стена! - А дальше и не надо! Pота - ПЛИ !!!");
INSERT INTO chat_shutnik VALUES("99","Все хорошо, что хорошо конча...");
INSERT INTO chat_shutnik VALUES("100","Встречаются два друга. Один спрашивает другого: - Ты, я вижу, к Интернету подключился! - Как ты узнал? - По глазам.\n- Стали умнее? - Нет, краснее... (с) АС");
INSERT INTO chat_shutnik VALUES("101","Нынче очень легко стало отличить КТО есть КТО в американской политике. Демократы называют его Кеннет Старр, а Республиканцы уважительно Судья Старр...");
INSERT INTO chat_shutnik VALUES("102","К врачу приходит пациент с полностью черным языком.\n- Что это с вами? - Да вот, пролил водку на свежеуложенный асфальт...");
INSERT INTO chat_shutnik VALUES("103","В кабинет врача входит девушка: - Раздевайтесь, пожалуйста, - говорит ей врач.\n- Зачем?! - вспыхивает девушка.\n- У меня ведь болит ухо! - В таком случае вам не ко мне, - отвечает врач.\n- Я глазник.");
INSERT INTO chat_shutnik VALUES("104","Похороны. Катафалк, после того как на него погрузили гроб, трогается с места. Случайные свидетели наблюдают такую душераздирающую сцену: за катафалком бежит мальчуган лет восьми и рыдает: - Папа, папочка, куда же ты, не оставляй меня, я хочу с тобой!!! Но тут вдруг катафалк останавливается, из кабины выходит шофер и орет мальчику: - А ну марш домой, кому сказал! Не сделаешь уроки к моему приходу - я тебе ремня дам!");
INSERT INTO chat_shutnik VALUES("105","Сдают мужики сперму в больнице. Очередь большая. Вдруг подходит девушка и становится молча в очередь. Пять минут стоит и молчит. Десять. Народ удивляется. Подходит к ней мужик и спрашивает: - А вы что, тоже сперму сдаете ? А она отвечает, не раскрывая рта: - Угу.");
INSERT INTO chat_shutnik VALUES("106","В кабинет врача входит девушка: - Раздевайтесь, пожалуйста, - говорит ей врач.\n- Зачем?! - вспыхивает девушка.\n- У меня ведь болит ухо! - В таком случае вам не ко мне, - отвечает врач.\n- Я глазник.");
INSERT INTO chat_shutnik VALUES("107","Похороны. Катафалк, после того как на него погрузили гроб, трогается с места. Случайные свидетели наблюдают такую душераздирающую сцену: за катафалком бежит мальчуган лет восьми и рыдает: - Папа, папочка, куда же ты, не оставляй меня, я хочу с тобой!!! Но тут вдруг катафалк останавливается, из кабины выходит шофер и орет мальчику: - А ну марш домой, кому сказал! Не сделаешь уроки к моему приходу - я тебе ремня дам!");
INSERT INTO chat_shutnik VALUES("108","Сдают мужики сперму в больнице. Очередь большая. Вдруг подходит девушка и становится молча в очередь. Пять минут стоит и молчит. Десять. Народ удивляется. Подходит к ней мужик и спрашивает: - А вы что, тоже сперму сдаете ? А она отвечает, не раскрывая рта: - Угу.");
INSERT INTO chat_shutnik VALUES("109","Приходит барышня к гинекологу.\n- Доктор, вы мне вчера спиральку поставили...\n- Да, помню.\n- Но она слишком длинная.\n- Присядьте пока, через 5 минут поменяю. Барышня садится: пау-уау-уау!");
INSERT INTO chat_shutnik VALUES("110","Тяпница (день недели - время выпить)");
INSERT INTO chat_shutnik VALUES("111","Три секретарши в кафе обсуждают своего негодяя-босса.\n- Я вылила пузырек чернил в ящик его письменного стола.\n- А я нашла у него в столе презерватив и проколола его иглой. Третья падает в обморок.");
INSERT INTO chat_shutnik VALUES("112","Чукча приехал домой из Москвы и говорит: - Чукча в Москве был, чукча умным стал, все знает. Оказывается, Карл, Маркс, Фридрих, Энгельс не четыре человека, а два, а Слава КПСС - вообще не человек.");
INSERT INTO chat_shutnik VALUES("113","Если бы люди водили автомобили также, как они работают на компьютерах (разговор по телефону Водителя и Техника из тех. поддержки) Техник: Водительская тех. поддержка. Чем можем помочь? Водитель: Эта... Машина у меня не заводится. Техник: Ясненько. Какая у вашей машины марка, модель, и год выпуска? Водитель: А я... хрен его знает! Я ее купил в магазин ездить, откуда мне знать... Техник: Хорошо-хорошо, успокойтесь. Попробуем обойтись без этой информации... (вздох) У вас есть бензин в баке? Водитель: Гм... Бензин в баке, говоришь... А как я узнаю? Техник: На передней панели посмотрите. Куда стрелка показывает, на \"Е\" или на \"F\"? Водитель: А где передняя панель? Техник: Она находится сразу за рулем если вы сидите в водительском кресле. Водитель: А! Вижу. .. Тэкс... А тут стрелок много, которую из них смотреть? Техник: Смотрите на ту, рядом с которой написано Е или F. Там еще может быть бензоколонка нарисована. Водитель: Ааа! Вижу. Стрелка показывает на ноль. Техник: Как на ноль? Водитель: Ага. Прямо на ноль. А ещ");
INSERT INTO chat_shutnik VALUES("114","- Алло! Это \"секс по-телефону\"? - Да.\n- Значит, так. Hикаких кружевных трусиков, чулочек. Ты - блондинка, толстая, раскрасневшаяся. Абсолютно голая, но в резиновых сапогах. Звать тебя Клава. Hедавно кончилась война, примерно сорок шестой год. Мы - на сеновале. Пахнет конским навозом. Лучик света сквозь дыру в крыше упал на мою спину... Поехали, Клавка!");
INSERT INTO chat_shutnik VALUES("115","Отправляют первого китайца в космос. В напутствие ему говорят: Летишь ты не надолго, но еды мы тебе дадим много - кушай сколько хочешь, а мешочек (для естественных отходов организма) в скафандр пришили небольшой (ну на сутки, зачем большой?)... Приземлятся китайский космонавт. Еда нетронута, а вот мешочек порвался :( (c) Toha, onliner.by");
INSERT INTO chat_shutnik VALUES("116","Разговор мужа и жены: - Слушай, что мы подарим на этот раз моей маме на день рождения ? - А что мы дарили в прошлый раз ? - В прошлый раз мы подарили ей стул.\n- Hу а теперь подведем к нему электричество.");
INSERT INTO chat_shutnik VALUES("117","- Моня, ты что делаешь сегодня вечером? - Да, вроде, ничего.\n- Давай пойдем в клуб \"Кому за тридцать\". Договорились, но Моня не пришел. Встречаются на другой день.\n- Ну чего же ты не пришел? Я так хорошо провел время, там такие женщины...\n- Хаим, а я померил, у меня только двадцать четыре... Ну я и не пошел.");
INSERT INTO chat_shutnik VALUES("118","На еврейском кладбище в Одессе три землекопа присели отдохнуть у трех могил известных людей.\n- Хотел бы я лежать вот здесь, рядом с Рабиновичем, а ты? - говорит один.\n- Нет, я предпочел бы рядом с Абрамовичем.\n- А я предпочел бы прямо сейчас лежать с женой Когана...\n- Так она же жива! - Вот и я про то же!");
INSERT INTO chat_shutnik VALUES("119","Один приятель другому: - Ты знаешь, я когда в командировку последний раз уезжал, в шкафу капкан на медведя оставил. Представляешь - приезжаю и сразу к шкафу бегу, смотрю - сидит красавец! - Кто? Любовник? - Да нет... Медведь!");
INSERT INTO chat_shutnik VALUES("120","Явлинский-Болдырев-Лукин - ЯБЛоко. Немцов-Хакамада-Чубайс - НеХаЧу. Коалиция: \"НЕХАЧУ ЯБЛОКО\". &copy; Хрюн");
INSERT INTO chat_shutnik VALUES("121","- У этой пьесы был счастливый конец? - Конечно, все были так рады, что она закончилась.");
INSERT INTO chat_shutnik VALUES("122","Как называется человек, который не дарит подарков своей любовнице? Ответ: Дармоёб");
INSERT INTO chat_shutnik VALUES("123","- Доктоp, я пеpестала получать удовольствие от колбасы.\n- А что вы с ней, пpостите, делаете? - Я ее ем...");
INSERT INTO chat_shutnik VALUES("124","Пришел муж домой, уставший с работы. Поел и лег с женой спать. Всю ночь жена ластится к нему и так, и сяк, а он ворчит: - Отстань, Машка, у меня еще колосок не созрел... Спать хочу! На следующую ночь повторяется то же самое. На третью ночь муж начал сам к ней ластиться - и так, и сяк. А она ему отвечает: - Чё пристал? - Колосок-то созрел, - отвечает муж.\n- Ну вот еще, - ворчит жена, - буду из-за одного колоска весь комбайн заводить!");
INSERT INTO chat_shutnik VALUES("125","Два часа ночи. Звонок в дверь. Жена открывает дверь и... тело мужа падает в коридор.\n- Свинья! Ну что за радость каждый раз напиваться до полусмерти..!? - Прасти, драгая, ккак вседа денег неххватило....!!!");
INSERT INTO chat_shutnik VALUES("126","Заходит мужик в аптеку. М. У вас бананы есть? А. Нет. Здесь дорогой аптека и бананов не бывает. а следующий день снова он же заходит в аптеку. М. У вас Бананы есть? А. Да нет же здесь аптека здесь лекарства разные банки и т.д. Так повторяется в течении пяти дней, заебанный аптекарь на большом ватмане крупными буквами пишет объявление \"БАНАНОВ НЕТ! \" Заходит тот же мужчина, внимательно читает объявление, Подходит к Аптекарю и с обидой говорит \"А значит были бананы!\"");
INSERT INTO chat_shutnik VALUES("127","Дерется Чебурашка с Кощеем Бессмертным. Кощей говорит: - Все равно ты меня не убьешь. У меня смерть в яйце. Последовал удар.\n- У... да не в том!!!");
INSERT INTO chat_shutnik VALUES("128","В роддоме. Из операционной выходит молоденькая медсестра и говорит мужчине, ждущему результатов родов своей жены: - Поздравляю вас! У вас родился сын с шестью кулачками. Мужик побледнел и чуть не упал в обморок. А медсестра, хохоча: - Обманули дурачка на четыре кулачка!");
INSERT INTO chat_shutnik VALUES("129","Двое охранителей купили Мерседесы. И сразу же возник вопрос: дескать, как мы эти Мерседесы отличать будем? Вот один и говорит: - Послушай, давай разобьем у твоего левую фару, а у моего - правую. Так и будем отличать... Другой согласился. Так и сделали. Второй посмотрел-посмотрел и спрашивает: - Послушай, братан. Фары-то мы разбили, а ты помнишь, какая фара у твоей разбита - правая или левая? - Не-а.\n- Давай разобьем и другую фару. Разбили обе фары обеих машин, сидят и смотрят...\n- Послушай, братан, а ведь опять машины не отличишь.У обеих обе фары разбиты! - Ну, слушай, надоело с этими Мерседесами цацкаться. Ты бери черную, а мне таки-да достанется белая.");
INSERT INTO chat_shutnik VALUES("130","- Эй мужик, ты пиво будешь? - Буду, конечно! - Когда будешь, то меня позови...");
INSERT INTO chat_shutnik VALUES("131","Осмотрев кран, сантехник говорит девушке - хозяйке квартиры: - А прокладку-то вам пора менять! Девушка, смущенно покраснев, бормочет: - А вы-то откуда знаете?");
INSERT INTO chat_shutnik VALUES("132","Приходит Вовочка из школы и говорит отцу: - Мне двойку по биологии поставили. Папаша: - За что? - Да спросили у кого самые большие яйца.\n- Ну а ты? - Я сказал у верблюда.\n- Правильно, а учительница? - А она говорит что у страуса. Отец (задумчиво): - У Страуса ... так вот он почему такие медленные вальсы писал.");
INSERT INTO chat_shutnik VALUES("133","Когда АбрамОвич родился, АбрАмович три дня плакал...");
INSERT INTO chat_shutnik VALUES("134","Приходит женщина к врачу: - Доктор, я хотела бы подправить форму одной груди. А то они у меня не одинаковые.\n- Ну показывайте.\n- Вот эта (вытаскивает) нормальная.\n- Вполне.\n- А вот эта (вытаскивает, грудь пля-ф-ф-ф-ф на пол) видите, какая? Доктор чешет в затылке: - Да, такое я в первый раз вижу.\n- Это, наверно, из-за моего мужа. Он, понимаете, не может заснуть, если за мою грудь не держится.\n- Ну что вы такое рассказываете? Я вам признаюсь, у меня самого есть такая маленькая мания, но у моей супруги грудь нормальная.\n- Так вы, наверно, доктор, с женой в одной комнате спите?");
INSERT INTO chat_shutnik VALUES("135","В нью-йоркском отеле вывешено объявление: \"Гасите сигареты! Помните о пожаре в Чикаго!\" Под этим объявлением кто-то подписал: \"Hе плюйте на пол, помните о весенних разливах Миссисипи!\"");
INSERT INTO chat_shutnik VALUES("136","По дороге на мопеде ехал \"голубой\". Ну и заглох его мопед. Встал он на обочине, пригорюнился. Тут к нему на \"Мерседесе\" подъезжает \"крутой\" и небрежно так открывая окно спрашивает: - Ну что, мужик, толкнем твое говно? Педик (с радостью в голосе): - Конечно, толкнем!! А потом и мопед починим!!");
INSERT INTO chat_shutnik VALUES("137","Мужик, недавно купивший себе \"Феppаpи\", несется на этой машине с огpомной скоpостью, наслаждаясь мощью двигателя. Вдpуг он видит табличку: \"Сбавь скоpость - 50 км\". Мужик думает: \"Можно ведь было пpосто установить соответствующий запpещающий знак. А pаз они этого не сделали, значит, тут что-то сеpьезное и скоpость действительно надо сбавить\". Сбавляет он скоpость до 50 км/ч - и чеpез некотоpое вpемя видит еще одну табличку: \"Сбавь скоpость - 20 км\". Он и на этот pаз сбавляет скоpость до 20 км/ч, хоть и с большой неохотой. Чеpез полчаса - опять табличка: \"Сбавь скоpость 10 км\". Пpоклиная все на свете, он замедляется до 10 км/ч. А еще чеpез час он видит такую вывеску: \"Добpо пожаловать в пpидоpожный pестоpан \"Сбавь скоpость!\"\"");
INSERT INTO chat_shutnik VALUES("138","В испанском публичном доме \"мадам\" кричит: - Донна Мария, дон Педро все еще на вас? - Да.\n- Не давайте ему кончить, он заплатил фальшивыми купюрами.");
INSERT INTO chat_shutnik VALUES("139","Пришел мужчина на пляж. Снимает майку - вся спина искусана. Народ: - Мужик, что у тебя со спиной-то?! Мужик, отмахиваясь: - Да вчера тут голубого трахал, дык всю спину изгрыз, зараза!");
INSERT INTO chat_shutnik VALUES("140","Мужик приходит в фирму по объявлению \"Требуется менеджер\". Показывает боссу свои дипломы - финансовый институт, школа управления, курсы менеджмента и т.п. Босс: - Это хорошо. Мне нужен сообразительный управленец. Он должен взять на себя главный наш больной вопрос - финансы. Кандидат: - С моим образованием это без проблем. А как насчет заработка? - Ну, вы начинающий, предполагаю вам пока положить 10000 $.\n- Да? Но откуда же ваша маленькая фирма берет средства, чтобы платить такие деньги? - Вот. Вот это первый вопрос, который вам предстоит решить.");
INSERT INTO chat_shutnik VALUES("141","Когда мужчины спрашивали ее о возрасте, она кокетливо смеялась и отвечала, что женщине столько лет, на сколько она выглядит. Некоторые ей верили и имели большие проблемы - паршивке еще не было 15-ти.");
INSERT INTO chat_shutnik VALUES("142","И волки сыты, и овцы целы. Светлая память пастуху!");
INSERT INTO chat_shutnik VALUES("143","\"Все зло от Б.А.Б.!\" В.В.П.");
INSERT INTO chat_shutnik VALUES("144","Заяц отслужил на флоте и возвращается домой. Идет по лесу, поет песню: - На побывку едет молодой моряк! В кустах его поджидает Волк, который тоже служил на флоте, и тоже тихонько напевает: - Напрасно старушка ждет сына домой!");
INSERT INTO chat_shutnik VALUES("145","В бане два маленьких мальчика увидели голого мужчину с большим животом. Спрашивают его: - Дядя, а что у тебя в животе? - Бомба. Один тихо говорит другому: - Давай взорвем ее.\n- Опасно очень короткий фитиль.");
INSERT INTO chat_shutnik VALUES("146","Два бpаконьеpа: - Вчеpа поймал огpомного осетpа. Закинyл его на спинy и идy домой.\n- Hy? - А тyт из-за кyстов - инспектоp pыбнадзоpа! - Hy?! - А я осетpа со спины - и в каpман!");
INSERT INTO chat_shutnik VALUES("147","- Твоя собака, сосед, укусила мою жену за ногу. Придется тебе заплатить штраф.\n- За то, что может быть возмещено,- отвечает Насреддин,- нельзя требовать выкупа. Пришли свою собаку, пусть она укусит за ногу мою жену. И мы в расчете!");
INSERT INTO chat_shutnik VALUES("148","Ползут по пустыне два унитаза. Один говорит другому: - Ген, а Ген ! Давай приколупаемся к той черепахе ! - Hе надо, Чебурашка, Мы уже к старику Хотабычу приколупались !");
INSERT INTO chat_shutnik VALUES("149","У Моллы был длиннорогий бык. Целые дни и ночи Молла думал: как бы хоть раз сесть быку на голову, между рогами. Но удачного случая не представлялось. Однажды ночью Молла вышел во двор и видит: бык лежит на земле, пережевывая свою жвачку. Вот подходящий момент! -подумал Молла. Подобрав полы своей чохи, он вскочил быку на голову и уселся между рогами. Бык, испугавшись, вскочил и, мотнув головой, сбросил Моллу на землю. Молла закричал и упал в обморок. Услышав крик Моллы, жена его выбежала из дому и видит: муж ее лежит в крови, без сознания. Она подняла крик. Сбежался народ. Моллу привели в чувство. Оказалось, он сломал ногу. Его подняли, внесли в дом и уложили в постель. Молла огляделся по сторонам и заметил, что жена плачет. Он поднял голову и сказал ей: - Жена, не плачь. Хотя я упал и разбился, но зато желание мое исполнилось.");
INSERT INTO chat_shutnik VALUES("150","Идет мужик пьяный, смотрит - лужа, а в луже луна отражается.\n- У, сейчас на луне покатаюсь. Сел на нее и сидит. Идет милиционер, увидел мужика и спрашивает: - Эй, мужик, ты что тут делаешь? - На луне сижу.\n- Ну сиди, сиди, сейчас луноход подойдет.");
INSERT INTO chat_shutnik VALUES("151","Разговор подруг: - Ты знаешь, что женщины совершают меньше аварий, чем мужчины? - Интересно? А почему? - Потому что женщины заботятся о машине, как о муже, а мужчины относятся к ней, как к собственной жене.");
INSERT INTO chat_shutnik VALUES("152","Врач, обследовав женщину, выходит в коридор и сообщает ее мужу: - У меня для вас две новости: хорошая и плохая.\n- Давайте сначала плохую.\n- Ваша жена больна сифилисом.\n- Какой ужас! А хорошая? - Она заразилась им не от вас.");
INSERT INTO chat_shutnik VALUES("153","В компьютер заложили множество всевозможных анекдотов, чтобы тот выдал средний. Результат начинался так: \"Лежат в постели три еврея: Чапаев, Чебурашка и Поручик Ржевский...\".");
INSERT INTO chat_shutnik VALUES("154","- Вася дома? - Нет, Васи больше нету... Он покинул наш мир - Он что, умер? :-( - Нет, к интернету подключился!");
INSERT INTO chat_shutnik VALUES("155","Пpиходит женщина к вpачy.\n- Доктоp, y меня такая маленькая гpyдь. Вы не посоветyете как ее yвеличить.\n- Пpотиpайте ее ежедневно тyалетной бyмагой.\n- И что, поможет ? :-O - Hy, глядя на Вашy задницy... должно помочь.");
INSERT INTO chat_shutnik VALUES("156","Суд осудил Вас на десять лет тюрьмы,- говорит судья обвиняемому.\n- Большое спасибо, не надеялся так долго прожить.");
INSERT INTO chat_shutnik VALUES("157","Объявление: \"Для переписки секретных документов срочно требуется машинистка, не умеющая читать\".");
INSERT INTO chat_shutnik VALUES("158","- Как живешь? - спрашивают Менделя.\n- Как пуговица.\n- Как это понять? - В петлю лезть охота.");
INSERT INTO chat_shutnik VALUES("159","На экзамене по праву: -Профессор, между прочим, шпаргалка является моей собственностью, а Вы её изъяли без соблюдения соответствующей прцессуально-правовой прцедуры! -Эх,молодой человек! Я же преподователь, а не милиционер. Не могу же я лупить вас по почкам перед тем, как забрать шпаргалку!");
INSERT INTO chat_shutnik VALUES("160","Кароче, Робинзон Крузо отсидел на своём острове уже 3 года. Всё у него было - и фрукты, и вода, и хлеб: не было только бабы. И вы сами понимаете, как он удовлетворял свои потребности. И вот однажды, только он хотел с собой поиграть - вдали показался корабль. Робинзон быстро забежал на утес и стал жечь костёр и палить из мушкета. И свершилось чудо - на корабле его заметили и поплыли в его сторону. Робинзон размечтался: - Наконец-то! Сначала я приму ванну и помоюсь с мылом. Потом я выпью фунфырик рома. Затем они дадут мне красивую бабу. Я начну с ней танцевать, потрогаю её за попу, поглажу по спине, потом прикоснусь к её грудям, потом брошу её на кровать и раздену. И у неё будет кружевное бельё, и розовые чулочки на подвязках....... Тут он заметил, что у него наступила жестокая эрекция. Он быстро засунул руку в штаны и сказал: - А насчет корабля я-то пошутил! Ха-Ха-Ха-Ха.....");
INSERT INTO chat_shutnik VALUES("161","- Запомни раз и навсегда! - говорит жена мужу.- Если ты будешь приставать к горничной, я с тобой разведусь! - Из-за такого пустяка? - Ты ее разбалуешь. Пойми, такого мужа, как ты, я всегда найду, а такую горничную - вряд ли!");
INSERT INTO chat_shutnik VALUES("162","Штирлиц пришел к выводу. Но Вывода не оказалось дома.");
INSERT INTO chat_shutnik VALUES("163","Hовый русский заваливается к директору одной фирмы на работу (все как полагается - сотовый телефон,малиновый пиджак, etc). Директора нет на месте. Секретарша предлагает: - Вы телефончик оставьте, он позвонит. HР: - Да ты че, дура, ошалела, труба тыщу баков стоит!");
INSERT INTO chat_shutnik VALUES("164","Приехала Зыкина на гастроли в Грузию. Ей бурно аплодируют после каждой песни. Кончила петь - ее вызывают на бис. Спела на бис - ей аплодируют еще сильнее. Выходит она, наконец, на сцену и говорит, что репертуар исчерпан, петь нечего.\n- Зачем петь? - кричат ей из зала.\n- Ты ходи: туда ходи, сюда ходи!");
INSERT INTO chat_shutnik VALUES("165","Граница на карте обозначена точка-тире, точка-тире, что символизирует пограничник-собака, пограничник-собака.");
INSERT INTO chat_shutnik VALUES("166","Когда Рустем вернулся из Японии, где был в командировке, знакомые поинтересовались, как он там объяснялся, не зная японского языка.\n- Надо сказать, трудности бывали, - признался Рустем.\n- Вот, например, когда я хотел купить плавки и жестами объяснил, что мне нужно, продавец принес нож для харакири.");
INSERT INTO chat_shutnik VALUES("167","Урологическая операционная. Лежит больной, подготовленный к операции. Молоденькая сестричка. Входит хирург, с вымытыми руками, в стерильных перчатках: - Сестра, поправьте член.\n- Хмм..., - поправляет.\n- А теперь больному!");
INSERT INTO chat_shutnik VALUES("168","- Винтовка для солдата - лучший друг, не правда ли? - Не знаю, господин генерал! Вчера, когда я ее чистил, она выстрелила мне в ногу!");
INSERT INTO chat_shutnik VALUES("169","В больнице идет обход. Подходят к первому больному. Доктор: Что у вас? Больной: Геморрой! Д: Чем лечат? Б: Йодом мажут! Д: Продолжать! Подходят ко второму. Д: Что у вас? Б: Грибок на ногах! Д: Чем лечат? Б: Йодом мажут! Д: Продолжать! Подходят к третьему. Д: Что у вас? Б: Ангина! Д: Чем лечат? Б: Йодом мажут! Д: Продолжать! Б: Доктор, скажите сестре, чтобы мне первому мазали...");
INSERT INTO chat_shutnik VALUES("170","Жена сказала мужу: - Я очень не люблю твоих братьев. Как появятся у тебя деньги, они все тут как тут и вовсю пользуются твоей щедростью. А когда у тебя в кошельке пусто и ты сам бедствуешь, ни один из них на глаза не покажется. Муж ответил: - Они очень вежливые и не хотят доставлять мне лишних хлопот, когда нам нечем с ними поделиться.");
INSERT INTO chat_shutnik VALUES("171","- Ну что, помогла вам наша отрава избавиться от мышей? - О да, пан аптекарь! Мышам она так понравилась, что они растолстели и не смогли пролезть в нору. Наша кошка переловила их всех и съела!");
INSERT INTO chat_shutnik VALUES("172","Однажды в жаркий полдень молодой папаша вывез коляску с ребенком на улицу и стал с ней прогуливаться.\n- Послушай, Чарли! - послышалось из окна третьего этажа.\n- Оставь меня в покое, - огрызнулся муж, - у нас все в порядке. Через чес раздался тот же голос: - Чарли, Чарли... Ну, что ты хочешь? - стал ворчать муж.\n- Что там у тебя случилось? - Да нет, Чарли, ничего. Но ты вот уже больше часа катаешь в коляске куклу Ненси. Пожалуйста, погуляй немного и с ребенком...");
INSERT INTO chat_shutnik VALUES("173","Муж с женой собираются на свадьбу. Муж, понятное дело, быстренько собрался, а жена все крутится перед зеркалом, примеряет наряды. И то не так, и се не так...\n- Скорее собирайся, мы же опоздаем! Наконец вышли. Приходят к дому, где свадьбу играют, а там один пьянчужка спит под забором, а другой, еле держась на ногах, что-то лепечет. Увидев эту картину, муж сердито говорит жене: - Видишь, люди уже гуляют, а мы еще только идем!");
INSERT INTO chat_shutnik VALUES("174","Дирижер оркестра получает после концерта записку: \"Я не ябеда, но вон тот рыжий детина с усами бьет в барабан только тогда, когда вы на него смотрите!\"");
INSERT INTO chat_shutnik VALUES("175","Сказочка Жил-был мальчик. И подарил однажды этот мальчик девочке цветочек. На следующий день опять подарил, и дарил много-много дней подряд. И говорит однажды ему девочка: - Хватит херней страдать, пошли-ка лучше со мной спать! Мальчик заплакал и говорит: - Я не умею. И пошел прочь от девочки. Идет он, значит, по улице, и плачет. Тут навстречу ему - проститутка.\n- Почему ты плачешь, мальчик? - спрашивает она.\n- А мне девочка предложила с ней спать, а я не умею! - Ну ничего страшного, пошли со мной! И пошли они к проститутке домой, и научила она мальчика всем прелестям вагинального, орального и прочих видов секса. Обрадованный мальчик радостно выбежал на улицу и побежал к своей девочке. Прибегает, а девочка уже спит с другим мальчиком. Наш мальчик опять заплакал и пошел на почту.\n- Отправьте телеграмму.\n- сказал он тетеньке в окошке.\n- Какую? - спросила тетенька.\n- \"Мама, я больше не приду домой, я теперь буду жить своей особенной жизнью!\" - продиктовал мальчик.\n- А как тебя звать-то, мальчик? - спросила тетен");
INSERT INTO chat_shutnik VALUES("176","Интеллигентного вида мужчина садится в такси. Диалог с таксистом: - Вы не могли бы подбросить меня в аэропорт, только нужно на минуточку заскочить на базар? - Без базару! - Да? Ну тогда сразу в аэропорт...");
INSERT INTO chat_shutnik VALUES("177","- Куда девать пенсионеров? - поступают в центр вопросы с мест. Из центра шлют циркуляры: \"У кого трясутся руки из стороны в сторону посылать на мельницу сеять муку. У кого вертится голова направлять в торговлю. У кого трясется голова того сажать в президиум. Ожил Ленин и попросил подшивку газеты \"Правда\" за последние 70 лет. Читает: ЄПрием в Кремле Є3автрак в Кремле ЄОбед в КремлеЄ - Что же вы мне дали? - возмущается Ленин, Это же меню!");
INSERT INTO chat_shutnik VALUES("178","Служанка: - Извините, пожалуйста, но миссис Браун велела сказать, что ее нет дома. Гостья: - Ничего, ничего, голубушка. В таком случае передайте ей, что я очень рада, что не приходила.");
INSERT INTO chat_shutnik VALUES("179","Гpабитель на улице обpащается к хоpошо одетой женщине: - Деньги, мадам! Да поживее! Подумайте, что будет, если стpуя из этого водяного пистолета pазмоет косметику на вашем лице.");
INSERT INTO chat_shutnik VALUES("180","Шотландец и его сын в традиционных юбках идут по Эдинбургу. Навстречу - девушка в брюках. Отец - сыну: - Сколько тебе повторять - не оглядывайся на каждые брюки!");
INSERT INTO chat_shutnik VALUES("181","- Какой смысл вкладывается в выражение \"не тяни кота за хвост\"? - Сколько кота не тренируй, он ящерицей не станет!");
INSERT INTO chat_shutnik VALUES("182","- Доктор, - говорит ассистент, - пациент из второй палаты Иванов скверно себя чувствует.\n- Надо говорить: пациент Иванов думает, что он скверно себя чувствует. Это новейший взгляд на сущность болезней. На следующий день ассистент говорит врачу: - Доктор, больной Иванов думает, что он умер.");
INSERT INTO chat_shutnik VALUES("183","Шла мышка по темному лесу. И чтоб ей не было так страшно она пела песенку: - \"ЛА-ЛА-ЛА-ЛА\" (исполнять громко и страшно).");
INSERT INTO chat_shutnik VALUES("184","Утром...\n- Я жених... я женихххх... я же ниххххрена не помню...");
INSERT INTO chat_shutnik VALUES("185","Деревенский мальчик кричит: - Мама, там молочник пришел. Ты ему деньги отдашь или мне пойти погулять?");
INSERT INTO chat_shutnik VALUES("186","Встречаются два друга.\n- Как твои дела? - Да вот подозреваю, что моя жена мне изменяет с пекарем. Каждый раз раскрывая постель, обнаруживаю в ней хлебные крошки.\n- А..а..а. Теперь и я начинаю подозревать, что моя жена мне изменяет со слесарем из нашего ЖЭКа.\n- Ты что, инструменты в постели находишь? - Да нет. Понимаешь, как ни приду домой, так слесарь лежит в нашей постели.");
INSERT INTO chat_shutnik VALUES("187","Новая Шаума сделала мои волосы такими объемными, что даже ширинка не застегивается!!!");
INSERT INTO chat_shutnik VALUES("188","- Какие герои вышли из книги в реальную жизнь? - Гайдар и его команда!");
INSERT INTO chat_shutnik VALUES("189","Парень повредил палец на руке и пришел к врачу. Врачиха говорит: - Раздевайтесь. Парень: - Зачем? Я ведь всего лишь повредил палец. Мужской голос из-за ширмы: - Это что! Я вообще пришел телефон починить!");
INSERT INTO chat_shutnik VALUES("190","Идут два программера, мими них проходит обалденно красивая девушка. Оба провожают ее взглядом. Идут дальше... Первый: - Да... Плохо, что у девушек нету стандартного интерфейса. Второй: - Ошибаешься! Стандартный интерфейс у них как раз-то есть! Первый: - Действительно. И все же жаль, что не существует стандартного способа этот интерфейс получить.");
INSERT INTO chat_shutnik VALUES("191","20-летняя бабёнка вышла замуж за 90 летнего дедка. После первой брачной ночи она вышла из спальни еле передвигая ноги, вся разбитая и усталая.\n- Господи, что он с тобой сделал?! - спрашивает мать.\n- Он говорил мне, что копил 75 лет... Но я думала, что он имел ввиду деньги.");
INSERT INTO chat_shutnik VALUES("192","Два грузина смотрят фильм: Альпинист лезет на гору из последних сил, лезет, останавливается, опять лезет.\n- Слушай, Гоги, давай поспорим на 1000 баксов, что он не залезет? - Да ты что? Я знаю, он залезет! Поспорили. Альпинист все-таки взобрался. Первый: - Ну, Гоги, ты выиграл, забирай деньги, я проиграл, ты был прав.\n- Слушай, Вано, ну как так можно, ты же мой друг, я не могу взять деньги у друга... К тому же я уже смотрел этот фильм раньше.\n- Ну и что, я тоже смотрел этот фильм раньше, но был уверен, что второй раз точно не залезет!");
INSERT INTO chat_shutnik VALUES("193","- Э, слущай, я себе \"СУПЕРМАЗ\" купил! - А зачэм тэбэ \"СУПЕРМАЗ\"? - Ну как!? Памазал - все праходыт!");
INSERT INTO chat_shutnik VALUES("194","Чувство вины мучило доктора Х. весь день. Как ни пытался он забыть об этом, ничего не получалось. Нервы напряглись до предела. Но время от времени звучал этот подбадривающий внутренний голос: Да не переживай ты так. Ты не первый и не последний врач, который сношается с пациентами. Но тут же неизменно второй, подленький такой голос возвращал его в реальность: Но ты же все-таки ветеринар...");
INSERT INTO chat_shutnik VALUES("195","Возле стройки тормозит \"Мерседес\", из окошка высовывается новый русский и предлагает рабочим: - Мужики, нужен рубероид, даю сотню баксов! Что еще можете толкнуть? Те ошалели от неожиданности: - Все! Кирпич, цемент, стекло, прораба.");
INSERT INTO chat_shutnik VALUES("196","Чебурашка прибегает к крокодилу Гене: - Шапокляк родила! Беги к ней скорее - я своих утопил, а твои плавают!");
INSERT INTO chat_shutnik VALUES("197","На радио Эхо Москвы: - Сегодня, 22 апреля, солнце взошло в 6 утра, погода +12 градусов. Теперь кто из знаменитостей родился в этот день... Хм..., так, ну кто родился, все и так знают, а кто не знает, тем лучше и не надо...");
INSERT INTO chat_shutnik VALUES("198","Диктатору на заметку: если Вы хотите, чтобы все люди жили в одном большом концлагере, уделите должное внимание защите государственной границы.");
INSERT INTO chat_shutnik VALUES("199","Состоялась защита кандидатской диссертации на тему: \"Введение спиртного через задний проход\". Диссертант научно доказал, что этот способ имеет преимущества перед обычным: мало нужно, чтобы опьянеть;можно без закуски;изо рта не пахнет. Оппонент задал вопрос, как при этом способе выпивать на брудершафт.\n- Это тема моей докторской, - ответил диссертант.");
INSERT INTO chat_shutnik VALUES("200","- Смотри, какие тени длинные, и облака тяжелые...\n- Длинные, потому что уже поздно, а тяжелые, потому что мы уже пятый день пьем...");
INSERT INTO chat_shutnik VALUES("201","Знаменитая киноактриса: - А теперь хватит говорить обо мне. Поговорим о вас. Расскажите мне, как я понравилась вам в моем последнем фильме.");
INSERT INTO chat_shutnik VALUES("202","Продам китайский гарнитур из одиннадцати предметов - две циновки и девять портретов Мао Цзедуна.");
INSERT INTO chat_shutnik VALUES("203","Таможенник на границе входит в купе: - Коньяк? Табак? Наркотоки? - Чашечку кофе, пожалуйста.");
INSERT INTO chat_shutnik VALUES("204","Всем известна история о русском мастере Левше, подковавшем аглицкую блоху. Но почему-то история умалчивает о другом мастере Мойше, сделавшем той самой блохе обрезание.");
INSERT INTO chat_shutnik VALUES("205","- Вы помните Нухима Спивака? Когда 20 лет назад он приехал в Америку, у него была только пара рваных штанов. Сейчас он имеет миллион! - Господи! Что будет делать этот ненормальный в Америке с миллионом рваных штанов!?!");
INSERT INTO chat_shutnik VALUES("206","Лежат парень с девушкой в постели. Она(томно): - Трахни меня! Он(напряженно): - Уже трахаю! -=Nail=-");
INSERT INTO chat_shutnik VALUES("207","Школьница спрашивает у матери: - Мама, скажи мне, что такое пятилетка? - Пятилетка, дочка, это трудовой порыв. Через пять лет в стране всего станет в пять раз больше! - Всего-всего? - Да, дочка, и мы в пять раз будем жить лучше! В школе учительница задает вопрос: - Дети, скажите, что такое пятилетка? Желая блеснуть знаниями, ученица подняла руку.\n- Пятилетка - это трудовой порыв, когда всего становится в пять раз больше - и хлеба, и масла, и людейЄ Увидела в окно - покойника везут.\n- ЄИ покойников, и воров, и нищих, и двоечников.");
INSERT INTO chat_shutnik VALUES("208","Хоpонят авторитета. К гpобу очеpедь попpощаться. Один мужик подходит, пpипадает и долго-долго не может отоpваться от усопшего. Его подталкивют, мол, пpоходи, видишь, сколько наpоду еще. А мужик: - Погодите вы, я с бодуна, а он такой холодненький...");
INSERT INTO chat_shutnik VALUES("209","- Почему твой муж часто уходит по вечерам из дому? - спрашивает подруга.\n- Бедняжка, он не любит сидеть дома один.");
INSERT INTO chat_shutnik VALUES("210","Мужчина стоит на набережной и бросает монеты в воду.\n- Что случилось? - удивленно спрашивает прохожий.\n- У меня упала в канал монета.\n- Но для чего вы бросаете туда другие монеты? - Чтобы не лезть в воду ради одной.");
INSERT INTO chat_shutnik VALUES("211","Шел мимо крутой усадьбы бродяга, и потянуло его на халяву.\n- А я так просто не подаю, мужик! - заявил хозяин, лениво развалившись в шезлонге с журналом.\n- Хочешь деньжат - заработай! Вон, пойди на задний двор, там найдёшь краску и покрасишь мне забор... Бомж поплёлся за особняк. А хозяин продолжил листать «Плейбой», да так увлекся, что совсем забыл о «маляре». Опомнился он только тогда, когда тот постучал его по плечу.\n- Закончил я! - бодренько сообщил бродяга, потирая руки.\n- Только вы мне неправильно сказали: у вас там не «Запор», а BMW.");
INSERT INTO chat_shutnik VALUES("212","- Что за кривоногая девчонка была с тобой сегодня утром? - спросил один студент другого.\n- Это та со стройными ножками, с которой ты познакомил меня вчера вечером.");
INSERT INTO chat_shutnik VALUES("213","На вокзале в Риме провинциального вида старушка подходит к окошку кассы и спрашивает, сколько стоит билет на Палермо.\n- Десять тысяч лир, синьора. Старушка оборачивается к своей спутнице и говорит: - Придется, видимо, купить. Я уже спрашивала во всех кассах, и всюду цена у них одинаковая. Не иначе, как договорились...");
INSERT INTO chat_shutnik VALUES("214","- Пани Ковальская, очень прискорбно, но мы вынуждены сообщить, что ваш муж скончался прямо на работе. Пани Ковальская продолжает спокойно обедать.\n- Разве вы не слышите - ваш муж умер! - Слышу, слышу! Подождите, вот я сейчас закончу, тогда вы увидите, какая со мной будет истерика!");
INSERT INTO chat_shutnik VALUES("215","Российскими ученными было доказано, что смешивание водки с молоком приводит к раздражению желудочно-кишечного тракта вследствие недостаточно изученных свойств молока.");
INSERT INTO chat_shutnik VALUES("216","У генерала родился внук. Чтобы узнать, на кого он похож, генерал посылает в роддом адъютанта.\n- На вас! - радостно сообщает вернувшийся адъютант.\n- Вот это да! Докладывай детали! - Внучок ваш лысый, пузатый, ничего не соображает и все время орет.");
INSERT INTO chat_shutnik VALUES("217","В метро едут два парня, а напротив - две девушки. Один парень говорит другому: - Ну что, познакомимся с подругами? - Почему нет? - Ну и отлично. Твоя, правда, страшноватенькая...");
INSERT INTO chat_shutnik VALUES("218","Однажды в Сенате Разумовский отказался подписать решение, которое считал несправедливым.\n- Государыня желает, чтоб дело решено было таким образом,- объявили ему сенаторы.\n- Если так - не смею ослушаться,- сказал Разумовский и подписал свою фамилию \"вверх ногами\". Этот поступок сразу же стал известен императрице, та потребовала объяснений.\n- Я исполнил вашу волю, но так как покривил совестью, то и подпись моя кривая.");
INSERT INTO chat_shutnik VALUES("219","Выходит пеpвый мощный MEN - ТААКОЙ КРУТООЙ ! Снимает доpогенный плащ, достает pоскошный лук и БАЦ !!! Попал в самую точку, не задев добpовольца! Все:\"ООООО\". Мужик:\"I`m ROBIN GOOD\" и удаляется.");
INSERT INTO chat_shutnik VALUES("220","Альпинист покорил вершину. В восторге он стоит наверху и кричит: - Ура, я первый! Эхо доносит: \"Не первый! Не первый!\" Он снова кричит... А эхо снова: \"Не первый! Не первый!\" Альпинист: - Кто это со мной разговаривает? Из-за гребня к нему подходит седенький старичок.\n- Сынок! Это я с тобой разговариваю! - Дедушка, а ты кто? - Я? Волшебник! - И ты можешь выполнить три моих желания? - Конечно! Загадывай! - Во-первых, хочу чтобы у меня был миллион рублей денег! Во-вторых, чтобы моей женой стала \"мисс СССР\"! В третьих, хочу быть не здесь, а дома, в своей квартире! - Хорошо, сынок! Я исполню все три твои желания, если ты исполнишь одно мое? - Какое, дедушка? - Отсоси у меня! - А если я не захочу? - Тогда и твои желания не исполнятся! Альпинист подумал: \"Так уж быть! Ради своих желаний можно и пойти на уступки, тем более, что нас никто не видит... \" - Ладно, дедушка, давай! Взял в рот, сосет. Старичок нежно гладит его по голове: - Такой большой, а в сказки веришь!");
INSERT INTO chat_shutnik VALUES("221","Долго думали в армии, куда чукчу пристроить, и определили в пожарники. Через неделю начальник расчета приходит к начальнику пожарной части: - Опять у нас с чукчей ЧП.\n- Мать вашу етить! сколько раз уже говорил вам, чтоб технику безопасности соблюдали! - Так мы соблюдаем. Вон, ему на верхушке лестницы прибили плакат - СТОП! - Ну и чего ж? - Так он, оказывается, читает медленно.");
INSERT INTO chat_shutnik VALUES("222","Учительница спрашивает: - Петенька, кем ты хочешь стать, когда вырастешь? - Врачом.\n- Молодец. А ты, Ванечка? - Юристом.\n- Умница. А ты, Вовочка? - А я хочу стать придурком.\n- Почему придурком?! - Потому что когда мы с папой выходим из дома, он все время говорит: \"Роскошный дом у этого придурка!\" Или: \"Клевая тачка у этого придурка!\"");
INSERT INTO chat_shutnik VALUES("223","Двое кавказцев играют в шахматы. Один ставит ферзя на центр поля: - Мат! Другой ставит своего рядом: - Отэц!");
INSERT INTO chat_shutnik VALUES("224","- Я слышал, Пол Маккартни к нам приезжает. Будет выступать на Красной площади.\n- А ну его, не пойду.\n- Почему? - Пол без Джона - деньги на ветер.");
INSERT INTO chat_shutnik VALUES("225","Сидят две вороны на дереве.\n- Какие все-таки люди неблагодар-р-рные! - Мы их о дожде пр-редупреждали - предупреждали, а они говорят, что мы его накар-р-ркали!");
INSERT INTO chat_shutnik VALUES("226","Слуга обращается к лорду: - Сэр, осмелюсь доложить, что на кухне некоторым образом возник пожар. Хозяин дома медленно отложил \"Таймс\" и сказал: - Сообщите это леди. Вы же знаете, Робинс, что я не занимаюсь домашним хозяйством.");
INSERT INTO chat_shutnik VALUES("227","Сенбернары - это такие собаки, которые живут в Альпах, они зимой ищут потерявшихся лыжников... тем и живут.");
INSERT INTO chat_shutnik VALUES("228","Штирлиц заходит в кабинет Мюллера, смотрит, Мюллер сидит в фуфайке и играет на балалайке.\n- Группенфюрер, что с вами? - удивился Штирлиц.\n- Полноте вам, Штирлиц, не вы один по Родине скучаете.");
INSERT INTO chat_shutnik VALUES("229","Мужик приходит в кабак.\n- Я здесь вчера сидел.\n- Да.\n- Я всю зарплату пропил? - Да.\n- Фу ты (облегченно вздыхая) Думал потерял.");
INSERT INTO chat_shutnik VALUES("230","Встретились как-то три бывшие шлюхи-пенсионерки: Первая шлюха: - Когда я занималась проституцией, я получала всего лишь 20 баков за минет. Вторая шлюха: - Ну это не так уж плохо, мне в свое время платили за это только 10 баков. Третья шлюха слушала, слушала и тоже решила высказаться: - Я занималась проституцией во время Великой Депресии и делала минет за так - лишь бы набить живот чем-нибудь теплым.");
INSERT INTO chat_shutnik VALUES("231","- Потерпевший, вы напились до такой степени, что упали в оркестровую яму.\n- Гражданин следователь, каюсь - я попал в нехорошую компанию. На троих была одна бутылка водки, и никто, кроме меня, не пил.");
INSERT INTO chat_shutnik VALUES("232","Hа пеpвую годовщину Чеpнобыля все киевские евpеи получили по 2 юбилейных медали: (1-я) За освобождение Киева (2-я) За взятие Одессы.");
INSERT INTO chat_shutnik VALUES("233","Мужской возраст: 1. Взялся за грудь и... поел 2. Взялся за грудь и... кончил 3. Взялся за грудь и... возбудился 4. Взялся за грудь и... уснул");
INSERT INTO chat_shutnik VALUES("234","Сидят два мужика и ловят рыбу. А один грустный такой. Друг его спрашивает: - Что случилось? - Да у жены день рождения был, а я забыл поздравить. Посидели, помолчали. Тут друг успокаивать начал: - Знаешь, я тебе сейчас всё объясню. Ты вот, например, помнишь день, когда ты поймал самую большую рыбу? - Конечно, помню! - Так вот, а рыба - не помнит!");
INSERT INTO chat_shutnik VALUES("235","Мужик в подавленном состоянии приходит к психиатру и жалуется: - Доктор, помогите, я никогда не пользовался успехом у женщин, они от меня разбегаются, а ведь мне уже 35 лет, я больше не могу так жить! - Успокойтесь, эта проблема на самом деле легко решается, просто вам необходимо вырабатывать уверенность в себе. Каждое утро вставайте перед зеркалом, оглядывайте себя с ног до головы и повторяйте: я уважаемый человек, люди мною восхищаются и завидуют мне, я сильный и чертовски привлекательный. Поверьте мне, как только у вас появится уверенность в себе, женщины так и будут липнуть к вам. У пациента заметно улучшается настроение, и он уходит. Но через неделю он снова приходит подавленным. Психиатр спрашивает: - Вы не последовали моему совету? - Последовал, и все получилось именно так как вы сказали.\n- Так в чем же тогда у вас проблема? - Да это не у меня, это у жены проблема.");
INSERT INTO chat_shutnik VALUES("236","Встретились как-то грузин и американец. Спорят, кто лучше живет.\n- У нас каждый американец имеет квартиру отдельную - У нас кажадый грузин имеет большой коттедж.\n- У нас каждый американец имеет машину.\n- А у нас каждый грузин имеет самолет.\n- Слушай, а что ты все про грузин да про грузин? А русские-то у вас как живут? - Я же у тебя про негров не спрашиваю...");
INSERT INTO chat_shutnik VALUES("237","- Слышал, говорят, что на рынке уже можно купить говядину по рублю за килограмм.\n- Ну, это вранье! - Пускай, лишь бы дешево!");
INSERT INTO chat_shutnik VALUES("238","Сидят чукчи у моря.\n- Смотри, самолет полетел! - Да-а-а! Наверное правительственный.\n- Нет.\n- Почему? - Мотоцикла впереди нету!");
INSERT INTO chat_shutnik VALUES("239","Заходит в купе парень без уха и смеется! Его спрашивают: - Ты что? Ухо потерял - плакать нужно! - Что там ухо! На свадьбе драка была! Мне ухо оторвали, а член жениха - вот, у меня в кармане!");
INSERT INTO chat_shutnik VALUES("240","На скамье в парке сидит человек и, с негодованием глядя на идущего мимо пьяного, говорит: - Безобразие! Я бы вылил весь мировой запас спиртного в океан! Сидящий рядом мужчина аплодирует: - Браво! Отличная идея! - Вы тоже трезвенник? - Нет, я водолаз...");
INSERT INTO chat_shutnik VALUES("241","- Карлссон, опять щенок в углу насрал...\n- А где ж ему срать, на шкафу, что ли? Так только я могу!");
INSERT INTO chat_shutnik VALUES("242","- Мой муж хочет, чтобы я поступила на кулинарные курсы.\n- Вот как! А я и не знала, что вы приобрели собаку.");
INSERT INTO chat_shutnik VALUES("243","Стали Винни с Пятачком альпинистами. Ползут по стене.\n- Винни, Винни я прополз 15 метров и не вбил ни одного крюка.\n- Бей шлямбур, толстая свинья.\n- Но Винни, если я его забью он испортится.\n- Если ты его не забьешь, то испортимся мы оба.");
INSERT INTO chat_shutnik VALUES("244","После жуткого перепоя просыпается утром тетка. Во рту - кошки насрали, под глазами - черные круги, волосы торчком. Смотрит на себя в зеркало и говорит: - Я тебя не знаю, но я тебя накрашу.");
INSERT INTO chat_shutnik VALUES("245","Реальная история (вот так анекдоты и размножаются). Приятели заказали другу на день рождения семь девочек по вызову (ну процветает разврат среди молодежи, процветает!). Отметили отлично. На следующий день стадия \"разбор полета\". Довольный именниник благодарит: - Да, спасибо, все было классно, только я всего пятерых смог, но я же здорово пьяный был. А вот если бы трезвый был, то я бы, конечно, больше смог...\n- Знаешь, если б ты был трезвый... ТЫ БЫ НИ ОДНУ ИЗ НИХ НЕ СТАЛ!!!");
INSERT INTO chat_shutnik VALUES("246","Лукашенко перед вылетом в Москву на встречу с Путиным: «Я рад, что госпожа Райс, пролетая над Белоруссией, могла убедиться, что терроризма в ней нет. Никто ракеты по ней не выпустил». А руки так чесались...");
INSERT INTO chat_shutnik VALUES("247","Пожелание врагу: -Чтобы я увидел тебя на костылях, а ты меня одним глазом!");
INSERT INTO chat_shutnik VALUES("248","Тесть и зять работают на одной шахте, но в разные смены. Видятся только когда одного поднимают, а другого опускают в забой. Как-то раз происходит следущее... Поравнявшись в своих подъемниках и увидев друг друга, зять крутит пальцем около виска. Тесть, в ответ, крутит обеими пальцами у своих висков. Зять - резко сгибает одну руку в локте, а другой перекрещивает согнутую. Тесть - вытягивает одну руку, а другой бьет себя по ней в области плеча и показывает на свой зад. Народ - в шоке... Старый шахтер говорит зятю: - Что же ты со своим тестем никак общий язык не найдешь? Я его столько лет знаю - мужик просто замечательный! - Да вы ничего не поняли! - отвечает зять, - У нас великолепные отношения! Я его спросил знаком: \"Моя дура дома?\" - он ответил знаком: \"Обе - дома\". Дальше я его спросил: \"0,5 есть?\", на что он ответил: \"Есть 0,7 и стоит за унитазом!\" Вообще-то, этот анекдот надо показывать.");
INSERT INTO chat_shutnik VALUES("249","Просыпаются утром отец и сын.\n- А что, сынок, неплохо бы нам с тобой сейчас принять по сто грамм.\n- Дело говоришь, батя, дело. Сбегал сын в магазин, принес водки. Посидели, выпили.\n- Hу что, сынок, неплохо бы нам еще по-немногу? - Дело говоришь, батя, дело! Сбегал, еще принес. Выпили.\n- Hу что, сынок, теперь и поработать можно? - Hу, батя, ты как выпьешь - такую фигню нести начинешь!");
INSERT INTO chat_shutnik VALUES("250","С того времени, как нашего соседа сняли с должности генерального директора, он растерял половину своих друзей.\n- А как та... вторая половина? - Они еще не знают об его отставке.");
INSERT INTO chat_shutnik VALUES("251","Адвокат(А): - Итак, утром,25 июля, Вы шли со своей фермы по направлению к пастбищу? Свидетель(С): - Да. А: - Значит, Вы прошли всего в нескольких метрах от водоема с утками? С: - Да. А: - Заметили ли Вы что-то необычное? С: - Да. (Молчит) А: - Могли бы Вы сообщить суду, ЧТО Вы видели? С.\n- Я увидел Джорджа. А: - Вы увидели Джорджа.....обвиняемого в данном случае? С: - Да. А: - Могли бы Вы сказать суду, что Джордж...э.э.э.э....делал в это время? С: - Да. (Молчит) А: - Ну, ну, так что же он делал? С: - Ну....он засунул свою...э.э.э.... штучку....в одну из уток. А: - Свою \"штучку\" ? С: - Ну....Вы знаете...ну, штучку....свой ху......ну....свой пенис. А: - Итак, Вы проходили возле пруда, было уже светло, Вы были совершенно трезвы, у Вас хорошее зрение и Вы все это видели совершенно четко? С: - Да. А: - Сказали ли Вы что-нибудь Джорджу? С: - Разумеется! А: - И ЧТО Вы ему сказали?!! С: - Доброе утро, Джордж.");
INSERT INTO chat_shutnik VALUES("252","Один чудак в гостинице спрашивает номер, ему отвечают: \"Нет, мол, номеров\". А он ну очень упрашивает - ну хоть каморку какую-нибудь. Ему и говорят: - Ну ладно, есть один люкс, но у него слава дурная, там уже восемь человек повесилось. Чудак в ответ: - Я не суеверный. Отводят его в номер, показывают ему все, а он спрашивает: - А как, мол, повесились-то? - Все вот на этой дверной ручке.\n- Не может быть! - Да вот, уж, смогли. Утром уборщица открывает дверь - мужик висит на ручке двери, мертвый.\n- Елки зеленые, еще один любопытный.");
INSERT INTO chat_shutnik VALUES("253","Звезда Голливуда говорит своей приятельнице: - Я купила тебе в подарок книгу. По-моему, это учебник танцев под названием \"Оливер Твист\".");
INSERT INTO chat_shutnik VALUES("254","Пришел наркоман к стоматологу и говорит: - Доктор, вырвите мне зуб.\n- Вам под местным или под общим наркозом? - Что, одурел!? Под общим, конечно! И так 32 раза...");
INSERT INTO chat_shutnik VALUES("255","Песня пилота самолета МИГ, занимающегося сексом с девушкой за штурвалом самолета: Чем дорожу, чем рискую на Свете я, МИГом одним, только МИГом одним...");
INSERT INTO chat_shutnik VALUES("256","Конец мая. Училка на последнем в учебном году классном часе: - Дети, что для вас тpуднее всего было в 3-м классе? - Объяснять пpодавщице для кого покупается водка!!!");
INSERT INTO chat_shutnik VALUES("257","В троллейбусе едут два друга. Один рассказывает анекдот другому: - Ты, говорит, знаешь, почему менты всегда по трое ходят? Один имеет читать, второй писать, а третий следит за этими интеллектуалами! Тут с задней площадки протискиваются два мента. Предъявите, мол, документы и все такое... Один берет паспорт и говорит другому: - Вась, записывай...");
INSERT INTO chat_shutnik VALUES("258","Волк поймал Красную Шапочку в лесу.\n- Я тебя съем, - говорит. Красная Шапочка: - Не надо меня есть, я еще такая маленькая. Лучше вые@и меня. Волк подумал, подумал: - Ну ладно, говорит, только ты меня обеими руками за уши держи.\n- А у тебя там что, эрогенные зоны? - Да нет, просто знаю я вас, таких... Вечно по карманам шарите.");
INSERT INTO chat_shutnik VALUES("259","Мне сказали, Что от веснушек можно избавиться, если опустить лицо в муравейник на 5-6 минут.");
INSERT INTO chat_shutnik VALUES("260","- Ну, что? Опять вчера дома выволочка была? - Не то слово. На порог не пустила. В подъезде ночевал.\n- Чудак. Ты, прежде чем позвонить, разденься догола. А как она дверь откроет, бросай туда свои шмотки. Голого не оставит в подъезде. На другой день.\n- Ну как, пригодился мой совет? - Все сделал, как ты говорил. Двери открылись, я бельишко туда - шварк! Тут она чужим голосом громко говорит: \"Осторожно, двери закрываются. Следующая станция \"Маяковская\".");
INSERT INTO chat_shutnik VALUES("261","Ноги позволяют мужчине идти, а женщине еще и продвигаться.");
INSERT INTO chat_shutnik VALUES("262","- Девушки 90-60-90! Hе ищите пpиключений на свои 90!");
INSERT INTO chat_shutnik VALUES("263","Преподаватель автошколы спрашивает у студентов, сколько дел может одновременно делать водитель? Они начали перечислять: - 2 дела- управлять автомобилем и говорить по мобильнику.\n- 3 дела- управлять автомобилем, говорить по мобильнику и слушать музыку.\n- 4 дела- управлять автомобилем, говорить по мобильнику, слушать музыку и жевать бутерброд.\n- 5 дел- управлять автомобилем, говорить по мобильнику, слушать музыку, жевать бутерброд и отливать в памперсы... Ну, вроде все! Преподаватель: - Нет! Вы забыли еще одно дело.\n- Какое?! - Давить пешеходов!");
INSERT INTO chat_shutnik VALUES("264","Три проститутки сидят в баре, и одна жалуется остальным: - Сегодня неудачный день... Я заработала всего $100 -взяла в рот 4 раза по $50, а половину забрал сутенер... Другая отвечает ей: - Это еще ничего - я сегодня заработала $50 - всего 2 минета по $50, и тоже половину сутенеру... Сидящая рядом старая проститутка заявляет: - Вы не знаете, что такое плохая жизнь... Во времена Великой Депрессии мне иной раз приходилось по 10 раз в день делать минет бесплатно, только для того, чтобы иметь в пищу что-нибудь горячее...");
INSERT INTO chat_shutnik VALUES("265","Объявление о приеме на работу. Условия: Два дня работаешь, пять лет сидишь, зарплата сдельная.");
INSERT INTO chat_shutnik VALUES("266","Один умелец сделал часы, которые при произнесении матерного слова спешат на одну минуту. Для испытания повесили часы в детском саду, в училище, и в воинской части. Через месяц решили проверить результаты эксперимента. В детском саду часы ушли вперед на 10 минут, в училище - на полчаса. Пришли в воинскую часть - часов нет! Спросили у дневального: - Куда часы подевались? - Какие часы?! А... этот вентилятор командир приказал снять на следующий же день.");
INSERT INTO chat_shutnik VALUES("267","В 30-е годы мужик заполняет анкету и дошел до вопроса \"Как спите с женой ?\" Что писать? Напишешь \"слева\" - пришьют левый уклон. \"Справа\" - правый уклон. \"Сверху\" - возвышение над массами. \"Снизу\" - идешь на поводу у масс. Написал: \"сплю отдельно, занимаюсь онанизмом\". Ему дали 10 лет \"за кулацкий уклон и растрату семенного фонда\".");
INSERT INTO chat_shutnik VALUES("268","Если, проснувшись с глубокого похмелья, вы взглянули в зеркало и никого там не увидели - значит, вы стали просто неотразимы.");
INSERT INTO chat_shutnik VALUES("269","- Почему в Люксембурге не любят играть в футбол? - Очень неудобная игра: посильнее ударил по мячу и за ним надо бежать то в Бельгию, то в Германию, а то и во Францию... jonas");
INSERT INTO chat_shutnik VALUES("270","Человек приходит к директору завода и спрашивает: - Вам нужен начальник отдела кадров? - Нет.\n- А зачем вы его тогда держите?");
INSERT INTO chat_shutnik VALUES("271","Hовый русский на \"Мерседесе\" на огромной скорости въезжает в небольшой городок. Его тут же останавливает инспектор и говорит: - С вас штраф за превышение скорости свыше 30 километров в час в размере 500 рублей.\n- Hа тебе тысячу без сдачи - я на такой же скорости хочу покинуть ваш гнусный городишко!");
INSERT INTO chat_shutnik VALUES("272","Певичка была заранее уверена в своем успехе: - Пусть только попробуют плохо аплодировать - я буду петь песни о Сталине!");
INSERT INTO chat_shutnik VALUES("273","- Папа, мы евреи? - Нет, сынок.\n- А когда будем?!");
INSERT INTO chat_shutnik VALUES("274","- Дети! Я сейчас проходила мимо столовой и видела на полу булку хлеба. Кто-то бросил хлеб на пол и играл им в футбол. А вы знаете, сколько он стоит?! Да он полторы штуки стоит! Довели страну, реформаторы хреновы!");
INSERT INTO chat_shutnik VALUES("275","Пожилая женщина сделала молодежную стрижку и спрашивает мужа: - Дорогой, правда, я теперь не похожа на старуху? - Да, ты теперь похожа на старика.");
INSERT INTO chat_shutnik VALUES("276","Российский политик перед выборами: - Мой конкурент, находясь при власти, бессовестно обворовывал вас все эти годы! Все, о чем я вас прошу сегодня , это дать мне шанс!");
INSERT INTO chat_shutnik VALUES("277","В зоопарк сам прилетел попугай. Хочу, говорит, у вас поселиться. Ну, звери его обступили, говорят, рассказывай, как случилось такое, чтоб кто-то сам явился жить в зоопарк. Попугай говорит, это долгая история. Я 10 лет жил у одного дрессировщика. Мы выступали в разных цирках с большим успехом, потому что я умел имитировать самые разные голоса и звуки. Я подражал паровозному гудку, клаксонам машин, тиканью ходиков, крикам льва, мурлыканью кота, воплям обезьян... Но потом я состарился, и мне стало уже трудно заниматься этим ремеслом. Контракты прекратились. Нам просто стало нечего есть. И однажды вечером мой хозяин затопил печь, посмотрел на меня долгим взглядом и сказал: - Ну чего, братан, сымитируй крик фазана.");
INSERT INTO chat_shutnik VALUES("278","Телефонный звонок.\n- Позовите, пожалуйста, Рабиновича.\n- Его нет.\n- Он на работе ? - Нет.\n- В командировке ? - Нет.\n- В отпуску ? - Нет.\n- Я вас правильно понял ? - Да !");
INSERT INTO chat_shutnik VALUES("279","Приводит Дочь(Д) Нового Русского(НР) домой жениха-Выпускника семинарии.(В) (НР)с ним наедине: (НР)-Ты знаешь,моя дочь любит каждые три месяца отдыхать за границей!Что ты будешь делать? (В)-Боженька поможет. (НР)-А шубы она меняет как перчатки!Что будешь делать? (В)-Боженька поможет. (НР)-И машины меняет одну за другой...Что будешь делать? (В)-Боженька поможет. Короче на все вопросы отвечал-Боженька поможет! После его ухода,дочь спрашивает отца: (Д)-Пап,ну как он тебе? (НР)-Да так себе...Но то,что он меня Боженькой называет,мне нравится!!! :)");
INSERT INTO chat_shutnik VALUES("280","Троллейбус. Контроллер: - Ваш билет.\n- А ты кто такой? - Контроллер. [Громко, на весь троллейбус] - А! Контроллер! [Все щелкают компостерами]");
INSERT INTO chat_shutnik VALUES("281","- Вчера на меня напал бандит, но я даже не заявил в полицию.\n- Почему же? - Он обшарил все мои карманы, вздохнул и дал мне доллар.");
INSERT INTO chat_shutnik VALUES("282","У окулиста: - Доктор, у меня после свадьбы начались проблемы со зрением: я не вижу денег !");
INSERT INTO chat_shutnik VALUES("283","Молодая девушка в день своего совершеннолетия получает нарядное вечернее платье.\n- Мама, что это за материал? - Разве ты не видишь, это шелк.\n- Смотри, какая прелесть. И это все от маленького, никудышного червячка? - Как тебе не стыдно называть так своего собственного отца!");
INSERT INTO chat_shutnik VALUES("284","Из сообщений \"Дорожного патруля\". В лесопарковой зоне Михино было найдено тело с документами на имя гражданина К. Неожиданное осложнение в работу прибывших на место происшествия сотрудников милиции внесло то обстоятельство, что сам гражданин К. решительно отказался признавать свое тело и потребовал вызвать для опознания супругу, находящуюся в данное время в служебной командировке.");
INSERT INTO chat_shutnik VALUES("285","Социологический опрос: \"Как военное положение влияет на семейную жизнь?\" Самый популярный ответ: \"Очень хорошо! а) Жена в противогазе молчит все время. б) Лица жены я под противогазом не вижу. в) А если находясь в постели дырочку в баллоне заткнуть, то она даже пошевелиться может\".");
INSERT INTO chat_shutnik VALUES("286","- Папа! А почему бабушка по огороду бегает зигзагами? - Кому бабушка, а кому и теща. Дай-ка, сынок, вторую обойму!");
INSERT INTO chat_shutnik VALUES("287","Мyж c женой загоpают на пляже. Мyж, щyплый человек небольшого pоcта заметил, что его жена не отpывает глаз от cидевшего неподалекy кpyпного, мycкyлиcтого кpаcавца. Hе выдеpжав, мyж обpащаетcя к жене: - Зpя ты пялишьcя на него, доpогая. Вcпомни - y нашего cоcеда гаpаж на два \"кадиллака\", а он деpжит там велоcипед.");
INSERT INTO chat_shutnik VALUES("288","ртист пригласил на спектакль своего друга. После спектакля он сидит в гримерной, вытирает грим. Артист: - Ну что, как спектакль? Друг: - Чудесно! Все актеры играли как боги, сцена слилась с залом, просто полное проникновение, но ты... то слова забудешь, то на бабу в зале засмотришься.\n- Угу... А музыка тебе как? - Прекрасно, чувствуется, что композитор чувствовал пьесу, от драматических актеров не ожидал такого вокального таланта, правда, ты то не в такт запоешь, то петуха пустишь.\n- Умм... А декорации понравились? - Бесподобно!!! На всех актерах костюмы с иголочки, ну как в прошлом веке, правда, у тебя пуговица оторвана, ботинки нечишены, не понимаю.\n- Ага... а что, жена-то твоя все блядует?");
INSERT INTO chat_shutnik VALUES("289","Бог создал три качества - честность, ум и партийность, - но никому не дал больше двух. Так что если человек умный и честный, то он беспартийный. Если он честный и партийный, то он не умный. А если он умный и партийный, то он нечестный.");
INSERT INTO chat_shutnik VALUES("290","А вы пробовали принять слабительное одновременно со снот- ворным? Интересный эффект получается.");
INSERT INTO chat_shutnik VALUES("291","Журналист спрашивает у Карпова: - Ваше мнение о Deep Blue? - Душно и тесно.");
INSERT INTO chat_shutnik VALUES("292","Новый русский обсуждает с архитектором проект новой виллы.\n- Кароче, а тут рядом с сауной - чтобы три бассейна... один с горячей водой, другой с холодной, а третий - без воды! Архитектор: - А зачем вам бассейн без воды??? ж:-[] НР: - Ну ты прикинь, а вдруг у меня в сауне будут гости, которые плавать не умеют?");
INSERT INTO chat_shutnik VALUES("293","Пpишла весна. Зазвенела капель. Запели птички. Двоpник Hикодим вышел на улицу. Соpвавшаяся с кpыши сосулька убила двоpника Hикодима... Пpозектоp в моpге задумался над гpафой о пpичине смеpти и, улыбнувшись, написал: \"Весна пpишла\".");
INSERT INTO chat_shutnik VALUES("294","Сколько нужно ирландцев, чтобы закрутить лампочку? - Двое. Один держит лампочку, а второй пьёт виски, чтобы комната пошла кругом.");
INSERT INTO chat_shutnik VALUES("295","Судят грузина за изнасилование мальчика... Судья: - Расскажытэ, как это било? - Море - синий, синий; солнцэ - жолтый, жолтый; мальчык - попа розовый, розовый... Эх! Судья: - Эх! Расскажытэ еше раз, как это било...\n- Море - синий, синий; солнцэ - жолтый, жолтый; мальчык - попа розовый... розовый, розовый... Эх! Судья: - Суд удаляется на совещание! Через несколько минут...\n- Народный суд города Тбилиси постановил! Солнце желтый-желтый - продолжать светить. Мальчикам с розовой попкой по берегу синий-синий моря - нэ ходить, а подсудимый Габелия - па-автарите, пожалуйста, свой рассказ!");
INSERT INTO chat_shutnik VALUES("296","Сидя в джипе, бывший не в духе сержант приказал водителю: - Мне что-то не нравятся физиономии вон тех солдат около лужи. Ну-ка дай по газам и обдай их водой. Водитель послушно нажал на педаль газа и направил джип на лужу, в которую автомобиль буквально нырнул, так что на поверхности остались только головы сержанта и водителя. Это была канава, доверху наполнившаяся водой.");
INSERT INTO chat_shutnik VALUES("297","Один норвежец решил разводить птицу, купил 500 цыплят и... закопал их у себя в саду. Результат: все цыплята сдохли. Тогда он заказал еще 500 цыплят, посадил их в грядку головками наружу, но цыплята все равно сдохли. Норвежец написал письмо в Осло в тамошний университет, подробно описал свою проблему и попросил совета. Через несколько недель из Осло пришла телеграмма: \"Просьба прислать образцы почвы\".");
INSERT INTO chat_shutnik VALUES("298","Винни-Пух спрашивает у Пятачка, кем был его дед.\n- Мой дед был отбивной.\n- А кем был твой отец? - Мой отец был шашлыком! - Слушай, Пяточок, а кем ты хочешь стать? - Да вот, космонавтом...\n- А чё так грустно? - Да боюсь, в тюбик не влезу...");
INSERT INTO chat_shutnik VALUES("299","Врач говорит пациенту, очнувшемуся от наркоза: - Операцию вы перенесли хорошо, а вот перед ней вы вели себя просто невозможно: вырывались, кричали... А ваш знакомый с соседней койки вел себя еще хуже! - Еще бы! Ведь нас в клинику послали окна мыть.");
INSERT INTO chat_shutnik VALUES("300","Мой компьютер постоянно обыгрывает меня в шахматы. Зато я всегда побеждаю его в боксерском поединке!");
INSERT INTO chat_shutnik VALUES("301","- Что такое Советская власть? - спрашивает сын программиста у своего папы.\n- Это сынок, такая жутко глючная программа: пять лет ее устанавливают, затем 50 лет перезагружают компьютер, а потом оказывается, что вся система полетела и ее менять надо! Голем");
INSERT INTO chat_shutnik VALUES("302","Стоит наркоман, косяк забивает ( в ладони левой руки анаша). Подбегает девочка: - Дяденька, сколько время? Наркоман молчит. Девочка снова: - Дяденька, сколько время? Молчит. Девочка: - Дяденька, дяденька, ну сколько время? Hаркоман переворачивет ладонь и смотрит на часы: - Пи##ец тебе, девочка.");
INSERT INTO chat_shutnik VALUES("303","У речки с удочками сидят Счастливчик и Неудачник. У одного, естественно, клюет, у другого - нет. Неудачник интересуется: - На что ловишь? - На червя,- отвечает Счастливчик,- хочешь, бери! Вынимая жирного червя, тот спрашивает: - Ты где берешь таких красавцев? - Все очень просто. Отвожу от розетки провода и втыкаю их в огороде на грядке. Черви ползут как миленькие, собирай - не хочу. На следующий день Неудачник приходит весь в синяках.\n- Что с тобой? - изумился Счастливчик.\n- Да мало мне показалось двести двадцать вольт. Вышел в поле, там, где ЛЭП проложена, закинул провода, воткнул в землю и жду, когда черви появятся. А тут вылезли шахтеры и так морду набилиЄ");
INSERT INTO chat_shutnik VALUES("304","Опять же к доктору приходит женщина : - Доктор, у Вас есть 100%-ное противозачаточное средство. Доктор:(достает какие-то таблетки) - Вот, пожалуйста.\n- А это 100%-ное ? - Hет, 90.\n- А мне нужно 100. Доктор:(достает таблетки побольше) - Вот.\n- Это 100 ? - Hет, 95.\n- Hо мне-то нужно 100 ! Доктор: - Подождите. (достает таблетку величиной с ладонь) - Вот.\n- Hу это-то хоть 100 ? - Hет, 97.\n- Я вижу, Вы меня не понимаете... Доктор: - Hу, тогда... (двумя руками достает из шкафа таблетку величиной с автомобильное колесо) ... вот ! - О-о-о ! 8-0 Hу это наверно все 100...\n- Hет, Вы знаете, это 99.\n- Hо что-же мне делать ? Доктор: - Я кажется знаю... (долго копается в столе и наконец достает маленький металлический шарик) ...Вот что Вам нужно ! - И это 100%-ное ??? Доктор:(облегченно) - Да.\n- А как-же его использовать ??? - Держать между ногами во время полового акта !");
INSERT INTO chat_shutnik VALUES("305","Он был таким интеллигентным. Маму называл на вы.\n- Мама, вы что, охренели?");
INSERT INTO chat_shutnik VALUES("306","Если ваша жена хочет научиться водить автомобиль, самое главное - не стоять у нее на пути.");
INSERT INTO chat_shutnik VALUES("307","- А вот я тёще на день рождения подарил стиралку и сушилку! - Наверно, кучу денег выкинул? - Да не, всего баксов за 18! - ??????????? Это что ж за техника такая? - Тазик и полотенце!");
INSERT INTO chat_shutnik VALUES("308","Во время войсковых маневров начальник артиллерии замечает, что одно из орудий не стреляет. Он вызывает по рации командира батареи и требует доложить, в чем дело.\n- Дело в том, - докладывает тот, - что орудийный расчет так замаскировал свою пушку, что теперь не может ее найти.");
INSERT INTO chat_shutnik VALUES("309","- Когда читаю медицинскую энциклопедию, я обнаруживаю у себя все болезни.\n- Это бывает. Когда я читаю уголовный кодекс, то на каждой странице чувствую себя за решеткой.");
INSERT INTO chat_shutnik VALUES("310","Один мужик видя, что его сосед играет в карты со своей собакой восхищенно говорит ему: - Какая у Вас умная собака - Какая же она умная, видишь хвостом виляет, значит ей хорошая карта пришла.");
INSERT INTO chat_shutnik VALUES("311","Играют в карты Кощей Бессмертный, Баба Яга, Умный Мент и Глупый Мент. На столе лежит куча денег. Внезапно гаснет свет. Когда свет зажигается, денег нет. Вопрос: Кто украл деньги? Ответ: Глупый Мент. Вопрос: Почему? Ответ: Потому что все остальные - вымышленные персонажи.");
INSERT INTO chat_shutnik VALUES("312","- Я всегда любил слушать хорошие анекдоты, но быстро их забывал. Поэтому я стал их придумывать сам. Получилось совсем не хуже, и даже лучше.\n- Почему ты так решил? - Потому что не только я, но и все мои знакомые, которые слышали эти анекдоты, тоже их быстро забывают!");
INSERT INTO chat_shutnik VALUES("313","Из отчета слyжб безопасности \"... по поводy взлома китайцами сеpвеpа Пентагона\": ....... 1) Каждый китаец попpобовал один паpоль. 2) Каждый втоpой паpоль был \"maodzedun\" 3) Hа -й попытке сеpвеp согласился что y него паpоль \"maodzedun\"");
INSERT INTO chat_shutnik VALUES("314","Звонок в двеpь. Hа поpоге Дед Моpоз. Маленький мальчик кpичит: - Здpавствyй, Дедyшка Моpоз! Ты подаpки... Дед Моpоз: - Hе тpанди, пацан! Штопоp есть?!");
INSERT INTO chat_shutnik VALUES("315","Муж возвращается из командировки и видит у подъезда припаркованный \"Мерседес-600\". Заходит домой. Hа вешалке - красный пиджак, на столе - радиотелефон, в постели - жена с каким-то мужиком. Муж толкает мужика в бок: - Ты чего здесь делаешь? - Как чего? Hе видишь - новых русских делаем.");
INSERT INTO chat_shutnik VALUES("316","У него было трудное детство - до пяти лет, он был уверен, что его зовут: -\"Идитынах%й\"");
INSERT INTO chat_shutnik VALUES("317","Анекдот для москвичей: А раньше \"Лысый в кепке\" означало: \"Ленин\"...");
INSERT INTO chat_shutnik VALUES("318","Приходит пролетарий домой и, увидев свою жену с соседом, гово- рит: \"Вот вы тут глупостями занимаетесь, а в магазине, между про- чим, колбасу дают!\"");
INSERT INTO chat_shutnik VALUES("319","У фотографа: - Товарищ фотограф, это не моя фотография.\n- Как же не ваша, а, по-моему, похоже получилось.\n- А вот смотрите, нос же не мой.\n- Да, как будто не ваш.\n- А эта бородавка! У меня нет никакой бородавки.\n- Гм, действительно нет.\n- И потом, этот лежит в гробу, а я еще живой.");
INSERT INTO chat_shutnik VALUES("320","Женская мысль давно хотела попасть в мужскую голову... И вот она наконец-то туда залетает, счастливая.. А там никого нет. Пусто. Она смотрит по сторонам и вдалека видит летящую мужскую мысль. Женская мысль зовет мужскую, та подлетает... Женская мысль говорит: - Я так хотела сюда попасть.... А тут нет никого? Мужская мысль ей отвечает: - Ах, дурочка! Мы уже все внизу тусуемся...!");
INSERT INTO chat_shutnik VALUES("321","Инженер, парикмахер и экономист путешествовали по сельской местности. Устав, они остановились в маленькой харчевне.\n- У меня только две комнаты, - извинился хозяин.\n- Одному из вас придется спать в амбаре. Как водится, в амбар добровольно подался инженер. Вскоре уже засыпавших его товарищей разбудил стук. За дверью стоял инженер: - В амбаре корова. А я - индуист и по своей вере не имею права спать рядом со священным животным, - объяснил инженер. В амбар направился парикмахер. Не успели путники заснуть, в дверь снова постучали. За дверью стоял парикмахер: - Там свинья. Я, как еврей, не могу спать рядом с нечистым животным. Не оставалось ничего другого, как пойти в амбар экономисту. Под утро снова раздался стук. Удивленные приятели увидели за дверью корову и свинью.");
INSERT INTO chat_shutnik VALUES("322","В больнице две дамы говоpят о только что умеpшей подpуге: - Хотелось бы мне иметь ее ноги - у нее были пpелестные ноги! Жалко - тепеpь пpопадут...");
INSERT INTO chat_shutnik VALUES("323","Разговаривают два алкаша: - Я намедни пить бросил...\n- ??? - А вот куда - не помню!..");
INSERT INTO chat_shutnik VALUES("324","Осень, сыро, холодно. В пивную заходит оборванец и просит налить кружечку похмелиться. Бармен говорит жалостливо: - Ты бы лучше себе носки потеплее купил.\n- На хрена? Здоровье дороже!");
INSERT INTO chat_shutnik VALUES("325","Корсиканец с гордостью говорит приезжему: - У нас воруют так, что во многих местах железная дорога проложена кольцами.\n- А зачем? - Чтобы машинист мог убедиться, что все вагоны на месте.");
INSERT INTO chat_shutnik VALUES("326","Как известно, спартанцы учили детей плавать, попросту сбрасывая их со скалы в море. Интересно, если начать сбрасывать детей с самолета, хоть некоторые из них научатся летать?");
INSERT INTO chat_shutnik VALUES("327","Уход за волосами - смерть лысого человека.");
INSERT INTO chat_shutnik VALUES("328","Взвод морских пехотинцев пришол в кинотеaтр нa просмотр голивудского боевикa. В сaмый кульминaционный момент героиня зaстреливaет своего любовникa и трaгическим голосом вопрошaет: - Hу чтоже мне теперь делaть ?! Kомaндный голос из зaлa: - Осмотреть оружие и отойти зa огневой рубеж!");
INSERT INTO chat_shutnik VALUES("329","- Мадам, вы, очевидно, принимаете меня за дурака? - Что вы, я никогда не сужу о людях по первому впечатлению.");
INSERT INTO chat_shutnik VALUES("330","Как и полагается, у сексопатолога: - Доктор, Вы знаете, у меня не стоит...\n- А Вы, батенька, сюда трахаться, что ли, пришли ?!.");
INSERT INTO chat_shutnik VALUES("331","Что делают чукчи, когда холодно? Закрывают в юрту дверь и садятся вокруг свечки. Что делают чукчи, когда очень-очень холодно? Они ее зажигают.");
INSERT INTO chat_shutnik VALUES("332","Два человека выходят на улицу: - Какая ужасная погода, снег с дождем! - Подонки, что хотят, то и творят...");
INSERT INTO chat_shutnik VALUES("333","Получилось так, что две женщины отсидели в тюрьме 10 лет. В одной камере. Выпустили их в один день. Вышли за ворота, одной надо направо, другой налево. Hу, обнялись, расцеловались. Одна другой: - Ладно, остальное я тебе завтра по телефону расскажу . . .");
INSERT INTO chat_shutnik VALUES("334","Приходят к Сталину украинские националисты и говорят, что надо, мол, составить украинско-русский словарь. Сталин закурил трубку, задумался: - Словарь, говорите, ну а как по-украински будет рука? - Рука.\n- Ну а как нога? - Нога.\n- Ну а как голова? - Голова.\n- А как будет жопа? - Срака.\n- Так что же это, из-за одного слова словарь составлять!");
INSERT INTO chat_shutnik VALUES("335","- Ты потребовала бы развод, если бы узнала, что муж тебе изменяет? - Ты что?! За такое его еще и награждать?...");
INSERT INTO chat_shutnik VALUES("336","В церкви большой переполох. Скоро приедет архиепископ с проверкой. Подбегает к пастору монашка и грит: - Святой отец, мне кажется, что ваши стулья надо заново покрыть лаком. Они совсем облупились! - Не ВАШИ, а НАШИ, сестра - здесь ничего нет личного, а только НАШЕ, понятно!? На следущий день опять эта монашка грит пастору: - Святой отец, надо бы ваш потолок заново побелить, а то он уже черный весь! - Дочь моя, не ВАШ, а НАШ потолок, я же вам говорил...! И вот приехал архиепископ. Ходит он с пастором, смотрит вокруг, всем вроде доволен. Тут подбегает монашка и грит пастору: - Святой отец, я нашла ваши часы...\n- Очень мило, сестра, и где же они были? - Под НАШЕЙ кроватью...!!!!");
INSERT INTO chat_shutnik VALUES("337","Свеpхмодный молодой человек обpащается к поpтному: - Вы могли бы сшить мне костюм цвета кофе с кипящим молоком ? - С сахаpом или без ? - спокойно осведомился поpтной. ;););)");
INSERT INTO chat_shutnik VALUES("338","Война. В окопе сидят два солдата и раскуриваются, на них едет танк. Один солдат говорит другому: \"Вань бросай гранату\". Тот говорит: \"Давай сделаем по напасу и тогда бросим\". Сделали по напасу. Первый говорит: \" Вань танк уже близко, давай бросай гранату\". А второй ему: \"Ну ты чего пристал, хочешь, бросай сам\". Подъезжает танк, из люка вываливается накуренный фашист и спрашивает: \"Ну вы чего, гранату то будете кидать?\" А те ему: \"Да что-то нам влом. А вы почему не стреляете?\" Фашисты: \" А мы ствол запаяли чтобы кумар не уходил!\"");
INSERT INTO chat_shutnik VALUES("339","Bесна. Половодье. Mаленький остpовок суши, на котоpом спасаются от воды Cобака и Заяц. A вода все пpибывает и пpибывает, вот-вот затопит остpовок... Чу... Bдали показалась лодка.\n- Уpа, мы спасены!!! - закpичал Заяц.\n- Это Дед Mазай!!! Cобака долго вглядывалась в даль, а потом гpустно сказала: - Hет, Заяц, это не Mазай, это ГEPACИM!!!");
INSERT INTO chat_shutnik VALUES("340","Маленький сын был с папой в зоопарке. У клетки со львом он спросил: - Папа, а если он съест кого-нибудь из нас, на каком номере автобуса мне ехать домой?");
INSERT INTO chat_shutnik VALUES("341","Директор коммерческого магазина учит молодую продавщицу: - Если покупатель спросит: \"Почем очки?\", ты скажи: \"Три штуки\". Если он не дрогнет, скажи: \"За оправу\". Если он опять не дрогнет, скажи: \"И за стекла три штуки\". И если опять не дрогнет, скажи: \"За каждое\".");
INSERT INTO chat_shutnik VALUES("342","- Доктор, я - импотент. И это у меня наследственное.");
INSERT INTO chat_shutnik VALUES("343","У миссис Смит умер муж и страховое агентство платит пятьдесят тысяч долларов бедной вдове. Она горько плачет: - Ах, я бы отдала треть этих денег, лишь бы он был опять со мной...");
INSERT INTO chat_shutnik VALUES("344","На приеме у психиатра.\n- Так, милейший, не волнуйтесь, на что жалуемся? - Не поверите, доктор! Иду я вчера с работы мимо нашего Вычислительного центра, и...\n- Ну-ну! - А там из всех окон Билл Гейтс выглядывает!!! - Так-так! - А по бокам... интерфейсы с кнопками стоят!!! - Да, батенька, пора вам перезагружаться. В новую рубашечку!");
INSERT INTO chat_shutnik VALUES("345","- Гарсон! Кажется, я хватил лишнего. Принесите чего-нибудь отрезвляющего.\n- Пожалуйста, счет.");
INSERT INTO chat_shutnik VALUES("346","Идет по Арбату новый русский в белом костюме с букетом белых роз, спешит на свидание. Погода прекрасная, настроение тоже. Вдруг он видит аппарат, типа автомата с газировкой, с надписью: \"Портим настроение. 1$\" \"Что мне может испортить настроение\" - подумал он и спокойно опустил доллар в автомат. И в тот же момент автомат выплюнул ему ложечку говна прямо на лацкан белого костюмчика. Расстроился новый русский: костюм испорчен, настроение тоже. Вдруг видит рядом стоит точно такой же автомат с надписью: \"Поднимаем настроение. 100$\" \"Что мне может поднять настроение\" - удивился он и быстренько опустил в автомат стольник. И в тот же момент на всех окружающих автомат выплюнул ведро говна...");
INSERT INTO chat_shutnik VALUES("347","Прочитав кое-что на женском форуме понял, что все русские мужчины - импотенты. Эти же козлы, все поголовно, изменяют своим женам.");
INSERT INTO chat_shutnik VALUES("348","Объявили вепсы войну Китаю! Китайцы присылают парламентеров. Идут по деревне, видят идет мужичек, спрашивают (вежливо): \"Вы вепс?\", тот говорит \"Конечно вепс\". Китайцы говорят: \"Вот вы (вепсы) нам войну объявили, а вы знаете, что нас китайцев больше миллиарда?\". Мужичок: \"Ой блин! Где-же мы вас хоронить-то будем?\"");
INSERT INTO chat_shutnik VALUES("349","Когда канцлер князь Горчаков сделал камер-юнкером Акинифьева (в жену которого был влюблен), Тютчев сказал: \"Князь Горчаков походит на древних жрецов, которые золотили рога своих жертв\".");
INSERT INTO chat_shutnik VALUES("350","Идет судебный процесс. Слон обвиняется в изнасиловании змеи. Судья-лев вызывает пострадавшую: - Расскажи, как это было.\n- Мне до сих пор трудно говорить... В общем, он силой заставил меня взять в рот свой детородный орган.\n- Понятно. Теперь послушаем свидетеля. Выходит свидетель - легкомысленная обезьяна: - О! А! Вы бы видели, какая была эрекция! А когда началось семяизвержение, я подумала, что наступил конец света.\n- Ясно. Обвиняемый, что ты можешь сказать в свою защиту? Слон: - Прежде всего, это был не оральный секс, а анальный. И не со змеей, а с обезьяной и по взаимному согласию. А змею я просто применил в качестве презерватива.");
INSERT INTO chat_shutnik VALUES("351","По просьбе своих соплеменников поехал Чукча в Москву узнать, когда будет коммунизм. Приходит Чукча на прием к Горбачеву и спрашивает: - Когда будет коммунизм ? - Вот смотри: видишь, стоит моя \"Волга\", \"Волга\" Лукьянова, \"Волга\" Лигачева. Вот когда будет рядом стоять твоя \"Волга\", тогда, считай, и будет коммунизм. Вернулся Чукча в стойбище.\n- Узнал ? - Узнал. Вот видишь, стоят мои унты, твои унты и еще унты. Вот когда рядом будут стоять унты Горбачева, тогда, считай, и будет коммунизм.");
INSERT INTO chat_shutnik VALUES("352","Судья: - Вы должны попробовать стать другим человеком.\n- Я уже пытался, меня сразу посадили за подделку документов.");
INSERT INTO chat_shutnik VALUES("353","На недавней компютерной выставке (COMDEX) Билл Гейтс сравнил компьютерную промышленность с автомобильной и, в частности, сказал: - Если бы Дженерал Моторс осваивала достижения технологии с таким же эффектом, как это происходит в компьютерной промышленности, то мы все уже бы ездили на -ти долларовых машинах с расходом бензина литров на километров. На что Дженерал Моторс отреагировала: - Да, но хотели бы вы чинить ваш автомобиль дважды в день?...");
INSERT INTO chat_shutnik VALUES("354","- Скажи, вот если мужчина говорит, что у меня волосы хорошо пахнут, это домогательство или нет? - Да нет, это комплимент, по-моему.\n- А если он карлик ....????");
INSERT INTO chat_shutnik VALUES("355","- Когда я иду с женой в гости, то пью очень мало.\n- Тебе не разрешает жена? - Вовсе нет. Просто однажды я здорово перебрал, и мне показалось, что у меня две жены. Такого ужаса я никогда не испытывал!");
INSERT INTO chat_shutnik VALUES("356","Два наркомана, обкурившись, лежат на кровати. Звонок в дверь... Через полчаса один другому: \"Кажется, в дверь звонят...\" Через полчаса другой первому: \"Может, пойти, открыть дверь?..\" Через полчаса первый: \"Ну, сходи, открой...\" Через полчаса второй встает, медленно идет к двери, открывает... На пороге, облокотившись о дверной косяк, стоит третий наркоман: \"Ох-х! Не успел позвонить, уже дверь открывают!\"");
INSERT INTO chat_shutnik VALUES("357","Наташа Ростова вышла вечером подышать на веранду. Внизу в лопухах что-то темнело. НР: Поручик, это Вы? Ржевский: Я! НР: А что это Вы такой маленький? Ржевский: Я не маленький. Я сру.");
INSERT INTO chat_shutnik VALUES("358","- А я не встану под музыку нового гимна! - Ну и будешь смотреть в задницу поющему... Коклюшкин");
INSERT INTO chat_shutnik VALUES("359","Семь раз отмерь - один раз отрежь! (еврейская народная пословица)");
INSERT INTO chat_shutnik VALUES("360","К мужику на вокзале подбегает цыганка: - Драгоценный мой, дай руку, погадаю, все скажу, что будет, что было. Мужик пожимает плечами, протягивает руку: - Hу, погадай. Цыганка некоторое время смотрит на ладонь, потом в ужасе кричит: - Страшной смертью помрешь! Зарежут тебя, сдерут шкуру, четвертуют, зажарят и съедят! - Ах да, я ж перчатку не снял...");
INSERT INTO chat_shutnik VALUES("361","Мадам готовит завтрак, муж перелистывает газету. Вдруг раздается странный гортанный звук.\n- Что там с тобой? - кричит она мужу.\n- Я случайно проглотил пуговицу от воротничка! Мадам удовлетворенно: - Хоть теперь мы будем знать, где она находится!");
INSERT INTO chat_shutnik VALUES("362","Военный говорит жене: - Поздравь меня - мне дали майора.\n- Поздравляю. И что ты с ним сделал?..");
INSERT INTO chat_shutnik VALUES("363","- Что делать, профессор, все готово к операции, а пациента еще нет.\n- Это ничего, начнем без него.");
INSERT INTO chat_shutnik VALUES("364","- Доктор, что означают буквы \"ЧЗ\" в моем диагнозе? - \"Черт его знает\".");
INSERT INTO chat_shutnik VALUES("365","Купил искусственную электронную вагину. Вы даже не представляете, что сбой процессора может быть так приятен...");
INSERT INTO chat_shutnik VALUES("366","Люди, которые думают, что они знают все на свете, раздражают нас, людей, которые действительно все на свете знают.");
INSERT INTO chat_shutnik VALUES("367","- Вчера я видел, как ты выходил из пивной.\n- Что поделаешь, не могу же я там жить.");
INSERT INTO chat_shutnik VALUES("368","Мать с дочкой идут через густой лес. Вокруг никого. страшно. Дочь: - Мама, а вдруг нас изнасилуют?!! - Не с нашим счастьем, доченька....");
INSERT INTO chat_shutnik VALUES("369","ЗВОНОК ОТ ХИЛЛАРИ Хиллари пошла к гинекологу, чтобы провериться. Когда она закончила, она спросила его, все ли в порядке. Он ответил, что он очень рад ее состоянием, но...........она беременна! - Как это возможно? Этого не может быть! - Но это так! Вы беременны уже месяц! Она выбежала из оффиса и побежала к секретарю. Взяла телефон и позвонила в Белый Дом. Когда ответил оператор, она сказала, что это Хиллари и хочет говорить с Биллом срочно! Оператор соединил ее с Овальным оффисом и Билл ответил. Хиллари начала кричать: - Ты знаешь, что ты сделал, ты кретин! Ты сделал меня беременной!!! Никакого ответа не последовало. Хиллари опять повторила, крича: - Ты знаешь, что ты сделал, ты никому не нужный кретин! Ты сделал меня беременной!!!!!!!!!! Наконец, послышался ответ: - Кто это???................");
INSERT INTO chat_shutnik VALUES("370","Управляющий беседует с молодым человеком, который хочет устроиться на работу: - В нашей фирме, - говорит управляющий, - очень заботятся о чистоте. Вы вытерли ноги о коврик перед тем как войти? - О да, разумеется.\n- Во-вторых, - продолжает управляющий, - мы требуем от наших сотрудников правдивости. Никакого коврика там нет.");
INSERT INTO chat_shutnik VALUES("371","Если к поэту приходит муза, к поэтессе приходит музык.");
INSERT INTO chat_shutnik VALUES("372","- Не понимаю, почему ты развелась с мужем? - Мне вообще не повезло с замужеством. Сначала оно напоминало мираж в пустыне: дворцы, фонтаны, пальмы, яхты, путешествия на верблюдах по Африке...\n- А потом? - Потом дворцы, фонтаны исчезли, яхта пришла в негодность, осталась одна верблюжья работа.");
INSERT INTO chat_shutnik VALUES("373","Директор мебельной фабрики поехал в командировку в Париж. Возвращается - масса впечатлений. Рассказывает своим приятелям: - О, такой город! Такие улицы! Такие магазины! - Ну а женщины? - О-о! Это что-то невероятное! Мечта! Главное - любого мужика понимают с полуслова. Вот например: захожу я в маленький ресторанчик, сажусь за столик. Ко мне подсаживается умопомрачительная красотка. Ну сразу сообразила, что я по ихнему - ни слова. Рисует мне на салфетке рюмку. Я - наливаю ей шампанского. Рисует сигарету. Я - даю закурить. Рисует две танцующие фигурки. Я - приглашаю ее на танец.\n- Ну а потом? - Рисует кровать...\n- А ты? - Хмм... До сих пор не пойму - как она узнала, что я - директор мебельной фабрики...");
INSERT INTO chat_shutnik VALUES("374","Молодой офицер попадает служить на боевой корабль, который немедленно направляется в длительный поход. \"Товарищ капитан первого ранга, я и с девушкой-то не успел побыть, а тут такой длительный поход - жалуется он командиру. \"Ничего, лейтенант, у нас для этих целей кок есть.\" \"Как можно - возмущается лейтенант - ведь он мужчина.\" \"Ну не хотите, как хотите, но если что, посодействую.\" Проходит три месяца. Лейтенант подходит к командиру: \"Товарищ капитан первого ранга, Вы что-то насчет кока говорили...\" \"Мичман! - зовет тот - приведи кока в каюту лейтенанта и не забудь взять еще троих.\" \"Зачем троих? - смущается лейтенант - а нельзя ли нам с коком один на один?\" \"Ты один с ним не справишься, сынок. Его же сначала надо с ног сбить и к кровати прижать.\"");
INSERT INTO chat_shutnik VALUES("375","На балу к поручику подскочил корнет и решив блеснуть остроумием и поетическим даром сказал: \"Поручик-ключик-чайничек\" Ржевский ответил: \"Корнет-кларнет-тромбон-гандон- и вообще ты пидарас\"");
INSERT INTO chat_shutnik VALUES("376","Самое сложное для артиста пародирующего Баскова - также не попасть в ноты.");
INSERT INTO chat_shutnik VALUES("377","Анекдот из сериала \"Скорая помощь\". Врач дает указания практикантке: - В третьей смотровой пациент повредил прямую кишку большой морковью. Составьте анамнез и заполните его карточку. Практикантка изумленно: - Как он проглотил целую морковь?!!");
INSERT INTO chat_shutnik VALUES("378","Ночь была темной. Часовому хотелось курить.\n- Эй, Мак! - окликнул он, как ему показалось, своего товарища, проходившего недалеко от поста.\n- У тебя нет сигаретки? И тут он рассмотрел, что окликнул генерала.\n- Виноват, сэр! - гаркнул он и принял стойку \"смирно\".\n- Вольно, рядовой, - отдал команду генерал.\n- И считай, тебе повезло, что я не лейтенант!");
INSERT INTO chat_shutnik VALUES("379","В фотоателье мастер долго и пристально смотрит на клиента. Тот заерзал в кресле: - Что-то не так ? - Да Вы не волнуйтесь, все в порядке - просто если б не усы, Вы были бы вылитая моя теща.\n- Но у меня нет усов ! - А вот у нее есть.");
INSERT INTO chat_shutnik VALUES("380","- Как получить миллиард долларов? - Очень просто. Надо поймать Березовского и продать его Гусинскому.");
INSERT INTO chat_shutnik VALUES("381","Вернулся мужик из командировки. Приехал домой, открывает дверь и видит на вешалке чужое мужское пальто. Заходит в спальню. В постели жена лежит, всюду мужская одежда разбросана, а тут еще из ванной выходит голый мужчина. Муж только открывает рот, но его тут же перебивает жена: - Ну, конечно, всегда так ! Ты сейчас будешь верить своим бесстыжим глазам, а не любимой жене !");
INSERT INTO chat_shutnik VALUES("382","Молодой, талантливый пианист пришел записываться на радиостудию. Но вот непруха! Чем больше играет, тем хуже получается. И дальше - хуже... Время часов ночи. За стеклышком сидит оператор грустный... Кофе кончился, сигарет нет, жена три раза звонила, обещала из дому выгнать. Надоело ему это все. Включает он микрофон в студии и говорит: - \"Слушай, мужик! Ладно, все, хорош! Ну не получается. Но ты хоть гамму-то сыграть можешь?\" Тот ему: - Гамму! Нет проблем! - Сыграй, а я потом нарежу!");
INSERT INTO chat_shutnik VALUES("383","- Какая разница между женщиной без груди и брюками без карманов? - Никакой. Некуда руки девать.");
INSERT INTO chat_shutnik VALUES("384","Около ранчо остановилось стадо баранов и уставилось на ворота.\n- Чего они смотрят? - спросили у пастуха.\n- Ведь ворота старые? - Бараны новые, - ответил пастух.");
INSERT INTO chat_shutnik VALUES("385","Встречаются на том свете три старых седых мужика, узнают друг у друга, как и отчего приключилась смерть. Первый говорит: - Я всю жизнь работал и смерть меня настигла в процессе труда. А работа была нелегкой, и поседел я лет в шестьдесят. Второй говорит: - А я всю жизнь воровал потихоньку, в конце концов меня и убили из-за денег. И при этом лет в сорок поседел, понимая, чем кончится мой промысел. Третий говорит: - Ну, вы, мужики, круты, хоть чего-то в жизни добились, а вот я вообще не делал ни хрена, и, как услышал, что моя собственная жена хочет меня на пересадку органов пустить, сначала поседел, а потом - при операции - сердце не выдержало... Голем");
INSERT INTO chat_shutnik VALUES("386","Жили в одной избушке Медведь, Волк и Заяц. У Медведя была заначка водки. Как-то раз ушел он в лес, а Волк с Зайцем остались дома. Заяц подходит к Волку и говорит: - Давай выпьем! - Да ты что, Медведь нам потом головы оторвет.\n- Ничего, когда он станет про водку спрашивать, ты, главное, глаза побольше сделай, мол, и не видели ее даже, а там как-нибудь выкрутимся. Выпили они медвежью заначку. Вечером Медведь обнаружил пропажу и спрашивает - А где моя водка? У Волка глаза по пятаку, а Заяц ему и говорит: - Ну что глазенки-то выпятил, рассказывай все дяде Мише!");
INSERT INTO chat_shutnik VALUES("387","Мужики взбунтовались, взяли вилы, топоры, дубье и поперли к усадьбе. Шумят, матерятся, гул стоит. Подходят к усадьбе. Выходит староста, пытается уговорить мужиков разойтись, потом управляющий - не слушают, матерятся, требуют, чтоб Сам вышел. Выходит помещик, после завтрака, халат расстегнут, левой рукой чешет брюхо, правой зубочистку держит, во рту ковыряется. Мужики притихли. Барин зевает, поворачивается к толпе и негромким голосом спрашивает: - Ну, чего вам, мужики? Мужики стоят молча. Барин смотрит на них, ждет ответа минуты три, потом лениво уходит. Мужики стоят, молчат, потом, спустя полчаса понемногу расходятся. Дня через три один из зачинщиков обедает дома, ест шти. Вдруг посреди обеда останавливается, задумывается, потом бах ложкой об стол и орет: - ЧАВО, ЧАВО, А НИЧАВО!");
INSERT INTO chat_shutnik VALUES("388","- Что можно снять с голой женщины? - Только голого мужчину.");
INSERT INTO chat_shutnik VALUES("389","Учительница прибегает к директору в слезах: - Ах это просто невыносим ! Не ученики - животные, скоты ! А один даже грозился меня изнасиловать ! Представляете ?! Директор встает и идет в класс. Входит. Молча осматривает ряды учеников и тыкает пальцем в Вовочку: - Этот сказал ? Понимаю: этот раз сказал - сделает.");
INSERT INTO chat_shutnik VALUES("390","\"Хуюшки вам, а не Кунашир!\" - сказал японцам Владимир Путин. И остров Хуюшки из Курильской гряды пришлось отдать.");
INSERT INTO chat_shutnik VALUES("391","- Любите ли вы Шекспира? - Трудно сказать. Скорее, мы просто приятели.");
INSERT INTO chat_shutnik VALUES("392","Начало чемнионата России по футболу. Матч \"Динамо\" - \"Спартак\". Опоздавший болельщик - соседу: - Ну и кто из наших лучше всех играет, точнее всех бьет? - Ковтун.\n- Но на табло :, и два гола забил Терехин....\n- Много ты понимаешь! Терехин десять раз ударил и два раза забил, а Ковтун три раза ударил, и для всех троих сезон уже закончился!");
INSERT INTO chat_shutnik VALUES("393","- Кто, в конце концов, в доме хозяин?! - набравшись духу, закричал муж.\n- Я,- спокойно ответила жена,- А что? - Да нет, ничего... Все в порядке. Я просто так спросил.");
INSERT INTO chat_shutnik VALUES("394","- Где у женщин расположен аппендикс? - Как войдешь - налево.");
INSERT INTO chat_shutnik VALUES("395","Где-то загорелся дом. Все тушат. Прибегает хозяин и кричит: - Hа меня ведро воды! Выплеснули на него ведро, вбежал в горящий дом, через какое-то время выскоч ил. Проходит минут , мужик опять: - Hа меня ведро воды! Снова забежал в дом, через некоторое время выскочил. Прошло еще минут , у дома крыша уже обваливается, мужик опять: - Hа меня ведер! Ему говорят, мол, куда ты полезешь, и вещей не спасешь, и сам погибнешь.\n- Какие вещи! Там моя теща, а я ее переворачиваю.");
INSERT INTO chat_shutnik VALUES("396","Однажды пришли к габровцам гости, да слишком засиделись. Не вытерпела хозяйка и громко сказала мужу, чтобы все услышали: - Давай, муженек, ляжем спать, а то, наверное, гости уже хотят идти домой!..");
INSERT INTO chat_shutnik VALUES("397","Революция кончилась. Петька с Василием Ивановичем думают о новой жизни: - Петька, что бы нам теперь построить? - Построим консерваторию! - Точно! А на крышу пулемет поставим! - А это зачем? - Чтобы все консервы не растащили!");
INSERT INTO chat_shutnik VALUES("398","Мужик жалуется приятелю: - А ведь когда-то у меня было все: деньги, роскошный дом, мерс, красивая женщина, которая меня по-настоящему любила. И всего этого я лишился в одночасье.\n- А что случилось? - Да какой-то козел рассказал об этом моей жене!");
INSERT INTO chat_shutnik VALUES("399","Из письма А. Б. Чубайсу. Уважаемый Анатолий Борисович, пишет вам электрик Эрнест Петрович Сидоров. Сделайте что-нибудь. Ввиду огромного внешнего сходства с вами, мне очень часто бьют морду. С уважением Э. П. Сидоров");
INSERT INTO chat_shutnik VALUES("400","Глубокой ночью Сталин поднимает трубку.\n- Слушай, товарищ Молотов, а ты так же все заикаешься? - Заикаюсь, товарищ Сталин, но если нужно будет для дела строительства социализма, тоЄ - Нет, ничего не надо. Спи спокойно. И кладет трубку. Звонит Микояну.\n- Слушай, товарищ Микоян, сколько там было бакинских комиссаров? - , товарищ СталинЄ - А сколько погибло? - , товарищ Сталин.\n- Ну, спи спокойно, наш двадцать седьмой бакинский комиссар! И кладет трубку. Звонит Берии.\n- Слушай, товарищ Берия, ты Бухарина надежно расстрелял? - Надежно, товарищ Сталин. А что? - Да ничего. Спи спокойно. Кладет трубку и говорит: - Ну вот, их успокоил, теперь можно м самому уснуть.");
INSERT INTO chat_shutnik VALUES("401","Англичанин среднего достатка заходит в респектабельный магазин. Немного оглядевшись спрашивает продавца.\n- Скажите, сколько стоит вон та шляпа? -Тысячу долларов, Сэр.\n-Черт.., А вон та? -Два черта, Сэр. FiL");
INSERT INTO chat_shutnik VALUES("402","Гpузин в pестоpане любуется новыими \"коpочками\" кандидата наук. Официант ехидно спpашивает: - Что, только что купил ? - Вах ! Зачэм стpашиваэш ! Зачэм сpазу: Купиль ! Дpуззя подаpиль !!");
INSERT INTO chat_shutnik VALUES("403","Встречаются два директора советского и японского предприятий. Предприятия изготавливают совершенно одинаковую продукцию и в одинаковых количествах. Директор нашего завода спрашивает: - Сколько людей у тебя работает? - Девять. А у тебя? У нашего вообще-то пятьсот, но он говорит: - Десять! На следующий день японец говорит: - Слушай, я всю ночь думал и никак не могу понять: что у тебя этот десятый делает?");
INSERT INTO chat_shutnik VALUES("404","\"Фанта. Вкус апельсина.\" До сих пор не могу понять, что именно дает этот вкус. То ли вода с сахаром и диоксидом углерода, то ли регулятор кислотности и стабилизатор гуммиарабик. А может, изо-бутират ацетат сахарозы с антиоксидантом аскорбиновая кислота? Хотя, вероятнее всего, краситель \"желтый солнечный загар\" с идентичными натуральным ароматизаторами... Нет, наверное, все-таки бензоат натрия!..");
INSERT INTO chat_shutnik VALUES("405","Жена: - Не могли бы мы как-нибудь сходить в кино ? Муж: - Мы же были в кино.\n- Да, но теперь там идут звуковые фильмы...");
INSERT INTO chat_shutnik VALUES("406","Садятся старик со старухой ужинать. Старуха поставила перед стариком сковородку картошки. Он поковырялся вилкой, взял сковородку да как треснет старухе по лбу.\n- Старик, ты одурел, что ли? - Как вспомню что не целкой взял, так аппетит пропадает!!!");
INSERT INTO chat_shutnik VALUES("407","У минетчицы спрашивают: - как дела? - Да вот вот хреново! Всякая пошлятина в голову лезет!");
INSERT INTO chat_shutnik VALUES("408","Выполз уж из ресторана: \"Гав. Неа.. Ку-ка-реку Неа.. Мяу Неа... Шшшш, бля буду, шшшшш!\"");
INSERT INTO chat_shutnik VALUES("409","Леди не захочет, джентльмен не вскочит.");
INSERT INTO chat_shutnik VALUES("410","- Ва-ань, а Ва-ань, ты за ско-олько доходишь от кровати до двери? - Я - за час, а ты за сколько? - За полчаса! - Ну, ты вообще, как метеор!");
INSERT INTO chat_shutnik VALUES("411","Фиpма, пpодающая пилюли для похудения, получила письмо: \"Ваши пилюли бесподобны. За пеpвые две недели моя жена похудела на шесть кг, а вскоpе исчезла вообще.\"");
INSERT INTO chat_shutnik VALUES("412","Врач - пациенту, глядя в историю болезни: - Э-э ,батенька, с сегодняшнего дня бросайте курить - положение серьезное! - Доктор, но я не курю! Не люблю.\n- Да? Тогда ни капли спиртного!! - Но, доктор, я не пью! Не люблю! - Да??... Но что-нибудь вы любите!!?? - Картошку...\n- Так вот! С сегодняшнего дня я вам решительно запрещаю есть картошку!!!");
INSERT INTO chat_shutnik VALUES("413","- Рабинович, говорят, вы большой интриган? - Да, а кто это ценит...");
INSERT INTO chat_shutnik VALUES("414","Социальная реклама Мы yже не pаз обманывали вас. Вы защищали нас осенью -го, мы стpеляли в вас осенью -го. Мы pазвалили вашy стpанy в -м, обокpали в -м, надyли с двyмя Волгами в -м, с помощью МММ-ов pаскpyтили на бабки в -м, посылали ваших детей на бойню в -м, неплохо \"повтоpничали\" в -м, и полностью огpабили в -м. Hо y нас опять кончились деньги. Пожалyйста, заплатите налоги...");
INSERT INTO chat_shutnik VALUES("415","- Дорогой! Наш сосед подарил тебе на день рождения двухрожковую люстру! - Это он на что намекает?!");
INSERT INTO chat_shutnik VALUES("416","Недавно на ж/д переезде № пожарный инспектор Василий М. обнаружил цистерну со спиртом, близкую к самовозгоранию. Лишь к вечеру силами жителей семи окрестных сел риск самовозгорания уменьшился ровно наполовину.");
INSERT INTO chat_shutnik VALUES("417","Молодой фермер, призванный на военную службу, в письме домой написал: \"Эта армейская жизнь - сплошное удовольствие. Можно валяться в постели до пяти часов утра\".");
INSERT INTO chat_shutnik VALUES("418","- Что вы будете делать, сержант Тейер, если запасы воды в вашем взводе окажутся зараженными? - Лучшим выходом было бы перейти на пиво.");
INSERT INTO chat_shutnik VALUES("419","Встречаются две подруги. Одна две недели назад вышла замуж. Вторая любопытствует: - Ну и как тебе семейная жизнь? - Да так себе, ничего. Только вот, представляешь, а Жан-то, оказывается, пьет...\n- Как пьет! Вы же два года были знакомы! И ты не знала? - Так ведь два года все было нормально, но вот вчера он пришел трезвым!");
INSERT INTO chat_shutnik VALUES("420","Почему евреи так популярны у женщин? Потому, что у них есть длинный, большой и толстый... Нет, не то, о чем Вы подумали: длинный - рубль, большой - счет в банке, а толстый - бумажник! Голем");
INSERT INTO chat_shutnik VALUES("421","\"micro soft works for micro soft windows\" означает \"Микро программное обеспечение работает для микро окон программного обеспечения\" (Перевод выполнен ПО Stylus for Windows , в. .)");
INSERT INTO chat_shutnik VALUES("422","Больной вызывает врача в три часа ночи. После осмотра врач задумывается, потом говорит: - Вы составили завещание? - Нет, доктор.\n- Так вызовите, пожалуйста, нотариуса и двух свидетелей.\n- Боже мой, это так серьезно? - Нет, но я не хотел бы быть единственным дураком, которого вы подняли в три часа ночи.");
INSERT INTO chat_shutnik VALUES("423","Ж) - Смотри какие тени длинные, и облака тяжелые... Х) - Длинные - потому что уже поздно, а тяжелые потому что мы уже -й день пьем.");
INSERT INTO chat_shutnik VALUES("424","- Хаим, я слышал - вы женитесь! - Таки-да! - И как вам ваша будущая жена? - Ой, сколько людей, столько и мнений. Маме нравится, мне - нет.");
INSERT INTO chat_shutnik VALUES("425","Племянник разговаривает с Лениным: - Дядя Вова, у тебя такая большая умная голова!? - Да, Витенька, ей я думаю, как людям лучше жить.\n- У тебя такие руки!? - Да, Витенька, ими я указываю людям верную дорогу.\n- А усы тебе зачем? - А чтобы тетю Надю щекотать!");
INSERT INTO chat_shutnik VALUES("426","Один еврей рассказывает: - Представляешь, прихожу домой, а там жена с любовником. А глаза у них хитрые-хитрые... Думаю, что за черт! Бегу прямо к холодильнику, открываю его, так и есть! Всю фаршированную рыбу съели, сволочи!");
INSERT INTO chat_shutnik VALUES("427","Дочка спрашивает у мамы: - Мама, а что такое фаллоимитатор? Мама, немного смутившись, отвечает - Ну, доченька, это прибор, который заменяет мужа. Дочка (с восхищением): - Классно! И он сам по ночам жрет котлеты из холодильника и храпит?");
INSERT INTO chat_shutnik VALUES("428","Встречаются два приятеля: - Говорят, ты женился на девушке, о которой даже не мог и мечтать.\n- Правильно говорят... Неужели ты думаешь, что я мог мечтать о такой стерве?");
INSERT INTO chat_shutnik VALUES("429","Начальник лагеря объявляет: - Сегодня день смены белья. Первый барак меняется со вторым.");
INSERT INTO chat_shutnik VALUES("430","Вышел как-то Брежнев на балкон - на звезды посмотреть. Глянул - а луна-то не красная! Он позвонил кому надо, ему ответили, мол, все ОК, будет сделано! Выходит на следующий день - луна красная, как мак! Ильич лег спать довольным. На следующий день вышел - у луны снизу треугольник белый и надпись черным - Marlboro. Он звонит, ему - будет сделано! Он ложится спать. На следующий день - красная луна, белый треугольник, Мальборо и подпись внизу - \"московская фабрика Дукат\". Ильич ложится довольным. Следующий день. Глянул Брежнев - красная луна, Мальборо, фабрика Дукат, а внизу подпись - по лицензии компании Phillip Morris Ltd. Звонит, ему - будет сделано. Следующий день. Брежнев на балконе. Красная луна, белый треугольник, надпись Marlboro, подпись \"московская фабрика Дукат\", еще подпись \"по лицензии компании Phillip Morris Ltd.\", а внизу крупными буквами - МИНИСТЕРСТВО ОБОРОНЫ СССР ПРЕДУПРЕЖДАЕТ...");
INSERT INTO chat_shutnik VALUES("431","Вовочка пpедлагает Машеньке: - Машка, а давай мы с тобой в семью поигpаем? - А как? - Сначала потp#хаемся - а потом хаpактеpами не сойдёмся!");
INSERT INTO chat_shutnik VALUES("432","После того, как хирург сделал даме пластическую операцию, удалив двойной подбородок и придав носу классическую форму, она попросила, чтобы он расширил ей глаза.\n- Это уже лишнее, - заявил хирург, - у вас глаза станут и без того широкими, когда вы увидите счет за две первые операции.");
INSERT INTO chat_shutnik VALUES("433","Новый русский приходит к дантисту. Садится в кресло, открывает рот и дантист обалдевает: верхняя челюсть платиновая, а нижняя - золотая! Обалдевши дантист спрашивает: - А чем я могу помочь !??? - Как чем? Ты сигнализатцию поставь.");
INSERT INTO chat_shutnik VALUES("434","И настали в России смутные времена - лица кавказской национальности стали проверять прописку у работников милиции, а гаишники давать взятки водителям...");
INSERT INTO chat_shutnik VALUES("435","- Что-нибудь поймали? - интересуется прохожий.\n- Да, - мрачно отвечает рыбак.\n- Поймал одного и бросил в реку.\n- Наверное, маленький был? - Да, ростом примерно с вас и такой же назойливый.");
INSERT INTO chat_shutnik VALUES("436","- Мадам, почему вы уменьшили свой возраст на шесть лет? - Дело в том, что первые шесть лет я не умела считать.");
INSERT INTO chat_shutnik VALUES("437","Ленин с Крупской сидят и пьют чай. Вдруг на лестнице раздался страшный грохот и лязг.\n- Наденька, кажется, в прихожей упал несгораемый шкаф...\n- Нет, Володя, это железный Феликс на перилах катается.");
INSERT INTO chat_shutnik VALUES("438","Вопрос: Почему большинство женщин не может уснуть после оргазма? Ответ: Потому что им нужно еще до дома добираться!");
INSERT INTO chat_shutnik VALUES("439","- Доктор, я после ампутации не чувствую правую ногу.\n- Как же вы, голубчик, хотите ее чувствовать, если она у вас ампутирована?.\n- Так мне же ампутировали левую!");
INSERT INTO chat_shutnik VALUES("440","С завистью про одну знакомую: - Она только что вернулась с черноморского побережья с чудесно загоревшим языком!");
INSERT INTO chat_shutnik VALUES("441","Винни-Пух полез за медом и застрял.\n- Пятачок! Пятачок! Отдери меня! Ну Пятачок и отодрал. Через два дня пошел дождь, Винни-Пух отлип и упал.");
INSERT INTO chat_shutnik VALUES("442","Как пытают Саддама Хусейна? - показывают портрет Мадлен Олбрайт");
INSERT INTO chat_shutnik VALUES("443","У нового рyсского спрашивают: \"За сколько минимyм Вы пробежите метровкy?\" (HР): \"Минимyм за $.\"");
INSERT INTO chat_shutnik VALUES("444","\"Как я учился трахаться\" - руководство по установке \"Windows\"");
INSERT INTO chat_shutnik VALUES("445","Парочка едет на спортивном автомобиле. Она: - Дорогой, не надо ехать так быстро, я боюсь. Он: - А ты закрой глаза, как я.");
INSERT INTO chat_shutnik VALUES("446","Вопpос к аpмянскому pадио: - Женятся ли онанисты? Ответ: - Да. Hа дояpках!");
INSERT INTO chat_shutnik VALUES("447","Солдат стройбата берет пачку \"Беломора\" и по слогам читает: - Минздрав предупреждает...\n- прикурил, затянулся, поглядел мечтательно вдаль и произнес: - Вот же гады, на лопатах-то такое не пишут.");
INSERT INTO chat_shutnik VALUES("448","- Pядовой Петpов - выйти из cтpоя - шагов впеpед! - Pаз, два, тpи... Cемь! Дальше не могy, товаpищ майоp, - стена! - А дальше и не надо! Pота - ПЛИ !!!");
INSERT INTO chat_shutnik VALUES("449","Все хорошо, что хорошо конча...");
INSERT INTO chat_shutnik VALUES("450","Встречаются два друга. Один спрашивает другого: - Ты, я вижу, к Интернету подключился! - Как ты узнал? - По глазам.\n- Стали умнее? - Нет, краснее... (с) АС");
INSERT INTO chat_shutnik VALUES("451","Нынче очень легко стало отличить КТО есть КТО в американской политике. Демократы называют его Кеннет Старр, а Республиканцы уважительно Судья Старр...");
INSERT INTO chat_shutnik VALUES("452","К врачу приходит пациент с полностью черным языком.\n- Что это с вами? - Да вот, пролил водку на свежеуложенный асфальт...");
INSERT INTO chat_shutnik VALUES("453","В кабинет врача входит девушка: - Раздевайтесь, пожалуйста, - говорит ей врач.\n- Зачем?! - вспыхивает девушка.\n- У меня ведь болит ухо! - В таком случае вам не ко мне, - отвечает врач.\n- Я глазник.");
INSERT INTO chat_shutnik VALUES("454","Похороны. Катафалк, после того как на него погрузили гроб, трогается с места. Случайные свидетели наблюдают такую душераздирающую сцену: за катафалком бежит мальчуган лет восьми и рыдает: - Папа, папочка, куда же ты, не оставляй меня, я хочу с тобой!!! Но тут вдруг катафалк останавливается, из кабины выходит шофер и орет мальчику: - А ну марш домой, кому сказал! Не сделаешь уроки к моему приходу - я тебе ремня дам!");
INSERT INTO chat_shutnik VALUES("455","Сдают мужики сперму в больнице. Очередь большая. Вдруг подходит девушка и становится молча в очередь. Пять минут стоит и молчит. Десять. Народ удивляется. Подходит к ней мужик и спрашивает: - А вы что, тоже сперму сдаете ? А она отвечает, не раскрывая рта: - Угу.");
INSERT INTO chat_shutnik VALUES("456","В кабинет врача входит девушка: - Раздевайтесь, пожалуйста, - говорит ей врач.\n- Зачем?! - вспыхивает девушка.\n- У меня ведь болит ухо! - В таком случае вам не ко мне, - отвечает врач.\n- Я глазник.");
INSERT INTO chat_shutnik VALUES("457","Похороны. Катафалк, после того как на него погрузили гроб, трогается с места. Случайные свидетели наблюдают такую душераздирающую сцену: за катафалком бежит мальчуган лет восьми и рыдает: - Папа, папочка, куда же ты, не оставляй меня, я хочу с тобой!!! Но тут вдруг катафалк останавливается, из кабины выходит шофер и орет мальчику: - А ну марш домой, кому сказал! Не сделаешь уроки к моему приходу - я тебе ремня дам!");
INSERT INTO chat_shutnik VALUES("458","Сдают мужики сперму в больнице. Очередь большая. Вдруг подходит девушка и становится молча в очередь. Пять минут стоит и молчит. Десять. Народ удивляется. Подходит к ней мужик и спрашивает: - А вы что, тоже сперму сдаете ? А она отвечает, не раскрывая рта: - Угу.");
INSERT INTO chat_shutnik VALUES("459","Приходит барышня к гинекологу.\n- Доктор, вы мне вчера спиральку поставили...\n- Да, помню.\n- Но она слишком длинная.\n- Присядьте пока, через минут поменяю. Барышня садится: пау-уау-уау!");
INSERT INTO chat_shutnik VALUES("460","Тяпница (день недели - время выпить)");
INSERT INTO chat_shutnik VALUES("461","Три секретарши в кафе обсуждают своего негодяя-босса.\n- Я вылила пузырек чернил в ящик его письменного стола.\n- А я нашла у него в столе презерватив и проколола его иглой. Третья падает в обморок.");
INSERT INTO chat_shutnik VALUES("462","Чукча приехал домой из Москвы и говорит: - Чукча в Москве был, чукча умным стал, все знает. Оказывается, Карл, Маркс, Фридрих, Энгельс не четыре человека, а два, а Слава КПСС - вообще не человек.");
INSERT INTO chat_shutnik VALUES("463","Если бы люди водили автомобили также, как они работают на компьютерах (разговор по телефону Водителя и Техника из тех. поддержки) Техник: Водительская тех. поддержка. Чем можем помочь? Водитель: Эта... Машина у меня не заводится. Техник: Ясненько. Какая у вашей машины марка, модель, и год выпуска? Водитель: А я... хрен его знает! Я ее купил в магазин ездить, откуда мне знать... Техник: Хорошо-хорошо, успокойтесь. Попробуем обойтись без этой информации... (вздох) У вас есть бензин в баке? Водитель: Гм... Бензин в баке, говоришь... А как я узнаю? Техник: На передней панели посмотрите. Куда стрелка показывает, на \"Е\" или на \"F\"? Водитель: А где передняя панель? Техник: Она находится сразу за рулем если вы сидите в водительском кресле. Водитель: А! Вижу. .. Тэкс... А тут стрелок много, которую из них смотреть? Техник: Смотрите на ту, рядом с которой написано Е или F. Там еще может быть бензоколонка нарисована. Водитель: Ааа! Вижу. Стрелка показывает на ноль. Техник: Как на ноль? Водитель: Ага. Прямо на ноль. А ещ");
INSERT INTO chat_shutnik VALUES("464","- Алло! Это \"секс по-телефону\"? - Да.\n- Значит, так. Hикаких кружевных трусиков, чулочек. Ты - блондинка, толстая, раскрасневшаяся. Абсолютно голая, но в резиновых сапогах. Звать тебя Клава. Hедавно кончилась война, примерно сорок шестой год. Мы - на сеновале. Пахнет конским навозом. Лучик света сквозь дыру в крыше упал на мою спину... Поехали, Клавка!");
INSERT INTO chat_shutnik VALUES("465","Отправляют первого китайца в космос. В напутствие ему говорят: Летишь ты не надолго, но еды мы тебе дадим много - кушай сколько хочешь, а мешочек (для естественных отходов организма) в скафандр пришили небольшой (ну на сутки, зачем большой?)... Приземлятся китайский космонавт. Еда нетронута, а вот мешочек порвался :( (c) Toha, onliner.by");
INSERT INTO chat_shutnik VALUES("466","Разговор мужа и жены: - Слушай, что мы подарим на этот раз моей маме на день рождения ? - А что мы дарили в прошлый раз ? - В прошлый раз мы подарили ей стул.\n- Hу а теперь подведем к нему электричество.");
INSERT INTO chat_shutnik VALUES("467","- Моня, ты что делаешь сегодня вечером? - Да, вроде, ничего.\n- Давай пойдем в клуб \"Кому за тридцать\". Договорились, но Моня не пришел. Встречаются на другой день.\n- Ну чего же ты не пришел? Я так хорошо провел время, там такие женщины...\n- Хаим, а я померил, у меня только двадцать четыре... Ну я и не пошел.");
INSERT INTO chat_shutnik VALUES("468","На еврейском кладбище в Одессе три землекопа присели отдохнуть у трех могил известных людей.\n- Хотел бы я лежать вот здесь, рядом с Рабиновичем, а ты? - говорит один.\n- Нет, я предпочел бы рядом с Абрамовичем.\n- А я предпочел бы прямо сейчас лежать с женой Когана...\n- Так она же жива! - Вот и я про то же!");
INSERT INTO chat_shutnik VALUES("469","Один приятель другому: - Ты знаешь, я когда в командировку последний раз уезжал, в шкафу капкан на медведя оставил. Представляешь - приезжаю и сразу к шкафу бегу, смотрю - сидит красавец! - Кто? Любовник? - Да нет... Медведь!");
INSERT INTO chat_shutnik VALUES("470","Явлинский-Болдырев-Лукин - ЯБЛоко. Немцов-Хакамада-Чубайс - НеХаЧу. Коалиция: \"НЕХАЧУ ЯБЛОКО\". &copy; Хрюн");
INSERT INTO chat_shutnik VALUES("471","- У этой пьесы был счастливый конец? - Конечно, все были так рады, что она закончилась.");
INSERT INTO chat_shutnik VALUES("472","Как называется человек, который не дарит подарков своей любовнице? Ответ: Дармоёб");
INSERT INTO chat_shutnik VALUES("473","- Доктоp, я пеpестала получать удовольствие от колбасы.\n- А что вы с ней, пpостите, делаете? - Я ее ем...");
INSERT INTO chat_shutnik VALUES("474","Пришел муж домой, уставший с работы. Поел и лег с женой спать. Всю ночь жена ластится к нему и так, и сяк, а он ворчит: - Отстань, Машка, у меня еще колосок не созрел... Спать хочу! На следующую ночь повторяется то же самое. На третью ночь муж начал сам к ней ластиться - и так, и сяк. А она ему отвечает: - Чё пристал? - Колосок-то созрел, - отвечает муж.\n- Ну вот еще, - ворчит жена, - буду из-за одного колоска весь комбайн заводить!");
INSERT INTO chat_shutnik VALUES("475","Два часа ночи. Звонок в дверь. Жена открывает дверь и... тело мужа падает в коридор.\n- Свинья! Ну что за радость каждый раз напиваться до полусмерти..!? - Прасти, драгая, ккак вседа денег неххватило....!!!");
INSERT INTO chat_shutnik VALUES("476","Заходит мужик в аптеку. М. У вас бананы есть? А. Нет. Здесь дорогой аптека и бананов не бывает. а следующий день снова он же заходит в аптеку. М. У вас Бананы есть? А. Да нет же здесь аптека здесь лекарства разные банки и т.д. Так повторяется в течении пяти дней, заебанный аптекарь на большом ватмане крупными буквами пишет объявление \"БАНАНОВ НЕТ! \" Заходит тот же мужчина, внимательно читает объявление, Подходит к Аптекарю и с обидой говорит \"А значит были бананы!\"");
INSERT INTO chat_shutnik VALUES("477","Дерется Чебурашка с Кощеем Бессмертным. Кощей говорит: - Все равно ты меня не убьешь. У меня смерть в яйце. Последовал удар.\n- У... да не в том!!!");
INSERT INTO chat_shutnik VALUES("478","В роддоме. Из операционной выходит молоденькая медсестра и говорит мужчине, ждущему результатов родов своей жены: - Поздравляю вас! У вас родился сын с шестью кулачками. Мужик побледнел и чуть не упал в обморок. А медсестра, хохоча: - Обманули дурачка на четыре кулачка!");
INSERT INTO chat_shutnik VALUES("479","Двое охранителей купили Мерседесы. И сразу же возник вопрос: дескать, как мы эти Мерседесы отличать будем? Вот один и говорит: - Послушай, давай разобьем у твоего левую фару, а у моего - правую. Так и будем отличать... Другой согласился. Так и сделали. Второй посмотрел-посмотрел и спрашивает: - Послушай, братан. Фары-то мы разбили, а ты помнишь, какая фара у твоей разбита - правая или левая? - Не-а.\n- Давай разобьем и другую фару. Разбили обе фары обеих машин, сидят и смотрят...\n- Послушай, братан, а ведь опять машины не отличишь.У обеих обе фары разбиты! - Ну, слушай, надоело с этими Мерседесами цацкаться. Ты бери черную, а мне таки-да достанется белая.");
INSERT INTO chat_shutnik VALUES("480","- Эй мужик, ты пиво будешь? - Буду, конечно! - Когда будешь, то меня позови...");
INSERT INTO chat_shutnik VALUES("481","Осмотрев кран, сантехник говорит девушке - хозяйке квартиры: - А прокладку-то вам пора менять! Девушка, смущенно покраснев, бормочет: - А вы-то откуда знаете?");
INSERT INTO chat_shutnik VALUES("482","Приходит Вовочка из школы и говорит отцу: - Мне двойку по биологии поставили. Папаша: - За что? - Да спросили у кого самые большие яйца.\n- Ну а ты? - Я сказал у верблюда.\n- Правильно, а учительница? - А она говорит что у страуса. Отец (задумчиво): - У Страуса ... так вот он почему такие медленные вальсы писал.");
INSERT INTO chat_shutnik VALUES("483","Когда АбрамОвич родился, АбрАмович три дня плакал...");
INSERT INTO chat_shutnik VALUES("484","Приходит женщина к врачу: - Доктор, я хотела бы подправить форму одной груди. А то они у меня не одинаковые.\n- Ну показывайте.\n- Вот эта (вытаскивает) нормальная.\n- Вполне.\n- А вот эта (вытаскивает, грудь пля-ф-ф-ф-ф на пол) видите, какая? Доктор чешет в затылке: - Да, такое я в первый раз вижу.\n- Это, наверно, из-за моего мужа. Он, понимаете, не может заснуть, если за мою грудь не держится.\n- Ну что вы такое рассказываете? Я вам признаюсь, у меня самого есть такая маленькая мания, но у моей супруги грудь нормальная.\n- Так вы, наверно, доктор, с женой в одной комнате спите?");
INSERT INTO chat_shutnik VALUES("485","В нью-йоркском отеле вывешено объявление: \"Гасите сигареты! Помните о пожаре в Чикаго!\" Под этим объявлением кто-то подписал: \"Hе плюйте на пол, помните о весенних разливах Миссисипи!\"");
INSERT INTO chat_shutnik VALUES("486","По дороге на мопеде ехал \"голубой\". Ну и заглох его мопед. Встал он на обочине, пригорюнился. Тут к нему на \"Мерседесе\" подъезжает \"крутой\" и небрежно так открывая окно спрашивает: - Ну что, мужик, толкнем твое говно? Педик (с радостью в голосе): - Конечно, толкнем!! А потом и мопед починим!!");
INSERT INTO chat_shutnik VALUES("487","Мужик, недавно купивший себе \"Феppаpи\", несется на этой машине с огpомной скоpостью, наслаждаясь мощью двигателя. Вдpуг он видит табличку: \"Сбавь скоpость - км\". Мужик думает: \"Можно ведь было пpосто установить соответствующий запpещающий знак. А pаз они этого не сделали, значит, тут что-то сеpьезное и скоpость действительно надо сбавить\". Сбавляет он скоpость до км/ч - и чеpез некотоpое вpемя видит еще одну табличку: \"Сбавь скоpость - км\". Он и на этот pаз сбавляет скоpость до км/ч, хоть и с большой неохотой. Чеpез полчаса - опять табличка: \"Сбавь скоpость км\". Пpоклиная все на свете, он замедляется до км/ч. А еще чеpез час он видит такую вывеску: \"Добpо пожаловать в пpидоpожный pестоpан \"Сбавь скоpость!\"\"");
INSERT INTO chat_shutnik VALUES("488","В испанском публичном доме \"мадам\" кричит: - Донна Мария, дон Педро все еще на вас? - Да.\n- Не давайте ему кончить, он заплатил фальшивыми купюрами.");
INSERT INTO chat_shutnik VALUES("489","Пришел мужчина на пляж. Снимает майку - вся спина искусана. Народ: - Мужик, что у тебя со спиной-то?! Мужик, отмахиваясь: - Да вчера тут голубого трахал, дык всю спину изгрыз, зараза!");
INSERT INTO chat_shutnik VALUES("490","Мужик приходит в фирму по объявлению \"Требуется менеджер\". Показывает боссу свои дипломы - финансовый институт, школа управления, курсы менеджмента и т.п. Босс: - Это хорошо. Мне нужен сообразительный управленец. Он должен взять на себя главный наш больной вопрос - финансы. Кандидат: - С моим образованием это без проблем. А как насчет заработка? - Ну, вы начинающий, предполагаю вам пока положить $.\n- Да? Но откуда же ваша маленькая фирма берет средства, чтобы платить такие деньги? - Вот. Вот это первый вопрос, который вам предстоит решить.");
INSERT INTO chat_shutnik VALUES("491","Когда мужчины спрашивали ее о возрасте, она кокетливо смеялась и отвечала, что женщине столько лет, на сколько она выглядит. Некоторые ей верили и имели большие проблемы - паршивке еще не было -ти.");
INSERT INTO chat_shutnik VALUES("492","И волки сыты, и овцы целы. Светлая память пастуху!");
INSERT INTO chat_shutnik VALUES("493","\"Все зло от Б.А.Б.!\" В.В.П.");
INSERT INTO chat_shutnik VALUES("494","Заяц отслужил на флоте и возвращается домой. Идет по лесу, поет песню: - На побывку едет молодой моряк! В кустах его поджидает Волк, который тоже служил на флоте, и тоже тихонько напевает: - Напрасно старушка ждет сына домой!");
INSERT INTO chat_shutnik VALUES("495","В бане два маленьких мальчика увидели голого мужчину с большим животом. Спрашивают его: - Дядя, а что у тебя в животе? - Бомба. Один тихо говорит другому: - Давай взорвем ее.\n- Опасно очень короткий фитиль.");
INSERT INTO chat_shutnik VALUES("496","Два бpаконьеpа: - Вчеpа поймал огpомного осетpа. Закинyл его на спинy и идy домой.\n- Hy? - А тyт из-за кyстов - инспектоp pыбнадзоpа! - Hy?! - А я осетpа со спины - и в каpман!");
INSERT INTO chat_shutnik VALUES("497","- Твоя собака, сосед, укусила мою жену за ногу. Придется тебе заплатить штраф.\n- За то, что может быть возмещено,- отвечает Насреддин,- нельзя требовать выкупа. Пришли свою собаку, пусть она укусит за ногу мою жену. И мы в расчете!");
INSERT INTO chat_shutnik VALUES("498","Ползут по пустыне два унитаза. Один говорит другому: - Ген, а Ген ! Давай приколупаемся к той черепахе ! - Hе надо, Чебурашка, Мы уже к старику Хотабычу приколупались !");
INSERT INTO chat_shutnik VALUES("499","У Моллы был длиннорогий бык. Целые дни и ночи Молла думал: как бы хоть раз сесть быку на голову, между рогами. Но удачного случая не представлялось. Однажды ночью Молла вышел во двор и видит: бык лежит на земле, пережевывая свою жвачку. Вот подходящий момент! -подумал Молла. Подобрав полы своей чохи, он вскочил быку на голову и уселся между рогами. Бык, испугавшись, вскочил и, мотнув головой, сбросил Моллу на землю. Молла закричал и упал в обморок. Услышав крик Моллы, жена его выбежала из дому и видит: муж ее лежит в крови, без сознания. Она подняла крик. Сбежался народ. Моллу привели в чувство. Оказалось, он сломал ногу. Его подняли, внесли в дом и уложили в постель. Молла огляделся по сторонам и заметил, что жена плачет. Он поднял голову и сказал ей: - Жена, не плачь. Хотя я упал и разбился, но зато желание мое исполнилось.");
INSERT INTO chat_shutnik VALUES("500","Идет мужик пьяный, смотрит - лужа, а в луже луна отражается.\n- У, сейчас на луне покатаюсь. Сел на нее и сидит. Идет милиционер, увидел мужика и спрашивает: - Эй, мужик, ты что тут делаешь? - На луне сижу.\n- Ну сиди, сиди, сейчас луноход подойдет.");



DROP TABLE IF EXISTS `chat_vopros`;

CREATE TABLE `chat_vopros` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `vopros` varchar(1024) NOT NULL,
  `otvet` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=502 DEFAULT CHARSET=utf8;

INSERT INTO chat_vopros VALUES("2","Сильная жара.","зной");
INSERT INTO chat_vopros VALUES("3","Пояс, территория с какими-либо общими признаками.","зона");
INSERT INTO chat_vopros VALUES("4","Медицинский инструмент для исследования внутренностей организма.","зонд");
INSERT INTO chat_vopros VALUES("5","Метеорологический воздушный шар.","зонд");
INSERT INTO chat_vopros VALUES("6","Крупный дикий лесной бык.","зубр");
INSERT INTO chat_vopros VALUES("7","Легкая рябь на водной поверхности.","зыбь");
INSERT INTO chat_vopros VALUES("8","Южный ветер, юг.","зюйд");
INSERT INTO chat_vopros VALUES("9","Поле, вспаханное с осени для посева яровых.","зябь");
INSERT INTO chat_vopros VALUES("10","Мысль, намерение, план.","идея");
INSERT INTO chat_vopros VALUES("11","Язык части евреев.","идиш");
INSERT INTO chat_vopros VALUES("12","Статуя, предмет, которому поклоняются как божеству.","идол");
INSERT INTO chat_vopros VALUES("13","Сушеные ягоды винограда.","изюм");
INSERT INTO chat_vopros VALUES("14","Жестокий древнеиудейский царь.","ирод");
INSERT INTO chat_vopros VALUES("15","Помесь лошади и осла.","ишак");
INSERT INTO chat_vopros VALUES("16","Осел или мул.","ишак");
INSERT INTO chat_vopros VALUES("17","Невысокая упрямая лошадь.","осел");
INSERT INTO chat_vopros VALUES("18","Исторически сложившаяся группа человечества с общими наследственными признаками.","раса");
INSERT INTO chat_vopros VALUES("19","Буква греческого алфавита.","йота");
INSERT INTO chat_vopros VALUES("20","Ледяная корка на снегу.","наст");
INSERT INTO chat_vopros VALUES("21","Представитель черной расы.","негр");
INSERT INTO chat_vopros VALUES("22","Углубление в стене, скате горы, берега.","ниша");
INSERT INTO chat_vopros VALUES("23","Число, деление на которое невозможно.","нуль");
INSERT INTO chat_vopros VALUES("24","В древнегреческой мифологии богиня победы.","ника");
INSERT INTO chat_vopros VALUES("25","Женское имя (греч. победительница).","ника");
INSERT INTO chat_vopros VALUES("26","Зазор между сопряженными поверхностями частей машин.","люфт");
INSERT INTO chat_vopros VALUES("27","Единица освещенности.","люкс");
INSERT INTO chat_vopros VALUES("28","Лучший номер в гостинице.","люкс");
INSERT INTO chat_vopros VALUES("29","Внутренняя часть коры липы, ивы.","лыко");
INSERT INTO chat_vopros VALUES("30","Материал для плетения лаптей.","лыко");
INSERT INTO chat_vopros VALUES("31","Буддийский монах.","лама");
INSERT INTO chat_vopros VALUES("32","Южноамериканское вьючное животное.","лама");
INSERT INTO chat_vopros VALUES("33","Южное вечнозеленое душистое растение, листья которого употребляются как специя.","лавр");
INSERT INTO chat_vopros VALUES("34","Стройное быстрое животное сем. оленей.","лань");
INSERT INTO chat_vopros VALUES("35","Ребро чеканной монеты.","гурт");
INSERT INTO chat_vopros VALUES("36","Стадо домашних животных.","гурт");
INSERT INTO chat_vopros VALUES("37","Духовный наставник, учитель.","гуру");
INSERT INTO chat_vopros VALUES("38","Туго натянутая веревка на судне, предохраняющая от падения людей за борт.","леер");
INSERT INTO chat_vopros VALUES("39","Ограждение вдоль бортов судна.","леер");
INSERT INTO chat_vopros VALUES("40","Край диска звезды, планеты.","лимб");
INSERT INTO chat_vopros VALUES("41","Кольцо с делениями для отсчета углов в угломерных инструментах.","лимб");
INSERT INTO chat_vopros VALUES("42","Пеньковый трос для корабельных снастей.","линь");
INSERT INTO chat_vopros VALUES("43","Пресноводная рыба сем. карповых с толстым слизистым телом.","линь");
INSERT INTO chat_vopros VALUES("44","Медоносное лиственное дерево.","липа");
INSERT INTO chat_vopros VALUES("45","Старинный струнный музыкальный инструмент.","лира");
INSERT INTO chat_vopros VALUES("46","Созвездие Северного полушария.","лира");
INSERT INTO chat_vopros VALUES("47","Денежная единица Италии, Турции.","лира");
INSERT INTO chat_vopros VALUES("48","Хитрая хищница с пушистым хвостом.","лиса");
INSERT INTO chat_vopros VALUES("49","Венгерский композитор, дирижер, создатель нового направления в пианизме, симфонии \"Орфей\", \"Прометей\".","лист");
INSERT INTO chat_vopros VALUES("50","Часть кроны дерева.","лист");
INSERT INTO chat_vopros VALUES("51","Метрическая единица объема.","литр");
INSERT INTO chat_vopros VALUES("52","Подъемник с кабиной для перемещения грузов, людей.","лифт");
INSERT INTO chat_vopros VALUES("53","Неправда, обман.","ложь");
INSERT INTO chat_vopros VALUES("54","Высший дворянский наследственный титул в Англии.","лорд");
INSERT INTO chat_vopros VALUES("55","Попугай, питающийся нектаром.","лори");
INSERT INTO chat_vopros VALUES("56","Самый крупный олень.","лось");
INSERT INTO chat_vopros VALUES("57","Крупный олень с широкими рогами.","лось");
INSERT INTO chat_vopros VALUES("58","Сохатый.","лось");
INSERT INTO chat_vopros VALUES("59","Ямка с водой.","лужа");
INSERT INTO chat_vopros VALUES("60","Корзинка бильярдного стола.","луза");
INSERT INTO chat_vopros VALUES("61","Увеличительное стекло.","лупа");
INSERT INTO chat_vopros VALUES("62","Наружное лекарство.","мазь");
INSERT INTO chat_vopros VALUES("63","Состав для натирания различных участков тела.","мазь");
INSERT INTO chat_vopros VALUES("64","Французский художник-импрессионист, картины \"Завтрак на траве\", \"Олимпия\".","мане");
INSERT INTO chat_vopros VALUES("65","Планета Солнечной системы.","марс");
INSERT INTO chat_vopros VALUES("66","В древнеримской мифологии бог войны.","марс");
INSERT INTO chat_vopros VALUES("67","Площадка на верху мачты для наблюдения над горизонтом.","марс");
INSERT INTO chat_vopros VALUES("68","Выдающаяся французская эстрадная певица.","пиаф");
INSERT INTO chat_vopros VALUES("69","Пресная сухая лепешка у евреев.","маца");
INSERT INTO chat_vopros VALUES("70","Береговой ориентир для судов.","маяк");
INSERT INTO chat_vopros VALUES("71","Непрозрачность воздуха из-за пыли, дыма, метели, сумерек.","мгла");
INSERT INTO chat_vopros VALUES("72","Ночной сумрак.","мгла");
INSERT INTO chat_vopros VALUES("73","Спортивное состязание.","матч");
INSERT INTO chat_vopros VALUES("74","Ковкий химический элемент красновато-желтого цвета.","медь");
INSERT INTO chat_vopros VALUES("75","Граница земельных участков.","межа");
INSERT INTO chat_vopros VALUES("76","Основная единица длины.","метр");
INSERT INTO chat_vopros VALUES("77","Английская морская единица длины = 1,852 км.","миля");
INSERT INTO chat_vopros VALUES("78","Английская единица длины = 1,60934 км.","миля");
INSERT INTO chat_vopros VALUES("79","Непрочная, быстропроходящая популярность.","мода");
INSERT INTO chat_vopros VALUES("80","Бабочка, вредитель вещей.","моль");
INSERT INTO chat_vopros VALUES("81","Единица количества вещества.","моль");
INSERT INTO chat_vopros VALUES("82","Французский художник-импрессионист, картина \"Кувшинки\".","моне");
INSERT INTO chat_vopros VALUES("83","Английский писатель, мастер новеллы, роман \"Луна и грош\".","моэм");
INSERT INTO chat_vopros VALUES("84","Плотная шелковая ткань, переливающаяся на свету.","муар");
INSERT INTO chat_vopros VALUES("85","В греческой мифологии одна из девяти муз, покровительница истории.","клио");
INSERT INTO chat_vopros VALUES("86","Надоедливое двукрылое насекомое.","муха");
INSERT INTO chat_vopros VALUES("87","Созвездие Южного полушария.","муха");
INSERT INTO chat_vopros VALUES("88","Моющее средство.","мыло");
INSERT INTO chat_vopros VALUES("89","Грызун, вредитель сельского хозяйства.","мышь");
INSERT INTO chat_vopros VALUES("90","Периферийное устройство компьютера.","мышь");
INSERT INTO chat_vopros VALUES("91","Нестабильная заряженная элементарная частица.","мюон");
INSERT INTO chat_vopros VALUES("92","Часть туши убитого животного, употребляемая в пищу.","мясо");
INSERT INTO chat_vopros VALUES("93","Основной источник белка в питании человека.","мясо");
INSERT INTO chat_vopros VALUES("94","Душистое лекарственное растение.","мята");
INSERT INTO chat_vopros VALUES("95","Выпуклая замкнутая плоская кривая без изломов.","овал");
INSERT INTO chat_vopros VALUES("96","Зодиакальное созвездие (март).","овен");
INSERT INTO chat_vopros VALUES("97","Домашнее жвачное животное.","овца");
INSERT INTO chat_vopros VALUES("98","Полевое земляное укрытие личного состава.","окоп");
INSERT INTO chat_vopros VALUES("99","Государство на Аравийском полуострове.","оман");
INSERT INTO chat_vopros VALUES("100","Буква греческого алфавита.","бета");
INSERT INTO chat_vopros VALUES("101","Областной центр, порт на реке Иртыш.","омск");
INSERT INTO chat_vopros VALUES("102","Аморфный драгоценный камень.","опал");
INSERT INTO chat_vopros VALUES("103","Накопленные знания и навыки.","опыт");
INSERT INTO chat_vopros VALUES("104","Научный эксперимент.","опыт");
INSERT INTO chat_vopros VALUES("105","Плод в скорлупе.","орех");
INSERT INTO chat_vopros VALUES("106","Роман Войнич .","овод");
INSERT INTO chat_vopros VALUES("107","Двукрылое насекомое, личинки которого паразитируют в теле животных.","овод");
INSERT INTO chat_vopros VALUES("108","Трудноискоренимый сорняк.","осот");
INSERT INTO chat_vopros VALUES("109","Крупная сорная колючая трава.","осот");
INSERT INTO chat_vopros VALUES("110","Способность воспринимать звуковые колебания.","слух");
INSERT INTO chat_vopros VALUES("111","Прибор для коррекции зрения.","очки");
INSERT INTO chat_vopros VALUES("112","Американские авиаконструкторы, братья, пионеры авиации.","райт");
INSERT INTO chat_vopros VALUES("113","Звание, чин.","ранг");
INSERT INTO chat_vopros VALUES("114","Кровососущее насекомое, паразит.","клоп");
INSERT INTO chat_vopros VALUES("115","Пьеса В.Маяковского .","клоп");
INSERT INTO chat_vopros VALUES("116","Связанные между собой плавучие предметы для перевозки грузов, людей.","плот");
INSERT INTO chat_vopros VALUES("117","Скрепленные между собой бревна для переправы.","плот");
INSERT INTO chat_vopros VALUES("118","Маршрут в один конец.","рейс");
INSERT INTO chat_vopros VALUES("119","Большой водный поток, текущий в русле.","река");
INSERT INTO chat_vopros VALUES("120","Порода короткошерстных кроликов.","рекс");
INSERT INTO chat_vopros VALUES("121","Способность человека говорить.","речь");
INSERT INTO chat_vopros VALUES("122","Металлический оклад на иконе.","риза");
INSERT INTO chat_vopros VALUES("123","Темп, скорость музыки.","ритм");
INSERT INTO chat_vopros VALUES("124","Твердые выросты на голове копытных животных.","рога");
INSERT INTO chat_vopros VALUES("125","Яровой злак.","рожь");
INSERT INTO chat_vopros VALUES("126","Декоративный душистый цветок с шипами на стебле.","роза");
INSERT INTO chat_vopros VALUES("127","Воплощенный актером образ.","роль");
INSERT INTO chat_vopros VALUES("128","Параллелограмм с равными сторонами.","ромб");
INSERT INTO chat_vopros VALUES("129","Река в Швейцарии и Франции.","рона");
INSERT INTO chat_vopros VALUES("130","Конденсат на почве, траве.","роса");
INSERT INTO chat_vopros VALUES("131","Английские полярные исследователи, дядя и племянник.","росс");
INSERT INTO chat_vopros VALUES("132","Японская национальная борьба.","сумо");
INSERT INTO chat_vopros VALUES("133","Небольшой лесной массив лиственных деревьев.","роща");
INSERT INTO chat_vopros VALUES("134","Минеральное полезное ископаемое, горная порода.","руда");
INSERT INTO chat_vopros VALUES("135","Поворотное устройство машин, судов.","руль");
INSERT INTO chat_vopros VALUES("136","Состриженная сплошным пластом шерсть овцы.","руно");
INSERT INTO chat_vopros VALUES("137","Водное позвоночное.","рыба");
INSERT INTO chat_vopros VALUES("138","Зодиакальное созвездие (февраль).","рыбы");
INSERT INTO chat_vopros VALUES("139","Способ бега лошади.","рысь");
INSERT INTO chat_vopros VALUES("140","Хищник с кисточками на ушах.","рысь");
INSERT INTO chat_vopros VALUES("141","Созвездие Северного полушария.","рысь");
INSERT INTO chat_vopros VALUES("142","Государство в Южной Америке.","перу");
INSERT INTO chat_vopros VALUES("143","Сладкая вязкая масса с орехами.","нуга");
INSERT INTO chat_vopros VALUES("144","Санитарка в лечебном учреждении.","няня");
INSERT INTO chat_vopros VALUES("145","Работница по уходу за детьми.","няня");
INSERT INTO chat_vopros VALUES("146","Тюремная кровать.","нары");
INSERT INTO chat_vopros VALUES("147","Немецкий писатель, мыслитель и естествоиспытатель, трагедия \"Фауст\".","гете");
INSERT INTO chat_vopros VALUES("148","Французский писатель, роман \"Отверженные\".","гюго");
INSERT INTO chat_vopros VALUES("149","Широкие массы населения.","низы");
INSERT INTO chat_vopros VALUES("150","Нижняя конечность человека.","нога");
INSERT INTO chat_vopros VALUES("151","Северный ветер, север.","норд");
INSERT INTO chat_vopros VALUES("152","Западный ветер, запад.","вест");
INSERT INTO chat_vopros VALUES("153","То же, что характер.","нрав");
INSERT INTO chat_vopros VALUES("154","Прием пищи в середине дня.","обед");
INSERT INTO chat_vopros VALUES("155","Резкий толчок.","удар");
INSERT INTO chat_vopros VALUES("156","Административно-территориальная единица в составе губернии в дореволюционной России.","уезд");
INSERT INTO chat_vopros VALUES("157","Чувство сильного страха.","ужас");
INSERT INTO chat_vopros VALUES("158","Вечерняя еда.","ужин");
INSERT INTO chat_vopros VALUES("159","Часть сбруи.","узда");
INSERT INTO chat_vopros VALUES("160","Постановление верховного органа власти, имеющее силу закона.","указ");
INSERT INTO chat_vopros VALUES("161","То же, что инъекция.","укол");
INSERT INTO chat_vopros VALUES("162","Упрек, порицание.","укор");
INSERT INTO chat_vopros VALUES("163","Военнослужащий легкой кавалерии в русской армии.","улан");
INSERT INTO chat_vopros VALUES("164","Количество пойманной рыбы, дичи.","улов");
INSERT INTO chat_vopros VALUES("165","Селение в Средней Азии и некоторых районах Сибири.","улус");
INSERT INTO chat_vopros VALUES("166","Белый медведь.","умка");
INSERT INTO chat_vopros VALUES("167","Учебный час в школе.","урок");
INSERT INTO chat_vopros VALUES("168","Сушеные абрикосы с косточками.","урюк");
INSERT INTO chat_vopros VALUES("169","Ложный слух.","утка");
INSERT INTO chat_vopros VALUES("170","Водоплавающая птица.","утка");
INSERT INTO chat_vopros VALUES("171","Начало дня.","утро");
INSERT INTO chat_vopros VALUES("172","Прибор для глаженья.","утюг");
INSERT INTO chat_vopros VALUES("173","Регистрация наличия чего-либо.","учет");
INSERT INTO chat_vopros VALUES("174","Небольшая кадка.","ушат");
INSERT INTO chat_vopros VALUES("175","В греческой мифологии царица богов, жена Зевса.","гера");
INSERT INTO chat_vopros VALUES("176","У мусульман человек иной веры.","гяур");
INSERT INTO chat_vopros VALUES("177","В старину налог с побежденных.","дань");
INSERT INTO chat_vopros VALUES("178","Календарное время какого-либо события.","дата");
INSERT INTO chat_vopros VALUES("179","Загородный участок с летним домом.","дача");
INSERT INTO chat_vopros VALUES("180","Здание, сооружение для ж/д подвижного состава.","депо");
INSERT INTO chat_vopros VALUES("181","Заросший травой верхний слой почвы.","дерн");
INSERT INTO chat_vopros VALUES("182","Волокнистое растение для изготовления, веревок канатов.","джут");
INSERT INTO chat_vopros VALUES("183","Укрепленная оборонительная огневая точка.","дзот");
INSERT INTO chat_vopros VALUES("184","Взятое взаймы.","долг");
INSERT INTO chat_vopros VALUES("185","Денежная единица Вьетнама.","донг");
INSERT INTO chat_vopros VALUES("186","Тяжелая плотная шерстяная ткань.","драп");
INSERT INTO chat_vopros VALUES("187","Близкий, верный товарищ.","друг");
INSERT INTO chat_vopros VALUES("188","Часть кривой линии.","дуга");
INSERT INTO chat_vopros VALUES("189","Часть окружности.","дуга");
INSERT INTO chat_vopros VALUES("190","Ствол огнестрельного оружия.","дуло");
INSERT INTO chat_vopros VALUES("191","Сорт небольших груш.","дуля");
INSERT INTO chat_vopros VALUES("192","Мысль, размышление.","дума");
INSERT INTO chat_vopros VALUES("193","Музыкальное произведение для двух исполнителей.","дуэт");
INSERT INTO chat_vopros VALUES("194","Старинное орудие пытки, на котором истязуемого растягивали.","дыба");
INSERT INTO chat_vopros VALUES("195","Бахчевая культура.","дыня");
INSERT INTO chat_vopros VALUES("196","Низший служитель в православной церкви.","дьяк");
INSERT INTO chat_vopros VALUES("197","Английская единица длины = 2,54 см.","дюйм");
INSERT INTO chat_vopros VALUES("198","Английская единица длины = 1/12 фута.","дюйм");
INSERT INTO chat_vopros VALUES("199","Полярная морская птица с ценным пухом.","гага");
INSERT INTO chat_vopros VALUES("200","Полярная утка.","гага");
INSERT INTO chat_vopros VALUES("201","Выжженное место в лесу.","гарь");
INSERT INTO chat_vopros VALUES("202","В греческой мифологии богиня вечной юности, супруга Геракла.","геба");
INSERT INTO chat_vopros VALUES("203","Студенистое вещество.","гель");
INSERT INTO chat_vopros VALUES("204","В западноевропейской мифологии карлик, охраняющий подземные сокровища.","гном");
INSERT INTO chat_vopros VALUES("205","Старая мера аптекарского веса = 62,21 мг.","гран");
INSERT INTO chat_vopros VALUES("206","Крупная хищная птица, питающаяся падалью.","гриф");
INSERT INTO chat_vopros VALUES("207","Часть музыкального инструмента, над которой натянуты струны.","гриф");
INSERT INTO chat_vopros VALUES("208","Сладкий разбавленный горячий напиток из рома или коньяка.","грог");
INSERT INTO chat_vopros VALUES("209","Старинная медная монета в полкопейки.","грош");
INSERT INTO chat_vopros VALUES("210","Очень подвижная рыбка.","вьюн");
INSERT INTO chat_vopros VALUES("211","Поклажа для перевозки на спине животных.","вьюк");
INSERT INTO chat_vopros VALUES("212","Сплетение нескольких букв в один сложный знак.","вязь");
INSERT INTO chat_vopros VALUES("213","Вспомогательный якорь на судне.","верп");
INSERT INTO chat_vopros VALUES("214","Древнегреческие счеты.","абак");
INSERT INTO chat_vopros VALUES("215","Монгольский крестьянин-скотовод.","арат");
INSERT INTO chat_vopros VALUES("216","Испанский гротескный живописец, гравер.","гойя");
INSERT INTO chat_vopros VALUES("217","Раскраска, оформление лица.","грим");
INSERT INTO chat_vopros VALUES("218","Тяжесть, тяжелый предмет.","груз");
INSERT INTO chat_vopros VALUES("219","Игральная карта.","дама");
INSERT INTO chat_vopros VALUES("220","Дерево с твердой древесиной сем. березовых.","граб");
INSERT INTO chat_vopros VALUES("221","Норвежский композитор, пианист, дирижер, сюита \"Пер Гюнт\".","григ");
INSERT INTO chat_vopros VALUES("222","Русский советский писатель, повесть \"Алые паруса\".","грин");
INSERT INTO chat_vopros VALUES("223","Действительное происшествие в прошлом.","быль");
INSERT INTO chat_vopros VALUES("224","Правдивая история.","быль");
INSERT INTO chat_vopros VALUES("225","Большие весы для тяжелых предметов.","вага");
INSERT INTO chat_vopros VALUES("226","Листья папоротников.","вайя");
INSERT INTO chat_vopros VALUES("227","Общее собрание горожан на Руси.","вече");
INSERT INTO chat_vopros VALUES("228","Индийский струнный щипковый музыкальный инструмент из сушеной тыквы.","вина");
INSERT INTO chat_vopros VALUES("229","Проступок, преступление.","вина");
INSERT INTO chat_vopros VALUES("230","Карточная игра.","вист");
INSERT INTO chat_vopros VALUES("231","Самая распространенная на земле жидкость.","вода");
INSERT INTO chat_vopros VALUES("232","Растаявший лед.","вода");
INSERT INTO chat_vopros VALUES("233","Короткий густой пушок на ткани.","ворс");
INSERT INTO chat_vopros VALUES("234","Материал для постройки пчелиных сот.","воск");
INSERT INTO chat_vopros VALUES("235","Путешествие, поездка.","вояж");
INSERT INTO chat_vopros VALUES("236","Ночная болотная птица.","выпь");
INSERT INTO chat_vopros VALUES("237","Небесная даль.","высь");
INSERT INTO chat_vopros VALUES("238","Французский композитор, опера \"Ромео и Джульетта\".","гуно");
INSERT INTO chat_vopros VALUES("239","Правый приток Амударьи.","вахш");
INSERT INTO chat_vopros VALUES("240","Приданое жены.","вено");
INSERT INTO chat_vopros VALUES("241","Французский математик, разработчик элементарной алгебры.","виет");
INSERT INTO chat_vopros VALUES("242","Приятная расслабленность.","кайф");
INSERT INTO chat_vopros VALUES("243","Боевое построение пехоты четырехугольником.","каре");
INSERT INTO chat_vopros VALUES("244","Столица Египта.","каир");
INSERT INTO chat_vopros VALUES("245","Порт во Франции.","кале");
INSERT INTO chat_vopros VALUES("246","Пресноводная рыба, одомашненный сазан.","карп");
INSERT INTO chat_vopros VALUES("247","Гоночный микролитражный автомобиль без кузова.","карт");
INSERT INTO chat_vopros VALUES("248","Спортивные матерчатые ботинки на резиновой подошве.","кеды");
INSERT INTO chat_vopros VALUES("249","Образец породы из скважины при бурении.","керн");
INSERT INTO chat_vopros VALUES("250","Женщина, которой Пушкин посвятил \"Я помню чудное мгновенье...\".","керн");
INSERT INTO chat_vopros VALUES("251","Дальневосточная лососевая рыба.","кета");
INSERT INTO chat_vopros VALUES("252","Ароматный и сочный тропический фрукт.","киви");
INSERT INTO chat_vopros VALUES("253","Субтропический ароматный и сочный плод.","киви");
INSERT INTO chat_vopros VALUES("254","Новозеландская бескрылая птица.","киви");
INSERT INTO chat_vopros VALUES("255","Балка днища судна от носа до кормы.","киль");
INSERT INTO chat_vopros VALUES("256","Часть хвостового оперения самолета, ракеты.","киль");
INSERT INTO chat_vopros VALUES("257","Созвездие Южного полушария.","киль");
INSERT INTO chat_vopros VALUES("258","То же, что фильм.","кино");
INSERT INTO chat_vopros VALUES("259","Зарытые, спрятанные сокровища.","клад");
INSERT INTO chat_vopros VALUES("260","Мафиозная семья.","клан");
INSERT INTO chat_vopros VALUES("261","Родовая или семейная община.","клан");
INSERT INTO chat_vopros VALUES("262","Расширение юбки, брюк, пальто внизу.","клеш");
INSERT INTO chat_vopros VALUES("263","Цепкое мелкое членистоногое животное.","клещ");
INSERT INTO chat_vopros VALUES("264","Кусок дерева, металла с сужающимся плоским концом.","клин");
INSERT INTO chat_vopros VALUES("265","Призыв, возглас.","клич");
INSERT INTO chat_vopros VALUES("266","Торчащая прядь.","клок");
INSERT INTO chat_vopros VALUES("267","Копия организма.","клон");
INSERT INTO chat_vopros VALUES("268","Культурно-просветительное учреждение.","клуб");
INSERT INTO chat_vopros VALUES("269","Зуб, расположенный сразу за резцом.","клык");
INSERT INTO chat_vopros VALUES("270","Челюсти у птиц.","клюв");
INSERT INTO chat_vopros VALUES("271","Знак в начале нотной строки.","ключ");
INSERT INTO chat_vopros VALUES("272","Приспособление для отпирания замков.","ключ");
INSERT INTO chat_vopros VALUES("273","Тряпка, насильно засовываемая в рот для предупреждения крика.","кляп");
INSERT INTO chat_vopros VALUES("274","Насильно засунутая в рот тряпка.","кляп");
INSERT INTO chat_vopros VALUES("275","Большая плеть.","кнут");
INSERT INTO chat_vopros VALUES("276","Наружный покров тела человека, животного.","кожа");
INSERT INTO chat_vopros VALUES("277","Твердое топливо.","кокс");
INSERT INTO chat_vopros VALUES("278","Столица Украины.","киев");
INSERT INTO chat_vopros VALUES("279","Украинское название волынки.","коза");
INSERT INTO chat_vopros VALUES("280","Домашнее парнокопытное животное.","коза");
INSERT INTO chat_vopros VALUES("281","То же, что рудник.","копи");
INSERT INTO chat_vopros VALUES("282","Вес чистого благородного металла в монете.","корн");
INSERT INTO chat_vopros VALUES("283","Сплетеные в виде жгута волосы.","коса");
INSERT INTO chat_vopros VALUES("284","Ручное сельскохозяйственное орудие.","коса");
INSERT INTO chat_vopros VALUES("285","Ручное сельскохозяйственное орудие для срезания травы.","коса");
INSERT INTO chat_vopros VALUES("286","Береговая отмель.","коса");
INSERT INTO chat_vopros VALUES("287","Короткохвостый рак.","краб");
INSERT INTO chat_vopros VALUES("288","Десятиногое ракообразное животное.","краб");
INSERT INTO chat_vopros VALUES("289","Эмблема на форменной фуражке моряков.","краб");
INSERT INTO chat_vopros VALUES("290","Крупная административно-территориальная единица.","край");
INSERT INTO chat_vopros VALUES("291","Обладатель несметных богатств.","крез");
INSERT INTO chat_vopros VALUES("292","Наклон судна набок.","крен");
INSERT INTO chat_vopros VALUES("293","Задняя часть туловища лошади.","круп");
INSERT INTO chat_vopros VALUES("294","Гряда холмов.","кряж");
INSERT INTO chat_vopros VALUES("295","Невысокая горная цепь.","кряж");
INSERT INTO chat_vopros VALUES("296","Крестная мать по отношению к родителям крестника.","кума");
INSERT INTO chat_vopros VALUES("297","Река в Дагестане.","кума");
INSERT INTO chat_vopros VALUES("298","Отделение в пассажирском вагоне.","купе");
INSERT INTO chat_vopros VALUES("299","Направление движения, путь транспорта.","курс");
INSERT INTO chat_vopros VALUES("300","Биржевая цена ценных бумаг.","курс");
INSERT INTO chat_vopros VALUES("301","Ветвистое травянистое растение.","куст");
INSERT INTO chat_vopros VALUES("302","Католический приходской священник.","кюре");
INSERT INTO chat_vopros VALUES("303","Жена помещика, барина в старину на Украине, в Польше.","пани");
INSERT INTO chat_vopros VALUES("304","Отец.","папа");
INSERT INTO chat_vopros VALUES("305","Глава католической церкви.","папа");
INSERT INTO chat_vopros VALUES("306","Спор с каким-либо условием.","пари");
INSERT INTO chat_vopros VALUES("307","Титул высших сановников и генералов в древней Турции.","паша");
INSERT INTO chat_vopros VALUES("308","Прежнее название клоуна.","паяц");
INSERT INTO chat_vopros VALUES("309","Торчащий из земли остаток спиленного дерева.","пень");
INSERT INTO chat_vopros VALUES("310","Орудие для письма в старину.","перо");
INSERT INTO chat_vopros VALUES("311","Стреловидный лист лука, чеснока.","перо");
INSERT INTO chat_vopros VALUES("312","Сооружение для отопления помещения.","печь");
INSERT INTO chat_vopros VALUES("313","Созвездие Южного полушария.","печь");
INSERT INTO chat_vopros VALUES("314","Род копья.","пика");
INSERT INTO chat_vopros VALUES("315","Крутое снижение самолета.","пике");
INSERT INTO chat_vopros VALUES("316","Черная масть в картах.","пики");
INSERT INTO chat_vopros VALUES("317","Зубчатый режущий инструмент.","пила");
INSERT INTO chat_vopros VALUES("318","Декоративный яркий цветок семейства лютиковых.","пион");
INSERT INTO chat_vopros VALUES("319","Нестабильная элементарная частица.","пион");
INSERT INTO chat_vopros VALUES("320","Портовое причальное сооружение.","пирс");
INSERT INTO chat_vopros VALUES("321","14-й президент США.","пирс");
INSERT INTO chat_vopros VALUES("322","Непромокаемое пальто.","плащ");
INSERT INTO chat_vopros VALUES("323","Дорожное одеяло.","плед");
INSERT INTO chat_vopros VALUES("324","Знак сложения в математике.","плюс");
INSERT INTO chat_vopros VALUES("325","Ткань с ворсом.","плюш");
INSERT INTO chat_vopros VALUES("326","Лиановое растение.","плющ");
INSERT INTO chat_vopros VALUES("327","Положение тела.","поза");
INSERT INTO chat_vopros VALUES("328","Безлесная равнинная территория.","поле");
INSERT INTO chat_vopros VALUES("329","Участок земли под посевы.","поле");
INSERT INTO chat_vopros VALUES("330","Ответственная должность.","пост");
INSERT INTO chat_vopros VALUES("331","Воздержание от скоромной пищи.","пост");
INSERT INTO chat_vopros VALUES("332","Место постоянного дежурства.","пост");
INSERT INTO chat_vopros VALUES("333","Автор стихов.","поэт");
INSERT INTO chat_vopros VALUES("334","Ремень на талии.","пояс");
INSERT INTO chat_vopros VALUES("335","Зона на Земле с одинаковым временем.","пояс");
INSERT INTO chat_vopros VALUES("336","Французский физик, вместе с женой исследовавший радиоактивность.","кюри");
INSERT INTO chat_vopros VALUES("337","Единица активности радиоактивных изотопов.","кюри");
INSERT INTO chat_vopros VALUES("338","Тонкая ветка без листьев.","прут");
INSERT INTO chat_vopros VALUES("339","Левый приток Дуная.","прут");
INSERT INTO chat_vopros VALUES("340","Неуравновешенный или душевнобольной человек.","псих");
INSERT INTO chat_vopros VALUES("341","Напиток из рома с приправами.","пунш");
INSERT INTO chat_vopros VALUES("342","Момент приведения в движение.","пуск");
INSERT INTO chat_vopros VALUES("343","Веревка, ремни, стягивающие тело пленника.","путы");
INSERT INTO chat_vopros VALUES("344","Густой труднопроходимый лес.","пуща");
INSERT INTO chat_vopros VALUES("345","Протертая масса из фруктов, ягод или овощей.","пюре");
INSERT INTO chat_vopros VALUES("346","Мелкое волнение водной поверхности.","рябь");
INSERT INTO chat_vopros VALUES("347","Открытое повреждение тканей тела.","рана");
INSERT INTO chat_vopros VALUES("348","То же, что войско.","рать");
INSERT INTO chat_vopros VALUES("349","Гитлеровская империя.","рейх");
INSERT INTO chat_vopros VALUES("350","Столица Латвии.","рига");
INSERT INTO chat_vopros VALUES("351","Французский композитор, балет \"Жизель\".","адан");
INSERT INTO chat_vopros VALUES("352","Французская писательница, роман \"Консуэло\".","санд");
INSERT INTO chat_vopros VALUES("353","Мать жены.","теща");
INSERT INTO chat_vopros VALUES("354","Полосатый полудрагоценный камень.","агат");
INSERT INTO chat_vopros VALUES("355","Работник по уходу за коровами.","дояр");
INSERT INTO chat_vopros VALUES("356","Государство в Центральной Африке.","заир");
INSERT INTO chat_vopros VALUES("357","Французский писатель, роман \"Жерминаль\".","золя");
INSERT INTO chat_vopros VALUES("358","Один из изобретателей телефона, шотландец.","белл");
INSERT INTO chat_vopros VALUES("359","Порт на реке Луара во Франции.","нант");
INSERT INTO chat_vopros VALUES("360","Столбообразное тело в жерле вулкана.","некк");
INSERT INTO chat_vopros VALUES("361","Премьер-министр Индии, сподвижник М.К.Ганди.","неру");
INSERT INTO chat_vopros VALUES("362","Французский композитор, музыка \"Марсельеза\".","лиль");
INSERT INTO chat_vopros VALUES("363","Французский композитор, опера \"Сон в летнюю ночь\".","тома");
INSERT INTO chat_vopros VALUES("364","Место переправы через реку.","брод");
INSERT INTO chat_vopros VALUES("365","Роман Ф.М.Достоевского .","бесы");
INSERT INTO chat_vopros VALUES("366","Роман Э.Золя .","нана");
INSERT INTO chat_vopros VALUES("367","Колдовство, волшебство.","чары");
INSERT INTO chat_vopros VALUES("368","Стихотворение С.Есенина .","чары");
INSERT INTO chat_vopros VALUES("369","Опера Ж.Массне .","таис");
INSERT INTO chat_vopros VALUES("370","Американский писатель, роман \"Приключения Гекльберри Финна\".","твен");
INSERT INTO chat_vopros VALUES("371","Древнегреческий баснописец.","эзоп");
INSERT INTO chat_vopros VALUES("372","Русский советский писатель, соавтор романа \"12 стульев\".","ильф");
INSERT INTO chat_vopros VALUES("373","Английский математик, разработавший алгебру логики.","буль");
INSERT INTO chat_vopros VALUES("374","Французский писатель-фантаст, роман \"Планета обезьян\".","буль");
INSERT INTO chat_vopros VALUES("375","Французский писатель, роман \"Набоб\".","доде");
INSERT INTO chat_vopros VALUES("376","Французский писатель, роман \"Калигула\".","камю");
INSERT INTO chat_vopros VALUES("377","Немецкий писатель, роман \"Будденброки\".","манн");
INSERT INTO chat_vopros VALUES("378","Картофельная крупа.","саго");
INSERT INTO chat_vopros VALUES("379","Столица Перу.","лима");
INSERT INTO chat_vopros VALUES("380","Порт во Франции у слияния рек Рона и Сона.","лион");
INSERT INTO chat_vopros VALUES("381","Река в Прикаспийской низменности.","урал");
INSERT INTO chat_vopros VALUES("382","Марка отечественного автомобиля .","урал");
INSERT INTO chat_vopros VALUES("383","Горная система на границе Европы и Азии.","урал");
INSERT INTO chat_vopros VALUES("384","Русский живописец, картина \"Бородино\".","рубо");
INSERT INTO chat_vopros VALUES("385","Русский художник, панорама \"Бородинская битва\".","рубо");
INSERT INTO chat_vopros VALUES("386","В греческой мифологии супруга спартанского царя Тиндарея.","леда");
INSERT INTO chat_vopros VALUES("387","Спутник Юпитера.","леда");
INSERT INTO chat_vopros VALUES("388","Спутник Сатурна.","феба");
INSERT INTO chat_vopros VALUES("389","Созвездие Южного полушария.","чаша");
INSERT INTO chat_vopros VALUES("390","Округлый сосуд.","чаша");
INSERT INTO chat_vopros VALUES("391","Сделка с немедленной оплатой.","спот");
INSERT INTO chat_vopros VALUES("392","Женское имя (лат. пышная, сноп).","юлия");
INSERT INTO chat_vopros VALUES("393","Тело убитого крупного зверя.","туша");
INSERT INTO chat_vopros VALUES("394","Двухмачтовое судно с прямыми парусами.","бриг");
INSERT INTO chat_vopros VALUES("395","Восковые ячейки пчелиного жилища.","соты");
INSERT INTO chat_vopros VALUES("396","Помещение для мытья с парилкой.","баня");
INSERT INTO chat_vopros VALUES("397","Запряженная ишаком двухколесная повозка.","арба");
INSERT INTO chat_vopros VALUES("398","Чернокожий, негр.","арап");
INSERT INTO chat_vopros VALUES("399","Библейский первый мужчина.","адам");
INSERT INTO chat_vopros VALUES("400","Строительный материал, балка.","брус");
INSERT INTO chat_vopros VALUES("401","Отчаянный высокий вопль.","визг");
INSERT INTO chat_vopros VALUES("402","Способность осуществлять поставленные перед собой цели.","воля");
INSERT INTO chat_vopros VALUES("403","Грузовое помещение на корабле.","трюм");
INSERT INTO chat_vopros VALUES("404","Река в Германии.","рейн");
INSERT INTO chat_vopros VALUES("405","Отец одного из супругов по отношению к родителям другого супруга.","сват");
INSERT INTO chat_vopros VALUES("406","Город и река в Коми.","инта");
INSERT INTO chat_vopros VALUES("407","Женское имя (др. евр. радость).","анна");
INSERT INTO chat_vopros VALUES("408","Легендарный бразильский футболист.","пеле");
INSERT INTO chat_vopros VALUES("409","Ловкий, искусный прием.","трюк");
INSERT INTO chat_vopros VALUES("410","Столица Индии.","дели");
INSERT INTO chat_vopros VALUES("411","Река в Московской области, левый приток Оки.","нара");
INSERT INTO chat_vopros VALUES("412","Первая столица Японии.","нара");
INSERT INTO chat_vopros VALUES("413","Освежающий летний напиток.","квас");
INSERT INTO chat_vopros VALUES("414","Южная птица отряда голенастых.","ибис");
INSERT INTO chat_vopros VALUES("415","В древнегреческой мифологии бог любви.","эрот");
INSERT INTO chat_vopros VALUES("416","Королевский футбольный клуб Испании .","реал");
INSERT INTO chat_vopros VALUES("417","Старинная испанская серебряная монета.","реал");
INSERT INTO chat_vopros VALUES("418","Бывшая столица Германии.","бонн");
INSERT INTO chat_vopros VALUES("419","Спутник Юпитера.","теба");
INSERT INTO chat_vopros VALUES("420","Спутник Юпитера.","фива");
INSERT INTO chat_vopros VALUES("421","Отклонение в сторону повышения рыночной цены золота.","ажио");
INSERT INTO chat_vopros VALUES("422","Деталь затвора огнестрельного оружия.","боек");
INSERT INTO chat_vopros VALUES("423","Островное государство в Центральной Америке.","куба");
INSERT INTO chat_vopros VALUES("424","Курортный город в Грузии.","поти");
INSERT INTO chat_vopros VALUES("425","Город в Германии, в котором родился К. Маркс.","трир");
INSERT INTO chat_vopros VALUES("426","Город в Италии с \"падающей башней\".","пиза");
INSERT INTO chat_vopros VALUES("427","Прежнее название поэта.","пиит");
INSERT INTO chat_vopros VALUES("428","Сибирские валенки.","пимы");
INSERT INTO chat_vopros VALUES("429","Меховые сапоги у северных народов.","пимы");
INSERT INTO chat_vopros VALUES("430","Американский полярный исследователь.","пири");
INSERT INTO chat_vopros VALUES("431","Государство в Западной Азии.","ирак");
INSERT INTO chat_vopros VALUES("432","Государство в Западной Африке.","мали");
INSERT INTO chat_vopros VALUES("433","Государство в Юго-Восточной Азии.","лаос");
INSERT INTO chat_vopros VALUES("434","Государство в Западной Африке.","того");
INSERT INTO chat_vopros VALUES("435","Областной центр в Забайкалье.","чита");
INSERT INTO chat_vopros VALUES("436","Серия советских космических кораблей .","союз");
INSERT INTO chat_vopros VALUES("437","Служебное слово, соединяющее преложения и слова внутри предложения.","союз");
INSERT INTO chat_vopros VALUES("438","Государственное или общественное объединение.","союз");
INSERT INTO chat_vopros VALUES("439","Объединение, союз.","уния");
INSERT INTO chat_vopros VALUES("440","Объединение православной и католической церквей.","уния");
INSERT INTO chat_vopros VALUES("441","Польский парламент.","сейм");
INSERT INTO chat_vopros VALUES("442","Список блюд в ресторане.","меню");
INSERT INTO chat_vopros VALUES("443","Единица измерения.","мера");
INSERT INTO chat_vopros VALUES("444","Старая русская единица емкости сыпучих тел.","мера");
INSERT INTO chat_vopros VALUES("445","Часть чего-либо.","доля");
INSERT INTO chat_vopros VALUES("446","Участь, судьба.","доля");
INSERT INTO chat_vopros VALUES("447","Французский изобретатель телеграфа.","бодо");
INSERT INTO chat_vopros VALUES("448","Итальянский композитор, основатель русского балета, балет \"Конек-Горбунок\".","пуни");
INSERT INTO chat_vopros VALUES("449","Тонкий слой древесины, получаемый лущением.","шпон");
INSERT INTO chat_vopros VALUES("450","Многослойная фанера.","шпон");
INSERT INTO chat_vopros VALUES("451","Гробница для хранения святых мощей.","рака");
INSERT INTO chat_vopros VALUES("452","Первая выгонка вина из барды.","рака");
INSERT INTO chat_vopros VALUES("453","Тонкие волнообразные листы.","гофр");
INSERT INTO chat_vopros VALUES("454","Знакомство и связи, используемые в личных интересах.","блат");
INSERT INTO chat_vopros VALUES("455","Стальная заготовка квадратного сечения.","блюм");
INSERT INTO chat_vopros VALUES("456","Снасть, укрепляемая на концах рея для его поворота.","брас");
INSERT INTO chat_vopros VALUES("457","Минерал для очистки металлов при пайке.","бура");
INSERT INTO chat_vopros VALUES("458","Сложенные в виде вала и укрытые для хранения овощи, корнеплоды.","бурт");
INSERT INTO chat_vopros VALUES("459","Хлопчатобумажная плотная ткань.","бязь");
INSERT INTO chat_vopros VALUES("460","Наполнение легких воздухом.","вдох");
INSERT INTO chat_vopros VALUES("461","Часть теннисной партии.","гейм");
INSERT INTO chat_vopros VALUES("462","Клинообразная дощечка с пазами для покрытия крыши.","гонт");
INSERT INTO chat_vopros VALUES("463","Прорванное или проломанное отверстие.","дыра");
INSERT INTO chat_vopros VALUES("464","Женское имя (греч. вторая).","алла");
INSERT INTO chat_vopros VALUES("465","Псевдоним Н.В.Гоголя.","алов");
INSERT INTO chat_vopros VALUES("466","Марка немецкого автомобиля .","ауди");
INSERT INTO chat_vopros VALUES("467","Марка французского автомобиля .","пежо");
INSERT INTO chat_vopros VALUES("468","Марка американского автомобиля .","додж");
INSERT INTO chat_vopros VALUES("469","Марка шведского автомобиля .","сааб");
INSERT INTO chat_vopros VALUES("470","Марка итальянского автомобиля .","фиат");
INSERT INTO chat_vopros VALUES("471","Марка американского автомобиля .","форд");
INSERT INTO chat_vopros VALUES("472","38-й президент США.","форд");
INSERT INTO chat_vopros VALUES("473","Марка отечественного легкового автомобиля .","лада");
INSERT INTO chat_vopros VALUES("474","Богиня красоты, любви и брака у древних славян.","лада");
INSERT INTO chat_vopros VALUES("475","Отец.","батя");
INSERT INTO chat_vopros VALUES("476","Французский математик, труды по теории алгебраических уравнений.","безу");
INSERT INTO chat_vopros VALUES("477","Герой одесских рассказов Исаака Бабеля.","беня");
INSERT INTO chat_vopros VALUES("478","Столица Швейцарии.","берн");
INSERT INTO chat_vopros VALUES("479","Поперечная балка, соединяющая борта корабля.","бимс");
INSERT INTO chat_vopros VALUES("480","Тонкая лепешка, знаменитое блюдо русской кухни.","блин");
INSERT INTO chat_vopros VALUES("481","Холодный приморский ветер со склонов гор.","бора");
INSERT INTO chat_vopros VALUES("482","Боковая стенка корпуса судна.","борт");
INSERT INTO chat_vopros VALUES("483","Хозяин, начальник, руководитель.","босс");
INSERT INTO chat_vopros VALUES("484","Нидерландский живописец, картина \"Искушение святого Антония\".","босх");
INSERT INTO chat_vopros VALUES("485","Химический элемент, едкая дымящаяся жидкость с неприятным запахом.","бром");
INSERT INTO chat_vopros VALUES("486","Самое сухое шампанское.","брют");
INSERT INTO chat_vopros VALUES("487","Маленький сигнальный плавучий поплавок.","буек");
INSERT INTO chat_vopros VALUES("488","Солдат, боец.","воин");
INSERT INTO chat_vopros VALUES("489","Денежная единица Кореи.","вона");
INSERT INTO chat_vopros VALUES("490","Молочные железы коровы.","вымя");
INSERT INTO chat_vopros VALUES("491","Самое простонародное имя у немцев.","ганс");
INSERT INTO chat_vopros VALUES("492","Дощечки для покрытия крыш.","гарт");
INSERT INTO chat_vopros VALUES("493","Типографский сплав.","гарт");
INSERT INTO chat_vopros VALUES("494","Составитель словаря русского языка.","даль");
INSERT INTO chat_vopros VALUES("495","Английское холодное оружие, короткое метательное копье, дротик.","дарт");
INSERT INTO chat_vopros VALUES("496","Знаток, мастер своего дела.","дока");
INSERT INTO chat_vopros VALUES("497","Лицо женского пола по отношению к своим родителям.","дочь");
INSERT INTO chat_vopros VALUES("498","Порт в Великобритании у пролива Па-де-Кале.","дувр");
INSERT INTO chat_vopros VALUES("499","Вирусная болезнь парнокопытных животных.","ящур");
INSERT INTO chat_vopros VALUES("500","Выдающийся советский вратарь.","яшин");
INSERT INTO chat_vopros VALUES("501","Левый приток Москва-реки.","яуза");



DROP TABLE IF EXISTS `chat_who`;

CREATE TABLE `chat_who` (
  `id_user` int(11) NOT NULL,
  `room` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  KEY `id_user` (`id_user`,`room`,`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO chat_who VALUES("1","0","1487503093");
INSERT INTO chat_who VALUES("2","0","1487500209");



DROP TABLE IF EXISTS `cms_garem`;

CREATE TABLE `cms_garem` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_garem` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO cms_garem VALUES("4","7","1","1487720230");
INSERT INTO cms_garem VALUES("2","1","5","1487577543");



DROP TABLE IF EXISTS `cms_garem_zapret`;

CREATE TABLE `cms_garem_zapret` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `comedy_battle`;

CREATE TABLE `comedy_battle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `time_close` int(11) DEFAULT '0',
  `status` int(11) DEFAULT '0',
  `count_user` int(11) DEFAULT '0',
  `count_protivnik` int(11) DEFAULT '0',
  `id_user` int(11) NOT NULL,
  `id_protivnik` int(11) NOT NULL,
  `text_user` varchar(1024) NOT NULL,
  `text_protivnik` varchar(1024) NOT NULL,
  `win` int(11) DEFAULT NULL,
  `ban` int(1) DEFAULT '0',
  `id_ban` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `comedy_info`;

CREATE TABLE `comedy_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `win` int(11) DEFAULT '0',
  `draw` int(11) DEFAULT '0',
  `lesions` int(11) DEFAULT '0',
  `rating` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `comedy_votes`;

CREATE TABLE `comedy_votes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_battle` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `contests`;

CREATE TABLE `contests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(2000) NOT NULL,
  `name` varchar(32) NOT NULL,
  `ntime` int(11) NOT NULL,
  `ktime` int(11) NOT NULL,
  `pol` set('0','1','2') NOT NULL,
  `type` set('0','1','2') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO contests VALUES("1","1","1487706209","Играем, в конце конкура выведем побидителя.","Фотоконкурс №1","1487706209","1487792609","0","0");
INSERT INTO contests VALUES("2","1","1487706303","Новый конкурс пользователей. инфо после завершения","Конкурс №2","1487792703","1487879103","0","0");



DROP TABLE IF EXISTS `contests_golos`;

CREATE TABLE `contests_golos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_golos` int(11) NOT NULL,
  `id_contest` int(11) NOT NULL,
  `golos` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `contests_users`;

CREATE TABLE `contests_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_contest` int(11) NOT NULL,
  `text` varchar(2000) NOT NULL,
  `time` int(11) NOT NULL,
  `golos` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO contests_users VALUES("1","1","2","","1487706309","0");



DROP TABLE IF EXISTS `covered_page`;

CREATE TABLE `covered_page` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO covered_page VALUES("9","1","1488317062");



DROP TABLE IF EXISTS `cron`;

CREATE TABLE `cron` (
  `id` varchar(32) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO cron VALUES("clear_tmp_dir","1487665304");
INSERT INTO cron VALUES("visit","1487491982");
INSERT INTO cron VALUES("everyday","1487665314");
INSERT INTO cron VALUES("backup_mysql","1487491999");
INSERT INTO cron VALUES("birthday","1487493625");



DROP TABLE IF EXISTS `discussions`;

CREATE TABLE `discussions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `avtor` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `count` int(11) DEFAULT '0',
  `msg` varchar(1024) NOT NULL,
  `time` int(11) NOT NULL,
  `type` varchar(100) NOT NULL,
  `id_sim` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8;

INSERT INTO discussions VALUES("1","2","2","3","","1487598610","them","2");
INSERT INTO discussions VALUES("2","2","1","0","","1487598610","them","2");
INSERT INTO discussions VALUES("3","7","1","0","","1487693023","them","3");
INSERT INTO discussions VALUES("4","7","7","1","","1487693023","them","3");
INSERT INTO discussions VALUES("5","6","1","0","","1487615307","them","4");
INSERT INTO discussions VALUES("6","6","6","7","","1487615307","them","4");
INSERT INTO discussions VALUES("7","1","2","2","","1487596116","status","5");
INSERT INTO discussions VALUES("8","1","3","2","","1487596116","status","5");
INSERT INTO discussions VALUES("9","1","4","2","","1487596116","status","5");
INSERT INTO discussions VALUES("10","1","5","2","","1487596116","status","5");
INSERT INTO discussions VALUES("11","1","6","2","","1487596116","status","5");
INSERT INTO discussions VALUES("12","1","7","0","","1487596116","status","5");
INSERT INTO discussions VALUES("13","1","1","0","","1487596116","status","5");
INSERT INTO discussions VALUES("14","1","2","0","","1487693171","notes","1");
INSERT INTO discussions VALUES("15","1","3","2","","1487693171","notes","1");
INSERT INTO discussions VALUES("16","1","4","2","","1487693171","notes","1");
INSERT INTO discussions VALUES("17","1","5","2","","1487693171","notes","1");
INSERT INTO discussions VALUES("18","1","6","2","","1487693171","notes","1");
INSERT INTO discussions VALUES("19","1","7","2","","1487693171","notes","1");
INSERT INTO discussions VALUES("20","1","8","2","","1487693171","notes","1");
INSERT INTO discussions VALUES("21","1","12","0","","1487693171","notes","1");
INSERT INTO discussions VALUES("22","1","1","0","","1487693171","notes","1");



DROP TABLE IF EXISTS `discussions_set`;

CREATE TABLE `discussions_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `disc_status` int(11) DEFAULT '1',
  `disc_foto` int(11) DEFAULT '1',
  `disc_files` int(11) DEFAULT '1',
  `disc_forum` int(11) DEFAULT '1',
  `disc_notes` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

INSERT INTO discussions_set VALUES("1","1","1","1","1","1","1");
INSERT INTO discussions_set VALUES("2","2","1","1","1","1","1");
INSERT INTO discussions_set VALUES("3","3","1","1","1","1","1");
INSERT INTO discussions_set VALUES("4","4","1","1","1","1","1");
INSERT INTO discussions_set VALUES("5","5","1","1","1","1","1");
INSERT INTO discussions_set VALUES("6","6","1","1","1","1","1");
INSERT INTO discussions_set VALUES("7","7","1","1","1","1","1");
INSERT INTO discussions_set VALUES("8","8","1","1","1","1","1");
INSERT INTO discussions_set VALUES("9","9","1","1","1","1","1");
INSERT INTO discussions_set VALUES("10","10","1","1","1","1","1");
INSERT INTO discussions_set VALUES("11","11","1","1","1","1","1");
INSERT INTO discussions_set VALUES("12","12","1","1","1","1","1");
INSERT INTO discussions_set VALUES("13","13","1","1","1","1","1");
INSERT INTO discussions_set VALUES("14","14","1","1","1","1","1");
INSERT INTO discussions_set VALUES("15","15","1","1","1","1","1");
INSERT INTO discussions_set VALUES("16","16","1","1","1","1","1");
INSERT INTO discussions_set VALUES("17","17","1","1","1","1","1");
INSERT INTO discussions_set VALUES("18","18","1","1","1","1","1");
INSERT INTO discussions_set VALUES("19","19","1","1","1","1","1");
INSERT INTO discussions_set VALUES("20","20","1","1","1","1","1");



DROP TABLE IF EXISTS `duels`;

CREATE TABLE `duels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user1` int(11) DEFAULT NULL,
  `id_user2` int(11) DEFAULT NULL,
  `foto1` varchar(111) NOT NULL,
  `foto2` varchar(111) NOT NULL,
  `golos1` int(11) NOT NULL,
  `golos2` int(11) NOT NULL,
  `active` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO duels VALUES("1","1","2","14874973801.jpg","14874974881.jpg","3","1","1","1487497380");



DROP TABLE IF EXISTS `duels_golos`;

CREATE TABLE `duels_golos` (
  `id_duels` int(11) NOT NULL,
  `user` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO duels_golos VALUES("1","1","9","1487595474");
INSERT INTO duels_golos VALUES("1","1","7","1487595492");
INSERT INTO duels_golos VALUES("1","2","6","1487595578");
INSERT INTO duels_golos VALUES("1","1","8","1487595597");



DROP TABLE IF EXISTS `duels_invite`;

CREATE TABLE `duels_invite` (
  `id_duels` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `user` int(11) NOT NULL,
  `time` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO duels_invite VALUES("1","1","2","1487497433");



DROP TABLE IF EXISTS `duels_settings`;

CREATE TABLE `duels_settings` (
  `golos` int(11) NOT NULL,
  `pobeda` int(11) NOT NULL,
  `pobeda2` int(11) NOT NULL,
  `golosov` int(11) NOT NULL,
  `invite` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO duels_settings VALUES("0","0","0","5","5");



DROP TABLE IF EXISTS `forum_f`;

CREATE TABLE `forum_f` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `pos` int(11) NOT NULL,
  `opis` varchar(512) NOT NULL,
  `adm` set('0','1') NOT NULL DEFAULT '0',
  `icon` varchar(30) DEFAULT 'default',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO forum_f VALUES("1","Новости форума","1","Конкурсы, акции, мероприятия, новости","0","f_news.gif");
INSERT INTO forum_f VALUES("2","Общение и знакомство","2","Общение между пользователями нашего сайта","0","f_obshenie.gif");
INSERT INTO forum_f VALUES("3","Тематические форумы","3","Форумы разбитые по темам","0","f_tematijka.gif");
INSERT INTO forum_f VALUES("4","Секс и отношения","4","Полезные статьи, Любовь, Секс, Вопросы о сексе","0","F_seks.gif");
INSERT INTO forum_f VALUES("5","Досуг и увлечения","5","Отдых, Туризм, Кино, Авто/Мото и др.","0","f_dosug.gif");
INSERT INTO forum_f VALUES("6","Музыка","6","Все что связано с музыкой","0","f_music.gif");
INSERT INTO forum_f VALUES("7","Все о спорте","7","Футбол хоккей и прочее","0","f_sport.gif");
INSERT INTO forum_f VALUES("8","Мобильные телефоны","8","Обсуждение моделей, Покупка, Продажа","0","f_mobil.gif");
INSERT INTO forum_f VALUES("9","Все для телефона","9","Java Symbian Мелодии Картинки","0","f_vse_mobil.gif");
INSERT INTO forum_f VALUES("10","Мобильная связь","10","Все о операторах, WAP; GPRS; EDGE; 3G; Wi-Fi; SMS; MMS","0","svyaz_mob.gif");
INSERT INTO forum_f VALUES("11","Компьютеры","11","Все о компьютерах","0","f_jkomp.gif");
INSERT INTO forum_f VALUES("12","Беспредел","12","No comments...","0","bespredel.gif");



DROP TABLE IF EXISTS `forum_files`;

CREATE TABLE `forum_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_post` int(11) NOT NULL,
  `name` varchar(64) DEFAULT NULL,
  `ras` varchar(32) NOT NULL,
  `size` int(11) NOT NULL,
  `type` varchar(32) NOT NULL,
  `count` int(11) NOT NULL DEFAULT '0',
  `rating` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_post` (`id_post`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `forum_files_rating`;

CREATE TABLE `forum_files_rating` (
  `id_file` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `rating` int(11) DEFAULT '0',
  KEY `id_file` (`id_file`),
  KEY `id_user` (`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `forum_p`;

CREATE TABLE `forum_p` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_forum` int(11) NOT NULL,
  `id_razdel` int(11) NOT NULL,
  `id_them` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  `cit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`),
  KEY `time` (`time`),
  KEY `id_forum` (`id_forum`),
  KEY `id_razdel` (`id_razdel`),
  KEY `id_them` (`id_them`),
  FULLTEXT KEY `msg` (`msg`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;

INSERT INTO forum_p VALUES("1","6","60","2","1","1487496872","Найду и скину Алена =)","");
INSERT INTO forum_p VALUES("2","6","60","2","7","1487594517","Ну ка шас скину)","");
INSERT INTO forum_p VALUES("3","7","55","3","8","1487594750","Рунни постарел и все :D","");
INSERT INTO forum_p VALUES("4","7","55","3","7","1487594999","Дзейтов Мага, Он красавчик","");
INSERT INTO forum_p VALUES("5","7","55","3","8","1487595040","Зуля, Хорошо бьет по мечю) и так хороший игрок","");
INSERT INTO forum_p VALUES("6","5","70","4","6","1487595570","Москва","");
INSERT INTO forum_p VALUES("7","5","70","4","8","1487595611","Liana05, Анапа","");
INSERT INTO forum_p VALUES("8","5","70","4","7","1487595659","Дзейтов Мага, Англия","");
INSERT INTO forum_p VALUES("9","5","70","4","8","1487595683","Зуля, Япония","");
INSERT INTO forum_p VALUES("10","5","70","4","7","1487595699","Дзейтов Мага, Якути","");
INSERT INTO forum_p VALUES("11","5","70","4","8","1487595717","Зуля, Ирладния","");
INSERT INTO forum_p VALUES("12","5","70","4","7","1487595731","Дзейтов Мага, Ирусалим","");
INSERT INTO forum_p VALUES("13","5","70","4","8","1487595757","Зуля, Турция","");
INSERT INTO forum_p VALUES("14","6","60","2","11","1487598452","http://royalgram.ru/user/personalfiles/11/11/?id_file=2&page=1","");
INSERT INTO forum_p VALUES("15","6","60","2","1","1487598610","amfetaminf, пирвет. есть музыка доедишь пиши?","");
INSERT INTO forum_p VALUES("16","5","70","4","7","1487615307","Дзейтов Мага, Якутия","");
INSERT INTO forum_p VALUES("17","7","55","3","2","1487693023","Челси моя любимая команда","");



DROP TABLE IF EXISTS `forum_r`;

CREATE TABLE `forum_r` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_forum` int(11) NOT NULL,
  `name` varchar(32) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_forum` (`id_forum`,`time`)
) ENGINE=MyISAM AUTO_INCREMENT=102 DEFAULT CHARSET=utf8;

INSERT INTO forum_r VALUES("1","15","Архив","1405753625");
INSERT INTO forum_r VALUES("2","15","Корзина","1405753640");
INSERT INTO forum_r VALUES("3","14","Онлайн-помощники","1405753665");
INSERT INTO forum_r VALUES("4","14","Модераторы Чата","1405753675");
INSERT INTO forum_r VALUES("5","14","Модераторы Зоны Обмена","1405753694");
INSERT INTO forum_r VALUES("6","14","Модераторы","1405753706");
INSERT INTO forum_r VALUES("7","14","Администраторы","1405753721");
INSERT INTO forum_r VALUES("8","14","Правила подачи жалобы!","1405753734");
INSERT INTO forum_r VALUES("9","14","Модераторы Форума","1405753753");
INSERT INTO forum_r VALUES("10","12","Юмор без цензуры","1405753786");
INSERT INTO forum_r VALUES("11","12","Общение без цензуры","1405753794");
INSERT INTO forum_r VALUES("12","11","Софт","1405753812");
INSERT INTO forum_r VALUES("13","11","Игры","1405753820");
INSERT INTO forum_r VALUES("14","11","Ноутбуки","1405753827");
INSERT INTO forum_r VALUES("15","11","Железо","1405753835");
INSERT INTO forum_r VALUES("16","11","КПК / Коммуникаторы","1405753851");
INSERT INTO forum_r VALUES("17","11","Обзоры и статьи","1405753860");
INSERT INTO forum_r VALUES("18","11","Программирование","1405753868");
INSERT INTO forum_r VALUES("19","11","Тех.поддержка и ремонт","1405753879");
INSERT INTO forum_r VALUES("20","11","Операционные системы","1405753888");
INSERT INTO forum_r VALUES("21","11","Общее по компьютерам","1405753896");
INSERT INTO forum_r VALUES("22","11","Игровые консоли","1405753906");
INSERT INTO forum_r VALUES("23","10","Общее по Моб.Связи","1405753930");
INSERT INTO forum_r VALUES("24","10","WAP; GPRS; EDGE; 3G; Wi-Fi","1405753938");
INSERT INTO forum_r VALUES("25","10","Операторы Моб.Связи","1405753947");
INSERT INTO forum_r VALUES("26","10","Bluetooth; Irda и т.д.","1405753959");
INSERT INTO forum_r VALUES("27","10","icq ; opera ; e-mail и т.д.","1405753968");
INSERT INTO forum_r VALUES("28","9","Symbian приложения","1405753999");
INSERT INTO forum_r VALUES("29","9","Android игры","1405754006");
INSERT INTO forum_r VALUES("30","9","Symbian игры","1405754014");
INSERT INTO forum_r VALUES("31","9","Java-игры","1405754024");
INSERT INTO forum_r VALUES("32","9","Мелодии","1405754032");
INSERT INTO forum_r VALUES("33","9","Картинки","1405754046");
INSERT INTO forum_r VALUES("34","9","Темы","1405754055");
INSERT INTO forum_r VALUES("35","9","Аксессуары","1405754067");
INSERT INTO forum_r VALUES("36","9","Internet ссылки","1405754078");
INSERT INTO forum_r VALUES("37","9","Видео","1405754085");
INSERT INTO forum_r VALUES("38","9","Android приложения","1405754095");
INSERT INTO forum_r VALUES("39","9","Java-приложения","1405754112");
INSERT INTO forum_r VALUES("40","8","Покупка-продажа","1405754168");
INSERT INTO forum_r VALUES("41","8","SonyEricsson","1405754178");
INSERT INTO forum_r VALUES("42","8","Motorola","1405754188");
INSERT INTO forum_r VALUES("43","8","LG","1405754198");
INSERT INTO forum_r VALUES("44","8","Другие модели","1405754205");
INSERT INTO forum_r VALUES("45","8","Смартфоны","1405754214");
INSERT INTO forum_r VALUES("46","8","Общее по телефонам","1405754222");
INSERT INTO forum_r VALUES("47","8","Samsung","1405754233");
INSERT INTO forum_r VALUES("48","8","Nokia","1405754252");
INSERT INTO forum_r VALUES("49","7","О баскетболе","1405754318");
INSERT INTO forum_r VALUES("50","7","Спорт online","1405754325");
INSERT INTO forum_r VALUES("51","7","О хоккее","1405754334");
INSERT INTO forum_r VALUES("52","7","Остальные виды","1405754343");
INSERT INTO forum_r VALUES("53","7","Спортпрогноз","1405754352");
INSERT INTO forum_r VALUES("54","7","З О Ж","1405754360");
INSERT INTO forum_r VALUES("55","7","О футболе","1487693023");
INSERT INTO forum_r VALUES("56","6","ПОП музыка","1405754386");
INSERT INTO forum_r VALUES("57","6","Rock","1405754394");
INSERT INTO forum_r VALUES("58","6","Metal","1405754402");
INSERT INTO forum_r VALUES("59","6","Шансон","1405754411");
INSERT INTO forum_r VALUES("60","6","Клубная музыка","1487598610");
INSERT INTO forum_r VALUES("61","6","Общее по музыке","1406096708");
INSERT INTO forum_r VALUES("62","6","Rap / Hip-Hop / R`n`B","1405754436");
INSERT INTO forum_r VALUES("63","5","Творчество / Искусство","1405754458");
INSERT INTO forum_r VALUES("64","5","Отдых / Туризм","1405754465");
INSERT INTO forum_r VALUES("65","5","Охота / Рыбалка","1405754475");
INSERT INTO forum_r VALUES("66","5","Домашние животные / Растения","1405754489");
INSERT INTO forum_r VALUES("67","5","Лирика / Проза","1405754497");
INSERT INTO forum_r VALUES("68","5","Авто / Мото","1405754507");
INSERT INTO forum_r VALUES("69","5","Кулинария","1405754515");
INSERT INTO forum_r VALUES("70","5","Прочие увлечения","1487615307");
INSERT INTO forum_r VALUES("71","5","Кино / Сериалы / Видео / ТВ","1405754533");
INSERT INTO forum_r VALUES("72","4","Контрацептивы / Венерология","1405754553");
INSERT INTO forum_r VALUES("73","4","Виды / Позы /Секс","1405754566");
INSERT INTO forum_r VALUES("74","4","Полезные статьи о сексе","1405754574");
INSERT INTO forum_r VALUES("75","4","Семейные отношения и Дети","1405754583");
INSERT INTO forum_r VALUES("76","4","Любовь и взаимоотношения","1405754593");
INSERT INTO forum_r VALUES("77","4","Проблемы и Вопросы","1405754603");
INSERT INTO forum_r VALUES("78","3","Религии стран Мира","1405754625");
INSERT INTO forum_r VALUES("79","3","Наука / Культура","1405754637");
INSERT INTO forum_r VALUES("80","3","Работа / Образование","1405754644");
INSERT INTO forum_r VALUES("81","3","История","1405754653");
INSERT INTO forum_r VALUES("82","3","Цифровая / Бытовая техника","1405754663");
INSERT INTO forum_r VALUES("83","3","Политика / Общество","1405754673");
INSERT INTO forum_r VALUES("84","3","Красота, косметика, уход","1405754683");
INSERT INTO forum_r VALUES("85","3","Непознанный мир","1406056283");
INSERT INTO forum_r VALUES("86","3","Литературный клуб","1405754700");
INSERT INTO forum_r VALUES("87","3","Медицина / Здоровье","1405754710");
INSERT INTO forum_r VALUES("88","2","Праздники, торжества и т.д.","1405754775");
INSERT INTO forum_r VALUES("89","2","Юмор","1405754784");
INSERT INTO forum_r VALUES("90","2","Болтология","1405754792");
INSERT INTO forum_r VALUES("91","2","Города и Страны","1405754801");
INSERT INTO forum_r VALUES("92","2","Знакомства","1406183145");
INSERT INTO forum_r VALUES("93","2","Игры on-line","1406192448");
INSERT INTO forum_r VALUES("94","13","Правила","1405754836");
INSERT INTO forum_r VALUES("95","13","Вопросы по разделам","1405754854");
INSERT INTO forum_r VALUES("96","13","Помощь новичкам","1405754864");
INSERT INTO forum_r VALUES("97","13","Ответы на вопросы","1405754872");
INSERT INTO forum_r VALUES("98","13","Тех. Поддержка","1405754879");
INSERT INTO forum_r VALUES("99","13","Общие вопросы","1406055672");
INSERT INTO forum_r VALUES("100","13","Вопросы и пожелания","1405754898");
INSERT INTO forum_r VALUES("101","1","Новости и события","1406097814");



DROP TABLE IF EXISTS `forum_t`;

CREATE TABLE `forum_t` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_forum` int(11) NOT NULL,
  `id_razdel` int(11) DEFAULT NULL,
  `name` varchar(32) NOT NULL,
  `id_user` int(11) DEFAULT NULL,
  `time_create` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `up` set('0','1') NOT NULL DEFAULT '0',
  `close` set('0','1') NOT NULL DEFAULT '0',
  `text` varchar(2000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_forum` (`id_forum`,`id_razdel`),
  FULLTEXT KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO forum_t VALUES("2","6","60","Эндшпиль музыка","2","1487598610","1487496533","0","0","Есть у кого музыка Эндшпиля - малиновый расвет?");
INSERT INTO forum_t VALUES("3","7","55","Манчестер Юнайтед","7","1487693023","1487594585","0","0","Инфо и обсуждения команды) вам она нравиться?");
INSERT INTO forum_t VALUES("4","5","70","Игра городок","6","1487615307","1487595562","0","0","Вот смотрите играем в игру городок, я пишу имя города а вы затем пишите с последней буквы имена других город. поехали?");



DROP TABLE IF EXISTS `forum_zakl`;

CREATE TABLE `forum_zakl` (
  `id_user` int(11) NOT NULL,
  `id_them` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `time_obn` int(11) NOT NULL,
  KEY `id_user` (`id_user`,`id_them`,`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `fotokr`;

CREATE TABLE `fotokr` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(25) NOT NULL,
  `msg` varchar(5000) NOT NULL,
  `ot` int(11) NOT NULL,
  `do` int(11) NOT NULL,
  `pob1` int(11) NOT NULL,
  `pob2` int(11) NOT NULL,
  `pob3` int(11) NOT NULL,
  `others` int(11) NOT NULL,
  `votes` int(1) NOT NULL,
  `time` int(11) DEFAULT NULL,
  `who` int(1) DEFAULT '2',
  `end` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO fotokr VALUES("1","Конкурс №1","Конкурс кто красивее. время длительности фотоконкураса 2 днея.","1487696346","1487869146","300","200","100","0","0","1487696346","2","0");



DROP TABLE IF EXISTS `fotokr_komm`;

CREATE TABLE `fotokr_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_foto` int(11) NOT NULL,
  `id_u` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  `otv` int(11) NOT NULL DEFAULT '0',
  `id_kon` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_foto` (`id_foto`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `fotokr_lider`;

CREATE TABLE `fotokr_lider` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_u` int(11) NOT NULL,
  `id_kon` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_kon` (`id_kon`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `fotokr_rating`;

CREATE TABLE `fotokr_rating` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_u` int(11) NOT NULL,
  `id_foto` int(11) NOT NULL,
  `rating` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_foto` (`id_foto`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `fotokr_users`;

CREATE TABLE `fotokr_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_kon` int(11) NOT NULL,
  `id_u` int(11) DEFAULT NULL,
  `rating` int(11) NOT NULL DEFAULT '0',
  `id_foto` varchar(50) NOT NULL,
  `name_foto` varchar(50) NOT NULL,
  `block` int(1) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_kon` (`id_kon`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO fotokr_users VALUES("1","1","1","0","1_1_90","Лучший из лучших","0","1487696454");
INSERT INTO fotokr_users VALUES("2","1","6","0","1_6_25","А я худенькая)","0","1487696950");



DROP TABLE IF EXISTS `fotokr_users_a`;

CREATE TABLE `fotokr_users_a` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_kon` int(11) NOT NULL,
  `id_u` int(11) DEFAULT NULL,
  `id_foto` varchar(50) NOT NULL,
  `name_foto` varchar(50) NOT NULL,
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_kon` (`id_kon`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `frends`;

CREATE TABLE `frends` (
  `user` int(11) NOT NULL DEFAULT '0',
  `frend` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `i` int(1) DEFAULT '0',
  `lenta_forum` int(11) NOT NULL DEFAULT '1',
  `lenta_obmen` int(11) NOT NULL DEFAULT '1',
  `lenta_foto` int(11) NOT NULL DEFAULT '1',
  `lenta_notes` int(11) NOT NULL DEFAULT '1',
  `lenta_avatar` int(11) DEFAULT '1',
  `lenta_frends` int(1) DEFAULT '1',
  `lenta_status` int(1) DEFAULT '1',
  `lenta_status_like` int(1) DEFAULT '1',
  `disc_forum` int(11) NOT NULL DEFAULT '1',
  `disc_obmen` int(11) NOT NULL DEFAULT '1',
  `disc_foto` int(11) NOT NULL DEFAULT '1',
  `disc_notes` int(11) NOT NULL DEFAULT '1',
  `disc_frends` int(1) DEFAULT '1',
  `disc_status` int(1) DEFAULT '1',
  PRIMARY KEY (`user`,`frend`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO frends VALUES("1","2","1487504866","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("2","1","1487504866","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","3","1487506427","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("3","1","1487506427","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","4","1487572540","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("4","1","1487572540","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","6","1487577311","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("6","1","1487577311","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","5","1487577312","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("5","1","1487577312","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("7","1","1487594225","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","7","1487594225","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","8","1487596187","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("8","1","1487596187","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("12","1","1487691796","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","12","1487691796","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");



DROP TABLE IF EXISTS `frends_new`;

CREATE TABLE `frends_new` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `to` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO frends_new VALUES("11","1","17","1487719836");



DROP TABLE IF EXISTS `gallery`;

CREATE TABLE `gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `name` varchar(32) NOT NULL,
  `time_create` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `opis` varchar(256) NOT NULL,
  `pass` varchar(11) DEFAULT NULL,
  `privat` int(11) NOT NULL,
  `privat_komm` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

INSERT INTO gallery VALUES("1","1","JLada Gred","1487494187","1487494187","","","0","0");
INSERT INTO gallery VALUES("2","2","DJ Alena","1487496357","1487496357","","","0","0");
INSERT INTO gallery VALUES("3","3","KAT_IN_177","1487519516","1487519516","","","0","0");
INSERT INTO gallery VALUES("4","4","BMW M5","1487571979","1487571979","","","0","0");
INSERT INTO gallery VALUES("5","5","Vaka","1487576720","1487576720","","","0","0");
INSERT INTO gallery VALUES("6","6","Мусульманка","1487577166","1487577166","","","0","0");
INSERT INTO gallery VALUES("7","7","Lolove","1487593000","1487593000","","","0","0");
INSERT INTO gallery VALUES("8","8","Kaвказский центр","1487594823","1487594823","","","0","0");
INSERT INTO gallery VALUES("9","9","Чеченский поворот","1487595247","1487595247","","","0","0");
INSERT INTO gallery VALUES("10","9","Зуднаш","1487595325","1487595325","","","0","0");
INSERT INTO gallery VALUES("11","10","ХхХ фото только 18","1487596591","1487596591","","","0","0");
INSERT INTO gallery VALUES("12","12","marsel","1487689875","1487689875","яяяя","","0","0");
INSERT INTO gallery VALUES("13","17","jhgf","1487719118","1487719118","","","0","0");
INSERT INTO gallery VALUES("14","18","MAHA4KALA","1487736496","1487736496","","","0","0");



DROP TABLE IF EXISTS `gallery_foto`;

CREATE TABLE `gallery_foto` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_gallery` int(11) NOT NULL,
  `name` varchar(64) NOT NULL,
  `ras` varchar(4) NOT NULL,
  `type` varchar(64) NOT NULL,
  `opis` varchar(1024) NOT NULL,
  `effects` text,
  `rating` int(11) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL,
  `avatar` enum('0','1') DEFAULT '0',
  `pass` varchar(11) DEFAULT NULL,
  `people` int(11) DEFAULT NULL,
  `time` int(11) NOT NULL,
  `metka` int(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_gallery` (`id_gallery`)
) ENGINE=MyISAM AUTO_INCREMENT=58 DEFAULT CHARSET=utf8;

INSERT INTO gallery_foto VALUES("1","1","3BEB4yHIavo","jpg","image/jpeg","","","0","1","0","","","1487494218","0");
INSERT INTO gallery_foto VALUES("2","1","B4OmoR_NJYo","jpg","image/jpeg","","","0","1","0","","","1487494239","0");
INSERT INTO gallery_foto VALUES("3","1","bpHZwbqboy8","jpg","image/jpeg","","","3","1","0","","","1487494253","0");
INSERT INTO gallery_foto VALUES("4","2","0b6pV2O0MRE","jpg","image/jpeg","","","5","2","0","","","1487496376","0");
INSERT INTO gallery_foto VALUES("5","2","1HJcJO_lIVo","jpg","image/jpeg","","","5","2","0","","","1487496386","0");
INSERT INTO gallery_foto VALUES("6","2","2wn32q3FYYY","jpg","image/jpeg","","","5","2","0","","","1487496398","0");
INSERT INTO gallery_foto VALUES("7","2","5Bx1t0wDwjw","jpg","image/jpeg","","","5","2","0","","","1487496419","0");
INSERT INTO gallery_foto VALUES("8","2","8JqQbXfRbok","jpg","image/jpeg","","","5","2","0","","","1487496428","0");
INSERT INTO gallery_foto VALUES("9","2","8ezmoL4OZxY","jpg","image/jpeg","","","5","2","0","","","1487496439","0");
INSERT INTO gallery_foto VALUES("10","2","8u7PjTQhwy4","jpg","image/jpeg","","","5","2","1","","","1487496449","0");
INSERT INTO gallery_foto VALUES("11","3","9UQrFnsqB2E","jpg","image/jpeg","","","5","3","0","","","1487519537","0");
INSERT INTO gallery_foto VALUES("12","3","3-pLQv4NLuM","jpg","image/jpeg","","","5","3","1","","","1487519545","0");
INSERT INTO gallery_foto VALUES("13","3","F3UAx1DrHeo","jpg","image/jpeg","","","5","3","0","","","1487519566","0");
INSERT INTO gallery_foto VALUES("14","4","104","jpg","image/jpeg","","","0","4","1","","","1487571997","0");
INSERT INTO gallery_foto VALUES("15","5","douZSvwWclY","jpg","image/jpeg","","","0","5","0","","","1487576738","0");
INSERT INTO gallery_foto VALUES("16","5","55oaJ8W2H7Q","jpg","image/jpeg","","","0","5","0","","","1487576749","0");
INSERT INTO gallery_foto VALUES("17","5","65Pr3eUIOAc","jpg","image/jpeg","","","0","5","0","","","1487576759","0");
INSERT INTO gallery_foto VALUES("18","5","rJFDz699e-I","jpg","image/jpeg","","","0","5","1","","","1487576773","0");
INSERT INTO gallery_foto VALUES("19","6","nnz3_xKjv0w","jpg","image/jpeg","","","5","6","1","","","1487577198","0");
INSERT INTO gallery_foto VALUES("20","1","6SVK_a4nSSI","jpg","image/jpeg","","","0","1","0","","","1487577857","0");
INSERT INTO gallery_foto VALUES("21","1","cXSoESgV9Pc","jpg","image/jpeg","","","0","1","0","","","1487577868","0");
INSERT INTO gallery_foto VALUES("22","1","UMABRFWjWyQ","jpg","image/jpeg","","","0","1","0","","","1487577880","0");
INSERT INTO gallery_foto VALUES("23","1","y1BTrdYFSUI","jpg","image/jpeg","","","0","1","0","","","1487577921","0");
INSERT INTO gallery_foto VALUES("24","1","rXpjek6ZTvI","jpg","image/jpeg","","","0","1","1","","","1487577954","0");
INSERT INTO gallery_foto VALUES("25","7","Q5PtoGXGPAs","jpg","image/jpeg","","","0","7","1","","","1487593018","0");
INSERT INTO gallery_foto VALUES("26","7","NZn-xdlRAn8","jpg","image/jpeg","","","0","7","0","","","1487593034","0");
INSERT INTO gallery_foto VALUES("27","7","TFN8osaQNAA","jpg","image/jpeg","","","0","7","0","","","1487593045","0");
INSERT INTO gallery_foto VALUES("28","8","tltpRSD22Yc","jpg","image/jpeg","","","0","8","0","","","1487594841","0");
INSERT INTO gallery_foto VALUES("29","8","1DAY5Ybjzgk","jpg","image/jpeg","","","0","8","0","","","1487594850","0");
INSERT INTO gallery_foto VALUES("30","8","6iP0R5kPdok","jpg","image/jpeg","","","0","8","0","","","1487594860","0");
INSERT INTO gallery_foto VALUES("31","8","4RHRrEa3fkA","jpg","image/jpeg","","","0","8","0","","","1487594871","0");
INSERT INTO gallery_foto VALUES("32","8","1wO6uAttmgY","jpg","image/jpeg","","","0","8","0","","","1487594880","0");
INSERT INTO gallery_foto VALUES("33","8","NZ3gaWjqlH4","jpg","image/jpeg","","","0","8","0","","","1487594895","0");
INSERT INTO gallery_foto VALUES("34","8","s1CldZ77dA0","jpg","image/jpeg","","","0","8","1","","","1487594916","0");
INSERT INTO gallery_foto VALUES("35","9","u9RnIfB1PK0","jpg","image/jpeg","","","0","9","0","","","1487595260","0");
INSERT INTO gallery_foto VALUES("36","9","4TbhzDZmgcQ","jpg","image/jpeg","","","0","9","0","","","1487595277","0");
INSERT INTO gallery_foto VALUES("37","9","_uK8zFDizRE","jpg","image/jpeg","","","0","9","0","","","1487595285","0");
INSERT INTO gallery_foto VALUES("38","9","rKEDHkwH2Fs","jpg","image/jpeg","","","0","9","0","","","1487595293","0");
INSERT INTO gallery_foto VALUES("39","9","mFZJ3AJorRE","jpg","image/jpeg","","","0","9","1","","","1487595306","0");
INSERT INTO gallery_foto VALUES("40","10","nwsXfGomuK8","jpg","image/jpeg","","","0","9","0","","","1487595337","0");
INSERT INTO gallery_foto VALUES("41","10","OFVOMu-sOgU","jpg","image/jpeg","","","0","9","0","","","1487595354","0");
INSERT INTO gallery_foto VALUES("42","10","aeuWrlKL_XU","jpg","image/jpeg","","","0","9","0","","","1487595362","0");
INSERT INTO gallery_foto VALUES("43","10","JHPcdrn7TcQ","jpg","image/jpeg","","","0","9","0","","","1487595371","0");
INSERT INTO gallery_foto VALUES("44","10","0jg-9x0-BvM","jpg","image/jpeg","","","0","9","0","","","1487595379","0");
INSERT INTO gallery_foto VALUES("45","10","mrPdxak0Sgw","jpg","image/jpeg","","","10","9","0","","","1487595391","0");
INSERT INTO gallery_foto VALUES("46","10","iFHz0HYVf9k","jpg","image/jpeg","","","5","9","0","","","1487595400","0");
INSERT INTO gallery_foto VALUES("47","10","gX_Rzbf__8w","jpg","image/jpeg","","","5","9","0","","","1487595409","0");
INSERT INTO gallery_foto VALUES("48","10","p9gGGkAjlIo","jpg","image/jpeg","","","5","9","0","","","1487595418","0");
INSERT INTO gallery_foto VALUES("49","10","FmrahBq4Ryo","jpg","image/jpeg","","","0","9","0","","","1487595429","0");
INSERT INTO gallery_foto VALUES("50","11","4cr8EEY2mzg","jpg","image/jpeg","","","0","10","0","","","1487596603","0");
INSERT INTO gallery_foto VALUES("51","11","l_6dz3pndjs","jpg","image/jpeg","","","0","10","1","","","1487596614","0");
INSERT INTO gallery_foto VALUES("52","11","pBDwLgnlEDk","jpg","image/jpeg","","","5","10","0","","","1487596626","0");
INSERT INTO gallery_foto VALUES("53","11","ly6hTYwApA0","jpg","image/jpeg","","","0","10","0","","","1487596642","0");
INSERT INTO gallery_foto VALUES("54","12","Картинка","jpg","image/jpeg","Гггггг","","5","12","1","","","1487689911","0");
INSERT INTO gallery_foto VALUES("55","13","ghfj","jpg","image/jpeg","Hghf","","0","17","0","","","1487719183","0");
INSERT INTO gallery_foto VALUES("56","13","ghfj","jpg","image/jpeg","Hghf","","5","17","0","","","1487719256","0");
INSERT INTO gallery_foto VALUES("57","14","79410_150","jpg","image/jpeg","","","0","18","1","","","1487736517","0");



DROP TABLE IF EXISTS `gallery_komm`;

CREATE TABLE `gallery_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_foto` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_foto` (`id_foto`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gallery_rating`;

CREATE TABLE `gallery_rating` (
  `id_foto` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `like` int(11) NOT NULL DEFAULT '0',
  `avtor` int(11) NOT NULL DEFAULT '0',
  `ready` int(11) NOT NULL DEFAULT '1',
  `time` int(11) NOT NULL DEFAULT '0',
  `read` int(1) DEFAULT '1',
  KEY `id_foto` (`id_foto`,`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO gallery_rating VALUES("10","1","6","2","1","1487534438","1");
INSERT INTO gallery_rating VALUES("9","1","6","2","1","1487534442","1");
INSERT INTO gallery_rating VALUES("8","1","6","2","1","1487534447","1");
INSERT INTO gallery_rating VALUES("7","1","6","2","1","1487534451","1");
INSERT INTO gallery_rating VALUES("6","1","6","2","1","1487534456","1");
INSERT INTO gallery_rating VALUES("5","1","6","2","1","1487534460","1");
INSERT INTO gallery_rating VALUES("4","1","6","2","1","1487534464","1");
INSERT INTO gallery_rating VALUES("12","1","6","3","1","1487534477","1");
INSERT INTO gallery_rating VALUES("11","1","6","3","1","1487534481","1");
INSERT INTO gallery_rating VALUES("13","1","6","3","1","1487534489","1");
INSERT INTO gallery_rating VALUES("3","6","5","1","1","1487577208","1");
INSERT INTO gallery_rating VALUES("19","1","6","6","1","1487578907","1");
INSERT INTO gallery_rating VALUES("48","1","6","9","1","1487596374","1");
INSERT INTO gallery_rating VALUES("47","1","6","9","1","1487596378","1");
INSERT INTO gallery_rating VALUES("46","1","6","9","1","1487596382","1");
INSERT INTO gallery_rating VALUES("45","1","6","9","1","1487596386","1");
INSERT INTO gallery_rating VALUES("52","7","6","10","1","1487615318","1");
INSERT INTO gallery_rating VALUES("54","1","6","12","1","1487693914","0");
INSERT INTO gallery_rating VALUES("45","6","6","9","1","1487712545","1");
INSERT INTO gallery_rating VALUES("56","1","6","17","1","1487719826","1");



DROP TABLE IF EXISTS `gift_categories`;

CREATE TABLE `gift_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=cp1251;

INSERT INTO gift_categories VALUES("16","Зверушки");
INSERT INTO gift_categories VALUES("15","50 монет");
INSERT INTO gift_categories VALUES("14","30 монет");
INSERT INTO gift_categories VALUES("13","10 монет");
INSERT INTO gift_categories VALUES("17","9 Мая");



DROP TABLE IF EXISTS `gift_list`;

CREATE TABLE `gift_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_category` int(11) NOT NULL,
  `name` varchar(128) NOT NULL,
  `money` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=315 DEFAULT CHARSET=cp1251;

INSERT INTO gift_list VALUES("291","16","Волчонок","10");
INSERT INTO gift_list VALUES("290","16","Заяц","10");
INSERT INTO gift_list VALUES("289","16","Ёжик","10");
INSERT INTO gift_list VALUES("288","16","Жираф","10");
INSERT INTO gift_list VALUES("287","16","Бегемот","10");
INSERT INTO gift_list VALUES("286","16","Лев","10");
INSERT INTO gift_list VALUES("285","16","Зебра","10");
INSERT INTO gift_list VALUES("284","16","Кот и Рыбка","10");
INSERT INTO gift_list VALUES("283","16","Орёл","10");
INSERT INTO gift_list VALUES("282","16","Скунс","10");
INSERT INTO gift_list VALUES("210","13","Соска","10");
INSERT INTO gift_list VALUES("211","13","Привидение","10");
INSERT INTO gift_list VALUES("212","13","Кофе","10");
INSERT INTO gift_list VALUES("213","13","Будильник","10");
INSERT INTO gift_list VALUES("214","13","Конфеты","10");
INSERT INTO gift_list VALUES("215","13","Cкалка","10");
INSERT INTO gift_list VALUES("216","13","Катана","10");
INSERT INTO gift_list VALUES("217","13","Пулемёт","10");
INSERT INTO gift_list VALUES("218","13","Мяч","10");
INSERT INTO gift_list VALUES("219","13","Перчатки","10");
INSERT INTO gift_list VALUES("220","13","Медаль","10");
INSERT INTO gift_list VALUES("221","13","Копилка Полная Монет","10");
INSERT INTO gift_list VALUES("222","13","Красные Труселя","10");
INSERT INTO gift_list VALUES("223","13","Ёлка","10");
INSERT INTO gift_list VALUES("224","13","Дед Мороз","10");
INSERT INTO gift_list VALUES("225","13","Снегурочка","10");
INSERT INTO gift_list VALUES("226","13","Букет Ромашек","10");
INSERT INTO gift_list VALUES("227","13","Духи","10");
INSERT INTO gift_list VALUES("228","13","Бонсай","10");
INSERT INTO gift_list VALUES("229","13","Крылья","10");
INSERT INTO gift_list VALUES("230","13","Чертенок","10");
INSERT INTO gift_list VALUES("231","13","Коктейль","10");
INSERT INTO gift_list VALUES("232","13","Электрогитара","10");
INSERT INTO gift_list VALUES("233","13","Мандарины","10");
INSERT INTO gift_list VALUES("234","13","Снеговик","10");
INSERT INTO gift_list VALUES("235","13","Снежинка","10");
INSERT INTO gift_list VALUES("236","13","Мешок с Подарками","10");
INSERT INTO gift_list VALUES("237","13","Новогодняя Шапка","10");
INSERT INTO gift_list VALUES("238","13","Морковка","10");
INSERT INTO gift_list VALUES("239","13","Карамелька","10");
INSERT INTO gift_list VALUES("240","13","Плюшевый Мишка","10");
INSERT INTO gift_list VALUES("241","13","Поцелуй","10");
INSERT INTO gift_list VALUES("242","13","Гвоздика","10");
INSERT INTO gift_list VALUES("243","13","Щит и Меч","10");
INSERT INTO gift_list VALUES("244","13","Завтрак","10");
INSERT INTO gift_list VALUES("245","13","Мимоза","10");
INSERT INTO gift_list VALUES("246","13","Леденец","10");
INSERT INTO gift_list VALUES("247","13","Дракон","10");
INSERT INTO gift_list VALUES("248","13","Подарки","10");
INSERT INTO gift_list VALUES("249","13","Мишка Тедди","10");
INSERT INTO gift_list VALUES("250","14","Хаммер","30");
INSERT INTO gift_list VALUES("251","14","Дорогие Часы","30");
INSERT INTO gift_list VALUES("252","14","Мотоцикл","30");
INSERT INTO gift_list VALUES("253","14","Обручальные Кольца","30");
INSERT INTO gift_list VALUES("254","14","Свадебный Торт","30");
INSERT INTO gift_list VALUES("255","14","Млн.Долларов США","30");
INSERT INTO gift_list VALUES("256","14","Колье с Изумрудом","30");
INSERT INTO gift_list VALUES("257","14","Танк","30");
INSERT INTO gift_list VALUES("258","14","Машина","30");
INSERT INTO gift_list VALUES("259","14","Брошь Изумрудная","30");
INSERT INTO gift_list VALUES("260","14","Жемчужина","30");
INSERT INTO gift_list VALUES("261","14","Статуэтка Будды","30");
INSERT INTO gift_list VALUES("262","14","Сердце","30");
INSERT INTO gift_list VALUES("263","14","Самолет","30");
INSERT INTO gift_list VALUES("264","14","Диадема","30");
INSERT INTO gift_list VALUES("265","15","Сердце","50");
INSERT INTO gift_list VALUES("266","15","Золотая Рыбка","50");
INSERT INTO gift_list VALUES("267","15","Кольцо с Бриллиантом","50");
INSERT INTO gift_list VALUES("268","15","Шикарная Яхта","50");
INSERT INTO gift_list VALUES("269","15","Трон","50");
INSERT INTO gift_list VALUES("270","15","Корона","50");
INSERT INTO gift_list VALUES("271","15","Крупный Бриллиант","50");
INSERT INTO gift_list VALUES("272","15","Замок в Облаках","50");
INSERT INTO gift_list VALUES("273","16","Олень","10");
INSERT INTO gift_list VALUES("274","16","Котёнок","10");
INSERT INTO gift_list VALUES("275","16","Щенок","10");
INSERT INTO gift_list VALUES("276","16","Лисёнок","10");
INSERT INTO gift_list VALUES("277","16","Енот","10");
INSERT INTO gift_list VALUES("278","16","Тигрёнок","10");
INSERT INTO gift_list VALUES("279","16","Кролик","10");
INSERT INTO gift_list VALUES("280","16","Бобр","10");
INSERT INTO gift_list VALUES("281","16","Хомяк","10");
INSERT INTO gift_list VALUES("209","13","Тыква","10");
INSERT INTO gift_list VALUES("208","13","Ноутбук","10");
INSERT INTO gift_list VALUES("207","13","Кусочек Торта","10");
INSERT INTO gift_list VALUES("206","13","Красные Туфельки","10");
INSERT INTO gift_list VALUES("205","13","Сладкая она","10");
INSERT INTO gift_list VALUES("204","13","Сладкий он","10");
INSERT INTO gift_list VALUES("203","13","Бита","10");
INSERT INTO gift_list VALUES("202","13","Мишки","10");
INSERT INTO gift_list VALUES("201","13","Шампанское","10");
INSERT INTO gift_list VALUES("200","13","Пиво","10");
INSERT INTO gift_list VALUES("199","13","Букет","10");
INSERT INTO gift_list VALUES("198","13","Торт","10");
INSERT INTO gift_list VALUES("197","13","Роза","10");
INSERT INTO gift_list VALUES("196","13","Довольная Белка","10");
INSERT INTO gift_list VALUES("195","13","Змея 2013","10");
INSERT INTO gift_list VALUES("194","13","Щелкунчик","10");
INSERT INTO gift_list VALUES("193","13","Зеленый Эльф","10");
INSERT INTO gift_list VALUES("192","13","Волшебный Шар","10");
INSERT INTO gift_list VALUES("191","13","Новогодний Хомяк","10");
INSERT INTO gift_list VALUES("190","13","Ёлочная игрушка","10");
INSERT INTO gift_list VALUES("189","13","Лошадь 2014","10");
INSERT INTO gift_list VALUES("292","16","Пингвин","10");
INSERT INTO gift_list VALUES("293","16","Медвежонок","10");
INSERT INTO gift_list VALUES("294","17","Ленточка","10");
INSERT INTO gift_list VALUES("295","17","Автомат","10");
INSERT INTO gift_list VALUES("296","17","Граната","10");
INSERT INTO gift_list VALUES("297","17","Каска","10");
INSERT INTO gift_list VALUES("298","17","Гвоздика","10");
INSERT INTO gift_list VALUES("299","17","Пулемёт","10");
INSERT INTO gift_list VALUES("301","17","Бескозырка","10");
INSERT INTO gift_list VALUES("302","17","Шапка ушанка","10");
INSERT INTO gift_list VALUES("303","13","Перископ","10");
INSERT INTO gift_list VALUES("304","13","Хризантемы","10");
INSERT INTO gift_list VALUES("305","13","Купидон","10");
INSERT INTO gift_list VALUES("306","13","Пасхальное яйцо красное","10");
INSERT INTO gift_list VALUES("307","13","Пасхально яйцо зеленое","10");
INSERT INTO gift_list VALUES("308","13","Пасхальное яйцо синее","10");
INSERT INTO gift_list VALUES("309","13","Розы","10");
INSERT INTO gift_list VALUES("310","13","Хрустальная туфелька","10");
INSERT INTO gift_list VALUES("311","13","Клубничка","10");
INSERT INTO gift_list VALUES("312","13","Тюльпаны","10");
INSERT INTO gift_list VALUES("313","14","Изумруд","30");
INSERT INTO gift_list VALUES("314","15","Сундук сокровищ","50");



DROP TABLE IF EXISTS `gifts_free`;

CREATE TABLE `gifts_free` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `type` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO gifts_free VALUES("1","5","1487577066","Джин подарила Бесплатный подарок");
INSERT INTO gifts_free VALUES("2","7","1487593216","Джин дал +500 баллов");
INSERT INTO gifts_free VALUES("3","12","1487690042","Джин подарил Бесплатный подарок");



DROP TABLE IF EXISTS `gifts_user`;

CREATE TABLE `gifts_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_ank` int(11) NOT NULL,
  `id_gift` int(11) NOT NULL,
  `anonim` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `coment` varchar(150) NOT NULL,
  `status` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=cp1251;

INSERT INTO gifts_user VALUES("1","2","1","189","0","1487521203","","1");
INSERT INTO gifts_user VALUES("2","1","5","1","0","1487577066","Подарок от Джина","0");
INSERT INTO gifts_user VALUES("3","6","1","265","0","1487577429","","1");
INSERT INTO gifts_user VALUES("4","6","1","270","0","1487577440","","1");
INSERT INTO gifts_user VALUES("5","5","1","256","0","1487577470","","1");
INSERT INTO gifts_user VALUES("6","1","5","269","0","1487577574","","0");
INSERT INTO gifts_user VALUES("7","1","5","314","0","1487577584","","0");
INSERT INTO gifts_user VALUES("8","1","5","250","0","1487577594","","0");
INSERT INTO gifts_user VALUES("9","2","6","298","0","1487577663","","0");
INSERT INTO gifts_user VALUES("10","1","6","278","0","1487577708","","1");
INSERT INTO gifts_user VALUES("11","1","6","271","0","1487577717","","1");
INSERT INTO gifts_user VALUES("12","1","6","214","0","1487577727","","1");
INSERT INTO gifts_user VALUES("13","1","6","225","0","1487577734","","1");
INSERT INTO gifts_user VALUES("14","1","6","304","0","1487577745","","1");
INSERT INTO gifts_user VALUES("15","4","1","271","0","1487584005","","1");
INSERT INTO gifts_user VALUES("16","4","1","272","0","1487584016","","1");
INSERT INTO gifts_user VALUES("17","4","1","314","0","1487584019","","1");
INSERT INTO gifts_user VALUES("18","7","1","256","0","1487594193","","1");
INSERT INTO gifts_user VALUES("19","7","1","260","0","1487594201","","1");
INSERT INTO gifts_user VALUES("20","7","1","262","0","1487594205","","1");
INSERT INTO gifts_user VALUES("21","1","7","313","0","1487594292","","1");
INSERT INTO gifts_user VALUES("22","1","12","1","0","1487690042","Подарок от Джина","0");
INSERT INTO gifts_user VALUES("23","12","1","312","0","1487690487","","1");
INSERT INTO gifts_user VALUES("24","14","1","193","0","1487709419","","1");
INSERT INTO gifts_user VALUES("25","16","1","265","0","1487718217","","1");
INSERT INTO gifts_user VALUES("26","17","1","270","0","1487719853","","1");



DROP TABLE IF EXISTS `groups`;

CREATE TABLE `groups` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `id_admin` int(11) NOT NULL,
  `name` varchar(512) DEFAULT 'Новая группа',
  `avatar` varchar(128) DEFAULT NULL,
  `comment` varchar(10240) DEFAULT NULL,
  `category` varchar(128) DEFAULT 'Без категории',
  `theme` int(11) DEFAULT '0',
  `privacy_view` int(1) DEFAULT '1',
  `privacy_come` int(1) DEFAULT '1',
  `privacy_photo` int(1) DEFAULT '0',
  `privacy_forum` int(1) DEFAULT '0',
  `hide_admin` int(1) DEFAULT '0',
  `public_admin` int(1) DEFAULT '0',
  `tape_admin` int(1) DEFAULT '0',
  `time_created` int(11) NOT NULL,
  `rating` int(11) DEFAULT '0',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO groups VALUES("1","1","Ингушетия","0004d0b59e19461ff126e3a08a814c33","Оффициальная группа Республики Ингушетия","Без категории","0","1","1","0","0","0","0","0","1487532728","0");
INSERT INTO groups VALUES("2","2","Moskva Brodyga","bcff3f632fd16ff099a49c2f0932b47a","Московские бродяга","Без категории","0","1","1","0","0","0","0","0","1487533259","0");
INSERT INTO groups VALUES("3","10","Magnum 18","108a525a89b7c0224a5a4ca3abb718a2","Строго +18","Без категории","0","1","1","0","0","0","0","0","1487596704","0");
INSERT INTO groups VALUES("4","12","Любители музыки","","","Без категории","7","1","1","0","0","0","0","0","1487690137","0");



DROP TABLE IF EXISTS `groups_albums`;

CREATE TABLE `groups_albums` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_group` int(11) NOT NULL,
  `upload_admin` int(1) DEFAULT '0',
  `name` varchar(512) DEFAULT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO groups_albums VALUES("1","10","3","0","Соски","1487596838");



DROP TABLE IF EXISTS `groups_comments`;

CREATE TABLE `groups_comments` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_reply` int(11) NOT NULL,
  `id_group` int(11) NOT NULL,
  `id_object` int(11) NOT NULL,
  `type` mediumtext,
  `msg` mediumtext,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `groups_friends`;

CREATE TABLE `groups_friends` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_friends` int(11) NOT NULL,
  `id_group` int(11) NOT NULL,
  `confirm` int(11) DEFAULT '0',
  `count` int(11) DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `groups_photos`;

CREATE TABLE `groups_photos` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `name` varchar(2048) DEFAULT NULL,
  `id_group` int(11) NOT NULL,
  `id_albums` int(11) DEFAULT '0',
  `avatar` int(1) DEFAULT '0',
  `hash` varchar(128) NOT NULL,
  `size` int(11) DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO groups_photos VALUES("3","1","","1","0","1","0004d0b59e19461ff126e3a08a814c33","1970","1487581184");
INSERT INTO groups_photos VALUES("2","2","","2","0","1","bcff3f632fd16ff099a49c2f0932b47a","8010","1487533609");
INSERT INTO groups_photos VALUES("4","10","","3","0","1","108a525a89b7c0224a5a4ca3abb718a2","50533","1487596727");
INSERT INTO groups_photos VALUES("5","10","Большая соска","3","1","0","7c9357dc1384365a339ee9de0b1f5766","41945","1487596865");
INSERT INTO groups_photos VALUES("6","10","","3","1","0","a6562b4b35ab5f1fcbcdb871e4f71b11","58136","1487596891");



DROP TABLE IF EXISTS `groups_tape`;

CREATE TABLE `groups_tape` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_group` int(11) NOT NULL,
  `id_object` int(11) NOT NULL,
  `id_last` int(11) DEFAULT '0',
  `count` int(11) DEFAULT '1',
  `type` mediumtext,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO groups_tape VALUES("1","2","2","1","1","1","topic","1487533647");
INSERT INTO groups_tape VALUES("2","10","3","1","6","2","albums","1487596891");



DROP TABLE IF EXISTS `groups_topic`;

CREATE TABLE `groups_topic` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_group` int(11) NOT NULL,
  `name` mediumtext,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO groups_topic VALUES("1","2","2","Москва, кто туту есть с москвы ребят?","1487533647");



DROP TABLE IF EXISTS `groups_users`;

CREATE TABLE `groups_users` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_group` int(11) NOT NULL,
  `level` int(1) DEFAULT '1',
  `invite` int(11) DEFAULT '0',
  `read` int(1) DEFAULT '0',
  `time` int(11) NOT NULL,
  `rating` int(11) DEFAULT '0',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO groups_users VALUES("1","1","1","4","0","0","1487532917","0");
INSERT INTO groups_users VALUES("2","2","1","1","0","0","1487533219","0");
INSERT INTO groups_users VALUES("3","2","2","4","0","0","1487533274","0");
INSERT INTO groups_users VALUES("4","1","2","1","0","0","1487534318","0");
INSERT INTO groups_users VALUES("5","5","1","1","0","0","1487576999","0");
INSERT INTO groups_users VALUES("6","5","2","1","0","0","1487577004","0");
INSERT INTO groups_users VALUES("7","10","3","4","0","0","1487596708","0");
INSERT INTO groups_users VALUES("8","1","3","1","0","0","1487616738","0");
INSERT INTO groups_users VALUES("9","12","4","4","0","0","1487690144","0");



DROP TABLE IF EXISTS `groups_videos`;

CREATE TABLE `groups_videos` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `name` varchar(2048) DEFAULT NULL,
  `id_group` int(11) NOT NULL,
  `view` int(11) DEFAULT '0',
  `duration` int(11) DEFAULT '0',
  `hash` varchar(128) NOT NULL,
  `type` varchar(128) NOT NULL,
  `codec` varchar(128) NOT NULL,
  `ras` varchar(5) DEFAULT 'mp4',
  `size` int(11) DEFAULT '0',
  `h` int(11) DEFAULT '0',
  `w` int(11) DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gu_bar`;

CREATE TABLE `gu_bar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_ank` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `id_nap` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_ank` (`id_ank`),
  KEY `id_user` (`id_user`),
  KEY `id_nap` (`id_nap`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gu_bar_cat`;

CREATE TABLE `gu_bar_cat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `cat` int(11) NOT NULL,
  `create` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO gu_bar_cat VALUES("1","Алкоголь","0","1");



DROP TABLE IF EXISTS `gu_bar_nap`;

CREATE TABLE `gu_bar_nap` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg` varchar(1024) NOT NULL,
  `file` varchar(100) NOT NULL,
  `id_cat` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_cat` (`id_cat`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `guest`;

CREATE TABLE `guest` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `msg` varchar(1024) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

INSERT INTO guest VALUES("1","1","1487492342","Всем приятного настоения .крут.");
INSERT INTO guest VALUES("2","7","1487594635","DR7777, Спосибо и тебе .семья.");
INSERT INTO guest VALUES("3","8","1487594941","Ас салам алейкум)");
INSERT INTO guest VALUES("6","9","1487595217","Дзейтов Мага, ва алейкум ас салам брат");
INSERT INTO guest VALUES("7","8","1487595773","Чеченец 95, как ты брат");
INSERT INTO guest VALUES("8","7","1487595792","Дзейтов Мага, Мага ты откуда?");
INSERT INTO guest VALUES("9","8","1487595811","Зуля, Я с Ингушетии ну живу в Москве. а ты?");
INSERT INTO guest VALUES("10","7","1487595825","Дзейтов Мага, тож с Назраня) ");
INSERT INTO guest VALUES("11","8","1487595837","Зуля, сколько те лет?");
INSERT INTO guest VALUES("12","7","1487595847","Дзейтов Мага, не скажу :D");
INSERT INTO guest VALUES("13","8","1487595861","Зуля, В личку можно .любовь.");
INSERT INTO guest VALUES("15","1","1487595946","Дзейтов Мага, Нельзя к ней).:D.");



DROP TABLE IF EXISTS `guests`;

CREATE TABLE `guests` (
  `ip` bigint(20) NOT NULL,
  `ua` varchar(32) NOT NULL,
  `date_aut` int(11) NOT NULL,
  `date_last` int(11) NOT NULL,
  `url` varchar(64) NOT NULL,
  `pereh` int(11) NOT NULL DEFAULT '0',
  KEY `ip_2` (`ip`,`ua`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO guests VALUES("1123631332","Mozilla","1487579365","1487741485","/aut.php","66");
INSERT INTO guests VALUES("1123631340","Mozilla","1487583128","1487744064","/user/status/like.php","52");
INSERT INTO guests VALUES("1123631336","Mozilla","1487583592","1487744064","/aut.php","77");
INSERT INTO guests VALUES("1570674719","Mozilla","1487619318","1487743781","/user/info/anketa.php","86");
INSERT INTO guests VALUES("2193699605","Mozilla","1487619352","1487744310","/foto/index.php","85");
INSERT INTO guests VALUES("2193699656","Mozilla","1487619382","1487741807","/obmen/index.php","67");
INSERT INTO guests VALUES("2366158613","Mozilla","1487619447","1487743177","/info.php","70");
INSERT INTO guests VALUES("2366145599","Mozilla","1487619763","1487742997","/info.php","71");
INSERT INTO guests VALUES("2366158865","Mozilla","1487621553","1487743416","/obmen/index.php","18");
INSERT INTO guests VALUES("2366148243","Mozilla","1487621592","1487743101","/foto/index.php","69");
INSERT INTO guests VALUES("1570674699","Mozilla","1487664725","1487742746","/user/users.php","8");
INSERT INTO guests VALUES("1600947686","Mozilla","1487696511","1487697083","/login.php","11");
INSERT INTO guests VALUES("1570674764","Mozilla","1487667785","1487743877","/online_g.php","42");
INSERT INTO guests VALUES("2193699362","Mozilla","1487667848","1487720900","/forum/index.php","29");
INSERT INTO guests VALUES("1385291499","Opera Mini (NokiaC2-01)","1487669462","1487669462","/index.php","0");
INSERT INTO guests VALUES("100662605","Mozilla","1487667862","1487741908","/forum/index.php","7");
INSERT INTO guests VALUES("1600971223","Mozilla","1487669615","1487669941","/index.php","3");
INSERT INTO guests VALUES("1570674716","Mozilla","1487670253","1487742213","/info.php","39");
INSERT INTO guests VALUES("3579280600","Mozilla","1487670430","1487670430","/index.php","0");
INSERT INTO guests VALUES("1089909282","Mozilla","1487674374","1487674374","/index.php","0");
INSERT INTO guests VALUES("1570674721","Mozilla","1487675427","1487742588","/chat/index.php","2");
INSERT INTO guests VALUES("2366158871","Mozilla","1487675431","1487675431","/index.php","0");
INSERT INTO guests VALUES("2366148232","Mozilla","1487675480","1487675480","/plugins/video/index.php","0");
INSERT INTO guests VALUES("100662589","Mozilla","1487675484","1487675484","/forum/index.php","0");
INSERT INTO guests VALUES("1600947655","Mozilla","1487676569","1487677395","/info.php","10");
INSERT INTO guests VALUES("621378251","Mozilla","1487677183","1487723341","/aut.php","1");
INSERT INTO guests VALUES("2996485578","Mozilla","1487677209","1487677209","/info.php","0");
INSERT INTO guests VALUES("1044457236","Mozilla","1487678854","1487738846","/index.php","4");
INSERT INTO guests VALUES("1123631356","Mozilla","1487702657","1487727668","/aut.php","5");
INSERT INTO guests VALUES("2499534613","Mozilla","1487682483","1487682565","/forum/index.php","11");
INSERT INTO guests VALUES("1570674889","Mozilla","1487683588","1487723337","/plugins/video/category.php","1");
INSERT INTO guests VALUES("2996485580","Mozilla","1487683592","1487683592","/chat/index.php","0");
INSERT INTO guests VALUES("2996485577","Mozilla","1487683596","1487683596","/chat/index.php","0");
INSERT INTO guests VALUES("1570674890","Mozilla","1487683600","1487683600","/chat/index.php","0");
INSERT INTO guests VALUES("1600971219","Mozilla","1487689185","1487689249","/index.php","1");
INSERT INTO guests VALUES("2366158857","Mozilla","1487686979","1487731977","/aut.php","8");
INSERT INTO guests VALUES("2996485394","Mozilla","1487686994","1487743800","/info.php","10");
INSERT INTO guests VALUES("2996485402","Mozilla","1487686998","1487743795","/plugins/notes/dir.php","4");
INSERT INTO guests VALUES("2366148282","Mozilla","1487687009","1487687009","/forum/index.php","0");
INSERT INTO guests VALUES("2193699620","Mozilla","1487687023","1487743373","/info.php","9");
INSERT INTO guests VALUES("2193699330","Mozilla","1487687067","1487742397","/user/bookmark/files.php","6");
INSERT INTO guests VALUES("2996485412","Mozilla","1487687080","1487742475","/info.php","4");
INSERT INTO guests VALUES("2366158605","Mozilla","1487687097","1487744506","/plugins/notes/list.php","11");
INSERT INTO guests VALUES("1123631297","Mozilla","1487702041","1487727617","/obmen/index.php","4");
INSERT INTO guests VALUES("1600947650","Mozilla","1487687154","1487687154","/index.php","0");
INSERT INTO guests VALUES("2193699615","Mozilla","1487687156","1487741815","/aut.php","15");
INSERT INTO guests VALUES("2366148116","Mozilla","1487687392","1487744482","/user/personalfiles/index.php","13");
INSERT INTO guests VALUES("2366148269","Mozilla","1487687408","1487742150","/chat/index.php","5");
INSERT INTO guests VALUES("2366158872","Mozilla","1487687474","1487742632","/info.php","7");
INSERT INTO guests VALUES("2366148262","Mozilla","1487687661","1487700863","/plugins/video/index.php","2");
INSERT INTO guests VALUES("1168359729","Mozilla","1487688506","1487688506","/index.php","0");
INSERT INTO guests VALUES("2366148194","Mozilla","1487687585","1487743825","/obmen/index.php","10");
INSERT INTO guests VALUES("2996485385","Mozilla","1487687588","1487741819","/foto/index.php","5");
INSERT INTO guests VALUES("2996475150","Mozilla","1487687674","1487742442","/forum/index.php","7");
INSERT INTO guests VALUES("1570674762","Mozilla","1487687752","1487742400","/info.php","9");
INSERT INTO guests VALUES("86900560","Mozilla","1487688602","1487689064","/index.php","10");
INSERT INTO guests VALUES("1433663510","Mozilla","1487688805","1487704687","/index.php","9");
INSERT INTO guests VALUES("86900575","Mozilla","1487689263","1487689813","/reg.php","12");
INSERT INTO guests VALUES("2365590545","Opera Mini (NokiaC2-01)","1487691562","1487691606","/plugins/apps/index.php","3");
INSERT INTO guests VALUES("623804457","Go 1.1 package http","1487692500","1487692500","/index.php","0");
INSERT INTO guests VALUES("1600971207","Mozilla","1487692662","1487699108","/login.php","14");
INSERT INTO guests VALUES("3169399293","Mozilla","1487721403","1487721628","/aut.php","6");
INSERT INTO guests VALUES("2366148143","Mozilla","1487699633","1487742480","/plugins/notes/user.php","5");
INSERT INTO guests VALUES("1433663584","Mozilla","1487743563","1487744011","/index.php","2");
INSERT INTO guests VALUES("1123631352","Mozilla","1487702038","1487727533","/aut.php","5");
INSERT INTO guests VALUES("3569448419","Mozilla","1487714954","1487714954","/index.php","0");
INSERT INTO guests VALUES("629980619","Mozilla","1487704937","1487705011","/index.php","3");
INSERT INTO guests VALUES("2990717712","Mozilla","1487718491","1487718505","/index.php","3");
INSERT INTO guests VALUES("1600947666","Mozilla","1487706159","1487712626","/login.php","23");
INSERT INTO guests VALUES("86884432","Mozilla","1487712328","1487736669","/login.php","1");
INSERT INTO guests VALUES("2996485387","Mozilla","1487710894","1487742252","/info.php","1");
INSERT INTO guests VALUES("1357916903","Mozilla","1487742801","1487742801","/index.php","0");
INSERT INTO guests VALUES("1570674700","Mozilla","1487710903","1487710903","/user/money/best_list.php","0");
INSERT INTO guests VALUES("1570674755","Mozilla","1487710903","1487710903","/znakomstva/index.php","0");
INSERT INTO guests VALUES("2996475141","Mozilla","1487710904","1487710904","/forum/index.php","0");
INSERT INTO guests VALUES("2193699647","Mozilla","1487710904","1487710904","/foto/index.php","0");
INSERT INTO guests VALUES("2366158880","Mozilla","1487710905","1487710905","/forum/index.php","0");
INSERT INTO guests VALUES("2996485406","Mozilla","1487712694","1487712694","/index.php","0");
INSERT INTO guests VALUES("1533767081","Go-http-client","1487714958","1487714958","/index.php","0");
INSERT INTO guests VALUES("86900595","Mozilla","1487718064","1487719161","/login.php","7");
INSERT INTO guests VALUES("785620563","Mozilla","1487718569","1487718608","/index.php","3");
INSERT INTO guests VALUES("1385291334","Mozilla","1487718705","1487718705","/index.php","0");
INSERT INTO guests VALUES("2834023390","Mozilla","1487718717","1487718717","/index.php","0");
INSERT INTO guests VALUES("2192887880","Mozilla","1487718917","1487718917","/reg.php","0");
INSERT INTO guests VALUES("2192888938","Mozilla","1487718982","1487719079","/reg.php","8");
INSERT INTO guests VALUES("1113983286","Mozilla","1487719745","1487719745","/index.php","0");
INSERT INTO guests VALUES("1427826982","Mozilla","1487719819","1487719819","/index.php","0");
INSERT INTO guests VALUES("1052167312","Mozilla","1487719830","1487719925","/index.php","3");
INSERT INTO guests VALUES("783284764","Mozilla","1487720092","1487720121","/aut.php","2");
INSERT INTO guests VALUES("1600947674","Mozilla","1487720254","1487720289","/login.php","6");
INSERT INTO guests VALUES("1596891646","Mozilla","1487720673","1487720673","/index.php","0");
INSERT INTO guests VALUES("86884444","Mozilla","1487721940","1487721940","/index.php","0");
INSERT INTO guests VALUES("3648413505","Mozilla","1487743310","1487743310","/index.php","0");
INSERT INTO guests VALUES("3648410105","Mozilla","1487722227","1487722296","/aut.php","5");
INSERT INTO guests VALUES("2834026185","Mozilla","1487722495","1487722546","/aut.php","2");
INSERT INTO guests VALUES("1315944814","Mozilla","1487722972","1487722972","/index.php","0");
INSERT INTO guests VALUES("100648535","Mozilla","1487724178","1487724178","/index.php","0");
INSERT INTO guests VALUES("1385312747","Mozilla","1487728030","1487728030","/index.php","0");
INSERT INTO guests VALUES("3569448437","Mozilla","1487728114","1487728225","/forum/index.php","5");
INSERT INTO guests VALUES("1113983282","Mozilla","1487728478","1487741435","/index.php","1");
INSERT INTO guests VALUES("780499871","Mozilla","1487728514","1487728514","/index.php","0");
INSERT INTO guests VALUES("1048945187","Mozilla","1487729340","1487729375","/aut.php","4");
INSERT INTO guests VALUES("3274840773","Mozilla","1487729581","1487729641","/aut.php","5");
INSERT INTO guests VALUES("1123638612","Mozilla","1487736168","1487736168","/index.php","0");
INSERT INTO guests VALUES("1840796286","Mozilla","1487736250","1487737734","/aut.php","12");
INSERT INTO guests VALUES("1600947652","Mozilla","1487736264","1487736477","/reg.php","11");
INSERT INTO guests VALUES("1385290938","Mozilla","1487737449","1487737730","/reg.php","8");
INSERT INTO guests VALUES("1048945323","Mozilla","1487737210","1487737237","/aut.php","4");
INSERT INTO guests VALUES("1565800355","Mozilla","1487737367","1487737367","/index.php","0");
INSERT INTO guests VALUES("2995385761","Mozilla","1487738575","1487738575","/index.php","0");
INSERT INTO guests VALUES("1588830783","Mozilla","1487737745","1487737745","/index.php","0");
INSERT INTO guests VALUES("2365590930","Opera Mini (Mozilla)","1487737928","1487737928","/index.php","0");
INSERT INTO guests VALUES("136702077","Mozilla","1487738186","1487738186","/index.php","0");
INSERT INTO guests VALUES("1315945186","Mozilla","1487738997","1487738997","/index.php","0");
INSERT INTO guests VALUES("1433663557","Mozilla","1487738767","1487741362","/aut.php","13");
INSERT INTO guests VALUES("1385291067","Opera Mini (NokiaX2-02)","1487739055","1487739055","/index.php","0");
INSERT INTO guests VALUES("531462188","Mozilla","1487739442","1487739442","/index.php","0");
INSERT INTO guests VALUES("785612500","Mozilla","1487740849","1487740849","/index.php","0");
INSERT INTO guests VALUES("3579286954","Mozilla","1487740679","1487740714","/index.php","3");
INSERT INTO guests VALUES("2953414703","Mozilla","1487741020","1487741020","/index.php","0");
INSERT INTO guests VALUES("623671286","Mozilla","1487742154","1487742266","/aut.php","2");
INSERT INTO guests VALUES("1385291169","Opera Mini (Mozilla)","1487741669","1487741669","/index.php","0");
INSERT INTO guests VALUES("785609573","Mozilla","1487742119","1487742119","/index.php","0");
INSERT INTO guests VALUES("3648410547","Mozilla","1487742381","1487742445","/aut.php","2");
INSERT INTO guests VALUES("1051008676","Mozilla","1487742397","1487742397","/index.php","0");
INSERT INTO guests VALUES("2365590826","Opera Mini (Mozilla)","1487742435","1487742507","/aut.php","6");
INSERT INTO guests VALUES("1385291013","Opera Mini (Opera)","1487744288","1487744288","/index.php","0");
INSERT INTO guests VALUES("1427827066","Mozilla","1487743039","1487743073","/index.php","1");
INSERT INTO guests VALUES("1385290960","Opera Mini (OperaMini)","1487743089","1487743089","/index.php","0");
INSERT INTO guests VALUES("1600971208","Mozilla","1487744301","1487744414","/login.php","5");



DROP TABLE IF EXISTS `konts`;

CREATE TABLE `konts` (
  `id_user` int(11) NOT NULL,
  `id_kont` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  KEY `id_user` (`id_user`,`id_kont`,`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `liders`;

CREATE TABLE `liders` (
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time_p` int(11) NOT NULL,
  `msg` varchar(215) NOT NULL,
  `stav` int(11) NOT NULL DEFAULT '0',
  KEY `id_user` (`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO liders VALUES("1488098899","1","0","VIP Премиум!","7");
INSERT INTO liders VALUES("1488100983","2","0","VIP Премиум!","7");
INSERT INTO liders VALUES("1488182481","6","0","VIP Премиум!","7");
INSERT INTO liders VALUES("1488182574","5","0","VIP Премиум!","7");
INSERT INTO liders VALUES("1488199131","7","0","VIP Премиум!","7");



DROP TABLE IF EXISTS `like_object`;

CREATE TABLE `like_object` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `type` varchar(11) DEFAULT NULL,
  `like` set('1','0') NOT NULL DEFAULT '0',
  `id_object` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mail`;

CREATE TABLE `mail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_kont` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  `read` set('0','1') NOT NULL DEFAULT '0',
  `unlink` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`,`id_kont`),
  KEY `read` (`read`)
) ENGINE=MyISAM AUTO_INCREMENT=42 DEFAULT CHARSET=utf8;

INSERT INTO mail VALUES("1","0","1","1487494099","Вы активировали услугу VIP Премиум . С вашего счета было снято 100 монет","1","0");
INSERT INTO mail VALUES("2","0","2","1487496133","Пользователь [b]DR7777[/b] перевeл вам средства в колличестве [b] 300 [/b] монет! [br]НЕ ЗАБУДЬТЕ СКАЗАТЬ СПАСИБО!","1","0");
INSERT INTO mail VALUES("3","0","2","1487496183","Вы активировали услугу VIP Премиум . С вашего счета было снято 100 монет","1","0");
INSERT INTO mail VALUES("4","0","2","1487497433","[url=/info.php?id=1][b]DR7777[/b][/url] приглашает Вас учавствовать в дуэле [url=/duels/waiting.php?duels=1][b]Открыть[/b][/url]","1","0");
INSERT INTO mail VALUES("5","0","1","1487497488","Ваша дуэль началась  [url=/duels/active.php?duels=1][b]Открыть[/b][/url]","1","0");
INSERT INTO mail VALUES("6","0","1","1487534220","Вам задали вопрос. [url=/ask/ask.php?id=1]Ответить![/url]","1","0");
INSERT INTO mail VALUES("7","0","1","1487534228","Вам задали вопрос. [url=/ask/ask.php?id=1]Ответить![/url]","1","0");
INSERT INTO mail VALUES("8","0","1","1487534247","Вам задали вопрос. [url=/ask/ask.php?id=1]Ответить![/url]","1","0");
INSERT INTO mail VALUES("9","0","6","1487577328","Пользователь [b]DR7777[/b] перевeл вам средства в колличестве [b] 50 [/b] монет! [br]НЕ ЗАБУДЬТЕ СКАЗАТЬ СПАСИБО!","1","0");
INSERT INTO mail VALUES("10","0","6","1487577448","Пользователь [b]DR7777[/b] перевeл вам средства в колличестве [b] 100000 [/b] монет! [br]НЕ ЗАБУДЬТЕ СКАЗАТЬ СПАСИБО!","1","0");
INSERT INTO mail VALUES("11","0","5","1487577460","Пользователь [b]DR7777[/b] перевeл вам средства в колличестве [b] 100000 [/b] монет! [br]НЕ ЗАБУДЬТЕ СКАЗАТЬ СПАСИБО!","1","0");
INSERT INTO mail VALUES("12","0","1","1487577553","Пользователь [url=/id=5][b]Vika_Tigr[/b][/url], повысила ваш авторитет на [64] очков, не забудьте сказать спасибо :)","1","0");
INSERT INTO mail VALUES("13","0","1","1487577554","Пользователь [url=/id=5][b]Vika_Tigr[/b][/url], повысила ваш авторитет на [64] очков, не забудьте сказать спасибо :)","1","0");
INSERT INTO mail VALUES("14","0","1","1487577554","Пользователь [url=/id=5][b]Vika_Tigr[/b][/url], повысила ваш авторитет на [64] очков, не забудьте сказать спасибо :)","1","0");
INSERT INTO mail VALUES("15","0","1","1487577559","Пользователь [url=/id=5][b]Vika_Tigr[/b][/url], повысила ваш авторитет на [64] очков, не забудьте сказать спасибо :)","1","0");
INSERT INTO mail VALUES("16","0","1","1487577560","Пользователь [url=/id=5][b]Vika_Tigr[/b][/url], повысила ваш авторитет на [64] очков, не забудьте сказать спасибо :)","1","0");
INSERT INTO mail VALUES("17","0","1","1487577560","Пользователь [url=/id=5][b]Vika_Tigr[/b][/url], повысила ваш авторитет на [64] очков, не забудьте сказать спасибо :)","1","0");
INSERT INTO mail VALUES("18","0","6","1487577681","Вы активировали услугу VIP Премиум . С вашего счета было снято 100 монет","1","0");
INSERT INTO mail VALUES("19","0","6","1487577975","Пользователь [url=/id=1][b]DR7777[/b][/url], повысил ваш авторитет на [64] очков, не забудьте сказать спасибо :)","1","0");
INSERT INTO mail VALUES("20","0","6","1487577975","Пользователь [url=/id=1][b]DR7777[/b][/url], повысил ваш авторитет на [64] очков, не забудьте сказать спасибо :)","1","0");
INSERT INTO mail VALUES("21","0","6","1487577977","Пользователь [url=/id=1][b]DR7777[/b][/url], повысил ваш авторитет на [64] очков, не забудьте сказать спасибо :)","1","0");
INSERT INTO mail VALUES("22","0","6","1487577978","Пользователь [url=/id=1][b]DR7777[/b][/url], повысил ваш авторитет на [64] очков, не забудьте сказать спасибо :)","1","0");
INSERT INTO mail VALUES("23","0","6","1487577979","Пользователь [url=/id=1][b]DR7777[/b][/url], повысил ваш авторитет на [64] очков, не забудьте сказать спасибо :)","1","0");
INSERT INTO mail VALUES("24","0","5","1487577987","Пользователь [url=/id=1][b]DR7777[/b][/url], повысил ваш авторитет на [64] очков, не забудьте сказать спасибо :)","0","0");
INSERT INTO mail VALUES("25","0","5","1487577988","Пользователь [url=/id=1][b]DR7777[/b][/url], повысил ваш авторитет на [64] очков, не забудьте сказать спасибо :)","0","0");
INSERT INTO mail VALUES("26","0","5","1487577989","Пользователь [url=/id=1][b]DR7777[/b][/url], повысил ваш авторитет на [64] очков, не забудьте сказать спасибо :)","0","0");
INSERT INTO mail VALUES("27","0","5","1487577990","Пользователь [url=/id=1][b]DR7777[/b][/url], повысил ваш авторитет на [64] очков, не забудьте сказать спасибо :)","0","0");
INSERT INTO mail VALUES("28","0","5","1487577991","Пользователь [url=/id=1][b]DR7777[/b][/url], повысил ваш авторитет на [64] очков, не забудьте сказать спасибо :)","0","0");
INSERT INTO mail VALUES("29","0","5","1487577991","Пользователь [url=/id=1][b]DR7777[/b][/url], повысил ваш авторитет на [64] очков, не забудьте сказать спасибо :)","0","0");
INSERT INTO mail VALUES("30","0","0","1487589562","Вы выиграли в аукционе 0 монет! Поздравляем!","0","0");
INSERT INTO mail VALUES("31","0","0","1487589582","Вы выиграли в аукционе 0 монет! Поздравляем!","0","0");
INSERT INTO mail VALUES("32","0","0","1487589675","Вы выиграли в аукционе 0 монет! Поздравляем!","0","0");
INSERT INTO mail VALUES("33","0","7","1487594176","Пользователь [b]DR7777[/b] перевeл вам средства в колличестве [b] 12212121 [/b] монет! [br]НЕ ЗАБУДЬТЕ СКАЗАТЬ СПАСИБО!","1","0");
INSERT INTO mail VALUES("34","0","7","1487594331","Вы активировали услугу VIP Премиум . С вашего счета было снято 100 монет","1","0");
INSERT INTO mail VALUES("35","0","1","1487595474","За ваше фото проголосовали в дуэле  [url=/duels/active.php?duels=1][b]Открыть[/b][/url]","1","0");
INSERT INTO mail VALUES("36","0","1","1487595492","За ваше фото проголосовали в дуэле  [url=/duels/active.php?duels=1][b]Открыть[/b][/url]","1","0");
INSERT INTO mail VALUES("37","0","2","1487595578","За ваше фото проголосовали в дуэле  [url=/duels/active.php?duels=1][b]Открыть[/b][/url]","1","0");
INSERT INTO mail VALUES("38","0","1","1487595597","За ваше фото проголосовали в дуэле  [url=/duels/active.php?duels=1][b]Открыть[/b][/url]","1","0");
INSERT INTO mail VALUES("39","0","7","1487596346","DR7777 оставил о Вас [url=/user/info/who_rating.php]положительный отзыв[/url]","1","0");
INSERT INTO mail VALUES("40","0","7","1487596950","Вам задали вопрос. [url=/ask/ask.php?id=7]Ответить![/url]","1","0");
INSERT INTO mail VALUES("41","0","12","1487690671","Вам задали вопрос. [url=/ask/ask.php?id=12]Ответить![/url]","1","0");



DROP TABLE IF EXISTS `mail_to_send`;

CREATE TABLE `mail_to_send` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mail` varchar(64) NOT NULL,
  `them` varchar(32) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mark_files`;

CREATE TABLE `mark_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_file` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mark_foto`;

CREATE TABLE `mark_foto` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_foto` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO mark_foto VALUES("1","1","13","1487534491");
INSERT INTO mark_foto VALUES("2","1","20","1487584029");
INSERT INTO mark_foto VALUES("3","1","45","1487596389");
INSERT INTO mark_foto VALUES("4","7","51","1487615332");



DROP TABLE IF EXISTS `mark_notes`;

CREATE TABLE `mark_notes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_list` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mark_people`;

CREATE TABLE `mark_people` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_people` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO mark_people VALUES("1","1","2","1487496307");
INSERT INTO mark_people VALUES("2","3","1","1487506195");
INSERT INTO mark_people VALUES("4","1","3","1487522513");



DROP TABLE IF EXISTS `media_info`;

CREATE TABLE `media_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file` varchar(64) NOT NULL,
  `size` int(11) NOT NULL,
  `lenght` varchar(32) NOT NULL,
  `bit` varchar(32) NOT NULL,
  `codec` varchar(32) NOT NULL,
  `wh` varchar(32) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `file` (`file`,`size`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `menu`;

CREATE TABLE `menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` enum('link','razd') NOT NULL DEFAULT 'link',
  `name` varchar(32) NOT NULL,
  `url` varchar(32) NOT NULL,
  `counter` varchar(32) NOT NULL,
  `pos` int(11) NOT NULL,
  `icon` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pos` (`pos`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COMMENT='Главное меню';

INSERT INTO menu VALUES("1","link","Новости","/news/","news/count.php","1","default.png");
INSERT INTO menu VALUES("2","link","Чат","/chat/","chat/count.php","7","default.png");
INSERT INTO menu VALUES("4","link","Гостевая","/guest/","guest/count.php","9","default.png");
INSERT INTO menu VALUES("5","link","Зона обмена","/obmen/","obmen/count.php","5","default.png");
INSERT INTO menu VALUES("6","link","Форум","/forum/","forum/count.php","6","default.png");
INSERT INTO menu VALUES("7","link","Фотогалерея","/foto/","foto/count.php","10","default.png");
INSERT INTO menu VALUES("11","link","Лидеры","/user/liders/","/user/liders/count.php","4","default.png");
INSERT INTO menu VALUES("10","link","Блоги","/plugins/notes/","plugins/notes/count.php","8","default.png");
INSERT INTO menu VALUES("12","link","Знакомства","/user/love/","/user/love/count.php","3","default.png");
INSERT INTO menu VALUES("15","link","Комеди Баттл","/plugins/comedy/index.php","/plugins/comedy/index","12","default.png");
INSERT INTO menu VALUES("14","link","Пользователи","/user/users.php","/user/count.php","11","default.png");
INSERT INTO menu VALUES("16","link","Фото дуэли","/duels/index.php","/duels/index","13","default.png");
INSERT INTO menu VALUES("20","link","Видеозаписи","/plugins/video/","plugins/video/count.php","7","default.png");
INSERT INTO menu VALUES("21","link","Доска объявления","/board/index.php","/board/index","14","default.png");
INSERT INTO menu VALUES("22","link","Мой ребенок","/moi/index.php","/moi/index","15","default.png");
INSERT INTO menu VALUES("23","link","Гаремы рейтинг","/plugins/user_garem/top/","","0","default.png");
INSERT INTO menu VALUES("24","link","Спрашивай.ру","/ask/index.php","/ask/index","16","default.png");



DROP TABLE IF EXISTS `my_guests`;

CREATE TABLE `my_guests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_ank` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `read` enum('0','1') NOT NULL DEFAULT '1',
  `count` int(11) NOT NULL DEFAULT '1',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=utf8;

INSERT INTO my_guests VALUES("1","1","2","1","1","1487692847");
INSERT INTO my_guests VALUES("2","2","1","1","1","1487534429");
INSERT INTO my_guests VALUES("3","1","3","1","1","1487506136");
INSERT INTO my_guests VALUES("4","3","1","1","1","1487534473");
INSERT INTO my_guests VALUES("5","1","4","1","1","1487571948");
INSERT INTO my_guests VALUES("6","1","5","1","1","1487577489");
INSERT INTO my_guests VALUES("7","1","6","1","1","1487712335");
INSERT INTO my_guests VALUES("8","6","1","1","1","1487712631");
INSERT INTO my_guests VALUES("9","5","1","1","1","1487691180");
INSERT INTO my_guests VALUES("10","2","6","1","1","1487577649");
INSERT INTO my_guests VALUES("11","4","1","1","1","1487583996");
INSERT INTO my_guests VALUES("12","7","1","1","1","1487736291");
INSERT INTO my_guests VALUES("13","1","7","1","1","1487596042");
INSERT INTO my_guests VALUES("14","1","8","1","1","1487596079");
INSERT INTO my_guests VALUES("15","1","9","1","1","1487596104");
INSERT INTO my_guests VALUES("16","1","10","1","1","1487596663");
INSERT INTO my_guests VALUES("17","10","11","1","1","1487598061");
INSERT INTO my_guests VALUES("18","11","1","1","1","1487598154");
INSERT INTO my_guests VALUES("19","10","1","1","1","1487616699");
INSERT INTO my_guests VALUES("20","6","12","1","1","1487690018");
INSERT INTO my_guests VALUES("21","10","12","1","1","1487690084");
INSERT INTO my_guests VALUES("22","2","12","1","1","1487690096");
INSERT INTO my_guests VALUES("23","1","12","1","1","1487690189");
INSERT INTO my_guests VALUES("24","7","12","1","1","1487737337");
INSERT INTO my_guests VALUES("25","12","1","0","1","1487693892");
INSERT INTO my_guests VALUES("26","14","1","1","1","1487709420");
INSERT INTO my_guests VALUES("27","5","6","1","1","1487712568");
INSERT INTO my_guests VALUES("28","16","1","1","1","1487720193");
INSERT INTO my_guests VALUES("29","17","1","1","1","1487719191");
INSERT INTO my_guests VALUES("30","7","18","1","1","1487736580");
INSERT INTO my_guests VALUES("31","20","7","1","1","1487744478");



DROP TABLE IF EXISTS `ncolor`;

CREATE TABLE `ncolor` (
  `cena1` varchar(15) NOT NULL,
  `cena2` varchar(15) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO ncolor VALUES("200","100");



DROP TABLE IF EXISTS `news`;

CREATE TABLE `news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg` varchar(10024) DEFAULT NULL,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `title` varchar(32) DEFAULT NULL,
  `main_time` int(11) NOT NULL DEFAULT '0',
  `link` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `news_komm`;

CREATE TABLE `news_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  `time` int(11) NOT NULL,
  `id_news` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `notes`;

CREATE TABLE `notes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg` mediumtext,
  `time` int(11) NOT NULL,
  `name` varchar(32) DEFAULT NULL,
  `private` int(11) NOT NULL DEFAULT '0',
  `tags` varchar(64) NOT NULL,
  `id_user` int(11) DEFAULT '0',
  `private_komm` int(11) DEFAULT '0',
  `count` int(11) DEFAULT '0',
  `id_dir` int(11) DEFAULT '0',
  `type` int(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO notes VALUES("1","Всем привет, хотел спросить и узнать как вы думаете как вам работа пожарного) ваше мнение?","1487692088","МСЧ РОССИИ","0","","1","0","3","10","0");



DROP TABLE IF EXISTS `notes_count`;

CREATE TABLE `notes_count` (
  `id_notes` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  KEY `id_notes` (`id_notes`,`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO notes_count VALUES("1","1");
INSERT INTO notes_count VALUES("1","2");
INSERT INTO notes_count VALUES("1","12");



DROP TABLE IF EXISTS `notes_dir`;

CREATE TABLE `notes_dir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg` varchar(1024) NOT NULL,
  `name` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;

INSERT INTO notes_dir VALUES("1","No comments...","Прочее");
INSERT INTO notes_dir VALUES("2","Отдых, Туризм, Кино, Авто и Мото и др. Пишите о том как вы проводите свой досуг, рассказывайте о местах в которых бывали, возможно кто то захочет побывать там же и взглянуть на все своими глазами.","Досуг");
INSERT INTO notes_dir VALUES("3","Пишите о своих проблемах, делитесь горем и несчастьем. Тут вас всегда поддержут.","Проблемы и вопросы");
INSERT INTO notes_dir VALUES("4","Тут вы можете выкладывать свои стихи, стихи и цитаты любимых поэтов.","Стихи");
INSERT INTO notes_dir VALUES("5","Название говорит само за себя. Все о сексе и отношениях. Здесь вас научат как сделать приятно","Секс");
INSERT INTO notes_dir VALUES("6","Высказывайте свое мнение, делитесь своими мыслями по поводу политики и политических деятелях, устроите настоящие политические дебаты.","Политика");
INSERT INTO notes_dir VALUES("7","Здесь вы можете писать о своих страхах, просто страшные истории и обо всем, что связанно со страхом.","Страшилки");
INSERT INTO notes_dir VALUES("8","Смешные истории, анекдоты, веселые рассказы, ну и конечно же свои веселые мысли.","Юмор и Приколы");
INSERT INTO notes_dir VALUES("9","Здесь вы можете описать свои мысли, написать стихи, высказывания и все все все что связанно с любовью.","О любви");
INSERT INTO notes_dir VALUES("10","Разные записи о том, об этом и обо всем сразу.","Все обо всем");
INSERT INTO notes_dir VALUES("11","Притчи и метафоры","Притчи и метафоры");
INSERT INTO notes_dir VALUES("12","Творчество собственного сочинения.","Личное творчество");
INSERT INTO notes_dir VALUES("13","Музыка, Кино, Искусство,тексты песен,биографии актеров и артистов, и все, что связанно с творчеством.","Искусство и творчество");
INSERT INTO notes_dir VALUES("14","Делимся полезной информацией. Здесь должно быть интересно.","Познавательные");
INSERT INTO notes_dir VALUES("15","Исторические события и факты. Наша история.","История");
INSERT INTO notes_dir VALUES("16","Рассказы, статьи, истории и казусы, вообщем все, все, все, что касается интернета.","Интернет");
INSERT INTO notes_dir VALUES("17","Поздравляем друг друга, оставляем пожелания,напутствия и добрые слова.","Поздравления и пожелания");
INSERT INTO notes_dir VALUES("18","Статусы. Жизненные высказывания и цитаты.","Цитаты. Статусы. Высказывания");
INSERT INTO notes_dir VALUES("19","В названии категории все сказано","Молитвы");



DROP TABLE IF EXISTS `notes_komm`;

CREATE TABLE `notes_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_notes` varchar(50) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO notes_komm VALUES("1","1","1","Пишем в коментариях ваши мысли о работе пожарного","1487692289");
INSERT INTO notes_komm VALUES("2","2","1","Думаю достаточно мужественная работа, и опасная. рискуешь жизнью. работа классная* спосибо вам огромное .кисс.","1487693171");



DROP TABLE IF EXISTS `notes_like`;

CREATE TABLE `notes_like` (
  `id_notes` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `like` int(11) DEFAULT '0',
  KEY `id_notes` (`id_notes`,`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `notification`;

CREATE TABLE `notification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `id_object` int(11) NOT NULL,
  `type` varchar(11) NOT NULL,
  `avtor` int(11) DEFAULT NULL,
  `all_type` varchar(11) DEFAULT NULL,
  `read` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=74 DEFAULT CHARSET=utf8;

INSERT INTO notification VALUES("1","2","1487494497","2","garem_kraj","1","","1");
INSERT INTO notification VALUES("2","2","1487504866","1","ok_frend","1","","1");
INSERT INTO notification VALUES("3","3","1487506427","1","ok_frend","1","","0");
INSERT INTO notification VALUES("4","2","1487521203","1","new_gift","1","","1");
INSERT INTO notification VALUES("5","1","1487533201","189","ok_gift","2","","1");
INSERT INTO notification VALUES("6","4","1487572540","1","ok_frend","1","","0");
INSERT INTO notification VALUES("7","5","1487577066","2","new_gift","1","","1");
INSERT INTO notification VALUES("8","1","1487577268","6","otm_frend","6","","1");
INSERT INTO notification VALUES("9","1","1487577288","6","otm_frend","6","","1");
INSERT INTO notification VALUES("10","6","1487577311","1","ok_frend","1","","1");
INSERT INTO notification VALUES("11","5","1487577312","1","ok_frend","1","","1");
INSERT INTO notification VALUES("12","6","1487577429","3","new_gift","1","","1");
INSERT INTO notification VALUES("13","6","1487577440","4","new_gift","1","","1");
INSERT INTO notification VALUES("14","5","1487577470","5","new_gift","1","","1");
INSERT INTO notification VALUES("15","1","1487577483","256","ok_gift","5","","1");
INSERT INTO notification VALUES("16","1","1487577543","1","garem_kraj","5","","1");
INSERT INTO notification VALUES("17","1","1487577574","6","new_gift","5","","1");
INSERT INTO notification VALUES("18","1","1487577584","7","new_gift","5","","1");
INSERT INTO notification VALUES("19","1","1487577594","8","new_gift","5","","1");
INSERT INTO notification VALUES("20","1","1487577620","270","ok_gift","6","","1");
INSERT INTO notification VALUES("21","1","1487577626","265","ok_gift","6","","1");
INSERT INTO notification VALUES("22","1","1487577652","1","garem_yk","6","","1");
INSERT INTO notification VALUES("23","2","1487577652","2","garem_kraj","6","","0");
INSERT INTO notification VALUES("24","2","1487577663","9","new_gift","6","","0");
INSERT INTO notification VALUES("25","1","1487577708","10","new_gift","6","","1");
INSERT INTO notification VALUES("26","1","1487577717","11","new_gift","6","","1");
INSERT INTO notification VALUES("27","1","1487577727","12","new_gift","6","","1");
INSERT INTO notification VALUES("28","1","1487577734","13","new_gift","6","","1");
INSERT INTO notification VALUES("29","1","1487577745","14","new_gift","6","","1");
INSERT INTO notification VALUES("30","6","1487577790","304","ok_gift","1","","1");
INSERT INTO notification VALUES("31","6","1487577794","225","ok_gift","1","","1");
INSERT INTO notification VALUES("32","6","1487577798","214","ok_gift","1","","1");
INSERT INTO notification VALUES("33","6","1487577804","271","ok_gift","1","","1");
INSERT INTO notification VALUES("34","6","1487577808","278","ok_gift","1","","1");
INSERT INTO notification VALUES("35","4","1487584005","15","new_gift","1","","0");
INSERT INTO notification VALUES("36","4","1487584016","16","new_gift","1","","0");
INSERT INTO notification VALUES("37","4","1487584019","17","new_gift","1","","0");
INSERT INTO notification VALUES("38","7","1487594193","18","new_gift","1","","1");
INSERT INTO notification VALUES("39","7","1487594201","19","new_gift","1","","1");
INSERT INTO notification VALUES("40","7","1487594205","20","new_gift","1","","1");
INSERT INTO notification VALUES("41","1","1487594225","7","ok_frend","7","","1");
INSERT INTO notification VALUES("42","1","1487594292","21","new_gift","7","","1");
INSERT INTO notification VALUES("43","1","1487594635","0","guest","7","","1");
INSERT INTO notification VALUES("44","8","1487594999","3","them_komm","7","","1");
INSERT INTO notification VALUES("45","7","1487595040","3","them_komm","8","","0");
INSERT INTO notification VALUES("46","8","1487595217","0","guest","9","","1");
INSERT INTO notification VALUES("47","6","1487595611","4","them_komm","8","","0");
INSERT INTO notification VALUES("48","8","1487595659","4","them_komm","7","","1");
INSERT INTO notification VALUES("49","7","1487595683","4","them_komm","8","","1");
INSERT INTO notification VALUES("50","8","1487595699","4","them_komm","7","","1");
INSERT INTO notification VALUES("51","7","1487595717","4","them_komm","8","","1");
INSERT INTO notification VALUES("52","8","1487595731","4","them_komm","7","","1");
INSERT INTO notification VALUES("53","7","1487595757","4","them_komm","8","","1");
INSERT INTO notification VALUES("54","9","1487595773","0","guest","8","","1");
INSERT INTO notification VALUES("55","8","1487595792","0","guest","7","","1");
INSERT INTO notification VALUES("56","7","1487595811","0","guest","8","","1");
INSERT INTO notification VALUES("57","8","1487595825","0","guest","7","","1");
INSERT INTO notification VALUES("58","7","1487595837","0","guest","8","","1");
INSERT INTO notification VALUES("59","8","1487595847","0","guest","7","","1");
INSERT INTO notification VALUES("60","7","1487595861","0","guest","8","","1");
INSERT INTO notification VALUES("61","8","1487595877","0","guest","7","","1");
INSERT INTO notification VALUES("62","8","1487595946","0","guest","1","","1");
INSERT INTO notification VALUES("63","8","1487596187","1","ok_frend","1","","0");
INSERT INTO notification VALUES("64","11","1487598610","2","them_komm","1","","0");
INSERT INTO notification VALUES("65","8","1487615307","4","them_komm","7","","0");
INSERT INTO notification VALUES("66","12","1487690042","22","new_gift","1","","1");
INSERT INTO notification VALUES("67","12","1487690487","23","new_gift","1","","1");
INSERT INTO notification VALUES("68","1","1487691796","12","ok_frend","12","","1");
INSERT INTO notification VALUES("69","6","1487692838","6","garem_exit","2","","0");
INSERT INTO notification VALUES("70","14","1487709419","24","new_gift","1","","0");
INSERT INTO notification VALUES("71","16","1487718217","25","new_gift","1","","0");
INSERT INTO notification VALUES("72","17","1487719853","26","new_gift","1","","0");
INSERT INTO notification VALUES("73","7","1487720230","7","garem_kraj","1","","0");



DROP TABLE IF EXISTS `notification_set`;

CREATE TABLE `notification_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `komm` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

INSERT INTO notification_set VALUES("1","1","1");
INSERT INTO notification_set VALUES("2","2","1");
INSERT INTO notification_set VALUES("3","3","1");
INSERT INTO notification_set VALUES("4","4","1");
INSERT INTO notification_set VALUES("5","5","1");
INSERT INTO notification_set VALUES("6","6","1");
INSERT INTO notification_set VALUES("7","7","1");
INSERT INTO notification_set VALUES("8","8","1");
INSERT INTO notification_set VALUES("9","9","1");
INSERT INTO notification_set VALUES("10","10","1");
INSERT INTO notification_set VALUES("11","11","1");
INSERT INTO notification_set VALUES("12","12","1");
INSERT INTO notification_set VALUES("13","13","1");
INSERT INTO notification_set VALUES("14","14","1");
INSERT INTO notification_set VALUES("15","15","1");
INSERT INTO notification_set VALUES("16","16","1");
INSERT INTO notification_set VALUES("17","17","1");
INSERT INTO notification_set VALUES("18","18","1");
INSERT INTO notification_set VALUES("19","19","1");
INSERT INTO notification_set VALUES("20","20","1");



DROP TABLE IF EXISTS `obmennik_dir`;

CREATE TABLE `obmennik_dir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `num` int(11) DEFAULT '0',
  `name` varchar(64) NOT NULL,
  `ras` varchar(512) NOT NULL,
  `maxfilesize` int(11) NOT NULL,
  `dir` varchar(512) NOT NULL DEFAULT '/',
  `dir_osn` varchar(512) DEFAULT '/',
  `upload` set('1','0') NOT NULL DEFAULT '0',
  `my` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `num` (`num`),
  KEY `dir` (`dir`(333))
) ENGINE=MyISAM AUTO_INCREMENT=368 DEFAULT CHARSET=utf8;

INSERT INTO obmennik_dir VALUES("1","0","Личные файлы","wmv;zip;rar;tar;avi;3gp;mp4;mp3;amr;txt;cab;thm;sdt;nth;mtf;col;scs;utz;gif;jpg;jpeg;bmp;png;wbmp;pic;ani;pco;mmf;mid;amr;mp3;wav;aac;seq;vox;dxm;imy;emy;pmd;rng;doc;docx;swf;tsk;apk;sis;sisx;jar;exe;","52428800","/Lichnye_fajly/","/","1","1");
INSERT INTO obmennik_dir VALUES("38","0","Будильники","mp3;mp4;midi;amr;wav:","10485760","/Audio/Budilniki/","/Audio/","1","0");
INSERT INTO obmennik_dir VALUES("3","0","Аудио","mp3;mp4;midi;amr;wav:","0","/Audio/","/","0","0");
INSERT INTO obmennik_dir VALUES("4","0","Видео","3gp;mp4;avi;flv;wmv;wav:","0","/Video/","/","0","0");
INSERT INTO obmennik_dir VALUES("5","0","Игры","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip:","0","/Igry/","/","0","0");
INSERT INTO obmennik_dir VALUES("6","0","Картинки","jpg;gif;png;jpeg:","0","/Kartinki/","/","0","0");
INSERT INTO obmennik_dir VALUES("7","0","Книги","jar;rar;zip;pdf;fb2;doc;jad;rtf;txt;mp3;mp4;midi:","0","/Knigi/","/","0","0");
INSERT INTO obmennik_dir VALUES("101","0","Музыка","mp3;mp4;midi;amr;wav;","0","/Muzyka/","/","0","0");
INSERT INTO obmennik_dir VALUES("9","0","Программы","exe;rar;zip;jar;ipa;rar;zip;jad;sis;7-Zip;sisx;","52428800","/Programmy/","/","1","0");
INSERT INTO obmennik_dir VALUES("10","0","Программы для ПК","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip:","104857600","/Programmy_dlja_PK/","/","1","0");
INSERT INTO obmennik_dir VALUES("11","0","Творчество обитателей","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;gif;txt;doc;mp3;jpg;jpeg;gif;png;mp4;docx;flv;amr;pdf:","0","/Tvorchestvo_obitatelej/","/","0","0");
INSERT INTO obmennik_dir VALUES("12","0","Темы","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip:","52428800","/Temy/","/","1","0");
INSERT INTO obmennik_dir VALUES("13","0","Флеш","swf;exe;thm;nth:","0","/Flesh/","/","0","0");
INSERT INTO obmennik_dir VALUES("105","0","POP","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/POP/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("104","0","Jazz","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Jazz/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("103","0","Dubstep","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Dubstep/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("18","0","Советская Фантастика","jar;rar;zip;pdf;fb2;doc;jad;rtf;txt;mp3;mp4;midi:","2097152","/Knigi/Sovetskaja_fantastika/","/Knigi/","1","0");
INSERT INTO obmennik_dir VALUES("19","0","Зарубежная фантастика","jar;rar;zip;pdf;fb2;doc;jad;rtf;txt;mp3;mp4;midi:","2097152","/Knigi/Zarubezhnaja_fantastika/","/Knigi/","1","0");
INSERT INTO obmennik_dir VALUES("20","0","Фэнтези","jar;rar;zip;pdf;fb2;doc;jad;rtf;txt;mp3;mp4;midi:","2097152","/Knigi/Fjentezi/","/Knigi/","1","0");
INSERT INTO obmennik_dir VALUES("21","0","Любовные Романы","jar;rar;zip;pdf;fb2;doc;jad;rtf;txt;mp3;mp4;midi:","2097152","/Knigi/Ljybovnye_romany/","/Knigi/","1","0");
INSERT INTO obmennik_dir VALUES("22","0","Детективы","jar;rar;zip;pdf;fb2;doc;jad;rtf;txt;mp3;mp4;midi:","2097152","/Knigi/Detektivy/","/Knigi/","1","0");
INSERT INTO obmennik_dir VALUES("23","0","Боевики","jar;rar;zip;pdf;fb2;doc;jad;rtf;txt;mp3;mp4;midi:","2097152","/Knigi/Boeviki/","/Knigi/","1","0");
INSERT INTO obmennik_dir VALUES("24","0","Приключения","jar;rar;zip;pdf;fb2;doc;jad;rtf;txt;mp3;mp4;midi:","2097152","/Knigi/Prikljychenija/","/Knigi/","1","0");
INSERT INTO obmennik_dir VALUES("25","0","Ужасы","jar;rar;zip;pdf;fb2;doc;jad;rtf;txt;mp3;mp4;midi:","2097152","/Knigi/Uzhasy/","/Knigi/","1","0");
INSERT INTO obmennik_dir VALUES("26","0","Разное","jar;rar;zip;pdf;fb2;doc;jad;rtf;txt;mp3;mp4;midi:","2097152","/Knigi/Raznoe/","/Knigi/","1","0");
INSERT INTO obmennik_dir VALUES("27","0","Детские сказки","jar;rar;zip;pdf;fb2;doc;jad;rtf;txt;mp3;mp4;midi:","2097152","/Knigi/Detskie_skazki/","/Knigi/","1","0");
INSERT INTO obmennik_dir VALUES("28","0","Бизнес","jar;rar;zip;pdf;fb2;doc;jad;rtf;txt;mp3;mp4;midi:","2097152","/Knigi/Biznes/","/Knigi/","1","0");
INSERT INTO obmennik_dir VALUES("29","0","Книги по Фильму","jar;rar;zip;pdf;fb2;doc;jad;rtf;txt;mp3;mp4;midi:","2097152","/Knigi/Knigi_po_film/","/Knigi/","1","0");
INSERT INTO obmennik_dir VALUES("30","0","Дом Семья Здоровье","jar;rar;zip;pdf;fb2;doc;jad;rtf;txt;mp3;mp4;midi:","2097152","/Knigi/Dom_Semja_Zdorove/","/Knigi/","1","0");
INSERT INTO obmennik_dir VALUES("31","0","Компьютеры и Интернет","jar;rar;zip;pdf;fb2;doc;jad;rtf;txt;mp3;mp4;midi:","2097152","/Knigi/Kompjytery_i_Internet/","/Knigi/","1","0");
INSERT INTO obmennik_dir VALUES("32","0","Русская Классика","jar;rar;zip;pdf;fb2;doc;jad;rtf;txt;mp3;mp4;midi:","2097152","/Knigi/Russkaja_klassika/","/Knigi/","1","0");
INSERT INTO obmennik_dir VALUES("33","0","Русская и Зарубежная Поэзия","jar;rar;zip;pdf;fb2;doc;jad;rtf;txt;mp3;mp4;midi:","2097152","/Knigi/Russkaja_i_zarubezhnaja_pojezija/","/Knigi/","1","0");
INSERT INTO obmennik_dir VALUES("34","0","Справочники Энциклопедии","jar;rar;zip;pdf;fb2;doc;jad;rtf;txt;mp3;mp4;midi:","2097152","/Knigi/Spravochniki_Jenciklopedii/","/Knigi/","1","0");
INSERT INTO obmennik_dir VALUES("35","0","Наука Образование","jar;rar;zip;pdf;fb2;doc;jad;rtf;txt;mp3;mp4;midi:","2097152","/Knigi/Nauka_Obrazovanie/","/Knigi/","1","0");
INSERT INTO obmennik_dir VALUES("36","0","Документальное","jar;rar;zip;pdf;fb2;doc;jad;rtf;txt;mp3;mp4;midi:","2097152","/Knigi/Dokumentalnoe/","/Knigi/","1","0");
INSERT INTO obmennik_dir VALUES("37","0","Юмор","jar;rar;zip;pdf;fb2;doc;jad;rtf;txt;mp3;mp4;midi:","2097152","/Knigi/Jymor/","/Knigi/","1","0");
INSERT INTO obmennik_dir VALUES("39","0","Для SMS","mp3;mp4;midi;amr;wav:","10485760","/Audio/Dlja_SMS/","/Audio/","1","0");
INSERT INTO obmennik_dir VALUES("40","0","Звонки","mp3;mp4;midi;amr;wav:","10485760","/Audio/Zvonki/","/Audio/","1","0");
INSERT INTO obmennik_dir VALUES("41","0","Звонки по именам (жен)","mp3;mp4;midi;amr;wav:","10485760","/Audio/Zvonki_po_imenam_(zhen)/","/Audio/","1","0");
INSERT INTO obmennik_dir VALUES("42","0","Звонки по именам (муж)","mp3;mp4;midi;amr;wav:","10485760","/Audio/Zvonki_po_imenam_(muzh)/","/Audio/","1","0");
INSERT INTO obmennik_dir VALUES("43","0","Звуки животных","mp3;mp4;midi;amr;wav:","10485760","/Audio/Zvuki_zhivotnyh/","/Audio/","1","0");
INSERT INTO obmennik_dir VALUES("44","0","Звуки людей","mp3;mp4;midi;amr;wav:","10485760","/Audio/Zvuki_ljydej/","/Audio/","1","0");
INSERT INTO obmennik_dir VALUES("45","0","Из мультиков","mp3;mp4;midi;amr;wav:","10485760","/Audio/Iz_multikov/","/Audio/","1","0");
INSERT INTO obmennik_dir VALUES("46","0","Из фильмов","mp3;mp4;midi;amr;wav:","10485760","/Audio/Iz_filmov/","/Audio/","1","0");
INSERT INTO obmennik_dir VALUES("47","0","Разное","mp3;mp4;midi;amr;wav:","10485760","/Audio/Raznoe/","/Audio/","1","0");
INSERT INTO obmennik_dir VALUES("48","0","Розыгрыши","mp3;mp4;midi;amr;wav:","10485760","/Audio/Rozygryshi/","/Audio/","1","0");
INSERT INTO obmennik_dir VALUES("49","0","Юмор Приколы","mp3;mp4;midi;amr;wav:","10485760","/Audio/Jymor_Prikoly/","/Audio/","1","0");
INSERT INTO obmennik_dir VALUES("102","0","Drum n Bass","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Drum_n_Bass/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("130","0","Авто-Мото-Техника","jpg;gif;png;jpeg:","5242880","/Kartinki/Avto-Moto-Tehnika/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("52","0","Авто-Мото-Техника","3gp;mp4;avi;flv;wmv;wav:","52428800","/Video/Avto-Moto-Tehnika/","/Video/","1","0");
INSERT INTO obmennik_dir VALUES("53","0","Видео-Клипы","3gp;mp4;avi;flv;wmv;wav:","52428800","/Video/Video-Klipy/","/Video/","1","0");
INSERT INTO obmennik_dir VALUES("54","0","Знаменитости","3gp;mp4;avi;flv;wmv;wav:","52428800","/Video/Znamenitosti/","/Video/","1","0");
INSERT INTO obmennik_dir VALUES("55","0","Из фильмов","3gp;mp4;avi;flv;wmv;wav:","52428800","/Video/Iz_filmov/","/Video/","1","0");
INSERT INTO obmennik_dir VALUES("56","0","Из мультиков","3gp;mp4;avi;flv;wmv;wav:","52428800","/Video/Iz_multikov/","/Video/","1","0");
INSERT INTO obmennik_dir VALUES("57","0","Проишествия","3gp;mp4;avi;flv;wmv;wav:","52428800","/Video/Proishestvija/","/Video/","1","0");
INSERT INTO obmennik_dir VALUES("58","0","Разное","3gp;mp4;avi;flv;wmv;wav:","52428800","/Video/Raznoe/","/Video/","1","0");
INSERT INTO obmennik_dir VALUES("59","0","Спорт","3gp;mp4;avi;flv;wmv;wav:","52428800","/Video/Sport/","/Video/","1","0");
INSERT INTO obmennik_dir VALUES("60","0","Юмор-Приколы","3gp;mp4;avi;flv;wmv;wav:","52428800","/Video/Jymor-Prikoly/","/Video/","1","0");
INSERT INTO obmennik_dir VALUES("61","0","Мой видео портрет(Ж)","3gp;mp4;avi;flv;wmv;wav:","52428800","/Video/Moj_video_portret(ZH)/","/Video/","1","0");
INSERT INTO obmennik_dir VALUES("62","0","Мой видео портрет(М)","3gp;mp4;avi;flv;wmv;wav:","52428800","/Video/Moj_video_portret(M)/","/Video/","1","0");
INSERT INTO obmennik_dir VALUES("63","0","Это Интересно","3gp;mp4;avi;flv;wmv;wav:","52428800","/Video/Jeto_Interesno/","/Video/","1","0");
INSERT INTO obmennik_dir VALUES("198","0","Java","jar;jad;zip;sis;sisx:","52428800","/Programmy/Java/","/Programmy/","1","0");
INSERT INTO obmennik_dir VALUES("65","0","iPhone","","0","/Igry/iPhone/","/Igry/","0","0");
INSERT INTO obmennik_dir VALUES("66","0","Аndroid","","0","/Igry/Android/","/Igry/","0","0");
INSERT INTO obmennik_dir VALUES("67","0","Java игры","","0","/Igry/Java_igry/","/Igry/","0","0");
INSERT INTO obmennik_dir VALUES("68","0","Symbian","","0","/Igry/Symbian/","/Igry/","0","0");
INSERT INTO obmennik_dir VALUES("69","0","Игры для ПК","","0","/Igry/Igry_dlja_PK/","/Igry/","0","0");
INSERT INTO obmennik_dir VALUES("70","0","Action","jar;jad;sis;zip;rar;ipa:","10485760","/Igry/iPhone/Action/","/Igry/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("71","0","PRG","jar;jad;sis;zip;rar;ipa:","10485760","/Igry/iPhone/PRG/","/Igry/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("72","0","Азартные","jar;jad;sis;zip;rar;ipa:","10485760","/Igry/iPhone/Azartnye/","/Igry/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("73","0","Аркады","jar;jad;sis;zip;rar;ipa:","10485760","/Igry/iPhone/Arkady/","/Igry/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("74","0","Гонки","jar;jad;sis;zip;rar;ipa:","10485760","/Igry/iPhone/Gonki/","/Igry/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("75","0","Драки","jar;jad;sis;zip;rar;ipa:","10485760","/Igry/iPhone/Draki/","/Igry/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("76","0","Квесты - Приключения","jar;jad;sis;zip;rar;ipa:","10485760","/Igry/iPhone/Kvesty_-_Prikljychenija/","/Igry/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("77","0","Леталки","jar;jad;sis;zip;rar;ipa:","10485760","/Igry/iPhone/Letalki/","/Igry/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("78","0","Логические","jar;jad;sis;zip;rar;ipa:","10485760","/Igry/iPhone/Logicheskie/","/Igry/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("79","0","Настольные","jar;jad;sis;zip;rar;ipa:","10485760","/Igry/iPhone/Nastolnye/","/Igry/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("80","0","Прочие","jar;jad;sis;zip;rar;ipa:","10485760","/Igry/iPhone/Prochie/","/Igry/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("81","0","Симуляторы","jar;jad;sis;zip;rar;ipa:","10485760","/Igry/iPhone/Simuljatory/","/Igry/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("82","0","Спорт","jar;jad;sis;zip;rar;ipa:","10485760","/Igry/iPhone/Sport/","/Igry/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("83","0","Стратегии","jar;jad;sis;zip;rar;ipa:","10485760","/Igry/iPhone/Strategii/","/Igry/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("84","0","Стрелялки","jar;jad;sis;zip;rar;ipa:","10485760","/Igry/iPhone/Streljalki/","/Igry/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("85","0","Action","jar;jad;sis;zip;rar;ipa:","52428800","/Igry/Java_igry/Action/","/Igry/Java_igry/","1","0");
INSERT INTO obmennik_dir VALUES("86","0","PRG","jar;jad;sis;zip;rar;ipa:","52428800","/Igry/Java_igry/PRG/","/Igry/Java_igry/","1","0");
INSERT INTO obmennik_dir VALUES("87","0","Азартные","jar;jad;sis;zip;rar;ipa:","52428800","/Igry/Java_igry/Azartnye/","/Igry/Java_igry/","1","0");
INSERT INTO obmennik_dir VALUES("88","0","Аркады","jar;jad;sis;zip;rar;ipa:","52428800","/Igry/Java_igry/Arkady/","/Igry/Java_igry/","1","0");
INSERT INTO obmennik_dir VALUES("89","0","Гонки","jar;jad;sis;zip;rar;ipa:","52428800","/Igry/Java_igry/Gonki/","/Igry/Java_igry/","1","0");
INSERT INTO obmennik_dir VALUES("90","0","Драки","jar;jad;sis;zip;rar;ipa:","52428800","/Igry/Java_igry/Draki/","/Igry/Java_igry/","1","0");
INSERT INTO obmennik_dir VALUES("91","0","Квесты - Приключения","jar;jad;sis;zip;rar;ipa:","52428800","/Igry/Java_igry/Kvesty_-_Prikljychenija/","/Igry/Java_igry/","1","0");
INSERT INTO obmennik_dir VALUES("92","0","Леталки","jar;jad;sis;zip;rar;ipa:","52428800","/Igry/Java_igry/Letalki/","/Igry/Java_igry/","1","0");
INSERT INTO obmennik_dir VALUES("93","0","Логические","jar;jad;sis;zip;rar;ipa:","52428800","/Igry/Java_igry/Logicheskie/","/Igry/Java_igry/","1","0");
INSERT INTO obmennik_dir VALUES("94","0","Настольные","jar;jad;sis;zip;rar;ipa:","52428800","/Igry/Java_igry/Nastolnye/","/Igry/Java_igry/","1","0");
INSERT INTO obmennik_dir VALUES("95","0","Симуляторы","jar;jad;sis;zip;rar;ipa:","52428800","/Igry/Java_igry/Simuljatory/","/Igry/Java_igry/","1","0");
INSERT INTO obmennik_dir VALUES("96","0","Спорт","jar;jad;sis;zip;rar;ipa:","52428800","/Igry/Java_igry/Sport/","/Igry/Java_igry/","1","0");
INSERT INTO obmennik_dir VALUES("97","0","Стратегии","jar;jad;sis;zip;rar;ipa:","52428800","/Igry/Java_igry/Strategii/","/Igry/Java_igry/","1","0");
INSERT INTO obmennik_dir VALUES("98","0","Стрелялки","jar;jad;sis;zip;rar;ipa:","52428800","/Igry/Java_igry/Streljalki/","/Igry/Java_igry/","1","0");
INSERT INTO obmennik_dir VALUES("106","0","R n B","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/R_n_B/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("100","0","Экшены","jar;jad;sis;zip;rar;ipa:","52428800","/Igry/Java_igry/Jeksheny/","/Igry/Java_igry/","1","0");
INSERT INTO obmennik_dir VALUES("107","0","RAP-Hip-Hop","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/RAP-Hip-Hop/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("108","0","Rock","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Rock/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("109","0","Sound track","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Sound_track/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("110","0","Альтернатива","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Alternativa/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("111","0","Дискотека 80-х","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Diskoteka_80-h/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("112","0","Eurodance","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Evrodens/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("113","0","Из Игр","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Iz_Igr/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("114","0","Из мультиков","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Iz_multikov/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("115","0","Из фильмов","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Iz_filmov/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("116","0","Классика","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Klassika/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("117","0","Клубняк","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Klubnjak/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("118","0","Медитативная","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Meditativnaja/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("119","0","Минусовки-Караоке","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Minusovki-Karaoke/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("120","0","Мрачная","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Mrachnaja/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("121","0","Под Гитару","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Pod_Gitaru/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("122","0","Разное","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Raznoe/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("123","0","РЕП","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/REP/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("124","0","Русский Rock","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Russkij_Rock/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("125","0","Русский РОР","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Russkij_ROR/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("126","0","Спокойная","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Spokojnaja/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("127","0","Танцевальная","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Tancevalnaja/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("128","0","Шансон","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/SHanson/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("129","0","Электронная","mp3;mp4;midi;amr;wav:","52428800","/Muzyka/Jelektronnaja/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("131","0","Аниме","jpg;gif;png;jpeg:","5242880","/Kartinki/Anime/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("132","0","Демотиваторы","jpg;gif;png;jpeg:","5242880","/Kartinki/Demotivatory/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("133","0","Дети","jpg;gif;png;jpeg:","5242880","/Kartinki/Deti/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("134","0","Еда и Выпивка","jpg;gif;png;jpeg:","5242880","/Kartinki/Eda_i_Vypivka/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("135","0","Животный Мир","jpg;gif;png;jpeg:","5242880","/Kartinki/ZHivotnyj_Mir/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("136","0","Знаменитости","jpg;gif;png;jpeg:","5242880","/Kartinki/Znamenitosti/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("137","0","Из Игр","jpg;gif;png;jpeg:","5242880","/Kartinki/Iz_Igr/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("138","0","Из Музыки","jpg;gif;png;jpeg:","5242880","/Kartinki/Iz_Muzyki/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("139","0","Из Мультиков","jpg;gif;png;jpeg:","5242880","/Kartinki/Iz_Multikov/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("140","0","Из Фильмов","jpg;gif;png;jpeg:","5242880","/Kartinki/Iz_Filmov/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("141","0","Космос","jpg;gif;png;jpeg:","5242880","/Kartinki/Kosmos/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("142","0","Лого","jpg;gif;png;jpeg:","5242880","/Kartinki/Logo/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("143","0","Люди - Лица","jpg;gif;png;jpeg:","5242880","/Kartinki/Ljydi_-_Lica/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("144","0","Надписи и Пожелания","jpg;gif;png;jpeg:","5242880","/Kartinki/Nadpisi_i_Pozhelanija/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("145","0","Обои для ПК","jpg;gif;png;jpeg:","5242880","/Kartinki/Oboi_dlja_PK/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("146","0","Отдых Путешествия","jpg;gif;png;jpeg:","5242880","/Kartinki/Otdyh_Puteshestvija/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("147","0","Полезные Вещи","jpg;gif;png;jpeg:","5242880","/Kartinki/Poleznye_Veschi/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("148","0","Праздники","jpg;gif;png;jpeg:","5242880","/Kartinki/Prazdniki/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("149","0","Приколы","jpg;gif;png;jpeg:","5242880","/Kartinki/Prikoly/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("150","0","Природа","jpg;gif;png;jpeg:","5242880","/Kartinki/Priroda/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("151","0","Про Любовь","jpg;gif;png;jpeg:","5242880","/Kartinki/Pro_Ljybov/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("152","0","Ужасы","jpg;gif;png;jpeg:","5242880","/Kartinki/Uzhasy/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("153","0","Фентези","jpg;gif;png;jpeg:","5242880","/Kartinki/Fentezi/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("154","0","Цветы","jpg;gif;png;jpeg:","5242880","/Kartinki/Cvety/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("155","0","Action","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Symbian/Action/","/Igry/Symbian/","1","0");
INSERT INTO obmennik_dir VALUES("156","0","PRG","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Symbian/PRG/","/Igry/Symbian/","1","0");
INSERT INTO obmennik_dir VALUES("157","0","Азартные","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Symbian/Azartnye/","/Igry/Symbian/","1","0");
INSERT INTO obmennik_dir VALUES("158","0","Аркады","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Symbian/Arkady/","/Igry/Symbian/","1","0");
INSERT INTO obmennik_dir VALUES("159","0","Гонки","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Symbian/Gonki/","/Igry/Symbian/","1","0");
INSERT INTO obmennik_dir VALUES("160","0","Драки","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Symbian/Draki/","/Igry/Symbian/","1","0");
INSERT INTO obmennik_dir VALUES("161","0","Квесты-Приключения","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Symbian/Kvesty-Prikljychenija/","/Igry/Symbian/","1","0");
INSERT INTO obmennik_dir VALUES("162","0","Леталки","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Symbian/Letalki/","/Igry/Symbian/","1","0");
INSERT INTO obmennik_dir VALUES("163","0","Логические","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Symbian/Logicheskie/","/Igry/Symbian/","1","0");
INSERT INTO obmennik_dir VALUES("164","0","Настольные","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Symbian/Nastolnye/","/Igry/Symbian/","1","0");
INSERT INTO obmennik_dir VALUES("165","0","Симуляторы","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Symbian/Simuljatory/","/Igry/Symbian/","1","0");
INSERT INTO obmennik_dir VALUES("166","0","Спорт","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Symbian/Sport/","/Igry/Symbian/","1","0");
INSERT INTO obmennik_dir VALUES("167","0","Стратегии","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Symbian/Strategii/","/Igry/Symbian/","1","0");
INSERT INTO obmennik_dir VALUES("168","0","Action","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Android/Action/","/Igry/Android/","1","0");
INSERT INTO obmennik_dir VALUES("169","0","PRG","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Android/PRG/","/Igry/Android/","1","0");
INSERT INTO obmennik_dir VALUES("170","0","Азартные","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Android/Azartnye/","/Igry/Android/","1","0");
INSERT INTO obmennik_dir VALUES("171","0","Аркады","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Android/Arkady/","/Igry/Android/","1","0");
INSERT INTO obmennik_dir VALUES("172","0","Гонки","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Android/Gonki/","/Igry/Android/","1","0");
INSERT INTO obmennik_dir VALUES("173","0","Драки","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Android/Draki/","/Igry/Android/","1","0");
INSERT INTO obmennik_dir VALUES("174","0","Квесты-Приключения","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Android/Kvesty-Prikljychenija/","/Igry/Android/","1","0");
INSERT INTO obmennik_dir VALUES("175","0","Леталки","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Android/Letalki/","/Igry/Android/","1","0");
INSERT INTO obmennik_dir VALUES("176","0","Логические","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Android/Logicheskie/","/Igry/Android/","1","0");
INSERT INTO obmennik_dir VALUES("177","0","Настольные","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Android/Nastolnye/","/Igry/Android/","1","0");
INSERT INTO obmennik_dir VALUES("178","0","Симуляторы","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Android/Simuljatory/","/Igry/Android/","1","0");
INSERT INTO obmennik_dir VALUES("179","0","Спорт","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Android/Sport/","/Igry/Android/","1","0");
INSERT INTO obmennik_dir VALUES("180","0","Стратегии","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Android/Strategii/","/Igry/Android/","1","0");
INSERT INTO obmennik_dir VALUES("181","0","Стрелялки","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Android/Streljalki/","/Igry/Android/","1","0");
INSERT INTO obmennik_dir VALUES("182","0","Экшены","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Android/Jeksheny/","/Igry/Android/","1","0");
INSERT INTO obmennik_dir VALUES("183","0","Аction","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Igry_dlja_PK/Action/","/Igry/Igry_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("184","0","PRG","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Igry_dlja_PK/PRG/","/Igry/Igry_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("185","0","Азартные","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Igry_dlja_PK/Azartnye/","/Igry/Igry_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("186","0","Аркады","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Igry_dlja_PK/Arkady/","/Igry/Igry_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("187","0","Гонки","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Igry_dlja_PK/Gonki/","/Igry/Igry_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("188","0","Драки","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Igry_dlja_PK/Draki/","/Igry/Igry_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("189","0","Квесты-Приключения","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Igry_dlja_PK/Kvesty-Prikljychenija/","/Igry/Igry_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("190","0","Леталки","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Igry_dlja_PK/Letalki/","/Igry/Igry_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("191","0","Логические","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Igry_dlja_PK/Logicheskie/","/Igry/Igry_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("192","0","Настольные","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Igry_dlja_PK/Nastolnye/","/Igry/Igry_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("193","0","Симуляторы","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Igry_dlja_PK/Simuljatory/","/Igry/Igry_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("194","0","Спорт","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Igry_dlja_PK/Sport/","/Igry/Igry_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("195","0","Стратегии","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Igry_dlja_PK/Strategii/","/Igry/Igry_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("196","0","Стрелялки","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Igry_dlja_PK/Streljalki/","/Igry/Igry_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("197","0","Экшены","jar;jad;sis;zip;rar;ipa;sisx:","52428800","/Igry/Igry_dlja_PK/Jeksheny/","/Igry/Igry_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("199","0","Simbian","jar;jad;zip;sis;sisx:exe;ipa;rar;apk;7-Zip:","52428800","/Programmy/Simbian/","/Programmy/","1","0");
INSERT INTO obmennik_dir VALUES("200","0","Аndroid","jar;jad;zip;sis;sisx:","52428800","/Programmy/Android/","/Programmy/","1","0");
INSERT INTO obmennik_dir VALUES("201","0","Windows Mobile","jar;jad;zip;sis;sisx:","52428800","/Programmy/Windows_Mobile/","/Programmy/","1","0");
INSERT INTO obmennik_dir VALUES("202","0","Bada","jar;jad;zip;sis;sisx:","52428800","/Programmy/Bada/","/Programmy/","1","0");
INSERT INTO obmennik_dir VALUES("203","0","iPhone","jar;jad;zip;sis;sisx:","52428800","/Programmy/iPhone/","/Programmy/","1","0");
INSERT INTO obmennik_dir VALUES("204","0","Безопасность","jar;jad;zip;sis;sisx:","52428800","/Programmy/Bada/Bezopasnost/","/Programmy/Bada/","1","0");
INSERT INTO obmennik_dir VALUES("205","0","Интернет","jar;jad;zip;sis;sisx:","52428800","/Programmy/Bada/Internet/","/Programmy/Bada/","1","0");
INSERT INTO obmennik_dir VALUES("206","0","Мессенджеры","jar;jad;zip;sis;sisx:","52428800","/Programmy/Bada/Messendzhery/","/Programmy/Bada/","1","0");
INSERT INTO obmennik_dir VALUES("207","0","Карты и схемы","jar;jad;zip;sis;sisx:","52428800","/Programmy/Bada/Karty_i_shemy/","/Programmy/Bada/","1","0");
INSERT INTO obmennik_dir VALUES("208","0","Мультимедия","jar;jad;zip;sis;sisx:","52428800","/Programmy/Bada/Multimedija/","/Programmy/Bada/","1","0");
INSERT INTO obmennik_dir VALUES("209","0","Офис","jar;jad;zip;sis;sisx:","52428800","/Programmy/Bada/Ofis/","/Programmy/Bada/","1","0");
INSERT INTO obmennik_dir VALUES("210","0","Система","jar;jad;zip;sis;sisx:","52428800","/Programmy/Bada/Sistema/","/Programmy/Bada/","1","0");
INSERT INTO obmennik_dir VALUES("211","0","Шрифты","jar;jad;zip;sis;sisx:","52428800","/Programmy/Bada/SHrifty/","/Programmy/Bada/","1","0");
INSERT INTO obmennik_dir VALUES("212","0","Разное","jar;jad;zip;sis;sisx:","52428800","/Programmy/Bada/Raznoe/","/Programmy/Bada/","1","0");
INSERT INTO obmennik_dir VALUES("213","0","Аудио Видео","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip:","52428800","/Programmy_dlja_PK/Audio_Video/","/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("214","0","Графика Дизайн","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip:","52428800","/Programmy_dlja_PK/Grafika_Dizajn/","/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("215","0","Безопасность","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip:","52428800","/Programmy_dlja_PK/Bezopasnost/","/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("216","0","Игры и развлечения","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip:","52428800","/Programmy_dlja_PK/Igry_i_razvlechenija/","/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("217","0","Интернет Почта","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip:","52428800","/Programmy_dlja_PK/Internet_Pochta/","/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("218","0","Карты и схемы","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip:","52428800","/Programmy_dlja_PK/Karty_i_shemy/","/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("219","0","Мессенджеры","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip:","52428800","/Programmy_dlja_PK/Messendzhery/","/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("220","0","Мобильная связь","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip:","52428800","/Programmy_dlja_PK/Mobilnaja_svjaz/","/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("221","0","Образование","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip:","52428800","/Programmy_dlja_PK/Obrazovanie/","/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("222","0","Офис","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip:","52428800","/Programmy_dlja_PK/Ofis/","/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("223","0","Словари Инфо","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip:","52428800","/Programmy_dlja_PK/Slovari_Info/","/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("224","0","Система","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip:","52428800","/Programmy_dlja_PK/Sistema/","/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("225","0","Оформление Темы","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip:","52428800","/Programmy_dlja_PK/Oformlenie_Temy/","/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("226","0","Разное","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip:","52428800","/Programmy_dlja_PK/Raznoe/","/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("227","0","Безопасность","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/iPhone/Bezopasnost/","/Programmy/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("228","0","Интернет Почта","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/iPhone/Internet_Pochta/","/Programmy/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("229","0","Карты и схемы","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/iPhone/Karty_i_shemy/","/Programmy/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("230","0","Мессенджеры","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/iPhone/Messendzhery/","/Programmy/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("231","0","Мультимедия","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/iPhone/Multimedija/","/Programmy/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("232","0","Офис","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/iPhone/Ofis/","/Programmy/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("233","0","Система","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/iPhone/Sistema/","/Programmy/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("234","0","Разное","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/iPhone/Raznoe/","/Programmy/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("235","0","Шрифты","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/iPhone/SHrifty/","/Programmy/iPhone/","1","0");
INSERT INTO obmennik_dir VALUES("236","0","Безопасность","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Java/Bezopasnost/","/Programmy/Java/","1","0");
INSERT INTO obmennik_dir VALUES("237","0","Интернет Почта","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Java/Internet_Pochta/","/Programmy/Java/","1","0");
INSERT INTO obmennik_dir VALUES("238","0","Карты и схемы","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Java/Karty_i_shemy/","/Programmy/Java/","1","0");
INSERT INTO obmennik_dir VALUES("239","0","Мессенджеры","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Java/Messendzhery/","/Programmy/Java/","1","0");
INSERT INTO obmennik_dir VALUES("240","0","Мультимедия","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Java/Multimedija/","/Programmy/Java/","1","0");
INSERT INTO obmennik_dir VALUES("241","0","Офис","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Java/Ofis/","/Programmy/Java/","1","0");
INSERT INTO obmennik_dir VALUES("242","0","Разное","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Java/Raznoe/","/Programmy/Java/","1","0");
INSERT INTO obmennik_dir VALUES("243","0","Система","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Java/Sistema/","/Programmy/Java/","1","0");
INSERT INTO obmennik_dir VALUES("244","0","Шрифты","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Java/SHrifty/","/Programmy/Java/","1","0");
INSERT INTO obmennik_dir VALUES("245","0","Безопасность","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Simbian/Bezopasnost/","/Programmy/Simbian/","1","0");
INSERT INTO obmennik_dir VALUES("246","0","Интернет Почта","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Simbian/Internet_Pochta/","/Programmy/Simbian/","1","0");
INSERT INTO obmennik_dir VALUES("247","0","Карты и схемы","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Simbian/Karty_i_shemy/","/Programmy/Simbian/","1","0");
INSERT INTO obmennik_dir VALUES("248","0","Мессенджеры","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Simbian/Messendzhery/","/Programmy/Simbian/","1","0");
INSERT INTO obmennik_dir VALUES("249","0","Мультимедия","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Simbian/Multimedija/","/Programmy/Simbian/","1","0");
INSERT INTO obmennik_dir VALUES("250","0","Офис","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Simbian/Ofis/","/Programmy/Simbian/","1","0");
INSERT INTO obmennik_dir VALUES("251","0","Разное","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Simbian/Raznoe/","/Programmy/Simbian/","1","0");
INSERT INTO obmennik_dir VALUES("252","0","Система","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Simbian/Sistema/","/Programmy/Simbian/","1","0");
INSERT INTO obmennik_dir VALUES("253","0","Шрифты","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Simbian/SHrifty/","/Programmy/Simbian/","1","0");
INSERT INTO obmennik_dir VALUES("254","0","Безопасность","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Windows_Mobile/Bezopasnost/","/Programmy/Windows_Mobile/","1","0");
INSERT INTO obmennik_dir VALUES("255","0","Интернет","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Windows_Mobile/Internet/","/Programmy/Windows_Mobile/","1","0");
INSERT INTO obmennik_dir VALUES("256","0","Карты и схемы","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Windows_Mobile/Karty_i_shemy/","/Programmy/Windows_Mobile/","1","0");
INSERT INTO obmennik_dir VALUES("257","0","Мессенджеры","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Windows_Mobile/Messendzhery/","/Programmy/Windows_Mobile/","1","0");
INSERT INTO obmennik_dir VALUES("258","0","Мультимедия","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Windows_Mobile/Multimedija/","/Programmy/Windows_Mobile/","1","0");
INSERT INTO obmennik_dir VALUES("259","0","Офис","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Windows_Mobile/Ofis/","/Programmy/Windows_Mobile/","1","0");
INSERT INTO obmennik_dir VALUES("260","0","Система","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Windows_Mobile/Sistema/","/Programmy/Windows_Mobile/","1","0");
INSERT INTO obmennik_dir VALUES("261","0","Разное","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Windows_Mobile/Raznoe/","/Programmy/Windows_Mobile/","1","0");
INSERT INTO obmennik_dir VALUES("262","0","Шрифты","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Windows_Mobile/SHrifty/","/Programmy/Windows_Mobile/","1","0");
INSERT INTO obmennik_dir VALUES("263","0","Безопасность","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Android/Bezopasnost/","/Programmy/Android/","1","0");
INSERT INTO obmennik_dir VALUES("264","0","Интернет","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Android/Internet/","/Programmy/Android/","1","0");
INSERT INTO obmennik_dir VALUES("265","0","Карты и схемы","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Android/Karty_i_shemy/","/Programmy/Android/","1","0");
INSERT INTO obmennik_dir VALUES("266","0","Мессенджеры","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Android/Messendzhery/","/Programmy/Android/","1","0");
INSERT INTO obmennik_dir VALUES("267","0","Мультимедия","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Android/Multimedija/","/Programmy/Android/","1","0");
INSERT INTO obmennik_dir VALUES("268","0","Офис","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Android/Ofis/","/Programmy/Android/","1","0");
INSERT INTO obmennik_dir VALUES("269","0","Система","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Android/Sistema/","/Programmy/Android/","1","0");
INSERT INTO obmennik_dir VALUES("270","0","Разное","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Android/Raznoe/","/Programmy/Android/","1","0");
INSERT INTO obmennik_dir VALUES("271","0","Шрифты","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;sis;sisx:","52428800","/Programmy/Android/SHrifty/","/Programmy/Android/","1","0");
INSERT INTO obmennik_dir VALUES("272","0","Видео","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;gif;txt;doc;mp3;jpg;jpeg;gif;png;mp4;docx;flv;amr;pdf;3gp;avi:","52428800","/Tvorchestvo_obitatelej/Video/","/Tvorchestvo_obitatelej/","1","0");
INSERT INTO obmennik_dir VALUES("273","0","Музыка","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;gif;txt;doc;mp3;jpg;jpeg;gif;png;mp4;docx;flv;amr;pdf;3gp;avi:","52428800","/Tvorchestvo_obitatelej/Muzyka/","/Tvorchestvo_obitatelej/","1","0");
INSERT INTO obmennik_dir VALUES("274","0","Стихи","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;gif;txt;doc;mp3;jpg;jpeg;gif;png;mp4;docx;flv;amr;pdf;3gp;avi:","52428800","/Tvorchestvo_obitatelej/Stihi/","/Tvorchestvo_obitatelej/","1","0");
INSERT INTO obmennik_dir VALUES("275","0","Проза","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;gif;txt;doc;mp3;jpg;jpeg;gif;png;mp4;docx;flv;amr;pdf;3gp;avi:","52428800","/Tvorchestvo_obitatelej/Proza/","/Tvorchestvo_obitatelej/","1","0");
INSERT INTO obmennik_dir VALUES("276","0","Дизайн Рисунки","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;gif;txt;doc;mp3;jpg;jpeg;gif;png;mp4;docx;flv;amr;pdf;3gp;avi:","52428800","/Tvorchestvo_obitatelej/Dizajn_Risunki/","/Tvorchestvo_obitatelej/","1","0");
INSERT INTO obmennik_dir VALUES("277","0","Прочее","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;gif;txt;doc;mp3;jpg;jpeg;gif;png;mp4;docx;flv;amr;pdf;3gp;avi:","52428800","/Tvorchestvo_obitatelej/Prochee/","/Tvorchestvo_obitatelej/","1","0");
INSERT INTO obmennik_dir VALUES("278","0","Simbian","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;gif;txt;doc;mp3;jpg;jpeg;gif;png;mp4;docx;flv;amr;pdf;3gp;avi;cab;tsk;thm;nth;swf:","0","/Temy/Simbian/","/Temy/","0","0");
INSERT INTO obmennik_dir VALUES("279","0","Java","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;gif;txt;doc;mp3;jpg;jpeg;gif;png;mp4;docx;flv;amr;pdf;3gp;avi;cab;tsk;thm;nth;swf:","0","/Temy/Java/","/Temy/","0","0");
INSERT INTO obmennik_dir VALUES("280","0","Аndroid","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;gif;txt;doc;mp3;jpg;jpeg;gif;png;mp4;docx;flv;amr;pdf;3gp;avi;cab;tsk;thm;nth;swf:","0","/Temy/Android/","/Temy/","0","0");
INSERT INTO obmennik_dir VALUES("281","0","Windows Mobile","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;gif;txt;doc;mp3;jpg;jpeg;gif;png;mp4;docx;flv;amr;pdf;3gp;avi;cab;tsk;thm;nth;swf:","0","/Temy/Windows_Mobile/","/Temy/","0","0");
INSERT INTO obmennik_dir VALUES("282","0","iPhone","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;gif;txt;doc;mp3;jpg;jpeg;gif;png;mp4;docx;flv;amr;pdf;3gp;avi;cab;tsk;thm;nth;swf:","0","/Temy/iPHONE/","/Temy/","0","0");
INSERT INTO obmennik_dir VALUES("283","0","Bada","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip;gif;txt;doc;mp3;jpg;jpeg;gif;png;mp4;docx;flv;amr;pdf;3gp;avi;cab;tsk;thm;nth;swf:","0","/Temy/Bada/","/Temy/","0","0");
INSERT INTO obmennik_dir VALUES("284","0","Абстракция","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/iPHONE/Abstrakcija/","/Temy/iPHONE/","1","0");
INSERT INTO obmennik_dir VALUES("285","0","Авто Мото","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/iPHONE/Avto_Moto/","/Temy/iPHONE/","1","0");
INSERT INTO obmennik_dir VALUES("286","0","Животный мир","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/iPHONE/ZHivotnyj_mir/","/Temy/iPHONE/","1","0");
INSERT INTO obmennik_dir VALUES("287","0","Кино Игры","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/iPHONE/Kino_Igry/","/Temy/iPHONE/","1","0");
INSERT INTO obmennik_dir VALUES("288","0","Любовь","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/iPHONE/Ljybov/","/Temy/iPHONE/","1","0");
INSERT INTO obmennik_dir VALUES("289","0","Природа","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/iPHONE/Priroda/","/Temy/iPHONE/","1","0");
INSERT INTO obmennik_dir VALUES("290","0","Спорт","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/iPHONE/Sport/","/Temy/iPHONE/","1","0");
INSERT INTO obmennik_dir VALUES("291","0","Фэнтези Фантастика","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/iPHONE/Fjentezi_Fantastika/","/Temy/iPHONE/","1","0");
INSERT INTO obmennik_dir VALUES("292","0","Эротика","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/iPHONE/Jerotika/","/Temy/iPHONE/","1","0");
INSERT INTO obmennik_dir VALUES("293","0","Разное","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/iPHONE/Raznoe/","/Temy/iPHONE/","1","0");
INSERT INTO obmennik_dir VALUES("294","0","Абстракции","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Bada/Abstrakcii/","/Temy/Bada/","1","0");
INSERT INTO obmennik_dir VALUES("295","0","Авто Мото","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Bada/Avto_Moto/","/Temy/Bada/","1","0");
INSERT INTO obmennik_dir VALUES("296","0","Животный мир","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Bada/ZHivotnyj_mir/","/Temy/Bada/","1","0");
INSERT INTO obmennik_dir VALUES("297","0","Кино Игры","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Bada/Kino_Igry/","/Temy/Bada/","1","0");
INSERT INTO obmennik_dir VALUES("298","0","Любовь","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Bada/Ljybov/","/Temy/Bada/","1","0");
INSERT INTO obmennik_dir VALUES("299","0","Природа","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Bada/Priroda/","/Temy/Bada/","1","0");
INSERT INTO obmennik_dir VALUES("300","0","Спорт","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Bada/Sport/","/Temy/Bada/","1","0");
INSERT INTO obmennik_dir VALUES("301","0","Эротика","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Bada/Jerotika/","/Temy/Bada/","1","0");
INSERT INTO obmennik_dir VALUES("302","0","Разное","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Bada/Raznoe/","/Temy/Bada/","1","0");
INSERT INTO obmennik_dir VALUES("303","0","Фэнтезф Фантастика","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Bada/Fjentezf_Fantastika/","/Temy/Bada/","1","0");
INSERT INTO obmennik_dir VALUES("304","0","Абстракции","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Java/Abstrakcii/","/Temy/Java/","1","0");
INSERT INTO obmennik_dir VALUES("305","0","Авто Мото","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Java/Avto_Moto/","/Temy/Java/","1","0");
INSERT INTO obmennik_dir VALUES("306","0","Животный мир","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Java/ZHivotnyj_mir/","/Temy/Java/","1","0");
INSERT INTO obmennik_dir VALUES("307","0","Природа","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Java/Priroda/","/Temy/Java/","1","0");
INSERT INTO obmennik_dir VALUES("308","0","Кино Игры","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Java/Kino_Igry/","/Temy/Java/","1","0");
INSERT INTO obmennik_dir VALUES("309","0","Любовь","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Java/Ljybov/","/Temy/Java/","1","0");
INSERT INTO obmennik_dir VALUES("310","0","Спорт","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Java/Sport/","/Temy/Java/","1","0");
INSERT INTO obmennik_dir VALUES("311","0","Фэнтези Фантастика","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Java/Fjentezi_Fantastika/","/Temy/Java/","1","0");
INSERT INTO obmennik_dir VALUES("312","0","Эротика","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Java/Jerotika/","/Temy/Java/","1","0");
INSERT INTO obmennik_dir VALUES("313","0","Разное","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Java/Raznoe/","/Temy/Java/","1","0");
INSERT INTO obmennik_dir VALUES("314","0","Абстракция","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Simbian/Abstrakcija/","/Temy/Simbian/","1","0");
INSERT INTO obmennik_dir VALUES("315","0","Авто Мото","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Simbian/Avto_Moto/","/Temy/Simbian/","1","0");
INSERT INTO obmennik_dir VALUES("316","0","Животный мир","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Simbian/ZHivotnyj_mir/","/Temy/Simbian/","1","0");
INSERT INTO obmennik_dir VALUES("317","0","Кино Игры","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Simbian/Kino_Igry/","/Temy/Simbian/","1","0");
INSERT INTO obmennik_dir VALUES("318","0","Природа","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Simbian/Priroda/","/Temy/Simbian/","1","0");
INSERT INTO obmennik_dir VALUES("319","0","Любовь","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Simbian/Ljybov/","/Temy/Simbian/","1","0");
INSERT INTO obmennik_dir VALUES("320","0","Спорт","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Simbian/Sport/","/Temy/Simbian/","1","0");
INSERT INTO obmennik_dir VALUES("321","0","Фэнтези Фантастика","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Simbian/Fjentezi_Fantastika/","/Temy/Simbian/","1","0");
INSERT INTO obmennik_dir VALUES("322","0","Эротика","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Simbian/Jerotika/","/Temy/Simbian/","1","0");
INSERT INTO obmennik_dir VALUES("323","0","Разное","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Simbian/Raznoe/","/Temy/Simbian/","1","0");
INSERT INTO obmennik_dir VALUES("324","0","Абстракция","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Windows_Mobile/Abstrakcija/","/Temy/Windows_Mobile/","1","0");
INSERT INTO obmennik_dir VALUES("325","0","Авто Мото","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Windows_Mobile/Avto_Moto/","/Temy/Windows_Mobile/","1","0");
INSERT INTO obmennik_dir VALUES("326","0","Животный мир","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Windows_Mobile/ZHivotnyj_mir/","/Temy/Windows_Mobile/","1","0");
INSERT INTO obmennik_dir VALUES("327","0","Кино Игры","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Windows_Mobile/Kino_Igry/","/Temy/Windows_Mobile/","1","0");
INSERT INTO obmennik_dir VALUES("328","0","Любовь","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Windows_Mobile/Ljybov/","/Temy/Windows_Mobile/","1","0");
INSERT INTO obmennik_dir VALUES("329","0","Спорт","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Windows_Mobile/Sport/","/Temy/Windows_Mobile/","1","0");
INSERT INTO obmennik_dir VALUES("330","0","Природа","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Windows_Mobile/Priroda/","/Temy/Windows_Mobile/","1","0");
INSERT INTO obmennik_dir VALUES("331","0","Фэнтези Фантастика","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Windows_Mobile/Fjentezi_Fantastika/","/Temy/Windows_Mobile/","1","0");
INSERT INTO obmennik_dir VALUES("332","0","Разное","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Windows_Mobile/Raznoe/","/Temy/Windows_Mobile/","1","0");
INSERT INTO obmennik_dir VALUES("333","0","Эротика","sisx;rar;sis;cab;tsk;thm;nth;zip:","52428800","/Temy/Windows_Mobile/Jerotika/","/Temy/Windows_Mobile/","1","0");
INSERT INTO obmennik_dir VALUES("334","0","Абстракция","sisx;rar;sis;cab;tsk;thm;nth;zip;apk;utz;smt:","52428800","/Temy/Android/Abstrakcija/","/Temy/Android/","1","0");
INSERT INTO obmennik_dir VALUES("335","0","Авто Мото","sisx;rar;sis;cab;tsk;thm;nth;zip;apk;utz;smt:","52428800","/Temy/Android/Avto_Moto/","/Temy/Android/","1","0");
INSERT INTO obmennik_dir VALUES("336","0","Животный мир","sisx;rar;sis;cab;tsk;thm;nth;zip;apk;utz;smt:","52428800","/Temy/Android/ZHivotnyj_mir/","/Temy/Android/","1","0");
INSERT INTO obmennik_dir VALUES("337","0","Кино Игры","sisx;rar;sis;cab;tsk;thm;nth;zip;apk;utz;smt:","52428800","/Temy/Android/Kino_Igry/","/Temy/Android/","1","0");
INSERT INTO obmennik_dir VALUES("338","0","Природа","sisx;rar;sis;cab;tsk;thm;nth;zip;apk;utz;smt:","52428800","/Temy/Android/Priroda/","/Temy/Android/","1","0");
INSERT INTO obmennik_dir VALUES("339","0","Эротика","sisx;rar;sis;cab;tsk;thm;nth;zip;apk;utz;smt:","52428800","/Temy/Android/Jerotika/","/Temy/Android/","1","0");
INSERT INTO obmennik_dir VALUES("340","0","Спорт","sisx;rar;sis;cab;tsk;thm;nth;zip;apk;utz;smt:","52428800","/Temy/Android/Sport/","/Temy/Android/","1","0");
INSERT INTO obmennik_dir VALUES("341","0","Фэнтези Фантастика","sisx;rar;sis;cab;tsk;thm;nth;zip;apk;utz;smt:","52428800","/Temy/Android/Fjentezi_Fantastika/","/Temy/Android/","1","0");
INSERT INTO obmennik_dir VALUES("342","0","Разное","sisx;rar;sis;cab;tsk;thm;nth;zip;apk;utz;smt:","52428800","/Temy/Android/Raznoe/","/Temy/Android/","1","0");
INSERT INTO obmennik_dir VALUES("343","0","Заставки","swf;exe;thm;nth:","52428800","/Flesh/Zastavki/","/Flesh/","1","0");
INSERT INTO obmennik_dir VALUES("344","0","Часы","swf;exe;thm;nth:","52428800","/Flesh/CHasy/","/Flesh/","1","0");
INSERT INTO obmennik_dir VALUES("345","0","Мультики","swf;exe;thm;nth:","52428800","/Flesh/Multiki/","/Flesh/","1","0");
INSERT INTO obmennik_dir VALUES("346","0","Темы для SE","swf;exe;thm;nth:","52428800","/Flesh/Temy_dlja_SE/","/Flesh/","1","0");
INSERT INTO obmennik_dir VALUES("347","0","Темы для Nokia","swf;exe;thm;nth:","52428800","/Flesh/Temy_dlja_Nokia/","/Flesh/","1","0");
INSERT INTO obmennik_dir VALUES("348","0","Игры","swf;exe;thm;nth:","52428800","/Flesh/Igry/","/Flesh/","1","0");
INSERT INTO obmennik_dir VALUES("349","0","Программы","swf;exe;thm;nth:","52428800","/Flesh/Programmy/","/Flesh/","1","0");
INSERT INTO obmennik_dir VALUES("350","0","Trance","mp3;mp4","20971520","/Muzyka/Trance/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("351","0","Armin Van Buuren","mp3;mp4","20971520","/Muzyka/Trance/Armin_Van_Buuren/","/Muzyka/Trance/","1","0");
INSERT INTO obmennik_dir VALUES("352","0","Браузеры","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip:","52428800","/Programmy/Simbian/Brauzery/","/Programmy/Simbian/","1","0");
INSERT INTO obmennik_dir VALUES("353","0","Фото","gif; jpg; jpeg; bmp; png;","1048576","/Foto/","/","1","0");
INSERT INTO obmennik_dir VALUES("354","0","Клубничка","jpg;jpeg;gif;png.pnh;pnp;","512000","/Foto/Klubnichka/","/Foto/","1","0");
INSERT INTO obmennik_dir VALUES("356","0","Для сайтов","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip:","10485760","/Temy/Dlja_sajtov/","/Temy/","1","0");
INSERT INTO obmennik_dir VALUES("357","0","WAP версия","exe;rar;zip;jar;ipa;rar;zip;apk;jad;sis;7-Zip:","10485760","/Temy/Dlja_sajtov/WAP_versija/","/Temy/Dlja_sajtov/","1","0");
INSERT INTO obmennik_dir VALUES("358","0","Абстракция","jpg;gif;png;jpeg:","1048576","/Kartinki/Abstrakcija/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("359","0","Тату","jpg;gif;png;jpeg:","512000","/Kartinki/Tatu/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("360","0","Про любовь","jpg;gif;png;jpeg:","1048576","/Kartinki/Demotivatory/o_Ljybvi/","/Kartinki/Demotivatory/","1","0");
INSERT INTO obmennik_dir VALUES("361","0","Приколы","jpg;gif;png;jpeg:","1048576","/Kartinki/Demotivatory/Prikoly/","/Kartinki/Demotivatory/","1","0");
INSERT INTO obmennik_dir VALUES("362","0","Ангелы и Демоны","jpg;gif;png;jpeg:","5242880","/Kartinki/Angely_i_Demony/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("364","0","Слайд шоу","3gp;mp4;avi;flv;wmv;wav:","104857600","/Video/Slajd_shou/","/Video/","1","0");
INSERT INTO obmennik_dir VALUES("365","0","наш сайт","","0","/Video/Slajd_shou/nash_sajt/","/Video/Slajd_shou/","0","0");
INSERT INTO obmennik_dir VALUES("366","0","Наш сайт","3gp;mp4;avi;flv;wmv;wav:","52428800","/Video/Slajd_shou/Nash_sajt/","/Video/Slajd_shou/","1","0");



DROP TABLE IF EXISTS `obmennik_files`;

CREATE TABLE `obmennik_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_dir` int(11) NOT NULL,
  `name` varchar(128) NOT NULL,
  `ras` varchar(36) NOT NULL,
  `type` varchar(64) NOT NULL,
  `time` int(11) NOT NULL,
  `time_last` int(11) NOT NULL,
  `size` int(11) NOT NULL,
  `k_loads` int(11) DEFAULT '0',
  `time_go` int(11) DEFAULT '0',
  `opis` text NOT NULL,
  `my_dir` int(11) DEFAULT '0',
  `metka` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO obmennik_files VALUES("1","1","130","0i5Jbbv2MXU","jpg","image/jpeg","1487597244","1487597244","146790","0","0","","1","0");
INSERT INTO obmennik_files VALUES("2","11","123","-","mp3","audio/mpeg","1487598379","1487598379","9513371","4","0","По просьбе....","11","0");



DROP TABLE IF EXISTS `obmennik_komm`;

CREATE TABLE `obmennik_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_file` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_file` (`id_file`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `opsos`;

CREATE TABLE `opsos` (
  `min` bigint(11) DEFAULT NULL,
  `max` bigint(11) DEFAULT NULL,
  `opsos` varchar(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `min` (`min`,`max`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO opsos VALUES("3274702592","3274702847","Kcel");
INSERT INTO opsos VALUES("1333559296","1333575679","life:)");
INSERT INTO opsos VALUES("-734354944","-734354433","life:)");
INSERT INTO opsos VALUES("3582431104","3582434943","TambovGSM");
INSERT INTO opsos VALUES("1358905344","1358905471","UMC");
INSERT INTO opsos VALUES("1490444288","1490452479","UMC");
INSERT INTO opsos VALUES("1490436096","1490444287","UMC");
INSERT INTO opsos VALUES("3588472832","3588489215","WellCOM GSM");
INSERT INTO opsos VALUES("3253698560","3253699071","WellCOM GSM");
INSERT INTO opsos VALUES("3557661440","3557661695","КаР-Тел");
INSERT INTO opsos VALUES("3240705024","3240706047","Киевстар");
INSERT INTO opsos VALUES("1360467968","1360470015","Киевстар");
INSERT INTO opsos VALUES("1360465920","1360467967","Киевстар");
INSERT INTO opsos VALUES("1402278912","1402279935","МегаФон");
INSERT INTO opsos VALUES("1402286080","1402287103","МегаФон");
INSERT INTO opsos VALUES("1402273792","1402275839","MegaFon");
INSERT INTO opsos VALUES("3650368512","3650368767","МОТИВ");
INSERT INTO opsos VALUES("1410459648","1410460159","МТС");
INSERT INTO opsos VALUES("3641237504","3641241599","МТС");
INSERT INTO opsos VALUES("3276428288","3276428543","МТС");
INSERT INTO opsos VALUES("3258356736","3258357759","МТС");
INSERT INTO opsos VALUES("3562834880","3562834943","МТС");
INSERT INTO opsos VALUES("3579259392","3579265535","МТС");
INSERT INTO opsos VALUES("1347674112","1347678207","МТС");
INSERT INTO opsos VALUES("3579267072","3579267935","МТС");
INSERT INTO opsos VALUES("1358906880","1358907135","МТС");
INSERT INTO opsos VALUES("1476194816","1476195071","МТС");
INSERT INTO opsos VALUES("1372794624","1372794879","МТС");
INSERT INTO opsos VALUES("3642047744","3642047999","МТС");
INSERT INTO opsos VALUES("3579269120","3579273215","МТС");
INSERT INTO opsos VALUES("3277188608","3277188863","МТС");
INSERT INTO opsos VALUES("3645018112","3645019135","МТС");
INSERT INTO opsos VALUES("1347126528","1347127167","МТС");
INSERT INTO opsos VALUES("3281465344","3281465599","МТС");
INSERT INTO opsos VALUES("1360933376","1360933887","МТС");
INSERT INTO opsos VALUES("3647698432","3647698687","МТС");
INSERT INTO opsos VALUES("3267023360","3267023488","МТС");
INSERT INTO opsos VALUES("1535627776","1535628031","МТС");
INSERT INTO opsos VALUES("1410457600","1410459647","МТС");
INSERT INTO opsos VALUES("1433788416","1433788671","МТС");
INSERT INTO opsos VALUES("1389383040","1389383167","НСС");
INSERT INTO opsos VALUES("1358122240","1358123007","НТК");
INSERT INTO opsos VALUES("1358118912","1358119423","НТК");
INSERT INTO opsos VALUES("1438682304","1438682335","Оренбург-GSM");
INSERT INTO opsos VALUES("1509752832","1509756927","Скай Линк");
INSERT INTO opsos VALUES("3565250560","3565254655","Скай Линк");
INSERT INTO opsos VALUES("1536507904","1536516095","Скай Линк");
INSERT INTO opsos VALUES("1536516096","1536518143","Скай Линк");
INSERT INTO opsos VALUES("3578853376","3578854079","Скай Линк");
INSERT INTO opsos VALUES("1406738432","1406739967","Скай Линк");
INSERT INTO opsos VALUES("3266342656","3266342911","Скай Мобайл");
INSERT INTO opsos VALUES("1346736128","1346737151","СМАРТС");
INSERT INTO opsos VALUES("3260286336","3260286463","СМАРТС");
INSERT INTO opsos VALUES("1509527552","1509528575","СТеК Джи Эс Эм");
INSERT INTO opsos VALUES("1506762752","1506764799","ТАТИНКОМ-Т");
INSERT INTO opsos VALUES("1404203008","1404211199","Теле2");
INSERT INTO opsos VALUES("3580231936","3580232191","Теле2");
INSERT INTO opsos VALUES("1404215296","1404219391","Теле2");
INSERT INTO opsos VALUES("1404874752","1404875775","Теле2");
INSERT INTO opsos VALUES("1404189184","1404189695","Теле2");
INSERT INTO opsos VALUES("1404829696","1404837887","Теле2");
INSERT INTO opsos VALUES("3580236800","3580237567","Теле2");
INSERT INTO opsos VALUES("3580235264","3580235775","Теле2");
INSERT INTO opsos VALUES("1404837888","1404846079","Теле2");
INSERT INTO opsos VALUES("3580214272","3580214783","Теле2");
INSERT INTO opsos VALUES("1404227584","1404232191","Теле2");
INSERT INTO opsos VALUES("3580232448","3580233215","Теле2");
INSERT INTO opsos VALUES("3580239360","3580239871","Теле2");
INSERT INTO opsos VALUES("3580231680","3580231935","Теле2");
INSERT INTO opsos VALUES("1441366016","1441371903","Utel");
INSERT INTO opsos VALUES("1401450496","1401450751","Utel");
INSERT INTO opsos VALUES("1506570240","1506574335","Utel");
INSERT INTO opsos VALUES("3571187712","3571191807","Utel");
INSERT INTO opsos VALUES("3564676832","3564676863","Utel");
INSERT INTO opsos VALUES("1494507776","1494508031","Utel");
INSERT INTO opsos VALUES("3641816064","3641816319","Utel");
INSERT INTO opsos VALUES("3651755008","3651756031","Цифровая экспансия");
INSERT INTO opsos VALUES("2130706433","2130706433","localhost");
INSERT INTO opsos VALUES("3283979853","3283979853","Opera Mini");
INSERT INTO opsos VALUES("1412413440","1412413951","Наука-Связь");
INSERT INTO opsos VALUES("1518993408","1519058943","Теле2");
INSERT INTO opsos VALUES("1410269184","1410334719","Bite GSM");
INSERT INTO opsos VALUES("1407907840","1407908351","Ульяновск-GSM");
INSERT INTO opsos VALUES("2197028864","2197094399","Теле2");
INSERT INTO opsos VALUES("3274702592","3274702847","Kcel");
INSERT INTO opsos VALUES("-734351360","-734347265","life:)");
INSERT INTO opsos VALUES("-734353408","-734351361","life:)");
INSERT INTO opsos VALUES("3582431104","3582434943","TambovGSM");
INSERT INTO opsos VALUES("1358905344","1358905471","UMC");
INSERT INTO opsos VALUES("1490444288","1490452479","UMC");
INSERT INTO opsos VALUES("1490436096","1490444287","UMC");
INSERT INTO opsos VALUES("3588472832","3588489215","WellCOM GSM");
INSERT INTO opsos VALUES("3253698560","3253699071","WellCOM GSM");
INSERT INTO opsos VALUES("3557661440","3557661695","КаР-Тел");
INSERT INTO opsos VALUES("3240705024","3240706047","Киевстар");
INSERT INTO opsos VALUES("1360467968","1360470015","Киевстар");
INSERT INTO opsos VALUES("1360465920","1360467967","Киевстар");
INSERT INTO opsos VALUES("1402275840","1402276863","МегаФон");
INSERT INTO opsos VALUES("1402278912","1402279935","МегаФон");
INSERT INTO opsos VALUES("1402286080","1402287103","МегаФон");
INSERT INTO opsos VALUES("1402273792","1402275839","МегаФон");
INSERT INTO opsos VALUES("1346621440","1346622463","МегаФон");
INSERT INTO opsos VALUES("3251233792","3251234815","МегаФон");
INSERT INTO opsos VALUES("1402284032","1402285055","МегаФон");
INSERT INTO opsos VALUES("1402281984","1402283007","МегаФон");
INSERT INTO opsos VALUES("1402287104","1402288127","МегаФон");
INSERT INTO opsos VALUES("1402279936","1402280959","МегаФон");
INSERT INTO opsos VALUES("1402277888","1402278911","МегаФон");
INSERT INTO opsos VALUES("3650368512","3650368767","МОТИВ");
INSERT INTO opsos VALUES("1410459648","1410460159","МТС");
INSERT INTO opsos VALUES("3641237504","3641241599","МТС");
INSERT INTO opsos VALUES("3276428288","3276428543","МТС");
INSERT INTO opsos VALUES("3258356736","3258357759","МТС");
INSERT INTO opsos VALUES("3562834880","3562834943","МТС");
INSERT INTO opsos VALUES("3579259392","3579265535","МТС");
INSERT INTO opsos VALUES("1347674112","1347678207","МТС");
INSERT INTO opsos VALUES("3579267072","3579267935","МТС");
INSERT INTO opsos VALUES("1358906880","1358907135","МТС");
INSERT INTO opsos VALUES("1476194816","1476195071","МТС");
INSERT INTO opsos VALUES("1372794624","1372794879","МТС");
INSERT INTO opsos VALUES("3642047744","3642047999","МТС");
INSERT INTO opsos VALUES("3579269120","3579273215","МТС");
INSERT INTO opsos VALUES("3277188608","3277188863","МТС");
INSERT INTO opsos VALUES("3645018112","3645019135","МТС");
INSERT INTO opsos VALUES("1347126528","1347127167","МТС");
INSERT INTO opsos VALUES("3281465344","3281465599","МТС");
INSERT INTO opsos VALUES("1360933376","1360933887","МТС");
INSERT INTO opsos VALUES("3647698432","3647698687","МТС");
INSERT INTO opsos VALUES("3267023360","3267023488","МТС");
INSERT INTO opsos VALUES("3645566976","3645569023","МТС");
INSERT INTO opsos VALUES("1535627776","1535628031","МТС");
INSERT INTO opsos VALUES("1410457600","1410459647","МТС");
INSERT INTO opsos VALUES("1433788416","1433788671","МТС");
INSERT INTO opsos VALUES("1389383040","1389383167","НСС");
INSERT INTO opsos VALUES("1358122240","1358123007","НТК");
INSERT INTO opsos VALUES("1358118912","1358119423","НТК");
INSERT INTO opsos VALUES("1438682304","1438682335","Оренбург-GSM");
INSERT INTO opsos VALUES("1509752832","1509756927","Скай Линк");
INSERT INTO opsos VALUES("3565250560","3565254655","Скай Линк");
INSERT INTO opsos VALUES("1536507904","1536516095","Скай Линк");
INSERT INTO opsos VALUES("1536516096","1536518143","Скай Линк");
INSERT INTO opsos VALUES("3578853376","3578854079","Скай Линк");
INSERT INTO opsos VALUES("1406738432","1406739967","Скай Линк");
INSERT INTO opsos VALUES("3266342656","3266342911","Скай Мобайл");
INSERT INTO opsos VALUES("1346736128","1346737151","СМАРТС");
INSERT INTO opsos VALUES("3260286336","3260286463","СМАРТС");
INSERT INTO opsos VALUES("1509527552","1509528575","СТеК Джи Эс Эм");
INSERT INTO opsos VALUES("1506762752","1506764799","ТАТИНКОМ-Т");
INSERT INTO opsos VALUES("1404203008","1404211199","Теле2");
INSERT INTO opsos VALUES("3580231936","3580232191","Теле2");
INSERT INTO opsos VALUES("1404215296","1404219391","Теле2");
INSERT INTO opsos VALUES("1404874752","1404875775","Теле2");
INSERT INTO opsos VALUES("1404189184","1404189695","Теле2");
INSERT INTO opsos VALUES("1404829696","1404837887","Теле2");
INSERT INTO opsos VALUES("3580236800","3580237567","Теле2");
INSERT INTO opsos VALUES("3580235264","3580235775","Теле2");
INSERT INTO opsos VALUES("1404837888","1404846079","Теле2");
INSERT INTO opsos VALUES("3580214272","3580214783","Теле2");
INSERT INTO opsos VALUES("1404227584","1404232191","Теле2");
INSERT INTO opsos VALUES("3580232448","3580233215","Теле2");
INSERT INTO opsos VALUES("3580239360","3580239871","Теле2");
INSERT INTO opsos VALUES("3580231680","3580231935","Теле2");
INSERT INTO opsos VALUES("1441366016","1441371903","Utel");
INSERT INTO opsos VALUES("1401450496","1401450751","Utel");
INSERT INTO opsos VALUES("1506570240","1506574335","Utel");
INSERT INTO opsos VALUES("3571187712","3571191807","Utel");
INSERT INTO opsos VALUES("3564676832","3564676863","Utel");
INSERT INTO opsos VALUES("1494507776","1494508031","Utel");
INSERT INTO opsos VALUES("3641816064","3641816319","Utel");
INSERT INTO opsos VALUES("3651755008","3651756031","Цифровая экспансия");
INSERT INTO opsos VALUES("2130706433","2130706433","localhost");
INSERT INTO opsos VALUES("3283979853","3283979853","Opera Mini");
INSERT INTO opsos VALUES("1412413440","1412413951","Наука-Связь");
INSERT INTO opsos VALUES("3588390912","3588391935","Bite GSM");
INSERT INTO opsos VALUES("1518993408","1519058943","Теле2");
INSERT INTO opsos VALUES("1410269184","1410334719","Bite GSM");
INSERT INTO opsos VALUES("1407907840","1407908351","Ульяновск-GSM");
INSERT INTO opsos VALUES("2197028864","2197094399","Теле2");
INSERT INTO opsos VALUES("-646557696","-646556673","Beeline");
INSERT INTO opsos VALUES("3274702592","3274702847","K cel");
INSERT INTO opsos VALUES("-712536192","-712532353","TambovGSM");
INSERT INTO opsos VALUES("1333575680","1333592063","life:)");
INSERT INTO opsos VALUES("-734355456","-734355201","life:)");
INSERT INTO opsos VALUES("1536278528","1536294911","Life:)");
INSERT INTO opsos VALUES("3582431104","3582434943","TambovGSM");
INSERT INTO opsos VALUES("1358905344","1358905471","UMC");
INSERT INTO opsos VALUES("1490444288","1490452479","UMC");
INSERT INTO opsos VALUES("1490436096","1490444287","UMC");
INSERT INTO opsos VALUES("3588472832","3588489215","WellCOM GSM");
INSERT INTO opsos VALUES("3253698560","3253699071","WellCOM GSM");
INSERT INTO opsos VALUES("1519796224","1519800319","Уралсвязьинформ");
INSERT INTO opsos VALUES("1388849152","1388850175","ИНДИГО");
INSERT INTO opsos VALUES("1427948288","1427948543","Дальсвязь");
INSERT INTO opsos VALUES("1385632000","1385632255","БашСЕЛ");
INSERT INTO opsos VALUES("3273026560","3273027583","БашСЕЛ");
INSERT INTO opsos VALUES("1347599104","1347599359","Байкалвестком");
INSERT INTO opsos VALUES("1360162816","1360166911","Байкалвестком");
INSERT INTO opsos VALUES("1360163840","1360164351","Байкалвестком");
INSERT INTO opsos VALUES("3588519936","3588520447","Байкалвестком");
INSERT INTO opsos VALUES("1407888896","1407889151","Байкалвестком");
INSERT INTO opsos VALUES("3564188672","3564188927","Utel");
INSERT INTO opsos VALUES("3564189696","3564191743","Utel");
INSERT INTO opsos VALUES("1441366016","1441371903","Utel");
INSERT INTO opsos VALUES("1401450496","1401450751","Utel");
INSERT INTO opsos VALUES("1506570240","1506574335","Utel");
INSERT INTO opsos VALUES("3571187712","3571191807","Utel");
INSERT INTO opsos VALUES("3564676832","3564676863","Utel");
INSERT INTO opsos VALUES("1494507776","1494508031","Utel");
INSERT INTO opsos VALUES("3641816064","3641816319","Utel");
INSERT INTO opsos VALUES("3564189440","3564189695","Utel");
INSERT INTO opsos VALUES("2130706433","2130706433","localhost");
INSERT INTO opsos VALUES("3283979853","3283979853","Opera Mini");
INSERT INTO opsos VALUES("3588390912","3588391935","Bite GSM");
INSERT INTO opsos VALUES("3585764352","3585764607","Utel");
INSERT INTO opsos VALUES("1410269184","1410334719","Bite GSM");
INSERT INTO opsos VALUES("3564189184","3564189439","Utel");
INSERT INTO opsos VALUES("3582031776","3582031807","Мегафон");
INSERT INTO opsos VALUES("1427812352","1427813375","Мегафон");
INSERT INTO opsos VALUES("1433657344","1433657599","Билайн");
INSERT INTO opsos VALUES("3648405504","3648406527","Билайн");
INSERT INTO opsos VALUES("3648406528","3648407551","Билайн");
INSERT INTO opsos VALUES("3648408576","3648409599","Билайн");
INSERT INTO opsos VALUES("3648409600","3648410623","Билайн");
INSERT INTO opsos VALUES("3648410624","3648411647","Билайн");
INSERT INTO opsos VALUES("3648411648","3648412671","Билайн");
INSERT INTO opsos VALUES("3648412672","3648413695","Билайн");
INSERT INTO opsos VALUES("1047070464","1047072255","Utel");
INSERT INTO opsos VALUES("1401451520","1401451775","Utel");
INSERT INTO opsos VALUES("1425981440","1425997823","Utel");
INSERT INTO opsos VALUES("3272364544","3272364799","Utel");
INSERT INTO opsos VALUES("3564675072","3564675583","Utel");
INSERT INTO opsos VALUES("3641816576","3641816831","Utel");
INSERT INTO opsos VALUES("1519779840","1519910911","Utel");
INSERT INTO opsos VALUES("3274599168","3274599423","БайкалВестКом");
INSERT INTO opsos VALUES("1042394624","1042394879","МТС");
INSERT INTO opsos VALUES("1346950400","1346950655","МТС");
INSERT INTO opsos VALUES("3281453056","3281518591","МТС");
INSERT INTO opsos VALUES("3287259392","3287259647","МТС");
INSERT INTO opsos VALUES("3559689216","3559689471","МТС");
INSERT INTO opsos VALUES("3562834688","3562834879","МТС");
INSERT INTO opsos VALUES("3578831872","3578832127","МТС");
INSERT INTO opsos VALUES("3648478720","3648479231","МТС");
INSERT INTO opsos VALUES("3579268096","3579268607","МТС");
INSERT INTO opsos VALUES("1404862464","1404870655","Tele2");
INSERT INTO opsos VALUES("1404846080","1404854271","Tele2");
INSERT INTO opsos VALUES("1404854272","1404862463","Tele2");
INSERT INTO opsos VALUES("1518927872","1518944255","Tele2");
INSERT INTO opsos VALUES("3650367488","3650368511","Мотив");
INSERT INTO opsos VALUES("3278955480","3278955515","ЕТК");
INSERT INTO opsos VALUES("3278956288","3278956543","ЕТК");
INSERT INTO opsos VALUES("3278960128","3278960383","ЕТК");
INSERT INTO opsos VALUES("1432330240","1432334335","НСС");
INSERT INTO opsos VALUES("3282161664","3282163711","НСС");
INSERT INTO opsos VALUES("3282171904","3282173951","НСС");
INSERT INTO opsos VALUES("3585171456","3585174271","НСС");
INSERT INTO opsos VALUES("3267008512","3267008767","НСС");
INSERT INTO opsos VALUES("3277992448","3277992959","НСС");
INSERT INTO opsos VALUES("1441609984","1441610239","НСС");
INSERT INTO opsos VALUES("3645731072","3645731079","Смартс");
INSERT INTO opsos VALUES("1310210048","1310211071","Смартс");
INSERT INTO opsos VALUES("1536099328","1536099839","Смартс");
INSERT INTO opsos VALUES("3587219456","3587219711","Смартс");
INSERT INTO opsos VALUES("3648294912","3648295935","Stek GSM");
INSERT INTO opsos VALUES("1481787392","1481787647","Татинком-Т");
INSERT INTO opsos VALUES("3652001536","3652001599","Татинком-Т");
INSERT INTO opsos VALUES("1052193280","1052193535","MTT");
INSERT INTO opsos VALUES("1347125248","1347125759","MTT");
INSERT INTO opsos VALUES("1358119424","1358120703","НТК");
INSERT INTO opsos VALUES("1406740480","1406746623","Sky Link");
INSERT INTO opsos VALUES("3564593152","3564593919","Sky Link");
INSERT INTO opsos VALUES("3564595968","3564596735","Sky Link");
INSERT INTO opsos VALUES("3564599808","3564601343","Sky Link");
INSERT INTO opsos VALUES("3565248512","3565250047","Sky Link");
INSERT INTO opsos VALUES("3565250048","3565250559","Sky Link");
INSERT INTO opsos VALUES("3648212992","3648217087","Sky Link");
INSERT INTO opsos VALUES("1386348544","1386414079","Акос");
INSERT INTO opsos VALUES("1566410752","1566411775","Ульяновск GSM");
INSERT INTO opsos VALUES("3651751936","3651752191","Цифровая экспансия");
INSERT INTO opsos VALUES("3651752192","3651752447","Цифровая экспансия");
INSERT INTO opsos VALUES("3287244288","3287244543","Индиго");
INSERT INTO opsos VALUES("3560612864","3560613887","Киевстар");
INSERT INTO opsos VALUES("1486487552","1486553087","Киевстар");
INSERT INTO opsos VALUES("1295253504","1295319039","UMC");
INSERT INTO opsos VALUES("1358907392","1358907647","UMC");
INSERT INTO opsos VALUES("1358907648","1358907903","UMC");
INSERT INTO opsos VALUES("1358907904","1358908031","UMC");
INSERT INTO opsos VALUES("1358908160","1358908415","UMC");
INSERT INTO opsos VALUES("1358908416","1358908671","UMC");
INSERT INTO opsos VALUES("1358908672","1358908927","UMC");
INSERT INTO opsos VALUES("1358908928","1358909183","UMC");
INSERT INTO opsos VALUES("1358909184","1358909439","UMC");
INSERT INTO opsos VALUES("2516451328","2516516863","T-Mobile");
INSERT INTO opsos VALUES("3562889472","3562889727","LMT");
INSERT INTO opsos VALUES("3651710976","3651715071","AzerCellTelecom");
INSERT INTO opsos VALUES("1365222400","1365223423","Ge-Magticom");
INSERT INTO opsos VALUES("3645744128","3645744639","Vodafon");
INSERT INTO opsos VALUES("3584180736","3584180991","T-Mobile");
INSERT INTO opsos VALUES("1358192896","1358193151","Vodafon");
INSERT INTO opsos VALUES("1507835904","1507852287","Vodafon");
INSERT INTO opsos VALUES("1507819520","1507827711","Vodafon");
INSERT INTO opsos VALUES("1507827712","1507835903","Vodafon");
INSERT INTO opsos VALUES("1536655360","1536659455","Geocell");
INSERT INTO opsos VALUES("3253712384","3253712895","Voxtel");
INSERT INTO opsos VALUES("3560144384","3560144639","Mobtel");
INSERT INTO opsos VALUES("3644964864","3644965479","T-Mobile");
INSERT INTO opsos VALUES("1054471936","1054472191","Orange");
INSERT INTO opsos VALUES("3275173632","3275173695","TME");
INSERT INTO opsos VALUES("1404190720","1404198911","Tele2");
INSERT INTO opsos VALUES("3583496320","3583496447","Orange");
INSERT INTO opsos VALUES("3266322432","3266322687","Omnitel");
INSERT INTO opsos VALUES("1407033600","1407033855","Unitel");
INSERT INTO opsos VALUES("3568795648","3568799999","Vodafon");
INSERT INTO opsos VALUES("1407188992","1407210495","Vodafon");
INSERT INTO opsos VALUES("3645317120","3645318015","EMT");
INSERT INTO opsos VALUES("3240329216","3240333311","Orange");
INSERT INTO opsos VALUES("3254619392","3254619647","Orange");
INSERT INTO opsos VALUES("1358598144","1358600191","Cellcom");
INSERT INTO opsos VALUES("1296285696","1296302079","Tcell");
INSERT INTO opsos VALUES("3576365056","3576397823","Tcell");
INSERT INTO opsos VALUES("1449959424","1449967615","Tcell");
INSERT INTO opsos VALUES("1336598528","1336599521","Mordcell");
INSERT INTO opsos VALUES("3566895360","3566895615","МТС");
INSERT INTO opsos VALUES("3279123456","3279124479","SRR");
INSERT INTO opsos VALUES("3652165632","3652167167","OutRemer");
INSERT INTO opsos VALUES("3283979776","3283980287","Opera Mini");
INSERT INTO opsos VALUES("3242554368","3242554495","Opera Mini");
INSERT INTO opsos VALUES("1357411584","1357411839","Opera Mini");
INSERT INTO opsos VALUES("1540055040","1540056063","Opera Mini");
INSERT INTO opsos VALUES("1593212416","1593212927","Opera Mini");
INSERT INTO opsos VALUES("-1010987520","-1010987009","Opera Mini");
INSERT INTO opsos VALUES("-646555136","-646554369","Вымпелком");
INSERT INTO opsos VALUES("-646554368","-646553857","Вымпелком WiFi");



DROP TABLE IF EXISTS `podtv_reg_user`;

CREATE TABLE `podtv_reg_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reg` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO podtv_reg_user VALUES("1","0");



DROP TABLE IF EXISTS `reg_mail`;

CREATE TABLE `reg_mail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `mail` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mail` (`mail`),
  KEY `id_user` (`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `rekl`;

CREATE TABLE `rekl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `img` varchar(64) NOT NULL,
  `link` varchar(64) NOT NULL,
  `time_last` int(11) NOT NULL,
  `sel` set('1','2','3','4') NOT NULL DEFAULT '1',
  `count` int(11) NOT NULL DEFAULT '0',
  `dop_str` set('0','1') NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `sel` (`sel`),
  KEY `time_last` (`time_last`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `rules`;

CREATE TABLE `rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg` mediumtext,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `title` varchar(60) DEFAULT NULL,
  `url` varchar(999) DEFAULT NULL,
  `name_url` varchar(52) DEFAULT NULL,
  `pos` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `rules_p`;

CREATE TABLE `rules_p` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `msg` mediumtext NOT NULL,
  `time` int(11) NOT NULL,
  `id_news` int(11) NOT NULL,
  `pos` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `sea_set`;

CREATE TABLE `sea_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `forum` int(11) NOT NULL DEFAULT '1',
  `foto` int(11) NOT NULL DEFAULT '1',
  `img` int(11) NOT NULL DEFAULT '1',
  `users` int(11) NOT NULL DEFAULT '1',
  `java` int(11) NOT NULL DEFAULT '1',
  `muz` int(11) NOT NULL DEFAULT '1',
  `video` int(11) NOT NULL DEFAULT '1',
  KEY `type` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO sea_set VALUES("1","1","1","1","1","1","1","1");



DROP TABLE IF EXISTS `sexwars`;

CREATE TABLE `sexwars` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `time_end` int(11) DEFAULT '0',
  `male` int(11) DEFAULT '0',
  `female` int(11) DEFAULT '0',
  `win` varchar(128) DEFAULT '0',
  `active` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO sexwars VALUES("1","1487591870","0","7","2","0","1");



DROP TABLE IF EXISTS `sexwars_chat`;

CREATE TABLE `sexwars_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `msg` varchar(512) DEFAULT NULL,
  `id_tournament` int(11) DEFAULT '0',
  `sex` varchar(12) DEFAULT 'male',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `sexwars_users`;

CREATE TABLE `sexwars_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `level` int(11) DEFAULT '0',
  `sex` varchar(32) NOT NULL DEFAULT 'male',
  `rating` int(11) DEFAULT '0',
  `time_reboot` int(11) DEFAULT '0',
  `count_weapon` int(11) DEFAULT '0',
  `count_win` int(11) DEFAULT '0',
  `count_loss` int(11) DEFAULT '0',
  `id_tournament` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO sexwars_users VALUES("1","1487591876","1","0","male","3","1487597811","3","0","0","1");
INSERT INTO sexwars_users VALUES("2","1487596124","9","0","male","1","1487596727","1","0","0","1");
INSERT INTO sexwars_users VALUES("3","1487596142","7","0","male","2","1487615874","2","0","0","1");
INSERT INTO sexwars_users VALUES("4","1487596168","6","0","male","1","1487596771","1","0","0","1");
INSERT INTO sexwars_users VALUES("5","1487598101","11","0","male","1","1487598718","1","0","0","1");
INSERT INTO sexwars_users VALUES("6","1487692707","2","0","female","1","1487693315","1","0","0","1");



DROP TABLE IF EXISTS `sexwars_weapons`;

CREATE TABLE `sexwars_weapons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `id_user` int(11) DEFAULT '0',
  `id_tournament` int(11) DEFAULT '0',
  `id_weapon` int(11) DEFAULT '1',
  `type` varchar(32) DEFAULT 'tomate',
  `style` varchar(512) DEFAULT '',
  `sex` varchar(128) DEFAULT 'male',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO sexwars_weapons VALUES("1","1487591879","1","1","2","kiss","a:3:{s:3:\"top\";i:4;s:4:\"left\";i:86;s:6:\"rotate\";i:159;}","male");
INSERT INTO sexwars_weapons VALUES("2","1487594143","1","1","3","kiss","a:3:{s:3:\"top\";i:78;s:4:\"left\";i:-1;s:6:\"rotate\";i:43;}","male");
INSERT INTO sexwars_weapons VALUES("3","1487596127","9","1","3","puli","a:3:{s:3:\"top\";i:48;s:4:\"left\";i:79;s:6:\"rotate\";i:24;}","male");
INSERT INTO sexwars_weapons VALUES("4","1487596145","7","1","7","scelet","a:3:{s:3:\"top\";i:80;s:4:\"left\";i:13;s:6:\"rotate\";i:215;}","male");
INSERT INTO sexwars_weapons VALUES("5","1487596171","6","1","6","pchel","a:3:{s:3:\"top\";i:12;s:4:\"left\";i:87;s:6:\"rotate\";i:183;}","male");
INSERT INTO sexwars_weapons VALUES("6","1487597211","1","1","1","tomate","a:3:{s:3:\"top\";i:53;s:4:\"left\";i:28;s:6:\"rotate\";i:337;}","male");
INSERT INTO sexwars_weapons VALUES("7","1487598118","11","1","3","scelet","a:3:{s:3:\"top\";i:9;s:4:\"left\";i:60;s:6:\"rotate\";i:133;}","male");
INSERT INTO sexwars_weapons VALUES("8","1487615274","7","1","7","kraski","a:3:{s:3:\"top\";i:38;s:4:\"left\";i:-2;s:6:\"rotate\";i:111;}","female");
INSERT INTO sexwars_weapons VALUES("9","1487692715","2","1","2","tomate","a:3:{s:3:\"top\";i:47;s:4:\"left\";i:6;s:6:\"rotate\";i:193;}","female");



DROP TABLE IF EXISTS `smile`;

CREATE TABLE `smile` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `smile` varchar(64) NOT NULL,
  `dir` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1187 DEFAULT CHARSET=utf8;

INSERT INTO smile VALUES("3",".2сердца.","11");
INSERT INTO smile VALUES("18",".кис.","11");
INSERT INTO smile VALUES("4",".амур.","11");
INSERT INTO smile VALUES("5",".бананы.","11");
INSERT INTO smile VALUES("6",".целует.","11");
INSERT INTO smile VALUES("7",".чмок.","11");
INSERT INTO smile VALUES("8",".чмок2.","11");
INSERT INTO smile VALUES("9",".дев.","11");
INSERT INTO smile VALUES("10",".дарюсерд.","11");
INSERT INTO smile VALUES("11",".феминистка.","11");
INSERT INTO smile VALUES("12",".флирт.","11");
INSERT INTO smile VALUES("13",".флирт2.","11");
INSERT INTO smile VALUES("14",".глазавглаза.","11");
INSERT INTO smile VALUES("15",".инлав.","11");
INSERT INTO smile VALUES("16",".инлове.","11");
INSERT INTO smile VALUES("17",".качели.","11");
INSERT INTO smile VALUES("19",".кис2.","11");
INSERT INTO smile VALUES("20",".кис3.","11");
INSERT INTO smile VALUES("21",".краситгуб.","11");
INSERT INTO smile VALUES("22",".кружит.","11");
INSERT INTO smile VALUES("23",".лапушка.","11");
INSERT INTO smile VALUES("24",".лассо.","11");
INSERT INTO smile VALUES("25",".лесби.","11");
INSERT INTO smile VALUES("26",".любовь.","11");
INSERT INTO smile VALUES("28",".лягушка.","11");
INSERT INTO smile VALUES("29",".лягушка2.","11");
INSERT INTO smile VALUES("30",".м.","11");
INSERT INTO smile VALUES("31",".манюта.","11");
INSERT INTO smile VALUES("32",".мишка.","11");
INSERT INTO smile VALUES("44",".нравится.","11");
INSERT INTO smile VALUES("43",".нежно.","11");
INSERT INTO smile VALUES("45",".обнимки.","11");
INSERT INTO smile VALUES("46",".пинк.","11");
INSERT INTO smile VALUES("47",".поц.","11");
INSERT INTO smile VALUES("48",".подмиг2.","11");
INSERT INTO smile VALUES("49",".покраснела.","11");
INSERT INTO smile VALUES("50",".порукам3.","11");
INSERT INTO smile VALUES("51",".пшаг.","11");
INSERT INTO smile VALUES("52",".рисует.","11");
INSERT INTO smile VALUES("53",".счастливые.","11");
INSERT INTO smile VALUES("54",".секс.","11");
INSERT INTO smile VALUES("55",".секс2.","11");
INSERT INTO smile VALUES("56",".сердце.","11");
INSERT INTO smile VALUES("57",".сердце2.","11");
INSERT INTO smile VALUES("58",".сердце3.","11");
INSERT INTO smile VALUES("59",".серенада.","11");
INSERT INTO smile VALUES("60",".щекочет.","11");
INSERT INTO smile VALUES("61",".стеснит.","11");
INSERT INTO smile VALUES("62",".стеснит2.","11");
INSERT INTO smile VALUES("63",".стрела2.","11");
INSERT INTO smile VALUES("64",".танцуют.","11");
INSERT INTO smile VALUES("65",".вкусно.","11");
INSERT INTO smile VALUES("66",".воздпоц.","11");
INSERT INTO smile VALUES("67",".вруку.","11");
INSERT INTO smile VALUES("68",".взасос.","11");
INSERT INTO smile VALUES("69",".йоу.","11");
INSERT INTO smile VALUES("70",".заруки.","11");
INSERT INTO smile VALUES("78",".бис.","20");
INSERT INTO smile VALUES("77",".ах.","20");
INSERT INTO smile VALUES("76",".ааа.","20");
INSERT INTO smile VALUES("79",".бла.","20");
INSERT INTO smile VALUES("80",".бла2.","20");
INSERT INTO smile VALUES("81",".браво.","20");
INSERT INTO smile VALUES("82",".браво2.","20");
INSERT INTO smile VALUES("83",".бур2.","20");
INSERT INTO smile VALUES("84",".кул.","20");
INSERT INTO smile VALUES("85",".дик.","20");
INSERT INTO smile VALUES("86",".доволен.","20");
INSERT INTO smile VALUES("87",".доволен2.","20");
INSERT INTO smile VALUES("88",".доволен4.","20");
INSERT INTO smile VALUES("89",".дум.","20");
INSERT INTO smile VALUES("90",".думает.","20");
INSERT INTO smile VALUES("91",".фигасе.","20");
INSERT INTO smile VALUES("92",".финг.","20");
INSERT INTO smile VALUES("1184",".сердит.","21");
INSERT INTO smile VALUES("94",".фу.","20");
INSERT INTO smile VALUES("95",".фуу.","20");
INSERT INTO smile VALUES("96",".глаза.","20");
INSERT INTO smile VALUES("97",".глазами.","20");
INSERT INTO smile VALUES("98",".глаза2.","20");
INSERT INTO smile VALUES("99",".го.","20");
INSERT INTO smile VALUES("100",".гордо.","20");
INSERT INTO smile VALUES("101",".грустит.","20");
INSERT INTO smile VALUES("102",".хаха.","20");
INSERT INTO smile VALUES("103",".хм.","20");
INSERT INTO smile VALUES("104",".хнык.","20");
INSERT INTO smile VALUES("105",".идея.","20");
INSERT INTO smile VALUES("106",".идея2.","20");
INSERT INTO smile VALUES("107",".ик2.","20");
INSERT INTO smile VALUES("108",".испуг.","20");
INSERT INTO smile VALUES("109",".истерика.","20");
INSERT INTO smile VALUES("110",".яху.","20");
INSERT INTO smile VALUES("111",".ех2.","20");
INSERT INTO smile VALUES("112",".красн.","20");
INSERT INTO smile VALUES("113",".крик.","20");
INSERT INTO smile VALUES("114",".лол2.","20");
INSERT INTO smile VALUES("115",".лол.","20");
INSERT INTO smile VALUES("116",".мат.","20");
INSERT INTO smile VALUES("117",".мда.","20");
INSERT INTO smile VALUES("118",".молча.","20");
INSERT INTO smile VALUES("119",".нагло.","20");
INSERT INTO smile VALUES("120",".наис.","20");
INSERT INTO smile VALUES("121",".нервы.","20");
INSERT INTO smile VALUES("122",".нет.","20");
INSERT INTO smile VALUES("123",".невозм.","20");
INSERT INTO smile VALUES("124",".нея.","20");
INSERT INTO smile VALUES("125",".нифига.","20");
INSERT INTO smile VALUES("126",".но.","20");
INSERT INTO smile VALUES("127",".новичек.","20");
INSERT INTO smile VALUES("128",".совсем.","20");
INSERT INTO smile VALUES("129",".ням.","20");
INSERT INTO smile VALUES("130",".обижен.","20");
INSERT INTO smile VALUES("131",".обижена.","20");
INSERT INTO smile VALUES("132",".оченьдоволен.","20");
INSERT INTO smile VALUES("133",".охбой.","20");
INSERT INTO smile VALUES("134",".ок.","20");
INSERT INTO smile VALUES("135",".окно.","20");
INSERT INTO smile VALUES("136",".ор.","20");
INSERT INTO smile VALUES("137",".отрыв.","20");
INSERT INTO smile VALUES("138",".отстой.","20");
INSERT INTO smile VALUES("139",".пардон.","20");
INSERT INTO smile VALUES("140",".пардон2.","20");
INSERT INTO smile VALUES("141",".пасиба.","20");
INSERT INTO smile VALUES("142",".плачет.","20");
INSERT INTO smile VALUES("143",".плачет2.","20");
INSERT INTO smile VALUES("144",".плак.","20");
INSERT INTO smile VALUES("145",".плакса.","20");
INSERT INTO smile VALUES("146",".плющит.","20");
INSERT INTO smile VALUES("147",".поцелуй2.","20");
INSERT INTO smile VALUES("148",".подмиг.","20");
INSERT INTO smile VALUES("149",".подморг.","20");
INSERT INTO smile VALUES("150",".пох.","20");
INSERT INTO smile VALUES("151",".поймал.","20");
INSERT INTO smile VALUES("152",".пока2.","20");
INSERT INTO smile VALUES("153",".поклон.","20");
INSERT INTO smile VALUES("154",".носвис.","20");
INSERT INTO smile VALUES("155",".позеленел.","20");
INSERT INTO smile VALUES("156",".прелесть.","20");
INSERT INTO smile VALUES("157",".размаз.","20");
INSERT INTO smile VALUES("158",".рок.","20");
INSERT INTO smile VALUES("160",".сад.","20");
INSERT INTO smile VALUES("161",".саркастик.","20");
INSERT INTO smile VALUES("162",".саркастик2.","20");
INSERT INTO smile VALUES("163",".сердит.","20");
INSERT INTO smile VALUES("164",".сердито.","20");
INSERT INTO smile VALUES("165",".сердито2.","20");
INSERT INTO smile VALUES("166",".шутят.","20");
INSERT INTO smile VALUES("167",".скучает.","20");
INSERT INTO smile VALUES("168",".слюнявит.","20");
INSERT INTO smile VALUES("169",".смех.","20");
INSERT INTO smile VALUES("170",".смех2.","20");
INSERT INTO smile VALUES("171",".смех3.","20");
INSERT INTO smile VALUES("172",".улыбка.","20");
INSERT INTO smile VALUES("173",".сонно.","20");
INSERT INTO smile VALUES("174",".сорри.","20");
INSERT INTO smile VALUES("175",".стеснит3.","20");
INSERT INTO smile VALUES("176",".сюрприз.","20");
INSERT INTO smile VALUES("177",".свист.","20");
INSERT INTO smile VALUES("178",".танцует.","20");
INSERT INTO smile VALUES("179",".танц.","20");
INSERT INTO smile VALUES("180",".тонгуе.","20");
INSERT INTO smile VALUES("181",".удивлен.","20");
INSERT INTO smile VALUES("182",".ура2.","20");
INSERT INTO smile VALUES("183",".уснул.","20");
INSERT INTO smile VALUES("184",".устал.","20");
INSERT INTO smile VALUES("185",".весело.","20");
INSERT INTO smile VALUES("186",".волнуется.","20");
INSERT INTO smile VALUES("187",".вопрос.","20");
INSERT INTO smile VALUES("188",".восадок.","20");
INSERT INTO smile VALUES("189",".шинк.","20");
INSERT INTO smile VALUES("190",".шутка.","20");
INSERT INTO smile VALUES("191",".язык.","20");
INSERT INTO smile VALUES("192",".еа.","20");
INSERT INTO smile VALUES("193",".жарко.","20");
INSERT INTO smile VALUES("194",".жду.","20");
INSERT INTO smile VALUES("195",".жду2.","20");
INSERT INTO smile VALUES("196",".злой.","20");
INSERT INTO smile VALUES("197",".злой2.","20");
INSERT INTO smile VALUES("198",".злой3.","20");
INSERT INTO smile VALUES("199",".звезды.","20");
INSERT INTO smile VALUES("200",".злой4.","20");
INSERT INTO smile VALUES("201",".звезды2.","20");
INSERT INTO smile VALUES("202",".звезды3.","20");
INSERT INTO smile VALUES("206",".дискета.","18");
INSERT INTO smile VALUES("207",".ф1.","18");
INSERT INTO smile VALUES("208",".ф2.","18");
INSERT INTO smile VALUES("209",".кпк.","18");
INSERT INTO smile VALUES("210",".машинист.","18");
INSERT INTO smile VALUES("211",".мото.","18");
INSERT INTO smile VALUES("212",".налодке.","18");
INSERT INTO smile VALUES("213",".намото.","18");
INSERT INTO smile VALUES("214",".ноут.","18");
INSERT INTO smile VALUES("215",".паровоз.","18");
INSERT INTO smile VALUES("216",".паровоз2.","18");
INSERT INTO smile VALUES("217",".самолет.","18");
INSERT INTO smile VALUES("218",".самолет2.","18");
INSERT INTO smile VALUES("219",".шар.","18");
INSERT INTO smile VALUES("220",".скутер.","18");
INSERT INTO smile VALUES("221",".тачка.","18");
INSERT INTO smile VALUES("222",".танк.","18");
INSERT INTO smile VALUES("223",".вело.","18");
INSERT INTO smile VALUES("224",".вентилятор.","18");
INSERT INTO smile VALUES("225",".закомпом.","18");
INSERT INTO smile VALUES("226",".закомпом2.","18");
INSERT INTO smile VALUES("227",".закомпом3.","18");
INSERT INTO smile VALUES("228",".монитор.","18");
INSERT INTO smile VALUES("229",".монитор2.","18");
INSERT INTO smile VALUES("230",".будильник2.","15");
INSERT INTO smile VALUES("231",".клоун2.","15");
INSERT INTO smile VALUES("232",".осень.","15");
INSERT INTO smile VALUES("233",".плохо.","15");
INSERT INTO smile VALUES("234",".праздник.","15");
INSERT INTO smile VALUES("235",".ру.","15");
INSERT INTO smile VALUES("236",".шарики.","15");
INSERT INTO smile VALUES("237",".солнце.","15");
INSERT INTO smile VALUES("238",".срогами.","15");
INSERT INTO smile VALUES("239",".вкапусте.","15");
INSERT INTO smile VALUES("240",".застеклом.","15");
INSERT INTO smile VALUES("241",".затушил.","15");
INSERT INTO smile VALUES("246",".алерт.","10");
INSERT INTO smile VALUES("247",".ангел4.","10");
INSERT INTO smile VALUES("248",".бай.","10");
INSERT INTO smile VALUES("249",".бан.","10");
INSERT INTO smile VALUES("250",".билайн.","10");
INSERT INTO smile VALUES("251",".пост.","10");
INSERT INTO smile VALUES("252",".гугл.","10");
INSERT INTO smile VALUES("253",".гугл2.","10");
INSERT INTO smile VALUES("254",".гугл3.","10");
INSERT INTO smile VALUES("255",".ася.","10");
INSERT INTO smile VALUES("256",".омг.","10");
INSERT INTO smile VALUES("257",".кисс.","10");
INSERT INTO smile VALUES("258",".кисми.","10");
INSERT INTO smile VALUES("259",".клева.","10");
INSERT INTO smile VALUES("260",".линк.","10");
INSERT INTO smile VALUES("261",".лин.","10");
INSERT INTO smile VALUES("262",".лол3.","10");
INSERT INTO smile VALUES("263",".спам.","10");
INSERT INTO smile VALUES("264",".джд.","10");
INSERT INTO smile VALUES("265",".опера.","10");
INSERT INTO smile VALUES("266",".опера2.","10");
INSERT INTO smile VALUES("267",".упс.","10");
INSERT INTO smile VALUES("268",".ошибочка.","10");
INSERT INTO smile VALUES("269",".перв.","10");
INSERT INTO smile VALUES("270",".пиванет.","10");
INSERT INTO smile VALUES("271",".каунт.","10");
INSERT INTO smile VALUES("272",".пс.","10");
INSERT INTO smile VALUES("273",".рок2.","10");
INSERT INTO smile VALUES("274",".русский.","10");
INSERT INTO smile VALUES("275",".сервис.","10");
INSERT INTO smile VALUES("276",".супер.","10");
INSERT INTO smile VALUES("277",".феньк.","10");
INSERT INTO smile VALUES("278",".транслит.","10");
INSERT INTO smile VALUES("279",".всемпр.","10");
INSERT INTO smile VALUES("280",".вт.","10");
INSERT INTO smile VALUES("281",".ыы.","10");
INSERT INTO smile VALUES("283",".ангел2.","4");
INSERT INTO smile VALUES("284",".ангел3.","4");
INSERT INTO smile VALUES("285",".череп.","4");
INSERT INTO smile VALUES("286",".демон.","4");
INSERT INTO smile VALUES("287",".френки.","4");
INSERT INTO smile VALUES("288",".гдевил.","4");
INSERT INTO smile VALUES("290",".мертвец.","4");
INSERT INTO smile VALUES("291",".молитва.","4");
INSERT INTO smile VALUES("292",".неангел.","4");
INSERT INTO smile VALUES("293",".скосой.","4");
INSERT INTO smile VALUES("295",".вампир2.","4");
INSERT INTO smile VALUES("296",".ведьма.","4");
INSERT INTO smile VALUES("297",".2пистолета.","5");
INSERT INTO smile VALUES("298",".асасин.","5");
INSERT INTO smile VALUES("299",".атата.","5");
INSERT INTO smile VALUES("300",".пила.","5");
INSERT INTO smile VALUES("301",".бомба.","5");
INSERT INTO smile VALUES("302",".бомба2.","5");
INSERT INTO smile VALUES("303",".драка.","5");
INSERT INTO smile VALUES("304",".гранатомет.","5");
INSERT INTO smile VALUES("305",".хрясь.","5");
INSERT INTO smile VALUES("306",".карате.","5");
INSERT INTO smile VALUES("307",".лучник.","5");
INSERT INTO smile VALUES("308",".молотком.","5");
INSERT INTO smile VALUES("309",".нож.","5");
INSERT INTO smile VALUES("310",".орк.","5");
INSERT INTO smile VALUES("311",".палач.","5");
INSERT INTO smile VALUES("312",".паладин.","5");
INSERT INTO smile VALUES("313",".пифпаф.","5");
INSERT INTO smile VALUES("314",".пистолеты.","5");
INSERT INTO smile VALUES("315",".поголове.","5");
INSERT INTO smile VALUES("316",".попопе.","5");
INSERT INTO smile VALUES("317",".пушки.","5");
INSERT INTO smile VALUES("318",".руссолдат.","5");
INSERT INTO smile VALUES("319",".стар.","5");
INSERT INTO smile VALUES("320",".варвар.","5");
INSERT INTO smile VALUES("321",".вглаз.","5");
INSERT INTO smile VALUES("322",".винсент.","5");
INSERT INTO smile VALUES("323",".висит.","5");
INSERT INTO smile VALUES("324",".висит2.","5");
INSERT INTO smile VALUES("325",".виселица.","5");
INSERT INTO smile VALUES("326",".шахиды.","5");
INSERT INTO smile VALUES("327",".закосу.","5");
INSERT INTO smile VALUES("328",".сдаюсь.","5");
INSERT INTO smile VALUES("1185",":)","21");
INSERT INTO smile VALUES("331","=)","21");
INSERT INTO smile VALUES("344",".дедвнучка.","13");
INSERT INTO smile VALUES("345",".елка.","13");
INSERT INTO smile VALUES("346",".елка2.","13");
INSERT INTO smile VALUES("347",".гоблин.","13");
INSERT INTO smile VALUES("348",".мороз2.","13");
INSERT INTO smile VALUES("349",".ньюеар.","13");
INSERT INTO smile VALUES("351",".салют.","13");
INSERT INTO smile VALUES("352",".санта.","13");
INSERT INTO smile VALUES("353",".санта2.","13");
INSERT INTO smile VALUES("354",".санта3.","13");
INSERT INTO smile VALUES("355",".санта4.","13");
INSERT INTO smile VALUES("356",".щелкун.","13");
INSERT INTO smile VALUES("357",".снеговик.","13");
INSERT INTO smile VALUES("358",".снегур.","13");
INSERT INTO smile VALUES("359",".снегур2.","13");
INSERT INTO smile VALUES("360",".снежок.","13");
INSERT INTO smile VALUES("361",".хмас.","13");
INSERT INTO smile VALUES("362",".замерзла.","13");
INSERT INTO smile VALUES("363",".зима.","13");
INSERT INTO smile VALUES("364",".аллергия.","6");
INSERT INTO smile VALUES("365",".циклоп.","6");
INSERT INTO smile VALUES("366",".стена.","6");
INSERT INTO smile VALUES("367",".стена2.","6");
INSERT INTO smile VALUES("368",".стена3.","6");
INSERT INTO smile VALUES("369",".гы.","6");
INSERT INTO smile VALUES("370",".гыы.","6");
INSERT INTO smile VALUES("371",".идиот.","6");
INSERT INTO smile VALUES("372",".идиот2.","6");
INSERT INTO smile VALUES("373",".нарк.","6");
INSERT INTO smile VALUES("374",".пилот.","6");
INSERT INTO smile VALUES("375",".пилот2.","6");
INSERT INTO smile VALUES("376",".повес.","6");
INSERT INTO smile VALUES("377",".русрулетка.","6");
INSERT INTO smile VALUES("378",".суицид.","6");
INSERT INTO smile VALUES("379",".суицид2.","6");
INSERT INTO smile VALUES("380",".тормоз.","6");
INSERT INTO smile VALUES("381",".пук.","6");
INSERT INTO smile VALUES("382",".шутник.","6");
INSERT INTO smile VALUES("383",".яд.","6");
INSERT INTO smile VALUES("384",".язык3.","6");
INSERT INTO smile VALUES("396",".алкаш.","7");
INSERT INTO smile VALUES("397",".алкаши.","7");
INSERT INTO smile VALUES("398",".алкоголик.","7");
INSERT INTO smile VALUES("399",".апельсин.","7");
INSERT INTO smile VALUES("400",".арбуз.","7");
INSERT INTO smile VALUES("401",".банка.","7");
INSERT INTO smile VALUES("402",".барб.","7");
INSERT INTO smile VALUES("403",".бокалы.","7");
INSERT INTO smile VALUES("404",".бутылки.","7");
INSERT INTO smile VALUES("405",".коктейль.","7");
INSERT INTO smile VALUES("406",".кофе2.","7");
INSERT INTO smile VALUES("407",".кофе.","7");
INSERT INTO smile VALUES("408",".дв.","7");
INSERT INTO smile VALUES("409",".ик.","7");
INSERT INTO smile VALUES("410",".катает.","7");
INSERT INTO smile VALUES("411",".кофе3.","7");
INSERT INTO smile VALUES("412",".коктел.","7");
INSERT INTO smile VALUES("413",".конфета.","7");
INSERT INTO smile VALUES("414",".конфета2.","7");
INSERT INTO smile VALUES("415",".кружки.","7");
INSERT INTO smile VALUES("416",".кушает.","7");
INSERT INTO smile VALUES("417",".кушает2.","7");
INSERT INTO smile VALUES("418",".лай.","7");
INSERT INTO smile VALUES("419",".леденец.","7");
INSERT INTO smile VALUES("420",".лимон.","7");
INSERT INTO smile VALUES("421",".морковка.","7");
INSERT INTO smile VALUES("422",".морож.","7");
INSERT INTO smile VALUES("423",".напиток.","7");
INSERT INTO smile VALUES("424",".огурюм.","7");
INSERT INTO smile VALUES("425",".палочки.","7");
INSERT INTO smile VALUES("426",".печенька2.","7");
INSERT INTO smile VALUES("427",".печенька.","7");
INSERT INTO smile VALUES("428",".пил.","7");
INSERT INTO smile VALUES("429",".пила.","7");
INSERT INTO smile VALUES("430",".пирож.","7");
INSERT INTO smile VALUES("431",".пиво.","7");
INSERT INTO smile VALUES("432",".пиво2.","7");
INSERT INTO smile VALUES("433",".пицца.","7");
INSERT INTO smile VALUES("434",".пицца2.","7");
INSERT INTO smile VALUES("435",".попкорн.","7");
INSERT INTO smile VALUES("436",".попиву.","7");
INSERT INTO smile VALUES("437",".попиву2.","7");
INSERT INTO smile VALUES("438",".повар.","7");
INSERT INTO smile VALUES("440",".рыбу.","7");
INSERT INTO smile VALUES("441",".смакует.","7");
INSERT INTO smile VALUES("442",".стакан.","7");
INSERT INTO smile VALUES("443",".торт.","7");
INSERT INTO smile VALUES("444",".тостер.","7");
INSERT INTO smile VALUES("445",".тостер2.","7");
INSERT INTO smile VALUES("446",".ага.","7");
INSERT INTO smile VALUES("447",".вилка.","7");
INSERT INTO smile VALUES("448",".вино.","7");
INSERT INTO smile VALUES("449",".вишня.","7");
INSERT INTO smile VALUES("450",".выпил.","7");
INSERT INTO smile VALUES("451",".шамп.","7");
INSERT INTO smile VALUES("452",".шоко.","7");
INSERT INTO smile VALUES("453",".яблоко.","7");
INSERT INTO smile VALUES("454",".жарит.","7");
INSERT INTO smile VALUES("455",".акула.","9");
INSERT INTO smile VALUES("456",".чебур.","9");
INSERT INTO smile VALUES("457",".червяк.","9");
INSERT INTO smile VALUES("458",".чудо.","9");
INSERT INTO smile VALUES("459",".чудо2.","9");
INSERT INTO smile VALUES("460",".чудо3.","9");
INSERT INTO smile VALUES("461",".чудо4.","9");
INSERT INTO smile VALUES("462",".чудо5.","9");
INSERT INTO smile VALUES("463",".чудо6.","9");
INSERT INTO smile VALUES("464",".цыпленок.","9");
INSERT INTO smile VALUES("465",".еж.","9");
INSERT INTO smile VALUES("466",".еж2.","9");
INSERT INTO smile VALUES("467",".еж3.","9");
INSERT INTO smile VALUES("468",".еж4.","9");
INSERT INTO smile VALUES("469",".гладит.","9");
INSERT INTO smile VALUES("470",".киса.","9");
INSERT INTO smile VALUES("471",".конь.","9");
INSERT INTO smile VALUES("472",".корова.","9");
INSERT INTO smile VALUES("473",".кот.","9");
INSERT INTO smile VALUES("474",".кот2.","9");
INSERT INTO smile VALUES("475",".кролик.","9");
INSERT INTO smile VALUES("476",".лев.","9");
INSERT INTO smile VALUES("477",".лев2.","9");
INSERT INTO smile VALUES("478",".лиса.","9");
INSERT INTO smile VALUES("479",".лось.","9");
INSERT INTO smile VALUES("480",".мишка2.","9");
INSERT INTO smile VALUES("481",".мышь.","9");
INSERT INTO smile VALUES("482",".мед.","9");
INSERT INTO smile VALUES("483",".мишка.","9");
INSERT INTO smile VALUES("484",".мишки.","9");
INSERT INTO smile VALUES("486",".нуся.","9");
INSERT INTO smile VALUES("487",".олень.","9");
INSERT INTO smile VALUES("488",".олень2.","9");
INSERT INTO smile VALUES("489",".олень3.","9");
INSERT INTO smile VALUES("490",".пакман.","9");
INSERT INTO smile VALUES("491",".папамишка.","9");
INSERT INTO smile VALUES("492",".паук.","9");
INSERT INTO smile VALUES("493",".пчела.","9");
INSERT INTO smile VALUES("494",".петух.","9");
INSERT INTO smile VALUES("495",".пингвин.","9");
INSERT INTO smile VALUES("496",".поголове2.","9");
INSERT INTO smile VALUES("497",".пришел.","9");
INSERT INTO smile VALUES("498",".пух.","9");
INSERT INTO smile VALUES("499",".пух1.","9");
INSERT INTO smile VALUES("500",".пух2.","9");
INSERT INTO smile VALUES("501",".пух3.","9");
INSERT INTO smile VALUES("502",".пухвис.","9");
INSERT INTO smile VALUES("503",".рак.","9");
INSERT INTO smile VALUES("504",".рыбка2.","9");
INSERT INTO smile VALUES("519",".собака2.","9");
INSERT INTO smile VALUES("518",".собака.","9");
INSERT INTO smile VALUES("517",".слоник.","9");
INSERT INTO smile VALUES("516",".слон.","9");
INSERT INTO smile VALUES("515",".скунсы.","9");
INSERT INTO smile VALUES("520",".собака3.","9");
INSERT INTO smile VALUES("521",".свинья.","9");
INSERT INTO smile VALUES("522",".улитка.","9");
INSERT INTO smile VALUES("525",".заяц.","9");
INSERT INTO smile VALUES("524",".вианен.","9");
INSERT INTO smile VALUES("526",".заяц2.","9");
INSERT INTO smile VALUES("527",".жаба.","9");
INSERT INTO smile VALUES("528",".жук.","9");
INSERT INTO smile VALUES("529",".барабан.","12");
INSERT INTO smile VALUES("530",".барабан2.","12");
INSERT INTO smile VALUES("531",".диско.","12");
INSERT INTO smile VALUES("532",".диско2.","12");
INSERT INTO smile VALUES("533",".диско3.","12");
INSERT INTO smile VALUES("534",".диджей.","12");
INSERT INTO smile VALUES("535",".дудка.","12");
INSERT INTO smile VALUES("536",".элвис.","12");
INSERT INTO smile VALUES("537",".гитара.","12");
INSERT INTO smile VALUES("538",".гитара2.","12");
INSERT INTO smile VALUES("539",".гитара3.","12");
INSERT INTO smile VALUES("540",".гитара4.","12");
INSERT INTO smile VALUES("541",".гитара5.","12");
INSERT INTO smile VALUES("542",".гитара6.","12");
INSERT INTO smile VALUES("543",".харп.","12");
INSERT INTO smile VALUES("544",".играет.","12");
INSERT INTO smile VALUES("545",".музон.","12");
INSERT INTO smile VALUES("546",".баян.","12");
INSERT INTO smile VALUES("547",".2гитары.","12");
INSERT INTO smile VALUES("548",".натрубе.","12");
INSERT INTO smile VALUES("549",".ноты.","12");
INSERT INTO smile VALUES("550",".панк.","12");
INSERT INTO smile VALUES("551",".пианино.","12");
INSERT INTO smile VALUES("552",".пианино2.","12");
INSERT INTO smile VALUES("553",".сакс.","12");
INSERT INTO smile VALUES("554",".сгитарой.","12");
INSERT INTO smile VALUES("555",".скрипка.","12");
INSERT INTO smile VALUES("556",".смузыкой.","12");
INSERT INTO smile VALUES("557",".сопилка.","12");
INSERT INTO smile VALUES("558",".стерео.","12");
INSERT INTO smile VALUES("559",".труба4.","12");
INSERT INTO smile VALUES("560",".трубы.","12");
INSERT INTO smile VALUES("561",".хор.","12");
INSERT INTO smile VALUES("562",".2пал.","8");
INSERT INTO smile VALUES("563",".акут.","8");
INSERT INTO smile VALUES("564",".апл.","8");
INSERT INTO smile VALUES("565",".безпаники.","8");
INSERT INTO smile VALUES("566",".фига.","8");
INSERT INTO smile VALUES("567",".фига2.","8");
INSERT INTO smile VALUES("568",".фига3.","8");
INSERT INTO smile VALUES("569",".хлопает.","8");
INSERT INTO smile VALUES("570",".хорош.","8");
INSERT INTO smile VALUES("571",".кул.","8");
INSERT INTO smile VALUES("572",".кул2.","8");
INSERT INTO smile VALUES("573",".кул3.","8");
INSERT INTO smile VALUES("574",".лапа.","8");
INSERT INTO smile VALUES("575",".неа.","8");
INSERT INTO smile VALUES("576",".ненадо.","8");
INSERT INTO smile VALUES("577",".неочем.","8");
INSERT INTO smile VALUES("579",".незнаю.","8");
INSERT INTO smile VALUES("583",".пора.","8");
INSERT INTO smile VALUES("584",".привет.","8");
INSERT INTO smile VALUES("585",".прив.","8");
INSERT INTO smile VALUES("586",".ревер.","8");
INSERT INTO smile VALUES("587",".сумас.","8");
INSERT INTO smile VALUES("588",".сумас2.","8");
INSERT INTO smile VALUES("589",".ес.","8");
INSERT INTO smile VALUES("590",".жопа.","8");
INSERT INTO smile VALUES("605",".бабулька.","16");
INSERT INTO smile VALUES("606",".бабулька2.","16");
INSERT INTO smile VALUES("607",".дед2.","16");
INSERT INTO smile VALUES("608",".качает.","16");
INSERT INTO smile VALUES("609",".киди.","16");
INSERT INTO smile VALUES("610",".кормит.","16");
INSERT INTO smile VALUES("612",".кубики.","16");
INSERT INTO smile VALUES("613",".кубики2.","16");
INSERT INTO smile VALUES("614",".кубики3.","16");
INSERT INTO smile VALUES("615",".младенец.","16");
INSERT INTO smile VALUES("616",".младенец2.","16");
INSERT INTO smile VALUES("617",".женаты.","16");
INSERT INTO smile VALUES("618",".невижу.","16");
INSERT INTO smile VALUES("620",".ребенок.","16");
INSERT INTO smile VALUES("621",".сдетьми.","16");
INSERT INTO smile VALUES("622",".семья.","16");
INSERT INTO smile VALUES("623",".семья2.","16");
INSERT INTO smile VALUES("624",".семья3.","16");
INSERT INTO smile VALUES("625",".смишкой.","16");
INSERT INTO smile VALUES("626",".соска.","16");
INSERT INTO smile VALUES("627",".ссоской.","16");
INSERT INTO smile VALUES("628",".вкроват.","16");
INSERT INTO smile VALUES("629",".вкроват2.","16");
INSERT INTO smile VALUES("630",".вкроват3.","16");
INSERT INTO smile VALUES("631",".вкроват4.","16");
INSERT INTO smile VALUES("632",".вванной.","16");
INSERT INTO smile VALUES("633",".змей.","16");
INSERT INTO smile VALUES("636",".анютки.","19");
INSERT INTO smile VALUES("637",".клевер.","19");
INSERT INTO smile VALUES("638",".цвето.","19");
INSERT INTO smile VALUES("669",".амкар.","22");
INSERT INTO smile VALUES("642",".цветок2.","19");
INSERT INTO smile VALUES("643",".цветок3.","19");
INSERT INTO smile VALUES("644",".цветок4.","19");
INSERT INTO smile VALUES("645",".цветок5.","19");
INSERT INTO smile VALUES("646",".цветок6.","19");
INSERT INTO smile VALUES("647",".цветок7.","19");
INSERT INTO smile VALUES("648",".цветок8.","19");
INSERT INTO smile VALUES("668",".айкидо.","22");
INSERT INTO smile VALUES("650",".дарюрозу.","19");
INSERT INTO smile VALUES("651",".клевер2.","19");
INSERT INTO smile VALUES("653",".ромашка.","19");
INSERT INTO smile VALUES("654",".ромашки.","19");
INSERT INTO smile VALUES("655",".роза.","19");
INSERT INTO smile VALUES("656",".роза1.","19");
INSERT INTO smile VALUES("657",".роза2.","19");
INSERT INTO smile VALUES("658",".роза3.","19");
INSERT INTO smile VALUES("659",".роза4.","19");
INSERT INTO smile VALUES("660",".роза5.","19");
INSERT INTO smile VALUES("661",".роза6.","19");
INSERT INTO smile VALUES("662",".роза7.","19");
INSERT INTO smile VALUES("663",".роза8.","19");
INSERT INTO smile VALUES("664",".роза9.","19");
INSERT INTO smile VALUES("665",".сромашкой.","19");
INSERT INTO smile VALUES("670",".баскет.","22");
INSERT INTO smile VALUES("667",".тюльпан.","19");
INSERT INTO smile VALUES("671",".баскетбол.","22");
INSERT INTO smile VALUES("672",".бегун.","22");
INSERT INTO smile VALUES("673",".бейсбол.","22");
INSERT INTO smile VALUES("674",".бест.","22");
INSERT INTO smile VALUES("675",".бобслей.","22");
INSERT INTO smile VALUES("676",".бодибилд.","22");
INSERT INTO smile VALUES("677",".бодибилд2.","22");
INSERT INTO smile VALUES("678",".боксер.","22");
INSERT INTO smile VALUES("679",".бокс.","22");
INSERT INTO smile VALUES("680",".цска.","22");
INSERT INTO smile VALUES("681",".дайвер.","22");
INSERT INTO smile VALUES("682",".дайвер2.","22");
INSERT INTO smile VALUES("683",".динамо.","22");
INSERT INTO smile VALUES("684",".динамо2.","22");
INSERT INTO smile VALUES("685",".фанат.","22");
INSERT INTO smile VALUES("686",".фанаты.","22");
INSERT INTO smile VALUES("687",".футб.","22");
INSERT INTO smile VALUES("688",".гантели.","22");
INSERT INTO smile VALUES("689",".гольф.","22");
INSERT INTO smile VALUES("690",".химки.","22");
INSERT INTO smile VALUES("691",".кач.","22");
INSERT INTO smile VALUES("692",".кубань.","22");
INSERT INTO smile VALUES("693",".лыжник.","22");
INSERT INTO smile VALUES("694",".лыжник2.","22");
INSERT INTO smile VALUES("695",".локо.","22");
INSERT INTO smile VALUES("696",".мяч.","22");
INSERT INTO smile VALUES("697",".москва.","22");
INSERT INTO smile VALUES("698",".налыжах.","22");
INSERT INTO smile VALUES("699",".нхл.","22");
INSERT INTO smile VALUES("700",".обруч.","22");
INSERT INTO smile VALUES("701",".олимп.","22");
INSERT INTO smile VALUES("708",".рубин.","22");
INSERT INTO smile VALUES("703",".парус.","22");
INSERT INTO smile VALUES("704",".плавает.","22");
INSERT INTO smile VALUES("705",".подводой.","22");
INSERT INTO smile VALUES("706",".ростов.","22");
INSERT INTO smile VALUES("707",".рыбалка2.","22");
INSERT INTO smile VALUES("709",".сатурн.","22");
INSERT INTO smile VALUES("710",".шахматы.","22");
INSERT INTO smile VALUES("711",".серфер.","22");
INSERT INTO smile VALUES("712",".сфлагом.","22");
INSERT INTO smile VALUES("713",".скакалка.","22");
INSERT INTO smile VALUES("714",".скакалка2.","22");
INSERT INTO smile VALUES("715",".скейт.","22");
INSERT INTO smile VALUES("716",".слуком.","22");
INSERT INTO smile VALUES("717",".спартак.","22");
INSERT INTO smile VALUES("718",".серф.","22");
INSERT INTO smile VALUES("719",".теннис.","22");
INSERT INTO smile VALUES("720",".теннис2.","22");
INSERT INTO smile VALUES("721",".тренинг.","22");
INSERT INTO smile VALUES("723",".вело2.","22");
INSERT INTO smile VALUES("724",".вело3.","22");
INSERT INTO smile VALUES("725",".водолаз.","22");
INSERT INTO smile VALUES("726",".водолаз2.","22");
INSERT INTO smile VALUES("727",".вплавь.","22");
INSERT INTO smile VALUES("728",".штанга.","22");
INSERT INTO smile VALUES("729",".штанга2.","22");
INSERT INTO smile VALUES("730",".штанга3.","22");
INSERT INTO smile VALUES("731",".зенит.","22");
INSERT INTO smile VALUES("732",".зенит2.","22");
INSERT INTO smile VALUES("733",".жанглер.","22");
INSERT INTO smile VALUES("734",".басков.","14");
INSERT INTO smile VALUES("735",".болею.","14");
INSERT INTO smile VALUES("736",".босс.","14");
INSERT INTO smile VALUES("737",".буба.","14");
INSERT INTO smile VALUES("738",".кактус.","14");
INSERT INTO smile VALUES("739",".чел.","14");
INSERT INTO smile VALUES("740",".командо.","14");
INSERT INTO smile VALUES("741",".командо2.","14");
INSERT INTO smile VALUES("742",".даров.","14");
INSERT INTO smile VALUES("743",".дева.","14");
INSERT INTO smile VALUES("744",".дева2.","14");
INSERT INTO smile VALUES("745",".электрик.","14");
INSERT INTO smile VALUES("746",".еврей.","14");
INSERT INTO smile VALUES("747",".фанат2.","14");
INSERT INTO smile VALUES("748",".фокусник.","14");
INSERT INTO smile VALUES("749",".гитлер.","14");
INSERT INTO smile VALUES("750",".индеец.","14");
INSERT INTO smile VALUES("751",".канабис.","14");
INSERT INTO smile VALUES("752",".капитан.","14");
INSERT INTO smile VALUES("753",".кинг.","14");
INSERT INTO smile VALUES("754",".клео.","14");
INSERT INTO smile VALUES("755",".клоун.","14");
INSERT INTO smile VALUES("757",".клоун3.","14");
INSERT INTO smile VALUES("758",".колдун.","14");
INSERT INTO smile VALUES("759",".колдун2.","14");
INSERT INTO smile VALUES("760",".король.","14");
INSERT INTO smile VALUES("761",".король2.","14");
INSERT INTO smile VALUES("762",".король3.","14");
INSERT INTO smile VALUES("763",".королева.","14");
INSERT INTO smile VALUES("764",".ковбой.","14");
INSERT INTO smile VALUES("765",".ковбой2.","14");
INSERT INTO smile VALUES("766",".крут.","14");
INSERT INTO smile VALUES("767",".курит.","14");
INSERT INTO smile VALUES("768",".ларису.","14");
INSERT INTO smile VALUES("769",".летает.","14");
INSERT INTO smile VALUES("770",".лучник1.","14");
INSERT INTO smile VALUES("771",".мафия.","14");
INSERT INTO smile VALUES("772",".маг.","14");
INSERT INTO smile VALUES("773",".ман2.","14");
INSERT INTO smile VALUES("774",".ман3.","14");
INSERT INTO smile VALUES("775",".мент.","14");
INSERT INTO smile VALUES("776",".мексиканец.","14");
INSERT INTO smile VALUES("777",".мушкетер.","14");
INSERT INTO smile VALUES("778",".мексиканец2.","14");
INSERT INTO smile VALUES("779",".наконе.","14");
INSERT INTO smile VALUES("780",".наполеон.","14");
INSERT INTO smile VALUES("781",".нео.","14");
INSERT INTO smile VALUES("782",".нитки.","14");
INSERT INTO smile VALUES("783",".новрус.","14");
INSERT INTO smile VALUES("784",".охотник.","14");
INSERT INTO smile VALUES("785",".пак.","14");
INSERT INTO smile VALUES("786",".пионер.","14");
INSERT INTO smile VALUES("787",".пират.","14");
INSERT INTO smile VALUES("788",".пират2.","14");
INSERT INTO smile VALUES("789",".писька.","14");
INSERT INTO smile VALUES("790",".погран.","14");
INSERT INTO smile VALUES("791",".порядок.","14");
INSERT INTO smile VALUES("792",".потер.","14");
INSERT INTO smile VALUES("793",".принцесса.","14");
INSERT INTO smile VALUES("794",".принцесса2.","14");
INSERT INTO smile VALUES("795",".пуф.","14");
INSERT INTO smile VALUES("796",".реп.","14");
INSERT INTO smile VALUES("797",".рыбак.","14");
INSERT INTO smile VALUES("798",".рыцарь.","14");
INSERT INTO smile VALUES("799",".рус.","14");
INSERT INTO smile VALUES("800",".рус2.","14");
INSERT INTO smile VALUES("801",".русалка.","14");
INSERT INTO smile VALUES("802",".рыбак2.","14");
INSERT INTO smile VALUES("803",".сестра.","14");
INSERT INTO smile VALUES("804",".шрек.","14");
INSERT INTO smile VALUES("805",".шут.","14");
INSERT INTO smile VALUES("806",".солдат.","14");
INSERT INTO smile VALUES("807",".студент.","14");
INSERT INTO smile VALUES("808",".студент2.","14");
INSERT INTO smile VALUES("809",".студент3.","14");
INSERT INTO smile VALUES("810",".томми.","14");
INSERT INTO smile VALUES("811",".тринити.","14");
INSERT INTO smile VALUES("812",".учен.","14");
INSERT INTO smile VALUES("813",".укр.","14");
INSERT INTO smile VALUES("814",".юса.","14");
INSERT INTO smile VALUES("815",".укр2.","14");
INSERT INTO smile VALUES("816",".воробей.","14");
INSERT INTO smile VALUES("817",".японец.","14");
INSERT INTO smile VALUES("818",".заболел.","14");
INSERT INTO smile VALUES("819",".замерз.","14");
INSERT INTO smile VALUES("820",".зк.","14");
INSERT INTO smile VALUES("821",".звезда.","14");
INSERT INTO smile VALUES("822",".апл2.","3");
INSERT INTO smile VALUES("823",".бегу.","3");
INSERT INTO smile VALUES("824",".бегу2.","3");
INSERT INTO smile VALUES("825",".безпон.","3");
INSERT INTO smile VALUES("826",".блин.","3");
INSERT INTO smile VALUES("827",".болельщица.","3");
INSERT INTO smile VALUES("828",".болен.","3");
INSERT INTO smile VALUES("829",".бреется.","3");
INSERT INTO smile VALUES("830",".будильник2.","3");
INSERT INTO smile VALUES("831",".будильник.","3");
INSERT INTO smile VALUES("832",".чай.","3");
INSERT INTO smile VALUES("833",".честь.","3");
INSERT INTO smile VALUES("834",".честь2.","3");
INSERT INTO smile VALUES("835",".чифа.","3");
INSERT INTO smile VALUES("836",".чих.","3");
INSERT INTO smile VALUES("837",".чистзуб.","3");
INSERT INTO smile VALUES("838",".чит.","3");
INSERT INTO smile VALUES("839",".чит2.","3");
INSERT INTO smile VALUES("840",".чит3.","3");
INSERT INTO smile VALUES("841",".читает.","3");
INSERT INTO smile VALUES("844",".дансе.","3");
INSERT INTO smile VALUES("845",".дарит.","3");
INSERT INTO smile VALUES("847",".довольно.","3");
INSERT INTO smile VALUES("848",".дождь.","3");
INSERT INTO smile VALUES("849",".дождь2.","3");
INSERT INTO smile VALUES("850",".дразнилка.","3");
INSERT INTO smile VALUES("851",".дрель.","3");
INSERT INTO smile VALUES("852",".дружба.","3");
INSERT INTO smile VALUES("853",".душ.","3");
INSERT INTO smile VALUES("854",".душ2.","3");
INSERT INTO smile VALUES("855",".двери.","3");
INSERT INTO smile VALUES("856",".дворник.","3");
INSERT INTO smile VALUES("857",".джентл.","3");
INSERT INTO smile VALUES("858",".еду.","3");
INSERT INTO smile VALUES("859",".фен.","3");
INSERT INTO smile VALUES("860",".фото.","3");
INSERT INTO smile VALUES("861",".фотограф.","3");
INSERT INTO smile VALUES("862",".галстук3.","3");
INSERT INTO smile VALUES("863",".газета.","3");
INSERT INTO smile VALUES("864",".геймеры.","3");
INSERT INTO smile VALUES("866",".гномы.","3");
INSERT INTO smile VALUES("867",".гончар.","3");
INSERT INTO smile VALUES("868",".гребет.","3");
INSERT INTO smile VALUES("869",".гуд.","3");
INSERT INTO smile VALUES("870",".хелпми.","3");
INSERT INTO smile VALUES("871",".худож.","3");
INSERT INTO smile VALUES("872",".игра.","3");
INSERT INTO smile VALUES("874",".играют.","3");
INSERT INTO smile VALUES("875",".инвалиды.","3");
INSERT INTO smile VALUES("876",".ирония.","3");
INSERT INTO smile VALUES("877",".изне.","3");
INSERT INTO smile VALUES("878",".изпола.","3");
INSERT INTO smile VALUES("879",".язык3.","3");
INSERT INTO smile VALUES("880",".картежник.","3");
INSERT INTO smile VALUES("881",".карты.","3");
INSERT INTO smile VALUES("882",".клеит.","3");
INSERT INTO smile VALUES("883",".колбасит.","3");
INSERT INTO smile VALUES("884",".колокол.","3");
INSERT INTO smile VALUES("885",".комполом.","3");
INSERT INTO smile VALUES("886",".конверт.","3");
INSERT INTO smile VALUES("887",".копилка.","3");
INSERT INTO smile VALUES("888",".ковыр2.","3");
INSERT INTO smile VALUES("889",".ковыр.","3");
INSERT INTO smile VALUES("890",".красит.","3");
INSERT INTO smile VALUES("891",".красит2.","3");
INSERT INTO smile VALUES("892",".крик.","3");
INSERT INTO smile VALUES("893",".кривится.","3");
INSERT INTO smile VALUES("894",".круг.","3");
INSERT INTO smile VALUES("895",".куб.","3");
INSERT INTO smile VALUES("897",".куку.","3");
INSERT INTO smile VALUES("898",".куку2.","3");
INSERT INTO smile VALUES("899",".кур.","3");
INSERT INTO smile VALUES("900",".кур2.","3");
INSERT INTO smile VALUES("901",".курица.","3");
INSERT INTO smile VALUES("902",".лак1.","3");
INSERT INTO smile VALUES("903",".манит.","3");
INSERT INTO smile VALUES("904",".марионетка.","3");
INSERT INTO smile VALUES("905",".марионетка2.","3");
INSERT INTO smile VALUES("906",".математик.","3");
INSERT INTO smile VALUES("907",".медит.","3");
INSERT INTO smile VALUES("908",".моб.","3");
INSERT INTO smile VALUES("909",".моетпол.","3");
INSERT INTO smile VALUES("910",".монашка.","3");
INSERT INTO smile VALUES("912",".муха.","3");
INSERT INTO smile VALUES("913",".накачели.","3");
INSERT INTO smile VALUES("914",".наконе2.","3");
INSERT INTO smile VALUES("915",".налуне.","3");
INSERT INTO smile VALUES("916",".наметле.","3");
INSERT INTO smile VALUES("917",".наразлив.","3");
INSERT INTO smile VALUES("918",".наухо.","3");
INSERT INTO smile VALUES("919",".назамок.","3");
INSERT INTO smile VALUES("920",".неоткр.","3");
INSERT INTO smile VALUES("921",".невидим.","3");
INSERT INTO smile VALUES("922",".найт.","3");
INSERT INTO smile VALUES("924",".оценки.","3");
INSERT INTO smile VALUES("925",".палец.","3");
INSERT INTO smile VALUES("926",".письмо.","3");
INSERT INTO smile VALUES("927",".пазл.","3");
INSERT INTO smile VALUES("928",".пепер.","3");
INSERT INTO smile VALUES("929",".пылесос.","3");
INSERT INTO smile VALUES("930",".пилит.","3");
INSERT INTO smile VALUES("931",".пиосмок.","3");
INSERT INTO smile VALUES("932",".пишу.","3");
INSERT INTO smile VALUES("933",".подарок.","3");
INSERT INTO smile VALUES("934",".подарок2.","3");
INSERT INTO smile VALUES("935",".подарок3.","3");
INSERT INTO smile VALUES("936",".поддержка.","3");
INSERT INTO smile VALUES("938",".поливает.","3");
INSERT INTO smile VALUES("939",".порукам.","3");
INSERT INTO smile VALUES("940",".порукам2.","3");
INSERT INTO smile VALUES("942",".посписку.","3");
INSERT INTO smile VALUES("943",".потелефону.","3");
INSERT INTO smile VALUES("944",".потяг.","3");
INSERT INTO smile VALUES("945",".поушам.","3");
INSERT INTO smile VALUES("947",".привет2.","3");
INSERT INTO smile VALUES("948",".привет3.","3");
INSERT INTO smile VALUES("949",".пробежала.","3");
INSERT INTO smile VALUES("950",".пузырьки.","3");
INSERT INTO smile VALUES("951",".пазл2.","3");
INSERT INTO smile VALUES("952",".пьет.","3");
INSERT INTO smile VALUES("953",".пьет2.","3");
INSERT INTO smile VALUES("954",".ракушка.","3");
INSERT INTO smile VALUES("955",".книга.","3");
INSERT INTO smile VALUES("956",".рога2.","3");
INSERT INTO smile VALUES("957",".рогатка.","3");
INSERT INTO smile VALUES("958",".рубанок.","3");
INSERT INTO smile VALUES("959",".рубик.","3");
INSERT INTO smile VALUES("960",".салон.","3");
INSERT INTO smile VALUES("961",".сальто.","3");
INSERT INTO smile VALUES("962",".шарик.","3");
INSERT INTO smile VALUES("963",".шляпки.","3");
INSERT INTO smile VALUES("964",".фен.","3");
INSERT INTO smile VALUES("965",".сгалстуком.","3");
INSERT INTO smile VALUES("966",".щелкает.","3");
INSERT INTO smile VALUES("967",".сключем.","3");
INSERT INTO smile VALUES("968",".скубком.","3");
INSERT INTO smile VALUES("969",".спит.","3");
INSERT INTO smile VALUES("970",".слупой.","3");
INSERT INTO smile VALUES("971",".слупой2.","3");
INSERT INTO smile VALUES("972",".смешком.","3");
INSERT INTO smile VALUES("973",".список.","3");
INSERT INTO smile VALUES("974",".спит2.","3");
INSERT INTO smile VALUES("975",".спят.","3");
INSERT INTO smile VALUES("976",".стопором.","3");
INSERT INTO smile VALUES("977",".свеником.","3");
INSERT INTO smile VALUES("978",".свистит.","3");
INSERT INTO smile VALUES("979",".свистун.","3");
INSERT INTO smile VALUES("980",".таблетки.","3");
INSERT INTO smile VALUES("981",".тел.","3");
INSERT INTO smile VALUES("982",".тел2.","3");
INSERT INTO smile VALUES("983",".томат.","3");
INSERT INTO smile VALUES("984",".указ.","3");
INSERT INTO smile VALUES("985",".улетел.","3");
INSERT INTO smile VALUES("986",".умник.","3");
INSERT INTO smile VALUES("987",".управ.","3");
INSERT INTO smile VALUES("988",".вазон.","3");
INSERT INTO smile VALUES("989",".вбанке.","3");
INSERT INTO smile VALUES("990",".вдуше.","3");
INSERT INTO smile VALUES("991",".венок.","3");
INSERT INTO smile VALUES("992",".вертушка.","3");
INSERT INTO smile VALUES("993",".вкресле.","3");
INSERT INTO smile VALUES("994",".вкресле2.","3");
INSERT INTO smile VALUES("995",".влужу.","3");
INSERT INTO smile VALUES("996",".внебо.","3");
INSERT INTO smile VALUES("997",".во.","3");
INSERT INTO smile VALUES("998",".вочках.","3");
INSERT INTO smile VALUES("999",".вокруг.","3");
INSERT INTO smile VALUES("1000",".время.","3");
INSERT INTO smile VALUES("1001",".вуду.","3");
INSERT INTO smile VALUES("1002",".вухе.","3");
INSERT INTO smile VALUES("1003",".вванную.","3");
INSERT INTO smile VALUES("1004",".вяжет.","3");
INSERT INTO smile VALUES("1005",".выглядывает.","3");
INSERT INTO smile VALUES("1006",".вышивает.","3");
INSERT INTO smile VALUES("1007",".вышивает2.","3");
INSERT INTO smile VALUES("1008",".взрыватель.","3");
INSERT INTO smile VALUES("1009",".велком.","3");
INSERT INTO smile VALUES("1010",".химия.","3");
INSERT INTO smile VALUES("1011",".хо.","3");
INSERT INTO smile VALUES("1013",".йойо.","3");
INSERT INTO smile VALUES("1014",".уес.","3");
INSERT INTO smile VALUES("1015",".уес2.","3");
INSERT INTO smile VALUES("1016",".забивает.","3");
INSERT INTO smile VALUES("1017",".задумался.","3");
INSERT INTO smile VALUES("1018",".задумчиво.","3");
INSERT INTO smile VALUES("1019",".закосички.","3");
INSERT INTO smile VALUES("1020",".зарядка.","3");
INSERT INTO smile VALUES("1021",".засып.","3");
INSERT INTO smile VALUES("1022",".заволосы.","3");
INSERT INTO smile VALUES("1023",".зашторой.","3");
INSERT INTO smile VALUES("1024",".зеркало.","3");
INSERT INTO smile VALUES("1025",".зеркало2.","3");
INSERT INTO smile VALUES("1026",".зевает.","3");
INSERT INTO smile VALUES("1027",".жопой.","3");
INSERT INTO smile VALUES("1028",".жиш.","3");
INSERT INTO smile VALUES("1029",".зомби.","3");
INSERT INTO smile VALUES("1030",".зонт.","3");
INSERT INTO smile VALUES("1031",".зубч.","3");
INSERT INTO smile VALUES("1049",".зуб.","6");
INSERT INTO smile VALUES("1050",".зуб2.","6");
INSERT INTO smile VALUES("1051",".гг.","6");
INSERT INTO smile VALUES("1054",".ахуеть.","10");
INSERT INTO smile VALUES("1053",".ценз.","10");
INSERT INTO smile VALUES("1055",".зоо.","23");
INSERT INTO smile VALUES("1056",".позор.","20");
INSERT INTO smile VALUES("1072",".кгам.","4");
INSERT INTO smile VALUES("1073",".симбас.","14");
INSERT INTO smile VALUES("1074",".пивос.","7");
INSERT INTO smile VALUES("1076",":сердит","24");
INSERT INTO smile VALUES("1077",":улыбка","24");
INSERT INTO smile VALUES("1078",":грусть","24");
INSERT INTO smile VALUES("1079",":дум","24");
INSERT INTO smile VALUES("1080",":хмур","24");
INSERT INTO smile VALUES("1081",":сум","24");
INSERT INTO smile VALUES("1082",":подмиг","24");
INSERT INTO smile VALUES("1083",":злой","24");
INSERT INTO smile VALUES("1084",":лыба","24");
INSERT INTO smile VALUES("1085",":плак","24");
INSERT INTO smile VALUES("1086",":язык","24");
INSERT INTO smile VALUES("1087",":ах","24");
INSERT INTO smile VALUES("1088",":фигасе","24");
INSERT INTO smile VALUES("1089",":мечт","24");
INSERT INTO smile VALUES("1090",":люб","24");
INSERT INTO smile VALUES("1091",":сплю","24");
INSERT INTO smile VALUES("1092",":рад","24");
INSERT INTO smile VALUES("1093",":зев","24");
INSERT INTO smile VALUES("1094","(H)","24");
INSERT INTO smile VALUES("1095",".йух2.","23");
INSERT INTO smile VALUES("1097",":simsim","10");
INSERT INTO smile VALUES("1152",".мумия.","13");
INSERT INTO smile VALUES("1153",".приведение1.","13");
INSERT INTO smile VALUES("1154",".тыква.","13");
INSERT INTO smile VALUES("1155",".приведение2.","13");
INSERT INTO smile VALUES("1156",".дракула1.","13");
INSERT INTO smile VALUES("1157",".хэллоуин.","13");
INSERT INTO smile VALUES("1158",".хэллоуин1.","13");
INSERT INTO smile VALUES("1168",".че.","21");
INSERT INTO smile VALUES("1169",":(","21");
INSERT INTO smile VALUES("1170",":D","21");
INSERT INTO smile VALUES("1186",".язык.","21");
INSERT INTO smile VALUES("1173",".миг.","21");
INSERT INTO smile VALUES("1174",".крут.","21");
INSERT INTO smile VALUES("1175",".секрет.","21");
INSERT INTO smile VALUES("1182",".ах.","21");
INSERT INTO smile VALUES("1183",".кисс.","21");



DROP TABLE IF EXISTS `smile_dir`;

CREATE TABLE `smile_dir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `opis` varchar(320) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=utf8;

INSERT INTO smile_dir VALUES("3","Действия","");
INSERT INTO smile_dir VALUES("4","Добро и Зло","");
INSERT INTO smile_dir VALUES("5","Драки и Оружие","");
INSERT INTO smile_dir VALUES("6","Дурдом","");
INSERT INTO smile_dir VALUES("7","Еда и Напитки","");
INSERT INTO smile_dir VALUES("8","Жесты","");
INSERT INTO smile_dir VALUES("9","Животные","");
INSERT INTO smile_dir VALUES("10","Значки и Надписи","");
INSERT INTO smile_dir VALUES("11","Любовь","");
INSERT INTO smile_dir VALUES("12","Музыка","");
INSERT INTO smile_dir VALUES("13","Праздники","");
INSERT INTO smile_dir VALUES("14","Персонажи","");
INSERT INTO smile_dir VALUES("15","Разное","");
INSERT INTO smile_dir VALUES("16","Семья","");
INSERT INTO smile_dir VALUES("22","Спорт","");
INSERT INTO smile_dir VALUES("18","Техника","");
INSERT INTO smile_dir VALUES("19","Цветы","");
INSERT INTO smile_dir VALUES("20","Эмоции","");
INSERT INTO smile_dir VALUES("21","Общие","");
INSERT INTO smile_dir VALUES("23","Секс","");
INSERT INTO smile_dir VALUES("24","Квадратные","");



DROP TABLE IF EXISTS `spamus`;

CREATE TABLE `spamus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `msg` varchar(512) DEFAULT NULL,
  `razdel` varchar(40) DEFAULT NULL,
  `id_spam` int(11) NOT NULL,
  `types` int(11) DEFAULT '0',
  `time` int(12) DEFAULT NULL,
  `id_post` int(111) DEFAULT NULL,
  `spam` varchar(1000) DEFAULT NULL,
  `id_object` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `status`;

CREATE TABLE `status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  `like` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `pokaz` int(11) NOT NULL,
  `rating` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO status VALUES("1","5","Всем добра от Вики =)","0","1487576801","1","0");
INSERT INTO status VALUES("2","6","Жми класс если мусульманин?!","0","1487577225","1","0");
INSERT INTO status VALUES("3","7","Семья это самое лучшее что надо создавать в этой мире .семья.","0","1487594123","1","0");
INSERT INTO status VALUES("4","8","Ингуш упал в воду и вода стало Ингушской .шахиды.","0","1487594789","1","0");
INSERT INTO status VALUES("5","1","Плохой сын, хорошей матери!.ангел4.","0","1487596013","1","0");
INSERT INTO status VALUES("7","10","Россия для Русских :D","0","1487596564","1","0");
INSERT INTO status VALUES("8","2","По вызову. 1 час - 2500 руб. Москва/Россия","0","1487692757","1","0");



DROP TABLE IF EXISTS `status_komm`;

CREATE TABLE `status_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  `like` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `id_status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO status_komm VALUES("1","7","красивый статус) и ты не плохой* .кисс.","0","1487596066","5");
INSERT INTO status_komm VALUES("2","9","От души пацан .хорош.","0","1487596116","5");



DROP TABLE IF EXISTS `status_like`;

CREATE TABLE `status_like` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `id_status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

INSERT INTO status_like VALUES("1","1","1487582955","2");
INSERT INTO status_like VALUES("2","1","1487594157","3");
INSERT INTO status_like VALUES("3","7","1487596044","5");
INSERT INTO status_like VALUES("4","8","1487596081","5");
INSERT INTO status_like VALUES("5","9","1487596106","5");
INSERT INTO status_like VALUES("6","6","1487596162","5");
INSERT INTO status_like VALUES("7","10","1487596665","5");
INSERT INTO status_like VALUES("8","12","1487690024","2");
INSERT INTO status_like VALUES("9","2","1487692863","5");
INSERT INTO status_like VALUES("10","1","1487693331","8");
INSERT INTO status_like VALUES("11","6","1487712579","1");



DROP TABLE IF EXISTS `stena`;

CREATE TABLE `stena` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_stena` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(1024) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `read` int(11) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `stena_like`;

CREATE TABLE `stena_like` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_stena` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `stol_admin`;

CREATE TABLE `stol_admin` (
  `nick` text NOT NULL,
  `pass` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO stol_admin VALUES("Admin","12345");



DROP TABLE IF EXISTS `stol_infzak`;

CREATE TABLE `stol_infzak` (
  `nomer` int(11) NOT NULL,
  `status` text,
  `koment` text,
  `ssylka` text
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `stol_kategory`;

CREATE TABLE `stol_kategory` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kat` text,
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=cp1251;

INSERT INTO stol_kategory VALUES("1","Учебники");
INSERT INTO stol_kategory VALUES("2","Видео");
INSERT INTO stol_kategory VALUES("5","Музыка");
INSERT INTO stol_kategory VALUES("3","Картинки");
INSERT INTO stol_kategory VALUES("4","Игры");
INSERT INTO stol_kategory VALUES("6","Темы");
INSERT INTO stol_kategory VALUES("7","Программы");
INSERT INTO stol_kategory VALUES("8","Скрипты");
INSERT INTO stol_kategory VALUES("9","Другое");



DROP TABLE IF EXISTS `stol_zakaz`;

CREATE TABLE `stol_zakaz` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `aftar` text,
  `names` text,
  `kategory` text,
  `nick` text,
  `status` text,
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO stol_zakaz VALUES("1","Каспийский груз","Доедишь пиши","5","1","on");
INSERT INTO stol_zakaz VALUES("2","Николь","Danger dash","4","6","on");



DROP TABLE IF EXISTS `survey_v`;

CREATE TABLE `survey_v` (
  `id_s` int(11) NOT NULL,
  `id_r` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  KEY `id_s` (`id_s`,`id_r`,`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `tape`;

CREATE TABLE `tape` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `count` int(11) NOT NULL,
  `id_file` int(11) NOT NULL,
  `avtor` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `type` varchar(24) NOT NULL,
  `read` set('0','1') NOT NULL DEFAULT '0',
  `avatar` int(11) DEFAULT '0',
  `ot_kogo` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`,`avtor`),
  KEY `read` (`read`)
) ENGINE=MyISAM AUTO_INCREMENT=61 DEFAULT CHARSET=utf8;

INSERT INTO tape VALUES("1","1","3","3","3","1487519566","album","1","0","");
INSERT INTO tape VALUES("2","1","1","1","2","1487533647","groups_topic","1","0","1");
INSERT INTO tape VALUES("3","2","5","1","1","1487577954","album","0","0","");
INSERT INTO tape VALUES("4","3","5","1","1","1487577954","album","0","0","");
INSERT INTO tape VALUES("5","4","5","1","1","1487577954","album","0","0","");
INSERT INTO tape VALUES("6","5","5","1","1","1487577954","album","0","0","");
INSERT INTO tape VALUES("7","6","5","1","1","1487577954","album","1","0","");
INSERT INTO tape VALUES("8","2","0","2","6","1487582955","status_like","0","0","1");
INSERT INTO tape VALUES("9","3","0","2","6","1487582955","status_like","0","0","1");
INSERT INTO tape VALUES("10","4","0","2","6","1487582955","status_like","0","0","1");
INSERT INTO tape VALUES("11","5","0","2","6","1487582955","status_like","0","0","1");
INSERT INTO tape VALUES("12","2","0","3","7","1487594157","status_like","0","0","1");
INSERT INTO tape VALUES("13","3","0","3","7","1487594157","status_like","0","0","1");
INSERT INTO tape VALUES("14","4","0","3","7","1487594157","status_like","0","0","1");
INSERT INTO tape VALUES("15","5","0","3","7","1487594157","status_like","0","0","1");
INSERT INTO tape VALUES("16","6","0","3","7","1487594157","status_like","1","0","1");
INSERT INTO tape VALUES("17","2","1","7","1","1487594225","frends","0","0","");
INSERT INTO tape VALUES("18","3","1","7","1","1487594225","frends","0","0","");
INSERT INTO tape VALUES("19","4","1","7","1","1487594225","frends","0","0","");
INSERT INTO tape VALUES("20","5","1","7","1","1487594225","frends","0","0","");
INSERT INTO tape VALUES("21","6","1","7","1","1487594225","frends","1","0","");
INSERT INTO tape VALUES("22","1","0","3","7","1487594585","them","1","0","");
INSERT INTO tape VALUES("23","1","0","4","6","1487595562","them","1","0","");
INSERT INTO tape VALUES("24","2","0","5","1","1487596013","status","0","0","1");
INSERT INTO tape VALUES("25","3","0","5","1","1487596013","status","0","0","1");
INSERT INTO tape VALUES("26","4","0","5","1","1487596013","status","0","0","1");
INSERT INTO tape VALUES("27","5","0","5","1","1487596013","status","0","0","1");
INSERT INTO tape VALUES("28","6","0","5","1","1487596013","status","1","0","1");
INSERT INTO tape VALUES("29","7","0","5","1","1487596013","status","1","0","1");
INSERT INTO tape VALUES("30","2","1","1","1","1487597244","obmen","0","0","");
INSERT INTO tape VALUES("31","3","1","1","1","1487597244","obmen","0","0","");
INSERT INTO tape VALUES("32","4","1","1","1","1487597244","obmen","0","0","");
INSERT INTO tape VALUES("33","5","1","1","1","1487597244","obmen","0","0","");
INSERT INTO tape VALUES("34","6","1","1","1","1487597244","obmen","0","0","");
INSERT INTO tape VALUES("35","7","1","1","1","1487597244","obmen","0","0","");
INSERT INTO tape VALUES("36","8","1","1","1","1487597244","obmen","0","0","");
INSERT INTO tape VALUES("37","2","1","12","1","1487691796","frends","0","0","");
INSERT INTO tape VALUES("38","3","1","12","1","1487691796","frends","0","0","");
INSERT INTO tape VALUES("39","4","1","12","1","1487691796","frends","0","0","");
INSERT INTO tape VALUES("40","5","1","12","1","1487691796","frends","0","0","");
INSERT INTO tape VALUES("41","6","1","12","1","1487691796","frends","0","0","");
INSERT INTO tape VALUES("42","7","1","12","1","1487691796","frends","0","0","");
INSERT INTO tape VALUES("43","8","1","12","1","1487691796","frends","0","0","");
INSERT INTO tape VALUES("44","2","0","1","1","1487692088","notes","0","0","");
INSERT INTO tape VALUES("45","3","0","1","1","1487692088","notes","0","0","");
INSERT INTO tape VALUES("46","4","0","1","1","1487692088","notes","0","0","");
INSERT INTO tape VALUES("47","5","0","1","1","1487692088","notes","0","0","");
INSERT INTO tape VALUES("48","6","0","1","1","1487692088","notes","0","0","");
INSERT INTO tape VALUES("49","7","0","1","1","1487692088","notes","0","0","");
INSERT INTO tape VALUES("50","8","0","1","1","1487692088","notes","0","0","");
INSERT INTO tape VALUES("51","12","0","1","1","1487692088","notes","1","0","");
INSERT INTO tape VALUES("52","1","0","8","2","1487692757","status","1","0","2");
INSERT INTO tape VALUES("53","3","0","8","2","1487693331","status_like","0","0","1");
INSERT INTO tape VALUES("54","4","0","8","2","1487693331","status_like","0","0","1");
INSERT INTO tape VALUES("55","5","0","8","2","1487693331","status_like","0","0","1");
INSERT INTO tape VALUES("56","6","0","8","2","1487693331","status_like","0","0","1");
INSERT INTO tape VALUES("57","7","0","8","2","1487693331","status_like","0","0","1");
INSERT INTO tape VALUES("58","8","0","8","2","1487693331","status_like","0","0","1");
INSERT INTO tape VALUES("59","12","0","8","2","1487693331","status_like","1","0","1");
INSERT INTO tape VALUES("60","1","0","1","5","1487712579","status_like","1","0","6");



DROP TABLE IF EXISTS `tape_set`;

CREATE TABLE `tape_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `lenta_status_like` int(11) DEFAULT '1',
  `lenta_status` int(11) DEFAULT '1',
  `lenta_foto` int(11) DEFAULT '1',
  `lenta_files` int(11) DEFAULT '1',
  `lenta_forum` int(11) DEFAULT '1',
  `lenta_notes` int(11) DEFAULT '1',
  `lenta_avatar` int(11) DEFAULT '1',
  `lenta_frends` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

INSERT INTO tape_set VALUES("1","1","1","1","1","1","1","1","1","1");
INSERT INTO tape_set VALUES("2","2","1","1","1","1","1","1","1","1");
INSERT INTO tape_set VALUES("3","3","1","1","1","1","1","1","1","1");
INSERT INTO tape_set VALUES("4","4","1","1","1","1","1","1","1","1");
INSERT INTO tape_set VALUES("5","5","1","1","1","1","1","1","1","1");
INSERT INTO tape_set VALUES("6","6","1","1","1","1","1","1","1","1");
INSERT INTO tape_set VALUES("7","7","1","1","1","1","1","1","1","1");
INSERT INTO tape_set VALUES("8","8","1","1","1","1","1","1","1","1");
INSERT INTO tape_set VALUES("9","9","1","1","1","1","1","1","1","1");
INSERT INTO tape_set VALUES("10","10","1","1","1","1","1","1","1","1");
INSERT INTO tape_set VALUES("11","11","1","1","1","1","1","1","1","1");
INSERT INTO tape_set VALUES("12","12","1","1","1","1","1","1","1","1");
INSERT INTO tape_set VALUES("13","13","1","1","1","1","1","1","1","1");
INSERT INTO tape_set VALUES("14","14","1","1","1","1","1","1","1","1");
INSERT INTO tape_set VALUES("15","15","1","1","1","1","1","1","1","1");
INSERT INTO tape_set VALUES("16","16","1","1","1","1","1","1","1","1");
INSERT INTO tape_set VALUES("17","17","1","1","1","1","1","1","1","1");
INSERT INTO tape_set VALUES("18","18","1","1","1","1","1","1","1","1");
INSERT INTO tape_set VALUES("19","19","1","1","1","1","1","1","1","1");
INSERT INTO tape_set VALUES("20","20","1","1","1","1","1","1","1","1");



DROP TABLE IF EXISTS `us_icons`;

CREATE TABLE `us_icons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_icon` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO us_icons VALUES("1","1","66","1488123143");



DROP TABLE IF EXISTS `user`;

CREATE TABLE `user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nick` varchar(32) NOT NULL,
  `pass` varchar(32) NOT NULL,
  `sess` varchar(32) DEFAULT NULL,
  `activation` varchar(32) DEFAULT NULL,
  `ban` int(11) NOT NULL DEFAULT '0',
  `ban_pr` varchar(64) DEFAULT NULL,
  `ip` bigint(20) NOT NULL DEFAULT '0',
  `ip_cl` bigint(20) NOT NULL DEFAULT '0',
  `ip_xff` bigint(20) NOT NULL DEFAULT '0',
  `ua` varchar(32) DEFAULT NULL,
  `date_reg` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `date_aut` int(11) NOT NULL DEFAULT '0',
  `date_last` int(11) NOT NULL DEFAULT '0',
  `balls` int(11) NOT NULL DEFAULT '0',
  `rating` int(11) NOT NULL DEFAULT '0',
  `level` enum('0','1','2','3','4') NOT NULL DEFAULT '0',
  `group_access` int(10) unsigned NOT NULL DEFAULT '1',
  `pol` enum('0','1') NOT NULL DEFAULT '1',
  `url` varchar(64) NOT NULL DEFAULT '/',
  `show_url` enum('0','1') NOT NULL DEFAULT '1',
  `ank_g_r` int(4) DEFAULT NULL,
  `ank_m_r` int(2) DEFAULT NULL,
  `ank_d_r` int(2) DEFAULT NULL,
  `ank_city` varchar(32) DEFAULT NULL,
  `ank_o_sebe` varchar(512) DEFAULT NULL,
  `ank_icq` int(9) DEFAULT NULL,
  `ank_skype` varchar(16) DEFAULT NULL,
  `ank_mail` varchar(32) DEFAULT NULL,
  `ank_n_tel` varchar(11) DEFAULT NULL,
  `ank_name` varchar(32) DEFAULT NULL,
  `set_time_chat` int(11) DEFAULT '30',
  `set_p_str` int(11) DEFAULT '7',
  `set_show_icon` set('0','1','2') DEFAULT '1',
  `set_translit` enum('0','1') NOT NULL DEFAULT '1',
  `set_files` enum('0','1') NOT NULL DEFAULT '0',
  `set_timesdvig` int(11) NOT NULL DEFAULT '0',
  `set_news_to_mail` enum('0','1') NOT NULL DEFAULT '0',
  `set_show_mail` enum('0','1') NOT NULL DEFAULT '0',
  `set_them` varchar(32) DEFAULT 'default',
  `set_them2` varchar(32) DEFAULT 'default',
  `meteo_country` int(11) NOT NULL DEFAULT '0',
  `autorization` enum('0','1') NOT NULL DEFAULT '0',
  `add_konts` enum('0','1','2') NOT NULL DEFAULT '1',
  `wall` int(1) DEFAULT '1',
  `browser` varchar(3) DEFAULT 'wap',
  `ank_rost` int(11) DEFAULT NULL,
  `ank_ves` int(11) DEFAULT NULL,
  `ank_telosl` int(1) NOT NULL,
  `ank_cvet_glas` varchar(11) NOT NULL,
  `ank_volos` varchar(11) NOT NULL,
  `ank_orien` int(1) DEFAULT '0',
  `ank_lov_1` int(11) DEFAULT '0',
  `ank_lov_2` int(11) DEFAULT '0',
  `ank_lov_3` int(11) DEFAULT '0',
  `ank_lov_4` int(11) DEFAULT '0',
  `ank_lov_5` int(11) DEFAULT '0',
  `ank_lov_6` int(11) DEFAULT '0',
  `ank_lov_7` int(11) DEFAULT '0',
  `ank_lov_8` int(11) DEFAULT '0',
  `ank_lov_9` int(11) DEFAULT '0',
  `ank_lov_10` int(11) DEFAULT '0',
  `ank_lov_11` int(11) DEFAULT '0',
  `ank_lov_12` int(11) DEFAULT '0',
  `ank_lov_13` int(11) DEFAULT '0',
  `ank_lov_14` int(11) DEFAULT '0',
  `ank_lov_15` int(11) DEFAULT '0',
  `ank_o_par` varchar(215) NOT NULL,
  `ank_zan` varchar(215) NOT NULL,
  `ank_smok` int(11) NOT NULL,
  `ank_mat_pol` int(11) NOT NULL,
  `ank_proj` int(11) NOT NULL,
  `ank_baby` int(11) NOT NULL,
  `ank_avto` varchar(215) NOT NULL,
  `ank_avto_n` int(11) NOT NULL,
  `ank_alko` varchar(215) DEFAULT NULL,
  `ank_alko_n` int(11) DEFAULT '0',
  `ank_nark` int(11) DEFAULT '0',
  `rating_tmp` int(11) DEFAULT '0',
  `sort` int(1) DEFAULT '0',
  `news_read` int(1) DEFAULT '0',
  `ban_where` varchar(10) DEFAULT NULL,
  `abuld` int(1) DEFAULT '0',
  `vk_id` int(11) DEFAULT NULL,
  `type_reg` varchar(100) DEFAULT NULL,
  `identity` varchar(100) DEFAULT NULL,
  `set_nick` int(1) DEFAULT '0',
  `money` int(11) DEFAULT '0',
  `duels` int(11) NOT NULL,
  `id_sp` int(11) DEFAULT '0',
  `sem_poloj` enum('0','1','2','3','4','5','6','7','8','9','10','11','12','13','14') NOT NULL DEFAULT '0',
  `avtoritet` int(11) DEFAULT '0',
  `avtoritet_count` int(11) DEFAULT '0',
  `znakomstva_pokaz` int(11) NOT NULL DEFAULT '0',
  `znakomstva_orien` int(11) NOT NULL DEFAULT '0',
  `znakomstva_1` int(11) NOT NULL DEFAULT '0',
  `znakomstva_2` int(11) NOT NULL DEFAULT '0',
  `znakomstva_3` int(11) NOT NULL DEFAULT '0',
  `znakomstva_4` int(11) NOT NULL DEFAULT '0',
  `znakomstva_5` int(11) NOT NULL DEFAULT '0',
  `znakomstva_6` int(11) NOT NULL DEFAULT '0',
  `znakomstva_7` int(11) NOT NULL DEFAULT '0',
  `znakomstva_8` int(11) NOT NULL DEFAULT '0',
  `znakomstva_svad` int(11) NOT NULL DEFAULT '0',
  `znakomstva_ob` varchar(1024) DEFAULT NULL,
  `znakomstva_hochu_najti` int(11) NOT NULL DEFAULT '0',
  `znakomstva_voprosu` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros1_1` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros1_2` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros1_3` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros1_4` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros1_5` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros1_6` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros1_7` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros1_8` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros2_1` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros2_2` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros2_3` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros2_4` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros2_5` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros2_6` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros2_7` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros2_8` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros2_9` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros3` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros4_1` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros4_2` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros4_3` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros4_4` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros4_5` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros4_6` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros4_7` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros4_8` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros4_9` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros4_10` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros5` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros6_1` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros6_2` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros6_3` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros6_4` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros6_5` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros6_6` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros6_7` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vopros7` int(11) NOT NULL DEFAULT '0',
  `znakomstva_search_pol` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vozrast_ot` int(11) NOT NULL DEFAULT '0',
  `znakomstva_vozrast_do` int(11) NOT NULL DEFAULT '0',
  `znakomstva_search_or` int(11) NOT NULL DEFAULT '0',
  `znakomstva_search_cel` int(11) NOT NULL DEFAULT '0',
  `time_gift` int(11) NOT NULL,
  `birds_all` int(11) DEFAULT '0',
  `birds_sklad` int(11) DEFAULT '0',
  `birds_level` varchar(11) DEFAULT '0',
  `birds_1` int(11) DEFAULT '0',
  `birds_2` int(11) DEFAULT '0',
  `birds_3` int(11) DEFAULT '0',
  `birds_4` int(11) DEFAULT '0',
  `birds_5` int(11) DEFAULT '0',
  `birds_6` int(11) DEFAULT '0',
  `birds_1time` int(11) DEFAULT '0',
  `birds_2time` int(11) DEFAULT '0',
  `birds_3time` int(11) DEFAULT '0',
  `birds_4time` int(11) DEFAULT '0',
  `birds_5time` int(11) DEFAULT '0',
  `birds_6time` int(11) DEFAULT '0',
  `birds_1life` int(11) DEFAULT '0',
  `birds_2life` int(11) DEFAULT '0',
  `birds_3life` int(11) DEFAULT '0',
  `birds_4life` int(11) DEFAULT '0',
  `birds_5life` int(11) DEFAULT '0',
  `birds_6life` int(11) DEFAULT '0',
  `birds_1korm` int(11) DEFAULT '0',
  `birds_2korm` int(11) DEFAULT '0',
  `birds_3korm` int(11) DEFAULT '0',
  `birds_4korm` int(11) DEFAULT '0',
  `birds_5korm` int(11) DEFAULT '0',
  `birds_6korm` int(11) DEFAULT '0',
  `birds_money` int(11) DEFAULT '0',
  `birds_progress_korm` int(11) DEFAULT '0',
  `birds_progress_korm10` int(11) DEFAULT '0',
  `birds_progress_korm50` int(11) DEFAULT '0',
  `birds_progress_korm100` int(11) DEFAULT '0',
  `birds_progress_korm300` int(11) DEFAULT '0',
  `birds_progress_korm_time` int(11) DEFAULT '0',
  `birds_progress_sklad50` int(11) DEFAULT '0',
  `birds_progress_sklad150` int(11) DEFAULT '0',
  `birds_progress_sklad350` int(11) DEFAULT '0',
  `birds_progress_sklad1000` int(11) DEFAULT '0',
  `birds_progress_sklad_time` int(11) DEFAULT '0',
  `birds_progress_pay1` int(11) DEFAULT '0',
  `birds_progress_pay2` int(11) DEFAULT '0',
  `birds_progress_pay3` int(11) DEFAULT '0',
  `birds_progress_pay4` int(11) DEFAULT '0',
  `birds_progress_pay5` int(11) DEFAULT '0',
  `birds_progress_pay6` int(11) DEFAULT '0',
  `birds_progress_obmen100` int(11) DEFAULT '0',
  `birds_progress_obmen500` int(11) DEFAULT '0',
  `birds_progress_obmen1500` int(11) DEFAULT '0',
  `birds_progress_obmen3000` int(11) DEFAULT '0',
  `birds_progress_obmen5000` int(11) DEFAULT '0',
  `birds_progress_obmen10000` int(11) DEFAULT '0',
  `birds_progress_pay_time` int(11) DEFAULT '0',
  `birds_progress_obmen_time` int(11) DEFAULT '0',
  `birds_progress_obmenall` int(11) DEFAULT '0',
  `birds_progress_sklad` int(11) DEFAULT '0',
  `birds_hide` int(11) DEFAULT '0',
  `birds_zmoney` int(11) DEFAULT '0',
  `activday` int(11) NOT NULL DEFAULT '0',
  `ncolor2` varchar(10) NOT NULL,
  `ncolor` varchar(10) NOT NULL,
  `ank_country` varchar(40) NOT NULL,
  `ank_fam` varchar(60) NOT NULL,
  `podtv_reg_who` int(11) NOT NULL DEFAULT '0',
  `podtv_reg` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `nick` (`nick`),
  KEY `url` (`url`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

INSERT INTO user VALUES("1","DR7777","831563586fda43fc17402ff75e370d58","a86dbda2acaa485d16c69def8927076c","","0","","1600971208","0","0","Mozilla","1487491955","20488","1487744371","1487744393","2147479934","1000000","4","15","1","/exit.php","1","1995","12","21","Ингушетия","","","","","","Тима","30","7","1","1","0","0","0","0","default","default","0","0","1","0","web","","","0","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","0","0","0","0","","0","","0","0","28","0","0","","0","","","","0","2135072322","0","7","3","576","576","0","0","0","0","0","0","0","0","0","0","0","","0","1","0","0","0","0","1","0","0","1","0","0","0","0","0","0","1","0","0","4","0","0","0","1","0","0","0","0","0","0","4","0","0","0","1","1","0","0","8","0","0","0","0","0","1487619186","1","0","0","1","0","0","0","0","0","1487595693","0","0","0","0","0","1","0","0","0","0","0","1","0","0","0","0","0","14","1","0","0","0","0","0","0","0","0","0","0","1","0","0","0","0","0","0","0","0","0","0","0","1487592115","0","0","0","0","0","28","#0000FF","#00FF00","","","1","1");
INSERT INTO user VALUES("2","Alena","831563586fda43fc17402ff75e370d58","db9b56703198d6fb55b0d6f168f875b8","","0","","1600947686","0","0","Mozilla","1487492994","2655","1487697003","1487697049","5","0","0","1","0","/exit.php","1","","","","","","","","","","","30","7","1","1","0","0","0","0","default","default","0","0","1","0","web","","","0","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","0","0","0","0","","0","","0","0","13","0","0","","0","","","","0","195","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","1","1");
INSERT INTO user VALUES("3","Katy 177 reg","831563586fda43fc17402ff75e370d58","0c9b8fcaefebeb902b2629b14c41d4ab","","0","","1433663607","0","1433663607","Mozilla","1487506088","318","1487519499","1487519594","1","0","0","1","0","/exit.php","1","","","","","","","","","","","30","7","1","1","0","0","0","0","default","default","0","0","1","0","web","","","0","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","0","0","0","0","","0","","0","0","4","0","0","","0","","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","1","1");
INSERT INTO user VALUES("4","Bumer","831563586fda43fc17402ff75e370d58","dd9b491f4ff6bd93a7ac2d7031b41eb9","","0","","1433663509","0","1433663509","Mozilla","1487571917","110","0","1487572027","1","0","0","1","1","/exit.php","1","","","","","","","","","","","30","7","1","1","0","0","0","0","default","default","0","0","1","0","web","","","0","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","0","0","0","0","","0","","0","0","1","0","0","","0","","","","0","0","0","0","1","0","0","0","0","0","0","0","0","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","1","1");
INSERT INTO user VALUES("5","Vika_Tigr","831563586fda43fc17402ff75e370d58","b6b3598b407b7f328e3129c74ca8ca94","","0","","1433663576","0","1433663576","Mozilla","1487576711","567","1487577756","1487577781","167674248","0","0","1","0","/exit.php","1","1995","3","3","Питер","","","","","89991995888","Вика","30","7","1","1","0","0","0","0","default","default","0","0","1","0","web","","70","0","","Черные","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","0","0","0","0","","0","","0","0","12","0","0","","0","","","","0","99770","0","0","1","384","384","0","0","0","0","0","0","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","1487580666","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","1","1");
INSERT INTO user VALUES("6","Liana05","831563586fda43fc17402ff75e370d58","677f970b67471f7fb8b8b3174c10eb84","","0","","1600947666","0","0","Mozilla","1487577154","881","1487712328","1487712603","2147482949","10","0","1","1","/exit.php","1","","","","","","","","","","","30","7","1","1","0","0","0","0","default","default","0","0","1","0","web","","","0","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","0","0","0","0","","0","","0","0","8","0","0","","0","","","","0","99850","0","0","0","320","320","0","0","0","0","0","0","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","1487581292","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","4","","","","","1","1");
INSERT INTO user VALUES("7","Зуля","831563586fda43fc17402ff75e370d58","6603c59ddca280fa7c2f7720b86e5259","","0","","1600971208","0","0","Mozilla","1487592970","2058","1487744414","1487744495","2147476756","2","0","9","0","/index.php","1","1993","10","4","Назрань","","","Lolove1998","","8928000000","Зульфия","30","7","1","1","0","0","0","0","default","default","0","0","1","0","web","168","65","3","Карие","Черные","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","0","0","0","0","","0","","0","0","30","0","0","","0","","","","0","12211991","0","1","3","1344","1344","0","0","0","0","0","0","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","1487596816","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","5","","","","","1","1");
INSERT INTO user VALUES("8","Дзейтов Мага","831563586fda43fc17402ff75e370d58","98660af8903aeb5bd9bdac5de1a07963","","0","","1433663586","0","1433663586","Mozilla","1487594708","718","1487596076","1487596088","6","0","0","1","1","/exit.php","1","1995","3","4","Сунжа","","","","","","Мага","30","7","1","1","0","0","0","0","default","default","0","0","1","0","web","","","0","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","0","0","0","0","","0","","0","0","9","0","0","","0","","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","1","1");
INSERT INTO user VALUES("9","Чеченец 95","831563586fda43fc17402ff75e370d58","fa01e00419bf57ee3fed0ee893553b33","","0","","1433663586","0","1433663586","Mozilla","1487595175","338","1487596098","1487596131","1","0","0","1","1","/exit.php","1","1992","10","10","Грозный","","","","","","Ислам","30","7","1","1","0","0","0","0","default","default","0","0","1","0","web","","","0","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","0","0","0","0","","0","","0","0","3","0","0","","0","","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","1","1");
INSERT INTO user VALUES("10","Русский","831563586fda43fc17402ff75e370d58","a9847bb6fcb789f1f91ae7a469b46ea2","","0","","1433663586","0","1433663586","Mozilla","1487596425","491","0","1487596915","3","0","0","1","1","/exit.php","1","1992","10","6","Хабаровск","","","","","89991009234","Катя","30","7","1","1","0","0","0","0","default","default","0","0","1","0","web","168","70","3","Карие","","0","1","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","0","0","0","0","","0","","0","0","15","0","0","","0","","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","1","1");
INSERT INTO user VALUES("11","amfetaminf","163ffd4af93a0dc8089dab3264581ba1","afeb9b5c27c5cd2ecaa9aea7acf98891","","0","","2192888690","0","2192888690","Mozilla","1487598025","372","0","1487598536","3","0","0","1","1","/foto/index.php","1","","","","","","","","","","","30","7","1","1","0","0","0","0","default","default","0","0","1","0","web","","","0","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","0","0","0","0","","0","","0","0","9","0","0","","0","","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","","","1","1");
INSERT INTO user VALUES("12","марсель","ab2dde8279f775de74008ccb9f32f0d7","863c79b3eeb02927d6d6e0a99d102fea","","0","","86884432","0","0","Mozilla","1487689813","1057","1487736669","1487737350","1","0","0","1","1","/index.php","1","","","","","","","","","","","30","7","1","1","0","0","0","0","default","default","0","0","1","0","web","","","0","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","0","0","0","0","","0","","0","0","2","0","0","","0","","","","0","0","0","0","1","0","0","0","0","0","0","0","0","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","1487693642","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","4","","","","","1","1");
INSERT INTO user VALUES("13","FoolGreen","831563586fda43fc17402ff75e370d58","94130ea17023c4837f0dcdda95034b65","","0","","1433663510","0","1433663510","Mozilla","1487704672","14","0","1487704686","0","0","0","1","0","/exit.php","1","1994","1","1","Троицк","","","","","","Евлоев","30","7","1","1","0","0","0","0","default","default","0","0","1","1","web","","","0","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","0","0","0","0","","0","","0","0","0","0","0","","0","","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","Россия","Адам","1","1");
INSERT INTO user VALUES("14","Ivan7777","fc42981c092b7b335ae1a61fc68ddc84","aae1a1099bd9efcfae9dd2db797c3a27","","0","","1600947666","0","0","Mozilla","1487708608","487","0","1487709095","1","0","0","1","1","/exit.php","1","2000","2","21","Белгород","","","","","","Александр","30","7","1","1","0","0","0","0","default","default","0","0","1","1","web","","","0","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","0","0","0","0","","0","","0","0","1","0","0","","0","","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","Россия","Иванов","1","1");
INSERT INTO user VALUES("15","Bel_Gisha","7f2aaa0be6adf74fcb34f93819d43aa9","b71c5d361ab83c67856270985cc2d1a0","","0","","1600947666","0","0","Mozilla","1487709159","122","0","1487709281","0","0","0","1","1","/exit.php","1","1971","2","21","Белорусь","","","","","","Леонид","30","7","1","1","0","0","0","0","default","default","0","0","1","1","web","","","0","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","0","0","0","0","","0","","0","0","0","0","0","","0","","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","Россия","Григорьев","1","1");
INSERT INTO user VALUES("17","ivan.petrov@mail.ru","6b4483d3140901c50faa0f3c0c64b705","9484e6403fdc611e42ff3a14b1fa6eb8","","0","","2192888938","0","2192888938","Mozilla","1487719079","190","0","1487719269","1","0","0","1","1","/ask/index.php","1","0","0","0","","","","","","","","30","7","1","1","0","0","0","0","default","default","0","0","1","1","web","","","0","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","0","0","0","0","","0","","0","0","1","0","0","","0","","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","1","","","","","1","1");
INSERT INTO user VALUES("16","Настя Швецова","831563586fda43fc17402ff75e370d58","a4623522538df5dd12c83cfef527c5fd","","0","","1600947652","0","0","Mozilla","1487718155","52","1487736352","1487736385","1","0","0","1","1","/exit.php","1","1994","2","22","Москва","","","","","","Настя","30","7","1","1","0","0","0","0","default","default","0","0","1","1","web","","","0","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","0","0","0","0","","0","","0","0","2","0","0","","0","","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","2","","","Россия","Швец","1","1");
INSERT INTO user VALUES("18","Milena_Mahach","ef5a7421dd8b6ee3c0eea2e397540815","65053e8f552cd0c9a0472346393c33ea","","0","","1600947652","0","0","Mozilla","1487736477","106","0","1487736583","0","0","0","1","1","/index.php","1","1991","2","23","Махачкала","","","","","","Милена","30","7","1","1","0","0","0","0","default","default","0","0","1","1","web","","","0","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","0","0","0","0","","0","","0","0","0","0","0","","0","","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","2","","","Россия","Магамедова","7","1");
INSERT INTO user VALUES("19","forevil","93a2222f7510bba0d950ad83c8638bb6","006f22bb8af6302fa009df458a3cc5f1","","0","","1385290938","0","0","Mozilla","1487737730","10","0","1487737740","0","0","0","1","1","/avatar.php","1","1997","12","22","Курган","","","","","","Евгений","30","7","1","1","0","0","0","0","default","default","0","0","1","1","web","","","0","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","0","0","0","0","","0","","0","0","0","0","0","","0","","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","Россия","Андреев","7","1");
INSERT INTO user VALUES("20","mitroli@bk.tu","95cf3e5b05726c5c3af4bdc881804e30","621590e2d5fdb6848161bd040d491e47","","0","","1433663557","0","1433663557","Mozilla","1487741191","47","0","1487741238","1","0","0","1","1","/reg_users/index.php","1","2003","5","5","allah","","","","","","lilllll","30","7","1","1","0","0","0","0","default","default","0","0","1","1","wap","","","0","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","0","0","0","0","","0","","0","0","1","0","0","","0","","","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","","","Албания","fsdkkfxs","7","2");



DROP TABLE IF EXISTS `user_apps`;

CREATE TABLE `user_apps` (
  `id_user` int(11) NOT NULL,
  `id_apps` varchar(100) NOT NULL,
  `time` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO user_apps VALUES("1","3","1487615645");



DROP TABLE IF EXISTS `user_collision`;

CREATE TABLE `user_collision` (
  `id_user` int(11) NOT NULL,
  `id_user2` int(11) NOT NULL,
  `type` set('sess','ip_ua_time') NOT NULL DEFAULT 'sess',
  KEY `id_user` (`id_user`,`id_user2`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO user_collision VALUES("2","1","ip_ua_time");
INSERT INTO user_collision VALUES("3","1","ip_ua_time");
INSERT INTO user_collision VALUES("1","4","ip_ua_time");
INSERT INTO user_collision VALUES("5","1","ip_ua_time");
INSERT INTO user_collision VALUES("6","1","ip_ua_time");
INSERT INTO user_collision VALUES("6","5","ip_ua_time");
INSERT INTO user_collision VALUES("7","1","ip_ua_time");
INSERT INTO user_collision VALUES("8","7","ip_ua_time");
INSERT INTO user_collision VALUES("1","8","ip_ua_time");
INSERT INTO user_collision VALUES("9","1","ip_ua_time");
INSERT INTO user_collision VALUES("9","7","ip_ua_time");
INSERT INTO user_collision VALUES("9","8","ip_ua_time");
INSERT INTO user_collision VALUES("6","7","ip_ua_time");
INSERT INTO user_collision VALUES("6","8","ip_ua_time");
INSERT INTO user_collision VALUES("6","9","ip_ua_time");
INSERT INTO user_collision VALUES("10","1","ip_ua_time");
INSERT INTO user_collision VALUES("10","6","ip_ua_time");
INSERT INTO user_collision VALUES("10","7","ip_ua_time");
INSERT INTO user_collision VALUES("10","8","ip_ua_time");
INSERT INTO user_collision VALUES("10","9","ip_ua_time");
INSERT INTO user_collision VALUES("6","2","ip_ua_time");
INSERT INTO user_collision VALUES("13","1","ip_ua_time");
INSERT INTO user_collision VALUES("14","1","ip_ua_time");
INSERT INTO user_collision VALUES("15","14","ip_ua_time");
INSERT INTO user_collision VALUES("1","15","ip_ua_time");
INSERT INTO user_collision VALUES("16","1","ip_ua_time");
INSERT INTO user_collision VALUES("7","16","ip_ua_time");
INSERT INTO user_collision VALUES("18","1","ip_ua_time");
INSERT INTO user_collision VALUES("18","7","ip_ua_time");
INSERT INTO user_collision VALUES("18","16","ip_ua_time");



DROP TABLE IF EXISTS `user_files`;

CREATE TABLE `user_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `name` varchar(32) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(256) NOT NULL,
  `id_dir` int(11) DEFAULT NULL,
  `osn` int(1) DEFAULT '0',
  `type` varchar(20) DEFAULT NULL,
  `id_dires` varchar(215) DEFAULT '/',
  `pass` varchar(12) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;

INSERT INTO user_files VALUES("1","1","Файлы","0","","","1","","/","");
INSERT INTO user_files VALUES("2","2","Файлы","0","","","1","","/","");
INSERT INTO user_files VALUES("3","3","Файлы","0","","","1","","/","");
INSERT INTO user_files VALUES("4","4","Файлы","0","","","1","","/","");
INSERT INTO user_files VALUES("5","5","Файлы","0","","","1","","/","");
INSERT INTO user_files VALUES("6","6","Файлы","0","","","1","","/","");
INSERT INTO user_files VALUES("7","7","Файлы","0","","","1","","/","");
INSERT INTO user_files VALUES("8","8","Файлы","0","","","1","","/","");
INSERT INTO user_files VALUES("9","9","Файлы","0","","","1","","/","");
INSERT INTO user_files VALUES("10","10","Файлы","0","","","1","","/","");
INSERT INTO user_files VALUES("11","11","Файлы","0","","","1","","/","");
INSERT INTO user_files VALUES("12","12","Файлы","0","","","1","","/","");
INSERT INTO user_files VALUES("13","13","Файлы","0","","","1","","/","");
INSERT INTO user_files VALUES("14","14","Файлы","0","","","1","","/","");
INSERT INTO user_files VALUES("15","15","Файлы","0","","","1","","/","");
INSERT INTO user_files VALUES("16","16","Файлы","0","","","1","","/","");
INSERT INTO user_files VALUES("17","17","Файлы","0","","","1","","/","");
INSERT INTO user_files VALUES("18","18","Файлы","0","","","1","","/","");
INSERT INTO user_files VALUES("19","20","Файлы","0","","","1","","/","");



DROP TABLE IF EXISTS `user_group`;

CREATE TABLE `user_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

INSERT INTO user_group VALUES("1","Пользователь","0");
INSERT INTO user_group VALUES("2","Модератор чата","1");
INSERT INTO user_group VALUES("3","Модератор форума","1");
INSERT INTO user_group VALUES("4","Модератор Зоны обмена","1");
INSERT INTO user_group VALUES("5","Модератор библиотеки","1");
INSERT INTO user_group VALUES("6","Модератор фотогалереи","1");
INSERT INTO user_group VALUES("7","Модератор","2");
INSERT INTO user_group VALUES("8","Администратор","3");
INSERT INTO user_group VALUES("9","Главный администратор","9");
INSERT INTO user_group VALUES("15","Создатель","10");
INSERT INTO user_group VALUES("11","Модератор дневников","1");
INSERT INTO user_group VALUES("12","Модератор гостевой","1");



DROP TABLE IF EXISTS `user_group_access`;

CREATE TABLE `user_group_access` (
  `id_group` int(10) unsigned NOT NULL,
  `id_access` varchar(32) NOT NULL,
  KEY `id_group` (`id_group`,`id_access`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO user_group_access VALUES("2","adm_info");
INSERT INTO user_group_access VALUES("2","adm_panel_show");
INSERT INTO user_group_access VALUES("2","adm_ref");
INSERT INTO user_group_access VALUES("2","adm_set_chat");
INSERT INTO user_group_access VALUES("2","adm_show_adm");
INSERT INTO user_group_access VALUES("2","adm_statistic");
INSERT INTO user_group_access VALUES("2","chat_clear");
INSERT INTO user_group_access VALUES("2","chat_room");
INSERT INTO user_group_access VALUES("2","user_ban_set");
INSERT INTO user_group_access VALUES("2","user_ban_set_h");
INSERT INTO user_group_access VALUES("2","user_ban_unset");
INSERT INTO user_group_access VALUES("2","user_prof_edit");
INSERT INTO user_group_access VALUES("2","user_show_add_info");
INSERT INTO user_group_access VALUES("2","user_show_ua");
INSERT INTO user_group_access VALUES("3","adm_banlist");
INSERT INTO user_group_access VALUES("3","adm_panel_show");
INSERT INTO user_group_access VALUES("3","adm_set_forum");
INSERT INTO user_group_access VALUES("3","adm_show_adm");
INSERT INTO user_group_access VALUES("3","adm_statistic");
INSERT INTO user_group_access VALUES("3","forum_for_edit");
INSERT INTO user_group_access VALUES("3","forum_post_ed");
INSERT INTO user_group_access VALUES("3","forum_razd_create");
INSERT INTO user_group_access VALUES("3","forum_razd_edit");
INSERT INTO user_group_access VALUES("3","forum_them_del");
INSERT INTO user_group_access VALUES("3","forum_them_edit");
INSERT INTO user_group_access VALUES("3","user_ban_set_h");
INSERT INTO user_group_access VALUES("3","user_prof_edit");
INSERT INTO user_group_access VALUES("3","user_show_add_info");
INSERT INTO user_group_access VALUES("3","user_show_ip");
INSERT INTO user_group_access VALUES("3","user_show_ua");
INSERT INTO user_group_access VALUES("4","adm_info");
INSERT INTO user_group_access VALUES("4","adm_panel_show");
INSERT INTO user_group_access VALUES("4","adm_set_loads");
INSERT INTO user_group_access VALUES("4","adm_show_adm");
INSERT INTO user_group_access VALUES("4","adm_statistic");
INSERT INTO user_group_access VALUES("4","loads_dir_create");
INSERT INTO user_group_access VALUES("4","loads_dir_delete");
INSERT INTO user_group_access VALUES("4","loads_dir_mesto");
INSERT INTO user_group_access VALUES("4","loads_dir_rename");
INSERT INTO user_group_access VALUES("4","loads_file_delete");
INSERT INTO user_group_access VALUES("4","loads_file_edit");
INSERT INTO user_group_access VALUES("4","loads_file_upload");
INSERT INTO user_group_access VALUES("4","loads_unzip");
INSERT INTO user_group_access VALUES("5","adm_info");
INSERT INTO user_group_access VALUES("5","adm_lib_repair");
INSERT INTO user_group_access VALUES("5","adm_panel_show");
INSERT INTO user_group_access VALUES("5","adm_ref");
INSERT INTO user_group_access VALUES("5","adm_set_foto");
INSERT INTO user_group_access VALUES("5","adm_statistic");
INSERT INTO user_group_access VALUES("5","lib_dir_create");
INSERT INTO user_group_access VALUES("5","lib_dir_delete");
INSERT INTO user_group_access VALUES("5","lib_dir_edit");
INSERT INTO user_group_access VALUES("5","lib_dir_mesto");
INSERT INTO user_group_access VALUES("5","lib_stat_create");
INSERT INTO user_group_access VALUES("5","lib_stat_delete");
INSERT INTO user_group_access VALUES("5","lib_stat_txt");
INSERT INTO user_group_access VALUES("5","lib_stat_zip");
INSERT INTO user_group_access VALUES("5","user_ban_set_h");
INSERT INTO user_group_access VALUES("5","user_prof_edit");
INSERT INTO user_group_access VALUES("6","adm_banlist");
INSERT INTO user_group_access VALUES("6","adm_info");
INSERT INTO user_group_access VALUES("6","adm_panel_show");
INSERT INTO user_group_access VALUES("6","adm_set_foto");
INSERT INTO user_group_access VALUES("6","adm_show_adm");
INSERT INTO user_group_access VALUES("6","adm_statistic");
INSERT INTO user_group_access VALUES("6","foto_alb_del");
INSERT INTO user_group_access VALUES("6","foto_foto_edit");
INSERT INTO user_group_access VALUES("6","foto_komm_del");
INSERT INTO user_group_access VALUES("6","user_ban_set_h");
INSERT INTO user_group_access VALUES("6","user_show_ua");
INSERT INTO user_group_access VALUES("7","adm_banlist");
INSERT INTO user_group_access VALUES("7","adm_lib_repair");
INSERT INTO user_group_access VALUES("7","adm_panel_show");
INSERT INTO user_group_access VALUES("7","adm_set_chat");
INSERT INTO user_group_access VALUES("7","adm_set_forum");
INSERT INTO user_group_access VALUES("7","adm_set_foto");
INSERT INTO user_group_access VALUES("7","adm_statistic");
INSERT INTO user_group_access VALUES("7","chat_clear");
INSERT INTO user_group_access VALUES("7","chat_room");
INSERT INTO user_group_access VALUES("7","forum_post_close");
INSERT INTO user_group_access VALUES("7","forum_post_ed");
INSERT INTO user_group_access VALUES("7","forum_razd_create");
INSERT INTO user_group_access VALUES("7","forum_razd_edit");
INSERT INTO user_group_access VALUES("7","forum_them_del");
INSERT INTO user_group_access VALUES("7","forum_them_edit");
INSERT INTO user_group_access VALUES("7","foto_foto_edit");
INSERT INTO user_group_access VALUES("7","foto_komm_del");
INSERT INTO user_group_access VALUES("7","guest_clear");
INSERT INTO user_group_access VALUES("7","guest_delete");
INSERT INTO user_group_access VALUES("7","guest_show_ip");
INSERT INTO user_group_access VALUES("7","lib_stat_create");
INSERT INTO user_group_access VALUES("7","lib_stat_txt");
INSERT INTO user_group_access VALUES("7","loads_file_delete");
INSERT INTO user_group_access VALUES("7","loads_file_edit");
INSERT INTO user_group_access VALUES("7","loads_file_upload");
INSERT INTO user_group_access VALUES("7","notes_delete");
INSERT INTO user_group_access VALUES("7","notes_edit");
INSERT INTO user_group_access VALUES("7","obmen_dir_create");
INSERT INTO user_group_access VALUES("7","obmen_dir_delete");
INSERT INTO user_group_access VALUES("7","obmen_dir_edit");
INSERT INTO user_group_access VALUES("7","obmen_file_delete");
INSERT INTO user_group_access VALUES("7","obmen_file_edit");
INSERT INTO user_group_access VALUES("7","obmen_komm_del");
INSERT INTO user_group_access VALUES("7","user_ban_set");
INSERT INTO user_group_access VALUES("7","user_ban_set_h");
INSERT INTO user_group_access VALUES("7","user_ban_unset");
INSERT INTO user_group_access VALUES("7","user_collisions");
INSERT INTO user_group_access VALUES("7","user_prof_edit");
INSERT INTO user_group_access VALUES("7","user_show_add_info");
INSERT INTO user_group_access VALUES("7","user_show_ua");
INSERT INTO user_group_access VALUES("8","adm_banlist");
INSERT INTO user_group_access VALUES("8","adm_ban_ip");
INSERT INTO user_group_access VALUES("8","adm_forum_sinc");
INSERT INTO user_group_access VALUES("8","adm_info");
INSERT INTO user_group_access VALUES("8","adm_lib_repair");
INSERT INTO user_group_access VALUES("8","adm_news");
INSERT INTO user_group_access VALUES("8","adm_panel_show");
INSERT INTO user_group_access VALUES("8","adm_ref");
INSERT INTO user_group_access VALUES("8","adm_set_chat");
INSERT INTO user_group_access VALUES("8","adm_set_forum");
INSERT INTO user_group_access VALUES("8","adm_set_foto");
INSERT INTO user_group_access VALUES("8","adm_set_loads");
INSERT INTO user_group_access VALUES("8","adm_show_adm");
INSERT INTO user_group_access VALUES("8","adm_statistic");
INSERT INTO user_group_access VALUES("8","chat_clear");
INSERT INTO user_group_access VALUES("8","chat_room");
INSERT INTO user_group_access VALUES("8","forum_for_create");
INSERT INTO user_group_access VALUES("8","forum_for_delete");
INSERT INTO user_group_access VALUES("8","forum_for_edit");
INSERT INTO user_group_access VALUES("8","forum_post_ed");
INSERT INTO user_group_access VALUES("8","forum_razd_create");
INSERT INTO user_group_access VALUES("8","forum_razd_edit");
INSERT INTO user_group_access VALUES("8","forum_them_del");
INSERT INTO user_group_access VALUES("8","forum_them_edit");
INSERT INTO user_group_access VALUES("8","foto_alb_del");
INSERT INTO user_group_access VALUES("8","foto_foto_edit");
INSERT INTO user_group_access VALUES("8","foto_komm_del");
INSERT INTO user_group_access VALUES("8","guest_clear");
INSERT INTO user_group_access VALUES("8","guest_delete");
INSERT INTO user_group_access VALUES("8","guest_show_ip");
INSERT INTO user_group_access VALUES("8","lib_dir_create");
INSERT INTO user_group_access VALUES("8","lib_dir_delete");
INSERT INTO user_group_access VALUES("8","lib_dir_edit");
INSERT INTO user_group_access VALUES("8","lib_dir_mesto");
INSERT INTO user_group_access VALUES("8","lib_stat_create");
INSERT INTO user_group_access VALUES("8","lib_stat_delete");
INSERT INTO user_group_access VALUES("8","lib_stat_txt");
INSERT INTO user_group_access VALUES("8","lib_stat_zip");
INSERT INTO user_group_access VALUES("8","loads_dir_create");
INSERT INTO user_group_access VALUES("8","loads_dir_delete");
INSERT INTO user_group_access VALUES("8","loads_dir_mesto");
INSERT INTO user_group_access VALUES("8","loads_dir_rename");
INSERT INTO user_group_access VALUES("8","loads_file_delete");
INSERT INTO user_group_access VALUES("8","loads_file_edit");
INSERT INTO user_group_access VALUES("8","loads_file_upload");
INSERT INTO user_group_access VALUES("8","loads_unzip");
INSERT INTO user_group_access VALUES("8","notes_delete");
INSERT INTO user_group_access VALUES("8","notes_edit");
INSERT INTO user_group_access VALUES("8","obmen_dir_create");
INSERT INTO user_group_access VALUES("8","obmen_dir_delete");
INSERT INTO user_group_access VALUES("8","obmen_dir_edit");
INSERT INTO user_group_access VALUES("8","obmen_file_delete");
INSERT INTO user_group_access VALUES("8","obmen_file_edit");
INSERT INTO user_group_access VALUES("8","obmen_komm_del");
INSERT INTO user_group_access VALUES("8","user_ban_set");
INSERT INTO user_group_access VALUES("8","user_ban_set_h");
INSERT INTO user_group_access VALUES("8","user_ban_unset");
INSERT INTO user_group_access VALUES("8","user_change_group");
INSERT INTO user_group_access VALUES("8","user_change_nick");
INSERT INTO user_group_access VALUES("8","user_collisions");
INSERT INTO user_group_access VALUES("8","user_delete");
INSERT INTO user_group_access VALUES("8","user_prof_edit");
INSERT INTO user_group_access VALUES("8","user_show_add_info");
INSERT INTO user_group_access VALUES("8","user_show_ip");
INSERT INTO user_group_access VALUES("8","user_show_ua");
INSERT INTO user_group_access VALUES("8","votes_create");
INSERT INTO user_group_access VALUES("8","votes_settings");
INSERT INTO user_group_access VALUES("9","adm_banlist");
INSERT INTO user_group_access VALUES("9","adm_ban_ip");
INSERT INTO user_group_access VALUES("9","adm_forum_sinc");
INSERT INTO user_group_access VALUES("9","adm_info");
INSERT INTO user_group_access VALUES("9","adm_ip_edit");
INSERT INTO user_group_access VALUES("9","adm_lib_repair");
INSERT INTO user_group_access VALUES("9","adm_log_read");
INSERT INTO user_group_access VALUES("9","adm_menu");
INSERT INTO user_group_access VALUES("9","adm_news");
INSERT INTO user_group_access VALUES("9","adm_panel_show");
INSERT INTO user_group_access VALUES("9","adm_ref");
INSERT INTO user_group_access VALUES("9","adm_rekl");
INSERT INTO user_group_access VALUES("9","adm_set_chat");
INSERT INTO user_group_access VALUES("9","adm_set_forum");
INSERT INTO user_group_access VALUES("9","adm_set_foto");
INSERT INTO user_group_access VALUES("9","adm_set_loads");
INSERT INTO user_group_access VALUES("9","adm_set_sys");
INSERT INTO user_group_access VALUES("9","adm_set_user");
INSERT INTO user_group_access VALUES("9","adm_show_adm");
INSERT INTO user_group_access VALUES("9","adm_statistic");
INSERT INTO user_group_access VALUES("9","adm_themes");
INSERT INTO user_group_access VALUES("9","chat_clear");
INSERT INTO user_group_access VALUES("9","chat_room");
INSERT INTO user_group_access VALUES("9","forum_for_create");
INSERT INTO user_group_access VALUES("9","forum_for_delete");
INSERT INTO user_group_access VALUES("9","forum_for_edit");
INSERT INTO user_group_access VALUES("9","forum_post_close");
INSERT INTO user_group_access VALUES("9","forum_post_ed");
INSERT INTO user_group_access VALUES("9","forum_razd_create");
INSERT INTO user_group_access VALUES("9","forum_razd_edit");
INSERT INTO user_group_access VALUES("9","forum_them_del");
INSERT INTO user_group_access VALUES("9","forum_them_edit");
INSERT INTO user_group_access VALUES("9","foto_alb_del");
INSERT INTO user_group_access VALUES("9","foto_foto_edit");
INSERT INTO user_group_access VALUES("9","foto_komm_del");
INSERT INTO user_group_access VALUES("9","guest_clear");
INSERT INTO user_group_access VALUES("9","guest_delete");
INSERT INTO user_group_access VALUES("9","guest_show_ip");
INSERT INTO user_group_access VALUES("9","lib_dir_create");
INSERT INTO user_group_access VALUES("9","lib_dir_delete");
INSERT INTO user_group_access VALUES("9","lib_dir_edit");
INSERT INTO user_group_access VALUES("9","lib_dir_mesto");
INSERT INTO user_group_access VALUES("9","lib_stat_create");
INSERT INTO user_group_access VALUES("9","lib_stat_delete");
INSERT INTO user_group_access VALUES("9","lib_stat_txt");
INSERT INTO user_group_access VALUES("9","lib_stat_zip");
INSERT INTO user_group_access VALUES("9","loads_dir_create");
INSERT INTO user_group_access VALUES("9","loads_dir_delete");
INSERT INTO user_group_access VALUES("9","loads_dir_mesto");
INSERT INTO user_group_access VALUES("9","loads_dir_rename");
INSERT INTO user_group_access VALUES("9","loads_file_delete");
INSERT INTO user_group_access VALUES("9","loads_file_edit");
INSERT INTO user_group_access VALUES("9","loads_file_import");
INSERT INTO user_group_access VALUES("9","loads_file_upload");
INSERT INTO user_group_access VALUES("9","loads_unzip");
INSERT INTO user_group_access VALUES("9","notes_delete");
INSERT INTO user_group_access VALUES("9","notes_edit");
INSERT INTO user_group_access VALUES("9","obmen_dir_create");
INSERT INTO user_group_access VALUES("9","obmen_dir_delete");
INSERT INTO user_group_access VALUES("9","obmen_dir_edit");
INSERT INTO user_group_access VALUES("9","obmen_file_delete");
INSERT INTO user_group_access VALUES("9","obmen_file_edit");
INSERT INTO user_group_access VALUES("9","obmen_komm_del");
INSERT INTO user_group_access VALUES("9","user_ban_set");
INSERT INTO user_group_access VALUES("9","user_ban_set_h");
INSERT INTO user_group_access VALUES("9","user_ban_unset");
INSERT INTO user_group_access VALUES("9","user_change_group");
INSERT INTO user_group_access VALUES("9","user_change_nick");
INSERT INTO user_group_access VALUES("9","user_collisions");
INSERT INTO user_group_access VALUES("9","user_delete");
INSERT INTO user_group_access VALUES("9","user_mass_delete");
INSERT INTO user_group_access VALUES("9","user_prof_edit");
INSERT INTO user_group_access VALUES("9","user_show_add_info");
INSERT INTO user_group_access VALUES("9","user_show_ip");
INSERT INTO user_group_access VALUES("9","user_show_ua");
INSERT INTO user_group_access VALUES("9","votes_create");
INSERT INTO user_group_access VALUES("9","votes_settings");
INSERT INTO user_group_access VALUES("11","adm_banlist");
INSERT INTO user_group_access VALUES("11","adm_info");
INSERT INTO user_group_access VALUES("11","adm_panel_show");
INSERT INTO user_group_access VALUES("11","adm_show_adm");
INSERT INTO user_group_access VALUES("11","adm_statistic");
INSERT INTO user_group_access VALUES("11","forum_post_close");
INSERT INTO user_group_access VALUES("11","notes_delete");
INSERT INTO user_group_access VALUES("11","notes_edit");
INSERT INTO user_group_access VALUES("11","user_ban_set");
INSERT INTO user_group_access VALUES("11","user_ban_set_h");
INSERT INTO user_group_access VALUES("12","adm_banlist");
INSERT INTO user_group_access VALUES("12","adm_info");
INSERT INTO user_group_access VALUES("12","adm_panel_show");
INSERT INTO user_group_access VALUES("12","adm_show_adm");
INSERT INTO user_group_access VALUES("12","adm_statistic");
INSERT INTO user_group_access VALUES("12","guest_clear");
INSERT INTO user_group_access VALUES("12","guest_delete");
INSERT INTO user_group_access VALUES("12","user_ban_set");
INSERT INTO user_group_access VALUES("12","user_ban_set_h");
INSERT INTO user_group_access VALUES("15","adm_accesses");
INSERT INTO user_group_access VALUES("15","adm_banlist");
INSERT INTO user_group_access VALUES("15","adm_ban_ip");
INSERT INTO user_group_access VALUES("15","adm_forum_sinc");
INSERT INTO user_group_access VALUES("15","adm_info");
INSERT INTO user_group_access VALUES("15","adm_ip_edit");
INSERT INTO user_group_access VALUES("15","adm_lib_repair");
INSERT INTO user_group_access VALUES("15","adm_log_delete");
INSERT INTO user_group_access VALUES("15","adm_log_read");
INSERT INTO user_group_access VALUES("15","adm_menu");
INSERT INTO user_group_access VALUES("15","adm_mysql");
INSERT INTO user_group_access VALUES("15","adm_news");
INSERT INTO user_group_access VALUES("15","adm_panel_show");
INSERT INTO user_group_access VALUES("15","adm_ref");
INSERT INTO user_group_access VALUES("15","adm_rekl");
INSERT INTO user_group_access VALUES("15","adm_set_chat");
INSERT INTO user_group_access VALUES("15","adm_set_forum");
INSERT INTO user_group_access VALUES("15","adm_set_foto");
INSERT INTO user_group_access VALUES("15","adm_set_loads");
INSERT INTO user_group_access VALUES("15","adm_set_sys");
INSERT INTO user_group_access VALUES("15","adm_set_user");
INSERT INTO user_group_access VALUES("15","adm_show_adm");
INSERT INTO user_group_access VALUES("15","adm_statistic");
INSERT INTO user_group_access VALUES("15","adm_themes");
INSERT INTO user_group_access VALUES("15","chat_clear");
INSERT INTO user_group_access VALUES("15","chat_room");
INSERT INTO user_group_access VALUES("15","forum_for_create");
INSERT INTO user_group_access VALUES("15","forum_for_delete");
INSERT INTO user_group_access VALUES("15","forum_for_edit");
INSERT INTO user_group_access VALUES("15","forum_post_close");
INSERT INTO user_group_access VALUES("15","forum_post_ed");
INSERT INTO user_group_access VALUES("15","forum_razd_create");
INSERT INTO user_group_access VALUES("15","forum_razd_edit");
INSERT INTO user_group_access VALUES("15","forum_them_del");
INSERT INTO user_group_access VALUES("15","forum_them_edit");
INSERT INTO user_group_access VALUES("15","foto_alb_del");
INSERT INTO user_group_access VALUES("15","foto_foto_edit");
INSERT INTO user_group_access VALUES("15","foto_komm_del");
INSERT INTO user_group_access VALUES("15","guest_clear");
INSERT INTO user_group_access VALUES("15","guest_delete");
INSERT INTO user_group_access VALUES("15","guest_show_ip");
INSERT INTO user_group_access VALUES("15","lib_dir_create");
INSERT INTO user_group_access VALUES("15","lib_dir_delete");
INSERT INTO user_group_access VALUES("15","lib_dir_edit");
INSERT INTO user_group_access VALUES("15","lib_dir_mesto");
INSERT INTO user_group_access VALUES("15","lib_stat_create");
INSERT INTO user_group_access VALUES("15","lib_stat_delete");
INSERT INTO user_group_access VALUES("15","lib_stat_txt");
INSERT INTO user_group_access VALUES("15","lib_stat_zip");
INSERT INTO user_group_access VALUES("15","loads_dir_create");
INSERT INTO user_group_access VALUES("15","loads_dir_delete");
INSERT INTO user_group_access VALUES("15","loads_dir_mesto");
INSERT INTO user_group_access VALUES("15","loads_dir_rename");
INSERT INTO user_group_access VALUES("15","loads_file_delete");
INSERT INTO user_group_access VALUES("15","loads_file_edit");
INSERT INTO user_group_access VALUES("15","loads_file_import");
INSERT INTO user_group_access VALUES("15","loads_file_upload");
INSERT INTO user_group_access VALUES("15","loads_unzip");
INSERT INTO user_group_access VALUES("15","notes_delete");
INSERT INTO user_group_access VALUES("15","notes_edit");
INSERT INTO user_group_access VALUES("15","obmen_dir_create");
INSERT INTO user_group_access VALUES("15","obmen_dir_delete");
INSERT INTO user_group_access VALUES("15","obmen_dir_edit");
INSERT INTO user_group_access VALUES("15","obmen_file_delete");
INSERT INTO user_group_access VALUES("15","obmen_file_edit");
INSERT INTO user_group_access VALUES("15","obmen_komm_del");
INSERT INTO user_group_access VALUES("15","user_ban_set");
INSERT INTO user_group_access VALUES("15","user_ban_set_h");
INSERT INTO user_group_access VALUES("15","user_ban_unset");
INSERT INTO user_group_access VALUES("15","user_change_group");
INSERT INTO user_group_access VALUES("15","user_change_nick");
INSERT INTO user_group_access VALUES("15","user_collisions");
INSERT INTO user_group_access VALUES("15","user_delete");
INSERT INTO user_group_access VALUES("15","user_mass_delete");
INSERT INTO user_group_access VALUES("15","user_prof_edit");
INSERT INTO user_group_access VALUES("15","user_show_add_info");
INSERT INTO user_group_access VALUES("15","user_show_ip");
INSERT INTO user_group_access VALUES("15","user_show_ua");
INSERT INTO user_group_access VALUES("15","votes_create");
INSERT INTO user_group_access VALUES("15","votes_settings");



DROP TABLE IF EXISTS `user_log`;

CREATE TABLE `user_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `method` set('1','0') NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `ip` bigint(20) NOT NULL DEFAULT '0',
  `ua` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=84 DEFAULT CHARSET=utf8;

INSERT INTO user_log VALUES("1","1","1","1487493023","1433663564","Mozilla");
INSERT INTO user_log VALUES("2","2","1","1487496146","1433663564","Mozilla");
INSERT INTO user_log VALUES("3","1","1","1487496244","1433663564","Mozilla");
INSERT INTO user_log VALUES("4","2","1","1487496342","1433663564","Mozilla");
INSERT INTO user_log VALUES("5","1","1","1487496856","1433663564","Mozilla");
INSERT INTO user_log VALUES("6","2","1","1487497460","1433663564","Mozilla");
INSERT INTO user_log VALUES("7","2","1","1487497517","1433663564","Mozilla");
INSERT INTO user_log VALUES("8","2","1","1487500757","1433663577","Mozilla");
INSERT INTO user_log VALUES("9","1","1","1487500788","1433663564","Mozilla");
INSERT INTO user_log VALUES("10","1","1","1487505689","1433663577","Mozilla");
INSERT INTO user_log VALUES("11","1","1","1487506318","1433663577","Mozilla");
INSERT INTO user_log VALUES("12","1","1","1487517755","1433663577","Mozilla");
INSERT INTO user_log VALUES("13","1","1","1487519092","1433663607","Mozilla");
INSERT INTO user_log VALUES("14","1","1","1487519451","1433663607","Mozilla");
INSERT INTO user_log VALUES("15","3","1","1487519499","1433663577","Mozilla");
INSERT INTO user_log VALUES("16","1","1","1487519613","1433663607","Mozilla");
INSERT INTO user_log VALUES("17","1","1","1487519895","1433663607","Mozilla");
INSERT INTO user_log VALUES("18","1","1","1487522135","1433663607","Mozilla");
INSERT INTO user_log VALUES("19","1","1","1487523819","1433663607","Mozilla");
INSERT INTO user_log VALUES("20","1","1","1487526107","1433663607","Mozilla");
INSERT INTO user_log VALUES("21","1","1","1487532203","3165308011","Mozilla");
INSERT INTO user_log VALUES("22","2","1","1487533182","1433663577","Mozilla");
INSERT INTO user_log VALUES("23","2","1","1487533590","1433663727","Mozilla");
INSERT INTO user_log VALUES("24","2","1","1487534184","1433663727","Mozilla");
INSERT INTO user_log VALUES("25","1","1","1487534265","1433663727","Mozilla");
INSERT INTO user_log VALUES("26","1","1","1487572533","1433663727","Mozilla");
INSERT INTO user_log VALUES("27","1","1","1487576417","1433663509","Mozilla");
INSERT INTO user_log VALUES("28","1","1","1487577298","1433663576","Mozilla");
INSERT INTO user_log VALUES("29","5","1","1487577478","1433663576","Mozilla");
INSERT INTO user_log VALUES("30","6","1","1487577612","1433663576","Mozilla");
INSERT INTO user_log VALUES("31","5","1","1487577756","1433663576","Mozilla");
INSERT INTO user_log VALUES("32","1","1","1487577784","1433663576","Mozilla");
INSERT INTO user_log VALUES("33","1","1","1487579737","1433663576","Mozilla");
INSERT INTO user_log VALUES("34","6","1","1487586793","1433663576","Mozilla");
INSERT INTO user_log VALUES("35","1","1","1487586879","1433663595","Mozilla");
INSERT INTO user_log VALUES("36","1","1","1487589653","1433663595","Mozilla");
INSERT INTO user_log VALUES("37","1","1","1487594137","1433663595","Mozilla");
INSERT INTO user_log VALUES("38","7","1","1487594216","1433663595","Mozilla");
INSERT INTO user_log VALUES("39","7","1","1487594614","1433663586","Mozilla");
INSERT INTO user_log VALUES("40","7","1","1487594974","1433663586","Mozilla");
INSERT INTO user_log VALUES("41","1","1","1487595113","1433663595","Mozilla");
INSERT INTO user_log VALUES("42","7","1","1487595486","1433663586","Mozilla");
INSERT INTO user_log VALUES("43","6","1","1487595501","1433663595","Mozilla");
INSERT INTO user_log VALUES("44","8","1","1487595592","1433663586","Mozilla");
INSERT INTO user_log VALUES("45","1","1","1487595897","1433663586","Mozilla");
INSERT INTO user_log VALUES("46","7","1","1487596039","1433663586","Mozilla");
INSERT INTO user_log VALUES("47","8","1","1487596076","1433663586","Mozilla");
INSERT INTO user_log VALUES("48","9","1","1487596098","1433663586","Mozilla");
INSERT INTO user_log VALUES("49","7","1","1487596136","1433663586","Mozilla");
INSERT INTO user_log VALUES("50","6","1","1487596157","1433663586","Mozilla");
INSERT INTO user_log VALUES("51","1","1","1487596178","1433663586","Mozilla");
INSERT INTO user_log VALUES("52","7","1","1487596257","1433663586","Mozilla");
INSERT INTO user_log VALUES("53","1","1","1487596310","1433663586","Mozilla");
INSERT INTO user_log VALUES("54","1","1","1487596922","1433663586","Mozilla");
INSERT INTO user_log VALUES("55","7","1","1487596968","1433663586","Mozilla");
INSERT INTO user_log VALUES("56","7","1","1487597005","1433663586","Mozilla");
INSERT INTO user_log VALUES("57","1","1","1487597204","1433663586","Mozilla");
INSERT INTO user_log VALUES("58","1","1","1487615189","1433663612","Mozilla");
INSERT INTO user_log VALUES("59","7","1","1487615257","1433663586","Mozilla");
INSERT INTO user_log VALUES("60","1","1","1487615347","1433663550","Mozilla");
INSERT INTO user_log VALUES("61","1","1","1487616676","1433663550","Mozilla");
INSERT INTO user_log VALUES("62","1","1","1487689674","629980617","Mozilla");
INSERT INTO user_log VALUES("63","2","1","1487692680","1433663727","Mozilla");
INSERT INTO user_log VALUES("64","6","1","1487693219","1433663586","Mozilla");
INSERT INTO user_log VALUES("65","1","1","1487693310","1600971207","Mozilla");
INSERT INTO user_log VALUES("66","6","1","1487696543","1600971207","Mozilla");
INSERT INTO user_log VALUES("67","1","1","1487696661","1600947686","Mozilla");
INSERT INTO user_log VALUES("68","2","1","1487697003","1600971207","Mozilla");
INSERT INTO user_log VALUES("69","1","1","1487697083","1600947686","Mozilla");
INSERT INTO user_log VALUES("70","7","1","1487698883","1433663550","Mozilla");
INSERT INTO user_log VALUES("71","1","1","1487699108","1600971207","Mozilla");
INSERT INTO user_log VALUES("72","1","1","1487704960","1433663510","Mozilla");
INSERT INTO user_log VALUES("73","1","1","1487706162","629980619","Mozilla");
INSERT INTO user_log VALUES("74","1","1","1487708535","1600947666","Mozilla");
INSERT INTO user_log VALUES("75","1","1","1487709303","1600947666","Mozilla");
INSERT INTO user_log VALUES("76","6","1","1487712328","1600947686","Mozilla");
INSERT INTO user_log VALUES("77","1","1","1487712626","1600947666","Mozilla");
INSERT INTO user_log VALUES("78","1","1","1487719161","86900595","Mozilla");
INSERT INTO user_log VALUES("79","1","1","1487720289","1600947674","Mozilla");
INSERT INTO user_log VALUES("80","1","1","1487736278","1600947674","Mozilla");
INSERT INTO user_log VALUES("81","7","1","1487736407","1600971207","Mozilla");
INSERT INTO user_log VALUES("82","1","1","1487744371","1600947652","Mozilla");
INSERT INTO user_log VALUES("83","7","1","1487744414","1600947652","Mozilla");



DROP TABLE IF EXISTS `user_music`;

CREATE TABLE `user_music` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `dir` varchar(64) NOT NULL,
  `id_file` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO user_music VALUES("1","1","obmen","2");



DROP TABLE IF EXISTS `user_ref`;

CREATE TABLE `user_ref` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `id_user` int(10) unsigned NOT NULL,
  `url` varchar(1024) DEFAULT NULL,
  `type_input` varchar(12) DEFAULT 'cookie',
  PRIMARY KEY (`id`),
  KEY `time` (`time`,`id_user`),
  KEY `type_input` (`type_input`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO user_ref VALUES("1","1487706259","1","h3.keo.su","session");
INSERT INTO user_ref VALUES("2","1487718419","1","bymas.ru","session");
INSERT INTO user_ref VALUES("3","1487719079","17","bymas.ru","reg");
INSERT INTO user_ref VALUES("4","1487720910","1","dragrace.keo.su","session");
INSERT INTO user_ref VALUES("5","1487736670","12","bymas.ru","session");
INSERT INTO user_ref VALUES("6","1487737730","19","bymas.ru","reg");
INSERT INTO user_ref VALUES("7","1487741191","20","bymas.ru","reg");



DROP TABLE IF EXISTS `user_set`;

CREATE TABLE `user_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `privat_str` int(11) DEFAULT '1',
  `privat_mail` int(11) DEFAULT '1',
  `ocenka` int(11) DEFAULT '0',
  `cost` int(11) NOT NULL,
  `garem_uk` int(11) NOT NULL DEFAULT '0',
  `sunduk_zarab` int(11) NOT NULL DEFAULT '0',
  `sunduk_otkrk` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

INSERT INTO user_set VALUES("1","1","1","1","1488098899","1","1","0","0");
INSERT INTO user_set VALUES("2","2","1","1","1488100983","2","0","0","0");
INSERT INTO user_set VALUES("3","3","1","1","0","0","0","0","0");
INSERT INTO user_set VALUES("4","4","1","1","0","0","0","0","0");
INSERT INTO user_set VALUES("5","5","1","1","1488182574","0","1","0","0");
INSERT INTO user_set VALUES("6","6","1","1","1488182481","0","0","0","0");
INSERT INTO user_set VALUES("7","7","1","1","1488199131","1","0","0","0");
INSERT INTO user_set VALUES("8","8","1","1","0","0","0","0","0");
INSERT INTO user_set VALUES("9","9","1","1","0","0","0","0","0");
INSERT INTO user_set VALUES("10","10","1","1","0","0","0","0","0");
INSERT INTO user_set VALUES("11","11","1","1","0","0","0","0","0");
INSERT INTO user_set VALUES("12","12","1","1","0","0","0","0","0");
INSERT INTO user_set VALUES("13","13","1","1","0","0","0","0","0");
INSERT INTO user_set VALUES("14","14","1","1","0","0","0","0","0");
INSERT INTO user_set VALUES("15","15","1","1","0","0","0","0","0");
INSERT INTO user_set VALUES("16","16","1","1","0","0","0","0","0");
INSERT INTO user_set VALUES("17","17","1","1","0","0","0","0","0");
INSERT INTO user_set VALUES("18","18","1","1","0","0","0","0","0");
INSERT INTO user_set VALUES("19","19","1","1","0","0","0","0","0");
INSERT INTO user_set VALUES("20","20","1","1","0","0","0","0","0");



DROP TABLE IF EXISTS `user_voice2`;

CREATE TABLE `user_voice2` (
  `id_user` int(11) NOT NULL,
  `id_kont` int(11) NOT NULL,
  `rating` int(11) NOT NULL DEFAULT '0',
  `msg` varchar(256) DEFAULT NULL,
  `time` int(11) NOT NULL,
  KEY `id_user` (`id_user`,`id_kont`),
  KEY `time` (`time`),
  KEY `rating` (`rating`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO user_voice2 VALUES("1","7","2","Хорошая девушка","1487596346");



DROP TABLE IF EXISTS `users_konts`;

CREATE TABLE `users_konts` (
  `id_user` int(11) NOT NULL,
  `id_kont` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `new_msg` int(11) NOT NULL DEFAULT '0',
  `type` enum('common','ignor','favorite','deleted') NOT NULL DEFAULT 'common',
  `name` varchar(64) DEFAULT NULL,
  UNIQUE KEY `id_user` (`id_user`,`id_kont`),
  KEY `type` (`type`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `video`;

CREATE TABLE `video` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `opis` varchar(1024) DEFAULT NULL,
  `url` varchar(11) DEFAULT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `count` int(11) NOT NULL,
  `id_category` int(11) NOT NULL,
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO video VALUES("1","ЛУЧШИЕ ПРИКОЛЫ 2017 ФЕВРАЛЬ | Лучшая Подборка Приколов #269","","cl0X-5d8upQ","7","1487597103","1","1");



DROP TABLE IF EXISTS `video_category`;

CREATE TABLE `video_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(315) DEFAULT NULL,
  `icon` varchar(64) NOT NULL,
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO video_category VALUES("1","Приколы и юмор","");
INSERT INTO video_category VALUES("2","Спорт","");
INSERT INTO video_category VALUES("3","Русские новости","");
INSERT INTO video_category VALUES("4","Турецкие сериалы","");
INSERT INTO video_category VALUES("5","Фильмы HD","");
INSERT INTO video_category VALUES("6","Триллеры из фильм","");



DROP TABLE IF EXISTS `video_komm`;

CREATE TABLE `video_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg` varchar(512) DEFAULT NULL,
  `id_user` int(11) NOT NULL,
  `id_video` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `video_like`;

CREATE TABLE `video_like` (
  `id_video` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `like` int(11) DEFAULT '0',
  KEY `id_video` (`id_video`,`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `vip_premimum`;

CREATE TABLE `vip_premimum` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `nomer` varchar(150) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO vip_premimum VALUES("1","1","4","1488098900");
INSERT INTO vip_premimum VALUES("2","2","1","1488100984");
INSERT INTO vip_premimum VALUES("3","6","2","1488182482");
INSERT INTO vip_premimum VALUES("4","5","5","1488182575");
INSERT INTO vip_premimum VALUES("5","7","1","1488199132");



DROP TABLE IF EXISTS `visit_everyday`;

CREATE TABLE `visit_everyday` (
  `time` int(11) NOT NULL,
  `host` int(11) NOT NULL,
  `hit` int(11) NOT NULL,
  `host_ip_ua` int(11) NOT NULL,
  KEY `time` (`time`),
  KEY `host` (`host`),
  KEY `hit` (`hit`),
  KEY `host_ip_ua` (`host_ip_ua`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO visit_everyday VALUES("1487365200","0","0","0");
INSERT INTO visit_everyday VALUES("1487451600","41","1178","44");
INSERT INTO visit_everyday VALUES("1487538000","52","2362","57");
INSERT INTO visit_everyday VALUES("1487624400","81","1432","85");



DROP TABLE IF EXISTS `visit_today`;

CREATE TABLE `visit_today` (
  `ip` bigint(11) NOT NULL,
  `ua` varchar(128) DEFAULT NULL,
  `time` int(11) NOT NULL,
  KEY `ip` (`ip`),
  KEY `ua` (`ua`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO visit_today VALUES("2366158605","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487744506");
INSERT INTO visit_today VALUES("2366148116","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487744482");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744495");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744478");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744474");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744470");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744466");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744464");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744463");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744461");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744461");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744455");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744453");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744452");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744448");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744445");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744428");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744416");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744415");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744414");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744397");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744394");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744393");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744376");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744375");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744372");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744371");
INSERT INTO visit_today VALUES("2193699605","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487744310");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744370");
INSERT INTO visit_today VALUES("1600971208","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744301");
INSERT INTO visit_today VALUES("1385291013","Opera/9.80 (J2ME/MIDP; Opera Mini/4.2.14912/57.119; U; ru) Presto/2.12.423 Version/12.16","1487744288");
INSERT INTO visit_today VALUES("1123631336","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487744064");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487744064");
INSERT INTO visit_today VALUES("1433663584","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487744011");
INSERT INTO visit_today VALUES("2366148116","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487743925");
INSERT INTO visit_today VALUES("2193699605","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487743929");
INSERT INTO visit_today VALUES("1570674764","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487743877");
INSERT INTO visit_today VALUES("2996485394","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487743800");
INSERT INTO visit_today VALUES("2366148194","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487743825");
INSERT INTO visit_today VALUES("2996485402","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487743795");
INSERT INTO visit_today VALUES("1570674719","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487743781");
INSERT INTO visit_today VALUES("2366148194","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487743721");
INSERT INTO visit_today VALUES("1433663584","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487743668");
INSERT INTO visit_today VALUES("1433663584","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 Safari/","1487743563");
INSERT INTO visit_today VALUES("2193699620","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487743373");
INSERT INTO visit_today VALUES("2366158865","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487743416");
INSERT INTO visit_today VALUES("3648413505","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487743310");
INSERT INTO visit_today VALUES("2366158865","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487743274");
INSERT INTO visit_today VALUES("2366148243","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487743101");
INSERT INTO visit_today VALUES("2366158613","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487743177");
INSERT INTO visit_today VALUES("1385290960","Opera/9.80 (MAUI Runtime; Opera Mini/4.4.39001/57.119; U; ru) Presto/2.12.423 Version/12.16","1487743089");
INSERT INTO visit_today VALUES("1427827066","Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487743073");
INSERT INTO visit_today VALUES("2366148243","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487743033");
INSERT INTO visit_today VALUES("1427827066","Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487743039");
INSERT INTO visit_today VALUES("2366145599","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742997");
INSERT INTO visit_today VALUES("2366158605","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742914");
INSERT INTO visit_today VALUES("2366145599","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742957");
INSERT INTO visit_today VALUES("2996485402","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742899");
INSERT INTO visit_today VALUES("2366148194","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742881");
INSERT INTO visit_today VALUES("1123631336","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487742827");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487742828");
INSERT INTO visit_today VALUES("2366158865","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742759");
INSERT INTO visit_today VALUES("1357916903","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.76 Safari/537.36 OPR/43.0.2442.806","1487742801");
INSERT INTO visit_today VALUES("1570674699","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742746");
INSERT INTO visit_today VALUES("2366158872","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742632");
INSERT INTO visit_today VALUES("1570674764","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742739");
INSERT INTO visit_today VALUES("1570674721","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742588");
INSERT INTO visit_today VALUES("2366145599","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742521");
INSERT INTO visit_today VALUES("2366145599","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742541");
INSERT INTO visit_today VALUES("2365590826","Opera/9.80 (Android; Opera Mini/19.0.2254/57.119; U; ru) Presto/2.12.423 Version/12.16","1487742507");
INSERT INTO visit_today VALUES("2365590826","Opera/9.80 (Android; Opera Mini/19.0.2254/57.119; U; ru) Presto/2.12.423 Version/12.16","1487742507");
INSERT INTO visit_today VALUES("2365590826","Opera/9.80 (Android; Opera Mini/19.0.2254/57.119; U; ru) Presto/2.12.423 Version/12.16","1487742500");
INSERT INTO visit_today VALUES("2365590826","Opera/9.80 (Android; Opera Mini/19.0.2254/57.119; U; ru) Presto/2.12.423 Version/12.16","1487742500");
INSERT INTO visit_today VALUES("2366158605","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742499");
INSERT INTO visit_today VALUES("2996485412","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742475");
INSERT INTO visit_today VALUES("2366148143","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742480");
INSERT INTO visit_today VALUES("2365590826","Opera/9.80 (Android; Opera Mini/19.0.2254/57.119; U; ru) Presto/2.12.423 Version/12.16","1487742460");
INSERT INTO visit_today VALUES("2365590826","Opera/9.80 (Android; Opera Mini/19.0.2254/57.119; U; ru) Presto/2.12.423 Version/12.16","1487742459");
INSERT INTO visit_today VALUES("2366145599","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742459");
INSERT INTO visit_today VALUES("2193699605","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742454");
INSERT INTO visit_today VALUES("3648410547","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487742445");
INSERT INTO visit_today VALUES("2996475150","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742442");
INSERT INTO visit_today VALUES("3648410547","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487742445");
INSERT INTO visit_today VALUES("2365590826","Opera/9.80 (Android; Opera Mini/19.0.2254/57.119; U; ru) Presto/2.12.423 Version/12.16","1487742435");
INSERT INTO visit_today VALUES("1570674762","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742400");
INSERT INTO visit_today VALUES("2193699330","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742397");
INSERT INTO visit_today VALUES("1570674719","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742389");
INSERT INTO visit_today VALUES("1051008676","Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487742397");
INSERT INTO visit_today VALUES("3648410547","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487742381");
INSERT INTO visit_today VALUES("2366158605","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742367");
INSERT INTO visit_today VALUES("2366148243","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742278");
INSERT INTO visit_today VALUES("2366148116","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742313");
INSERT INTO visit_today VALUES("623671286","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.82 Safari/537.36 OPR/35.0.2066.37","1487742266");
INSERT INTO visit_today VALUES("623671286","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.82 Safari/537.36 OPR/35.0.2066.37","1487742266");
INSERT INTO visit_today VALUES("1570674716","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742213");
INSERT INTO visit_today VALUES("2996485387","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742252");
INSERT INTO visit_today VALUES("623671286","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.82 Safari/537.36 OPR/35.0.2066.37","1487742154");
INSERT INTO visit_today VALUES("2366148269","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742150");
INSERT INTO visit_today VALUES("785609573","Mozilla/5.0 (Linux; Android 6.0.1; Redmi 3S Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safa","1487742119");
INSERT INTO visit_today VALUES("2996475150","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742048");
INSERT INTO visit_today VALUES("2996485412","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742086");
INSERT INTO visit_today VALUES("2366148269","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487742048");
INSERT INTO visit_today VALUES("2366158613","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487741963");
INSERT INTO visit_today VALUES("2366148243","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487741966");
INSERT INTO visit_today VALUES("2193699620","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487741932");
INSERT INTO visit_today VALUES("1570674762","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487741866");
INSERT INTO visit_today VALUES("100662605","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487741908");
INSERT INTO visit_today VALUES("2996485385","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487741819");
INSERT INTO visit_today VALUES("1123631336","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487741816");
INSERT INTO visit_today VALUES("2193699615","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487741815");
INSERT INTO visit_today VALUES("1123631336","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487741815");
INSERT INTO visit_today VALUES("1570674764","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487741811");
INSERT INTO visit_today VALUES("2193699656","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487741807");
INSERT INTO visit_today VALUES("2193699605","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487741811");
INSERT INTO visit_today VALUES("1385291169","Opera/9.80 (Android; Opera Mini/20.0.2254/57.119; U; ru) Presto/2.12.423 Version/12.16","1487741669");
INSERT INTO visit_today VALUES("1123631332","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487741485");
INSERT INTO visit_today VALUES("1123631336","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487741484");
INSERT INTO visit_today VALUES("1113983282","Mozilla/5.0 (Linux; Android 4.1.2; HUAWEI D2-0082 Build/HuaweiD2-0082) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.9","1487741435");
INSERT INTO visit_today VALUES("1433663557","Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630 Dual SIM)","1487741362");
INSERT INTO visit_today VALUES("1433663557","Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630 Dual SIM)","1487741362");
INSERT INTO visit_today VALUES("1433663557","Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630 Dual SIM)","1487741360");
INSERT INTO visit_today VALUES("1433663557","Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630 Dual SIM)","1487741360");
INSERT INTO visit_today VALUES("1433663557","Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630 Dual SIM)","1487741359");
INSERT INTO visit_today VALUES("1433663557","Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630 Dual SIM)","1487741358");
INSERT INTO visit_today VALUES("1433663557","Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630 Dual SIM)","1487741352");
INSERT INTO visit_today VALUES("1433663557","Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630 Dual SIM)","1487741352");
INSERT INTO visit_today VALUES("1433663557","Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630 Dual SIM)","1487741351");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487741293");
INSERT INTO visit_today VALUES("1123631332","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487741294");
INSERT INTO visit_today VALUES("1433663557","Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630 Dual SIM)","1487741238");
INSERT INTO visit_today VALUES("1433663557","Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630 Dual SIM)","1487741237");
INSERT INTO visit_today VALUES("1433663557","Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630 Dual SIM)","1487741201");
INSERT INTO visit_today VALUES("1433663557","Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630 Dual SIM)","1487741201");
INSERT INTO visit_today VALUES("1433663557","Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630 Dual SIM)","1487741198");
INSERT INTO visit_today VALUES("1433663557","Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630 Dual SIM)","1487741191");
INSERT INTO visit_today VALUES("1433663557","Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630 Dual SIM)","1487741191");
INSERT INTO visit_today VALUES("1433663557","Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630 Dual SIM)","1487741191");
INSERT INTO visit_today VALUES("1433663557","Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630 Dual SIM)","1487741185");
INSERT INTO visit_today VALUES("1433663557","Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630 Dual SIM)","1487741165");
INSERT INTO visit_today VALUES("1433663557","Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630 Dual SIM)","1487741143");
INSERT INTO visit_today VALUES("1433663557","Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630 Dual SIM)","1487741134");
INSERT INTO visit_today VALUES("2953414703","Mozilla/5.0 (X11; Linux x86_64; rv:18.0) Gecko/20100101 Firefox/18.0","1487741020");
INSERT INTO visit_today VALUES("1123631336","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487740985");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487740984");
INSERT INTO visit_today VALUES("785612500","Mozilla/5.0 (Linux; Android 5.1; PMT3137_3G Build/LMY47I) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.91 Safari/537.","1487740849");
INSERT INTO visit_today VALUES("1123631336","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487740715");
INSERT INTO visit_today VALUES("1123631336","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487740716");
INSERT INTO visit_today VALUES("3579286954","Mozilla/5.0 (Linux; Android 5.1; Ixion E250 Build/LMY47D) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safa","1487740714");
INSERT INTO visit_today VALUES("3579286954","Mozilla/5.0 (Linux; Android 5.1; Ixion E250 Build/LMY47D) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safa","1487740705");
INSERT INTO visit_today VALUES("3579286954","Mozilla/5.0 (Linux; Android 5.1; Ixion E250 Build/LMY47D) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safa","1487740705");
INSERT INTO visit_today VALUES("3579286954","Mozilla/5.0 (Linux; Android 5.1; Ixion E250 Build/LMY47D) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safa","1487740679");
INSERT INTO visit_today VALUES("1123631332","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487740433");
INSERT INTO visit_today VALUES("1123631336","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487740432");
INSERT INTO visit_today VALUES("1123631336","Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.96 Mobile Safa","1487740300");
INSERT INTO visit_today VALUES("1123631332","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487740125");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487739806");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487740124");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487739803");
INSERT INTO visit_today VALUES("1123631332","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487739495");
INSERT INTO visit_today VALUES("531462188","Mozilla/5.0 (Windows NT 6.1; WOW64; rv:49.0) Gecko/20100101 Firefox/49.0","1487739442");
INSERT INTO visit_today VALUES("1123631336","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487739493");
INSERT INTO visit_today VALUES("1123631332","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487739198");
INSERT INTO visit_today VALUES("1123631332","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487739197");
INSERT INTO visit_today VALUES("1385291067","Opera/9.80 (J2ME/MIDP; Opera Mini/8.0.35626/57.119; U; ru) Presto/2.12.423 Version/12.16","1487739055");
INSERT INTO visit_today VALUES("1315945186","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.76 Safari/537.36 OPR/43.0.2442","1487738997");
INSERT INTO visit_today VALUES("1123631332","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487738863");
INSERT INTO visit_today VALUES("1044457236","Mozilla/5.0 (compatible; U; DataMiner/3.14; +http://ramillion.com)","1487738846");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487738858");
INSERT INTO visit_today VALUES("1433663557","Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630 Dual SIM)","1487738767");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487738642");
INSERT INTO visit_today VALUES("1123631332","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487738642");
INSERT INTO visit_today VALUES("2995385761","Mozilla/5.0 (Linux; Android 5.1; X5 Build/LMY47I) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.41","1487738575");
INSERT INTO visit_today VALUES("1123631332","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487738346");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487738343");
INSERT INTO visit_today VALUES("136702077","Mozilla/5.0 (Linux; U; Android 6.0; en-US; UMI_London Build/MRA58K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser","1487738185");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487738001");
INSERT INTO visit_today VALUES("1123631336","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487738006");
INSERT INTO visit_today VALUES("2365590930","Opera/9.80 (Android; Opera Mini/18.0.2254/57.119; U; ru) Presto/2.12.423 Version/12.16","1487737928");
INSERT INTO visit_today VALUES("1588830783","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.76 Safari/537.36 OPR/43.0.2442.806","1487737745");
INSERT INTO visit_today VALUES("1385290938","Mozilla/5.0 (Linux; U; Android 4.1.2; ru-RU; GT-S7262 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 OPR/13.0.","1487737740");
INSERT INTO visit_today VALUES("1840796286","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36 OPR/43.0.2442.991","1487737734");
INSERT INTO visit_today VALUES("1840796286","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36 OPR/43.0.2442.991","1487737734");
INSERT INTO visit_today VALUES("1385290938","Mozilla/5.0 (Linux; U; Android 4.1.2; ru-RU; GT-S7262 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 OPR/13.0.","1487737731");
INSERT INTO visit_today VALUES("1385290938","Mozilla/5.0 (Linux; U; Android 4.1.2; ru-RU; GT-S7262 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 OPR/13.0.","1487737731");
INSERT INTO visit_today VALUES("1385290938","Mozilla/5.0 (Linux; U; Android 4.1.2; ru-RU; GT-S7262 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 OPR/13.0.","1487737730");
INSERT INTO visit_today VALUES("1385290938","Mozilla/5.0 (Linux; U; Android 4.1.2; ru-RU; GT-S7262 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 OPR/13.0.","1487737717");
INSERT INTO visit_today VALUES("1840796286","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36 OPR/43.0.2442.991","1487737704");
INSERT INTO visit_today VALUES("1840796286","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36 OPR/43.0.2442.991","1487737699");
INSERT INTO visit_today VALUES("1840796286","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36 OPR/43.0.2442.991","1487737698");
INSERT INTO visit_today VALUES("1123631332","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487737697");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487737698");
INSERT INTO visit_today VALUES("1385290938","Mozilla/5.0 (Linux; U; Android 4.1.2; ru-RU; GT-S7262 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 OPR/13.0.","1487737696");
INSERT INTO visit_today VALUES("1840796286","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36 OPR/43.0.2442.991","1487737672");
INSERT INTO visit_today VALUES("1385290938","Mozilla/5.0 (Linux; U; Android 4.1.2; ru-RU; GT-S7262 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 OPR/13.0.","1487737643");
INSERT INTO visit_today VALUES("1385290938","Mozilla/5.0 (Linux; U; Android 4.1.2; ru-RU; GT-S7262 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 OPR/13.0.","1487737637");
INSERT INTO visit_today VALUES("1385290938","Mozilla/5.0 (Linux; U; Android 4.1.2; ru-RU; GT-S7262 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 OPR/13.0.","1487737636");
INSERT INTO visit_today VALUES("1385290938","Mozilla/5.0 (Linux; U; Android 4.1.2; ru-RU; GT-S7262 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 OPR/13.0.","1487737621");
INSERT INTO visit_today VALUES("1385290938","Mozilla/5.0 (Linux; U; Android 4.1.2; ru-RU; GT-S7262 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 OPR/13.0.","1487737620");
INSERT INTO visit_today VALUES("1385290938","Mozilla/5.0 (Linux; U; Android 4.1.2; ru-RU; GT-S7262 Build/JZO54K) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 OPR/13.0.","1487737449");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487737382");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487737383");
INSERT INTO visit_today VALUES("1565800355","Mozilla/5.0 (Linux; Android 5.1; m3 note Build/LMY47I) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/","1487737367");
INSERT INTO visit_today VALUES("86884432","Mozilla/5.0 (Linux; Android 5.0; Beeline Pro 2 Build/LRX21M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowse","1487737350");
INSERT INTO visit_today VALUES("86884432","Mozilla/5.0 (Linux; Android 5.0; Beeline Pro 2 Build/LRX21M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowse","1487737338");
INSERT INTO visit_today VALUES("86884432","Mozilla/5.0 (Linux; Android 5.0; Beeline Pro 2 Build/LRX21M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowse","1487737337");
INSERT INTO visit_today VALUES("86884432","Mozilla/5.0 (Linux; Android 5.0; Beeline Pro 2 Build/LRX21M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowse","1487737333");
INSERT INTO visit_today VALUES("86884432","Mozilla/5.0 (Linux; Android 5.0; Beeline Pro 2 Build/LRX21M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowse","1487737327");
INSERT INTO visit_today VALUES("86884432","Mozilla/5.0 (Linux; Android 5.0; Beeline Pro 2 Build/LRX21M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowse","1487737320");
INSERT INTO visit_today VALUES("86884432","Mozilla/5.0 (Linux; Android 5.0; Beeline Pro 2 Build/LRX21M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowse","1487737315");
INSERT INTO visit_today VALUES("86884432","Mozilla/5.0 (Linux; Android 5.0; Beeline Pro 2 Build/LRX21M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowse","1487737315");
INSERT INTO visit_today VALUES("86884432","Mozilla/5.0 (Linux; Android 5.0; Beeline Pro 2 Build/LRX21M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowse","1487737312");
INSERT INTO visit_today VALUES("86884432","Mozilla/5.0 (Linux; Android 5.0; Beeline Pro 2 Build/LRX21M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowse","1487737301");
INSERT INTO visit_today VALUES("86884432","Mozilla/5.0 (Linux; Android 5.0; Beeline Pro 2 Build/LRX21M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowse","1487737300");
INSERT INTO visit_today VALUES("86884432","Mozilla/5.0 (Linux; Android 5.0; Beeline Pro 2 Build/LRX21M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowse","1487737284");
INSERT INTO visit_today VALUES("1048945323","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487737237");
INSERT INTO visit_today VALUES("1048945323","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487737237");
INSERT INTO visit_today VALUES("1048945323","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487737221");
INSERT INTO visit_today VALUES("1048945323","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487737218");
INSERT INTO visit_today VALUES("1048945323","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487737210");
INSERT INTO visit_today VALUES("1123631332","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487737145");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487737142");
INSERT INTO visit_today VALUES("86884432","Mozilla/5.0 (Linux; Android 5.0; Beeline Pro 2 Build/LRX21M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowse","1487736670");
INSERT INTO visit_today VALUES("86884432","Mozilla/5.0 (Linux; Android 5.0; Beeline Pro 2 Build/LRX21M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowse","1487736669");
INSERT INTO visit_today VALUES("86884432","Mozilla/5.0 (Linux; Android 5.0; Beeline Pro 2 Build/LRX21M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowse","1487736669");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736618");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736583");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736580");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736580");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736574");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736574");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736567");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736562");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736562");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736552");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736550");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736548");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487736546");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487736547");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736545");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736540");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736526");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736525");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736523");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736523");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736521");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736517");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736517");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736500");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736498");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736496");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736496");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736484");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736482");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736481");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736478");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736478");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736477");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736473");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736463");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736428");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736424");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736410");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736408");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736407");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736407");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736388");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736386");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736385");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736371");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736362");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736355");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736353");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736352");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736352");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736336");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736334");
INSERT INTO visit_today VALUES("1840796286","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36 OPR/43.0.2442.991","1487736332");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736331");
INSERT INTO visit_today VALUES("1840796286","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36 OPR/43.0.2442.991","1487736330");
INSERT INTO visit_today VALUES("1840796286","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36 OPR/43.0.2442.991","1487736330");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736317");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736317");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736308");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736308");
INSERT INTO visit_today VALUES("1840796286","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36 OPR/43.0.2442.991","1487736298");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736298");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736292");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736291");
INSERT INTO visit_today VALUES("1840796286","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36 OPR/43.0.2442.991","1487736290");
INSERT INTO visit_today VALUES("1840796286","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36 OPR/43.0.2442.991","1487736289");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736281");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736278");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736278");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736276");
INSERT INTO visit_today VALUES("1600947652","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487736264");
INSERT INTO visit_today VALUES("1840796286","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36 OPR/43.0.2442.991","1487736250");
INSERT INTO visit_today VALUES("1123631336","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487736237");
INSERT INTO visit_today VALUES("1123631336","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487736219");
INSERT INTO visit_today VALUES("1123638612","Mozilla/5.0 (Linux; Android 6.0.1; SM-G935F Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safa","1487736168");
INSERT INTO visit_today VALUES("1123631332","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487735724");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487735714");
INSERT INTO visit_today VALUES("1123631332","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487734562");
INSERT INTO visit_today VALUES("1123631332","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487734535");
INSERT INTO visit_today VALUES("1123631336","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487733687");
INSERT INTO visit_today VALUES("1123631332","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487733677");
INSERT INTO visit_today VALUES("2366158857","Mozilla/5.0 (iPhone; CPU iPhone OS 8_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12B411 Safari/6","1487731977");
INSERT INTO visit_today VALUES("2193699615","Mozilla/5.0 (iPhone; CPU iPhone OS 8_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12B411 Safari/6","1487731976");
INSERT INTO visit_today VALUES("1123631332","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487731628");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487731611");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487731154");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487731135");
INSERT INTO visit_today VALUES("3274840773","Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) CriOS/56.0.2924.79 Mobile/14D2","1487729641");
INSERT INTO visit_today VALUES("3274840773","Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) CriOS/56.0.2924.79 Mobile/14D2","1487729640");
INSERT INTO visit_today VALUES("3274840773","Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) CriOS/56.0.2924.79 Mobile/14D2","1487729626");
INSERT INTO visit_today VALUES("3274840773","Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) CriOS/56.0.2924.79 Mobile/14D2","1487729626");
INSERT INTO visit_today VALUES("3274840773","Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) CriOS/56.0.2924.79 Mobile/14D2","1487729607");
INSERT INTO visit_today VALUES("3274840773","Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) CriOS/56.0.2924.79 Mobile/14D2","1487729581");
INSERT INTO visit_today VALUES("1048945187","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487729375");
INSERT INTO visit_today VALUES("1048945187","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487729375");
INSERT INTO visit_today VALUES("1048945187","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487729374");
INSERT INTO visit_today VALUES("1048945187","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487729373");
INSERT INTO visit_today VALUES("1048945187","Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487729340");
INSERT INTO visit_today VALUES("780499871","Mozilla/5.0 (Linux; Android 4.4.2; SM-G313HU Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/36.0.1985.135 Mobile Sa","1487728514");
INSERT INTO visit_today VALUES("1113983282","Mozilla/5.0 (Linux; Android 4.4.2; LenovoA3300-HV Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.84 Safar","1487728478");
INSERT INTO visit_today VALUES("3569448437","Mozilla/5.0 (compatible; statdom.ru/Bot; +http://statdom.ru/bot.html)","1487728225");
INSERT INTO visit_today VALUES("3569448437","Mozilla/5.0 (compatible; statdom.ru/Bot; +http://statdom.ru/bot.html)","1487728218");
INSERT INTO visit_today VALUES("3569448437","Mozilla/5.0 (compatible; statdom.ru/Bot; +http://statdom.ru/bot.html)","1487728169");
INSERT INTO visit_today VALUES("3569448437","Mozilla/5.0 (compatible; statdom.ru/Bot; +http://statdom.ru/bot.html)","1487728123");
INSERT INTO visit_today VALUES("3569448437","Mozilla/5.0 (compatible; statdom.ru/Bot; +http://statdom.ru/bot.html)","1487728121");
INSERT INTO visit_today VALUES("3569448437","Mozilla/5.0 (compatible; statdom.ru/Bot; +http://statdom.ru/bot.html)","1487728114");
INSERT INTO visit_today VALUES("1385312747","Mozilla/5.0 (Windows NT 5.1; rv:16.0) Gecko/20100101 Firefox/16.0","1487728030");
INSERT INTO visit_today VALUES("1123631356","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487727668");
INSERT INTO visit_today VALUES("1123631297","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487727617");
INSERT INTO visit_today VALUES("1123631352","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487727533");
INSERT INTO visit_today VALUES("1123631356","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487727533");
INSERT INTO visit_today VALUES("1123631352","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487727410");
INSERT INTO visit_today VALUES("1123631356","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487727382");
INSERT INTO visit_today VALUES("100648535","Mozilla/5.0 (compatible; YandexMetrika/2.0; +http://yandex.com/bots)","1487724178");
INSERT INTO visit_today VALUES("1044457236","Mozilla/5.0 (compatible; U; DataMiner/3.14; +http://ramillion.com)","1487723983");
INSERT INTO visit_today VALUES("621378251","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487723341");
INSERT INTO visit_today VALUES("1570674889","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487723337");
INSERT INTO visit_today VALUES("1315944814","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487722971");
INSERT INTO visit_today VALUES("2834026185","Mozilla/5.0 (Linux; U; Android 4.0.4; en-US; ST21i2 Build/11.0.A.6.5) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrows","1487722546");
INSERT INTO visit_today VALUES("2834026185","Mozilla/5.0 (Linux; U; Android 4.0.4; en-US; ST21i2 Build/11.0.A.6.5) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrows","1487722546");
INSERT INTO visit_today VALUES("2834026185","Mozilla/5.0 (Linux; U; Android 4.0.4; en-US; ST21i2 Build/11.0.A.6.5) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrows","1487722495");
INSERT INTO visit_today VALUES("3648410105","Mozilla/5.0 (Windows Phone 10.0; Android 6.0.1; Microsoft; Lumia 535 Dual SIM) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.","1487722296");
INSERT INTO visit_today VALUES("3648410105","Mozilla/5.0 (Windows Phone 10.0; Android 6.0.1; Microsoft; Lumia 535 Dual SIM) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.","1487722296");
INSERT INTO visit_today VALUES("3648410105","Mozilla/5.0 (Windows Phone 10.0; Android 6.0.1; Microsoft; Lumia 535 Dual SIM) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.","1487722275");
INSERT INTO visit_today VALUES("3648410105","Mozilla/5.0 (Windows Phone 10.0; Android 6.0.1; Microsoft; Lumia 535 Dual SIM) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.","1487722269");
INSERT INTO visit_today VALUES("3648410105","Mozilla/5.0 (Windows Phone 10.0; Android 6.0.1; Microsoft; Lumia 535 Dual SIM) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.","1487722269");
INSERT INTO visit_today VALUES("3648410105","Mozilla/5.0 (Windows Phone 10.0; Android 6.0.1; Microsoft; Lumia 535 Dual SIM) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.","1487722227");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487722086");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487722082");
INSERT INTO visit_today VALUES("2996485394","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487721952");
INSERT INTO visit_today VALUES("86884444","Mozilla/5.0 (Linux; Android 5.1; Philips S337 Build/LMY47D) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 YaBrowse","1487721940");
INSERT INTO visit_today VALUES("3169399293","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 ","1487721628");
INSERT INTO visit_today VALUES("3169399293","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 ","1487721628");
INSERT INTO visit_today VALUES("3169399293","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 ","1487721622");
INSERT INTO visit_today VALUES("3169399293","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 ","1487721622");
INSERT INTO visit_today VALUES("3169399293","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 ","1487721421");
INSERT INTO visit_today VALUES("3169399293","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 ","1487721420");
INSERT INTO visit_today VALUES("3169399293","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.0.2034 Yowser/2.5 ","1487721403");
INSERT INTO visit_today VALUES("2366148194","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487721328");
INSERT INTO visit_today VALUES("2366148269","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487721310");
INSERT INTO visit_today VALUES("2366158605","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487721201");
INSERT INTO visit_today VALUES("2366145599","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487721191");
INSERT INTO visit_today VALUES("100662605","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487721180");
INSERT INTO visit_today VALUES("2193699330","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487721167");
INSERT INTO visit_today VALUES("2366148194","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487721156");
INSERT INTO visit_today VALUES("2996485394","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487721145");
INSERT INTO visit_today VALUES("2193699330","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487721133");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487721130");
INSERT INTO visit_today VALUES("1570674716","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487721117");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487721100");
INSERT INTO visit_today VALUES("2996475150","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487721071");
INSERT INTO visit_today VALUES("2193699620","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487721058");
INSERT INTO visit_today VALUES("2193699620","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487721043");
INSERT INTO visit_today VALUES("2193699605","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487721015");
INSERT INTO visit_today VALUES("1570674719","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487721003");
INSERT INTO visit_today VALUES("100662605","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487720992");
INSERT INTO visit_today VALUES("2996485385","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487720979");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720974");
INSERT INTO visit_today VALUES("2193699615","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487720962");
INSERT INTO visit_today VALUES("2366145599","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487720935");
INSERT INTO visit_today VALUES("2996475150","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487720924");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720910");
INSERT INTO visit_today VALUES("2193699362","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487720900");
INSERT INTO visit_today VALUES("1570674699","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487720888");
INSERT INTO visit_today VALUES("2366148143","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487720878");
INSERT INTO visit_today VALUES("2366148116","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487720867");
INSERT INTO visit_today VALUES("1570674699","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487720855");
INSERT INTO visit_today VALUES("2366145599","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487720844");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720831");
INSERT INTO visit_today VALUES("2193699615","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487720831");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720829");
INSERT INTO visit_today VALUES("2193699615","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487720817");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720789");
INSERT INTO visit_today VALUES("1596891646","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487720673");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720372");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720362");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720360");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720360");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720358");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720343");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720340");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720330");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720320");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720318");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720295");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720291");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720289");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720289");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720288");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720280");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720274");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720267");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720262");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720254");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720254");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720250");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720239");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720237");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720231");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720231");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720230");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720229");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720215");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720215");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720211");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720207");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720199");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720193");
INSERT INTO visit_today VALUES("1600947674","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487720178");
INSERT INTO visit_today VALUES("783284764","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487720121");
INSERT INTO visit_today VALUES("783284764","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487720121");
INSERT INTO visit_today VALUES("783284764","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487720092");
INSERT INTO visit_today VALUES("1052167312","Mozilla/5.0 (Linux; Android 4.4.2; FS451 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.85 Mobile Safari/","1487719925");
INSERT INTO visit_today VALUES("1052167312","Mozilla/5.0 (Linux; Android 4.4.2; FS451 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.85 Mobile Safari/","1487719894");
INSERT INTO visit_today VALUES("1052167312","Mozilla/5.0 (Linux; Android 4.4.2; FS451 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.85 Mobile Safari/","1487719894");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719870");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719855");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719854");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719853");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719853");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719852");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719844");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719842");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719836");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719836");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719836");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719831");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719831");
INSERT INTO visit_today VALUES("1052167312","Mozilla/5.0 (Linux; Android 4.4.2; FS451 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.85 Mobile Safari/","1487719830");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719827");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719826");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719822");
INSERT INTO visit_today VALUES("1427826982","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1004 Yowser/2.5","1487719819");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719819");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719813");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719798");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719796");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719796");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719772");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719771");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719756");
INSERT INTO visit_today VALUES("1113983286","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.75 Safari/537.36 Google Favicon","1487719745");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719745");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719742");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719730");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719729");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719695");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719689");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719686");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719682");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719680");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719654");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719653");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719635");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719616");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719590");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719590");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719567");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719567");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719487");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719487");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719460");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719460");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719426");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719425");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719390");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719389");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719362");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719322");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719322");
INSERT INTO visit_today VALUES("2192888938","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487719269");
INSERT INTO visit_today VALUES("2192888938","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487719256");
INSERT INTO visit_today VALUES("2192888938","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487719239");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719215");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719209");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719209");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719204");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719203");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719202");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719198");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719195");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719194");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719191");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719191");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719189");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719187");
INSERT INTO visit_today VALUES("2192888938","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487719183");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719173");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719163");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719161");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719161");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719154");
INSERT INTO visit_today VALUES("2192888938","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487719146");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487719145");
INSERT INTO visit_today VALUES("2192888938","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487719136");
INSERT INTO visit_today VALUES("2192888938","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487719119");
INSERT INTO visit_today VALUES("2192888938","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487719118");
INSERT INTO visit_today VALUES("2192888938","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487719111");
INSERT INTO visit_today VALUES("2192888938","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487719104");
INSERT INTO visit_today VALUES("2192888938","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487719093");
INSERT INTO visit_today VALUES("2192888938","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487719083");
INSERT INTO visit_today VALUES("2192888938","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487719081");
INSERT INTO visit_today VALUES("2192888938","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487719079");
INSERT INTO visit_today VALUES("2192888938","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487719066");
INSERT INTO visit_today VALUES("2192888938","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487719041");
INSERT INTO visit_today VALUES("2192888938","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487719039");
INSERT INTO visit_today VALUES("2192888938","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487719027");
INSERT INTO visit_today VALUES("2192888938","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487719026");
INSERT INTO visit_today VALUES("2192888938","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487719007");
INSERT INTO visit_today VALUES("2192888938","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487719005");
INSERT INTO visit_today VALUES("2192888938","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487718982");
INSERT INTO visit_today VALUES("2192887880","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487718917");
INSERT INTO visit_today VALUES("2834023390","Mozilla/5.0 (Linux; U; Android 5.1; en-US; C255i Build/LMY47D) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 UCBrowser/10.8","1487718717");
INSERT INTO visit_today VALUES("1385291334","Mozilla/5.0 (Linux; Android 5.0.2; LG-D335 Build/LRX22G) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.85 Mobile Safar","1487718705");
INSERT INTO visit_today VALUES("785620563","Mozilla/5.0 (compatible; MSIE 9.0; Windows Phone OS 7.5; Trident/5.0; IEMobile/9.0; NOKIA; Lumia 510)","1487718608");
INSERT INTO visit_today VALUES("785620563","Mozilla/5.0 (compatible; MSIE 9.0; Windows Phone OS 7.5; Trident/5.0; IEMobile/9.0; NOKIA; Lumia 510)","1487718603");
INSERT INTO visit_today VALUES("785620563","Mozilla/5.0 (compatible; MSIE 9.0; Windows Phone OS 7.5; Trident/5.0; IEMobile/9.0; NOKIA; Lumia 510)","1487718602");
INSERT INTO visit_today VALUES("785620563","Mozilla/5.0 (compatible; MSIE 9.0; Windows Phone OS 7.5; Trident/5.0; IEMobile/9.0; NOKIA; Lumia 510)","1487718569");
INSERT INTO visit_today VALUES("2990717712","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487718505");
INSERT INTO visit_today VALUES("2990717712","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487718503");
INSERT INTO visit_today VALUES("2990717712","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487718503");
INSERT INTO visit_today VALUES("2990717712","Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36","1487718491");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718419");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718365");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718228");
INSERT INTO visit_today VALUES("2366158865","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487718225");
INSERT INTO visit_today VALUES("2193699615","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487718225");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718220");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718217");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718217");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718215");
INSERT INTO visit_today VALUES("2193699362","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487718212");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718213");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718202");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718198");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718173");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718173");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718170");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718167");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718161");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718160");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718156");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718155");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718155");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718151");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718140");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718093");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718064");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718051");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718038");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718035");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718030");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718024");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718020");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718017");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487718011");
INSERT INTO visit_today VALUES("86900595","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487717896");
INSERT INTO visit_today VALUES("1123631356","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487716081");
INSERT INTO visit_today VALUES("2366158857","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487716382");
INSERT INTO visit_today VALUES("1123631356","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487716081");
INSERT INTO visit_today VALUES("1123631352","Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.96 Mobile Safa","1487715469");
INSERT INTO visit_today VALUES("1123631352","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487714974");
INSERT INTO visit_today VALUES("1533767081","Go-http-client/1.1","1487714958");
INSERT INTO visit_today VALUES("1123631297","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487714972");
INSERT INTO visit_today VALUES("2193699620","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487714536");
INSERT INTO visit_today VALUES("3569448419","Mozilla/5.0 (compatible; statdom.ru/Bot; +http://statdom.ru/bot.html)","1487714954");
INSERT INTO visit_today VALUES("2996485412","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487712716");
INSERT INTO visit_today VALUES("2996485406","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487712694");
INSERT INTO visit_today VALUES("2193699656","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487712694");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712637");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712632");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712631");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712628");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712626");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712626");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712605");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712603");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712603");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712589");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712587");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712580");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712579");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712579");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712571");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712568");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712547");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712546");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712545");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712528");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712524");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712515");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712514");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712498");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712466");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712446");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712422");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712394");
INSERT INTO visit_today VALUES("86884432","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712335");
INSERT INTO visit_today VALUES("86884432","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712332");
INSERT INTO visit_today VALUES("86884432","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712328");
INSERT INTO visit_today VALUES("86884432","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712328");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712282");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712280");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712279");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712266");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712265");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712262");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712262");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712260");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712254");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712233");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712207");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712147");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712121");
INSERT INTO visit_today VALUES("1123631332","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487711635");
INSERT INTO visit_today VALUES("1600947666","Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 YaBrowser/17.1.1.1003 Yowser/2.5 ","1487712115");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487711608");
INSERT INTO visit_today VALUES("1123631332","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487711251");
INSERT INTO visit_today VALUES("1123631336","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487711209");
INSERT INTO visit_today VALUES("1123631332","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487711250");
INSERT INTO visit_today VALUES("1123631332","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487711208");
INSERT INTO visit_today VALUES("1123631332","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487711035");
INSERT INTO visit_today VALUES("2366158613","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710905");
INSERT INTO visit_today VALUES("1123631340","Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)","1487711035");
INSERT INTO visit_today VALUES("2366158880","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710905");
INSERT INTO visit_today VALUES("2996475141","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710904");
INSERT INTO visit_today VALUES("2193699647","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710904");
INSERT INTO visit_today VALUES("1570674755","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710903");
INSERT INTO visit_today VALUES("1570674700","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710903");
INSERT INTO visit_today VALUES("1570674721","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710903");
INSERT INTO visit_today VALUES("2996485402","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710902");
INSERT INTO visit_today VALUES("2996485385","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710899");
INSERT INTO visit_today VALUES("1570674762","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710902");
INSERT INTO visit_today VALUES("2366158872","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710899");
INSERT INTO visit_today VALUES("2193699362","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710898");
INSERT INTO visit_today VALUES("2366158865","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710898");
INSERT INTO visit_today VALUES("1570674764","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710897");
INSERT INTO visit_today VALUES("1570674719","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710896");
INSERT INTO visit_today VALUES("2366145599","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710897");
INSERT INTO visit_today VALUES("2193699605","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710896");
INSERT INTO visit_today VALUES("2366148194","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710895");
INSERT INTO visit_today VALUES("2366158613","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710895");
INSERT INTO visit_today VALUES("2996485402","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710894");
INSERT INTO visit_today VALUES("2996485387","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710894");
INSERT INTO visit_today VALUES("1570674699","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710894");
INSERT INTO visit_today VALUES("2996485394","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710845");
INSERT INTO visit_today VALUES("2193699620","Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)","1487710893");



DROP TABLE IF EXISTS `znakomstva_chat`;

CREATE TABLE `znakomstva_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `msg` varchar(1024) DEFAULT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




