<?php
  
/*
--------------------------------------------
Класс для работы с пользовательскими данными
--------------------------------------------
*/
  
class user {
  
  /*
  -------------
  Вывод аватара
  -------------
  */
  
  public static function avatar($ID, $size = 80, $online = 0, $border = 0){
    
    //$ID - идентификатор пользователя
    //$size - размер аватара
    //$online - вывод значка онлайн

    $account = db::get_string("SELECT `DATE_VISIT`,`VERSION`,`LOGIN` FROM `USERS` WHERE `ID` = ? LIMIT 1", [$ID]);
    $account_set = db::get_string("SELECT `AVATAR`,`AVATAR_PHONE` FROM `USERS_SETTINGS` WHERE `USER_ID` = ? LIMIT 1", [$ID]); 
    $photo = db::get_string("SELECT `SHIF`,`ID_DIR` FROM `PHOTOS` WHERE `ID` = ? LIMIT 1", [$account_set['AVATAR']]);     
    
    if ($online == 1 && $account['DATE_VISIT'] > TM-config('ONLINE_TIME_USERS')){
      
      if ($account['VERSION'] == 'touch'){
        
        $on = "<span class='avatar-online-touch'><span><i class='fa fa-mobile'></i></span></span>";
      
      }else{
        
        $on = "<span class='avatar-online-web'><span><i class='fa fa-desktop'></i></span></span>";
      
      }
    
    }else{
      
      $on = null;
    
    }  
    
    $size_text = $size / 2 - 2;
    
    if ($border == 1){
      
      $border = 'border: 7px white solid;';
    
    }else{
      
      $border = null;
    
    }
    
    if (db::get_column("SELECT COUNT(*) FROM `BAN_USER` WHERE `USER_ID` = ? AND `BAN` = ? LIMIT 1", [$ID, 1]) > 0){
      
      return "<span style='position: relative;'><div class='avatar-o' style='".$border." background-color: ".$account_set['AVATAR_PHONE']."; font-size: ".$size_text."px; width: ".$size."px; height: ".$size."px;'><span><i class='fa fa-ban'></i></span></div>".$on."</span>";
    
    }else{
      
      if (is_file(ROOT.'/files/upload/photos/150x150/'.$photo['SHIF'].'.jpg')){
        
        return "<span style='position: relative;'><img class='avatar' style='".$border." font-size: ".$size_text."px; width: ".$size."px; height: ".$size."px;' src='/files/upload/photos/150x150/".$photo['SHIF'].".jpg'>".$on."</span>";
      
      }else{
        
        $login = mb_substr($account['LOGIN'], 0, 1, 'utf-8');
        
        return "<span style='position: relative;'><div class='avatar-o' style='".$border." background-color: ".$account_set['AVATAR_PHONE']."; font-size: ".$size_text."px; width: ".$size."px; height: ".$size."px'><span>".$login."</span></div>".$on."</span>";
      
      }
      
    }
  
  }
  
  /*
  -------------------
  Вывод иконки онлайн
  -------------------
  */
  
  public static function online($ID){
    
    if (db::get_column("SELECT COUNT(*) FROM `USERS` WHERE `ID` = ? AND `DATE_VISIT` > ? AND `VERSION` = 'touch' LIMIT 1", [$ID, (TM-config('ONLINE_TIME_USERS'))]) == 1){
      
      return "<i class='fa fa-mobile fa-fw' style='position: relative; top: 1px; color: green;'></i>";
    
    }elseif (db::get_column("SELECT COUNT(*) FROM `USERS` WHERE `ID` = ? AND `DATE_VISIT` > ? AND `VERSION` = 'web' LIMIT 1", [$ID, (TM-config('ONLINE_TIME_USERS'))]) == 1){
      
      return "<i class='fa fa-laptop fa-fw' style='position: relative; top: 1px; color: green;'></i>";
    
    }
  
  }
  
  /*
  -------------------------------
  Вывод логина со всем содержимым
  -------------------------------
  */
  
  public static function login($ID, $avatar = 0, $link = 0, $online = 0, $color = 'black'){
    
    $account_set = db::get_string("SELECT * FROM `USERS_SETTINGS` WHERE `USER_ID` = ? LIMIT 1", [$ID]); 
    $account = db::get_string("SELECT * FROM `USERS` WHERE `ID` = ? LIMIT 1", [$ID]);
    
    if ($color == 'white') {
      
      $cban = "<font color='#FFDEDB'>";
    
    }else{
      
      $cban = "<font color='#939699'>";
    
    }
    
    if (db::get_column("SELECT COUNT(*) FROM `BAN_USER` WHERE `USER_ID` = ? AND `BAN_TIME` > ? AND `BAN` = ? LIMIT 1", [$ID, TM, 0]) > 0){
      
      $login = $cban.tabs($account['LOGIN'])."</font> ".icons('ban', 15, 'fa-fw');
      
    }elseif (db::get_column("SELECT COUNT(*) FROM `BAN_USER` WHERE `USER_ID` = ? AND `BAN` = ? LIMIT 1", [$ID, 1]) > 0){
      
      $login = $cban."Blocked</font> ".icons('ban', 15, 'fa-fw');
    
    }else{
      
      $login = tabs($account['LOGIN']);
    
    }
    
    if ($link > 0){
      
      if (url_request_validate('/admin') == true) {
        
        $ajn = 'ajax="no"';
        
      }else{
        
        $ajn = null;
        
      }
      
      $link1 = "<a href='/id".$ID."' ".$ajn." style='color: ".$color."'>"; 
      $link2 = "</a>";
    
    }else{
      
      $link1 = null;
      $link2 = null;
      
    }
    
    if ($avatar > 0){
      
      $avatar = user::avatar($ID, 25)." ";   
    
    }else{
      
      $avatar = null;

    }
    
    if ($online > 0){
      
      $online = " ".user::online($ID)." ";   
    
    }else{
      
      $online = null; 

    }
    
    $upd1 = null; //вносимые изменения перед логином
    $upd2 = null; //вносимые изменения после логина
    
    $result = scandir(ROOT.'/system/PHP-classes/users_login/', SCANDIR_SORT_ASCENDING);
    
    for ($i = 0; $i < count($result); $i++){
      
      if (preg_match('#\.php$#i',$result[$i])){       
        
        require (ROOT.'/system/PHP-classes/users_login/'.$result[$i]);
      
      }
    
    }

    return $link1.$avatar.$upd1."<b>".$login."</b>".$upd2.$online.$link2;
  
  }
  
  /*
  -------------------------
  Вывод логина без настроек
  -------------------------
  */
  
  public static function login_mini($ID){

    $account = db::get_string("SELECT `LOGIN` FROM `USERS` WHERE `ID` = ? LIMIT 1", [$ID]);
    
    if (db::get_column("SELECT COUNT(*) FROM `BAN_USER` WHERE `USER_ID` = ? AND `BAN` = ? LIMIT 1", [$ID, 1]) > 0){
      
      $login = 'Blocked';
    
    }else{
      
      $login = tabs($account['LOGIN']);
    
    }

    return $login;
  
  }
  
}