<?php

/*
-----------------
Добавление города
-----------------
*/

$region = db::get_string("SELECT * FROM `REGION` WHERE `ID` = ? LIMIT 1", intval(get('id_region')));
if (get('get') == "add_city" && isset($region['ID'])){
  
  if (post('ok')){
    
    valid::create(array(
      
      'REGION_NAME' => ['name', 'text', [2, 200], 'Название', 0],
      'REGION_REGION' => ['region', 'number', [1, 999999999999], 'Регион']
    
    ));
    
    if (ERROR_LOG == 1){     
      
      redirect('/admin/site/modules/?mod=country&id_region='.$region['ID'].'&get=add_city');
    
    }
    
    db::get_add("INSERT INTO `CITY` (`NAME`, `ID_REGION`) VALUES (?, ?)", [REGION_NAME, REGION_REGION]); 
    
    success('Город успешно добавлен');
    redirect('/admin/site/modules/?mod=country&id_region='.REGION_REGION);
    
  }
  
  ?>
  <div class='list'>
  <form method='post' class='ajax-form' action='/admin/site/modules/?mod=country&id_region=<?=$region['ID']?>&get=add_city'>
  <?=html::input('name', null, 'Введите название города:', null, null, 'form-control-100', null, 'text', 'globe')?>
  <?
  $array = array();
  $data = db::get_string_all("SELECT `ID`,`NAME` FROM `REGION` WHERE `ID` = ? ORDER BY `ID` ASC", [$region['ID']]);  
  while ($list = $data->fetch()){
    
    $array[$list['ID']] = [$list['NAME'], ($region['ID'] == $list['ID'] ? "selected" : null)];
  
  }
  html::select('region', $array, 'Регион', 'form-control-100-modify-select', 'globe');
  ?>  
  <?=html::button('button ajax-button', 'ok', 'plus', 'Добавить')?>
  </form>
  </div>
  <?
  
  back('/admin/site/modules/?mod=country');
  acms_footer();
  
}

/*
------------------
Добавление региона
------------------
*/

$country = db::get_string("SELECT * FROM `COUNTRY` WHERE `ID` = ? LIMIT 1", intval(get('id_country')));
if (get('get') == "add_region" && isset($country['ID'])){
  
  if (post('ok')){
    
    valid::create(array(
      
      'COUNTRY_NAME' => ['name', 'text', [2, 200], 'Название', 0],
      'COUNTRY_COUNTRY' => ['country', 'number', [1, 999999999999], 'Страна']
    
    ));
    
    if (ERROR_LOG == 1){     
      
      redirect('/admin/site/modules/?mod=country&get=add_region');
    
    }
    
    db::get_add("INSERT INTO `REGION` (`NAME`, `ID_COUNTRY`) VALUES (?, ?)", [COUNTRY_NAME, COUNTRY_COUNTRY]); 
    
    success('Регион успешно добавлен');
    redirect('/admin/site/modules/?mod=country&id_country='.COUNTRY_COUNTRY);
    
  }
  
  ?>
  <div class='list'>
  <form method='post' class='ajax-form' action='/admin/site/modules/?mod=country&id_country=<?=$country['ID']?>&get=add_region'>
  <?=html::input('name', null, 'Введите название региона:', null, null, 'form-control-100', null, 'text', 'globe')?>
  <?
  $array = array();
  $data = db::get_string_all("SELECT `ID`,`NAME` FROM `COUNTRY` WHERE `ID` = ? ORDER BY `ID` ASC", [$country['ID']]);  
  while ($list = $data->fetch()){
    
    $array[$list['ID']] = [$list['NAME'], ($country['ID'] == $list['ID'] ? "selected" : null)];
  
  }
  html::select('country', $array, 'Страна', 'form-control-100-modify-select', 'globe');
  ?>  
  <?=html::button('button ajax-button', 'ok', 'plus', 'Добавить')?>
  </form>
  </div>
  <?
  
  back('/admin/site/modules/?mod=country');
  acms_footer();
  
}

/*
-----------------
Добавление страны
-----------------
*/

if (get('get') == "add_country"){
  
  if (post('ok')){
    
    valid::create(array(
      
      'COUNTRY_NAME' => ['name', 'text', [2, 200], 'Название', 0]
    
    ));
    
    if (ERROR_LOG == 1){     
      
      redirect('/admin/site/modules/?mod=country&get=add_country');
    
    }
    
    db::get_add("INSERT INTO `COUNTRY` (`NAME`) VALUES (?)", [COUNTRY_NAME]); 
    
    success('Страна успешно добавлена');
    redirect('/admin/site/modules/?mod=country');
    
  }
  
  ?>
  <div class='list'>
  <form method='post' class='ajax-form' action='/admin/site/modules/?mod=country&get=add_country'>
  <?=html::input('name', null, 'Введите название страны:', null, null, 'form-control-100', null, 'text', 'globe')?>  
  <?=html::button('button ajax-button', 'ok', 'plus', 'Добавить')?>
  </form>
  </div>
  <?
  
  back('/admin/site/modules/?mod=country');
  acms_footer();
  
}

/*
----------------------
Редактирование городов
----------------------
*/

$city = db::get_string("SELECT * FROM `CITY` WHERE `ID` = ? LIMIT 1", [intval(get('edit_city'))]);
if (get('edit_city') && isset($city['ID'])){
  
  $region = db::get_string("SELECT `ID_COUNTRY` FROM `REGION` WHERE `ID` = ? LIMIT 1", [$city['ID_REGION']]);
  $country = db::get_string("SELECT `ID` FROM `COUNTRY` WHERE `ID` = ? LIMIT 1", [$region['ID_COUNTRY']]);
  
  if (post('ok')){
    
    valid::create(array(
      
      'REGION_NAME' => ['name', 'text', [2, 200], 'Название', 0],
      'REGION_REGION' => ['region', 'number', [1, 999999999999], 'Регион']
    
    ));
    
    if (ERROR_LOG == 1){     
      
      redirect('/admin/site/modules/?mod=country&edit_city='.$city['ID']);
    
    }
    
    db::get_set("UPDATE `CITY` SET `NAME` = ?, `ID_REGION` = ? WHERE `ID` = ? LIMIT 1", [REGION_NAME, REGION_REGION, $city['ID']]);
    
    success('Изменения успешно приняты');
    redirect('/admin/site/modules/?mod=country&id_region='.REGION_REGION);
    
  }
  
  ?>
  <div class='list'>
  <form method='post' class='ajax-form' action='/admin/site/modules/?mod=country&edit_city=<?=$city['ID']?>'>
  <?=html::input('name', null, 'Введите название города:', null, tabs($city['NAME']), 'form-control-100', null, 'text', 'globe')?>
  <?
  $array = array();
  $data = db::get_string_all("SELECT `ID`,`NAME` FROM `REGION` WHERE `ID_COUNTRY` = ? ORDER BY `ID` ASC", [$country['ID']]);  
  while ($list = $data->fetch()){
    
    $array[$list['ID']] = [$list['NAME'], ($city['ID_REGION'] == $list['ID'] ? "selected" : null)];
  
  }
  html::select('region', $array, 'Регион', 'form-control-100-modify-select', 'globe');
  ?>  
  <?=html::button('button ajax-button', 'ok', 'save', 'Сохранить изменения')?>
  </form>
  </div>
  <?
    
  back('/admin/site/modules/?mod=country');
  acms_footer();
  
}

/*
-----------------------
Редактирование регионов
-----------------------
*/

$region = db::get_string("SELECT * FROM `REGION` WHERE `ID` = ? LIMIT 1", [intval(get('edit_region'))]);
if (get('edit_region') && isset($region['ID'])){
  
  if (POST('ok')){
    
    valid::create(array(
      
      'COUNTRY_NAME' => ['name', 'text', [2, 200], 'Название', 0],
      'COUNTRY_COUNTRY' => ['country', 'number', [1, 999999999999], 'Страна']
    
    ));
    
    if (ERROR_LOG == 1){     
      
      redirect('/admin/site/modules/?mod=country&edit_region='.$region['ID']);
    
    }
    
    db::get_set("UPDATE `REGION` SET `NAME` = ?, `ID_COUNTRY` = ? WHERE `ID` = ? LIMIT 1", [COUNTRY_NAME, COUNTRY_COUNTRY, $region['ID']]);
    
    success('Изменения успешно приняты');
    redirect('/admin/site/modules/?mod=country&id_country='.COUNTRY_COUNTRY);
    
  }
  
  ?>
  <div class='list'>
  <form method='post' class='ajax-form' action='/admin/site/modules/?mod=country&edit_region=<?=$region['ID']?>'>
  <?=html::input('name', null, 'Введите название региона:', null, tabs($region['NAME']), 'form-control-100', null, 'text', 'globe')?>
  <?
  $array = array();
  $data = db::get_string_all("SELECT `ID`,`NAME` FROM `COUNTRY` ORDER BY `ID` ASC");  
  while ($list = $data->fetch()){
    
    $array[$list['ID']] = [$list['NAME'], ($region['ID_COUNTRY'] == $list['ID'] ? "selected" : null)];
  
  }
  html::select('country', $array, 'Страна', 'form-control-100-modify-select', 'globe');
  ?>  
  <?=html::button('button ajax-button', 'ok', 'save', 'Сохранить изменения')?>
  </form>
  </div>
  <?
  
  back('/admin/site/modules/?mod=country');
  acms_footer();
  
}

/*
--------------------
Редактирование стран
--------------------
*/

$country = db::get_string("SELECT * FROM `COUNTRY` WHERE `ID` = ? LIMIT 1", [intval(get('edit_country'))]);
if (get('edit_country') && isset($country['ID'])){
  
  if (post('ok')){
    
    valid::create(array(
      
      'COUNTRY_NAME' => ['name', 'text', [2, 200], 'Название', 0]
    
    ));
    
    if (ERROR_LOG == 1){     
      
      redirect('/admin/site/modules/?mod=country&edit_country='.$country['ID']);
    
    }
    
    db::get_set("UPDATE `COUNTRY` SET `NAME` = ? WHERE `ID` = ? LIMIT 1", [COUNTRY_NAME, $country['ID']]);
    
    success('Изменения успешно приняты');
    redirect('/admin/site/modules/?mod=country');
    
  }
  
  ?>
  <div class='list'>
  <form method='post' class='ajax-form' action='/admin/site/modules/?mod=country&edit_country=<?=$country['ID']?>'>
  <?=html::input('name', null, 'Введите название страны:', null, tabs($country['NAME']), 'form-control-100', null, 'text', 'globe')?>  
  <?=html::button('button ajax-button', 'ok', 'save', 'Сохранить изменения')?>
  </form>
  </div>
  <?
  
  back('/admin/site/modules/?mod=country');
  acms_footer();
  
}

/*
----------------
Удаление городов
----------------
*/

$city = db::get_string("SELECT * FROM `CITY` WHERE `ID` = ? LIMIT 1", [intval(get('delete_city'))]);
if (get('delete_city') && isset($city['ID'])){
  
  get_check_valid();
  
  db::get_set("DELETE FROM `CITY` WHERE `ID` = ? LIMIT 1", [$city['ID']]);
  
  success('Удаление прошло успешно');  
  redirect('/admin/site/modules/?mod=country&id_region='.$city['ID_REGION']);
  
}

/*
-----------------
Удаление регионов
-----------------
*/

$region = db::get_string("SELECT * FROM `REGION` WHERE `ID` = ? LIMIT 1", [intval(get('delete_region'))]);
if (get('delete_region') && isset($region['ID'])){
  
  get_check_valid();
  
  db::get_set("DELETE FROM `CITY` WHERE `ID_REGION` = ? LIMIT 1", [$region['ID']]);
  db::get_set("DELETE FROM `REGION` WHERE `ID` = ? LIMIT 1", [$region['ID']]);  
  
  success('Удаление прошло успешно');  
  redirect('/admin/site/modules/?mod=country&id_country='.$region['ID_COUNTRY']);
  
}

/*
--------------
Удаление стран
--------------
*/

$country = db::get_string("SELECT * FROM `COUNTRY` WHERE `ID` = ? LIMIT 1", [intval(get('delete_country'))]);
if (get('delete_country') && isset($country['ID'])){
  
  get_check_valid();
  
  $region = db::get_set("SELECT * FROM `REGION` WHERE `ID` = ? LIMIT 1", [$country['ID_REGION']]);
  
  db::get_set("DELETE FROM `CITY` WHERE `ID_REGION` = ? LIMIT 1", [$region['ID']]);
  db::get_set("DELETE FROM `REGION` WHERE `ID` = ? LIMIT 1", [$region['ID']]);  
  db::get_set("DELETE FROM `COUNTRY` WHERE `ID` = ? LIMIT 1", [$country['ID']]);
  
  success('Удаление прошло успешно');  
  redirect('/admin/site/modules/?mod=country');
  
}

/*
--------------
Список городов
--------------
*/

$region = db::get_string("SELECT * FROM `REGION` WHERE `ID` = ? LIMIT 1", [intval(get('id_region'))]);
if (get('id_region') && isset($region['ID'])){
  
  ?>
  <div class='list-body'>
  <div class='list-menu'>
  <a href='/admin/site/modules/?mod=country&id_region=<?=$region['ID']?>&get=add_city' class='button'><?=icons('plus', 15, 'fa-fw')?> <?=lg('Добавить город')?></a>
  </div>
  <?
  
  $column = db::get_column("SELECT COUNT(*) FROM `CITY` WHERE `ID_REGION` = ?", [$region['ID']]);
  $spage = spage($column, PAGE_SETTINGS);
  $page = page($spage);
  $limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;
  
  ?>
  <div class='list-menu list-title'>
  <?=tabs($region['NAME'])?>: <?=lg('Список городов')?> <span class='count'><?=$column?></span></b>
  </div>
  <?
  
  if ($column == 0){ 
    
    html::empty();
  
  }
  
  $data = db::get_string_all("SELECT * FROM `CITY` WHERE `ID_REGION` = ? ORDER BY `ID` DESC LIMIT ".$limit.", ".PAGE_SETTINGS, [$region['ID']]);  
  while ($list = $data->fetch()){
    
    ?>
    <div class='list-menu'>
    <?=lg(tabs($list['NAME']))?>
    <br /><br />
    <a href='/admin/site/modules/?mod=country&edit_city=<?=$list['ID']?>' class='button3'><?=icons('pencil', 15, 'fa-fw')?> <?=lg('Редактировать')?></a>
    <a href='/admin/site/modules/?mod=country&delete_city=<?=$list['ID']?>&<?=TOKEN_URL?>' class='button2'><?=icons('trash', 15, 'fa-fw')?> <?=lg('Удалить')?></a>
    </div>
    <?
  
  }
  
  ?></div><?
  
  get_page('/admin/site/modules/?mod=country&id_region='.$region['ID'].'&', $spage, $page);
  
  back('/admin/site/modules/?mod=country');
  acms_footer();
  
}

/*
---------------
Список регионов
---------------
*/

$country = db::get_string("SELECT * FROM `COUNTRY` WHERE `ID` = ? LIMIT 1", [intval(get('id_country'))]);
if (get('id_country') && isset($country['ID'])){
  
  ?>
  <div class='list-body'>
  <div class='list-menu'>
  <a href='/admin/site/modules/?mod=country&id_country=<?=$country['ID']?>&get=add_region' class='button'><?=icons('plus', 15, 'fa-fw')?> <?=lg('Добавить регион')?></a>
  </div>
  <?
  
  $column = db::get_column("SELECT COUNT(*) FROM `REGION` WHERE `ID_COUNTRY` = ?", [$country['ID']]);
  $spage = spage($column, PAGE_SETTINGS);
  $page = page($spage);
  $limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;
  
  ?>
  <div class='list-menu list-title'>
  <b><?=tabs($country['NAME'])?>: <?=lg('Список регионов')?> <span class='count'><?=$column?></span></b>
  </div>
  <?
  
  if ($column == 0){ 
    
    html::empty();
  
  }
  
  $data = db::get_string_all("SELECT * FROM `REGION` WHERE `ID_COUNTRY` = ? ORDER BY `ID` DESC LIMIT ".$limit.", ".PAGE_SETTINGS, [$country['ID']]);  
  while ($list = $data->fetch()){
    
    ?>
    <div class='list-menu'>
    <a href='/admin/site/modules/?mod=country&id_region=<?=$list['ID']?>'><?=lg(tabs($list['NAME']))?></a>
    <br /><br />
    <a href='/admin/site/modules/?mod=country&id_region=<?=$list['ID']?>' class='button'><?=icons('bars', 15, 'fa-fw')?> <?=lg('Список городов')?></a>    
    <a href='/admin/site/modules/?mod=country&edit_region=<?=$list['ID']?>' class='button3'><?=icons('pencil', 15, 'fa-fw')?> <?=lg('Редактировать')?></a>
    <a href='/admin/site/modules/?mod=country&delete_region=<?=$list['ID']?>&<?=TOKEN_URL?>' class='button2'><?=icons('trash', 15, 'fa-fw')?> <?=lg('Удалить')?></a>
    </div>
    <?
  
  }
  
  ?></div><?
  
  get_page('/admin/site/modules/?mod=country&id_country='.$country['ID'].'&', $spage, $page);
  
  back('/admin/site/modules/?mod=country');
  acms_footer();
  
}

/*
------------
Список стран
------------
*/

$count = db::get_column("SELECT COUNT(*) FROM `COUNTRY`");

?>
<div class='list-body'>
<div class='list-menu'>
<a href='/admin/site/modules/?mod=country&get=add_country' class='button'><?=icons('plus', 15, 'fa-fw')?> <?=lg('Добавить страну')?></a>
</div>
<div class='list-menu list-title'>
<b><?=lg('Список стран')?> <span class='count'><?=$count?></span></b>
</div>
<?

if ($count == 0){ 
  
  html::empty();
  
}

$data = db::get_string_all("SELECT * FROM `COUNTRY` ORDER BY `ID` DESC");
while ($list = $data->fetch()){
  
  ?><div class='list-menu'><?
  
  if (is_file(ROOT.'/style/country/'.$list['ID'].'.png')){
    
    ?><img src='/style/country/<?=$list['ID']?>.png'><?
    
  }else{
    
    ?>
    <?=lg('Флаг для этой страны не обнаружен. Загрузите через хостинг в папку /style/country/ флаг с названием')?> <b><?=$list['ID']?>.png</b>
    <br /><br />
    <?
    
  }
  
  ?>
  <a href='/admin/site/modules/?mod=country&id_country=<?=$list['ID']?>'><?=lg(tabs($list['NAME']))?></a>
  <br /><br />
  <a href='/admin/site/modules/?mod=country&id_country=<?=$list['ID']?>' class='button'><?=icons('bars', 15, 'fa-fw')?> <?=lg('Список регионов')?></a>
  <a href='/admin/site/modules/?mod=country&edit_country=<?=$list['ID']?>' class='button3'><?=icons('pencil', 15, 'fa-fw')?> <?=lg('Редактировать')?></a>
  <a href='/admin/site/modules/?mod=country&delete_country=<?=$list['ID']?>&<?=TOKEN_URL?>' class='button2'><?=icons('trash', 15, 'fa-fw')?> <?=lg('Удалить')?></a>
  </div>
  <?
  
}

?></div>