<?php 
$ad = db::get_string("SELECT * FROM `ADLIST` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);
html::title('Разместить объявление в VIP');
acms_header(); 
access('users');

if (config('PRIVATE_ADLIST') == 0){
  
  error('Модуль отключен администратором');
  redirect('/');
  
}

if (!isset($ad['ID'])) {
  
  error('Неверная директива');
  redirect('/m/adlist/');

}

if (post('ok_vip')){
  
  $day = intval(post('sum'));
  
  if ($day == 86400) {
    
    $money = config('ADLIST_VIP_SUM');
  
  }elseif ($day == 172800) {
    
    $money = config('ADLIST_VIP_SUM') * 2;
  
  }elseif ($day == 259200) {
    
    $money = config('ADLIST_VIP_SUM') * 3;
  
  }elseif ($day == 345600) {
    
    $money = config('ADLIST_VIP_SUM') * 4;
  
  }elseif ($day == 432000) {
    
    $money = config('ADLIST_VIP_SUM') * 5;
  
  }elseif ($day == 518400) {
    
    $money = config('ADLIST_VIP_SUM') * 6;
  
  }elseif ($day == 604800) {
    
    $money = config('ADLIST_VIP_SUM') * 7;
  
  }
  
  if ($money > user('MONEY')){
    
    error('У вас недостаточно денег');
    redirect('/m/adlist/vip/?id='.$ad['ID']);
  
  }
  
  if ($ad['VIP'] > TM) {
    
    $day = $ad['VIP'] + $day;
  
  }else{
    
    $day = TM + $day;
  
  }
  
  db::get_set("UPDATE `ADLIST` SET `VIP` = ? WHERE `ID` = ? LIMIT 1", [$day, $ad['ID']]);
  db::get_set("UPDATE `USERS` SET `MONEY` = ? WHERE `ID` = ? LIMIT 1", [(user('MONEY') - $money), user('ID')]);
  
  success('Услуга успешно продлена');
  redirect('/m/adlist/show/?id='.$ad['ID']);

}

?>
<div class='list'>
<?=lg('Вы собираетесь купить услугу')?> <font color='#FF5A99'><?=icons('diamond', 15, 'fa-fw')?><b>VIP</b></font> 
<br /><br />
<?=lg('Стоимость услуги')?>: 1 <?=lg('день')?> = <b><?=money(config('ADLIST_VIP_SUM'), 3)?></b><br />
<?=lg('Ваш баланс')?>: <b><?=money(user('MONEY'), 3)?></b><br />
<?=lg('Услуга подключена до')?>: <b><?=($ad['VIP'] > TM ? ftime($ad['VIP']) : lg('отсутствует срок'))?></b>
<br /><br />
<form method='post' class='ajax-form' action='/m/adlist/vip/?id=<?=$ad['ID']?>'>
<?=html::select('sum', array(
86400 => ['1 '.('день'), 86400], 
172800 => ['2 '.('дня'), 172800], 
259200 => ['3 '.('дня'), 259200], 
345600 => ['4 '.('дня'), 345600], 
432000 => ['5 '.('дней'), 432000], 
518400 => ['6 '.('дней'), 518400], 
604800 => ['7 '.('дней'), 604800]
), 'Выберите срок', 'form-control-100-modify-select', 'clock-o')?>
<?=html::button('button ajax-button', 'ok_vip', 'plus', 'Купить')?>  
<a class='button-o' href='/m/adlist/show/?id=<?=$ad['ID']?>'><?=lg('Отмена')?></a>
<br /><br />
<?=lg('После подключения услуги ваше объявление будет отображаться в отдельном блоке в поиске, каталоге и разделах объявлений')?>
</form> 
</div>
<?
  
back('/m/adlist/show/?id='.$ad['ID']);
acms_footer();