<?php
html::title('Добавить видео YouTube');
acms_header(); 
access('users');

$id_dir = intval(get('dir'));

if (get('dir') && db::get_column("SELECT COUNT(*) FROM `VIDEOS_DIR` WHERE `ID` = ? AND `USER_ID` = ? LIMIT 1", [$id_dir, user('ID')]) == 0){
  
  $id_dir = 0;

}

if (config('PRIVATE_VIDEOS') == 0){
  
  error('Модуль отключен администратором');
  redirect('/');
  
}

if (post('ok_yt')){
  
  valid::create(array(
    
    'VIDEOS_LINK' => ['link', 'text', [10, 300], 'Ссылка', 0],
    'VIDEOS_PRIVATE_COMMENTS' => ['private_comments', 'number', [0, 5], 'Приватность комментариев'],
    'VIDEOS_ID_ALBUM' => ['id_album', 'number', [0, 99999], 'Альбом']
  
  ));

  preg_match('#(\.be/|/embed/|/v/|/watch\?v=)([A-Za-z0-9_-]{5,11})#', VIDEOS_LINK, $matches);
  
  if (isset($matches[2]) && $matches[2] != ''){
    
    $YoutubeCode = $matches[2];
  
  }else{
    
    error('Не корректная ссылка');
    redirect('/m/videos/add_video_youtube/?id_dir='.$id_dir);
    
  }
  
  $api_url = 'https://www.googleapis.com/youtube/v3/videos?part=snippet%2CcontentDetails%2Cstatistics&id='.$YoutubeCode.'&key=AIzaSyBNdq3gnIyKfZb8ZENYn8XwwkjuD1RI1tY';  
  $data = json_decode(file_get_contents($api_url));  
  $name = esc($data->items[0]->snippet->title);
  $duration = esc($data->items[0]->contentDetails->duration);
  
  $start = new DateTime("@0");
  $start->add(new DateInterval($duration));
  $stime = $start->format("H:i:s");
  $sc = explode(":", $stime);
  $duration = $sc[0]*3600+$sc[1]*60+$sc[2];
  $time = new DateTime('@'.$duration);
  $duration = $time->format('H:i:s');
  
  if (str($name) == 0){
    
    error('Видео не найдено');
    redirect('/m/videos/add_video_youtube/?id_dir='.$id_dir);
    
  }
  
  if (ERROR_LOG == 1){
    
    redirect('/m/videos/add_video_youtube/?id_dir='.$id_dir);
  
  }
  
  db::get_add("INSERT INTO `VIDEOS` (`NAME`, `USER_ID`, `TIME`, `ID_DIR`, `YOUTUBE`, `DURATION`, `PRIVATE_COMMENTS`, `EXT`) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", [$name, user('ID'), TM, VIDEOS_ID_ALBUM, $YoutubeCode, $duration, VIDEOS_PRIVATE_COMMENTS, 'mp4']);
  
  success('Видео успешно импортировано');
  redirect('/m/videos/users/?id='.user('ID').'&id_dir='.$dir_id);
  
}

?>
<div class='list'>
<form method='post' class='ajax-form' action='/m/videos/add_video_youtube/?id_dir=<?=$id_dir?>'>
<?=html::input('link', null, 'Введите ссылку на видео YouTube (Например: https://youtube.com/watch?v=mWGw4fLgu5o):', null, null, 'form-control-100', null, 'text', 'youtube')?>
<?php
$array = array();
$array[0] = ['Без альбома', ($id_dir == 0 ? "selected" : null)];
$data = db::get_string_all("SELECT * FROM `VIDEOS_DIR` WHERE `USER_ID` = ? ORDER BY `ID` DESC", [user('ID')]);  
while ($list = $data->fetch()){
  
  $array[$list['ID']] = [$list['NAME'], ($id_dir == $list['ID'] ? "selected" : null)];

}
html::select('id_album', $array, 'Альбом', 'form-control-100-modify-select', 'folder');
html::select('private_comments', array(
  0 => ['Всем'], 
  1 => ['Мне и друзьям'], 
  2 => ['Только мне']
), 'Комментирование', 'form-control-100-modify-select', 'comment');
html::button('button ajax-button', 'ok_yt', 'plus', 'Импортировать видео');
?>
</form>
</div>
<?

back('/m/videos/users/?id='.user('ID').'&dir='.$id_dir);   
acms_footer();