<?php
  
html::title('Восстановление доступа');
acms_header();
access('guests');

//Установка нового пароля
if (get('id') && get('hash')){
  
  $user = db::get_string("SELECT `ID`,`LOGIN`,`EMAIL_HASH` FROM `USERS` WHERE `ID` = ? AND `EMAIL_HASH` = ? LIMIT 1", [intval(get('id')), esc(get('hash'))]);
  
  if (isset($user['ID'])){
    
    if (post('ok_pass')){
      
      valid::create(array(
        
        'PASS_PASSWORD' => ['password', 'password'],
        'captcha' => []
      
      ));
      
      if (ERROR_LOG == 1){
        
        redirect('/password/?id='.$user['ID'].'&hash='.$user['EMAIL_HASH']);
      
      }
      
      $hash = user_hash($user['ID']);
      
      db::get_set("UPDATE `USERS` SET `HASH` = ?, `EMAIL_HASH` = ?, `PASSWORD` = ? WHERE `ID` = ? LIMIT 1", [$hash, null, shif(PASS_PASSWORD), $user['ID']]);
      
      setcookie('DOUBLE', 1, TM + 60 * 60 * 24 * 365, '/');
      setcookie('USER_ID', user_shif($user['ID']), TM + 60 * 60 * 24 * 365, '/');
      setcookie('PASSWORD', cencrypt(post('password'), $user['ID']), TM + 60 * 60 * 24 * 365, '/');
      session('salt', base64_encode(user_shif($user['ID']).','.cencrypt(post('password'), $user['ID'])));
      
      success('Доступ успешно восстановлен');    
      redirect('/account/');
    
    }
    
    ?>
    <div class='circle1'></div>
    <div class='circle2'></div>  
    <div class='circle3'></div>  
      
    <form method='post' action='/password/' class='list-tr'>
      
    <center>
    <div class='list-tr-avatar'>
    <?=icons('unlock', 40)?>  
    </div>
    <div class='aut-text'><?=lg('Теперь осталось придумать новый пароль для входа')?></div>
    </center>
      
    <?php
    html::input('login', 'Логин', null, config('REG_STR'), tabs($user['LOGIN']), 'form-control-100', 'text', 'disabled=disabled', 'user'); 
    html::input('password', 'Придумайте пароль', null, 24, null, 'form-control-100', 'password', null, 'lock', 'Придумайте сложный пароль, состоящий из латиницы, кириллицы, цифр или символов "_-@.%+". От 8 до 20 символов'); 
    html::input('password2', 'Повторите пароль', null, 24, null, 'form-control-100', 'password', null, 'lock', 'Повторите предыдущий пароль ещё раз');
    html::captcha('Введите числа');
    html::button('button', 'ok_pass', 'unlock', 'Восстановить доступ'); 
    ?>
      
    <br />
      
    <a href='/registration/' class='aut'><?=lg('Регистрация')?></a>
    <a href='/login/' style='float: right;' class='aut'><?=lg('Авторизация')?></a>  
      
    </form>
    <?
    
  }else{
    
    error('Неизвестная ошибка');
    redirect('/password/');
  
  }

}else{
  
  //Отправка сообщения для восстановления доступа  
  if (post('ok_pass')){
    
    $code = md5(mt_rand(0000000,9999999));
    $email = esc(post('email'));
    $login = esc(post('login'));
    
    if (db::get_column("SELECT COUNT(`ID`) FROM `USERS` WHERE `EMAIL` = ? AND `LOGIN` = ? LIMIT 1", [$email, $login]) == 0){
      
      error('Не удалось найти пользователя с таким E-mail');
      redirect('/password/');
    
    }
    
    valid::create(array('captcha' => []));
    
    session('email', $email);
    session('login', $login);
    
    if (ERROR_LOG == 1){
      
      redirect('/password/');
    
    }
    
    $user = db::get_string("SELECT `ID` FROM `USERS` WHERE `LOGIN` = ? LIMIT 1", [$login]);
    
    email($email, 'Восстановление доступа к аккаунту на '.HTTP_HOST, 'Здравствуйте. Вы получили это письмо для восстановления доступа к аккаунту на нашем сайте <b>'.HTTP_HOST.'</b>.<br><br> Ваш логин: <b>'.$login.'</b><br /><br />Перейдите по ссылке для установки нового пароля:<br /><a href="'.SCHEME.HTTP_HOST.'/password/?id='.$user['ID'].'&hash='.$code.'">'.SCHEME.HTTP_HOST.'/password/?id='.$user['ID'].'&hash='.$code.'</a>', tabs(config('EMAIL')));
    
    db::get_set("UPDATE `USERS` SET `EMAIL_HASH` = ? WHERE `ID` = ? LIMIT 1", [$code, $user['ID']]);
    
    session('email', null);
    session('login', null);
    
    success('Письмо успешно отправлено на указанный адрес. Перейдите к письму и следуйте дальнейшим инструкциям');
    redirect('/password/');  
  
  }
  
  ?>
  <div class='circle1'></div>
  <div class='circle2'></div>  
  <div class='circle3'></div>  
      
  <form method='post' class='list-tr'>
      
  <center>
  <div class='list-tr-avatar'>
  <?=icons('unlock', 40)?>
  </div>
  <div class='aut-text'><?=lg('Отправьте письмо с ссылкой для восстановления доступа на e-mail адрес, привязанный к вашему логину')?></div>
  </center>
    
  <?php
  html::input('login', 'Логин', null, config('REG_STR'), tabs(session('login')), 'form-control-100', 'text', null, 'user', 'Укажите логин, к которому нужно восстановить доступ'); 
  html::input('email', 'Укажите e-mail', null, 100, tabs(session('login')), 'form-control-100', 'text', null, 'at', 'Укажите e-mail, привязанный к логину');
  html::captcha('Введите числа');  
  html::button('button', 'ok_pass', 'envelope', 'Отправить письмо'); 
  ?>
    
  <br />
      
  <a href='/registration/' class='aut'><?=lg('Регистрация')?></a>
  <a href='/login/' style='float: right;' class='aut'><?=lg('Авторизация')?></a>  
      
  </form>
  <?
  
}

acms_footer();