<?php  
html::title('О системе');
acms_header();
access('management'); 
?>

<div class='navigation'>
<a href='/admin/desktop/'><?=icons('home', 25)?></a>
<?=icons('angle-right', 25, 'fa-fw')?>
<a href='/admin/system/'><?=lg('Настройки системы')?></a>
<?=icons('angle-right', 25, 'fa-fw')?>
<?=lg('О системе')?>
</div>
  
<div class='list-body6'>
<div class='list-menu list-title'>
<?=lg('Системные требования')?>
</div>

<div class='list-menu'>
<?php
list($php_ver1, $php_ver2, $php_ver3) = explode('.', strtok(strtok(phpversion(),'-'),' '), 3);
$php_p = $php_ver1.".".$php_ver2;

if ($php_p == '7.3' || $php_p == '7.2'){
  
  $php = "<span class='info green'>".lg('есть')."</span>";
  
}else{
  
  $php = "<span class='info red'>".lg('отсутствует')."</span>";
  
}
?>
<b><?=lg('Версия PHP')?> 7.2/7.3</b> <?=$php?><br /><small><?=lg('работа с PHP скриптами для взаимодействия пользователя с сервером')?></small><br /><br /><?=lg('Текущая версия')?>: <span class='info gray'><?=$php_ver1?>.<?=$php_ver2?>.<?=$php_ver3?></span>
</div>
  
<div class='list-menu'>
<?php
if (db::connect(0)){
  
  $pdo = "<span class='info green'>".lg('есть')."</span>";
  
}else{
  
  $pdo = "<span class='info red'>".lg('отсутствует')."</span>";
  
}
?>  
<b><?=lg('Драйвер PDO')?></b> <?=$pdo?><br /><small><?=lg('работа с базами данных MySQL')?></small>
</div>
  
<div class='list-menu'>
<?php
if (function_exists('ffmpeg_movie')) {
  
  $ffmpeg = "<span class='info green'>".lg('есть')."</span>";
  
}else{
  
  $ffmpeg = "<span class='info red'>".lg('отсутствует')."</span>";
  
}
?>  
<b><?=lg('Поддержка')?> FFmpeg</b> <?=$ffmpeg?><br /><small><?=lg('работа с видеофайлами. Не обязательно, если включена функция exec() и FFmpeg установлена на сервер через терминал')?></small>
</div>
  
<div class='list-menu'>
<?php
if (function_exists('exec')) {
  
  $exec = "<span class='info green'>".lg('есть')."</span>";
  
}else{
  
  $exec = "<span class='info red'>".lg('отсутствует')."</span>";
  
}
?>  
<b><?=lg('Вызов внешней программы')?> exec()</b> <?=$exec?><br /><small><?=lg('удаленное соединение с FFmpeg на сервере при отсутствии на PHP. Не обязательно, если FFmpeg работает на PHP')?></small>
</div>
  
<div class='list-menu'>
<?php
$mod_rewrite = @apache_get_modules();
if (array_search('mod_rewrite', $mod_rewrite)) {
  
  $mr = "<span class='info green'>".lg('есть')."</span>";

}else{
  
  $mr = "<span class='info red'>".lg('отсутствует')."</span>";
  
}
?>
<b><?=lg('Поддержка')?> mod_rewrite</b> <?=$mr?><br /><small><?=lg('работа ссылок в образе ЧПУ')?></small>
</div>
  
<div class='list-menu'>
<?php
$mod_rewrite = @apache_get_modules();
if (array_search('mod_php7', $mod_rewrite)) {
  
  $mp = "<span class='info green'>".lg('есть')."</span>";

}else{
  
  $mp = "<span class='info red'>".lg('отсутствует')."</span>";
  
}
?>
<b><?=lg('Поддержка')?> mod_php7</b> <?=$mp?><br /><small><?=lg('интерпретирование PHP >= 7 через .htaccess')?></small>
</div>
  
<div class='list-menu'>
<?php
if (function_exists('disk_free_space') && function_exists('disk_total_space')){
  
  $free_space = disk_free_space(ROOT);
  $total_space = disk_total_space(ROOT);
  
  $disk = "<span class='info gray'>".lg('свободно').": ".size_file($free_space)." из ".size_file($total_space)."</span>";
  
}else{
  
  $disk = "<span class='info red'>".lg('нет данных')."</span>";
  
}
?>
<b><?=lg('Память на сервере')?></b> <br /><?=$disk?>
</div>
  
</div>
  
<div class='list-body6'>
<div class='list-menu list-title'>
<?=lg('Общая информация')?>
</div>
<div class='list-menu'>
<?=lg('Версия')?>: <span class='info gray'><?=tabs(config('ACMS_VERSION'))?></span><br />
<?=lg('Тип')?>: <span class='info gray'><?=tabs(config('ACMS_TYPE'))?></span><br />
<?=lg('Посл. обновление')?>: <span class='info gray'><?=tabs(config('ACMS_UPDATE'))?></span><br />
<?=lg('Полное наименование')?>: <span class='info gray'><?=tabs(config('ACMS_NAME'))?></span><br />
<?=lg('Официальный сайт поддержки')?>: <a class='info blue' href='https://alpha-cms.ru' ajax='no'>alpha-cms.ru</a><br />
<?=lg('Руководитель проекта')?>: <a class='info blue' href='https://alpha-cms.ru/id1' ajax='no'>adm (ID: 1)</a><br />
</div>  
</div>  

<?
back('/admin/system/');
acms_footer();