<?php

html::title('Регистрация');
acms_header();
access('guests');

/*
------------------------
Если регистрация закрыта
------------------------
*/

if (config('REG_MODE') == 0){

  html::empty('Извините, регистрация закрыта', 'times');
  acms_footer();
  
}

/*
-------------------------------
Запрет на повторную регистрацию
-------------------------------
*/

if (config('REG_ANTIDOUBLE') == 1 && cookie('DOUBLE') == 1 || config('REG_ANTIDOUBLE') == 2 && cookie('DOUBLE') == 1 || config('REG_ANTIDOUBLE') == 2 && db::get_column("SELECT COUNT(`ID`) FROM `USERS` WHERE `IP` = ? LIMIT 1", [IP]) == 1){
  
  html::empty('Извините, вы не можете зарегистрироваться, так как уже регистрировались', 'times');
  acms_footer();
  
}

if (post('ok_reg')){ 
  
  valid::create(array(
    
    'REG_LOGIN' => ['login', 'login'],
    'REG_PASSWORD' => ['password', 'password'],
    'REG_SEX' => ['sex', 'number', [1, 2], 'Пол'],
    'REG_EMAIL' => ['email', 'email', [5, 50], 'E-mail', config('REG_MODE')],
    'EMAIL_CHECK' => ['email', (config('REG_MODE') == 2 ? 'email_check' : null)],
    'captcha' => [],
    'rules' => []
    
  ));
  
  session('login', REG_LOGIN);
  session('password', REG_PASSWORD);
  session('password2', post('password2'));
  session('sex', REG_SEX);
  if (config('REG_MODE') == 2){ session('email', REG_EMAIL); }
  
  if (ERROR_LOG == 1){

    redirect('/registration/');
    
  }
  
  $ID = db::get_add("INSERT INTO `USERS` (`BROWSER`, `IP`, `DATE_CREATE`, `DATE_VISIT`, `LOGIN`, `PASSWORD`, `SEX`) VALUES (?, ?, ?, ?, ?, ?, ?)", [BROWSER, IP, TM, TM, REG_LOGIN, shif(REG_PASSWORD), REG_SEX]);
  
  $user = db::get_string("SELECT * FROM `USERS` WHERE `ID` = ? AND `LOGIN` = ? AND `PASSWORD` = ? LIMIT 1", [$ID, REG_LOGIN, shif(REG_PASSWORD)]);
  $hash = user_hash($user['ID']);
  
  if (config('REG_MODE') == 2){
    
    $code = rand(111111,999999);
    email(tabs(REG_EMAIL), 'Подтверждение E-mail на '.HTTP_HOST, 'Здравствуйте. Вы получили это письмо для подтверждения E-mail адреса на нашем сайте <b>'.HTTP_HOST.'</b>.<br><br> Введите этот код для подтверждения: <b>'.$code.'</b>', tabs(config('EMAIL')));
    db::get_set("UPDATE `USERS` SET `REG_CODE` = ?, `REG_EMAIL` = ?, `REG_OK` = ?, `REG_TIME` = ? WHERE `ID` = ? LIMIT 1", [$code, REG_EMAIL, 1, TM, $user['ID']]);
    
  }
  
  db::get_set("UPDATE `USERS` SET `HASH` = ? WHERE `ID` = ? LIMIT 1", [$hash, $user['ID']]);
  
  setcookie('DOUBLE', 1, TM + 60 * 60 * 24 * 365, '/');
  setcookie('USER_ID', user_shif($user['ID']), TM + 60 * 60 * 24 * 365, '/');
  setcookie('PASSWORD', cencrypt(post('password'), $user['ID']), TM + 60 * 60 * 24 * 365, '/');
  session('salt', base64_encode(user_shif($user['ID']).','.cencrypt(post('password'), $user['ID'])));
  
  session('login', null);
  session('password', null);
  session('password2', null);
  session('sex', 0);
  if (config('REG_MODE') == 2){ session('email', null); }

  hooks::challenge('reg', 'reg');  
  hooks::run('reg');
  
  $avatar_rand_param = array('#6E8CCE', '#53C8A9', '#8FA1A9', '#FC8FD8', '#AFBC81', '#B381BC', '#EB6156', '#FD8B2C', '#72C375', '#B970C5', '#31ACB8', '#5498CE', '#997445', '#4EA771', '#828D92', '#F55448');
  $avatar_rand = array_rand($avatar_rand_param, 1);
  $avatar = $avatar_rand_param[$avatar_rand];
  
  db::get_add("INSERT INTO `NOTIFICATIONS_SETTINGS` (`USER_ID`) VALUES (?)", [$user['ID']]);
  db::get_add("INSERT INTO `MAIL_SETTINGS` (`USER_ID`) VALUES (?)", [$user['ID']]);
  db::get_add("INSERT INTO `USERS_SETTINGS` (`USER_ID`, `AVATAR_PHONE`) VALUES (?, ?)", [$user['ID'], $avatar]);
  
  success('Регистрация прошла успешно');    
  redirect('/account/cabinet/');

}

?>

<div class='circle1'></div>
<div class='circle2'></div>  
<div class='circle3'></div>  
  
<form method='post' action='/registration/' class='list-tr'>
  
<?php
hooks::challenge('reg_head', 'reg_head');  
hooks::run('reg_head');
?>
  
<center>
<div class='list-tr-avatar'>
<?=icons('id-card-o', 40)?>
</div>
<div class='aut-text'><?=lg('Пройдите легкую и быструю регистрацию для получения доступа ко всем возможностям')?></div>
</center>
  
<?php 

if (config('REG_LANG') == 1){
  
  $reg_lang = lg('Например: %s, 3-%d символов, только латиница, символы "_-." и цифры', '<b>Ivan_Ivanov</b>', config('REG_STR'));
  
}elseif (config('REG_LANG') == 2){
  
  $reg_lang = lg('Например: %s, 3-%d символов, только кириллица, символы "_-." и цифры', '<b>Иван_Иванов</b>', config('REG_STR'));
  
}elseif (config('REG_LANG') == 0){
  
  $reg_lang = lg('Например: %s или %s, 3-%d символов, только латиница, кириллица, символы "_-." и цифры', '<b>Иван_Иванов</b>', '<b>Ivan_Ivanov</b>', config('REG_STR'));
  
}

html::input('login', 'Придумайте логин', null, config('REG_STR'), tabs(session('login')), 'form-control-100', 'text', null, 'user', $reg_lang);
html::input('password', 'Придумайте пароль', null, 24, tabs(session('password')), 'form-control-100', 'password', null, 'lock', 'Придумайте сложный пароль, состоящий из латиницы, кириллицы, цифр или символов "_-@.%+". От 8 до 20 символов');
html::input('password2', 'Повторите пароль', null, 24, tabs(session('password2')), 'form-control-100', 'password', null, 'lock', 'Повторите предыдущий пароль ещё раз');

if (config('REG_MODE') == 2){
  
  html::input('email', 'Укажите свой e-mail', null, 50, tabs(session('email')), 'form-control-100', 'text', null, 'at');
  
}

html::select('sex', array(
  1 => ['Мужской', (session('sex') == 1 ? "selected" : null)], 
  2 => ['Женский', (session('sex') == 2 ? "selected" : null)]
), 'Выберите пол', 'form-control-100-modify-select', 'venus-mars');

html::captcha('Введите числа');
html::checkbox('rules', 'я обязуюсь соблюдать', 1, 1);
?><a href="/m/rules/" style='position: relative; bottom: 5px;'><?=lg('правила сайта')?></a><br /><br /><?
html::button('button', 'ok_reg', 'plus', 'Зарегистрироваться');

?>
  
<br />
  
<a href='/password/' class='aut'><?=lg('Забыли пароль?')?></a>
<a href='/login/' style='float: right;' class='aut'><?=lg('Уже есть аккаунт?')?></a>  
  
<?php
hooks::challenge('reg_foot', 'reg_foot');  
hooks::run('reg_foot');
?>

</form>

<?php acms_footer();