<?php  
html::title('Настройки регистрации');
acms_header();
access('management');
  
?>
<div class='navigation'>
<a href='/admin/desktop/'><?=icons('home', 25)?></a>
<?=icons('angle-right', 25, 'fa-fw')?>
<a href='/admin/system/'><?=lg('Настройки системы')?></a>
<?=icons('angle-right', 25, 'fa-fw')?>
<?=lg('Настройки регистрации')?>
</div>  
<?
  
if (post('ok_reg_set')){
  
  valid::create(array(

    'REG_MODE' => ['reg_mode', 'number', [0, 5], 'Режим регистрации'],
    'REG_STR' => ['reg_str', 'number', [3, 15], 'Длина логина'],
    'REG_LANG' => ['reg_lang', 'number', [0, 5], 'Допустимые буквы'],
    'REG_DOUBLE' => ['reg_double', 'number', [0, 5], 'Дубль логина'],
    'REG_ANTIDOUBLE' => ['reg_antidouble', 'number', [0, 5], 'Запрет на повторную регистрацию']
  
  ));
  
  if (ERROR_LOG == 1) {
    
    redirect('/admin/system/registration/');
    
  }
  
  ini::upgrade(ROOT.'/system/config/global/settings.ini', 'REG_MODE', REG_MODE);
  ini::upgrade(ROOT.'/system/config/global/settings.ini', 'REG_STR', REG_STR);
  ini::upgrade(ROOT.'/system/config/global/settings.ini', 'REG_LANG', REG_LANG);
  ini::upgrade(ROOT.'/system/config/global/settings.ini', 'REG_DOUBLE', REG_DOUBLE);
  ini::upgrade(ROOT.'/system/config/global/settings.ini', 'REG_ANTIDOUBLE', REG_ANTIDOUBLE);
  
  success('Изменения успешно приняты');
  redirect('/admin/system/registration/');

}

?>
<div class='list-body6'>

<div class='list-menu'>
<form method='post' action='/admin/system/registration/' class='ajax-form'>
  
<?=html::select('reg_mode', array(
  1 => ['Упрощенный без E-mail', (config('REG_MODE') == 1 ? "selected" : null)], 
  2 => ['С подтвержением E-mail', (config('REG_MODE') == 2 ? "selected" : null)], 
  0 => ['Закрытый (регистрация недоступна)', (config('REG_MODE') == 0 ? "selected" : null)]
), 'Режим регистрации', 'form-control-100-modify-select', 'user-plus')?> 
  
<?=html::select('reg_lang', array(
  1 => ['Только буквы английского алфавита', (config('REG_LANG') == 1 ? "selected" : null)], 
  2 => ['Только буквы русского алфавита', (config('REG_LANG') == 2 ? "selected" : null)], 
  0 => ['Буквы русского и английского алфавитов', (config('REG_LANG') == 0 ? "selected" : null)]
), 'Допустимые буквы при регистрации логина', 'form-control-100-modify-select', 'user-plus')?>

<?=html::input('reg_str', 'Количество допустимых символов в логине', null, null, config('REG_STR'), 'form-control-30', null, 'text', 'user-plus', 'Количество допустимых символов в логине. От 3 до 15 символов')?>
  
<?=html::select('reg_double', array(
  1 => ['Да', (config('REG_DOUBLE') == 1 ? "selected" : null)], 
  0 => ['Нет', (config('REG_DOUBLE') == 0 ? "selected" : null)] 
), 'Дублирование логинов', 'form-control-100-modify-select', 'user-plus')?> 
  
<?=html::select('reg_antidouble', array(
  1 => ['Проверка COOKIE', (config('REG_ANTIDOUBLE') == 1 ? "selected" : null)], 
  2 => ['Проверка COOKIE + IP', (config('REG_ANTIDOUBLE') == 2 ? "selected" : null)], 
  0 => ['Разрешена (нет запрета)', (config('REG_ANTIDOUBLE') == 0 ? "selected" : null)]
), 'Запрет повторной регистрации', 'form-control-100-modify-select', 'user-plus')?>  
  
<?=html::button('button ajax-button', 'ok_reg_set', 'save', 'Сохранить изменения')?>

</form>

</div>
</div>
<br />
<?
  
back('/admin/system/');
acms_footer();