<?php

/*
----------------------
Редактирование слайдов
----------------------
*/

if (get('edit')){
  
  $slide = db::get_string("SELECT * FROM `SLIDES` WHERE `ID` = ? LIMIT 1", [intval(get('edit'))]);
  
  if (isset($slide['ID'])){
    
    if (post('ok')){
      
      valid::create(array(
        
        'SL_NAME' => ['name', 'text', [1, 25], 'Название', 0],
        'SL_MESSAGE' => ['message', 'text', [1, 40], 'Описание', 0],
        'SL_LINK' => ['link', 'link', [0, 250], 'Ссылка'],
        'SL_LINK_NAME' => ['link_name', 'text', [0, 250], 'Имя ссылки', 0],
        'SL_LEVEL' => ['level', 'number', [0, 999999], 'Уровень']
      
      ));
      
      if (ERROR_LOG == 1){     
        
        redirect('/admin/site/modules/?mod=slides&edit='.$slide['ID']);
      
      }
      
      db::get_set("UPDATE `SLIDES` SET `NAME` = ?, `POSITION` = ?, `MESSAGE` = ?, `LINK_NAME` = ?, `LINK` = ? WHERE `ID` = ? LIMIT 1", [SL_NAME, SL_LEVEL, SL_MESSAGE, SL_LINK_NAME, SL_LINK, $slide['ID']]);
      
      success('Изменения успешно приняты');
      redirect('/admin/site/modules/?mod=slides');
    
    }
    
    ?>
    <div class='list-body'>
    <div class='list-menu'>
    <form method='post' class='ajax-form' action='/admin/site/modules/?mod=slides&edit=<?=$slide['ID']?>' method='post'>
    <b><?=lg('Введите название слайда')?></b> (<?=lg('от 1 до 25 символов')?>):<br />
    <?=html::input('name', 'Имя', null, null, tabs($slide['NAME']), 'form-control-100', 'text', null, 'text-width')?>
    <b><?=lg('Введите описание слайда')?></b> (<?=lg('от 1 до 40 символов')?>):<br />
    <?=html::input('message', 'Описание', null, null, tabs($slide['MESSAGE']), 'form-control-100', 'text', null, 'text-width')?>
    <b><?=lg('Введите ссылку')?></b>:<br />
    <?=html::input('link', 'Ссылка', null, null, tabs($slide['LINK']), 'form-control-100', 'text', null, 'link')?>
    <b><?=lg('Введите имя ссылки')?></b>:<br />
    <?=html::input('link_name', 'Имя ссылки', null, null, tabs($slide['LINK_NAME']), 'form-control-100', 'text', null, 'link')?>
    <b><?=lg('Уровень')?></b>:<br />
    <?=html::input('level', 0, null, null, $slide['POSITION'], 'form-control-30', 'text', null, 'sort-numeric-asc')?>
    <?=html::button('button ajax-button', 'ok', 'save', 'Сохранить изменения')?>
    <a href='/admin/site/modules/?mod=slides' class='button-o'><?=lg('Отмена')?></a>
    </form>
    </div>
    </div>
    <?
  
    back('/admin/site/modules/?mod=slides');
    acms_footer();
    
  }
  
}

/*
----------------
Удаление слайдов
----------------
*/

if (get('delete')){
  
  $slide = db::get_string("SELECT * FROM `SLIDES` WHERE `ID` = ? LIMIT 1", [intval(get('delete'))]);
  
  if (isset($slide['ID'])){
    
    @unlink(ROOT.'/files/upload/slides/650x200/'.$slide['ID'].'.'.$slide['EXT']);
    @unlink(ROOT.'/files/upload/slides/source/'.$slide['ID'].'.'.$slide['EXT']);
    
    db::get_set("DELETE FROM `SLIDES` WHERE `ID` = ? LIMIT 1", [$slide['ID']]);
    
    success('Удаление прошло успешно');  
    redirect('/admin/site/modules/?mod=slides');
    
  }
  
}

/*
--------------
Добавить слайд
--------------
*/

if (get('get') == 'add'){
  
  if (post('ok')){
    
    valid::create(array(
      
      'SL_NAME' => ['name', 'text', [1, 25], 'Название', 0],
      'SL_MESSAGE' => ['message', 'text', [1, 40], 'Описание', 0],
      'SL_LINK' => ['link', 'link', [0, 250], 'Ссылка'],
      'SL_LINK_NAME' => ['link_name', 'text', [0, 250], 'Имя ссылки', 0],
      'SL_LEVEL' => ['level', 'number', [0, 999999], 'Уровень']
    
    ));
    
    if (ERROR_LOG == 1){     
      
      redirect('/admin/site/modules/?mod=slides&get=add');
    
    }
    
    db::get_add("INSERT INTO `SLIDES` (`NAME`, `POSITION`, `MESSAGE`, `LINK_NAME`, `LINK`) VALUES (?, ?, ?, ?, ?)", [SL_NAME, SL_LEVEL, SL_MESSAGE, SL_LINK_NAME, SL_LINK]);
    
    success('Слайд успешно добавлен');
    redirect('/admin/site/modules/?mod=slides');
  
  }
  
  ?>
  <div class='list-body'>
  <div class='list-menu'>
  <form method='post' method='post' class='ajax-form' action='/admin/site/modules/?mod=slides&get=add'>
  <b><?=lg('Введите название слайда')?></b> (<?=lg('от 1 до 25 символов')?>):<br />
  <?=html::input('name', 'Имя', null, null, null, 'form-control-100', 'text', null, 'text-width')?>
  <b><?=lg('Введите описание слайда')?></b> (<?=lg('от 1 до 40 символов')?>):<br />
  <?=html::input('message', 'Описание', null, null, null, 'form-control-100', 'text', null, 'text-width')?>
  <b><?=lg('Введите ссылку')?></b>:<br />
  <?=html::input('link', 'Ссылка', null, null, null, 'form-control-100', 'text', null, 'link')?>
  <b><?=lg('Введите имя ссылки')?></b>:<br />
  <?=html::input('link_name', 'Имя ссылки', null, null, null, 'form-control-100', 'text', null, 'link')?>
  <b><?=lg('Уровень')?></b>:<br />
  <?=html::input('level', 0, null, null, null, 'form-control-30', 'text', null, 'sort-numeric-asc')?>    
  <?=html::button('button ajax-button', 'ok', 'plus', 'Добавить')?>
  <a href='/admin/site/modules/?mod=slides' class='button-o'><?=lg('Отмена')?></a>
  </form>
  </div>
  </div>
  <?
    
}

/*
---------------
Загрузить слайд
---------------
*/

if (get('upload')){
  
  $slide = db::get_string("SELECT `ID`,`EXT`,`NAME`,`HASH` FROM `SLIDES` WHERE `ID` = ? LIMIT 1", [intval(get('upload'))]);
  
  if (isset($slide['ID'])){
    
    attachments_result();
    
    ?>
    <div class='list-body'>
    <div class='list-menu list-title'><b><?=tabs($slide['NAME'])?> - <?=lg('подгрузить слайд')?></b></div>
    <div class='list-menu'>
    <?=lg('Рекомндуемый размер изображения')?>: 650x200<br /><br />
    <a ajax="no" id="modal_bottom_open_set" onclick="upload('/system/AJAX/php/slides.php?id=<?=$slide['ID']?>', 'attachments_upload')" class="button3"><?=icons('upload', 15, 'fa-fw')?> <?=lg('Загрузить слайд')?></a>
    <div id='upload-slide'>
    <?php if (is_file(ROOT.'/files/upload/slides/source/'.$slide['ID'].'.'.$slide['EXT'])) { ?>
    <br /><br />
    <img src='/files/upload/slides/650x200/<?=$slide['ID']?>.jpg?hash=<?=$slide['HASH']?>' style='max-width: 140px'>
    <br /><br />
    <a href='/admin/site/modules/?mod=slides' class='button'><?=lg('Готово')?></a>  
    <?php } ?>
    </div>
    </div>
    </div>
    <?
      
  }
  
}
  
/*
-------------------------------
Список слайдов и управление ими
-------------------------------
*/

$column = db::get_column("SELECT COUNT(*) FROM `SLIDES`");
$spage = spage($column, PAGE_SETTINGS);
$page = page($spage);
$limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;

?>
<div class='list-body'>
<div class='list-menu list-title'><b><?=lg('Список слайдов')?> <span class='count'><?=$column?></span></b></div>
  
<div class='list-menu'>
<a href='/admin/site/modules/?mod=slides&get=add' class='button'><?=icons('plus', 15, 'fa-fw')?> <?=lg('Добавить слайд')?></a>
</div>
<?

if ($column == 0){ 
  
  html::empty();

}

$id = intval(get('id'));

if (get('act') == 'on' && db::get_column("SELECT COUNT(*) FROM `SLIDES` WHERE `ID` = ? AND `ACTIVE` = '0' LIMIT 1", [$id]) > 0){
  
  db::get_set("UPDATE `SLIDES` SET `ACTIVE` = '1' WHERE `ID` = ? LIMIT 1", [$id]);
  
  success('Изменения успешно приняты');  
  redirect('/admin/site/modules/?mod=slides');
  
}

if (get('act') == 'off' && db::get_column("SELECT COUNT(*) FROM `SLIDES` WHERE `ID` = ? AND `ACTIVE` = '1' LIMIT 1", [$id]) > 0){
  
  db::get_set("UPDATE `SLIDES` SET `ACTIVE` = '0' WHERE `ID` = ? LIMIT 1", [$id]);
  
  success('Изменения успешно приняты');  
  redirect('/admin/site/modules/?mod=slides');
  
}

$data = db::get_string_all("SELECT * FROM `SLIDES` ORDER BY `POSITION` DESC LIMIT ".$limit.", ".PAGE_SETTINGS);
while ($list = $data->fetch()){
  
  ?>
  <div class='list-menu'>
  <?php if (is_file(ROOT.'/files/upload/slides/650x200/'.$list['ID'].'.jpg')) { ?>
  <img src='/files/upload/slides/650x200/<?=$list['ID']?>.jpg?hash=<?=$list['HASH']?>' style='max-width: 200px'><br /><br />
  <?php } ?>
  <b><?=lg('Заголовок')?>:</b> <?=tabs($list['NAME'])?><br />
  <b><?=lg('Описание')?>:</b> <?=tabs($list['MESSAGE'])?><br />
  <b><?=lg('Ссылка')?>:</b> <?=tabs($list['LINK'])?><br />
  <b><?=lg('Имя ссылки')?>:</b> <?=tabs($list['LINK_NAME'])?><br />
  <b><?=lg('Уровень')?>:</b> <?=tabs($list['POSITION'])?>
  <br /><br />
  <?
    
  if (!is_file(ROOT.'/files/upload/slides/650x200/'.$list['ID'].'.jpg')) {
    
    ?><font color='#E65F6D'><?=lg('Для активации показа подгрузите фото слайда')?></font><br /><br /><?
    
  }
  
  ?><a href='/admin/site/modules/?mod=slides&upload=<?=$list['ID']?>' class='button'><?=icons('upload', 15, 'fa-fw')?> <?=lg('Подгрузить слайд')?></a> <?
    
  if ($list['ACTIVE'] == 0){ 
    
    ?> <a href='/admin/site/modules/?mod=slides&act=on&id=<?=$list['ID']?>' class='button'><?=icons('plus', 15, 'fa-fw')?> <?=lg('Включить')?></a> <?
    
  }else{
    
    ?> <a href='/admin/site/modules/?mod=slides&act=off&id=<?=$list['ID']?>' class='button'><?=icons('times', 15, 'fa-fw')?> <?=lg('Отключить')?></a> <?
      
  }
  
  ?>
  <a href='/admin/site/modules/?mod=slides&edit=<?=$list['ID']?>' class='button3'><?=icons('pencil', 15, 'fa-fw')?> <?=lg('Редактировать')?></a> 
  <a href='/admin/site/modules/?mod=slides&delete=<?=$list['ID']?>' class='button2'><?=icons('trash', 15, 'fa-fw')?> <?=lg('Удалить')?></a> 
  </div>
  <?
  
}
  
get_page('/panel/?path=site&section=modules&mod=slides&', $spage, $page, 'list-menu');

?></div>