<?php
$goods = db::get_string("SELECT * FROM `SHOP_GOODS` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);
$subsc = db::get_string("SELECT `ID`,`NAME`,`SECTION_ID` FROM `SHOP_SUB_SECTION` WHERE `ID` = ? LIMIT 1", [$goods['SUB_SECTION_ID']]);
$sc = db::get_string("SELECT `ID`,`NAME` FROM `SHOP_SECTION` WHERE `ID` = ? LIMIT 1", [$subsc['SECTION_ID']]);
html::title(lg('Товар магазина - %s', tabs($goods['NAME'])));
acms_header();

if (!isset($goods['ID'])) {
  
  error('Неверная директива');
  redirect('/m/shop/');

}

if (config('PRIVATE_SHOP') == 0){
  
  error('Модуль отключен администратором');
  redirect('/');
  
}

/*
---------
Просмотры
---------
*/

if (user('ID') > 0){
  
  if (db::get_column("SELECT COUNT(`ID`) FROM `EYE` WHERE `USER_ID` = ? AND `OBJECT_ID` = ? AND `TYPE` = ? LIMIT 1", [user('ID'), $goods['ID'], 'shop']) == 0){
    
    db::get_add("INSERT INTO `EYE` (`USER_ID`, `TIME`, `OBJECT_ID`, `TYPE`) VALUES (?, ?, ?, ?)", [user('ID'), TM, $goods['ID'], 'shop']);
  
  }else{
    
    db::get_set("UPDATE `EYE` SET `TIME` = ? WHERE `OBJECT_ID` = ? AND `TYPE` = ? LIMIT 1", [TM, $goods['ID'], 'shop']);
    
  }

}

if (access('shop', null) == true){
  
  require_once (ROOT.'/modules/shop/plugins/ban.php');
  
}

if (user('ID') > 0){

  require_once (ROOT.'/modules/shop/plugins/rating_add.php');
  
}

if (access('shop', null) == true || $goods['USER_ID'] == user('ID')){
  
  require_once (ROOT.'/modules/shop/plugins/delete.php');
  
}

if (user('ID') > 0){
  
  if (access('shop', null) == true || $goods['USER_ID'] == user('ID')){
    
    ?><div class='list'><?
      
  }
    
  if (access('shop', null) == true || $goods['USER_ID'] == user('ID')){
    
    ?>
    <a href='/m/shop/edit_goods/?id=<?=$goods['ID']?>&get=edit' class='btn'><?=icons('pencil', 15, 'fa-fw')?> <?=lg('Редактировать')?></a>
    <a href='/m/shop/show/?id=<?=$goods['ID']?>&get=delete&<?=TOKEN_URL?>' class='btn'><?=icons('trash', 15, 'fa-fw')?> <?=lg('Удалить')?></a>
    <?
      
    if (access('shop', null) == true){
      
      if ($goods['BAN'] == 0){
        
        ?>
        <a href='/m/shop/show/?id=<?=$goods['ID']?>&get=ban&<?=TOKEN_URL?>' class='btn'><?=icons('ban', 15, 'fa-fw')?> <?=lg('Заблокировать')?></a>
        <?
          
      }else{
        
        ?>
        <a href='/m/shop/show/?id=<?=$goods['ID']?>&get=del_ban&<?=TOKEN_URL?>' class='btn'><?=icons('ban', 15, 'fa-fw')?> <?=lg('Разблокировать')?></a>
        <?
        
      }
      
    }
  
  }
  
  if (access('shop', null) == true || $goods['USER_ID'] == user('ID')){
    
    ?></div><?
      
  }
  
}

if ($goods['BAN'] == 1){
  
  html::empty(lg('Товар заблокирован администрацией сайта<br /><b>Причина: %s</b>', tabs($goods['BAN_COMMENTS'])), 'ban');
  
  back('/m/shop/');
  acms_footer();
  
}

if ($goods['MODERATION'] == 0){
  
  html::empty('Товар на модерации', 'gears');
  
}elseif ($goods['MODERATION'] == 2){
  
  html::empty('Товар не прошел проверку...<br />Перепроверьте данные и попробуйте добавить товар снова', 'times');
  
  back('/m/shop/');
  acms_footer();
  
}

?><div class='list-body'><?

$html_screen = null;
$html_screen2 = null;
$hs = 0;
$data4 = db::get_string_all("SELECT * FROM `ATTACHMENTS` WHERE `ID_POST` = ? AND `TYPE_POST` = ?", [$goods['ID'], 'shop_screen']);
while ($list4 = $data4->fetch()) {
  
  $hs++;
  
  if ($hs == 1) {
    
    $html_screen .= '<a ajax="no" href="/files/upload/shop/screen/'.$list4['ID'].'.jpg"><img src="/files/upload/shop/screen/'.$list4['ID'].'.jpg" style="max-width: 250px"></a><br />';
    
  }
  
  if ($hs > 1) {
    
    $html_screen2 .= '<a ajax="no" href="/files/upload/shop/screen/'.$list4['ID'].'.jpg"><img src="/files/upload/shop/screen/240x240/'.$list4['ID'].'.jpg" style="max-width: 80px; margin-right: 5px; margin-bottom: 7px"></a>';
    
  }

}

if (str($html_screen) > 0) {
  
  ?>
  <div class='list-menu' style='background-color: #313A3E; padding: 12px; text-align: center; margin-top: -1px; overflow-x: hidden; overflow-y: auto;'>
  <?=$html_screen?>
  <?
    
  if (str($html_screen2) > 0) {  
    
    ?>
    <br />
    <div class='files-main-list'>
    <?=$html_screen2?>
    </div>
    <?
      
  }
  
  ?></div><?
  
}

?>  
<div class='list-menu'>
<center>
<font size='+2' color='black'><b><?=tabs($goods['NAME'])?></b></font><br />
<font color='#707F85'><?=lg('Посл. обновление товара')?>: <?=ftime($goods['EDIT_TIME'])?></font>
</center>
<br />  
<font size='+1'><b><?=tabs('Описание')?></b></font><br /> 
<?=text($goods['MESSAGE'])?>
</div>
  
<?php
$sum = $goods['SUM']; 
$sum2 = null;
$sum3 = null;
$sum4 = null;
  
if (intval($goods['SUM']) > 0 && config('SHOP_DISCOUNT') == 1 && $goods['DISCOUNT_TIME'] > TM && $goods['DISCOUNT'] > 0) {
  
  $sum = $goods['SUM'] / 100;
  $sum = $sum * $goods['DISCOUNT'];
  $sum = $goods['SUM'] - $sum;
  $sum2 = ' <font color="#95A0A6"><s>'.$goods['SUM'].'</s></font> ';
  $sum3 = ' <span style="background-color: #FF5A72; padding: 2px 0.7em; border-radius: 7px; font-size: 11px; color: white; display: inline-block; position: relative; bottom: 2px; line-height: 15px">'.lg('Скидка').' -'.$goods['DISCOUNT'].'%</span> ';
  $sum4 = '<font color="#546E7A">'.lg('Скидка действует до').': '.ftime($goods['DISCOUNT_TIME']).'</font>';
  
} 
  
if (config('SHOP_MONEY_TYPE') == 1) {
  
  $sum = money($sum, 2);
  
}elseif (config('SHOP_MONEY_TYPE') == 2) {
  
  $sum = $sum.' '.lg('баллов');
  
}elseif (config('SHOP_MONEY_TYPE') == 3) {
  
  $sum = $sum.' '.lg('единиц рейтинга');
  
}

?>
  
<div class='list-menu'>
<font size='+1' color='black'><b><?=lg('Цена')?>: <?=(intval($goods['SUM']) == 0 ? '<span class="info green">'.lg('Бесплатно').'</span>' : $sum2.$sum.$sum3)?></b></font><br />
<?=$sum4?>
</div>
  
<div class='list-menu'>
<div class='user-info-mini'>
<div class='user-avatar-mini'>
<?=user::avatar($goods['USER_ID'], 45)?> 
</div>
<div class='user-login-mini' style='top: 0px; left: 55px'>
<?=user::login($goods['USER_ID'], 0, 1)?><br />
<div class='time'><?=ftime($goods['TIME'])?></div>
<a href='/m/shop/users/?id=<?=$goods['USER_ID']?>'><u><?=lg('Все товары продавца')?></u></a>
</div>
<br /><br /> 
<?=icons('shopping-basket', 15, 'fa-fw')?> <b><?=lg('Раздел магазина')?>:</b> <a href='/m/shop/sc/?id=<?=$sc['ID']?>'><?=lg(tabs($sc['NAME']))?></a> / <a href='/m/shop/sc/?id_sub=<?=$subsc['ID']?>'><?=lg(tabs($subsc['NAME']))?></a><br />
<?php $action = '/m/shop/show/?id='.$goods['ID']; ?>
<?=icons('eye', 15, 'fa-fw')?> <b><?=lg('Просмотрели')?>:</b> <a href='/m/eye/?id=<?=$goods['ID']?>&url=<?=base64_encode($action)?>&type=shop&<?=TOKEN_URL?>'><?=db::get_column("SELECT COUNT(`ID`) FROM `EYE` WHERE `OBJECT_ID` = ? AND `TYPE` = ? LIMIT 1", [$goods['ID'], 'shop'])?> <?=lg('чел.')?></a><br />
<?=icons('shopping-basket', 15, 'fa-fw')?> <b><?=lg('Добавили в корзину')?>:</b> <a href='/m/shop/basket_list/?id=<?=$goods['ID']?>'><?=db::get_column("SELECT COUNT(`ID`) FROM `SHOP_BASKET` WHERE `GOODS_ID` = ? LIMIT 1", [$goods['ID']])?> <?=lg('чел.')?></a><br /> 
<?=icons('money', 15, 'fa-fw')?> <b><?=lg('Купили')?>:</b> <a href='/m/shop/purchase_list/?id=<?=$goods['ID']?>'><?=db::get_column("SELECT COUNT(`ID`) FROM `SHOP_PURCHASE` WHERE `GOODS_ID` = ? LIMIT 1", [$goods['ID']])?> <?=lg('чел.')?></a><br />
<?=icons('clock-o', 15, 'fa-fw')?> <b><?=lg('Добавлен')?>:</b> <?=ftime($goods['TIME'])?><br />
<?=icons('bar-chart', 15, 'fa-fw')?> <b><?=lg('Рейтинг')?>:</b> <?=$goods['RATING']?>
</div>
</div>
  
<div class='list-menu'>
<?php 
require_once (ROOT.'/modules/shop/plugins/rating.php');

?>
<br /><br /><center>
<div id='update'>
<?php if (intval($goods['SUM']) > 0) { ?>
<font size='+1'><?=($goods['QUA'] > 0 ? lg('Осталось копий').': '.$goods['QUA'] : '<font color="red">'.lg('Все копии проданы').'</font>')?></font><br /><br />
<?php } ?>
<?
  
if ($goods['QUA'] > 0 && intval($goods['SUM']) > 0 && db::get_column("SELECT COUNT(`ID`) FROM `SHOP_PURCHASE` WHERE `USER_ID` = ? AND `GOODS_ID` = ? LIMIT 1", [user('ID'), $goods['ID']]) == 0) {
  
  ?>
  <a href="/m/shop/purchase/?id=<?=$goods['ID']?>" class='btn'><?=icons('plus', 13, 'fa-fw')?> <?=lg('Купить')?></a>
  <?
  
}elseif ($goods['TYPE'] == 'cf' && intval($goods['SUM']) == 0 || $goods['TYPE'] == 'cf' && db::get_column("SELECT COUNT(`ID`) FROM `SHOP_PURCHASE` WHERE `USER_ID` = ? AND `GOODS_ID` = ? LIMIT 1", [user('ID'), $goods['ID']]) > 0) {
  
  ?>
  <a href="/m/shop/download/?id=<?=$goods['ID']?>" ajax="no" class='btn'><?=icons('download', 13, 'fa-fw')?> <?=lg('Скачать товар')?></a>
  <?
  
}

if (user('ID') > 0) {
  
  if (get('basket') == 'ok' && db::get_column("SELECT COUNT(`ID`) FROM `SHOP_BASKET` WHERE `USER_ID` = ? AND `GOODS_ID` = ? LIMIT 1", [user('ID'), $goods['ID']]) == 0) {
    
    get_check_valid();
    db::get_add("INSERT INTO `SHOP_BASKET` (`USER_ID`, `TIME`, `GOODS_ID`) VALUES (?, ?, ?)", [user('ID'), TM, $goods['ID']]);
    
    $message = lg('Ваш товар добавили в').' [url=/m/shop/basket_list/?id='.$goods['ID'].']'.lg('корзину').'[/url].';
    messages::get(intval(config('SYSTEM')), $goods['USER_ID'], $message);
  
  }
  
  if (get('basket') == 'no' && db::get_column("SELECT COUNT(`ID`) FROM `SHOP_BASKET` WHERE `USER_ID` = ? AND `GOODS_ID` = ? LIMIT 1", [user('ID'), $goods['ID']]) > 0) {
    
    get_check_valid();
    db::get_set("DELETE FROM `SHOP_BASKET` WHERE `USER_ID` = ? AND `GOODS_ID` = ? LIMIT 1", [user('ID'), $goods['ID']]);
  
  }
  
  if (db::get_column("SELECT COUNT(`ID`) FROM `SHOP_BASKET` WHERE `USER_ID` = ? AND `GOODS_ID` = ? LIMIT 1", [user('ID'), $goods['ID']]) > 0) {
    
    ?>
    <span onclick="request('/m/shop/show/?id=<?=$goods['ID']?>&basket=no&<?=TOKEN_URL?>', '#update')" class='btn-o'><?=icons('shopping-basket', 13, 'fa-fw')?> <?=lg('Удалить из корзины')?></span>
    <?
    
  }else{
    
    ?>
    <span onclick="request('/m/shop/show/?id=<?=$goods['ID']?>&basket=ok&<?=TOKEN_URL?>', '#update')" class='btn-o'><?=icons('shopping-basket', 13, 'fa-fw')?> <?=lg('Добавить в корзину')?></span>
    <?
    
  }
  
  if (db::get_column("SELECT COUNT(`ID`) FROM `SHOP_PURCHASE` WHERE `USER_ID` = ? AND `GOODS_ID` = ? AND `ACT` = '1' LIMIT 1", [user('ID'), $goods['ID']]) > 0 && db::get_column("SELECT COUNT(`ID`) FROM `SHOP_RATING` WHERE `USER_ID` = ? AND `GOODS_ID` = ? LIMIT 1", [user('ID'), $goods['ID']]) == 0) {
    
    ?>
    <a href="/m/shop/show/?id=<?=$goods['ID']?>&get=rating&<?=TOKEN_URL?>" class='btn-o'><?=icons('bullhorn', 13, 'fa-fw')?> <?=lg('Оставить отзыв')?></a>
    <?
    
  }
  
}

?>
</div>
</center>
</div>
  
</div>
  
<div class='list'>
<b><?=lg('Вопросы по товару')?></b> <span class='count'><?=db::get_column("SELECT COUNT(`ID`) FROM `COMMENTS` WHERE `OBJECT_ID` = ? AND `OBJECT_TYPE` = ? LIMIT 1", [$goods['ID'], 'shop_comments'])?></span>
</div>
  
<?  
if (user('ID') == 0){
  
  $comments_set = 'Извините, для вас комментирование недоступно';
  
}

comments($action, 'shop_comments', 1, 'message', $goods['USER_ID'], $goods['ID']);

$column = db::get_column("SELECT COUNT(*) FROM `EYE` WHERE `TYPE` = ? AND `OBJECT_ID` != ?", ['shop', $goods['ID']]);

if ($column > 0){
  
  ?>
  <div class='list-body'>
  <div class='list-menu'>
  <b><?=lg('Сейчас также смотрят')?></b>
  </div>
  <?
  
  $data2 = db::get_string_all("SELECT * FROM `EYE` WHERE `TYPE` = ? AND `OBJECT_ID` != ? GROUP BY `OBJECT_ID` ORDER BY `TIME` DESC LIMIT 3", ['shop', $goods['ID']]);
  while ($list2 = $data2->fetch()) {
    
    $list = db::get_string("SELECT * FROM `SHOP_GOODS` WHERE `ID` = ? LIMIT 1", [$list2['OBJECT_ID']]);
    
    require (ROOT.'/modules/shop/plugins/list.php');
    echo $shop_list;
    
  }
  
  ?></div><?
  
}

back('/m/shop/sc/', 'Ко всем товарам');
acms_footer();