<?php
html::title('Разделы магазина');
acms_header(); 

if (config('PRIVATE_SHOP') == 0){
  
  error('Модуль отключен администратором');
  redirect('/');
  
}
  
?> 
<div class='menu-nav-content'>
    
<a class='menu-nav h' href='/m/shop/sc/'>
<?=lg('Разделы')?>
</a>
  
<a class='menu-nav' href='/m/shop/'>
<?=lg('Новинки')?>
</a>
  
<a class='menu-nav' href='/m/shop/discount/'>
<?=lg('Акции')?>
</a> 
  
<a class='menu-nav' href='/m/shop/top/'>
<?=lg('ТОП')?>
</a>
  
<?php if (config('SHOP_ACCESS') == 1 && user('ID') > 0 || config('SHOP_ACCESS') == 2 && access('shop', null) == true) { ?>  
<a class='menu-nav' href='/m/shop/users/?id=<?=user('ID')?>'>
<?=lg('Мои')?>
</a>
<?php } ?>  
  
</div>
<?
  
/*
----------------
Показ подраздела
----------------
*/ 
  
if (get('id_sub')){
  
  $scsub = db::get_string("SELECT * FROM `SHOP_SUB_SECTION` WHERE `ID` = ? LIMIT 1", [intval(get('id_sub'))]);
  $sc = db::get_string("SELECT * FROM `SHOP_SECTION` WHERE `ID` = ? LIMIT 1", [$scsub['SECTION_ID']]);
  
  if (isset($scsub['ID']) && isset($sc['ID'])){
    
    if (access('shop', null) == true){
      
      /*
      -------------------
      Удаление подраздела
      -------------------
      */
      
      if (get('get') == 'delete_sub_ok'){
        
        get_check_valid();
        
        if (db::get_column("SELECT COUNT(*) FROM `SHOP_SUB_SECTION` WHERE `SECTION_ID` = ? AND `SUB_SECTION_ID` = ? LIMIT 1", [$sc['ID'], $scsub['ID']]) > 0){
          
          error('Подраздел не может быть удален, пока в нем есть хотябы один внутренний подраздел');
          redirect('/m/shop/sc/?id_sub='.$scsub['ID']);
        
        }
        
        $data = db::get_string_all("SELECT * FROM `SHOP_GOODS` WHERE `SUB_SECTION_ID` = ?", [$scsub['ID']]);
        while ($list = $data->fetch()){
          
          $data2 = db::get_string_all("SELECT * FROM `COMMENTS` WHERE `OBJECT_ID` = ? AND `OBJECT_TYPE` = ?", [$list['ID'], 'shop_comments']);
          while ($list2 = $data2->fetch()) {
            
            db::get_set("DELETE FROM `LIKES` WHERE `OBJECT_ID` = ? AND `OBJECT_TYPE` = ?", [$list2['ID'], 'shop_comments']);
            db::get_set("DELETE FROM `ATTACHMENTS` WHERE `ID_POST` = ? AND `TYPE_POST` = ?", [$list2['ID'], 'shop_comments']);
            db::get_set("DELETE FROM `COMMENTS` WHERE `ID` = ? LIMIT 1", [$list2['ID']]);
          
          }
          
          db::get_set("DELETE FROM `SHOP_PURCHASE` WHERE `GOODS_ID` = ?", [$list['ID']]);
          db::get_set("DELETE FROM `SHOP_BASKET` WHERE `GOODS_ID` = ?", [$list['ID']]);
          db::get_set("DELETE FROM `SHOP_RATING` WHERE `GOODS_ID` = ?", [$list['ID']]);
          
          $data3 = db::get_string_all("SELECT * FROM `ATTACHMENTS` WHERE `ID_POST` = ? AND `TYPE_POST` = ?", [$list['ID'], 'shop_screen']);
          while ($list3 = $data3->fetch()) {
            
            @unlink(ROOT.'/files/upload/shop/screen/'.$list3['ID'].'.jpg');
            @unlink(ROOT.'/files/upload/shop/screen/240x240/'.$list3['ID'].'.jpg');
          
          }
          
          db::get_set("DELETE FROM `ATTACHMENTS` WHERE `ID_POST` = ? AND `TYPE_POST` = ?", [$list['ID'], 'shop_screen']);
          
          $data4 = db::get_string_all("SELECT * FROM `SHOP_FILE` WHERE `OBJECT_ID` = ?", [$list['ID']]);
          while ($list4 = $data4->fetch()) {
            
            @unlink(ROOT.'/files/upload/shop/files/'.$list4['ID'].'.'.$list4['EXT']);
          
          }
          
          db::get_set("DELETE FROM `SHOP_FILE` WHERE `OBJECT_ID` = ?", [$list['ID']]);

          db::get_set("DELETE FROM `EYE` WHERE `OBJECT_ID` = ? AND `TYPE` = ?", [$list['ID'], 'shop']);
          db::get_set("DELETE FROM `SHOP_GOODS` WHERE `ID` = ?", [$list['ID']]); 
        
        }
        
        db::get_set("DELETE FROM `SHOP_SUB_SECTION` WHERE `ID` = ?", [$scsub['ID']]);
        
        logs('Магазин - удаление подраздела', user('ID'));
        
        success('Удаление прошло успешно');
        redirect('/m/shop/sc/?id='.$scsub['SECTION_ID']);
      
      }
      
      if (get('get') == 'delete_sub'){
        
        get_check_valid();
        
        ?>
        <div class='list'>
        <?=lg('Вы действительно хотите удалить подраздел')?> <b><?=tabs($scsub['NAME'])?></b>?<br /><br />
        <a href='/m/shop/sc/?id_sub=<?=$scsub['ID']?>&get=delete_sub_ok&<?=TOKEN_URL?>' class='button'><?=icons('trash', 17, 'fa-fw')?> <?=lg('Удалить')?></a>
        <a href='/m/shop/sc/?id_sub=<?=$scsub['ID']?>' class='button-o'><?=lg('Отмена')?></a>
        </div>
        <?
  
      }
      
      /*
      -----------------------
      Редактировать подраздел
      -----------------------
      */
      
      if (get('get') == 'edit_sub'){
        
        get_check_valid();
        
        if (post('ok_shop_edit_sc_sub')){
          
          valid::create(array(
            
            'SC_SUB_NAME' => ['name', 'text', [3, 120], 'Название', 0],
            'SC_SUB_MESSAGE' => ['message', 'text', [0, 200], 'Описание', 0]
          
          ));
          
          if ($scsub['NAME'] != SC_SUB_NAME && db::get_column("SELECT COUNT(*) FROM `SHOP_SUB_SECTION` WHERE `NAME` = ? AND `SECTION_ID` = ? AND `SUB_SECTION_ID` = ? LIMIT 1", [SC_SUB_NAME, $scsub['SECTION_ID'], $scsub['SUB_SECTION_ID']]) > 0){
            
            error('Подраздел с таким названием уже существует');
            redirect('/m/shop/sc/?id_sub='.$scsub['ID'].'&get=edit_sub&'.TOKEN_URL);
          
          }
          
          if (ERROR_LOG == 1){
            
            redirect('/m/shop/sc/?id_sub='.$scsub['ID'].'&get=edit_sub&'.TOKEN_URL);
          
          }
          
          db::get_set("UPDATE `SHOP_SUB_SECTION` SET `NAME` = ?, `MESSAGE` = ? WHERE `ID` = ? LIMIT 1", [SC_SUB_NAME, SC_SUB_MESSAGE, $scsub['ID']]);
          
          logs('Магазин - редактирование [url=/m/shop/sc/?id_sub='.$scsub['ID'].']подраздела[/url]', user('ID'));
          
          success('Изменения успешно приняты');          
          redirect('/m/shop/sc/?id_sub='.$scsub['ID']);
        
        }
        
        ?>
        <div class='list'>
        <form method='post' class='ajax-form' action='/m/shop/sc/?id_sub=<?=$scsub['ID']?>&get=edit_sub&<?=TOKEN_URL?>'>
        <?          
        html::input('name', 'Название', null, null, tabs($scsub['NAME']), 'form-control-100', 'text', null, 'list');
        html::textarea(tabs($scsub['MESSAGE']), 'message', 'Введите описание (не обязательно)', null, 'form-control-textarea', 9, 0); 
        ?><br /><br /><?
        html::button('button ajax-button', 'ok_shop_edit_sc_sub', 'save', 'Сохранить');        
        ?>
        <a class='button-o' href='/m/shop/sc/?id_sub=<?=$scsub['ID']?>'><?=lg('Отмена')?></a>
        </form>
        </div>
        <?
        
        back('/m/shop/sc/?id_sub='.$scsub['ID']);
        acms_footer();
        
      }
      
    }
    
    require_once (ROOT.'/modules/shop/plugins/search_form.php');
    
    $array = array();
    $data = db::get_string_all("SELECT * FROM `SHOP_SUB_SECTION` WHERE `SUB_SECTION_ID` = ? ORDER BY `ID` DESC", [$scsub['ID']]);
    while ($list = $data->fetch()) {
      
      $array[] = array('dir' => 1, 'list' => $list);
    
    }
    
    $data = db::get_string_all("SELECT * FROM `SHOP_GOODS` WHERE `SUB_SECTION_ID` = ? AND `BAN` = '0' AND `MODERATION` = '1' ORDER BY `TIME` DESC", [$scsub['ID']]);
    while ($list = $data->fetch()) {
      
      $array[] = array('dir' => 0, 'list' => $list);
    
    }
    
    $column = sizeof($array);
    $spage = spage($column, PAGE_SETTINGS);
    $page = page($spage);
    $limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;
      
    if (user('ID') > 0){
      
      if (config('SHOP_ACCESS') == 1 && user('ID') > 0 || config('SHOP_ACCESS') == 2 && access('shop', null) == true || access('shop', null) == true){
        
        ?><div class='list'><?
          
      }
      
      if (config('SHOP_ACCESS') == 1 && user('ID') > 0 || config('SHOP_ACCESS') == 2 && access('shop', null) == true){
        
        ?><a href='/m/shop/add_goods/?id=<?=$scsub['ID']?>&<?=TOKEN_URL?>' class='btn'><?=icons('plus', 15)?> <?=lg('Добавить товар')?></a><?
          
      }
        
      if (access('shop', null) == true){
        
        ?>
        <a href='/m/shop/sc/?id=<?=$scsub['SECTION_ID']?>&id_sb=<?=$scsub['ID']?>&get=add_sub&<?=TOKEN_URL?>' class='btn'><?=icons('plus', 15)?> <?=lg('Добавить подраздел')?></a>
        <a href='/m/shop/sc/?id_sub=<?=$scsub['ID']?>&get=edit_sub&<?=TOKEN_URL?>' class='btn'><?=icons('pencil', 15)?> <?=lg('Редактировать')?></a>
        <a href='/m/shop/sc/?id_sub=<?=$scsub['ID']?>&get=delete_sub&<?=TOKEN_URL?>' class='btn'><?=icons('trash', 15)?> <?=lg('Удалить')?></a>  
        <?
          
      }
      
      ?></div><?
        
    }
    
    ?>
    <div class='list'>
    <?=lg('Подраздел')?> "<b><?=lg(tabs($scsub['NAME']))?></b>"
    </div>
    <?
    
    if ($column == 0){ 
      
      html::empty('Пока пусто');
    
    }else{
      
      ?><div class='list-body'><?
      
    }
    
    for ($i = $limit; $i < $column && $i < PAGE_SETTINGS * $page; $i++){
      
      $list = $array[$i]['list'];
      
      if ($array[$i]['dir'] == 1) {
        
        ?>
        <a href='/m/shop/sc/?id_sub=<?=$list['ID']?>'>
        <div class='list-menu hover'>
        <?=icons('angle-double-right', 15, 'fa-fw')?> <b><?=tabs($list['NAME'])?></b><br />
        <font color='#7B8285'><small><?=text($list['MESSAGE'])?></small></font>
        </div>
        </a>
        <?
      
      }else{
        
        require (ROOT.'/modules/shop/plugins/list.php');
        echo $shop_list;
        
      }
      
    }
    
    if ($column > 0){ 
      
      ?></div><?
      
    }
    
    get_page('/m/shop/sc/?id_sub='.$scsub['ID'].'&', $spage, $page, 'list'); 
    
    if ($scsub['SUB_SECTION_ID'] > 0) {
      
      back('/m/shop/sc/?id_sub='.$scsub['SUB_SECTION_ID']);
      
    }else{
      
      back('/m/shop/sc/?id='.$scsub['SECTION_ID']);
      
    }
    
    acms_footer();
    
  }
  
}
  
/*
-------------
Показ раздела
-------------
*/
  
if (get('id')){
  
  $id = intval(get('id'));
  $id_sub = intval(get('id_sb'));
  $sc = db::get_string("SELECT `NAME`,`MESSAGE` FROM `SHOP_SECTION` WHERE `ID` = ? LIMIT 1", [$id]);
  
  if (isset($sc['NAME'])){
    
    if (access('shop', null) == true){
      
      /*
      ------------------
      Добавить подраздел
      ------------------
      */
      
      if (get('get') == 'add_sub'){
        
        get_check_valid();
        
        if (post('ok_shop_add_sc_sub')){
          
          valid::create(array(
            
            'SC_SUB_NAME' => ['name', 'text', [3, 120], 'Название', 0],
            'SC_SUB_MESSAGE' => ['message', 'text', [0, 200], 'Описание', 0]
          
          ));
          
          if (db::get_column("SELECT COUNT(*) FROM `SHOP_SUB_SECTION` WHERE `NAME` = ? AND `SECTION_ID` = ? AND `SUB_SECTION_ID` = ? LIMIT 1", [SC_SUB_NAME, $id, $id_sub]) > 0){
            
            error('Подраздел с таким названием уже существует');
            redirect('/m/shop/sc/?id='.$id.'&get=add_sub&id_sb='.$id_sub.'&'.TOKEN_URL);
          
          }
          
          if (ERROR_LOG == 1){
            
            redirect('/m/shop/sc/?id='.$id.'&get=add_sub&id_sb='.$id_sub.'&'.TOKEN_URL);
          
          }
          
          $ID = db::get_add("INSERT INTO `SHOP_SUB_SECTION` (`NAME`, `MESSAGE`, `SECTION_ID`, `SUB_SECTION_ID`) VALUES (?, ?, ?, ?)", [SC_SUB_NAME, SC_SUB_MESSAGE, $id, $id_sub]);
          
          logs('Магазин - добавление [url=/m/shop/sc/?id_sub='.$ID.']подраздела[/url]', user('ID'));
          
          success('Подраздел успешно создан');
          
          if ($id_sub == 0) {
            
            redirect('/m/shop/sc/?id='.$id);
            
          }else{
            
            redirect('/m/shop/sc/?id_sub='.$id_sub);
            
          }
        
        }
        
        ?>
        <div class='list'>
        <form method='post' class='ajax-form' action='/m/shop/sc/?id=<?=$id?>&id_sb=<?=$id_sub?>&get=add_sub&<?=TOKEN_URL?>'>
        <?          
        html::input('name', 'Название', null, null, null, 'form-control-100', 'text', null, 'list');
        html::textarea(null, 'message', 'Введите описание (не обязательно)', null, 'form-control-textarea', 9, 0);
        ?><br /><br /><?
        html::button('button ajax-button', 'ok_shop_add_sc_sub', 'plus', 'Добавить');        
        ?>
        <a class='button-o' href='/m/shop/sc/?id=<?=$id?>'><?=lg('Отмена')?></a>
        </form>
        </div>
        <?
        
        back('/m/shop/sc/?id='.$id);
        acms_footer();
        
      }
      
      /*
      --------------------
      Редактировать раздел
      --------------------
      */
      
      if (get('get') == 'edit'){
        
        get_check_valid();
        
        if (post('ok_shop_edit_sc')){
          
          valid::create(array(
            
            'SC_NAME' => ['name', 'text', [3, 120], 'Название', 0],
            'SC_MESSAGE' => ['message', 'text', [0, 200], 'Описание', 0]
          
          ));
          
          if (SC_NAME != $sc['NAME'] && db::get_column("SELECT COUNT(*) FROM `SHOP_SECTION` WHERE `NAME` = ? LIMIT 1", [SC_NAME]) == 1){
            
            error('Раздел с таким названием уже существует');
            redirect('/m/shop/sc/?id='.$id.'&get=edit&'.TOKEN_URL);
          
          }
          
          if (ERROR_LOG == 1){
            
            redirect('/m/shop/sc/?id='.$id.'&get=edit&'.TOKEN_URL);
          
          }
          
          db::get_set("UPDATE `SHOP_SECTION` SET `NAME` = ?, `MESSAGE` = ? WHERE `ID` = ? LIMIT 1", [SC_NAME, SC_MESSAGE, $id]);          
          
          logs('Магазин - редактирование [url=/m/shop/sc/?id='.$id.']раздела[/url]', user('ID'));
          
          success('Изменения успешно приняты');
          redirect('/m/shop/sc/?id='.$id);
        
        }
        
        ?>
        <div class='list'>
        <form method='post' class='ajax-form' action='/m/shop/sc/?id=<?=$id?>&get=edit&<?=TOKEN_URL?>'>
        <?          
        html::input('name', 'Название', null, null, tabs($sc['NAME']), 'form-control-100', 'text', null, 'list');
        html::textarea(tabs($sc['MESSAGE']), 'message', 'Введите описание (не обязательно)', null, 'form-control-textarea', 9, 0);  
        ?><br /><br /><?
        html::button('button ajax-button', 'ok_shop_edit_sc', 'save', 'Сохранить');        
        ?>
        <a class='button-o' href='/m/shop/sc/?id=<?=$id?>'><?=lg('Отмена')?></a>
        </form>
        </div>
        <?
        
        back('/m/shop/sc/?id='.$id);
        acms_footer();
        
      }
      
      /*
      ----------------
      Удаление раздела
      ----------------
      */
      
      if (get('get') == 'delete_ok'){
        
        get_check_valid();
        
        $data = db::get_string_all("SELECT * FROM `SHOP_SUB_SECTION` WHERE `SECTION_ID` = ?", [$id]);
        while ($list = $data->fetch()){
          
          $data2 = db::get_string_all("SELECT * FROM `SHOP_GOODS` WHERE `SUB_SECTION_ID` = ?", [$list['ID']]);
          while ($list2 = $data2->fetch()){
            
            $data3 = db::get_string_all("SELECT * FROM `COMMENTS` WHERE `OBJECT_ID` = ? AND `OBJECT_TYPE` = ?", [$list2['ID'], 'shop_comments']);
            while ($list3 = $data3->fetch()) {
              
              db::get_set("DELETE FROM `LIKES` WHERE `OBJECT_ID` = ? AND `OBJECT_TYPE` = ?", [$list3['ID'], 'shop_comments']);
              db::get_set("DELETE FROM `ATTACHMENTS` WHERE `ID_POST` = ? AND `TYPE_POST` = ?", [$list3['ID'], 'shop_comments']);
              db::get_set("DELETE FROM `COMMENTS` WHERE `ID` = ? LIMIT 1", [$list3['ID']]);
            
            }

            db::get_set("DELETE FROM `EYE` WHERE `OBJECT_ID` = ? AND `TYPE` = ?", [$list2['ID'], 'shop']);
            db::get_set("DELETE FROM `SHOP_PURCHASE` WHERE `GOODS_ID` = ?", [$list2['ID']]);
            db::get_set("DELETE FROM `SHOP_BASKET` WHERE `GOODS_ID` = ?", [$list2['ID']]);
            db::get_set("DELETE FROM `SHOP_RATING` WHERE `GOODS_ID` = ?", [$list2['ID']]);
            
            $data4 = db::get_string_all("SELECT * FROM `ATTACHMENTS` WHERE `ID_POST` = ? AND `TYPE_POST` = ?", [$list2['ID'], 'shop_screen']);
            while ($list4 = $data4->fetch()) {
              
              @unlink(ROOT.'/files/upload/shop/screen/'.$list4['ID'].'.jpg');
              @unlink(ROOT.'/files/upload/shop/screen/240x240/'.$list4['ID'].'.jpg');
            
            }
            
            db::get_set("DELETE FROM `ATTACHMENTS` WHERE `ID_POST` = ? AND `TYPE_POST` = ?", [$list2['ID'], 'shop_screen']);
            
            $data5 = db::get_string_all("SELECT * FROM `SHOP_FILE` WHERE `OBJECT_ID` = ?", [$list2['ID']]);
            while ($list5 = $data5->fetch()) {
              
              @unlink(ROOT.'/files/upload/shop/files/'.$list5['ID'].'.'.$list5['EXT']);
            
            }
            
            db::get_set("DELETE FROM `SHOP_FILE` WHERE `OBJECT_ID` = ?", [$list2['ID']]);            
            db::get_set("DELETE FROM `SHOP_GOODS` WHERE `ID` = ?", [$list2['ID']]); 
          
          }
          
        }
        
        db::get_set("DELETE FROM `SHOP_SUB_SECTION` WHERE `SECTION_ID` = ?", [$id]);
        db::get_set("DELETE FROM `SHOP_SECTION` WHERE `ID` = ? LIMIT 1", [$id]);
        
        logs('Магазин - удаление раздела', user('ID'));
        
        success('Удаление прошло успешно');
        redirect('/m/shop/sc/');
      
      }
      
      if (get('get') == 'delete'){
        
        get_check_valid();
        
        ?>
        <div class='list'>
        <?=lg('Вы действительно хотите удалить раздел')?> <b><?=tabs($sc['NAME'])?></b>?<br /><br />
        <a href='/m/shop/sc/?id=<?=$id?>&get=delete_ok&<?=TOKEN_URL?>' class='button'><?=icons('trash', 17, 'fa-fw')?> <?=lg('Удалить')?></a>
        <a href='/m/shop/sc/?id=<?=$id?>' class='button-o'><?=lg('Отмена')?></a>
        </div>
        <?
  
      }
      
      require_once (ROOT.'/modules/shop/plugins/search_form.php');
      
      ?>
      <div class='list'>
      <a href='/m/shop/sc/?id=<?=$id?>&get=add_sub&<?=TOKEN_URL?>' class='btn'><?=icons('plus', 15)?> <?=lg('Добавить подраздел')?></a>
      <a href='/m/shop/sc/?id=<?=$id?>&get=edit&<?=TOKEN_URL?>' class='btn'><?=icons('pencil', 15)?> <?=lg('Редактировать')?></a>
      <a href='/m/shop/sc/?id=<?=$id?>&get=delete&<?=TOKEN_URL?>' class='btn'><?=icons('trash', 15)?> <?=lg('Удалить')?></a>  
      </div>
      <?
      
    }
    
    ?>
    <div class='list'>
    <?=lg('Подразделы')?> "<b><?=lg(tabs($sc['NAME']))?></b>"
    </div>
    <?
    
    $column = db::get_column("SELECT COUNT(*) FROM `SHOP_SUB_SECTION` WHERE `SECTION_ID` = ? AND `SUB_SECTION_ID` = ?", [$id, 0]);
    $spage = spage($column, PAGE_SETTINGS);
    $page = page($spage);
    $limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;
    
    if ($column == 0){ 
      
      html::empty('Пока пусто');
    
    }else{
      
      ?><div class='list-body'><?
      
    }

    $data = db::get_string_all("SELECT * FROM `SHOP_SUB_SECTION` WHERE `SECTION_ID` = ? AND `SUB_SECTION_ID` = ? ORDER BY `ID` DESC LIMIT ".$limit.", ".PAGE_SETTINGS, [$id, 0]);
    while ($list = $data->fetch()) {
      
      ?>
      <a href='/m/shop/sc/?id_sub=<?=$list['ID']?>'>
      <div class='list-menu hover'>
      <?=icons('angle-double-right', 15, 'fa-fw')?> <b><?=tabs($list['NAME'])?></b><br />
      <font color='#7B8285'><small><?=text($list['MESSAGE'])?></small></font>
      </div>
      </a>
      <?
    
    }
    
    if ($column > 0){ 
      
      ?></div><?
      
    }
    
    get_page('/m/shop/sc/?id='.$id.'&', $spage, $page, 'list'); 
    
    back('/m/shop/sc/');
    acms_footer();
    
  }
  
}
  
/*
---------------
Добавить раздел
---------------
*/
  
if (access('shop', null) == true && get('get') == 'add'){
  
  get_check_valid();
  
  if (post('ok_shop_sc')){
    
    valid::create(array(
      
      'SC_NAME' => ['name', 'text', [3, 120], 'Название', 0],
      'SC_MESSAGE' => ['message', 'text', [0, 200], 'Описание', 0]
    
    ));
    
    if (db::get_column("SELECT COUNT(*) FROM `SHOP_SECTION` WHERE `NAME` = ? LIMIT 1", [SC_NAME]) == 1){
      
      error('Раздел с таким названием уже существует');
      redirect('/m/shop/sc/?get=add&'.TOKEN_URL);
    
    }
    
    if (ERROR_LOG == 1){
      
      redirect('/m/shop/sc/?get=add&'.TOKEN_URL);
    
    }
    
    $ID = db::get_add("INSERT INTO `SHOP_SECTION` (`NAME`, `MESSAGE`) VALUES (?, ?)", [SC_NAME, SC_MESSAGE]);
    
    if (access('shop', null) == true){
      
      logs('Магазин - создание нового [url=/m/shop/sc/?id='.$ID.']раздела[/url]', user('ID'));
    
    }
    
    success('Раздел успешно добавлен');
    redirect('/m/shop/sc/');
    
  }
  
  ?>
  <div class='list'>
  <form method='post' class='ajax-form' action='/m/shop/sc/?get=add&<?=TOKEN_URL?>'>
  <?
  
  html::input('name', 'Название', null, null, null, 'form-control-100', 'text', null, 'list');
  html::textarea(null, 'message', 'Введите описание (не обязательно)', null, 'form-control-textarea', 9, 0);  
  ?><br /><br /><?
  html::button('button ajax-button', 'ok_shop_sc', 'plus', 'Добавить');
  
  ?>
  <a class='button-o' href='/m/shop/sc/'><?=lg('Отмена')?></a>
  </form>
  </div>
  <?
  
  back('/m/shop/sc/');
  acms_footer();
  
}
  
/*
---------------
Список разделов
---------------
*/ 

require_once (ROOT.'/modules/shop/plugins/search_form.php');
  
if (access('shop', null) == true){
  
  ?>
  <div class='list'>
  <a href='/m/shop/sc/?get=add&<?=TOKEN_URL?>' class='btn'><?=icons('plus', 15, 'fa-fw')?> <?=lg('Добавить раздел')?></a>
  </div>
  <?
  
}

$column = db::get_column("SELECT COUNT(*) FROM `SHOP_SECTION`");
$spage = spage($column, PAGE_SETTINGS);
$page = page($spage);
$limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;

if ($column == 0){ 
  
  html::empty('Пока нет разделов');
  
}else{
  
  ?><div class='list-body'><?
  
}

$data = db::get_string_all("SELECT * FROM `SHOP_SECTION` ORDER BY `ID` DESC LIMIT ".$limit.", ".PAGE_SETTINGS);
while ($list = $data->fetch()) {
  
  ?>
  <a href='/m/shop/sc/?id=<?=$list['ID']?>'>
  <div class='list-menu hover'>
  <?=icons('shopping-basket', 18, 'fa-fw')?> <b><?=tabs($list['NAME'])?></b><br />
  <font color='#7B8285'><small><?=text($list['MESSAGE'])?></small></font>
  </div>
  </a>
  <?
  
}

if ($column > 0){ 
  
  ?></div><?
  
}

get_page('/m/shop/sc/?', $spage, $page, 'list'); 

back('/', 'На главную');
acms_footer();