<?php
html::title('Кто добавил товар в корзину');
acms_header();

$goods = db::get_string("SELECT `ID`,`NAME` FROM `SHOP_GOODS` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);

if (!isset($goods['ID'])) {
  
  error('Неверная директива');
  redirect('/m/shop/');

}

if (config('PRIVATE_SHOP') == 0){
  
  error('Модуль отключен администратором');
  redirect('/');
  
}

?>
<div class='list'>
<?=lg('Пользователи, добавившие в корзину товар')?> <a href='/m/shop/show/?id=<?=$goods['ID']?>'><?=tabs($goods['NAME'])?></a>:
</div>
<?

$column = db::get_column("SELECT COUNT(*) FROM `SHOP_BASKET` WHERE `GOODS_ID` = ?", [$goods['ID']]);
$spage = spage($column, PAGE_SETTINGS);
$page = page($spage);
$limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;
  
if ($column == 0){ 
  
  html::empty('Пока пусто');

}else{
  
  ?><div class='list-body'><?
  
}

$data = db::get_string_all("SELECT * FROM `SHOP_BASKET` WHERE `GOODS_ID` = ? ORDER BY `ID` DESC LIMIT ".$limit.", ".PAGE_SETTINGS, [$goods['ID']]);  
while ($list = $data->fetch()){
  
  require (ROOT.'/modules/users/plugins/list-mini.php');
  echo $list_mini;

}

if ($column > 0){ 
  
  ?></div><?
  
}

get_page('/m/shop/basket_list/?id='.$goods['ID'].'&', $spage, $page, 'list');

back('/m/shop/show/?id='.$goods['ID']);
acms_footer();