<?php
html::title('Добавить товар');
acms_header();
access('users');

if (config('SHOP_ACCESS') == 1 && user('ID') == 0 || config('SHOP_ACCESS') == 2 && access('shop', null) == false){
  
  error('Нет прав');
  redirect('/');

}

if (config('PRIVATE_SHOP') == 0){
  
  error('Модуль отключен администратором');
  redirect('/');
  
}

$scsub = db::get_string("SELECT * FROM `SHOP_SUB_SECTION` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);

if (!isset($scsub['ID'])) {
  
  error('Неверная директива');
  redirect('/m/shop/sc/');

}

attachments_result();

if (post('ok_goods')){
  
  valid::create(array(
    
    'GOODS_NAME' => ['name', 'text', [2, 200], 'Название', 0],
    'GOODS_ID_SUB' => ['sc_sub', 'number', [0, 99999], 'Подраздел'],
    'GOODS_MESSAGE' => ['message', 'text', [10, 20000], 'Описание', 0],
    'GOODS_ADD_TYPE' => ['add_type', 'text', [0, 20], 'Тип товара', 0],
    'GOODS_SUM' => ['sum', 'number_abs', [0, 20000000000], 'Сумма'],
    'GOODS_DISCOUNT' => ['discount', 'number', [0, 99], 'Скидка'],
    'GOODS_QUA' => ['qua', 'number', [1, 999999], 'Количество'],
    'GOODS_DISCOUNT_TIME' => ['discount_time', 'number', [0, 99999999999999], 'Срок скидки']
  
  ));
  
  if (GOODS_DISCOUNT_TIME == 0){
    
    $dtime = null;
    
  }else{
    
    $dtime = TM + GOODS_DISCOUNT_TIME;
    
  }
  
  $add = esc(GOODS_ADD_TYPE);  
  if (config('SHOP_ADD_TYPE') == 2) { $add = 'ob'; }
  if (config('SHOP_ADD_TYPE') == 3) { $add = 'cf'; }
  
  if (db::get_column("SELECT COUNT(*) FROM `SHOP_GOODS` WHERE `MESSAGE` = ? LIMIT 1", [GOODS_MESSAGE]) > 0){
    
    error('Товар с таким содержимым уже существует');
    redirect('/m/shop/add_goods/?id='.$scsub['ID']);
    
  }
  
  if ($add == 'cf') {
    
    if (db::get_column("SELECT COUNT(*) FROM `SHOP_FILE` WHERE `OBJECT_ID` = ? AND `USER_ID` = ? LIMIT 1", [0, user('ID')]) == 0){
      
      error('Необходимо прикрепить файл с цифровым товаром');
      redirect('/m/shop/add_goods/?id='.$scsub['ID']);
    
    }
    
  }
  
  if (ERROR_LOG == 1){
    
    redirect('/m/shop/add_goods/?id='.$scsub['ID']);
  
  }
  
  $ID = db::get_add("INSERT INTO `SHOP_GOODS` (`NAME`, `USER_ID`, `SUB_SECTION_ID`, `MESSAGE`, `TIME`, `DISCOUNT_TIME`, `DISCOUNT`, `QUA`, `SUM`, `TYPE`, `EDIT_TIME`, `MODERATION`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", [GOODS_NAME, user('ID'), GOODS_ID_SUB, GOODS_MESSAGE, TM, $dtime, GOODS_DISCOUNT, GOODS_QUA, GOODS_SUM, $add, TM, (config('SHOP_MODERATION') == 1 ? 0 : 1)]);
  
  db::get_set("UPDATE `ATTACHMENTS` SET `ID_POST` = ?, `ACT` = '1' WHERE `USER_ID` = ? AND `ACT` = '0' AND `TYPE_POST` = ?", [$ID, user('ID'), 'shop_screen']);
  db::get_set("UPDATE `SHOP_FILE` SET `OBJECT_ID` = ? WHERE `USER_ID` = ? AND `OBJECT_ID` = ? LIMIT 1", [$ID, user('ID'), 0]);
  db::get_add("INSERT INTO `SHOP_MODERATION` (`USER_ID`, `ACT`, `TIME`, `GOODS_ID`) VALUES (?, ?, ?, ?)", [user('ID'), (config('SHOP_MODERATION') == 1 ? 0 : 1), TM, $ID]);
  
  success('Товар успешно добавлен');
  redirect('/m/shop/show/?id='.$ID);
  
}

?>    
<div class='list'>
<form method='post' class='ajax-form' action='/m/shop/add_goods/?id=<?=$scsub['ID']?>'>
<?
html::input('name', 'Название', null, null, null, 'form-control-100', 'text', null, 'shopping-basket');
html::textarea(null, 'message', 'Введите содержимое', null, 'form-control-textarea', 9, 0);  
?><br /><br /><?
$array = array();
$data = db::get_string_all("SELECT * FROM `SHOP_SUB_SECTION` WHERE `SECTION_ID` = ? ORDER BY `ID` DESC", [$scsub['SECTION_ID']]);  
while ($list = $data->fetch()){
  
  $array[$list['ID']] = [$list['NAME'], ($scsub['ID'] == $list['ID'] ? "selected" : null)];

}

if (config('SHOP_MONEY_TYPE') == 1) {
  
  $mn = 'в валюте сайта';
  
}elseif (config('SHOP_MONEY_TYPE') == 2) {
  
  $mn = 'в баллах';
  
}elseif (config('SHOP_MONEY_TYPE') == 3) {
  
  $mn = 'в единицах рейтинга';
  
}

html::select('sc_sub', $array, 'Подраздел', 'form-control-100-modify-select', 'list'); 
html::input('sum', 'Цена', 'Укажите цену ('.$mn.', если 0 то бесплатно):', null, 5, 'form-control-50', 'number', null, 'money');
html::input('qua', 0, 'Количество копий:', null, 1, 'form-control-50', 'number', null, 'files-o');

if (config('SHOP_DISCOUNT') == 1) {
  
  html::input('discount', 0, 'Скидка в процентах (по желанию):', null, 0, 'form-control-50', 'number', null, 'percent');
  html::select('discount_time', array( 
  86400 => ['1 '.lg('день'), 86400], 
  172800 => ['2 '.lg('дня'), 172800],  
  259200 => ['3 '.lg('дня'), 259200], 
  345600 => ['4 '.lg('дня'), 345600], 
  432000 => ['5 '.lg('дней'), 432000], 
  518400 => ['6 '.lg('дней'), 518400], 
  604800 => ['7 '.lg('дней'), 604800], 
  691200 => ['8 '.lg('дней'), 691200],   
  777600 => ['9 '.lg('дней'), 777600], 
  864000 => ['10 '.lg('дней'), 864000], 
  950400 => ['11 '.lg('дней'), 950400], 
  1036800 => ['12 '.lg('дней'), 1036800], 
  1123200 => ['13 '.lg('дней'), 1123200], 
  1209600 => ['14 '.lg('дней'), 1209600], 
  1296000 => ['15 '.lg('дней'), 1296000],  
  1382400 => ['16 '.lg('дней'), 1382400], 
  1468800 => ['17 '.lg('дней'), 1468800], 
  1555200 => ['18 '.lg('дней'), 1555200], 
  1641600 => ['19 '.lg('дней'), 1641600], 
  1728000 => ['20 '.lg('дней'), 1728000], 
  1814400 => ['21 '.lg('дней'), 1814400], 
  1900800 => ['22 '.lg('дня'), 1900800], 
  1987200 => ['23 '.lg('дня'), 1987200], 
  2073600 => ['24 '.lg('дня'), 2073600],  
  2160000 => ['25 '.lg('дней'), 2160000], 
  2246400 => ['26 '.lg('дней'), 2246400], 
  2332800 => ['27 '.lg('дней'), 2332800], 
  2419200 => ['28 '.lg('дней'), 2419200], 
  2505600 => ['29 '.lg('дней'), 2505600], 
  2592000 => ['30 '.lg('дней'), 2592000],  
  5184000 => ['2 '.lg('месяца'), 5184000], 
  7776000 => ['3 '.lg('месяца'), 7776000], 
  10368000 => ['4 '.lg('месяца'), 10368000],  
  12960000 => ['5 '.lg('месяцев'), 12960000], 
  15552000 => ['6 '.lg('месяцев'), 15552000], 
  31536000 => ['1 '.lg('год'), 31536000]
  ), 'Срок действия скидки', 'form-control-100-modify-select', 'clock-o');
  
}

if (config('SHOP_ADD_TYPE') == 1) {
  
  html::select('add_type', array( 
  'ob' => ['Реальный товар (с доставкой после оплаты)', 'ob'], 
  'cf' => ['Цифровой товар (скачивание после оплаты в виде файла)', 'cf']
  ), 'Тип товара', 'form-control-100-modify-select', 'shopping-basket');
  
}

$link = '/m/shop/add_goods/?id='.$scsub['ID'].'&'.TOKEN_URL;

?>
<div style='background-color: #E4F3FF; color: #577287; padding: 10px; border-radius: 10px; margin-bottom: 19px'>
<b><?=lg('Прикрепите скриншоты')?>:</b><br /><br />
<a ajax="no" id="modal_bottom_open_set" onclick="upload('/system/AJAX/php/shop_screen.php?id=0&url=<?=base64_encode($link)?>', 'attachments_upload')" class="btn-o"><?=icons('upload', 15, 'fa-fw')?> <?=lg('Загрузить')?></a><br />
<div id='upload-screen'>
<?
  
if (get('delete_screen')){
  
  $screen = db::get_string("SELECT `ID` FROM `ATTACHMENTS` WHERE `ID` = ? AND `USER_ID` = ? LIMIT 1", [intval(get('delete_screen')), user('ID')]);
  
  get_check_valid();
  db::get_set("DELETE FROM `ATTACHMENTS` WHERE `USER_ID` = ? AND `ID` = ? LIMIT 1", [user('ID'), $screen['ID']]);
  @unlink(ROOT.'/files/upload/shop/screen/'.$file['ID'].'.jpg');
  @unlink(ROOT.'/files/upload/shop/screen/240x240/'.$file['ID'].'.jpg');

}   
  
$html_screen = null;
$data = db::get_string_all("SELECT `OBJECT_ID`,`TYPE`,`ID` FROM `ATTACHMENTS` WHERE `USER_ID` = ? AND `ACT` = ? AND `TYPE_POST` = ? AND `ID_POST` = ? ORDER BY `TIME` DESC LIMIT 30", [user('ID'), 0, 'shop_screen', 0]);  
while ($list = $data->fetch()){
  
  $html_screen .= '
  <div class="attachments_files_type">
  <span class="attachments_delete" onclick="request(\''.url_request_get($link).'&delete_screen='.$list['ID'].'\', \'#upload-screen\', \'1\')">'.icons('times', 12).'</span>
  <a ajax="no" href="/files/upload/shop/screen/'.$list['ID'].'.jpg">
  <img src="/files/upload/shop/screen/240x240/'.$list['ID'].'.jpg">
  </a>
  </div>';

}  

if (str($html_screen) > 0){
  
  ?>      
  <div class='upload-attachments-result'>
  <div class='attachments_files_type'><?=$html_screen?></div>
  </div>
  <?
    
}
  
?></div></div><?

if (config('SHOP_ADD_TYPE') == 3 || config('SHOP_ADD_TYPE') == 1) {
  
  ?>
  <div style='background-color: #FFE4E6; color: #8E7174; padding: 10px; border-radius: 10px; margin-bottom: 19px'>
  <b><?=lg('Если товар цифровой, то прикрепите файл (.zip или .rar)')?>:</b><br /><br />
  <a ajax="no" id="modal_bottom_open_set" onclick="upload('/system/AJAX/php/shop_file.php?id=0&url=<?=base64_encode($link)?>', 'attachments_upload')" class="btn-o"><?=icons('upload', 15, 'fa-fw')?> <?=lg('Загрузить')?></a><br />
  <div id='upload-file'>
  <?
    
  if (get('delete_file')){
    
    $file = db::get_string("SELECT `EXT`,`ID` FROM `SHOP_FILE` WHERE `ID` = ? AND `USER_ID` = ? LIMIT 1", [intval(get('delete_file')), user('ID')]);
    
    get_check_valid();
    db::get_set("DELETE FROM `SHOP_FILE` WHERE `USER_ID` = ? AND `ID` = ? LIMIT 1", [user('ID'), $file['ID']]);
    @unlink(ROOT.'/files/upload/shop/files/'.$file['ID'].'.'.$file['EXT']);
  
  }  
    
  $file = db::get_string("SELECT * FROM `SHOP_FILE` WHERE `OBJECT_ID` = ? AND `USER_ID` = ? ORDER BY `TIME` DESC LIMIT 1", [0, user('ID')]);    
  if (isset($file['ID'])){
    
    ?>
    <div class='upload-attachments-result'>
    <div class='attachments_files_type'>
    <span class="attachments_delete" onclick="request('<?=url_request_get($link)?>&delete_file=<?=$file['ID']?>', '#upload-file', '1')"><?=icons('times', 12)?></span>
    <?=file::ext($file['EXT'])?><br />
    <?=tabs(crop_text($file['NAME'], 0, 15))?>
    </div>
    </div>
    <?
  
  }
  
  ?></div></div><?
  
}

html::button('button ajax-button', 'ok_goods', 'plus', 'Добавить');  
?>
<a class='button-o' href='/m/shop/sc/?id_sub=<?=$scsub['ID']?>'><?=lg('Отмена')?></a>
<form>
</div>
<?

back('/m/shop/sc/?id_sub='.$scsub['ID']);
acms_footer();