<?php
$comm = db::get_string("SELECT `ID`,`PRIVATE`,`URL`,`NAME` FROM `COMMUNITIES` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);
$par = db::get_string("SELECT `ADMINISTRATION` FROM `COMMUNITIES_PAR` WHERE `COMMUNITY_ID` = ? AND `USER_ID` = ? AND `ACT` = ? LIMIT 1", [$comm['ID'], user('ID'), 1]);
html::title(lg('Приглашения в сообщество %s', communities::name($comm['ID'])));
acms_header();
access('users');
communities::blocked($comm['ID']);

if (!isset($comm['ID'])) {
  
  error('Неверная директива');
  redirect('/m/communities/');

}

if (config('PRIVATE_COMMUNITIES') == 0){
  
  error('Модуль отключен администратором');
  redirect('/');
  
}
  
if (get('get') == 'add'){
  
  if ($comm['PRIVATE'] == 1 && $par['ADMINISTRATION'] == 0){
    
    error('Приглашать участников могут только создатели, администраторы и модераторы');
    redirect('/m/communities/invite/?id='.$comm['ID']);
    
  }
  
  if (post('ok_inv')){
    
    valid::create(array(
      
      'INV_ID' => ['id', 'number', [0, 99999999999999999999999], 'ID']
    
    ));
    
    if (db::get_column("SELECT COUNT(*) FROM `USERS` WHERE `ID` = ? LIMIT 1", [INV_ID]) == 0){
      
      error('Такого пользователя не существует');
      redirect('/m/communities/invite/?id='.$comm['ID'].'&get=add');
    
    }
    
    if (user('ID') == INV_ID){

      error('Вы не можете пригласить самого себя');
      redirect('/m/communities/invite/?id='.$comm['ID'].'&get=add');
    
    }
    
    if (db::get_column("SELECT COUNT(*) FROM `COMMUNITIES_PAR` WHERE `COMMUNITY_ID` = ? AND `USER_ID` = ? LIMIT 1", [$comm['ID'], INV_ID]) > 0){
      
      error('Данный пользователь уже приглашен или состоит в сообществе');
      redirect('/m/communities/invite/?id='.$comm['ID'].'&get=add');
    
    }
    
    if (ERROR_LOG == 1){
      
      redirect('/m/communities/invite/?id='.$comm['ID'].'&get=add');
    
    }
    
    db::get_add("INSERT INTO `COMMUNITIES_PAR` (`USER_ID`, `COMMUNITY_ID`, `ACT`) VALUES (?, ?, ?)", [INV_ID, $comm['ID'], 2]);
    
    $message = lg('Пользователь %s приглашает вас в сообщество %s', '[b]'.user('LOGIN').'[/b]', '[b]'.$comm['NAME'].'[/b]').'. [url=/m/communities/invitations/?id='.$comm['ID'].']'.lg('Перейти к приглашениям').'[/url]';
    messages::get(intval(config('SYSTEM')), INV_ID, $message);
    
    $pr = db::get_string("SELECT `LOGIN` FROM `USERS` WHERE `ID` = ? LIMIT 1", [INV_ID]);
    db::get_add("INSERT INTO `COMMUNITIES_JURNAL` (`COMMUNITY_ID`, `TIME`, `MESSAGE`) VALUES (?, ?, ?)", [$comm['ID'], TM, lg('%s пригласил в сообщество %s', '[url=/id'.user('ID').']'.user('LOGIN').'[/url]', '[url=/id'.INV_ID.']'.$pr['LOGIN'].'[/url]')]);
    
    success('Пользователь успешно приглашен');
    redirect('/m/communities/invite/?id='.$comm['ID']);
    
  }
  
  ?>
  <div class='list'>
  <form method='post' class='ajax-form' action='/m/communities/invite/?id=<?=$comm['ID']?>&get=add'>
  <?php
  html::input('id', 'ID пользователя', null, null, null, 'form-control-30');
  html::button('button ajax-button', 'ok_inv', 'plus', 'Пригласить');
  ?>
  </form>
  </div>
  <?
  
  back('/m/communities/invite/?id='.$comm['ID']);  
  acms_footer();
  
}

?>
<div class='list'>
<center><b><?=lg('Пользователи, приглашенные в сообщество')?></b></center>
</div>
  
<div class='list'>
<a class='btn' href='/m/communities/invite/?id=<?=$comm['ID']?>&get=add'><?=icons('plus', 15, 'fa-fw')?> <?=lg('Пригласить')?></a>
</div>
<?

$column = db::get_column("SELECT COUNT(`ID`) FROM `COMMUNITIES_PAR` WHERE `COMMUNITY_ID` = ? AND `ACT` = ?", [$comm['ID'], 2]);
$spage = spage($column, PAGE_SETTINGS);
$page = page($spage);
$limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;

if ($column == 0){
  
  html::empty('Пока пусто');
  
}else{
  
  ?><div class='list-body'><?
  
}

$data = db::get_string_all("SELECT * FROM `COMMUNITIES_PAR` WHERE `COMMUNITY_ID` = ? AND `ACT` = ? ORDER BY `ID` DESC LIMIT ".$limit.", ".PAGE_SETTINGS, [$comm['ID'], 2]);
while ($list = $data->fetch()) {
  
  require (ROOT.'/modules/users/plugins/list-mini.php');
  echo $list_mini;
  
}

if ($column > 0){
  
  ?></div><?
  
}

get_page('/m/communities/invite/?id='.$comm['ID'].'&', $spage, $page, 'list');

back('/public/'.$comm['URL']);
acms_footer();