<?php
$ad = db::get_string("SELECT * FROM `ADLIST` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);
html::title(lg('Объявление - %s', tabs($ad['NAME'])));
acms_header();

if (!isset($ad['ID'])) {
  
  error('Неверная директива');
  redirect('/m/adlist/');

}

if (config('PRIVATE_ADLIST') == 0){
  
  error('Модуль отключен администратором');
  redirect('/');
  
}

/*
---------
Просмотры
---------
*/

if (user('ID') > 0){
  
  if (db::get_column("SELECT COUNT(`ID`) FROM `EYE` WHERE `USER_ID` = ? AND `OBJECT_ID` = ? AND `TYPE` = ? LIMIT 1", [user('ID'), $ad['ID'], 'adlist']) == 0){
    
    db::get_add("INSERT INTO `EYE` (`USER_ID`, `TIME`, `OBJECT_ID`, `TYPE`) VALUES (?, ?, ?, ?)", [user('ID'), TM, $ad['ID'], 'adlist']);
  
  }else{
    
    db::get_set("UPDATE `EYE` SET `TIME` = ? WHERE `OBJECT_ID` = ? AND `TYPE` = ? LIMIT 1", [TM, $ad['ID'], 'adlist']);
    
  }

}

if (access('adlist', null) == true){
  
  require_once (ROOT.'/modules/adlist/plugins/ban.php');
  
}

if (access('adlist', null) == true || $ad['USER_ID'] == user('ID')){
  
  require_once (ROOT.'/modules/adlist/plugins/delete.php');
  
}

if (user('ID') > 0){
  
  if (access('adlist', null) == true || $ad['USER_ID'] == user('ID')){
    
    ?><div class='list'><?
      
  }
    
  if (access('adlist', null) == true || $ad['USER_ID'] == user('ID')){
    
    ?>
    <a href='/m/adlist/edit/?id=<?=$ad['ID']?>&get=edit' class='btn'><?=icons('pencil', 15, 'fa-fw')?> <?=lg('Редактировать')?></a>
    <a href='/m/adlist/show/?id=<?=$ad['ID']?>&get=delete&<?=TOKEN_URL?>' class='btn'><?=icons('trash', 15, 'fa-fw')?> <?=lg('Удалить')?></a>
    <?
      
    if ($ad['USER_ID'] == user('ID')){
      
      ?>
      <a href='/m/adlist/sec/?id=<?=$ad['ID']?>' class='btn'><?=icons('clock-o', 15, 'fa-fw')?> <?=lg('Продлить срок')?></a>
      <a href='/m/adlist/vip/?id=<?=$ad['ID']?>' class='btn'><?=icons('diamond', 15, 'fa-fw')?> <?=lg('Купить VIP')?></a>
      <a href='/m/adlist/upd/?id=<?=$ad['ID']?>' class='btn'><?=icons('arrow-up', 15, 'fa-fw')?> <?=lg('Поднять')?></a> 
      <?
      
    }
      
    if (access('adlist', null) == true){
      
      if ($ad['BAN'] == 0){
        
        ?>
        <a href='/m/adlist/show/?id=<?=$ad['ID']?>&get=ban&<?=TOKEN_URL?>' class='btn'><?=icons('ban', 15, 'fa-fw')?> <?=lg('Заблокировать')?></a>
        <?
          
      }else{
        
        ?>
        <a href='/m/adlist/show/?id=<?=$ad['ID']?>&get=del_ban&<?=TOKEN_URL?>' class='btn'><?=icons('ban', 15, 'fa-fw')?> <?=lg('Разблокировать')?></a>
        <?
        
      }
      
    }
  
  }
  
  if (access('adlist', null) == true || $ad['USER_ID'] == user('ID')){
    
    ?></div><?
      
  }
  
}

if ($ad['BAN'] == 1){
  
  html::empty(lg('Объявление заблокировано администрацией сайта<br /><b>Причина: %s</b>', tabs($ad['BAN_MESSAGE'])), 'ban');
  
  back('/m/adlist/');
  acms_footer();
  
}

if ($ad['MODERATION'] == 0){
  
  html::empty('Объявление на модерации', 'gears');
  
}elseif ($ad['MODERATION'] == 2){
  
  html::empty('Объявление не прошло проверку...<br />Перепроверьте данные и попробуйте добавить снова', 'times');
  
  back('/m/adlist/');
  acms_footer();
  
}elseif ($ad['TIME_SEC'] < TM){
  
  html::empty('У объявления истек срок жизни...', 'clock-o');
  
}

?>
<div class='list-body'>
<div class='list-menu'>
<div class='user-info-mini'>
<div class='user-avatar-mini'>
<?=user::avatar($ad['USER_ID'], 45, 1)?> 
</div>
<div class='user-login-mini' style='top: 4px; left: 55px;'>
<?=user::login($ad['USER_ID'], 0, 1)?><br />
<span class='time'><?=ftime($ad['TIME'])?></span>
</div> 
</div>  
<br />
<b><?=tabs($ad['NAME'])?></b>
<br />    
<?=attachments_files($ad['ID'], 'adlist', 320)?>
<?=text($ad['MESSAGE'])?> 
  
<br /><br />
<span style="background: linear-gradient(to right, #38E4FF, #37DF76); color: white; border-radius: 20px; padding: 2px 1em; line-height: 25px"><b><?=lg('Цена')?>: <?=money($ad['SUM'], 2)?></b></span>
  
<?php
likes_ajax($ad['ID'], 'adlist', $ad['USER_ID'], 1);
dislikes_ajax($ad['ID'], 'adlist');
$action = '/m/adlist/show/?id='.$ad['ID'];

$cat = db::get_string("SELECT `NAME`,`ID` FROM `ADLIST_CATEGORIES` WHERE `ID` = ? LIMIT 1", [$ad['ID_CATEGORY']]);
if (isset($cat['ID'])){
  
  ?>
  <br />
  <a class='info blue' style='background-color: #C07CEA' href='/m/adlist/sections/?id=<?=$cat['ID']?>'>
  <?=lg(tabs($cat['NAME']))?>
  </a>
  <?
  
}
?> 
</div>  
<div class='list-menu'>

<?php if (str($ad['PHONE']) > 0) { ?>
<div style='color: #44565E; margin-top: 3px; font-weight: 500'>
<?=icons('phone', 18, 'fa-fw')?> <?=tabs($ad['PHONE'])?>
</div>
<?php } ?>
  
<?php if (str($ad['SITE']) > 0) { ?>
<div style='color: #44565E; margin-top: 14px; font-weight: 500'>
<?=icons('globe', 18, 'fa-fw')?> <a href='<?=tabs($ad['SITE'])?>' ajax='no'><?=tabs($ad['SITE'])?></a>
</div>
<?php } ?>
  
<?php if (str($ad['SOC']) > 0) { ?>
<div style='color: #44565E; margin-top: 14px; font-weight: 500'>
<?=icons('globe', 18, 'fa-fw')?> <?=tabs($ad['SOC'])?>
</div>
<?php } ?>
  
<?php if (str($ad['COUNTRY_OR_CITY']) > 0) { ?>
<div style='color: #44565E; margin-top: 14px; font-weight: 500'>
<?=icons('map-marker', 18, 'fa-fw')?> <?=tabs($ad['COUNTRY_OR_CITY'])?>
</div>
<?php } ?>
  
<?php  
if ($ad['TIME_EDIT'] > 0){
  
  ?>
  <br />
  <span class='time'>
  <?=icons('pencil', 12, 'fa-fw')?> <?=lg('Посл. редактирование')?>: <?=ftime($ad['TIME_EDIT'])?>
  </span>
  <br />
  <?
  
}
?>
  
<div id='like'>
<?=likes_list($ad['ID'], 'adlist', $action)?>
<div class='menu-sw-cont'> 
<a class='menu-sw-cont-left-33' href="/m/eye/?id=<?=$ad['ID']?>&url=<?=base64_encode($action)?>&type=adlist&<?=TOKEN_URL?>"><?=icons('eye', 18, 'fa-fw')?> <?=db::get_column("SELECT COUNT(`ID`) FROM `EYE` WHERE `OBJECT_ID` = ? AND `TYPE` = ? LIMIT 1", [$ad['ID'], 'adlist'])?></a><?=mlikes($ad['ID'], $action, 'adlist', 'menu-sw-cont-left-33')?><?=mdislikes($ad['ID'], $action, 'adlist', 'menu-sw-cont-left-33')?>
</div>
</div>
  
</div>
  
</div>
  
<div class='list'>
<b><?=lg('Комментарии')?></b> <span class='count'><?=db::get_column("SELECT COUNT(`ID`) FROM `COMMENTS` WHERE `OBJECT_ID` = ? AND `OBJECT_TYPE` = ? LIMIT 1", [$ad['ID'], 'adlist_comments'])?></span>
</div>
  
<?  
if (user('ID') == 0){
  
  $comments_set = 'Извините, для вас комментирование недоступно';
  
}

comments($action, 'adlist_comments', 1, 'message', $ad['USER_ID'], $ad['ID']);

$column = db::get_column("SELECT COUNT(*) FROM `ADLIST` WHERE `MODERATION` = ? AND `BAN` = ? AND `ID_CATEGORY` = ? AND `TIME_SEC` > ? AND `ID` != ?", [1, 0, $ad['ID_CATEGORY'], TM, $ad['ID']]);

if ($column > 0){
  
  ?>
  <div class='list-body'>
  <div class='list-menu'>
  <b><?=lg('Похожие объявления')?></b>
  </div>
  <?
  
  $data = db::get_string_all("SELECT * FROM `ADLIST` WHERE `MODERATION` = ? AND `BAN` = ? AND `ID_CATEGORY` = ? AND `TIME_SEC` > ? AND `ID` != ? ORDER BY RAND() LIMIT 2", [1, 0, $ad['ID_CATEGORY'], TM, $ad['ID']]);
  while ($list = $data->fetch()) {
    
    require (ROOT.'/modules/adlist/plugins/list.php');
    echo $adlist_list;
    
  }
  
  ?></div><?
  
}

back('/m/adlist/', 'Ко всем объявлениям');
acms_footer();