<?php
html::title('Поиск объявлений');
acms_header(); 

if (config('PRIVATE_ADLIST') == 0){
  
  error('Модуль отключен администратором');
  redirect('/');
  
}

if (post('ok_search_name')){
  
  db_filter();
  
  session('country_or_city', null);
  session('name_or_message', post('ok_search_name'));
  session('sum_ot', null);
  session('sum_do', null);
  session('id_cat', null);
  
  redirect('/m/adlist/search/');
  
}

$sum_ot = (intval(session('sum_ot')) == 0 ? null : intval(session('sum_ot')));
$sum_do = (intval(session('sum_do')) == 0 ? null : intval(session('sum_do')));
$country_or_city = esc(session('country_or_city'));
$name_or_message = esc(session('name_or_message'));
$id_cat = intval(session('id_cat'));

$country_or_city_sql = " AND (`COUNTRY_OR_CITY` LIKE ? ".(str($country_or_city) == 0 ? 'OR `COUNTRY_OR_CITY` IS NULL OR `COUNTRY_OR_CITY` IS NOT NULL' : null).")";
$name_or_message_sql = " AND (`NAME` LIKE ? OR `MESSAGE` LIKE ? ".(str($name_or_message) == 0 ? 'OR `NAME` IS NULL OR `MESSAGE` IS NOT NULL OR `NAME` IS NOT NULL OR `MESSAGE` IS NULL' : null).")";
$sum_sql = " AND (`SUM` >= ? AND `SUM` <= ? ".(intval($sum_ot) == 0 ? "OR `SUM` >= '0'" : null)." ".(intval($sum_do) == 0 ? "OR `SUM` >= '0'" : null).")";
$id_cat_sql = " AND (`ID_CATEGORY` = ? ".($id_cat == 0 ? "OR `ID_CATEGORY` >= '0'" : null).")";

$sql = $country_or_city_sql.$name_or_message_sql.$sum_sql.$id_cat_sql." AND `MODERATION` = '1' AND `BAN` = '0'";

if (post('ok_search')){
  
  db_filter();
  post_check_valid();
  
  session('country_or_city', post('country_or_city'));
  session('name_or_message', post('name_or_message'));
  session('sum_ot', post('sum_ot'));
  session('sum_do', post('sum_do'));
  session('id_cat', post('id_cat'));
  
  if (intval(post('sum_ot')) > intval(post('sum_do'))){
    
    error('Цена "от" не может быть больше "до"');
    redirect('/m/adlist/search/');
    
  }
  
  redirect('/m/adlist/search/');
  
}

?>
<div class='list'>
<form method='post' class='ajax-form' action='/m/adlist/search/'>
<?=html::input('name_or_message', 'Имя или описание', null, null, tabs($name_or_message), 'form-control-100', 'text', null, 'bullhorn')?>
<?php
$array = array();
$array[0] = [lg('Все'), ($id_cat == 0 ? "selected" : null)];
$data = db::get_string_all("SELECT * FROM `ADLIST_CATEGORIES` ORDER BY `ID` DESC");  
while ($list = $data->fetch()){
  
  $array[$list['ID']] = [$list['NAME'], ($id_cat == $list['ID'] ? "selected" : null)];

}
html::select('id_cat', $array, 'Раздел', 'form-control-100-modify-select', 'folder-open'); 
?>
<?=html::input('country_or_city', 'Страна или город', null, null, tabs($country_or_city), 'form-control-100', 'text', null, 'globe')?>
<?=html::input('sum_ot', 'Цена от', null, null, $sum_ot, 'form-control-30', 'text', null, 'money')?>
<?=html::input('sum_do', 'Цена до', null, null, $sum_do, 'form-control-30', 'text', null, 'money')?>
<?=html::button('button ajax-button', 'ok_search', 'search', 'Искать')?>
</form>
</div>
<?
  
$column = db::get_column("SELECT COUNT(*) FROM `ADLIST` WHERE `TIME_SEC` > ? ".$sql, [TM, '%'.$country_or_city.'%', '%'.$name_or_message.'%', '%'.$name_or_message.'%', intval($sum_ot), intval($sum_do), $id_cat]);
$spage = spage($column, PAGE_SETTINGS);
$page = page($spage);
$limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;  

if ($column == 0){ 
  
  html::empty('Пока пусто');
  
}else{
  
  ?><div class='list-body'><?
  
}

$data = db::get_string_all("SELECT * FROM `ADLIST` WHERE `TIME_SEC` > ? ".$sql." ORDER BY `TIME_UPD` DESC LIMIT ".$limit.", ".PAGE_SETTINGS, [TM, '%'.$country_or_city.'%', '%'.$name_or_message.'%', '%'.$name_or_message.'%', intval($sum_ot), intval($sum_do), $id_cat]);
while ($list = $data->fetch()) {
  
  require (ROOT.'/modules/adlist/plugins/list.php');
  echo $adlist_list;
  
}

if ($column > 0){ 
  
  ?></div><?
  
}

get_page('/m/adlist/search/?', $spage, $page, 'list'); 

require_once (ROOT.'/modules/adlist/plugins/vip.php');

back('/m/adlist/');
acms_footer();