<?php
  
/*
------------------------------------------------
Загрузка видео в альбомы и прикрепление
к сообщению

AlphaCMS - универсальный движок для вашего сайта
E-mail администрации проекта: adm@alpha-cms.ru
Официальный сайт поддержки: alpha-cms.ru
Руководитель проекта: adm (ID 1)
------------------------------------------------
*/
  
require_once ($_SERVER['DOCUMENT_ROOT'].'/system/connections/core.php');
access('users');

if (isset($_FILES) && ajax() == true) {
  
  //Подключаем библиотеку getID3
  require ROOT.'/system/libs/getid3/getid3.php';
  $getID3 = new getID3();
  
  //Директория в которую будут загружены файлы
  $uploadDir = ROOT."/files/upload/videos/source/";
  
  //Подсчет количества отправляемых файлов
  $fileCount = count($_FILES['file']['name']);
  
  //Разрешенные форматы для выгрузки
  $AllowFileExt = explode(",", strtolower(preg_replace('/\s+/', '', config('VIDEOS_EXT'))));
  
  //Создаем анонимную папку "Вложения", если её ещё нет
  require_once(ROOT.'/modules/videos/plugins/param.php');
  
  //Определяем анонимную папку "Вложения"
  $dir = db::get_string("SELECT `ID` FROM `VIDEOS_DIR` WHERE `USER_ID` = ? AND `PRIVATE` = '3' AND `NAME` = 'Вложения' AND `ID_DIR` = '0' LIMIT 1", [user('ID')]);
  
  //Принудительно устанавливаем права 755 на директории
  @chmod(ROOT."/files/upload/videos/source/", 0755);
  @chmod(ROOT."/files/upload/videos/screen/", 0755);
  @chmod(ROOT."/files/upload/videos/screen/240x240/", 0755);
  
  //Определяем тип
  $type = tabs(esc(get('type')));
  $id = intval(get('id'));
  
  //Определяем url откуда пришли
  $url = url_check_validate(base64_decode(get('url')));
  
  if ($fileCount > config('MAXFILEUPLOAD')){
    
    ?>
    <div class='file-error'><?=icons('exclamation-triangle', 16)?> <?=lg('Нельзя загружать более %d файлов за 1 раз', config('MAXFILEUPLOAD'))?></div>
    <?
    exit;
    
  }
  
  if (config('FILE_ACCESS') == 0) {
    
    ?>
    <div class='file-error'><?=icons('exclamation-triangle', 16)?> <?=lg('Выгрузка файлов на сайте приостановлена администрацией')?></div>
    <?
    exit;
  
  }
  
  if (db::get_column("SELECT COUNT(*) FROM `VIDEOS` WHERE `USER_ID` = ?", [user('ID')]) >= config('VIDEOS_LIMIT')){

    ?>
    <div class='file-error'><?=icons('exclamation-triangle', 16)?> <?=lg('Вы исчерпали лимит на добавление видео')?></div>
    <?
    exit;
    
  }
  
  /*
  ---------------------
  Мультивыгрузка файлов
  ---------------------
  */
  
  $error = null; 
  $s = 0;
  for ($i = 0; $i < $fileCount; $i++) {
    
    //Оригинальное название файла
    $FileNameExt = $_FILES['file']['name'][$i];
    
    //Оригинальное название файла без расширения
    $FileName = tprcs(preg_replace('#\.[^\.]*$#', null, $FileNameExt));
    
    //Расширение файла без названия
    $Ext = strtolower(preg_replace('#^.*\.#', null, $FileNameExt));
    
    //Временные файлы
    $TempName = $_FILES['file']['tmp_name'][$i];

    if (db::get_column("SELECT COUNT(*) FROM `VIDEOS` WHERE `USER_ID` = ? AND `NAME` = ? AND `ID_DIR` = ? LIMIT 1", [user('ID'), $FileName, $dir['ID']]) >= 1){
      
      $error .= "<div class='file-info'>".icons('exclamation-triangle', 16)." <b>".$FileNameExt."</b> - ".lg('Видео с таким названием уже есть в этом альбоме')."</div>";
    
    }elseif (!in_array($Ext, $AllowFileExt)) {

      $error .= "<div class='file-info'>".icons('exclamation-triangle', 16)." <b>".$FileNameExt."</b> - ".lg('Неверный формат')."</div>";
    
    }elseif (str($type) == 0) {
      
      $error .= "<div class='file-info'>".icons('exclamation-triangle', 16)." <b>".$FileNameExt."</b> - ".lg('Неизвестная ошибка')."</div>";
    
    }elseif (filesize($TempName) > config('MAXFILESIZE')) {
      
      $error .= "<div class='file-info'>".icons('exclamation-triangle', 16)." <b>".$FileNameExt."</b> - ".lg('Размер превышает установленные ограничения. Размер должен быть не больше %s', size_file(config('MAXFILESIZE')))."</div>";
    
    }elseif (str($FileName) < 1) {
      
      $error .= "<div class='file-info'>".icons('exclamation-triangle', 16)." <b>".$FileNameExt."</b> - ".lg('Имя не должно быть менее 1 символа')."</div>";
    
    }elseif (str($FileName) > 200) {
      
      $error .= "<div class='file-info'>".icons('exclamation-triangle', 16)." <b>".$FileNameExt."</b> - ".lg('Имя не должно быть более 200 символов')."</div>";
    
    }else{
      
      //Сохраняем файл
      if (!copy($TempName, $uploadDir.$FileName.'.'.$Ext)) {
        
        $error .= "<div class='file-info'>".icons('exclamation-triangle', 16)." <b>".$FileNameExt."</b> - ".lg('Не удалось загрузить')."</div>";
      
      }else{

        $getID3_file = $getID3->analyze($uploadDir.$FileName.'.'.$Ext);
        
        $ID = db::get_add("INSERT INTO `VIDEOS` (`HEIGHT`, `WIDTH`, `NAME`, `USER_ID`, `EXT`, `SIZE`, `TIME`, `ID_DIR`, `SHOW`, `DURATION`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", [$getID3_file['video']['resolution_x'], $getID3_file['video']['resolution_y'], $FileName, user('ID'), $Ext, filesize($TempName), TM, $dir['ID'], intval(get('show')), tabs($getID3_file['playtime_string'])]);        
        
        if ($id == 0) {
          
          db::get_add("INSERT INTO `ATTACHMENTS` (`USER_ID`, `OBJECT_ID`, `TYPE`, `TYPE_POST`, `TIME`, `ID_POST`, `ACT`) VALUES (?, ?, ?, ?, ?, ?, ?)", [user('ID'), $ID, 'videos', $type, TM, 0, 0]);
          
        }else{
          
          db::get_add("INSERT INTO `ATTACHMENTS` (`USER_ID`, `OBJECT_ID`, `TYPE`, `TYPE_POST`, `TIME`, `ID_POST`, `ACT`) VALUES (?, ?, ?, ?, ?, ?, ?)", [user('ID'), $ID, 'videos', $type, TM, $id, 1]);
          
        }
        
        rename($uploadDir.$FileName.'.'.$Ext, $uploadDir.$ID.'.'.$Ext);        
        ffmpeg::screen($uploadDir.$ID.'.'.$Ext, ROOT.'/files/upload/videos/screen/'.$ID.'.jpg', '00:00:02');
        
        if (is_file(ROOT.'/files/upload/videos/screen/'.$ID.'.jpg')){
          
          crop_image(ROOT.'/files/upload/videos/screen/'.$ID.'.jpg', ROOT.'/files/upload/videos/screen/240x240/'.$ID.'.jpg', 240, 240);
        
        }
        
        balls_add('VIDEOS');
        rating_add('VIDEOS');
        
        $s++;
        
      }
      
    }
    
  }
  
  /*
  --------------------------------
  Действия после успешной загрузки
  --------------------------------
  */
  
  if ($s > 0) {
    
    ?> 
    <script>      
    var data = "<?=$url?>";
    var toLoad = data+' #upload-attachments-result';
    $("#upload-attachments-result").load(toLoad);        
    modal_bottom_close();
    </script>
    <?
    
  }
  
  /*
  ----------------------------
  Уведомление о наличии ошибок
  ----------------------------
  */  
  
  if (str($error) > 0) {
    
    ?> 
    <script>
    $('#files-upload-error').html("<div class='modal_title'><?=lg('Некоторые видео не были загружены')?> (<?=$s?> <?=lg('из')?> <?=$fileCount?>)</div><div class='modal-scroll'><?=$error?></div><div class='modal_foot'><span onclick='modal_center_close()' class='button'><?=lg('Понятно, хорошо')?></span></div>");  
    modal_bottom_close();
    modal_center_open();
    </script>
    <?
    
  }

}else{
  
  ?>
  <div class='file-error'><?=icons('exclamation-triangle', 16)?> <?=lg('Не удалось установить соединение с ресивером')?></div>
  <?

}