<?php
html::title('Поиск товаров');
acms_header(); 

if (config('PRIVATE_SHOP') == 0){
  
  error('Модуль отключен администратором');
  redirect('/');
  
}

if (post('ok_search_name')){
  
  db_filter();

  session('name_or_message', post('ok_search_name'));
  session('sum_ot', null);
  session('sum_do', null);
  
  redirect('/m/shop/search/');
  
}

$sum_ot = (intval(session('sum_ot')) == 0 ? null : intval(session('sum_ot')));
$sum_do = (intval(session('sum_do')) == 0 ? null : intval(session('sum_do')));
$name_or_message = esc(session('name_or_message'));

$name_or_message_sql = " (`NAME` LIKE ? OR `MESSAGE` LIKE ? ".(str($name_or_message) == 0 ? 'OR `NAME` IS NULL OR `MESSAGE` IS NOT NULL OR `NAME` IS NOT NULL OR `MESSAGE` IS NULL' : null).")";
$sum_sql = " AND (`SUM` >= ? AND `SUM` <= ? ".(intval($sum_ot) == 0 ? "OR `SUM` >= '0'" : null)." ".(intval($sum_do) == 0 ? "OR `SUM` >= '0'" : null).")";

$sql = $name_or_message_sql.$sum_sql." AND `MODERATION` = '1' AND `BAN` = '0'";

if (post('ok_search')){
  
  db_filter();
  post_check_valid();

  session('name_or_message', post('name_or_message'));
  session('sum_ot', post('sum_ot'));
  session('sum_do', post('sum_do'));
  
  if (intval(post('sum_ot')) > intval(post('sum_do'))){
    
    error('Цена "от" не может быть больше "до"');
    
  }
  
  redirect('/m/shop/search/');
  
}

?>
<div class='list'>
<form method='post' class='ajax-form' action='/m/shop/search/'>
<?=html::input('name_or_message', 'Имя или описание', null, null, tabs($name_or_message), 'form-control-100', 'text', null, 'bullhorn')?>
<?=html::input('sum_ot', 'Цена от', null, null, $sum_ot, 'form-control-30', 'text', null, 'money')?>
<?=html::input('sum_do', 'Цена до', null, null, $sum_do, 'form-control-30', 'text', null, 'money')?>
<?=html::button('button ajax-button', 'ok_search', 'search', 'Искать')?>
</form>
</div>
<?
  
$column = db::get_column("SELECT COUNT(*) FROM `SHOP_GOODS` WHERE ".$sql, ['%'.$name_or_message.'%', '%'.$name_or_message.'%', intval($sum_ot), intval($sum_do)]);
$spage = spage($column, PAGE_SETTINGS);
$page = page($spage);
$limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;  

if ($column == 0){ 
  
  html::empty('Пока пусто');
  
}else{
  
  ?><div class='list-body'><?
  
}

$data = db::get_string_all("SELECT * FROM `SHOP_GOODS` WHERE ".$sql." ORDER BY `TIME` DESC LIMIT ".$limit.", ".PAGE_SETTINGS, ['%'.$name_or_message.'%', '%'.$name_or_message.'%', intval($sum_ot), intval($sum_do)]);
while ($list = $data->fetch()) {
  
  require (ROOT.'/modules/shop/plugins/list.php');
  echo $shop_list;
  
}

if ($column > 0){ 
  
  ?></div><?
  
}

get_page('/m/shop/search/?', $spage, $page, 'list'); 

back('/m/shop/');
acms_footer();