<?php
html::title('Отзывы');
acms_header();

$goods = db::get_string("SELECT `ID`,`NAME` FROM `SHOP_GOODS` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);

if (!isset($goods['ID'])) {
  
  error('Неверная директива');
  redirect('/m/shop/');

}

if (config('PRIVATE_SHOP') == 0){
  
  error('Модуль отключен администратором');
  redirect('/');
  
}

?>
<div class='list'>
<?=lg('Пользователи, оставившие свои отзывы к товару')?> <a href='/m/shop/show/?id=<?=$goods['ID']?>'><?=tabs($goods['NAME'])?></a>:
</div>
<?

$column = db::get_column("SELECT COUNT(*) FROM `SHOP_RATING` WHERE `GOODS_ID` = ?", [$goods['ID']]);
$spage = spage($column, PAGE_SETTINGS);
$page = page($spage);
$limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;
  
if ($column == 0){ 
  
  html::empty('Пока пусто');

}else{
  
  ?><div class='list-body'><?
  
}

if (get('delete') && access('shop', null) == true) { 
  
  get_check_valid();
  db::get_set("DELETE FROM `SHOP_RATING` WHERE `ID` = ? LIMIT 1", [intval(get('delete'))]);
  
  success('Отзыв успешно удален');
  redirect('/m/shop/rating/?id='.$goods['ID']);
  
}

$data = db::get_string_all("SELECT * FROM `SHOP_RATING` WHERE `GOODS_ID` = ? ORDER BY `ID` DESC LIMIT ".$limit.", ".PAGE_SETTINGS, [$goods['ID']]);  
while ($list = $data->fetch()){
  
  ?>
  <div class='list-menu'>
  <?=user::login($list['USER_ID'], 0, 1)?><br />
  <span class='time'><?=ftime($list['TIME'])?></span>
  <br />
  <?=($list['TYPE'] == 'top' ? '<span class="info green">'.lg('Положительный отзыв').'</span>' : '<span class="info red">'.lg('Отрицательный отзыв').'</span>')?><br /><br />
  <?=tabs($list['MESSAGE'])?>
  <?
    
  if (access('shop', null) == true) {
    
    ?>
    <br /><br />
    <a href='/m/shop/rating/?id=<?=$goods['ID']?>&<?=TOKEN_URL?>&delete=<?=$list['ID']?>' class='btn'><?=icons('trash', 15, 'fa-fw')?> <?=lg('Удалить')?></a>
    <?
    
  }
  
  ?></div><?

}

if ($column > 0){ 
  
  ?></div><?
  
}

get_page('/m/shop/rating/?id='.$goods['ID'].'&', $spage, $page, 'list');

back('/m/shop/show/?id='.$goods['ID']);
acms_footer();