<?php
acms_header('Доставки', 'shop');
is_active_module('PRIVATE_SHOP');

if (get('ok')){
  
  get_check_valid();
  
  $pur = db::get_string("SELECT * FROM `SHOP_PURCHASE` WHERE `ID` = ? LIMIT 1", [intval(get('ok'))]);
  
  if (isset($pur['ID'])){
    
    db::get_set("UPDATE `SHOP_PURCHASE` SET `ACT` = ? WHERE `ID` = ?", [1, $pur['ID']]);
    
  }
  
  success('Вы подтвердили получение товара');
  redirect('/m/shop/purchase_adrs/');
  
}

if (get('no')){
  
  get_check_valid();
  
  $pur = db::get_string("SELECT * FROM `SHOP_PURCHASE` WHERE `ID` = ? LIMIT 1", [intval(get('no'))]);
  $list = db::get_string("SELECT `SUM`,`DISCOUNT_TIME`,`DISCOUNT` FROM `SHOP_GOODS` WHERE `ID` = ? LIMIT 1", [$pur['GOODS_ID']]);
  
  if (isset($pur['ID'])){
    
    $sum = $list['SUM'];
    
    if (config('SHOP_DISCOUNT') == 1 && $list['DISCOUNT_TIME'] > TM && $list['DISCOUNT'] > 0) {
      
      $sum = $list['SUM'] / 100;
      $sum = $sum * $list['DISCOUNT'];
      $sum = $list['SUM'] - $sum;
    
    }
    
    if (config('SHOP_MONEY_TYPE') == 1) {
      
      db::get_set("UPDATE `USERS` SET `MONEY` = `MONEY` + ? WHERE `ID` = ? LIMIT 1", [$sum, user('ID')]);
    
    }elseif (config('SHOP_MONEY_TYPE') == 2) {
      
      db::get_set("UPDATE `USERS` SET `BALLS` = `BALLS` + ? WHERE `ID` = ? LIMIT 1", [$sum, user('ID')]);
    
    }elseif (config('SHOP_MONEY_TYPE') == 3) {
      
      db::get_set("UPDATE `USERS` SET `RATING` = `RATING` + ? WHERE `ID` = ? LIMIT 1", [$sum, user('ID')]);
    
    }
    
    db::get_set("UPDATE `SHOP_GOODS` SET `QUA` = `QUA` + ? WHERE `ID` = ?", [1, $pur['GOODS_ID']]);    
    db::get_set("DELETE FROM `SHOP_PURCHASE` WHERE `ID` = ?", [$pur['ID']]);
    
  }
  
  success('Доставка отменена');
  redirect('/m/shop/purchase_adrs/');
  
}

?>
<div class='list'>
<?=lg('Покупки, ожидающие доставки')?>:
</div>
<?

$column = db::get_column("SELECT COUNT(*) FROM `SHOP_PURCHASE` WHERE `ACT` = ?", [0]);
$spage = spage($column, PAGE_SETTINGS);
$page = page($spage);
$limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;
  
if ($column == 0){ 
  
  html::empty('Пока пусто');

}else{
  
  ?><div class='list-body'><?
  
}

$d = 0;
$data2 = db::get_string_all("SELECT * FROM `SHOP_PURCHASE` WHERE `ACT` = ? ORDER BY `ID` DESC LIMIT ".$limit.", ".PAGE_SETTINGS, [0]);  
while ($list2 = $data2->fetch()){
  
  $list = db::get_string("SELECT * FROM `SHOP_GOODS` WHERE `ID` = ? LIMIT 1", [$list2['GOODS_ID']]);
  
  $dop = '
  <br /><br />
  '.lg('Адрес доставки').': <b>'.tabs($list2['ADRESS']).'</b><br />
  '.lg('Телефон для связи').': <b>'.tabs($list2['PHONE']).'</b><br />
  '.lg('Пользователь').': <b>'.user::login($list2['USER_ID'], 0, 1).'</b><br />
  '.lg('Время').': <b>'.ftime($list2['TIME']).'</b><br /><br />
  <a href="/m/shop/purchase_adrs/?ok='.$list2['ID'].'&'.TOKEN_URL.'" class="btn">'.icons('check', 15, 'fa-fw').' '.lg('Подтвердить получение товара').'</a>
  <a href="/m/shop/purchase_adrs/?no='.$list2['ID'].'&'.TOKEN_URL.'" class="btn">'.icons('times', 15, 'fa-fw').' '.lg('Отменить доставку').'</a>
  ';
  
  require (ROOT.'/modules/shop/plugins/list.php');
  echo $shop_list;

}

if ($column > 0){ 
  
  ?></div><?
  
}

get_page('/m/shop/purchase_adrs/?', $spage, $page, 'list');

back('/m/shop/sc/');
acms_footer();