<?php
acms_header('Журнал модерации', 'shop');
is_active_module('PRIVATE_SHOP');

if (get('id')){
  
  get_check_valid();
  
  $adm = db::get_string("SELECT * FROM `SHOP_MODERATION` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);
  
  if (isset($adm['ID'])){
    
    /*
    ----------------
    Одобрение товара
    ----------------
    */
    
    if (get('get') == 'yes'){
      
      db::get_set("UPDATE `SHOP_GOODS` SET `MODERATION` = ? WHERE `ID` = ? LIMIT 1", [1, $adm['GOODS_ID']]);
      db::get_set("UPDATE `SHOP_MODERATION` SET `ACT` = ? WHERE `ID` = ? LIMIT 1", [1, $adm['ID']]);
      
      $message = 'Поздравляем, ваш [url=/m/adlist/show/?id='.$adm['GOODS_ID'].']товар[/url] одобрен и уже добавлен в магазин.';
      messages::get(config('SYSTEM'), $adm['USER_ID'], $message, 0);
      
      success('Товар одобрен');
      redirect('/m/shop/moderation/');
      
    }
    
    if (get('get') == 'yes2'){
      
      db::get_set("UPDATE `SHOP_GOODS` SET `MODERATION` = ? WHERE `ID` = ? LIMIT 1", [1, $adm['GOODS_ID']]);
      db::get_set("UPDATE `SHOP_MODERATION` SET `ACT` = ? WHERE `ID` = ? LIMIT 1", [1, $adm['ID']]);
      
      success('Товар одобрен');
      redirect('/m/shop/moderation/');
      
    }
    
    /*
    -----------------
    Отклонение товара
    -----------------
    */
    
    if (get('get') == 'no'){
      
      db::get_set("UPDATE `SHOP_GOODS` SET `MODERATION` = ? WHERE `ID` = ? LIMIT 1", [2, $adm['GOODS_ID']]);
      db::get_set("UPDATE `SHOP_MODERATION` SET `ACT` = ? WHERE `ID` = ? LIMIT 1", [3, $adm['ID']]);
      
      $message = 'Сожалеем, но в ходе проверки ваш [url=/m/shop/show/?id='.$adm['GOODS_ID'].']товар[/url] не был одобрен.';
      messages::get(config('SYSTEM'), $adm['USER_ID'], $message, 0);
      
      success('Товар отклонен');
      redirect('/m/shop/moderation/');
      
    }
    
    /*
    ---------------------------
    Отмена одобрения/отклонения
    ---------------------------
    */
    
    if (get('get') == 'cancel'){
      
      db::get_set("UPDATE `SHOP_GOODS` SET `MODERATION` = ? WHERE `ID` = ? LIMIT 1", [0, $adm['GOODS_ID']]);
      db::get_set("UPDATE `SHOP_MODERATION` SET `ACT` = ? WHERE `ID` = ? LIMIT 1", [0, $adm['ID']]);

      redirect('/m/shop/moderation/');
      
    }
    
  }
  
}

$column = db::get_column("SELECT COUNT(*) FROM `SHOP_MODERATION`");
$spage = spage($column, PAGE_SETTINGS);
$page = page($spage);
$limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;

if ($column == 0){ 
  
  html::empty();
  
}else{
  
  ?><div class='list-body'><?
  
}

$data = db::get_string_all("SELECT * FROM `SHOP_MODERATION` ORDER BY `TIME` DESC LIMIT ".$limit.", ".PAGE_SETTINGS);
while ($list = $data->fetch()) {
  
  $goods = db::get_string("SELECT `ID`,`NAME` FROM `SHOP_GOODS` WHERE `ID` = ? LIMIT 1", [$list['GOODS_ID']]);
  
  ?><div class='list-menu'><?
    
  if ($list['ACT'] == 2) {
    
    ?>
    <?=lg('Пользователь %s отредактировал товар %s', '<b>'.user::login_mini($list['USER_ID']).'</b>', '<a href="/m/shop/show/?id='.$goods['ID'].'">'.tabs($goods['NAME']).'</a>')?>
    <br /><br />
    <a href='/m/shop/moderation/?id=<?=$list['ID']?>&get=yes2&<?=TOKEN_URL?>' class='btn'><?=icons('check', 15, 'fa-fw')?> <?=lg('Одобряю изменения')?></a>
    <a href='/m/shop/show/?id=<?=$list['ID']?>&get=ban&<?=TOKEN_URL?>' class='btn'><?=icons('times', 15, 'fa-fw')?> <?=lg('Заблокировать')?></a>
    <?
      
  }elseif ($list['ACT'] == 0) {
    
    ?>
    <?=lg('Пользователь %s добавил товар %s и ждет одобрения', '<b>'.user::login_mini($list['USER_ID']).'</b>', '<a href="/m/shop/show/?id='.$goods['ID'].'">'.tabs($goods['NAME']).'</a>')?><br />
    <span class='info gray'><?=lg('На модерации')?></span>
    <br /><br />
    <a href='/m/shop/moderation/?id=<?=$list['ID']?>&get=yes&<?=TOKEN_URL?>' class='btn'><?=icons('check', 15, 'fa-fw')?> <?=lg('Одобрить')?></a>
    <a href='/m/shop/moderation/?id=<?=$list['ID']?>&get=no&<?=TOKEN_URL?>' class='btn'><?=icons('times', 15, 'fa-fw')?> <?=lg('Отклонить')?></a>
    <?
    
  }elseif ($list['ACT'] == 1) {
    
    ?>
    <?=lg('Пользователь %s добавил товар %s и ждет одобрения', '<b>'.user::login_mini($list['USER_ID']).'</b>', '<a href="/m/shop/show/?id='.$goods['ID'].'">'.tabs($goods['NAME']).'</a>')?><br />
    <span class='info green'><?=lg('Активно')?></span>
    <br /><br />  
    <a href='/m/shop/moderation/?id=<?=$list['ID']?>&get=cancel&<?=TOKEN_URL?>' class='btn'><?=icons('times', 15, 'fa-fw')?> <?=lg('Отменить одобрение')?></a>
    <?
    
  }elseif ($list['ACT'] == 3) {
    
    ?>
    <?=lg('Пользователь %s добавил товар %s и ждет одобрения', '<b>'.user::login_mini($list['USER_ID']).'</b>', '<a href="/m/shop/show/?id='.$goods['ID'].'">'.tabs($goods['NAME']).'</a>')?><br />
    <span class='info red'><?=lg('Отклонено')?></span>
    <br /><br />  
    <a href='/m/shop/moderation/?id=<?=$list['ID']?>&get=cancel&<?=TOKEN_URL?>' class='btn'><?=icons('times', 15, 'fa-fw')?> <?=lg('Отменить отклонение')?></a>
    <?
    
  }
    
  ?></div><?

}

if ($column > 0){
  
  ?></div><?
  
}

get_page('/m/shop/moderation/?', $spage, $page);

back('/m/shop/sc/', 'К магазину');
acms_footer();