<?php
html::title('Разделы объявлений');
acms_header(); 

if (config('PRIVATE_ADLIST') == 0){
  
  error('Модуль отключен администратором');
  redirect('/');
  
}
  
?> 
<div class='menu-nav-content'>
  
<a class='menu-nav' href='/m/adlist/?'>
<?=lg('Все')?>
</a>
  
<a class='menu-nav' href='/m/adlist/?get=new'>
<?=lg('Новые')?>
</a>
  
<a class='menu-nav' href='/m/adlist/catalog/'>
<?=lg('Каталог')?>
</a>
    
<a class='menu-nav h' href='/m/adlist/sections/'>
<?=lg('Разделы')?>
</a>
  
<?php if (user('ID') > 0) { ?>  
<a class='menu-nav' href='/m/adlist/users/?id=<?=user('ID')?>'>
<?=lg('Мои')?>
</a>
<?php } ?>
  
</div>
<?
  
/*
-------------
Показ раздела
-------------
*/
  
if (get('id')){
  
  $id = intval(get('id'));  
  $section = db::get_string("SELECT `NAME`,`ICONS` FROM `ADLIST_CATEGORIES` WHERE `ID` = ? LIMIT 1", [$id]);
  
  if (isset($section['NAME'])){
    
    if (access('adlist', null) == true){
      
      /*
      -----------------------
      Редактировать категорию
      -----------------------
      */
      
      if (get('get') == 'edit'){
        
        get_check_valid();
        
        if (post('ok')){
          
          valid::create(array(
            
            'SECTION_NAME' => ['name', 'text', [3, 200], 'Название', 0],
            'SECTION_ICONS' => ['icons', 'text', [0, 50], 'Иконка', 0]
          
          ));
          
          if (SECTION_NAME != $section['NAME'] && db::get_column("SELECT COUNT(*) FROM `ADLIST_CATEGORIES` WHERE `NAME` = ? LIMIT 1", [SECTION_NAME]) == 1){
            
            error('Раздел с таким названием уже существует');
            redirect('/m/adlist/sections/?id='.$id.'&get=edit&'.TOKEN_URL);
          
          }
          
          if (ERROR_LOG == 1){
            
            redirect('/m/adlist/sections/?id='.$id.'&get=edit&'.TOKEN_URL);
          
          }
          
          db::get_set("UPDATE `ADLIST_CATEGORIES` SET `NAME` = ?, `ICONS` = ? WHERE `ID` = ? LIMIT 1", [SECTION_NAME, SECTION_ICONS, $id]);
          
          if (access('adlist', null) == true){
            
            logs('Объявления - редактирование [url=/m/adlist/sections/?id='.$id.']раздела[/url]', user('ID'));
          
          }
          
          success('Изменения успешно приняты');
          redirect('/m/adlist/sections/?id='.$id);
        
        }
        
        ?>
        <div class='list'>
        <form method='post' class='ajax-form' action='/m/adlist/sections/?id=<?=$id?>&get=edit&<?=TOKEN_URL?>'>
        <?          
        html::input('name', 'Название', null, null, tabs($section['NAME']), 'form-control-100', 'text', null, 'folder-open');
        html::input('icons', 'Иконка font-awesome (не обязательно)', null, null, tabs($section['ICONS']), 'form-control-50', 'text', null, 'image');
        html::button('button ajax-button', 'ok', 'plus', 'Добавить');        
        ?>
        <a class='button-o' href='/m/adlist/sections/?id=<?=$id?>'><?=lg('Отмена')?></a>
        </form>
        </div>
        <?
        
        back('/m/adlist/sections/?id='.$id);
        acms_footer();
        
      }
      
      /*
      ----------------
      Удаление раздела
      ----------------
      */
      
      if (get('get') == 'delete_ok'){
        
        get_check_valid();
        
        db::get_set("DELETE FROM `ADLIST_CATEGORIES` WHERE `ID` = ? LIMIT 1", [$id]);
        
        if (access('adlist', null) == true){
          
          logs('Объявления - удаление раздела', user('ID'));
        
        }
        
        success('Удаление прошло успешно');
        redirect('/m/adlist/sections/');
      
      }
      
      if (get('get') == 'delete'){
        
        get_check_valid();
        
        ?>
        <div class='list'>
        <?=lg('Вы действительно хотите удалить раздел')?> <b><?=tabs($section['NAME'])?></b>?<br /><br />
        <a href='/m/adlist/sections/?id=<?=$id?>&get=delete_ok&<?=TOKEN_URL?>' class='button'><?=icons('trash', 17, 'fa-fw')?> <?=lg('Удалить')?></a>
        <a href='/m/adlist/sections/?id=<?=$id?>' class='button-o'><?=lg('Отмена')?></a>
        </div>
        <?
  
      }
      
      ?>
      <div class='list'>
      <a href='/m/adlist/add/' class='btn'><?=icons('plus', 15)?> <?=lg('Добавить объявление')?></a>
      <a href='/m/adlist/sections/?id=<?=$id?>&get=edit&<?=TOKEN_URL?>' class='btn'><?=icons('pencil', 15)?> <?=lg('Редактировать')?></a>
      <a href='/m/adlist/sections/?id=<?=$id?>&get=delete&<?=TOKEN_URL?>' class='btn'><?=icons('trash', 15)?> <?=lg('Удалить')?></a>  
      </div>
      <?
      
    }
    
    ?>
    <div class='list'>
    <?=lg('Объявления раздела')?> "<b><?=lg(tabs($section['NAME']))?></b>"
    </div>
    <?
    
    $column = db::get_column("SELECT COUNT(*) FROM `ADLIST` WHERE `MODERATION` = '1' AND `BAN` = '0' AND `ID_CATEGORY` = ?  AND `TIME_SEC` > ?", [$id, TM]);
    $spage = spage($column, PAGE_SETTINGS);
    $page = page($spage);
    $limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;
    
    if ($column == 0){ 
      
      html::empty('Пока пусто');
    
    }else{
      
      ?><div class='list-body'><?
      
    }
    
    $data = db::get_string_all("SELECT * FROM `ADLIST` WHERE `MODERATION` = '1' AND `BAN` = '0' AND `ID_CATEGORY` = ? AND `TIME_SEC` > ? ORDER BY `TIME_UPD` DESC LIMIT ".$limit.", ".PAGE_SETTINGS, [$id, TM]);
    while ($list = $data->fetch()) {
      
      require (ROOT.'/modules/adlist/plugins/list.php');
      echo $adlist_list;
    
    }
    
    if ($column > 0){ 
      
      ?></div><?
      
    }
    
    get_page('/m/adlist/sections/?id='.$id.'&', $spage, $page, 'list');
    
    require_once (ROOT.'/modules/adlist/plugins/vip.php');
    
    back('/m/adlist/sections/');
    acms_footer();
    
  }
  
}
  
/*
---------------
Добавить раздел
---------------
*/
  
if (access('adlist', null) == true && get('get') == 'add'){
  
  get_check_valid();
  
  if (post('ok')){
    
    valid::create(array(
      
      'SECTION_NAME' => ['name', 'text', [3, 200], 'Название', 0],
      'SECTION_ICONS' => ['icons', 'text', [0, 50], 'Иконка', 0]
    
    ));
    
    if (db::get_column("SELECT COUNT(*) FROM `ADLIST_CATEGORIES` WHERE `NAME` = ? LIMIT 1", [SECTION_NAME]) == 1){
      
      error('Раздел с таким названием уже существует');
      redirect('/m/adlist/sections/?get=add&'.TOKEN_URL);
    
    }
    
    if (ERROR_LOG == 1){
      
      redirect('/m/adlist/sections/?get=add&'.TOKEN_URL);
    
    }
    
    $ID = db::get_add("INSERT INTO `ADLIST_CATEGORIES` (`NAME`, `ICONS`) VALUES (?, ?)", [SECTION_NAME, SECTION_ICONS]);
    
    if (access('adlist', null) == true){
      
      logs('Объявления - создание нового [url=/m/adlist/sections/?id='.$ID.']раздела[/url]', user('ID'));
    
    }
    
    success('Раздел успешно добавлен');
    redirect('/m/adlist/sections/');
    
  }
  
  ?>
  <div class='list'>
  <form method='post' class='ajax-form' action='/m/adlist/sections/?get=add&<?=TOKEN_URL?>'>
  <?
  
  html::input('name', 'Название', null, null, null, 'form-control-100', 'text', null, 'folder-open');
  html::input('icons', 'Иконка font-awesome (не обязательно)', null, null, null, 'form-control-50', 'text', null, 'image');
  html::button('button ajax-button', 'ok', 'plus', 'Добавить');
  
  ?>
  <a class='button-o' href='/m/adlist/sections/'><?=lg('Отмена')?></a>
  </form>
  </div>
  <?
  
  back('/m/adlist/sections/');
  acms_footer();
  
}
  
/*
----------------
Список разделов
----------------
*/
  
require_once (ROOT.'/modules/adlist/plugins/search_form.php');
  
if (access('adlist', null) == true){
  
  ?>
  <div class='list'>
  <a href='/m/adlist/sections/?get=add&<?=TOKEN_URL?>' class='btn'><?=icons('pencil', 15, 'fa-fw')?> <?=lg('Добавить раздел')?></a>
  </div>
  <?
  
}

$column = db::get_column("SELECT COUNT(*) FROM `ADLIST_CATEGORIES`");
$spage = spage($column, PAGE_SETTINGS);
$page = page($spage);
$limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;

if ($column == 0){ 
  
  html::empty('Пока нет разделов');
  
}else{
  
  ?><div class='list-body'><?
  
}

$data = db::get_string_all("SELECT * FROM `ADLIST_CATEGORIES` ORDER BY `ID` DESC LIMIT ".$limit.", ".PAGE_SETTINGS);
while ($list = $data->fetch()) {
  
  ?>
  <a href='/m/adlist/sections/?id=<?=$list['ID']?>'>
  <div class='list-menu hover'>
  <?=icons((str($list['ICONS']) > 0 ? $list['ICONS'] : 'folder-open'), 17, 'fa-fw')?> <?=lg(tabs($list['NAME']))?> <span class='count'><?=db::get_column("SELECT COUNT(*) FROM `ADLIST` WHERE `MODERATION` = ? AND `ID_CATEGORY` = ? AND `BAN` = ? AND `TIME_SEC` > ?", [1, $list['ID'], 0, TM])?></span>
  </div>
  </a>
  <?
  
}

if ($column > 0){ 
  
  ?></div><?
  
}

get_page('/m/adlist/sections/?', $spage, $page, 'list'); 

back('/', 'На главную');
acms_footer();