<?php
  
/*
--------------------------------
Проверка является ли посетитель 
зарегистрированным пользователем
--------------------------------
*/
  
function is_user($id, $type = 0){
  
  if (db::get_column("SELECT COUNT(`ID`) FROM `USERS` WHERE `ID` = ? LIMIT 1", [$id]) == 0) {
    
    if ($type == 0) {
      
      error('Такого пользователя не существует');
      redirect('/');
      
    }else{
      
      return false;
      
    }
    
  }
  
  return true;

}  
  
/*
------------------------------------
Проверка является ли модуль активным
------------------------------------
*/
  
function is_active_module($data, $type = 0){
  
  if (strpos($data, 'PRIVATE_') === false) {
    
    if ($type == 0) {
      
      error('Заданы неверные параметры. Обратитесь к администрации');
      redirect('/');
      
    }else{
      
      return false;
      
    }
    
  }
  
  if (config($data) == 0) {
    
    if ($type == 0) {
      
      error('Модуль отключен администратором');
      redirect('/');
      
    }else{
      
      return false;
      
    }
    
  }
  
  return true;

}
  
/*
--------------------------------------------
Абсолютный текст с фильтрацией без бб-кодов,
смайлов и т.п.
--------------------------------------------
*/
  
function tabs($text){
  
  return stripslashes(htmlspecialchars($text, ENT_QUOTES, 'UTF-8'));

}

/*
--------------------------------
Замена символов и удаление тегов
--------------------------------
*/

function tprcs($text){
  
  $special_chars = array('?', '[', ']', '/', '\\', '=', '<', '>', ':', ';', ',', "'", '"', '&', '$', '#', '*', '(', ')', '|', '~', '`', '!', '{', '}', '%', '+', chr(0));
  
  $text = preg_replace("#\x{00a0}#siu", ' ', $text);
  $text = str_replace($special_chars, '', $text);
  $text = str_replace(array('%20', '+' ), '-', $text);
  $text = preg_replace('/[\r\n\t -]+/', '-', $text);
  $text = trim($text, '.-_');	
  
  return htmlspecialchars(strip_tags($text));
  
}

/*
---------------------------------------------
Полное удаление символов из текста без замены
---------------------------------------------
*/

function clearspecialchars($text) {
  
  $special_chars = array('?', '[', ']', '/', '\\', '=', '<', '>', ':', ';', ',', "'", '"', '&', '$', '#', '*', '(', ')', '|', '~', '`', '!', '{', '}', '%', '+', chr(0));
  
  $text = preg_replace("#\x{00a0}#siu", ' ', $text);
  $text = str_replace($special_chars, '', $text);
  $text = str_replace(array('%20', '+'), '', $text);
  $text = trim($text, '.-_');	
  
  return htmlspecialchars($text);
  
}

/*
--------------------------------------
Фильтрация текста перед записью в базу
данных
--------------------------------------
*/

function esc($text){

  return addslashes($text);

}

/*
----------------------------------------------------
Модификация REQUEST_URI с поиском нужного элемента в 
адресной строке
Нужен для страниц работающих по типу controller.php
в /index.php
----------------------------------------------------
*/

function url_request_validate($data){
  
  if (strpos(REQUEST_URI, $data) !== false){
    
    return true;
    
  }else{
    
    return false;

  }
  
}

/*
--------------------------------
Функция для преобразования URL в
корректный вид
--------------------------------
*/

function url_filter($text, $cyrillic = false) {
  
  $text = trim(strip_tags(html_entity_decode((string)$text, ENT_QUOTES|ENT_XHTML, 'utf-8'))); 
  $text = function_exists('mb_strtolower') ? mb_strtolower($text, 'utf-8') : strtolower($text); 
  
  if ($cyrillic == true) { 
    
    $pattern = '#[^-0-9a-zа-яё.%/_:&=?\s]+#u'; 
  
  }else{
    
    $pattern = '#[^-0-9a-z.%/_:&=?\s]+#u';
  
  }    
  
  $text = preg_replace($pattern, '', $text); 
  $text = preg_replace("#[-\s]+#u", '-', $text); 
  $text = trim($text, '-'); 
  $s_length = mb_strlen($text, 'utf-8');
  
  if ($s_length > 255) { 
    
    $text = mb_substr($text, 0, 255, 'utf-8'); 
  
  }
  
  return $text; 

}

/*
--------------------------
Проверка url на валидность
--------------------------
*/

function url_check_validate($data){
  
  if (strpos($data, 'http://') !== false || strpos($data, 'https://') !== false){
    
    if (filter_var($data, FILTER_VALIDATE_URL)){
      
      return url_filter($data, true);
      
    }else{
      
      return 'none';
      
    }
    
  }else{
    
    $url = SCHEME.HTTP_HOST.$data;
    
    if (filter_var($url, FILTER_VALIDATE_URL)){
      
      return url_filter($data, true);
      
    }else{
      
      return 'none';
      
    }

  }
  
}

/*
---------------------------------
Преобразует get конструкцию в url
---------------------------------
*/

function url_request_get($url){
  
  $data = $url;
  
  $result = $data[strlen($data) - 1];
  
  if ($result == '/'){
    
    $result = $url."?";
    
  }else{
    
    $result = $url."&";

  }

  return $result;  
  
}

/*
------------------------
Фильтрация данных cookie
------------------------
*/

function filter_cookie($data){
  
  return filter_input(INPUT_COOKIE, $data, FILTER_SANITIZE_ENCODED);
  
}

/*
--------------
Обрезка текста
--------------
*/

function crop_text($text, $min, $max){
  
  //$text - текст который нужно обрезать
  //$min - обрезка начала текста
  //$max - обрезка конца
  
  if (str($text) <= $max){
    
    return $text;
    
  }else{
    
    return mb_substr($text, $min, $max, 'UTF-8')." ...";
    
  }

}

/*
------------------------------------
Проверка на валидность id и значения 
токена для get запросов
------------------------------------
*/
  
function get_check_valid() {
  
  if (config('CSRF') == 1 && csrf::check_valid('get') == false) {
    
    error('Неверный ключ запроса');
    redirect('/');
  
  }

}

/*
------------------------------------
Проверка на валидность id и значения 
токена для post запросов
------------------------------------
*/

function post_check_valid() {
  
  if (config('CSRF') == 1 && csrf::check_valid('post') == false) {
    
    error('Неверный ключ запроса');
    redirect('/');
  
  }

}

/*
----------------------------------------
Функция фильтрации записей в базу данных
по заданному интервалу
----------------------------------------
*/
  
function db_filter(){
  
  if (url_request_validate('/admin') == true){
    
    $ar = '/admin/';
    
  }else{
    
    $ar = '/';
    
  }
  
  if (user('ID') > 0){
    
    if (user('DB_FILTER') < TM){
      
      db::get_set("UPDATE `USERS` SET `DB_FILTER` = ? WHERE `ID` = ? LIMIT 1", [(TM + config('DB_INTERVAL')), user('ID')]);
      
    }else{
      
      error('Слишком частое действие. Подождите немного.');
      redirect($ar);
      
    }
    
  }
  
}

/*
--------------------------------------
Проверка данных на наличие запрещенных
символов перед записью в ini файлы
--------------------------------------
*/

function ini_data_check($data){
  
  if (!preg_match("#^([A-zА-я0-9\-\_\.\/\%\+\#\,\?\!\(\)\"\@\*\;\ \p{L}])+$#ui", $data)) {
    
    return 'none';
  
  }else{
    
    return $data;
  
  }

}

/*
--------------------------------
Перевод русских букв в аглийские
--------------------------------
*/

function translit($value){
	
  $converter = array(
    
		'а' => 'a',    'б' => 'b',    'в' => 'v',    'г' => 'g',    'д' => 'd',
		'е' => 'e',    'ё' => 'e',    'ж' => 'zh',   'з' => 'z',    'и' => 'i',
		'й' => 'y',    'к' => 'k',    'л' => 'l',    'м' => 'm',    'н' => 'n',
		'о' => 'o',    'п' => 'p',    'р' => 'r',    'с' => 's',    'т' => 't',
		'у' => 'u',    'ф' => 'f',    'х' => 'h',    'ц' => 'c',    'ч' => 'ch',
		'ш' => 'sh',   'щ' => 'sch',  'ь' => '',     'ы' => 'y',    'ъ' => '',
		'э' => 'e',    'ю' => 'yu',   'я' => 'ya',
 
		'А' => 'A',    'Б' => 'B',    'В' => 'V',    'Г' => 'G',    'Д' => 'D',
		'Е' => 'E',    'Ё' => 'E',    'Ж' => 'Zh',   'З' => 'Z',    'И' => 'I',
		'Й' => 'Y',    'К' => 'K',    'Л' => 'L',    'М' => 'M',    'Н' => 'N',
		'О' => 'O',    'П' => 'P',    'Р' => 'R',    'С' => 'S',    'Т' => 'T',
		'У' => 'U',    'Ф' => 'F',    'Х' => 'H',    'Ц' => 'C',    'Ч' => 'Ch',
		'Ш' => 'Sh',   'Щ' => 'Sch',  'Ь' => '',     'Ы' => 'Y',    'Ъ' => '',
		'Э' => 'E',    'Ю' => 'Yu',   'Я' => 'Ya',
    
  );
  
  $value = strtr($value, $converter);
  
  return $value;
  
}

/*
--------------------------
Вывод текста с настройками
--------------------------
*/
  
function text($text, $br = 1, $smiles = 1, $bb = 1, $link = 1){
  
  //$text - выводимый текст
  //$smiles - вставка смайлов
  //$br - перенос строк
  //$bb - вывод bb кодов
  //$link - обработка и вывод ссылок
  
  $text = stripslashes(htmlspecialchars($text, ENT_QUOTES, 'UTF-8'));
  
  if ($smiles == 1){
    
    $text = smiles($text);
    
  }
  
  if ($br == 1){
    
    $text = nl2br($text);
  
  }
  
  if ($bb == 1){
    
    $text = bb_code($text);
  
  }
  
  if ($link == 1){
    
    $text = links($text);
  
  }
  
  return $text;

}