<?php

/*
---------------------------
Функция вывода валюты сайта
---------------------------
*/
  
function money($sum, $type_name = 1) {
  
  //$sum - сумма которую будем выводить в валюте
  //$money - выбранная валюта на сайте
  //$type_name - тип выводимого имени валюты (просто название валюты или международное значение, если 0 то ничего не выводим)
  
  //Российские/Белорусские рубли
  if (config('MONEY') == "RUB" || config('MONEY') == "BYN"){ 
    
    $m1 = 'рубль';
    $m2 = 'рубля';
    $m3 = 'рублей';
    
  //Украинские гривны
  }elseif (config('MONEY') == "UAH"){ 
    
    $m1 = 'гривна';
    $m2 = 'гривны';
    $m3 = 'гривен';
    
  //Казахские тенге
  }elseif (config('MONEY') == "KZT"){ 
    
    $m1 = 'тенге';
    $m2 = 'тенге';
    $m3 = 'тенге';
    
  //Узбекские сумы
  }elseif (config('MONEY') == "UZS"){ 
    
    $m1 = 'сум';
    $m2 = 'сума';
    $m3 = 'сумов';
    
  //Азербайджанские/Туркменские манаты
  }elseif (config('MONEY') == "AZN" || config('MONEY') == "TMT"){ 
    
    $m1 = 'манат';
    $m2 = 'маната';
    $m3 = 'манатов';
    
  //Грузинские лари
  }elseif (config('MONEY') == "GEL"){ 
    
    $m1 = 'лари';
    $m2 = 'лари';
    $m3 = 'лари';
    
  //Армянские драмы
  }elseif (config('MONEY') == "AMD"){ 
    
    $m1 = 'драм';
    $m2 = 'драма';
    $m3 = 'драмов';
    
  //Таджикские сомони
  }elseif (config('MONEY') == "TJS"){ 
    
    $m1 = 'сомони';
    $m2 = 'сомони';
    $m3 = 'сомони';
    
  //Киргизские сомы
  }elseif (config('MONEY') == "KGS"){ 
    
    $m1 = 'сом';
    $m2 = 'сома';
    $m3 = 'сомов';
    
  //Молдавские леи
  }elseif (config('MONEY') == "MDL"){ 
    
    $m1 = 'лей';
    $m2 = 'лея';
    $m3 = 'леев';
    
  //Доллары
  }elseif (config('MONEY') == "USD"){ 
    
    $m1 = 'доллар';
    $m2 = 'доллара';
    $m3 = 'долларов';
    
  //Евро
  }elseif (config('MONEY') == "EUR"){ 
    
    $m1 = 'евро';
    $m2 = 'евро';
    $m3 = 'евро';
    
  //Серебро
  }elseif (config('MONEY') == "SLV"){ 
    
    $m1 = 'серебро';
    $m2 = 'серебра';
    $m3 = 'серебра';
    
  //Рубины
  }elseif (config('MONEY') == "RBN"){ 
    
    $m1 = 'рубин';
    $m2 = 'рубина';
    $m3 = 'рубинов';
    
  //Монеты
  }elseif (config('MONEY') == "MON"){ 
    
    $m1 = 'монета';
    $m2 = 'монеты';
    $m3 = 'монет';
    
  //Голоса
  }elseif (config('MONEY') == "VCS"){ 
    
    $m1 = 'голос';
    $m2 = 'голоса';
    $m3 = 'голосов';
    
  }
  
  //Склоняем имя валюты
  $num = abs($sum) % 100;
  $num_x = $num % 10;
  
  if ($num > 10 && $num < 20){ 
    
    $m = $m3; 
  
  }elseif ($num_x > 1 && $num_x < 5){ 
    
    $m = $m2; 
  
  }elseif ($num_x == 1){ 
    
    $m = $m1; 
  
  }else{
    
    $m = $m3;
  
  }
  
  //Вывод имени валюты
  if ($type_name == 1){ 
    
    $mn = " ".lg($m);
  
  }elseif ($type_name == 2){ 
    
    $mn = " ".config('MONEY'); 
  
  }elseif ($type_name == 3){ 
    
    $mn = " ".lg($m)." (".config('MONEY').")"; 
  
  }else{ 
    
    $mn = NULL; 
  
  }
  
  //Десятичный формат
  if (config('MONEY_SET') == 1){
    
    return tabs($sum).tabs($mn);
    
  //Обычный формат
  }else{
    
    return intval($sum).tabs($mn);  
  
  }
  
}