<?php
$game = db::get_string("SELECT * FROM `GAMES` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);
$game_user = db::get_string("SELECT * FROM `GAMES_USERS` WHERE `GAME_ID` = ? AND `USER_ID` = ? LIMIT 1", [$game['ID'], user('ID')]);
html::title(lg('Игра %s', tabs($game['NAME'])));
acms_header();
access('users');

if (!isset($game['ID'])) {
  
  error('Неверная директива');
  redirect('/m/games/');

}

if (config('PRIVATE_GAMES') == 0){
  
  error('Модуль отключен администратором');
  redirect('/');
  
}

if (get('get') == 'delete' && isset($game_user['ID'])){

  db::get_set("UPDATE `GAMES` SET `RATING` = `RATING` - '1' WHERE `ID` = ? LIMIT 1", [$game['ID']]);
  db::get_set("DELETE FROM `GAMES_USERS` WHERE `GAME_ID` = ? AND `USER_ID` = ? LIMIT 1", [$game['ID'], user('ID')]);

  success('Игра успешно удалена из вашего списка');
  redirect('/m/games/');

}

if (get('get') == 'go' && !isset($game_user['ID'])){
  
  db::get_add("INSERT INTO `GAMES_USERS` (`USER_ID`, `GAME_ID`) VALUES (?, ?)", [user('ID'), $game['ID']]);
  db::get_set("UPDATE `GAMES` SET `RATING` = `RATING` + '1' WHERE `ID` = ? LIMIT 1", [$game['ID']]);

  redirect('/games/'.$game['LINK'].'/');

}

if (get('get') == 'go_user' && isset($game_user['ID'])){

  redirect('/games/'.$game['LINK'].'/');

}

?>
<div class='list-body'>  
  
<div class='list-menu'>
<div class='user-avatar-mini'>
<img class='img' src='/games/<?=$game['LINK']?>/img/<?=$game['IMG']?>' style='width: 60px; height: 60px'>
</div>
<div class='user-login-mini' style='padding-left: 20px; width: 57%'>
<b><?=tabs($game['NAME'])?></b><br />
<p><?=icons('user', 15, 'fa-fw')?> <?=lg('играют')?> <?=db::get_column("SELECT COUNT(*) FROM `GAMES_USERS` WHERE `GAME_ID` = ?", [$game['ID']])?> <?=lg('чел.')?></p>
</div>
</div>
  
<div class='list-menu'>  
<?=tabs($game['MESSAGE'])?>
<br /><br />
<?

if (isset($game_user['ID'])){
  
  ?>
  <a href='/m/games/show/?id=<?=$game['ID']?>&get=go_user' class='btn'><?=icons('gamepad', 15, 'fa-fw')?> <?=lg('Играть')?></a>
  <a href='/m/games/show/?id=<?=$game['ID']?>&get=delete' class='btn-o'><?=icons('trash', 15, 'fa-fw')?> <?=lg('Удалить из списка')?></a>
  <?
  
}else{
  
  ?>
  <a href='/m/games/show/?id=<?=$game['ID']?>&get=go' class='btn'><?=icons('plus', 15, 'fa-fw')?> <?=lg('Вступить в игру')?></a>
  <?
  
}

?>
</div>
</div>
<?

back('/m/games/', 'Ко всем играм');
acms_footer();