<?php
function __autoload($class_name) {
    include $_SERVER["DOCUMENT_ROOT"].'/php/system/classes/'.$class_name . '.php';
}

function input($string){
	return filter_var($string, FILTER_SANITIZE_STRING);
}

function calcProdKat($id){

}

function output($string){
	return nl2br($string);
}

function showAlertDanger($string){
	echo '<div class="alert alert-danger" role="alert">'.$string.'</div>';
}

function showAlertSuccess($string){
	echo '<div class="alert alert-success" role="alert">'.$string.'</div>';
}

function isUser(){
	global $user;
	if(isset($user['id'])){
		return true;
	}else{
		return false;
	}
}

function admin($level){
	global $user;
	if($user['admin'] < $level){
		header('location:/');
	}
}

function mode($mode){
	if($mode == "user" && !isset($user['id'])){
		header('location:/main');
	}elseif($mode == "guest" && isset($user['id'])){
		header('location:/main');
	}
}

function endi ($count, $msg = array ())
{
	$count = (int) $count;
	$max = $count % 100;
	$min = $count % 10;

	if ($max > 10 && $max < 20) {
		return $count . ' ' . $msg[2];
	}

	if ($min > 1  && $min < 5 ) {
		return $count . ' ' . $msg[1];
	}

	if ($min == 1) {
		return $count . ' ' . $msg[0];
	}

	return $count . ' ' . $msg[2];
}

function datef ($time)
{
	$t = time ();
	if (($t - $time) <= 60) {
		$out .= endi ((time () - $time), array (
												'секунду',
												'секунды',
												'секунд'
												));
		$out .= ' назад';

	}elseif (($t - $time) <= 3600) {
		$out .= endi ((($t - $time)/60), array (
												'минуту',
												'минуты',
												'минут'
												));
		$out .= ' назад';

	}else{
		$timesp = date("j M Y  в H:i", $time);
		$timesp = str_replace (date ("j M Y", $t), 'Сегодня', $timesp);
		$timesp = str_replace (date ("j M Y", strtotime ("-1 day")), 'Вчера', $timesp);
		$timesp = strtr ($timesp, array (
										'Jan' => 'Января',
										'Feb' => 'Февраля',
										'Mar' => 'Марта',
										'May' => 'Мая',
										'Apr' => 'Апреля',
										'Jun' => 'Июня',
										'Jul' => 'Июля',
										'Aug' => 'Августа',
										'Sep' => 'Сентября',
										'Oct' => 'Октября',
										'Nov' => 'Ноября',
										'Dec' => 'Декабря'
										));

		$out .= $timesp;
	}
	return $out;
}

function outputNameProduct($id, $mode = 0){
	global $db;
	$query = $db->query("SELECT * FROM `products` WHERE `id`='".$id."'");
	if($query->num_rows != 0){
		$product = $query->fetch_assoc();
	}else{
		$product['name'] = 'Товар удалён';
	}

	if($mode != 0){
		echo '<a href="/product/'.$id.'/">'.output($product['name']).'</a>';
	}else{
		echo output($product['name']);
	}
}

function outputRateReview($id, $mode = 0){
	global $db;
	$query = $db->query("SELECT * FROM `products_reviews` WHERE `id`='".$id."'");
	if($query->num_rows != 0){
		$review = $query->fetch_assoc();
		if($mode == 0){
			if($review['rating'] == 1){
				echo '1 звезду';
			}elseif($review['rating'] == 5){
				echo '5 звёзд';
			}else{
				echo $review['rating'].' звёзды';
			}
		}
	}else{
		return ;
	}
}

function statusOrder($id){
	global $db;
	$order = $db->query("SELECT * FROM `purchased` WHERE `id`='".$id."'")->fetch_assoc();
	if($order['delivery'] != 0){
		if($order['status'] == 0){
			echo '<span class="label label-danger">Готовится к отправлению на складе</span>';
		}elseif($order['status'] == 1){
			echo '<span class="label label-warning">Отправлен</span>';
		}elseif($order['status'] == 2){
			echo '<span class="label label-success">Доставлен</span>';
		}
	}else{
		if($order['status'] == 0){
			echo '<span class="label label-warning">Ожидает</span>';
		}else{
			echo '<span class="label label-success">Отдан</span>';
		}
	}
}

function outNick($id){
	global $db;
	$u = $db->query("SELECT * FROM `users` WHERE `id`='".$id."'")->fetch_assoc();
	return $u['name'].' '.$u['surname'];
}

?>