<?php
include_once($_SERVER["DOCUMENT_ROOT"].'/php/system/includes_system.php');
?>
<!DOCTYPE html>
<html lang="ru">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <meta name="description" content="">
    <meta name="author" content="koiie">
    <link rel="icon" href="../../favicon.ico">

    <title>Магазин "Успех"</title>

    <!-- Bootstrap core CSS -->
    <link href="/css/bootstrap.min.css" rel="stylesheet">

    <!-- IE10 viewport hack for Surface/desktop Windows 8 bug -->
    <link href="/css/ie10-viewport-bug-workaround.css" rel="stylesheet">

    <!-- Just for debugging purposes. Don't actually copy these 2 lines! -->
    <!--[if lt IE 9]><script src="../../assets/js/ie8-responsive-file-warning.js"></script><![endif]-->
    <script src="/js/ie-emulation-modes-warning.js"></script>

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
      <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->

    <!-- Custom styles for this template -->
    <link href="/css/carousel.css" rel="stylesheet">
  </head>
<!-- NAVBAR
================================================== -->
  <body>
    <div class="navbar-wrapper">
      <div class="container">

        <nav class="navbar navbar-inverse navbar-static-top">
          <div class="container">
            <div class="navbar-header">
              <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
                <span class="sr-only">Toggle navigation</span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
              </button>
              <a class="navbar-brand" href="/">Успех</a>
            </div>
            <div id="navbar" class="navbar-collapse collapse">
              <ul class="nav navbar-nav">
                <li class="active"><a href="/">Главная</a></li>
                <li><a href="/categories">Разделы</a></li>
                <?if(isUser()){?>
              <li class="dropdown">
                <a href="" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">Аккаунт<span class="caret"></span></a>
                <ul class="dropdown-menu">
                  <li><a href="/user/<?=$user['id']?>">Мой профиль</a></li>
                  <li><a href="/cart">Корзина</a></li>
                  <li><a href="/order/see">Мои заказы</a></li>
                  <li><a href="#">Баланс <?=$user['money']?> руб.</a></li>
                  <?if($user['admin'] >= 3){?>
                    <li role="separator" class="divider"></li>
                    <li class="dropdown-header">Админ-панель</li>
                    <li><a href="/admin/orders">Заказы</a></li>
                    <li><li><a href="/admin/main_edit">Главная</a></li>
                  <?}?>
                </ul>
              </li>
            <?}?>
              </ul>
             <ul class="nav navbar-nav navbar-right">
                <?php
                if(isUser()){
                  $cart_count = $db->query("SELECT * FROM `cart` WHERE `id_user`='".$user['id']."'")->num_rows;
                  ?>
                  <li><a href="/cart">Корзина <? if($cart_count!=0){?><span class="badge"><?=$cart_count?></span><?}?></a></li>
                  <li><a href="#exitModal" data-toggle="modal">Выйти</a></li>
                  <?
                }else{?>
                  <li><a href="/auth">Вход</a></li>
                  <li><a href="/reg">Регистрация</a></li>
                <?php }?>
              </ul>
              <form class="navbar-form navbar-right" role="search" action="/search" method="POST">
                <div class="form-group">
                  <input type="text" class="form-control" placeholder="Поиск по сайту" name="text">
                </div>
                <button type="submit" class="btn btn-default">Искать</button>
              </form>
            </div>
          </div>
        </nav>

      </div>
    </div>


    <!-- Carousel
    ================================================== -->
    <div id="myCarousel" class="carousel slide" data-ride="carousel">
      <!-- Indicators -->
      <ol class="carousel-indicators">
        <li data-target="#myCarousel" data-slide-to="0" class="active"></li>
        <li data-target="#myCarousel" data-slide-to="1"></li>
        <li data-target="#myCarousel" data-slide-to="2"></li>
      </ol>
      <div class="carousel-inner" role="listbox">
        <?
        $query = $db->query("SELECT * FROM `carousel`");
        while($slide = $query->fetch_assoc()){
          ?>
          <div class="item <?if($slide['id']==1){?>active<?}?>">
          <img class="first-slide" src="/files/images/slides/<?=$slide['image']?>" alt="Slide">
          <div class="container">
            <div class="carousel-caption">
              <h1><?=output($slide['header'])?></h1>
              <p><?=output($slide['text'])?></p>
              <p><a class="btn btn-lg btn-primary" href="<?=output($slide['link'])?>" role="button"><?=output($slide['name_link'])?></a></p>
            </div>
          </div>
        </div>
          <?
        }?>
      </div>
      <a class="left carousel-control" href="#myCarousel" role="button" data-slide="prev">
        <span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
        <span class="sr-only">Назад</span>
      </a>
      <a class="right carousel-control" href="#myCarousel" role="button" data-slide="next">
        <span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
        <span class="sr-only">Вперед</span>
      </a>
    </div><!-- /.carousel -->


    <!-- Marketing messaging and featurettes
    ================================================== -->
    <!-- Wrap the rest of the page in another container to center all the content. -->

    <div class="container marketing">

      <!-- Three columns of text below the carousel -->
      <div class="row">
        <?
        $query = $db->query("SELECT * FROM `products` ORDER BY `id` DESC LIMIT 3");
        while($product = $query->fetch_assoc()){
          $image = $db->query("SELECT * FROM `products_images` WHERE `id_product`=".$product['id']." ORDER BY `id` DESC LIMIT 1")->fetch_assoc();
          ?>
           <div class="col-lg-4">
            <img class="img-circle" src="/files/images/products/<?=$image['image']?>" alt="Generic placeholder image" width="140" height="140">
            <h2><?=output($product['name'])?></h2>
            <p><?=mb_strimwidth(output($product['description']), 0, 299)?>...</p>
            <p><a class="btn btn-default" href="/product/<?=$product['id']?>" role="button">Подробнее &raquo;</a></p>
          </div>
          <?
        }?>
      </div><!-- /.row -->

      <!-- FOOTER -->
      <footer>
        <p class="pull-right"><a href="#">Наверх</a></p>
        <p>&copy; 2019 Alexander Kaplin &middot; <a href="https://vk.com/k011e">VK</a></p>
      </footer>

    </div><!-- /.container -->


    <!-- Bootstrap core JavaScript
    ================================================== -->
    <!-- Placed at the end of the document so the pages load faster -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
    <script>window.jQuery || document.write('<script src="./js/vendor/jquery.min.js"><\/script>')</script>
    <script src="/js/bootstrap.min.js"></script>
    <!-- Just to make our placeholder images work. Don't actually copy the next line! -->
    <script src="/js/vendor/holder.min.js"></script>
    <!-- IE10 viewport hack for Surface/desktop Windows 8 bug -->
    <script src="/js/ie10-viewport-bug-workaround.js"></script>
  </body>
</html>
