/*
 * Decompiled with CFR 0.152.
 */
package com.droidninja.imageeditengine.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.RequiresApi;
import com.droidninja.imageeditengine.R;

public class VerticalSlideColorPicker
extends View {
    private int defaultColor;
    private Paint paint;
    private Paint strokePaint;
    private Path path;
    private Bitmap bitmap;
    private int viewWidth;
    private int viewHeight;
    private int centerX;
    private float colorPickerRadius;
    private OnColorChangeListener onColorChangeListener;
    private RectF colorPickerBody;
    private float selectorYPos;
    private int borderColor;
    private float borderWidth;
    private int[] colors;
    private boolean cacheBitmap = true;

    public VerticalSlideColorPicker(Context context) {
        super(context);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VerticalSlideColorPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.VerticalSlideColorPicker, 0, 0);
        try {
            this.borderColor = a.getColor(R.styleable.VerticalSlideColorPicker_borderColor, -1);
            this.defaultColor = a.getColor(R.styleable.VerticalSlideColorPicker_defaultColor, 0);
            this.borderWidth = a.getDimension(R.styleable.VerticalSlideColorPicker_borderWidth, 5.0f);
            int colorsResourceId = a.getResourceId(R.styleable.VerticalSlideColorPicker_colors, R.array.default_colors);
            this.colors = a.getResources().getIntArray(colorsResourceId);
        }
        finally {
            a.recycle();
        }
        this.init();
    }

    public VerticalSlideColorPicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @RequiresApi(api=21)
    public VerticalSlideColorPicker(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.setWillNotDraw(false);
        this.paint = new Paint();
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setAntiAlias(true);
        this.path = new Path();
        this.strokePaint = new Paint();
        this.strokePaint.setStyle(Paint.Style.STROKE);
        this.strokePaint.setColor(this.borderColor);
        this.strokePaint.setAntiAlias(true);
        this.strokePaint.setStrokeWidth(this.borderWidth);
        this.setDrawingCacheEnabled(true);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.path.addCircle((float)this.centerX, this.borderWidth + this.colorPickerRadius, this.colorPickerRadius, Path.Direction.CW);
        this.path.addRect(this.colorPickerBody, Path.Direction.CW);
        this.path.addCircle((float)this.centerX, (float)this.viewHeight - (this.borderWidth + this.colorPickerRadius), this.colorPickerRadius, Path.Direction.CW);
        canvas.drawPath(this.path, this.strokePaint);
        canvas.drawPath(this.path, this.paint);
        if (this.cacheBitmap) {
            this.bitmap = this.getDrawingCache();
            this.cacheBitmap = false;
            this.invalidate();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        float yPos = Math.min(event.getY(), this.colorPickerBody.bottom);
        this.selectorYPos = yPos = Math.max(this.colorPickerBody.top, yPos);
        this.defaultColor = this.bitmap.getPixel(this.viewWidth / 2, (int)this.selectorYPos);
        if (this.onColorChangeListener != null) {
            this.onColorChangeListener.onColorChange(this.defaultColor);
        }
        return true;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.viewWidth = w;
        this.viewHeight = h;
        this.centerX = this.viewWidth / 2;
        this.colorPickerRadius = (float)(this.viewWidth / 2) - this.borderWidth;
        this.colorPickerBody = new RectF((float)this.centerX - this.colorPickerRadius, this.borderWidth + this.colorPickerRadius, (float)this.centerX + this.colorPickerRadius, (float)this.viewHeight - (this.borderWidth + this.colorPickerRadius));
        LinearGradient gradient = new LinearGradient(0.0f, this.colorPickerBody.top, 0.0f, this.colorPickerBody.bottom, this.colors, null, Shader.TileMode.CLAMP);
        this.paint.setShader((Shader)gradient);
        this.resetToDefault();
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        this.invalidate();
    }

    public void setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
        this.invalidate();
    }

    public void setColors(int[] colors) {
        this.colors = colors;
        this.cacheBitmap = true;
        this.invalidate();
    }

    public void resetToDefault() {
        this.selectorYPos = this.borderWidth + this.colorPickerRadius;
        if (this.onColorChangeListener != null) {
            this.onColorChangeListener.onColorChange(this.defaultColor);
        }
        this.invalidate();
    }

    public void setOnColorChangeListener(OnColorChangeListener onColorChangeListener) {
        this.onColorChangeListener = onColorChangeListener;
        if (onColorChangeListener != null) {
            onColorChangeListener.onColorChange(this.defaultColor);
        }
    }

    public int getDefaultColor() {
        return this.defaultColor;
    }

    public static interface OnColorChangeListener {
        public void onColorChange(int var1);
    }
}

